/****************************************************************************
 *
 * Copyright (c) 2005 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#include <config.h>
#include <xpl.h>
#include <hulautil.h>

#define ICAL2_C

#include <libical2.h>

const unsigned char ICal2CharDefinitions[] = {
    /* Hex  Dec Desc    Flags */
    /* 0x00 000 Null */ 0, 
    /* 0x01 001 SOH  */ 0, 
    /* 0x02 002 STX  */ 0, 
    /* 0x03 003 ETX  */ 0, 
    /* 0x04 004 EOT  */ 0, 
    /* 0x05 005 ENQ  */ 0, 
    /* 0x06 006 ACK  */ 0, 
    /* 0x07 007 BEL  */ 0, 
    /* 0x08 008 BS   */ 0, 
    /* 0x09 009 HT   */ ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x0A 010 LF   */ 0, 
    /* 0x0B 011 VT   */ 0, 
    /* 0x0C 012 FF   */ 0, 
    /* 0x0D 013 CR   */ 0, 
    /* 0x0E 014 SO   */ 0, 
    /* 0x0F 015 SI   */ 0, 
    /* 0x10 016 DLE  */ 0, 
    /* 0x11 017 DC1  */ 0, 
    /* 0x12 018 DC2  */ 0, 
    /* 0x13 019 DC3  */ 0, 
    /* 0x14 020 DC4  */ 0, 
    /* 0x15 021 NAK  */ 0, 
    /* 0x16 022 SYN  */ 0, 
    /* 0x17 023 ETB  */ 0, 
    /* 0x18 024 CAN  */ 0, 
    /* 0x19 025 EM   */ 0, 
    /* 0x1A 026 EOF  */ 0, 
    /* 0x1B 027 ESC  */ 0, 
    /* 0x1C 028 FS   */ 0, 
    /* 0x1D 029 GS   */ 0, 
    /* 0x1E 030 HOM  */ 0, 
    /* 0x1F 031 NEW  */ 0, 
    /* 0x20 032 SPA  */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x21 033 !    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x22 034 "    */ ICAL2_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x23 035 #    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x24 036 $    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x25 037 %    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x26 038 &    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x27 039 '    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x28 040 (    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x29 041 )    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x2A 042 *    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x2B 043 +    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x2C 044 ,    */ ICAL2_PROPERTY_DELIMITER | ICAL2_VALUE_CHAR, 
    /* 0x2D 045 -    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x2E 046 .    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x2F 047 /    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x30 048 0    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x31 049 1    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x32 050 2    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x33 051 3    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x34 052 4    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x35 053 5    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x36 054 6    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x37 055 7    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x38 056 8    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x39 057 9    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x3A 058 :    */ ICAL2_TEXT_CHAR | ICAL2_PROPERTY_DELIMITER | ICAL2_VALUE_CHAR, 
    /* 0x3B 059 ;    */ ICAL2_PROPERTY_DELIMITER | ICAL2_VALUE_CHAR, 
    /* 0x3C 060 <    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x3D 061 =    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x3E 062 >    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x3F 063 ?    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x40 064 @    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x41 065 A    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x42 066 B    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x43 067 C    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x44 068 D    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x45 069 E    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x46 070 F    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x47 071 G    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x48 072 H    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x49 073 I    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x4A 074 J    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x4B 075 K    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x4C 076 L    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x4D 077 M    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x4E 078 N    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x4F 079 O    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x50 080 P    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x51 081 Q    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x52 082 R    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x53 083 S    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x54 084 T    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x55 085 U    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x56 086 V    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x57 087 W    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x58 088 X    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x59 089 Y    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x5A 090 Z    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x5B 091 [    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x5C 092 \    */ ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x5D 093 ]    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x5E 094 ^    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x5F 095 _    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x60 096 `    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x61 097 a    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x62 098 b    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x63 099 c    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x64 100 d    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x65 101 e    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x66 102 f    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x67 103 g    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x68 104 h    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x69 105 i    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x6A 106 j    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x6B 107 k    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x6C 108 l    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x6D 109 m    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x6E 110 n    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x6F 111 o    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x70 112 p    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x71 113 q    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x72 114 r    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x73 115 s    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x74 116 t    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x75 117 u    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x76 118 v    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x77 119 w    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x78 120 x    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x79 121 y    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x7A 122 z    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_X_NAME_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x7B 123 {    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x7C 124 |    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x7D 125 }    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x7E 126 ~    */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x7F 127 DEL  */ 0, 
    /* 0x80 128      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x81 129      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x82 130      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x83 131      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x84 132      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x85 133      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x86 134      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x87 135      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x88 136      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x89 137      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x8A 138      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x8B 139      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x8C 140      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x8D 141      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x8E 142      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x8F 143      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x90 144      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x91 145      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x92 146      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x93 147      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x94 148      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x95 149      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x96 150      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x97 151      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x98 152      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x99 153      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x9A 154      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x9B 155      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x9C 156      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x9D 157      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x9E 158      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0x9F 159      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xA0 160      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xA1 161      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xA2 162      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xA3 163      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xA4 164      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xA5 165      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xA6 166      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xA7 167      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xA8 168      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xA9 169      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xAA 170      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xAB 171      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xAC 172      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xAD 173      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xAE 174      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xAF 175      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xB0 176      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xB1 177      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xB2 178      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xB3 179      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xB4 180      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xB5 181      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xB6 182      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xB7 183      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xB8 184      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xB9 185      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xBA 186      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xBB 187      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xBC 188      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xBD 189      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xBE 190      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xBF 191      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xC0 192      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xC1 193      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xC2 194      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xC3 195      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xC4 196      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xC5 197      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xC6 198      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xC7 199      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xC8 200      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xC9 201      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xCA 202      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xCB 203      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xCC 204      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xCD 205      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xCE 206      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xCF 207      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xD0 208      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xD1 209      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xD2 210      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xD3 211      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xD4 212      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xD5 213      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xD6 214      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xD7 215      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xD8 216      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xD9 217      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xDA 218      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xDB 219      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xDC 220      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xDD 221      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xDE 222      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xDF 223      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xE0 224      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xE1 225      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xE2 226      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xE3 227      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xE4 228      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xE5 229      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xE6 230      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xE7 231      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xE8 232      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xE9 233      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xEA 234      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xEB 235      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xEC 236      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xED 237      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xEE 238      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xEF 239      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xF0 240      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xF1 241      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xF2 242      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xF3 243      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xF4 244      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xF5 245      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xF6 246      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xF7 247      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xF8 248      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xF9 249      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xFA 250      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xFB 251      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xFC 252      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xFD 253      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xFE 254      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR, 
    /* 0xFF 255      */ ICAL2_TEXT_CHAR | ICAL2_PARAM_TEXT_CHAR | ICAL2_VALUE_CHAR
};

/*
    This array should be ordered in conjunction
    with the ICal2ParameterTypes enumeration defined in libical2.h
*/
const unsigned char *ICal2ParameterKeywords[] = {
    ICAL2_KEYWORD_ALTREP, 
    ICAL2_KEYWORD_CN, 
    ICAL2_KEYWORD_CUTYPE, 
    ICAL2_KEYWORD_DELEGATED_FROM, 
    ICAL2_KEYWORD_DELEGATED_TO, 
    ICAL2_KEYWORD_DIR, 
    ICAL2_KEYWORD_ENCODING, 
    ICAL2_KEYWORD_FMTTYPE, 
    ICAL2_KEYWORD_FBTYPE, 
    ICAL2_KEYWORD_LANGUAGE, 
    ICAL2_KEYWORD_MEMBER, 
    ICAL2_KEYWORD_PARTSTAT, 
    ICAL2_KEYWORD_RANGE, 
    ICAL2_KEYWORD_RELATED, 
    ICAL2_KEYWORD_RELTYPE, 
    ICAL2_KEYWORD_ROLE, 
    ICAL2_KEYWORD_RSVP, 
    ICAL2_KEYWORD_SENT_BY, 
    ICAL2_KEYWORD_TZID, 
    ICAL2_KEYWORD_VALUE, 
    ICAL2_KEYWORD_X, 
    ICAL2_KEYWORD_IANA
};

/*
    This array should be ordered in conjunction
    with the ICal2ValueTypes enumeration defined in libical2.h
*/
const unsigned char *ICal2ValueKeywords[] = {
    "NONE", 
    "BINARY", 
    "BOOLEAN", 
    "CAL-ADDRESS", 
    "DATE", 
    "DATE-TIME", 
    "DURATION", 
    "FLOAT", 
    "INTEGER", 
    "PERIOD", 
    "RECUR", 
    "REQUEST-STATUS", 
    "STATUS", 
    "TEXT", 
    "TIME", 
    "URI", 
    "UTC-OFFSET", 
    "X", 
    "IANA"
};

HulaKeywordIndex *ICal2ParameterIndex = NULL;
HulaKeywordIndex *ICal2RecurIndex = NULL;
HulaKeywordIndex *ICal2PropertyIndex = NULL;
HulaKeywordIndex *ICal2ComponentIndex = NULL;

ICal2Token ICal2ParameterTokens[] = {
    { ICAL2_KEYWORD_ALTREP, sizeof(ICAL2_KEYWORD_ALTREP) - 1, ICAL2_PARAMETER_ALTREP, NULL, ICal2AltRepParameterParser }, 
    { ICAL2_KEYWORD_CN, sizeof(ICAL2_KEYWORD_CN) - 1, ICAL2_PARAMETER_CN, NULL, ICal2CnParameterParser }, 
    { ICAL2_KEYWORD_CUTYPE, sizeof(ICAL2_KEYWORD_CUTYPE) - 1, ICAL2_PARAMETER_CUTYPE, NULL, ICal2CuTypeParameterParser }, 
    { ICAL2_KEYWORD_DELEGATED_FROM, sizeof(ICAL2_KEYWORD_DELEGATED_FROM) - 1, ICAL2_PARAMETER_DELEGATED_FROM, NULL, ICal2DelegatedFromParameterParser }, 
    { ICAL2_KEYWORD_DELEGATED_TO, sizeof(ICAL2_KEYWORD_DELEGATED_TO) - 1, ICAL2_PARAMETER_DELEGATED_TO, NULL, ICal2DelegatedToParameterParser }, 
    { ICAL2_KEYWORD_DIR, sizeof(ICAL2_KEYWORD_DIR) - 1, ICAL2_PARAMETER_DIR, NULL, ICal2DirParameterParser }, 
    { ICAL2_KEYWORD_ENCODING, sizeof(ICAL2_KEYWORD_ENCODING) - 1, ICAL2_PARAMETER_ENCODING, NULL, ICal2EncodingParameterParser }, 
    { ICAL2_KEYWORD_FMTTYPE, sizeof(ICAL2_KEYWORD_FMTTYPE) - 1, ICAL2_PARAMETER_FMTTYPE, NULL, ICal2FmtTypeParameterParser }, 
    { ICAL2_KEYWORD_FBTYPE, sizeof(ICAL2_KEYWORD_FBTYPE) - 1, ICAL2_PARAMETER_FBTYPE, NULL, ICal2FbTypeParameterParser }, 
    { ICAL2_KEYWORD_LANGUAGE, sizeof(ICAL2_KEYWORD_LANGUAGE) - 1, ICAL2_PARAMETER_LANGUAGE, NULL, ICal2LanguageParameterParser }, 
    { ICAL2_KEYWORD_MEMBER, sizeof(ICAL2_KEYWORD_MEMBER) - 1, ICAL2_PARAMETER_MEMBER, NULL, ICal2MemberParameterParser }, 
    { ICAL2_KEYWORD_PARTSTAT, sizeof(ICAL2_KEYWORD_PARTSTAT) - 1, ICAL2_PARAMETER_PARTSTAT, NULL, ICal2PartStatParameterParser }, 
    { ICAL2_KEYWORD_RANGE, sizeof(ICAL2_KEYWORD_RANGE) - 1, ICAL2_PARAMETER_RANGE, NULL, ICal2RangeParameterParser }, 
    { ICAL2_KEYWORD_RELATED, sizeof(ICAL2_KEYWORD_RELATED) - 1, ICAL2_PARAMETER_RELATED, NULL, ICal2RelatedParameterParser }, 
    { ICAL2_KEYWORD_RELTYPE, sizeof(ICAL2_KEYWORD_RELTYPE) - 1, ICAL2_PARAMETER_RELTYPE, NULL, ICal2RelTypeParameterParser }, 
    { ICAL2_KEYWORD_ROLE, sizeof(ICAL2_KEYWORD_ROLE) - 1, ICAL2_PARAMETER_ROLE, NULL, ICal2RoleParameterParser }, 
    { ICAL2_KEYWORD_RSVP, sizeof(ICAL2_KEYWORD_RSVP) - 1, ICAL2_PARAMETER_RSVP, NULL, ICal2RsvpParameterParser }, 
    { ICAL2_KEYWORD_SENT_BY, sizeof(ICAL2_KEYWORD_SENT_BY) - 1, ICAL2_PARAMETER_SENT_BY, NULL, ICal2SentByParameterParser }, 
    { ICAL2_KEYWORD_TZID, sizeof(ICAL2_KEYWORD_TZID) - 1, ICAL2_PARAMETER_TZID, NULL, ICal2TzIDParameterParser }, 
    { ICAL2_KEYWORD_VALUE, sizeof(ICAL2_KEYWORD_VALUE) - 1, ICAL2_PARAMETER_VALUE, NULL, ICal2ValueParameterParser }, 
    { ICAL2_KEYWORD_X, sizeof(ICAL2_KEYWORD_X) - 1, ICAL2_PARAMETER_X, NULL, ICal2XParameterParser }, 
    { NULL, 0, 0, NULL, NULL }
};

ICal2Token ICal2PropertyTokens[] = {
    { ICAL2_KEYWORD_BEGIN, sizeof(ICAL2_KEYWORD_BEGIN) - 1, ICAL2_PROPERTY_BEGIN, ICal2BeginPropertyParser, NULL }, 
    { ICAL2_KEYWORD_END, sizeof(ICAL2_KEYWORD_END) - 1, ICAL2_PROPERTY_END, ICal2EndPropertyParser, NULL }, 
    { ICAL2_KEYWORD_CALSCALE, sizeof(ICAL2_KEYWORD_CALSCALE) - 1, ICAL2_PROPERTY_CALSCALE, ICal2PropertyParser, ICal2TextValueParser }, 
    { ICAL2_KEYWORD_METHOD, sizeof(ICAL2_KEYWORD_METHOD) - 1, ICAL2_PROPERTY_METHOD, ICal2PropertyParser, ICal2TextValueParser }, 
    { ICAL2_KEYWORD_PRODID, sizeof(ICAL2_KEYWORD_PRODID) - 1, ICAL2_PROPERTY_PRODID, ICal2PropertyParser, ICal2TextValueParser }, 
    { ICAL2_KEYWORD_VERSION, sizeof(ICAL2_KEYWORD_VERSION) - 1, ICAL2_PROPERTY_VERSION, ICal2PropertyParser, ICal2TextValueParser }, 
    { ICAL2_KEYWORD_ATTACH, sizeof(ICAL2_KEYWORD_ATTACH) - 1, ICAL2_PROPERTY_ATTACH, ICal2PropertyParser , ICal2AttachValueParser }, 
    { ICAL2_KEYWORD_CATEGORIES, sizeof(ICAL2_KEYWORD_CATEGORIES) - 1, ICAL2_PROPERTY_CATEGORIES, ICal2PropertyParser, ICal2TextValueParser }, 
    { ICAL2_KEYWORD_CLASS, sizeof(ICAL2_KEYWORD_CLASS) - 1, ICAL2_PROPERTY_CLASS, ICal2PropertyParser, ICal2TextValueParser }, 
    { ICAL2_KEYWORD_COMMENT, sizeof(ICAL2_KEYWORD_COMMENT) - 1, ICAL2_PROPERTY_COMMENT, ICal2PropertyParser, ICal2TextValueParser }, 
    { ICAL2_KEYWORD_DESCRIPTION, sizeof(ICAL2_KEYWORD_DESCRIPTION) - 1, ICAL2_PROPERTY_DESCRIPTION, ICal2PropertyParser, ICal2TextValueParser }, 
    { ICAL2_KEYWORD_GEO, sizeof(ICAL2_KEYWORD_GEO) - 1, ICAL2_PROPERTY_GEO, ICal2PropertyParser, ICal2GeoValueParser }, 
    { ICAL2_KEYWORD_LOCATION, sizeof(ICAL2_KEYWORD_LOCATION) - 1, ICAL2_PROPERTY_LOCATION, ICal2PropertyParser, ICal2TextValueParser }, 
    { ICAL2_KEYWORD_PERCENT_COMPLETE, sizeof(ICAL2_KEYWORD_PERCENT_COMPLETE) - 1, ICAL2_PROPERTY_PERCENT_COMPLETE, ICal2PropertyParser, ICal2IntegerValueParser }, 
    { ICAL2_KEYWORD_PRIORITY, sizeof(ICAL2_KEYWORD_PRIORITY) - 1, ICAL2_PROPERTY_PRIORITY, ICal2PropertyParser, ICal2IntegerValueParser }, 
    { ICAL2_KEYWORD_RESOURCES, sizeof(ICAL2_KEYWORD_RESOURCES) - 1, ICAL2_PROPERTY_RESOURCES, ICal2PropertyParser, ICal2TextValueParser }, 
    { ICAL2_KEYWORD_STATUS, sizeof(ICAL2_KEYWORD_STATUS) - 1, ICAL2_PROPERTY_STATUS, ICal2PropertyParser, ICal2StatusValueParser }, 
    { ICAL2_KEYWORD_SUMMARY, sizeof(ICAL2_KEYWORD_SUMMARY) - 1, ICAL2_PROPERTY_SUMMARY, ICal2PropertyParser, ICal2TextValueParser }, 
    { ICAL2_KEYWORD_COMPLETED, sizeof(ICAL2_KEYWORD_COMPLETED) - 1, ICAL2_PROPERTY_COMPLETED, ICal2PropertyParser, ICal2DateTimeValueParser }, 
    { ICAL2_KEYWORD_DTEND, sizeof(ICAL2_KEYWORD_DTEND) - 1, ICAL2_PROPERTY_DTEND, ICal2PropertyParser, ICal2DateDateTimeValueParser }, 
    { ICAL2_KEYWORD_DUE, sizeof(ICAL2_KEYWORD_DUE) - 1, ICAL2_PROPERTY_DUE, ICal2PropertyParser, ICal2DateDateTimeValueParser }, 
    { ICAL2_KEYWORD_DTSTART, sizeof(ICAL2_KEYWORD_DTSTART) - 1, ICAL2_PROPERTY_DTSTART, ICal2PropertyParser, ICal2DateDateTimeValueParser }, 
    { ICAL2_KEYWORD_DURATION, sizeof(ICAL2_KEYWORD_DURATION) - 1, ICAL2_PROPERTY_DURATION, ICal2PropertyParser, ICal2DurationValueParser }, 
    { ICAL2_KEYWORD_FREEBUSY, sizeof(ICAL2_KEYWORD_FREEBUSY) - 1, ICAL2_PROPERTY_FREEBUSY, ICal2PropertyParser, ICal2PeriodValueParser }, 
    { ICAL2_KEYWORD_TRANSP, sizeof(ICAL2_KEYWORD_TRANSP) - 1, ICAL2_PROPERTY_TRANSP, ICal2PropertyParser, ICal2TextValueParser }, 
    { ICAL2_KEYWORD_TZID, sizeof(ICAL2_KEYWORD_TZID) - 1, ICAL2_PROPERTY_TZID, ICal2PropertyParser, ICal2TextValueParser }, 
    { ICAL2_KEYWORD_TZNAME, sizeof(ICAL2_KEYWORD_TZNAME) - 1, ICAL2_PROPERTY_TZNAME, ICal2PropertyParser, ICal2TextValueParser }, 
    { ICAL2_KEYWORD_TZOFFSETFROM, sizeof(ICAL2_KEYWORD_TZOFFSETFROM) - 1, ICAL2_PROPERTY_TZOFFSETFROM, ICal2PropertyParser, ICal2UtcOffsetValueParser }, 
    { ICAL2_KEYWORD_TZOFFSETTO, sizeof(ICAL2_KEYWORD_TZOFFSETTO) - 1, ICAL2_PROPERTY_TZOFFSETTO, ICal2PropertyParser, ICal2UtcOffsetValueParser }, 
    { ICAL2_KEYWORD_TZURL, sizeof(ICAL2_KEYWORD_TZURL) - 1, ICAL2_PROPERTY_TZURL, ICal2PropertyParser, ICal2UriValueParser }, 
    { ICAL2_KEYWORD_ATTENDEE, sizeof(ICAL2_KEYWORD_ATTENDEE) - 1, ICAL2_PROPERTY_ATTENDEE, ICal2PropertyParser, ICal2CalAddressValueParser }, 
    { ICAL2_KEYWORD_CONTACT, sizeof(ICAL2_KEYWORD_CONTACT) - 1, ICAL2_PROPERTY_CONTACT, ICal2PropertyParser, ICal2TextValueParser }, 
    { ICAL2_KEYWORD_ORGANIZER, sizeof(ICAL2_KEYWORD_ORGANIZER) - 1, ICAL2_PROPERTY_ORGANIZER, ICal2PropertyParser, ICal2CalAddressValueParser }, 
    { ICAL2_KEYWORD_RECURRENCE_ID, sizeof(ICAL2_KEYWORD_RECURRENCE_ID) - 1, ICAL2_PROPERTY_RECURRENCE_ID, ICal2PropertyParser, ICal2DateDateTimeValueParser }, 
    { ICAL2_KEYWORD_RELATED_TO, sizeof(ICAL2_KEYWORD_RELATED_TO) - 1, ICAL2_PROPERTY_RELATED_TO, ICal2PropertyParser, ICal2TextValueParser }, 
    { ICAL2_KEYWORD_URL, sizeof(ICAL2_KEYWORD_URL) - 1, ICAL2_PROPERTY_URL, ICal2PropertyParser, ICal2UriValueParser }, 
    { ICAL2_KEYWORD_UID, sizeof(ICAL2_KEYWORD_UID) - 1, ICAL2_PROPERTY_UID, ICal2PropertyParser, ICal2TextValueParser }, 
    { ICAL2_KEYWORD_EXDATE, sizeof(ICAL2_KEYWORD_EXDATE) - 1, ICAL2_PROPERTY_EXDATE, ICal2PropertyParser, ICal2DateDateTimeValueParser }, 
    { ICAL2_KEYWORD_EXRULE, sizeof(ICAL2_KEYWORD_EXRULE) - 1, ICAL2_PROPERTY_EXRULE, ICal2PropertyParser, ICal2RecurValueParser }, 
    { ICAL2_KEYWORD_RDATE, sizeof(ICAL2_KEYWORD_RDATE) - 1, ICAL2_PROPERTY_RDATE, ICal2PropertyParser, ICal2DateDateTimeValueParser }, 
    { ICAL2_KEYWORD_RRULE, sizeof(ICAL2_KEYWORD_RRULE) - 1, ICAL2_PROPERTY_RRULE, ICal2PropertyParser, ICal2RecurValueParser }, 
    { ICAL2_KEYWORD_ACTION, sizeof(ICAL2_KEYWORD_ACTION) - 1, ICAL2_PROPERTY_ACTION, ICal2PropertyParser, ICal2TextValueParser }, 
    { ICAL2_KEYWORD_REPEAT, sizeof(ICAL2_KEYWORD_REPEAT) - 1, ICAL2_PROPERTY_REPEAT, ICal2PropertyParser, ICal2IntegerValueParser }, 
    { ICAL2_KEYWORD_TRIGGER, sizeof(ICAL2_KEYWORD_TRIGGER) - 1, ICAL2_PROPERTY_TRIGGER, ICal2PropertyParser, ICal2TriggerValueParser }, 
    { ICAL2_KEYWORD_CREATED, sizeof(ICAL2_KEYWORD_CREATED) - 1, ICAL2_PROPERTY_CREATED, ICal2PropertyParser, ICal2DateTimeValueParser }, 
    { ICAL2_KEYWORD_DTSTAMP, sizeof(ICAL2_KEYWORD_DTSTAMP) - 1, ICAL2_PROPERTY_DTSTAMP, ICal2PropertyParser, ICal2DateTimeValueParser }, 
    { ICAL2_KEYWORD_LAST_MODIFIED, sizeof(ICAL2_KEYWORD_LAST_MODIFIED) - 1, ICAL2_PROPERTY_LAST_MODIFIED, ICal2PropertyParser, ICal2DateTimeValueParser }, 
    { ICAL2_KEYWORD_SEQUENCE, sizeof(ICAL2_KEYWORD_SEQUENCE) - 1, ICAL2_PROPERTY_SEQUENCE, ICal2PropertyParser, ICal2IntegerValueParser }, 
    { ICAL2_KEYWORD_X, sizeof(ICAL2_KEYWORD_X) - 1, ICAL2_PROPERTY_X, ICal2XPropertyParser, ICal2TextValueParser }, 
    { ICAL2_KEYWORD_REQUEST_STATUS, sizeof(ICAL2_KEYWORD_REQUEST_STATUS) - 1, ICAL2_PROPERTY_REQUEST_STATUS, ICal2PropertyParser, ICal2RequestStatusValueParser }, 
    { NULL, 0, 0, NULL, NULL }
};

ICal2Token ICal2RecurTokens[] = {
    { ICAL2_KEYWORD_RECUR_FREQ, sizeof(ICAL2_KEYWORD_RECUR_FREQ) - 1, ICAL2_RECUR_FREQ, NULL, ICal2RecurFreqParser }, 
    { ICAL2_KEYWORD_RECUR_UNTIL, sizeof(ICAL2_KEYWORD_RECUR_UNTIL) - 1, ICAL2_RECUR_UNTIL, NULL, ICal2RecurUntilParser }, 
    { ICAL2_KEYWORD_RECUR_COUNT, sizeof(ICAL2_KEYWORD_RECUR_COUNT) - 1, ICAL2_RECUR_COUNT, NULL, ICal2RecurCountParser }, 
    { ICAL2_KEYWORD_RECUR_INTERVAL, sizeof(ICAL2_KEYWORD_RECUR_INTERVAL) - 1, ICAL2_RECUR_INTERVAL, NULL, ICal2RecurIntervalParser }, 
    { ICAL2_KEYWORD_RECUR_BYSECOND, sizeof(ICAL2_KEYWORD_RECUR_BYSECOND) - 1, ICAL2_RECUR_BYSECOND, NULL, ICal2RecurBySecondParser }, 
    { ICAL2_KEYWORD_RECUR_BYMINUTE, sizeof(ICAL2_KEYWORD_RECUR_BYMINUTE) - 1, ICAL2_RECUR_BYMINUTE, NULL, ICal2RecurByMinuteParser }, 
    { ICAL2_KEYWORD_RECUR_BYHOUR, sizeof(ICAL2_KEYWORD_RECUR_BYHOUR) - 1, ICAL2_RECUR_BYHOUR, NULL, ICal2RecurByHourParser }, 
    { ICAL2_KEYWORD_RECUR_BYDAY, sizeof(ICAL2_KEYWORD_RECUR_BYDAY) - 1, ICAL2_RECUR_BYDAY, NULL, ICal2RecurByDayParser }, 
    { ICAL2_KEYWORD_RECUR_BYMONTHDAY, sizeof(ICAL2_KEYWORD_RECUR_BYMONTHDAY) - 1, ICAL2_RECUR_BYMONTHDAY, NULL, ICal2RecurByMonthDayParser }, 
    { ICAL2_KEYWORD_RECUR_BYYEARDAY, sizeof(ICAL2_KEYWORD_RECUR_BYYEARDAY) - 1, ICAL2_RECUR_BYYEARDAY, NULL, ICal2RecurByYearDayParser }, 
    { ICAL2_KEYWORD_RECUR_BYWEEKNO, sizeof(ICAL2_KEYWORD_RECUR_BYWEEKNO) - 1, ICAL2_RECUR_BYWEEKNO, NULL, ICal2RecurByWeekNoParser }, 
    { ICAL2_KEYWORD_RECUR_BYMONTH, sizeof(ICAL2_KEYWORD_RECUR_BYMONTH) - 1, ICAL2_RECUR_BYMONTH, NULL, ICal2RecurByMonthParser }, 
    { ICAL2_KEYWORD_RECUR_BYSETPOS, sizeof(ICAL2_KEYWORD_RECUR_BYSETPOS) - 1, ICAL2_RECUR_BYSETPOS, NULL, ICal2RecurBySetPosParser }, 
    { ICAL2_KEYWORD_RECUR_WKST, sizeof(ICAL2_KEYWORD_RECUR_WKST) - 1, ICAL2_RECUR_WKST, NULL, ICal2RecurWkstParser }, 
    { NULL, 0, 0, NULL, NULL }
};

ICal2Token ICal2ComponentTokens[] = {
    { ICAL2_KEYWORD_DAYLIGHT, sizeof(ICAL2_KEYWORD_DAYLIGHT) - 1, ICAL2_COMPONENT_DAYLIGHT, ICal2DaylightComponentParser, NULL }, 
    { ICAL2_KEYWORD_STANDARD, sizeof(ICAL2_KEYWORD_STANDARD) - 1, ICAL2_COMPONENT_STANDARD, ICal2StandardComponentParser, NULL }, 
    { ICAL2_KEYWORD_VALARM, sizeof(ICAL2_KEYWORD_VALARM) - 1, ICAL2_COMPONENT_VALARM, ICal2AlarmComponentParser, NULL }, 
    { ICAL2_KEYWORD_VEVENT, sizeof(ICAL2_KEYWORD_VEVENT) - 1, ICAL2_COMPONENT_VEVENT, ICal2EventComponentParser, NULL }, 
    { ICAL2_KEYWORD_VCALENDAR, sizeof(ICAL2_KEYWORD_VCALENDAR) - 1, ICAL2_COMPONENT_VCALENDAR, ICal2CalendarComponentParser, NULL }, 
    { ICAL2_KEYWORD_VJOURNAL, sizeof(ICAL2_KEYWORD_VJOURNAL) - 1, ICAL2_COMPONENT_VJOURNAL, ICal2JournalComponentParser, NULL }, 
    { ICAL2_KEYWORD_VFREEBUSY, sizeof(ICAL2_KEYWORD_VFREEBUSY) - 1, ICAL2_COMPONENT_VFREEBUSY, ICal2FreeBusyComponentParser, NULL }, 
    { ICAL2_KEYWORD_VTIMEZONE, sizeof(ICAL2_KEYWORD_VTIMEZONE) - 1, ICAL2_COMPONENT_VTIMEZONE, ICal2TimeZoneComponentParser, NULL }, 
    { ICAL2_KEYWORD_VTODO, sizeof(ICAL2_KEYWORD_VTODO) - 1, ICAL2_COMPONENT_VTODO, ICal2ToDoComponentParser, NULL }, 
    { ICAL2_KEYWORD_X, sizeof(ICAL2_KEYWORD_X) - 1, ICAL2_COMPONENT_X, ICal2XComponentParser, NULL }, 
    { NULL, 0, 0, NULL, NULL }
};

__inline static HulaKeywordIndex *
InitializeICal2Index(ICal2Token *list, BOOL tolerant)
{
    unsigned long i;
    unsigned long count;
    unsigned char **lines;
    HulaKeywordIndex *index = NULL;

    count = 0;

    while (list[count].name != NULL) {
        count++;
    }

    lines = MemMalloc(sizeof(unsigned char *) * (count + 1));
    if (lines) {
        for (i = 0; i < count; i++) {
            lines[i] = list[i].name;
        }

        lines[count] = NULL;

        index = HulaKeywordIndexCreate(lines, tolerant);

        MemFree(lines);
    }

    return(index);
}

EXPORT void 
CloseICal2Parser(void)
{

    if (ICal2ParameterIndex) {
        HulaKeywordIndexFree(ICal2ParameterIndex);
        ICal2ParameterIndex = NULL;
    }

    if (ICal2RecurIndex) {
        HulaKeywordIndexFree(ICal2RecurIndex);
        ICal2RecurIndex = NULL;
    }

    if (ICal2PropertyIndex) {
        HulaKeywordIndexFree(ICal2PropertyIndex);
        ICal2PropertyIndex = NULL;
    }

    if (ICal2ComponentIndex) {
        HulaKeywordIndexFree(ICal2ComponentIndex);
        ICal2ComponentIndex = NULL;
    }

    return;
}

EXPORT BOOL 
OpenICal2Parser(void)
{

    ICal2ParameterIndex = InitializeICal2Index(ICal2ParameterTokens, TRUE);
    ICal2RecurIndex = InitializeICal2Index(ICal2RecurTokens, TRUE);
    ICal2PropertyIndex = InitializeICal2Index(ICal2PropertyTokens, TRUE);
    ICal2ComponentIndex = InitializeICal2Index(ICal2ComponentTokens, TRUE);

    if (ICal2ParameterIndex && ICal2RecurIndex && ICal2PropertyIndex && ICal2ComponentIndex) {
        return(TRUE);
    }

    CloseICal2Parser();

    return(FALSE);
}

static void 
ICal2ParameterFree(ICal2Property *property, ICal2Parameter *parameter)
{
    if (parameter->next) {
        parameter->next->prev = parameter->prev;
    } else {
        property->parameters.tail = parameter->prev;
    }

    if (parameter->prev) {
        parameter->prev->next = parameter->next;
    } else {
        property->parameters.head = parameter->next;
    }

    MemFree(parameter);

    return;
}

static void 
ICal2RecurByListFree(ICal2RecurByList *list)
{
    ICal2RecurByList *next;
    ICal2RecurByList *recurBy = list;

    while (recurBy) {
        next = recurBy->next;

        MemFree(recurBy);

        recurBy = next;
    }

    return;
}

static void 
ICal2PropertyFree(ICal2Component *component, ICal2Property *property)
{
    unsigned long count;
    ICal2ValueDetail *detail;
    ICal2Value *value;

    while (property->parameters.head) {
        ICal2ParameterFree(property, property->parameters.head);
    }

    if (property->next) {
        property->next->prev = property->prev;
    } else {
        component->properties.tail = property->prev;
    }

    if (property->prev) {
        property->prev->next = property->next;
    } else {
        component->properties.head = property->next;
    }

    if ((value = property->value) != NULL) {
        if (value->type != ICAL2_VALUE_TYPE_RECUR) {
            MemFree(property->value);
        } else {
            detail = &(value->items.detail[0]);

            for (count = 0; count < value->items.count; count++, detail++) {
                ICal2RecurByListFree(detail->recur.bySeconds);
                ICal2RecurByListFree(detail->recur.byMinutes);
                ICal2RecurByListFree(detail->recur.byHours);
                ICal2RecurByListFree(detail->recur.byDays);
                ICal2RecurByListFree(detail->recur.byMonthDays);
                ICal2RecurByListFree(detail->recur.byYearDays);
                ICal2RecurByListFree(detail->recur.byWeekNumbers);
                ICal2RecurByListFree(detail->recur.byMonths);
                ICal2RecurByListFree(detail->recur.bySets);
                ICal2RecurByListFree(detail->recur.xNames);
            }

            MemFree(property->value);
        }
    }

    MemFree(property);

    return;
}

static void 
ICal2ComponentFree(ICal2Component *parent, ICal2Component *child)
{
    while (child->head) {
        ICal2ComponentFree(child, child->head);
    }

    while (child->properties.head) {
        ICal2PropertyFree(child, child->properties.head);
    }

    if (child->next) {
        child->next->prev = child->prev;
    } else if (parent) {
        parent->tail = child->prev;
    }

    if (child->prev) {
        child->prev->next = child->next;
    } else if (parent) {
        parent->head = child->next;
    }

    MemFree(child);

    return;
}

EXPORT void 
ICal2ObjectFree(ICal2Object *ical)
{
    ICal2Component *next;
    ICal2Component *component;

    component = ical->components.head;
    while (component) {
        next = component->next;

        ICal2ComponentFree(NULL, component);

        component = next;
    }

    MemFree(ical);

    return;
}

/*
    RFC 2445 Section 4.1 Content Lines

    contentline
        ; This ABNF is just a general definition for an initial parsing
        ; of the content line into its property name, parameter list,
        ; and value string
        name *(";" param ) ":" value CRLF

    ; When parsing a content line, folded lines MUST first
    ; be unfolded according to the unfolding procedure
    ; described above. When generating a content line, lines
    ; longer than 75 octets SHOULD be folded according to
    ; the folding procedure described above.

    name
        x-name / iana-token

    iana-token
        ; iCalendar identifier registered with IANA
        1*(ALPHA / DIGIT / "-")

    x-name
        ; Reservered for experimental use. Not intended for use in
        ; released products.
        "X-" [vendorid "-"] 1*(ALPHA / DIGIT / "-")

    vendorid
        ; Vendor identification
        3*(ALPHA / DIGIT)

    param
        ; Each property defines the specific ABNF for the parameters
        ; allowed on the property. Refer to specific properties for
        ; precise parameter ABNF.
        param-name "=" param-value *("," param-value)

    param-name
        iana-token / x-token

    param-value
        paramtext / quoted-string

    paramtext
        *SAFE-CHAR

    value
        *VALUE-CHAR

    quoted-string
        DQUOTE *QSAFE-CHAR DQUOTE

    NON-US-ASCII
        ; Use restricted by charset parameter
        ; on outer MIME object (UTF-8 preferred)
        %x80-F8

    QSAFE-CHAR
        ; Any character except CTLs and DQUOTE
        WSP / %x21 / %x23-7E / NON-US-ASCII

    SAFE-CHAR
        ; Any character except CTLs, DQUOTE, ";", ":", ","
        WSP / %x21 / %x23-2B / %x2D-39 / %x3C-7E / NON-US-ASCII

    VALUE-CHAR
        ; Any textual character
        WSP / %x21-7E / NON-US-ASCII

    CR
        ; carriage return
        %x0D

    LF
        ; line feed
        %x0A

    CRLF
        ; Internet standard newline
        CR LF

    CTL
        ; Controls
        %x00-08 / %x0A-1F / %x7F

    ALPHA
        ; A-Z / a-z
        %x41-5A / %x61-7A

    DIGIT
        ; 0-9
        %x30-39

    DQUOTE
        ; Quotation Mark
        %x22

    WSP
        SPACE / HTAB

    SPACE
        %x20

    HTAB
        %x09

*/
EXPORT ICal2Object *
ICal2ObjectParse(void *object, unsigned long flags, unsigned long length)
{
    unsigned long index;
    unsigned char *ptr;
    unsigned char *src;
    unsigned char *limit;
    BOOL result;
    FILE *fh;
    ICal2Object *ical;

    if (length && object) {
        /*
            fixme

            For non-memory based objects; rather than pre-allocate and
            read the entire source object; modify the 
            ICAL2_UNFOLD_AND_COPY_LINE macro to handle reading a single
            line from the source.
        */
        if (flags & ICAL2_OBJECT_FLAG_MEMORY) {
            src = (unsigned char *)object;
        } else if (flags & ICAL2_OBJECT_FLAG_FILE_HANDLE) {
            fh = (FILE *)object;
            src = (unsigned char *)MemMalloc(length + 1);
            if (src) {
                memset(src, 0, length);

                ptr = src;
                limit = src + length;

                while (!feof(fh) && !ferror(fh) && (ptr < limit)) {
                    ptr += fread(ptr, sizeof(unsigned char), limit - ptr, fh);
                }

                *ptr = '\0';
            } else {
                return(NULL);
            }
        } else {
            return(NULL);
        }

        if (XplStrNCaseCmp(src, "BEGIN:VCALENDAR\r\n", 17) == 0) {
            ical = (ICal2Object *)MemMalloc(sizeof(ICal2Object) + length + 1);
        } else {
            if (flags & ICAL2_OBJECT_FLAG_FILE_HANDLE) {
                MemFree(src);
            }

            return(NULL);
        }
    } else {
        return(NULL);
    }

    if (ical) {
        memset(ical, 0, sizeof(ICal2Object));

        ical->parse.cur = src;
        ical->parse.dest = ical->data;
    } else {
        if (src && (flags & ICAL2_OBJECT_FLAG_FILE_HANDLE)) {
            MemFree(src);
        }

        return(NULL);
    }

    do {
        ical->parse.name = ical->parse.dest;
        ICAL2_UNFOLD_AND_COPY_LINE(ical->parse.cur, ical->parse.dest);

        index = HulaKeywordFind(ICal2PropertyIndex, ical->parse.name);
        if (index != -1) {
            ical->parse.token = &ICal2PropertyTokens[index];

            ptr = ical->parse.name + ical->parse.token->nameLen;
            if (*ptr == ':') {
                *ptr++ = '\0';

                ical->parse.param = NULL;
                ical->parse.value = ptr;

                result = ical->parse.token->parser.property(ical);
            } else if (*ptr == ';') {
                *ptr++ = '\0';

                ical->parse.param = ptr;
                ical->parse.value = NULL;

                result = ical->parse.token->parser.property(ical);
            } else if (ical->parse.token->type == ICAL2_PROPERTY_X) {
                result = ICal2XPropertyParser(ical);
            } else {
                result = ICal2IanaPropertyParser(ical);
            }
        } else if (ICal2IsXName(ical->parse.name[0])) {
            result = ICal2IanaPropertyParser(ical);
        } else {
            /* Skip blank and garbled lines. */
            result = TRUE;
        }
    } while (result && ical->parse.cur[0]);

    ical->length = ical->parse.dest - ical->data;

    if (!result) {
        ICal2ObjectFree(ical);
        ical = NULL;
    }

    if (flags & ICAL2_OBJECT_FLAG_FILE_HANDLE) {
        MemFree(src);
    }

    return(ical);
}
