/****************************************************************************
 *
 * Copyright (c) 2001 Novell, Inc.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2.1 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, contact Novell, Inc.
 *
 * To contact Novell about this file by physical or electronic mail,
 * you may find current contact information at www.novell.com
 *
 ****************************************************************************/

#include <logger.h>

#include <mwpref.tok>
#include <mwpref.ary>
#include "saveform.h"

/* Forms */
#define	SAVE_FORM							6501
#define	RULE_LIST_FORM						6502
#define	RULE_CREATE_FORM					6503
#define	RULE_DELETE							6504

#define	REQUEST_NETMAIL_USER				6505
#define	REQUEST_RULE_DELETE				6506
#define	REQUEST_RULE_EDIT					6507
#define	REQUEST_RULE_TOGGLE_STATE		6508
#define	REQUEST_RULE_UP					6509
#define	REQUEST_RULE_DOWN					6510
#define	REQUEST_RULE_SAVE					6511
#define	REQUEST_DELETE_SHARE				6512
#define	REQUEST_PROXY_DELETE				6513
#define	REQUSET_PROXY_ADD					6514
#define	REQUEST_PROXY_RO					6515
#define	REQUEST_PROXY_RW					6516

extern void			*LogHandle;

typedef struct {
	MDBValueStruct		*V;
	unsigned long		Count;
	unsigned long		Error;
	unsigned char		*Results;
	unsigned char		*CurrentColor;
	unsigned long		CurrentColorLen;
	unsigned char		*CurrentRule;
	unsigned long		PasswordConfig;
	unsigned long		GeneralConfig;
	ProxyListStruct	Proxy[MAX_PROXY_ENTRIES];

	/* Rules */
	unsigned long		RuleID;

	unsigned char		*CurrentRuleSegment;
	unsigned char		RuleSegmentType;
	unsigned char		RuleSegmentBool;

	unsigned long		RuleSegmentArg1Len;
	unsigned char		*RuleSegmentArg1;

	unsigned long		RuleSegmentArg2Len;
	unsigned char		*RuleSegmentArg2;

} PrefSessionStruct;

/* Preferences password bitfield */
#define	ALLOW_PASSWORD_CHANGE		(1<<0)
#define	SSL_FOR_PASS_CHANGE			(1<<1)

/* Preferences config bitfield */
#define	PREF_HIDE_TIMEOUT				(1<<0)
#define	PREF_HIDE_COLORS				(1<<1)
#define	PREF_HIDE_PRIVACY				(1<<2)
#define	PREF_HIDE_SIGNATURE			(1<<3)
/* Date/Time formats */

unsigned char	ShortChineseFormat[]		= { '%', 'y', 0xE5, 0xB9, 0xB4, '%', 'm', 0xe6, 0x9c, 0x88, '%', 'd', 0xe6, 0x97, 0xa5, 0};
unsigned char	ShortChineseName[]		= { 0x79, 0x79, 0x22, 0xE5, 0xB9, 0xB4, 0x22, 0x4D, 0x4D, 0x22, 0xe6, 0x9c, 0x88, 0x64, 0x64, 0x22, 0xe6, 0x97, 0xa5, 0x22, 0};

/* Short Date */
unsigned char	*ShortDateFormats[] = {
	"%m/%d/%y",
	"%d/%m/%y",
	"%y/%m/%d",
	"%y-%m-%d",
	"%Y/%m/%d",
	ShortChineseFormat,
	"%d.%m.%y",
	"%d-%m-%y",
	"%d/%m/%Y",
	"%Y.%m.%d",
	"%Y-%m-%d",
	"%d.%m.%Y",
	NULL
};

unsigned char	*ShortDateFormatNames[] = {
	"MM/dd/yy",
	"dd/MM/yy",
	"yy/MM/dd",
	"yy-MM-dd",
	"yyyy/MM/dd",
	ShortChineseName,
	"dd.MM.yy",
	"dd-MM-yy",
	"dd/MM/yyyy",
	"yyyy.MM.dd",
	"yyyy-MM-dd",
	"dd.MM.yyyy",
	NULL
};


unsigned char	LongChineseFormat[]		= {	'%', 'Y', 0xE5, 0xB9, 0xB4, '%', 'm', 0xE6, 0x9C, 0x88, '%', 'd', 0};
unsigned char	LongChineseName[]		= {	'y', 'y', 'y', 'y', 0xE5, 0xB9, 0xB4, 'M', 'M', 0xE6, 0x9C, 0x88, 'd', 'd', 0	};

/* Long Date */
unsigned char	*LongDateFormats[] = {
	"%B %d, %Y",
	"%d %B %Y",
	"%d %B, %Y",
	LongChineseFormat,
	"%d. %B %Y",
	"%d. %b %Y",
	"%d %b %Y",
	"%Y.%B %d",
	"%Y/%m/%d",
	"%d de %B de %Y",
	"%a %d %B %Y",
	"%d %B %Y %A",
	NULL
};

unsigned char	*LongDateNames[] = {
	"MMMM dd, yyyy",
	"dd MMMM yyyy",
	"dd MMMM, yyyy",
	LongChineseName,
	"dd. MMMM yyyy",
	"dd. mmm yyyy",
	"dd mmm yyyy",
	"yyyy.MMMM dd",
	"yyyy/MM/dd",
	"dd \"de\" MMMM \"de\" yyyy",
	"EE dd MMMM yyyy",
	"dd MMMM yyyy EEEE",
	NULL
};

unsigned char	TimeChineseFormat[]		= {	'%', 'p', ' ', '%', 'I', 0xE6, 0x97, 0xB6, '%', 'M', 0xE5, 0x88, 0x86, '%', 'S', 0xE7, 0xA7, 0x92, 0	};
unsigned char	TimeChineseName[]		= {	't', 't', ' ', 'h', 'h', 0xE6, 0x97, 0xB6, 'm', 'm', 0xE5, 0x88, 0x86, 's', 's', 0xE7, 0xA7, 0x92, 0	};

unsigned char	TimeTieFormat[]		= {	'%', 'H', ' ', 0xE0, 0xB8, 0x99, 0xE0, 0xB8, 0xB2, 0xE0, 0xB8, 0xAC, 0xE0, 0xB8, 0xB4, 0xE0, 0xB8, 0x81, 0xE0, 0xB8, 0xB2, ' ', '%', 'M', ' ', 0xE0, 0xB8, 0x99, 0xE0, 0xB8, 0xB2, 0xE0, 0xB8, 0x97, 0xE0, 0xB8, 0xB5, 0	};
unsigned char	TimeTieName[]		= {	'H', 'H', ' ', 0xE0, 0xB8, 0x99, 0xE0, 0xB8, 0xB2, 0xE0, 0xB8, 0xAC, 0xE0, 0xB8, 0xB4, 0xE0, 0xB8, 0x81, 0xE0, 0xB8, 0xB2, ' ', 'm', 'm', ' ', 0xE0, 0xB8, 0x99, 0xE0, 0xB8, 0xB2, 0xE0, 0xB8, 0x97, 0xE0, 0xB8, 0xB5, 0	};

/* Time */
unsigned char	*TimeFormats[] = {
	"%I:%M %p",
	"%H:%M",
	"%I:%M",
	TimeChineseFormat,
	"%Hh%Mmin",
	TimeTieFormat,
	NULL
};

unsigned char	*TimeNames[] = {
	"h:mm tt" ,
	"HH:mm",
	"h:mm",
	TimeChineseName,
	"HH\"h\"mm\"min\"",
	TimeTieName,
	NULL
};


/*
 * This is the list of charsets from webmail (NIMS <= 2.65) *
 * They are here only for backwards compatability.  They    *
 * where stored as a number instead of the string but since *
 * the charset list is drasticly different with NIMS 3.0 we *
 * can't do that any more.                                  *
 */

unsigned char *OldCharsets[] = {
	"us-ascii",
	"utf-8",
	"iso-8859-1",
	"iso-8859-2",
	"iso-8859-3",
	"iso-8859-4",
	"iso-8859-5",
	"iso-8859-6",
	"iso-8859-7",
	"iso-8859-8",
	"iso-8859-9",
	"iso-8859-10",
	"iso-8859-13",
	"iso-8859-15",
	"koi8-r",
	"koi8-u",
	"koi8-ru",
	"tis-620",
	"viscii",
	"big5",
	"cn-big5",
	"gb2312",
	"cn-gb",
	"cn-gb-12345",
	"euc-jp",
	"iso-2022-jp",
	"iso-2022-jp-1",
	"iso-2022-jp-2",
	"iso-2022-cn",
	"iso-2022-kr",
	"euc-kr",
	"ks_c_5601-1987",
	"ks_c_5601-1992",
	"shift-jis",
	"shift_jis",
	NULL
};
