#ifndef _AFFIXMGR_HXX_
#define _AFFIXMGR_HXX_
#include <cstdlib>
#include <cstring>
#include <cstdio>

#include "atypes.hxx"
#include "baseaffix.hxx"
#include "hashmgr.hxx"

class AffixMgr
{

  AffEntry *          pStart[SETSIZE];
  AffEntry *          sStart[SETSIZE];
  AffEntry *          pFlag[CONTSIZE];
  AffEntry *          sFlag[CONTSIZE];
  HashMgr *           pHMgr;
  char *              trystring;
  char *              encoding;
  int                 utf8;
  struct unicode_info2 * utf_tbl;
  FLAG                compoundflag;  
  FLAG                compoundbegin;
  FLAG                compoundmiddle;
  FLAG                compoundend;
  FLAG                compoundroot;
  FLAG                compoundforbidflag;
  FLAG                compoundpermitflag;
  FLAG                forbiddenword;
  FLAG                pseudoroot;
  FLAG                onlyroot;
  int                 cpdmin;
  int                 numrep;
  replentry *         reptable;
  int                 nummap;
  mapentry *          maptable;
  int                 nomapsugs;
  int                 nosplitsugs;
  int                 cpdwordmax;
  int                 cpdmaxsyllable;
  char *              cpdvowels;
  w_char *            cpdvowels_utf16;
  int                 cpdvowels_utf16_len;
  replentry *         accent;
  char *              cpdsyllablenum;
  const char *        pfxappnd; // BUG: not stateless
  const char *        sfxappnd; // BUG: not stateless
  FLAG                sfxflag;  // BUG: not stateless
  char *              derived;  // BUG: not stateless
  AffEntry *          sfx;      // BUG: not stateless
  AffEntry *          pfx;      // BUG: not stateless
  int                 checknum;
  char *              wordchars;
  char *              version;
  char *              lang;
  int                 langnum;
  FLAG                lemma_present;
  FLAG                circumfix;
  FLAG                onlyincompound;

  int                 havecontclass; // boolean variable
#ifndef NOT_SHORT_2BYTE
  short               contclasses[CONTSIZE]; // flags of possible continuing classes (twofold affix)
#endif
  flag                flag_mode;

public:
 
  AffixMgr(const char * affpath, HashMgr * ptr);
  ~AffixMgr();
  struct hentry *     affix_check(const char * word, int len,
            const unsigned short needflag = (unsigned short) 0, char in_compound = IN_CPD_NOT);
  struct hentry *     prefix_check(const char * word, int len,
            char in_compound, const FLAG needflag = FLAG_NULL);
  struct hentry *     prefix_check_twosfx(const char * word, int len,
            char in_compound, const FLAG needflag = FLAG_NULL);
  struct hentry *     suffix_check(const char * word, int len, int sfxopts, AffEntry* ppfx,
			char ** wlst, int maxSug, int * ns, const FLAG cclass = FLAG_NULL,
                        const FLAG needflag = FLAG_NULL, char in_compound = IN_CPD_NOT);
  struct hentry *     suffix_check_twosfx(const char * word, int len,
            int sfxopts, AffEntry* ppfx, const FLAG needflag = FLAG_NULL);

  char * affix_check_morph(const char * word, int len,
                    const FLAG needflag = FLAG_NULL, char in_compound = IN_CPD_NOT);
  char * prefix_check_morph(const char * word, int len,
                    char in_compound, const FLAG needflag = FLAG_NULL);
  char * suffix_check_morph (const char * word, int len, int sfxopts, AffEntry * ppfx,
            const FLAG cclass = FLAG_NULL, const FLAG needflag = FLAG_NULL, char in_compound = IN_CPD_NOT);

  char * prefix_check_twosfx_morph(const char * word, int len,
            char in_compound, const FLAG needflag = FLAG_NULL);
  char * suffix_check_twosfx_morph(const char * word, int len,
            int sfxopts, AffEntry * ppfx, const FLAG needflag = FLAG_NULL);

  int                 expand_rootword(struct guessword * wlst, int maxn, 
                             const char * ts, int wl, const unsigned short * ap, unsigned short al);

  int                 get_syllable (const char * word, int wlen);
  int                 repl_check(const char * word, int len);
//  int                 swap_check(const char * word, int len);
  int                 candidate_check(const char * word, int len);
  struct hentry *     compound_check(const char * word, int len,
                              int wordnum, int numsyllable, int maxwordnum, int hu_mov_rule,
			      int * cmpdstemnum, int * cmpdstem);

  int compound_check_morph(const char * word, int len,
                              int wordnum, int numsyllable, int maxwordnum, int hu_mov_rule,
                              char ** result, char * partresult);

  struct hentry *     lookup(const char * word);
  int                 get_numrep();
  struct replentry *  get_reptable();
  struct replentry *  get_accent();
  int                 get_nummap();
  struct mapentry *   get_maptable();
  char *              get_encoding();
  int                 get_langnum();
  struct unicode_info2 * get_utf_conv();
  char *              get_try_string();
  const char *        get_wordchars();
  FLAG                get_compoundflag();
  FLAG                get_compoundbegin();
  FLAG                get_forbiddenword();
  FLAG                get_pseudoroot();
  FLAG                get_onlyroot(); // obsolote
  FLAG                get_compoundroot();
  FLAG                get_lemma_present();
  int                 get_checknum();
  char *              get_possible_root();
  const char *        get_prefix();
  const char *        get_suffix();
  const char *        get_derived();
  const char *        get_version();
  const int           have_contclass();
  int                 is_utf8();
  char *              get_suffixed(char );
  int                 get_nomapsugs();
  int                 get_nosplitsugs();

private:
  int  parse_file(const char * affpath);
  int  parse_try(char * line);
  int  parse_set(char * line);
  int  parse_flag(char * line, unsigned short * out, char * name);
  int  parse_num(char * line, int * out, char * name);
  int  parse_cpdflag(char * line);
  int  parse_cpdforbid(char * line);
  int  parse_forbid(char * line);
  int  parse_onlyroot(char * line);
  int  parse_cpdsyllable(char * line);
  int  parse_accent(char * line);
  int  parse_syllablenum(char * line);
  int  parse_reptable(char * line, FILE * af);
  int  parse_maptable(char * line, FILE * af);
  int  parse_affix(char * line, const char at, FILE * af);
  int  parse_wordchars(char * line);
  int  parse_lang(char * line);
  int  parse_version(char * line);

  void encodeit(struct affentry * ptr, char * cs);
  int build_pfxlist(AffEntry* pfxptr);
  int build_sfxtree(AffEntry* sfxptr);
  int process_pfx_order();
  int process_sfx_order();
  AffEntry * process_sfx_inorder(AffEntry * ptr, AffEntry * nptr);
  int process_sfx_tree_to_list();
  void set_spec_utf8_encoding();
  
};

#endif

