/* softnet/macros.h -- softnet macros */

#ifndef _softnet_macros_h_
#define _softnet_macros_h_

#include <softnet/types.h>

CDEFBEGIN

/* tell compiler/lint/whatever that a variable is used */
VXInline void
_variable_used(long x)
{
}
#define variable_used(x) \
	_variable_used((long) (x))

/* tell lint that a variable is used */
#ifdef lint
#define lintuse(x)	variable_used(x)
#else /*lint*/
#define lintuse(x)	/**/
#endif /*lint*/

/* define variable only if HOWFAR mode */
#ifdef HOWFAR
#define howfar_define(thing)			thing;
#else /*HOWFAR*/
#define howfar_define(thing)			/**/
#endif /*HOWFAR*/

/* variables that are used only when debugging */
#if !defined(HOWFAR) && !defined(HOWCHECK)
#define howfar_used(x)	variable_used(x)
#else /*HOWFAR/HOWCHECK*/
#define howfar_used(x)	/**/
#endif /*HOWFAR/HOWCHECK*/

/* tell compiler to not put variable in a register */
#define variable_unregister(x) \
	do { \
		void *variable_unregister_tmp; \
		variable_unregister_tmp = &(x); \
	} while (0)

/* casts */
#define CAST(y,x)	((y) (x))
#define DOUBLE(x)	CAST(double,x)

/* FIXME -- this has a conflict with -DFLOAT for kernel */
#ifndef FLOAT
#define FLOAT(x)	CAST(float,x)
#endif /*FLOAT*/

/* value casts */
#define SHORT(x)	CAST(short,x)
#define LG(x)		CAST(long,x)
#define WD(x)		CAST(u_short,x)
#define LW(x)		CAST(u_long,x)

/* pointer casts */
#define LP(x)		CAST(u_long *,x)
#define WP(x)		CAST(u_short *,x)
#define BP(x)		CAST(u_char *,x)
#define CP(x)		CAST(char *,x)
#define VP(x)		CAST(void *,x)

#define VDCODE(ptr)	((vdcode) ptr)
#define VPCODE(ptr)	((vpcode) ptr)
#define LGCODE(ptr)	((lgcode) ptr)
#define LWCODE(ptr)	((lwcode) ptr)

/* definition to print a pointer */
#define PP(x)		LW(x)

/* number of bits */
#define Sizeof(x) \
	(sizeof(x) * 8)

/* number of longs */
#define LSizeof(x) \
	(sizeof(x) / sizeof(long))

/* number of vector elements */
#define Cntof(x) \
	(sizeof(x) / sizeof(x[0]))

#ifndef MIN
#define MIN(x,y)	(((x) < (y)) ? (x) : (y))
#endif /*MIN*/

#ifndef MAX
#define MAX(x,y)	(((x) > (y)) ? (x) : (y))
#endif /*MAX*/

#define XABS(x)		(((x) < 0) ? -(x) : (x))
#define XSGN(x)		(((x) < 0) ? -1 : 1)

/* align to arbitrary (power of 2) boundaries */
#define ALIGN(x,y)	(LW(x) & (~((y) - 1)))
#define ALIGNUP(x,y)	ALIGN((x) + (y) - 1,y)

/* align to longword boundary */
#define WDALIGN(x)	ALIGN(x,sizeof(word))
#define LWALIGN(x)	ALIGN(x,sizeof(longword))
#define LWALIGNUP(x)	ALIGNUP(x,sizeof(longword))

/* find nonblank stuff */
#define NONBLANK(cp,ep) \
	for (;  (cp < ep) && (*cp != 0) && (*cp == ' ');  ++cp);

/* create control character */
#define CTRL(c) \
	(((c) - 'a') + 1)

/* square of number */
#define SQUARE(x) \
	((x) * (x))

/* common thing */
#define DUAL(item) \
	item,sizeof(item)
#define BFE(item) \
	&item[sizeof(item) / sizeof(item[0])]
#define DUALBFE(item) \
	item,BFE(item)

/* check that range is active */
#define RNGEON(lo,hi) \
	((lo) <= (hi))

/* check value within a range (lo <= x <= hi) */
#define RNGE(x,lo,hi) \
	(((x) >= (lo)) && ((x) <= (hi)))

/* check value within a range (lo <= x < hi) */
#define RNGEM1(x,lo,hi) \
	(((x) >= (lo)) && ((x) < (hi)))

/* check range is active and value is with range (if range not active, */
/* all data values are "within" range) */
#define RNGEOK(x,lo,hi) \
	(RNGEON(lo,hi) ? RNGE(x,lo,hi) : 1)

/* printable characters */
#define _PRTABLE(c) \
	RNGE(c,0x20,0x7E)
#define PRTABLE(c) \
	(_PRTABLE(c) ? (u_char) (c) : (u_char) '.')

/* bitmask has all its bits on */
#define ANDEQ(val,msk) \
	(((val) & (msk)) == (msk))

/* insure absolute boolean */
#define BOOL(x) \
	(((x) != 0) ? 1 : 0)

/* structure base pointer */
#define STRCTBAS(strnam) \
	CAST(strnam *,0)

/* compute the offset of a structure item */
#define STRCTOFF(strnam,stritem) \
	LW(&(STRCTBAS(strnam)->stritem))

/* compute the structure pointer from pointer to structure item */
#define STRCTPAR(strnam,stritem,ptr) \
	CAST(strnam *,VP(ptr) - STRCTOFF(strnam,stritem))

/* compute the size of a structure item (bytes) */
#define STRCTSIZ(strnam,stritem) \
	sizeof(STRCTBAS(strnam)->stritem)

/* compute the size of a structure item (bits) */
#define STRCTSIZB(strnam,stritem) \
	Sizeof(STRCTBAS(strnam)->stritem)

/* virtual functions */
#define VRT(vrt,vidx,vargs,falt) \
	(((vrt)[vidx] != NULL) ? (*(vrt)[vidx])vargs : (falt))

/* creates a 1 bit wide mask from its bit number (0 is LSB, n is MSB) */
#define RMSKOF(bitno) \
	(CAST(mskof_t,0x00000001) << (bitno))
#define RMSKOF1(bitno) \
	RMSKOF((bitno) - 1)
/* creates a bit mask of "wid" bits wide */
#define RMSKOFWID(wid) \
	(~(CAST(mskof_t,-1) << (wid)))

/* creates a 1 bit wide mask from its bit number (0 is MSB, n is LSB) */
#define LMSKOF(idx) \
	RMSKOF(Sizeof(mskof_t) - 1 - (idx))
#define LMSKOF1(bitno) \
	LMSKOF((bitno) - 1)
/* creates a bit mask of "wid" bits wide */
#define LMSKOFWID(wid) \
	(~(CAST(mskof_t,-1) >> (wid)))

/* set bits from mask */
#define MSKSET(tgt,msk) \
	tgt |= (msk)

/* clear bits from mask */
#define MSKCLEAR(tgt,msk) \
	tgt &= ~(msk)

/* clear bits from mask */
#define MSKFLIP(tgt,msk) \
	tgt ^= (msk)

/* speedup a part of strcmp */
#define STRCMP(dif,cp1,cp2) \
	do { \
		dif = LW(cp1[0]) - LW(cp2[0]); \
		if (dif == 0) \
			dif = strcmp(cp1,cp2); \
	} while (0)

/* speedup a part of strcmp */
#define STRMATCH(cp1,cp2) \
	(strcmp(cp1,cp2) == 0)

/* define an enum value */
#define ENUMDEF(name,idx,reason) \
	name = idx,
#define ENUMDEFX(name,idx,reason) \
	name idx,

/* define tagblk for enum with short and long names */
#define ENUMTAGSHORT(name,idx,reason) \
	TAGDUAL(name),

/* define tagblk for enum with long names */
#define ENUMTAGLONG(name,idx,reason) \
	TAGINIT(name,reason),

/* define tagblk for enum with short and long names */
#define ENUMTAGBOTH(name,idx,reason) \
	TAGINIT(name,#name " -- " reason),

/* check integrity */
#ifdef HOWCHECK
#define HOWCHKX(boolflg,op) \
	do { \
		if (boolflg) \
			op; \
	} while (0)
#else /*HOWCHECK*/
#define HOWCHKX(boolflg,op)		/**/
#endif /*HOWCHECK*/
#define HOWCHK(lvl,op) \
	HOWCHKX(zprtok(lvl),op)
#define HOWCHKIF(lvl,boolflg,abtmsg) \
	HOWCHK(lvl,if (boolflg) abtmsg)

CDEFEND

#endif /*_softnet_macros_h_*/
