#include "hx_types.h"
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <stdio.h>
#include "input.h"
#include "term.h"
#include "screen.h"
#include "hxlib.h"

#include <netinet/in.h>
#include <arpa/inet.h>
extern struct sockaddr_in hx_sockaddr;

static char vbuf[1024] = "\0";

void
default_status_draw (struct screen *scr)
{
	char ibuf[1024];
	int fd, ilen;

	if (!vbuf[0]) {
		if ((fd = open("/proc/version", O_RDONLY)) > -1) {
			char *p;
			read(fd, vbuf, sizeof vbuf);
			close(fd);
			if ((p = strchr(vbuf,'\n')))
				*p = 0;
		} else {
#ifdef __GNUC__
			sprintf(vbuf, "[hx version %s (gcc version %s)]",
				hx_version_string, __VERSION__);
#else
			sprintf(vbuf, "[hx version %s]", hx_version_string);
#endif
		}
	}

	term_goto_line((signed)scr->li + 1);
	if ((ilen = snprintf(ibuf, (unsigned)CO > sizeof ibuf ? sizeof ibuf : CO,
		hx_sockaddr.sin_addr.s_addr ?
		"[%s<%u>] [%s(0x%x)] [%s:%u]" :
		"[%s<%u>] [%s(0x%x)] [not connected]",
		hx_prefs.nick, hx_prefs.icon,
		curchat ? curchat->subject : "\0", curchat ? curchat->ref : 0,
		inet_ntoa(hx_sockaddr.sin_addr), ntohs(hx_sockaddr.sin_port))) == -1) ilen = CO;
	term_printf("%s%.*s", term_colour(BACK_BLUE), ilen, ibuf);
	term_ce();
	term_printf("\n%.*s", CO, vbuf);
	term_ce();
	term_printf("%s", term_colour(DEFAULT));
	term_goto_line(LI);
}
