/*
 * This file is part of hyantes.
 *
 * hyantes is free software; you can redistribute it and/or modify
 * it under the terms of the CeCILL-C License
 *
 * You should have received a copy of the CeCILL-C License
 * along with this program.  If not, see <http://www.cecill.info/licences>.
 */

#ifndef _HYANTES_INTERPOLATION_H
#define _HYANTES_INTERPOLATION_H
#include <stddef.h>

/* interpolation fonction prototype */
typedef double (*func_interpolation) (double);

/* G_INTER is used to perform smoothing, once set by set_fonc_inter */
extern /*@null@ */ func_interpolation g_inter;

/* sets global function pointer G_INTER before use */
extern void set_func_inter(const char *function_name,
   double function_param)
/*@modifies g_inter@*/ ;

/* implementation of hs_list_smoothing */
extern /*@observer@ */ const char **list_smoothing(size_t * sz);

#endif
