/*
 * This file is part of hyantes.
 *
 * hyantes is free software; you can redistribute it and/or modify
 * it under the terms of the CeCILL-C License
 *
 * You should have received a copy of the CeCILL-C License
 * along with this program.  If not, see <http://www.cecill.info/licences>.
 */

#include "module.h"
#include "engine.h"
#include "hs_config.h"

#include <athapascan-1>

unsigned long get_status()
{
    return 0;
}

/*
 * functor
 */
struct mpot
{
    const make_pot_param *param;

     mpot():param(0)
    {
    };
    mpot(const make_pot_param * p):param(p)
    {
    }

    hs_potential_t & operator()(hs_potential_t & p) const
    {
        make_pot(&p, param);
        return p;
    }

};

/*
 * module entry point
 */
int make_all_pot(hs_potential_t * iter, size_t nb_iter,
   const struct make_pot_param *param)
{
    int argc = 1;
    char *myargv[] = { "test", NULL };
    char **argv = myargv;
    a1::Community com = a1::System::join_community(argc, argv);
    if(com.is_leader())
        a1::transform(iter, iter + nb_iter, iter, mpot(param));
    com.leave();
    a1::System::terminate();
    return 1;
}

/*
 * dummy stream operators
 */
a1::IStream & operator>>(a1::IStream & i, mpot &)
{
    return i;
}

a1::OStream & operator<<(a1::OStream & i, const mpot &)
{
    return i;
}

a1::IStream & operator>>(a1::IStream & i, hs_potential_t &)
{
    return i;
}

a1::OStream & operator<<(a1::OStream & i, const hs_potential_t &)
{
    return i;
}
