/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: DrumkitManager.h,v 1.7 2004/01/26 11:17:48 comix Exp $
 *
 */


#ifndef DRUMKIT_MANAGER_H
#define DRUMKIT_MANAGER_H

#include <vector>
#include <iostream>
using std::cout;
using std::cerr;
using std::endl;


#include "qlabel.h"
#include "qlistbox.h"
#include "qmessagebox.h"
#include "qpushbutton.h"
#include "qfiledialog.h"
#include "qlineedit.h"
#include "qtextedit.h"
#include "qtabwidget.h"
#include "qcombobox.h"

#include "DrumkitManager_UI.h"
#include "config.h"

#include "lib/LocalFileMng.h"

/**
 * Drumkit manager
 */
class DrumkitManager : public DrumkitManager_UI {
	Q_OBJECT

	public:
		DrumkitManager( QWidget* parent );
		~DrumkitManager();

	private:
		vector<DrumkitInfo*> drumkitInfoList;

		void updateDrumkitList();

		void okBtnClicked();

		void loadTab_selectionChanged();
		void loadTab_loadDrumkitBtnClicked();
		void loadTab_deleteDrumkitBtnClicked();

		void importTab_browseBtnClicked();
		void importTab_importBtnClicked();
		void importTab_drumkitPathChanged();

		void saveTab_saveBtnClicked();
		void saveTab_nameChanged();

		void tabChanged();

		void exportTab_browseBtnClicked();
		void exportTab_exportBtnClicked();
		void exportTab_drumkitPathChanged();
};

#endif

