/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: ExportSongDialog.cpp,v 1.9 2004/01/26 11:17:48 comix Exp $
 *
 */


#include "ExportSongDialog.h"

#include "config.h"
#include "lib/Song.h"
#include "lib/Hydrogen.h"


/**
 * Constructor
 */
ExportSongDialog::ExportSongDialog(QWidget* parent) : ExportSongDialog_UI(parent, 0, true) {

//	cout << "Export Song Dialog INIT" << endl;

	setCaption( trUtf8( "Export song" ) );
	setIcon( QPixmap( QString(IMG_PATH) + QString( "/img/icon32.png") ) );

}




/**
 * Destructor
 */
ExportSongDialog::~ExportSongDialog() {
//	cout << "ExportSongDialog Destroy" << endl;
}





/** ??? */
void ExportSongDialog::languageChange() {
}



/**
 *
 */
void ExportSongDialog::browseBtnClicked() {

	QFileDialog *fd = new QFileDialog(this, "File Dialog", TRUE);
	fd->setMode(QFileDialog::AnyFile);
	fd->setFilter( trUtf8("Wave file (*.wav)") );

	fd->setCaption( trUtf8( "Export song" ) );
	fd->setIcon( QPixmap( QString(IMG_PATH) + QString( "/img/icon32.png") ) );

	QString defaultFilename;

	defaultFilename = (Hydrogen::getInstance()->getSong()->getName()).c_str();
	defaultFilename += ".wav";

	fd->setSelection(defaultFilename);

	QString filename = "";
	if (fd->exec() == QDialog::Accepted) {
		filename = fd->selectedFile();
	}

	if (filename != "") {
		QString sNewFilename = filename;
		if ( sNewFilename.endsWith( ".wav" ) == false ) {
			filename += ".wav";
		}

		exportNameTxt->setText(filename);
	}


}






/**
 *
 */
void ExportSongDialog::okBtnClicked() {
	QString filename = exportNameTxt->text();
	uint elapsedTime = (Hydrogen::getInstance())->exportSong(filename.latin1());
	char elap[10];
	sprintf(elap, "%0.02f", (float)(elapsedTime / 1000.0));

	QString info = trUtf8( "Exported %1" ).arg( filename );
	info += "\n";
	info += trUtf8("%1 seconds.").arg(elap) + QString("\n");


	QMessageBox::information( 0, "Hydrogen", info );
	accept();
}





/**
 *
 */
void ExportSongDialog::filenameTxtChanged() {
	QString filename = exportNameTxt->text();
	if (filename != "") {
		okBtn->setEnabled(true);
	}
	else {
		okBtn->setEnabled(false);
	}
}




