/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: HelpBrowser.cpp,v 1.5 2004/01/26 11:17:48 comix Exp $
 *
 */


#include "HelpBrowser.h"
#include "qstringlist.h"

/**
 * Constructor
 */
HelpBrowser::HelpBrowser( QWidget* parent ) : QTextBrowser( parent, "HelpBrowser" ) {
	setMinimumSize(width, height);
	resize(width, height);
	setCaption( trUtf8( "Manual" ) );
	setIcon( QPixmap( QString(IMG_PATH) + QString( "/img/icon32.png") ) );
}




/**
 * Destructor
 */
HelpBrowser::~HelpBrowser() {
}


/**
 *
 */
void HelpBrowser::showEvent ( QShowEvent *ev ) {
	string filename = IMG_PATH;
	filename.append( "/manual" );
	this->setReadOnly( true );
	this->mimeSourceFactory()->setFilePath( QStringList( filename.c_str() ) );

	filename.append( "/manual.html" );
	QFile file( filename.c_str() ); // Read the text from a file
	if ( file.open( IO_ReadOnly ) ) {
		QTextStream stream( &file );
		this->setText( stream.read() );
	}
}

