/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: InstrumentPropertiesDialog.cpp,v 1.10 2004/01/26 11:17:48 comix Exp $
 *
 */

#include "InstrumentPropertiesDialog.h"

#include "HydrogenApp.h"

#include "lib/Song.h"
#include "lib/Hydrogen.h"

/**
 * Constructor
 */
InstrumentPropertiesDialog::InstrumentPropertiesDialog(QWidget* parent, Instrument *instrument) : InstrumentPropertiesDialog_UI(parent) {
	setCaption( trUtf8( "Instrument properties" ) );
	this->instrument = instrument;

	setMinimumSize( width(), height() );	// not resizable
	setMaximumSize( width(), height() );	// not resizable

	setIcon( QPixmap( QString(IMG_PATH) + QString( "/img/icon32.png") ) );


	nameTxt->setText(QString((instrument->getName()).c_str()));

	sampleFilenameTxt->setText(QString((instrument->getSample()->getFilename()).c_str()));

	// update the drumkit text
	string drumkitName = instrument->getDrumkitName();
	if (drumkitName == "" ) {
		drumkitLbl->setText( QString( "External sample" ) );
	}
	else {
		drumkitLbl->setText( QString( drumkitName.c_str() ) );
	}
}





/**
 * Destructor
 */
InstrumentPropertiesDialog::~InstrumentPropertiesDialog() {
}





/**
 *
 */
void InstrumentPropertiesDialog::cancelBtnClicked() {
	reject();
}




/**
 *
 */
void InstrumentPropertiesDialog::nameChanged() {
	bool valid = true;

	string newName = (nameTxt->text()).latin1();
	if (newName == "") {
		valid = false;
	}
	Hydrogen *engine = Hydrogen::getInstance();
	Song *song = engine->getSong();
	InstrumentList *instrList = song->getInstrumentList();
	for (uint i = 0; i < instrList->getSize(); i++) {
		string instrName = (instrList->get(i))->getName();
		if (instrName == newName) {
			valid = false;
			break;
		}
	}

	if (valid) {
		okBtn->setEnabled(true);
	}
	else {
		okBtn->setEnabled(false);
	}
}




/**
 *
 */
void InstrumentPropertiesDialog::okBtnClicked() {
	string newName = (nameTxt->text()).latin1();

	instrument->setName(newName);
	nameTxt->setText(QString((instrument->getName()).c_str()));


	accept();
}




/** ??? */
void InstrumentPropertiesDialog::languageChange() {
}




/**
 *
 */
void InstrumentPropertiesDialog::loadSample() {
	int nLine = 0;
	InstrumentList *instrList = (HydrogenApp::getInstance())->getSong()->getInstrumentList();
	for (uint i = 0; i < instrList->getSize(); i++) {
		Instrument *instr = instrList->get(i);
		if (instr == instrument) {
			nLine = i;
		}
	}

	if (nLine == -1 ) {
		cerr << "InstrumentPropertiesDialog::loadSample Error nLine == -1" << endl;
		return;
	}

	(HydrogenApp::getInstance())->loadNewInstrument( nLine );


	// update the drumkit text
	string drumkitName = instrument->getDrumkitName();
	if (drumkitName == "" ) {
		drumkitLbl->setText( QString( "External sample" ) );
	}
	else {
		drumkitLbl->setText( QString( drumkitName.c_str() ) );
	}
	okBtn->setEnabled(true);


	sampleFilenameTxt->setText(QString((instrument->getSample()->getFilename()).c_str()));

}


