/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: SongEditor.h,v 1.25 2004/02/25 13:29:42 comix Exp $
 *
 */

#ifndef SONG_EDITOR_H
#define SONG_EDITOR_H

#include "qwidget.h"
#include "qpixmap.h"
#include "qscrollview.h"
#include "qvbox.h"
#include "qpopupmenu.h"

#include <string>
using std::string;

#include "config.h"

#include "lib/EngineListener.h"
#include "lib/Object.h"

#include "HydrogenApp.h"
#include "Button.h"
#include "PatternPropertiesDialog.h"
#include "SongPropertiesDialog.h"

class SongEditor;
class SongEditorPatternList;
class SongEditorPositionRuler;

/**
 * Song Editor panel
 */
class SongEditorPanel : public QWidget, public EngineListener, public Object
{
	Q_OBJECT

	public:
		SongEditorPanel( QWidget *parent );
		~SongEditorPanel();

		void updateAll();
	public slots:
		void contentsMove( int x, int y );
		void newPatBtnClicked( Button* );
		void songBtnClicked( Button* );
		void upBtnClicked( Button* );
		void downBtnClicked( Button* );
		void songLoopBtnClicked(Button* ref);

		void songPopup_songProperties();
		void songPopup_clearSequence();
		void songPopup_deleteAllPatterns();

	private:
		uint m_nInitialWidth;
		uint m_nInitialHeight;

		QScrollView* sv1;
		QScrollView* sv2;
		QScrollView* sv3;

		SongEditor *songEditor;
		SongEditorPatternList *songEditorPatternList;
		SongEditorPositionRuler *songEditorPositionRuler;

		Button *upBtn;
		Button *downBtn;

		Button *songBtn;
		QPopupMenu *songPopup;

		ToggleButton *songLoopBtn;

		virtual void patternChanged();
		void customEvent( QCustomEvent *ev );

		void resizeEvent ( QResizeEvent *ev );

};




/**
 * Song editor
 */
class SongEditor : public QWidget, public EngineListener, public Object
{
	Q_OBJECT

	public:
		SongEditor( QWidget *parent );
		~SongEditor();

		void updateEditor();
		void createBackground();

	private:
		uint gridWidth;
		uint gridHeight;
		static const uint maxPatternSequence = 300;
		uint initialWidth;
		uint initialHeight;
		bool changed;
		bool sequenceChanged;
		QPixmap temp;
		QPixmap background;
		QPixmap sequence;

		void mousePressEvent(QMouseEvent *ev);
		void paintEvent(QPaintEvent *ev);
		void drawSequence();
		void drawPattern( int pos, int number );

};




/**
 * Song editor pattern list
 */
class SongEditorPatternList : public QWidget, public EngineListener, public Object
{
	Q_OBJECT

	public:
		SongEditorPatternList( QWidget *parent );
		~SongEditorPatternList();

		void updateEditor();
		void createBackground();
		int getSelectedPatternPos() {	return nSelectedPattern;	}

	public slots:
		void patternPopup_edit();
		void patternPopup_properties();
		void patternPopup_delete();
		void patternPopup_copy();


	private:
		uint m_nGridHeight;
		uint m_nWidth;
		static const uint initialHeight = 10;
		bool changed;
		QPixmap temp;
		QPixmap background;
		int nSelectedPattern;

		QPopupMenu *patternPopup;

		void mousePressEvent( QMouseEvent *ev );
		void mouseDoubleClickEvent( QMouseEvent *ev );
		void paintEvent( QPaintEvent *ev );

};



class SongEditorPositionRuler : public QWidget, public Object
{
	Q_OBJECT

	public:
		SongEditorPositionRuler( QWidget *parent );
		~SongEditorPositionRuler();

		void updateRuler();
		void createBackground();

	public slots:
		void updatePosition();

	private:
		QTimer *m_pTimer;
		static const uint gridWidth = 16;
		static const uint maxPatternSequence = 300;
		static const uint initialWidth = maxPatternSequence * gridWidth;
		static const uint height = 15;

		bool changed;
		QPixmap temp;
		QPixmap background;
		QPixmap tickPosition;

		void mousePressEvent( QMouseEvent *ev );
		void paintEvent( QPaintEvent *ev );

};

#endif
