/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: main.cpp,v 1.40 2004/02/13 17:15:27 comix Exp $
 *
 */

#include <qapplication.h>
#include <qfont.h>
#include <qstring.h>
#include <qtextcodec.h>
#include <qtranslator.h>

#include <getopt.h>


#include "SplashScreen.h"
#include "lib/Hydrogen.h"
#include "Globals.h"
#include "HydrogenApp.h"

void showInfo();
void showUsage();



#define HAS_ARG 1
static struct option long_opts[] = {
        {"song", HAS_ARG, NULL, 's'},
        {"version", 0, NULL, 'v'},
        {"nosplash", 0, NULL, 'n'},
	{"verbose", 0, NULL, 'V'},
	{"help", 0, NULL, 'h'},
        {0, 0, 0, 0},
};

#define NELEM(a) ( sizeof(a)/sizeof((a)[0]) )


/**
 * Main
 */
int main(int argc, char *argv[]) {
	string songFilename = "";
	bool bNoSplash = false;

	// Options...

	char *cp;
	struct option *op;
	char opts[NELEM(long_opts) * 2 + 1];

	/* Build up the short option string */
        cp = opts;
        for (op = long_opts; op < &long_opts[NELEM(long_opts)]; op++) {
                *cp++ = op->val;
                if (op->has_arg)
                        *cp++ = ':';
        }

	/* Deal with the options */
	int c;
	for (;;) {
		c = getopt_long(argc, argv, opts, long_opts, NULL);
		if (c == -1)
			break;

		switch(c) {
			case 's':
				songFilename = optarg;
				break;

			case 'v':
				cout << VERSION << endl;
				exit(0);
				break;

			case 'V':
				Object::useVerboseLog( true );
				break;

			case 'n':
				bNoSplash = true;
				break;

			case 'h':
			case '?':
				showInfo();
				showUsage();
				exit(0);
				break;
		}
	}
#ifdef DEBUG_MESSAGES
	Object::useVerboseLog( true );
#endif


	showInfo();

	QApplication a(argc, argv);
	PreferencesMng *pref = PreferencesMng::getInstance();
	QString family = ( pref->getApplicationFontFamily() ).c_str();
	a.setFont( QFont( family, pref->getApplicationFontPointSize() ) );

	QTranslator tor( 0 );
	QString sTranslationFile = QString("hydrogen.") + QTextCodec::locale();
	QString sLocale = QTextCodec::locale();
	if ( sLocale != "C") {
		QString sTranslationPath = "hydrogen_gui/i18n";
		QString total = sTranslationPath + "/" + sTranslationFile + ".qm";

		bool bTransOk = tor.load( total, "." );
		if ( bTransOk ) {
			cout << "Using locale: " << sTranslationPath << "/" << sTranslationFile << endl;
		}
		else {
			sTranslationPath = QString(IMG_PATH) + "/i18n";
			total = sTranslationPath + "/" + sTranslationFile + ".qm";
			bTransOk = tor.load( total, "." );
			if (bTransOk) {
				cout << "Using locale: " << sTranslationPath << "/" << sTranslationFile << endl;
			}
			else {
				cerr << "Warning: no locale found: " << sTranslationPath << "/" << sTranslationFile << endl;
			}
		}
/*
		Introduced with QT3.1 :(
		if (tor.isEmpty()) {
			cerr << "Warning: error loading locale: " << total << endl;
		}
*/
	}
	a.installTranslator( &tor );

	string sStyle = pref->getQTStyle();
	if (sStyle != "" ) {
		a.setStyle( QString( sStyle.c_str() ) );
	}


	SplashScreen *splash = new SplashScreen();

	if (bNoSplash) {
		splash->hide();
	}
	else {
		splash->show();
	}


	a.setMainWidget( splash );

	MainForm *mainForm = new MainForm( &a, songFilename );

	mainForm->show();

	a.exec();

	// destroy splash screen
	delete splash;
	splash = NULL;


	delete mainForm;
	mainForm = NULL;

	delete pref;
	pref = NULL;

//	if ( Object::isUsingVerboseLog() ) {
		int nObj = Object::getNObjects();
		if (nObj != 0) {
			Object::printObjectMap();
			std::cout << std::endl << std::endl << nObj << " alive objects" << std::endl << std::endl;
		}
//	}
	cout << endl << "Bye..." << endl;

	return 0;
}



/**
 * Show some information
 */
void showInfo() {
	cout << endl << "Hydrogen " << VERSION << " [" << __DATE__"] - Copyright 2002-2004 Alessandro Cominu" << endl;
	cout << "Compiled modules: " + string(COMPILED_FEATURES) << endl;

	if ( Object::isUsingVerboseLog() ) {
		cout << "Verbose log mode = active" << endl;
	}

	cout << endl;
	cout << "Hydrogen comes with ABSOLUTELY NO WARRANTY" << endl;
	cout << "This is free software, and you are welcome to redistribute it" << endl;
	cout << "under certain conditions. See the file COPYING for details" << endl;
	cout << endl;
}



/**
 * Show the correct usage
 */
void showUsage() {
	cout << "Usage: hydrogen [-v] [-h] -s file" << endl;
	cout << "   -s, --song FILE - Load a song (*.h2song) at startup" << endl;
	cout << "   -n, --nosplash - Hide splash screen" << endl;
	cout << "   -V, --verbose - Print a lot of debugging info" << endl;
	cout << "   -v, --version - Show version info" << endl;
	cout << "   -h, --help - Show this help message" << endl;
}



