/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: DiskWriterDriver.cpp,v 1.11 2004/02/27 13:18:07 comix Exp $
 *
 */
#include "DiskWriterDriver.h"

DiskWriterDriver::DiskWriterDriver(audioProcessCallback processCallback) : GenericDriver( "DiskWriterDriver" )
{
	infoLog("INIT");
	this->processCallback = processCallback;
}



DiskWriterDriver::~DiskWriterDriver() {
	infoLog("DESTROY");
}



int DiskWriterDriver::init(uint nBufferSize)
{
	infoLog( "init, " + toString(nBufferSize) + " samples" );
	this->bufferSize = nBufferSize;
	out_L = new float[nBufferSize];
	out_R = new float[nBufferSize];
	return 0;
}

//-----------------------------------------------------------------------------
/**
 * Connect
 *
 * return 0: Ok
 */
int DiskWriterDriver::connect() {
	infoLog( "[connect]" );
	PreferencesMng *preferencesMng = PreferencesMng::getInstance();

	// always rolling, no user interaction
	m_transport.m_status = TransportInfo::ROLLING;


	int bits = 16;
	int sampleRate = preferencesMng->getSampleRate();

	// File Open
	AFfilesetup outputSetup = afNewFileSetup();
	afInitFileFormat(outputSetup, AF_FILE_WAVE);
	afInitSampleFormat (outputSetup, AF_DEFAULT_TRACK, AF_SAMPFMT_TWOSCOMP, bits);
	afInitRate(outputSetup, AF_DEFAULT_TRACK, sampleRate);
	afInitChannels(outputSetup, AF_DEFAULT_TRACK, 2);

//	filename += ".wav";
	outputFile = afOpenFile(filename.c_str(), "w", outputSetup);

	afFreeFileSetup(outputSetup);

#if defined(i386) || defined(alpha)
	afSetVirtualByteOrder(outputFile, AF_DEFAULT_TRACK, AF_BYTEORDER_LITTLEENDIAN);
#else
	afSetVirtualByteOrder(outputFile, AF_DEFAULT_TRACK, AF_BYTEORDER_BIGENDIAN);
#endif

	saveBuffer = new short[bufferSize * 2];

	while (processCallback(bufferSize, NULL) == 0) {
		// process...
		for (uint i = 0; i < bufferSize; i++) {
			saveBuffer[i * 2] = (short)(out_L[i] * 32768.0);
			saveBuffer[i * 2 + 1] = (short)(out_R[i] * 32768.0);
		}
		afWriteFrames(outputFile, AF_DEFAULT_TRACK, saveBuffer, bufferSize);

		if ((m_transport.m_nFrames % 65536) == 0) {
			infoLog( "frames: " + toString(m_transport.m_nFrames) );
		}
	}

	delete[] saveBuffer;
	saveBuffer = NULL;


	return 0;
}




/// disconnect
void DiskWriterDriver::disconnect() {
	infoLog( "[disconnect]" );
	afCloseFile(outputFile);
	delete [] out_L;
	out_L = NULL;

	delete [] out_R;
	out_R = NULL;
}




uint DiskWriterDriver::getBufferSize() {
	return bufferSize;
}




uint DiskWriterDriver::getSampleRate() {
	PreferencesMng *preferencesMng = PreferencesMng::getInstance();
	return preferencesMng->getSampleRate();
}


float* DiskWriterDriver::getOut_L()
{
	return out_L;
}


float* DiskWriterDriver::getOut_R()
{
	return out_R;
}


void DiskWriterDriver::play()
{
	m_transport.m_status = TransportInfo::ROLLING;
}

void DiskWriterDriver::stop()
{
	m_transport.m_status = TransportInfo::STOPPED;
}

void DiskWriterDriver::locate( unsigned long nFrame )
{
	infoLog( "[locate] " + toString(nFrame) );
	m_transport.m_nFrames = nFrame;
}


void DiskWriterDriver::updateTransportInfo()
{
//	errorLog( "[updateTransportInfo] not implemented yet" );
	// not used
}

void DiskWriterDriver::setBpm(float fBPM)
{
	infoLog( "[setBpm] " + toString(fBPM) );
	m_transport.m_nBPM = fBPM;
}
