/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: JackDriver.h,v 1.6 2004/01/26 11:16:58 comix Exp $
 *
 */

#include "config.h"

// check if jack support is enabled
#ifdef JACK_SUPPORT


#ifndef JACK_DRIVER_H
#define JACK_DRIVER_H

#include <pthread.h>
#include <jack/jack.h>
#include <jack/transport.h>

#include "Hydrogen.h"
#include "GenericDriver.h"
#include "PreferencesMng.h"
using std::cout;
using std::endl;

//----------------------------------------------------------------------------
/**
 * Jack (Jack Audio Connection Kit) server driver
 */
class JackDriver : public GenericDriver {
	public:
		jack_client_t *client;

		/** Constructor */
		JackDriver(JackProcessCallback processCallback);

		/** Destructor */
		~JackDriver();

		int connect();

		void disconnect();

		void deactivate();

		uint getBufferSize();

		uint getSampleRate();


		jack_transport_state_t getTransportState() {	return m_transportState;	}
		jack_position_t getTransportPos() {	return m_transportPos;	}

		void setTrackOuts(bool flag) { track_out_flag = flag;}
		bool getTrackOuts() { return track_out_flag;}

		void setConnectDefaults(bool flag) { connect_out_flag = flag;}
		bool getConnectDefaults() { return connect_out_flag;}

		float* getOut_L();
		float* getOut_R();
		float* getTrackOut_L(uint nTrack);
		float* getTrackOut_R(uint nTrack);

		int init(uint bufferSize);

		virtual void play();
		virtual void stop();
		virtual void locate( unsigned long nFrame );
		virtual void updateTransportInfo();
		virtual void setBpm(float fBPM);

	private:
		JackProcessCallback processCallback;
		jack_port_t *output_port_1;
		jack_port_t *output_port_2;
		string output_port_name_1;
		string output_port_name_2;
		jack_port_t *track_output_ports_L[MAX_TRACKS];
		jack_port_t *track_output_ports_R[MAX_TRACKS];

		jack_transport_state_t m_transportState;
		jack_position_t m_transportPos;

		bool track_out_flag;
		bool connect_out_flag;
};


#endif // JACK_SUPPORT

#endif

