/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: Sample.h,v 1.3 2004/01/26 11:16:59 comix Exp $
 *
 */

#ifndef SAMPLE_BUFFER_H
#define SAMPLE_BUFFER_H

#include <iostream>
using std::endl;
using std::cout;
using std::cerr;

#include <string>
using std::string;
#include <audiofile.h>

#include "Globals.h"
#include "Object.h"
#include "PreferencesMng.h"


//----------------------------------------------------------------------------
/**
 * Audio sample.
 */
class Sample : public Object{
	private:
		/** name of the audio sample. */
		string filename;

		/** Total number of frames int this sample. */
		uint nFrames;

		/** Left channel data */
		float *dataL;

		/** Right channel data */
		float *dataR;


	public:
		/** Constructor */
		Sample(uint nFrames, string filename);

		/** Destructor */
		~Sample();

		void setData_L(float *left);
		void setData_R(float *right);

		float* getData_L();
		float* getData_R();

		/** Restituisce il numero di samples. */
		uint getNFrames(){	return nFrames;	}

		/** Restituisce il numero di bytes del sample audio ( due canali ) */
		uint getNBytes(){	return nFrames * 2 * STEREO;	}

		/** Restituisce il filename dell'AudioSample. */
		string getFilename(){       return filename;    }

		void setFilename(string filename) {	this->filename = filename;	}

		/** Load a sample from disk */
		static Sample* load(string filename);

		/** \todo write implementation */
		void save(string filename);
};


#endif
