/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: Fader.h,v 1.15 2004/05/03 14:02:20 comix Exp $
 *
 */


#ifndef FADER_H
#define FADER_H

#include <string>
#include <iostream>

#include "config.h"
#include "qwidget.h"
#include "qpixmap.h"
#include "qpainter.h"

#include "lib/Object.h"

///
/// Fader and VuMeter widget
///
class Fader : public QWidget, public Object 
{
	Q_OBJECT

	public:
		Fader(QWidget * parent, bool bWithoutKnob = false);
		~Fader();

		void setValue(uint newValue);
		uint getValue();

		void updateFader();

		void setPeak_L( float peak );
		float getPeak_L() {	return peakValue_L;	}

		void setPeak_R( float peak );
		float getPeak_R() {	return peakValue_R;	}

		void mousePressEvent(QMouseEvent *ev);
		void mouseMoveEvent(QMouseEvent *ev);
		void paintEvent(QPaintEvent *ev);

	signals:
		void valueChanged(Fader *ref);

	private:
		bool m_bWithoutKnob;
		float peakValue_L;
		float peakValue_R;

		uint value;

		QPixmap temp;
		QPixmap back;
		QPixmap leds;
		QPixmap knob;

		bool changed;

};




class PanFader : public QWidget, public Object
{
	Q_OBJECT

	public:
		PanFader(QWidget *parent);
		~PanFader();

		void updateFader();

		void setValue(float newValue);
		float getValue() {	return value;	}

	signals:
		void valueChanged(PanFader *ref);

	private:
		float value;

		QPixmap back;
		QPixmap temp;

		bool changed;

		void paintEvent(QPaintEvent *ev);
		void mousePressEvent(QMouseEvent *ev);
		void mouseMoveEvent(QMouseEvent *ev);

};



class Knob : public QWidget, public Object
{
	Q_OBJECT
	public:
		Knob( QWidget* parent );
		~Knob();

		void setValue( float fValue );
		float getValue() {	return m_fValue;	}

		void updateKnob();


	signals:
		void valueChanged(Knob *ref);

	private:
		static QPixmap* m_background;
		QPixmap m_temp;

		bool m_bChanged;
		int m_nWidgetWidth;
		int m_nWidgetHeight;

		float m_fValue;
		float m_fMousePressValue;
		float m_fMousePressY;

		void paintEvent(QPaintEvent *ev);
		void mousePressEvent(QMouseEvent *ev);
		void mouseReleaseEvent( QMouseEvent *ev );
		void mouseMoveEvent(QMouseEvent *ev);
};



#endif
