/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: Sample.h,v 1.10 2004/05/26 13:12:12 comix Exp $
 *
 */

#ifndef SAMPLE_BUFFER_H
#define SAMPLE_BUFFER_H

#include <iostream>
using std::endl;
using std::cout;
using std::cerr;

#include <string>
using std::string;

#include "Globals.h"
#include "Object.h"


///
/// Audio sample.
///
class Sample : public Object{
	public:
		Sample(uint nFrames, string sFilename);
		~Sample();

		void setData_L( float *pData ) {	m_pData_L = pData;	}
		float* getData_L() {	return m_pData_L;	}
		
		void setData_R( float *pData ) {	m_pData_R = pData;	}
		float* getData_R() {	return m_pData_R;	}

		/// Returns the frames number
		uint getNFrames(){	return m_nFrames;	}

		/// Returns the bytes number ( 2 channels )
		uint getNBytes(){	return m_nFrames * sizeof(float) * STEREO;	}

		/// Returns the filename associated with this sample
		string getFilename(){       return m_sFilename;    }

		void setFilename(string sFilename) {	m_sFilename = sFilename;	}

		void setSampleRate(uint nSampleRate) {	m_nSampleRate = nSampleRate;	}
		uint getSampleRate() {	return m_nSampleRate;	}
		
		/// Loads a sample from disk
		static Sample* load(string sFilename);
		
		/// write the sample to disk
		void save(string sFilename);
	
	private:
		string m_sFilename;	///< filename associated with this sample

		uint m_nFrames;	///< Total number of frames in this sample.

		uint m_nSampleRate;	///< samplerate for this sample
		
		float *m_pData_L;	///< Left channel data
		float *m_pData_R;	///< Right channel data
		
		/// loads a wave file
		static Sample* loadWave( string sFilename );
		
		/// loads a FLAC file
		static Sample* loadFLAC( string sFilename );
};


#endif
