/*
 * Hydrogen
 * Copyright(c) 2002-2005 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://www.hydrogen-music.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: AboutDialog.cpp,v 1.13 2005/05/23 12:12:38 comix Exp $
 *
 */

#include "AboutDialog.h"
#include "Skin.h"
#include "config.h"

#include <qpixmap.h>
#include <qlabel.h>
#include <qtextbrowser.h>

using namespace std;

AboutDialog::AboutDialog(QWidget* parent) : AboutDialog_UI(parent, 0, false) {
	setCaption( tr( "About" ) );
	setIcon( QPixmap( Skin::getImagePath().c_str() + QString( "/icon32.png") ) );

	setMinimumSize( width(), height() );
	setMaximumSize( width(), height() );
	move( 240, 100 );

	QString about;
	about += "<center><b>Hydrogen Drum Machine " + QString(VERSION) + "</b><br>";
	about += tr( "<i>Compiled modules: %1</i></center>").arg(COMPILED_FEATURES);
	about += "<b>HomePage</b><br>";
	about += "<a href=\"http://www.hydrogen-music.org\">http://www.hydrogen-music.org</a><br><br>";
	about += tr( "<b>Project page</b><br>");
	about += "<a href=\"http://www.hydrogen-music.org\">http://sourceforge.net/projects/hydrogen</a><br><br>";
	about += tr( "<b>Mailing lists:</b><br>");
	about += "<a href=\"http://lists.sourceforge.net/lists/listinfo/hydrogen-announce\">http://lists.sourceforge.net/lists/listinfo/hydrogen-announce</a><br>";
	about += "<a href=\"http://lists.sourceforge.net/lists/listinfo/hydrogen-devel\">http://lists.sourceforge.net/lists/listinfo/hydrogen-devel</a><br>";
	aboutTxt->setText( about );

	QString authors;
	authors += "<p>Alex Cominu (aka Comix)";
	authors += "<i><ul>comix-at-users.sourceforge.net<br>";
	authors += tr( "Maintainer, main coder<br></ul></i></p>");

	authors += "<p>Artemiy Pavlov (aka Artemio)";
	authors += "<i><ul>www.artemiolabs.com<br>";
	authors += tr( "Drum kits, demo patterns, web site<br></ul></i></p>");

	authors += "<p>Willie Sippel";
	authors += "<i><ul>willie-at-zeitgeistmedia.net<br>";
	authors += tr( "GUI graphics, coding<br></ul></i></p>");

	authors += "<p>Emiliano Grilli (aka Emillo)";
	authors += "<i><ul>www.emillo.net<br>";
	authors += tr( "Drum kits, demo patterns<br></ul></i></p>");
	authors += "<br>";

	authors += "<b>Thanks to:</b><br>";

	authors += "<p>Alexandre Prokoudine";
	authors += tr( "<i><ul>Russian translation<br></ul></i></p>");

	authors += "<p>Benjamin Flaming";
	authors += tr( "<i><ul>Jack patches, bug fix<br></ul></i></p>");

	authors += "<p>Carlo Impagliazzo aka Truijllo<br>";
	authors += tr( "<i><ul>Testing, ideas..</ul></i></p>");

	authors += "<p>Chris Wareham<br>";
	authors += tr( "<i><ul>NetBSD patch</ul></i></p>" );

	authors += "<p>Christian Vorhof<br>";
	authors += tr( "<i><ul>Interface design concept</ul></i></p>" );

	authors += "<p>Daniel Tonda Castillo<br>";
	authors += tr( "<i><ul>Spanish manual</ul></i></p>" );

	authors += "<p>Dave Phillips<br>";
	authors += tr( "<i><ul>Bug reports, ideas</ul></i></p>" );

	authors += "<p>Derrick Karpo<br>";
	authors += tr( "<i><ul>Patches, testing</ul></i></p>" );

	authors += "<p>Ede Wolf<br>";
	authors += tr( "<i><ul>Faq, testing</ul></i></p>" );

	authors += "<p>Elizeu Santos-Neto<br>";
	authors += tr( "<i><ul>Portuguese(Brazil) translation</ul></i></p>" );

	authors += "<p>Francesco Cabras<br>";
	authors += tr( "<i><ul>Patches, testing</ul></i></p>" );

	authors += "<p>Gene<br>";
	authors += tr( "<i><ul>Patches, testing</ul></i></p>" );

	authors += "<p>Jesse Chappel<br>";
	authors += tr( "<i><ul>Jack patches</ul></i></p>" );

	authors += "<p>Jonas Melzer<br>";
	authors += tr( "<i><ul>German manual</ul></i></p>" );

	authors += "<p>Jonathan Dempsey<br>";
	authors += tr( "<i><ul>Mac OSX port</ul></i></p>" );

	authors += "<p>Kevin Dahan aka Unet<br>";
	authors += tr( "<i><ul>French translation</ul></i></p>" );

	authors += "<p>Lee Revell<br>";
	authors += tr( "<i><ul>Patches</ul></i></p>" );

	authors += "<p>Samuel Mimram<br>";
	authors += tr( "<i><ul>Packages</ul></i></p>" );

	authors += "<p>Sergio Gil Perez de la Manga<br>";
	authors += tr( "<i><ul>Spanish translation</ul></i></p>" );

	authors += "<p>Antonio Piraino<br>";
	authors += tr( "<i><ul>Italian manual</ul></i></p>" );

	authors += "<p>Torben Hohn<br>";
	authors += tr( "<i><ul>Bug fix, test</ul></i></p>" );


	authorsTxt->setText( authors );

	string logo_path = Skin::getImagePath() ;
	logo_path.append("/about/aboutLogo.png");

	logoLabel->setPixmap(QPixmap(logo_path.c_str()));
}




/**
 * Destructor
 */
AboutDialog::~AboutDialog() {
}




/**
 * Close the dialog
 */
void AboutDialog::okBtnClicked() {
	accept();
}

