/*
 * Hydrogen
 * Copyright(c) 2002-2005 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://www.hydrogen-music.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: SongEditor.h,v 1.19 2005/05/01 19:51:23 comix Exp $
 *
 */

#ifndef SONG_EDITOR_H
#define SONG_EDITOR_H


#include <string>
using std::string;
#include <vector>
using std::vector;

#include <qwidget.h>
#include <qpixmap.h>
#include <qpopupmenu.h>

#include "lib/Object.h"
#include "../EventListener.h"

class Button;
class ToggleButton;
class SongEditor;
class SongEditorPatternList;
class SongEditorPositionRuler;


static const int SONG_EDITOR_GRID_WIDTH = 16;

///
/// Song editor
///
class SongEditor : public QWidget, public Object
{
	Q_OBJECT

	public:

		SongEditor( QWidget *parent );
		~SongEditor();

		void updateEditor();
		void createBackground();

	private:
		unsigned m_nGridHeight;
		static const unsigned m_nMaxPatternSequence = 400;
		bool m_bChanged;
		bool m_bSequenceChanged;
		bool m_bIsMoving;
		bool m_bIsCtrlPressed;

		QPixmap m_backgroundPixmap;
		QPixmap m_sequencePixmap;

		vector<QPoint> m_selectedCells;
		vector<QPoint> m_movingCells;
		QPoint m_clickPoint;	// Usato come riferimento per le operazioni di spostamento
		bool m_bShowLasso;
		QRect m_lasso;

		virtual void mousePressEvent(QMouseEvent *ev);
		virtual void mouseReleaseEvent(QMouseEvent *ev);
		virtual void mouseMoveEvent(QMouseEvent *ev);
		virtual void keyPressEvent (QKeyEvent *ev);
		virtual void paintEvent(QPaintEvent *ev);

		void drawSequence();
		void drawPattern( int pos, int number );
};




///
/// Song editor pattern list
///
class SongEditorPatternList : public QWidget, public Object
{
	Q_OBJECT

	public:
		SongEditorPatternList( QWidget *parent );
		~SongEditorPatternList();

		void updateEditor();
		void createBackground();

	public slots:
		void patternPopup_edit();
		void patternPopup_properties();
		void patternPopup_delete();
		void patternPopup_copy();


	private:
		uint m_nGridHeight;
		uint m_nWidth;
		static const uint m_nInitialHeight = 10;
		bool m_bChanged;

		QPixmap m_labelBackgroundLight;
		QPixmap m_labelBackgroundDark;
		QPixmap m_labelBackgroundSelected;
		QPixmap m_backgroundPixmap;
		QPixmap m_playingPattern_on_Pixmap;
		QPixmap m_playingPattern_off_Pixmap;

		QPopupMenu *m_pPatternPopup;

		virtual void mousePressEvent( QMouseEvent *ev );
		virtual void mouseDoubleClickEvent( QMouseEvent *ev );
		virtual void paintEvent( QPaintEvent *ev );
};



class SongEditorPositionRuler : public QWidget, public Object
{
	Q_OBJECT

	public:
		SongEditorPositionRuler( QWidget *parent );
		~SongEditorPositionRuler();

		void createBackground();

	public slots:
		void updatePosition();

	private:
		QTimer *m_pTimer;
		static const uint m_nGridWidth = 16;
		static const uint m_nMaxPatternSequence = 400;
		static const uint m_nInitialWidth = m_nMaxPatternSequence * m_nGridWidth;
		static const uint m_nHeight = 25;

		bool m_bChanged;
		QPixmap m_tempPixmap;
		QPixmap m_backgroundPixmap;
		QPixmap m_tickPositionPixmap;

		virtual void mouseMoveEvent(QMouseEvent *ev);
		virtual void mousePressEvent( QMouseEvent *ev );
		virtual void paintEvent( QPaintEvent *ev );
};


#endif
