/* This is an example HY-PHY Batch File.

	In this file, we will illustrate how to define category
	variables sampled from continuous distribution to model rate heterogeneity
	and spatially correlated via a hidden markov chain
	
   Sergei L. Kosakovsky Pond and Spencer V. Muse 
   June 2001. 
*/

/* 1.
	Refer to definition1.bf and definition2.bf for 
	examples on how to define a distribution of rates.
	To introduce space correlation via a hidden markov model
	we need to specify an additional parameter in the call
	to "category": the transition matrix for the HMM.
	The following example defines a simple HMM model
	following the paper of Felsenstein and Churchill (1996 J Mol Evol).
*/

#include "displayFunction.bf";

global lambda = .5;
lambda :< 1;

hiddenMarkovM = {10,10};
hiddenMarkovF = {10,1};

for (k=0; k<10; k=k+1)
{
	hiddenMarkovM [k][k] := lambda+(1-lambda)/10;
	hiddenMarkovF [k][1] := 1/10;
	
	for (l=k+1;l<10;l=l+1)
	{
		hiddenMarkovM [k][l] := (1-lambda)/10;
		hiddenMarkovM [l][k] := (1-lambda)/10;
	}
}


Model HMM = (hiddenMarkovM,hiddenMarkovF,false);

global alpha = 1;
alpha:>0.01;alpha:<100;

category catVar =  (10,		/* number of rates */
					hiddenMarkovF,  /* probs. of rates */
					MEAN,	/* sampling method */
					GammaDist(_x_,alpha,alpha), /* density */
					CGammaDist(_x_,alpha,alpha), /*CDF*/
					0, 				   /*left bound*/
					1e25, 			   /*right bound*/
					CGammaDist(_x_,alpha+1,alpha),
						/* "antiderivative" of x f(x) */
					HMM /* transition matrix for the hidden Markov model */
				   );
				   
GetInformation (catInfo,catVar);
catInfo = echoCatVar (catInfo);
