#define _XOPEN_SOURCE

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <crypt.h>

#include "config.h"

int main(int argc, char *argv[])
{
#ifdef HAVE_CRYPT
    char *encrypted;

    if ( argc < 2 ) {
        fputs("Usage: iacd_passwd <password>\n", stderr);
        exit(1);
    }

    if ( !(encrypted = crypt(argv[1], IAC_CRYPT_SALT)) ) {
        fputs("crypt() is not supported on your system.\n", stderr);
        exit(1);
    }

    puts(encrypted);
    puts("\n");

#else
    fputs("iacd was compiled without crypt support.\n", stderr);
    exit(1);
#endif

    return 0;
}
