#ifndef TI_TIMER_H_
#define TI_TIMER_H_

#include "config.h"

#include <sys/time.h>
#include <time.h>

typedef struct ti_timer_node_s
{
	struct ti_timer_node_s *ti_next;
	struct timeval ti_interval;
	void (*ti_func)(const char *);
	char *ti_msg;

} ti_timer_node_t;
	
int ti_add_callback(struct timeval *, void (*func)(const char *), const char *msg);
void ti_get_timeout(struct timeval *);
void ti_call(void);
void ti_dump(void);

#endif
