/*
 * SpanDSP - a series of DSP components for telephony
 *
 * v17rx.c - ITU V.17 modem receive part
 *
 * Written by Steve Underwood <steveu@coppice.org>
 *
 * Copyright (C) 2004 Steve Underwood
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: v17rx.c,v 1.47 2006/05/22 12:47:24 steveu Exp $
 */

/*! \file */

/* THIS IS A WORK IN PROGRESS - KIND OF FUNCTIONAL, BUT NOT ROBUST! */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <inttypes.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "spandsp/telephony.h"
#include "spandsp/logging.h"
#include "spandsp/async.h"
#include "spandsp/power_meter.h"
#include "spandsp/arctan2.h"
#include "spandsp/complex.h"
#include "spandsp/dds.h"
#include "spandsp/complex_filters.h"

#include "spandsp/v29rx.h"
#include "spandsp/v17rx.h"

/* Segments of the training sequence */
#define V17_TRAINING_SEG_1_LEN          256
#define V17_TRAINING_SEG_2_LEN          2976
#define V17_TRAINING_SHORT_SEG_2_LEN    38
#define V17_TRAINING_SEG_3_LEN          64
#define V17_TRAINING_SEG_4A_LEN         15
#define V17_TRAINING_SEG_4_LEN          48

#define V17_BRIDGE_WORD                 0x8880

#define EQUALIZER_DELTA                 0.21f

enum
{
    TRAINING_STAGE_NORMAL_OPERATION = 0,
    TRAINING_STAGE_SYMBOL_ACQUISITION,
    TRAINING_STAGE_LOG_PHASE,
    TRAINING_STAGE_SHORT_WAIT_FOR_CDBA,
    TRAINING_STAGE_WAIT_FOR_CDBA,
    TRAINING_STAGE_TRAIN_ON_CDBA,
    TRAINING_STAGE_SHORT_TRAIN_ON_CDBA_AND_TEST,
    TRAINING_STAGE_TRAIN_ON_CDBA_AND_TEST,
    TRAINING_STAGE_BRIDGE,
    TRAINING_STAGE_TCM_WINDUP,
    TRAINING_STAGE_TEST_ONES,
    TRAINING_STAGE_PARKED
};

/* Raised root cosine pulse shaping; Beta = 0.5; 4 symbols either
   side of the centre. We cannot simplify this by using only half
   the filter, as each variant are each skewed by n/PULSESHAPER_COEFF_SETS
   of a sample. Only one is symmetric. */
#define PULSESHAPER_GAIN        10.00736638f
#define PULSESHAPER_COEFF_SETS  192
static const complex_t pulseshaper[PULSESHAPER_COEFF_SETS][V17RX_FILTER_STEPS] =
{
    {
        {-0.0006054906f, -0.0076934876f},   /* Filter 0 */
        { 0.0036800485f, -0.0011957203f},
        {-0.0058580401f, -0.0095594527f},
        { 0.0088272478f, -0.0088272478f},
        {-0.0070156625f, -0.0042992035f},
        { 0.0051634536f, -0.0158914760f},
        {-0.0145681542f, -0.0011465386f},
        {-0.0064674677f, -0.0408339841f},
        {-0.0136664373f,  0.0056608237f},
        {-0.0772003352f, -0.1062571456f},
        { 0.0857393937f, -0.1003879319f},
        {-0.1385128869f, -0.0705758410f},
        { 0.1555698725f, -0.6479951542f},
        { 1.0773601532f,  0.0000000000f},
        { 0.2515047330f,  1.0475926064f},
        {-0.5937739310f,  0.3025429291f},
        {-0.1009610162f, -0.1182101620f},
        {-0.0775987414f,  0.1068055047f},
        {-0.1213433125f, -0.0502620457f},
        { 0.0023140482f, -0.0146103256f},
        {-0.0412155383f,  0.0032437332f},
        {-0.0045157277f, -0.0138979808f},
        {-0.0142470090f,  0.0087305783f},
        {-0.0058181900f, -0.0058181900f},
        {-0.0065226702f,  0.0106440303f},
        {-0.0106628565f, -0.0034645721f},
        {-0.0003035921f,  0.0038575039f},
    },
    {
        {-0.0005350174f, -0.0067980401f},   /* Filter 1 */
        { 0.0036179827f, -0.0011755538f},
        {-0.0058922384f, -0.0096152592f},
        { 0.0087813723f, -0.0087813723f},
        {-0.0071152571f, -0.0043602352f},
        { 0.0051438801f, -0.0158312350f},
        {-0.0147911442f, -0.0011640883f},
        {-0.0064623452f, -0.0408016420f},
        {-0.0141731548f,  0.0058707129f},
        {-0.0774910884f, -0.1066573331f},
        { 0.0852944499f, -0.0998669696f},
        {-0.1405505661f, -0.0716140904f},
        { 0.1562083221f, -0.6506544882f},
        { 1.0785754919f,  0.0000000000f},
        { 0.2512098584f,  1.0463643655f},
        {-0.5913273989f,  0.3012963588f},
        {-0.0994933220f, -0.1164917128f},
        {-0.0779816184f,  0.1073324898f},
        {-0.1208747844f, -0.0500679750f},
        { 0.0022295424f, -0.0140767766f},
        {-0.0412382036f,  0.0032455170f},
        {-0.0044465975f, -0.0136852198f},
        {-0.0142966471f,  0.0087609966f},
        {-0.0057346411f, -0.0057346411f},
        {-0.0065550592f,  0.0106968845f},
        {-0.0105990212f, -0.0034438307f},
        {-0.0003085935f,  0.0039210527f},
    },
    {
        {-0.0004645441f, -0.0059025926f},   /* Filter 2 */
        { 0.0035559167f, -0.0011553874f},
        {-0.0059264367f, -0.0096710658f},
        { 0.0087354968f, -0.0087354967f},
        {-0.0072148518f, -0.0044212669f},
        { 0.0051243060f, -0.0157709923f},
        {-0.0150141341f, -0.0011816380f},
        {-0.0064572227f, -0.0407692998f},
        {-0.0146798714f,  0.0060806018f},
        {-0.0777818416f, -0.1070575206f},
        { 0.0848495158f, -0.0993460187f},
        {-0.1425882320f, -0.0726523330f},
        { 0.1568467578f, -0.6533137643f},
        { 1.0797908306f,  0.0000000000f},
        { 0.2509149561f,  1.0451360086f},
        {-0.5888808668f,  0.3000497884f},
        {-0.0980256278f, -0.1147732637f},
        {-0.0783644955f,  0.1078594748f},
        {-0.1204062425f, -0.0498738986f},
        { 0.0021450365f, -0.0135432277f},
        {-0.0412608690f,  0.0032473008f},
        {-0.0043774672f, -0.0134724587f},
        {-0.0143462852f,  0.0087914149f},
        {-0.0056510916f, -0.0056510916f},
        {-0.0065874478f,  0.0107497379f},
        {-0.0105351868f, -0.0034230897f},
        {-0.0003135949f,  0.0039846010f},
    },
    {
        {-0.0003940709f, -0.0050071451f},   /* Filter 3 */
        { 0.0034938509f, -0.0011352210f},
        {-0.0059606350f, -0.0097268724f},
        { 0.0086896212f, -0.0086896212f},
        {-0.0073144473f, -0.0044822991f},
        { 0.0051047326f, -0.0157107513f},
        {-0.0152371240f, -0.0011991877f},
        {-0.0064521008f, -0.0407369614f},
        {-0.0151865871f,  0.0062904903f},
        {-0.0780725949f, -0.1074577081f},
        { 0.0844045720f, -0.0988250564f},
        {-0.1446259112f, -0.0736905824f},
        { 0.1574852075f, -0.6559730983f},
        { 1.0810062885f,  0.0000000000f},
        { 0.2506200815f,  1.0439077677f},
        {-0.5864343878f,  0.2988032451f},
        {-0.0965579336f, -0.1130548146f},
        {-0.0787473725f,  0.1083864599f},
        {-0.1199377143f, -0.0496798279f},
        { 0.0020605307f, -0.0130096788f},
        {-0.0412835343f,  0.0032490846f},
        {-0.0043083372f, -0.0132596986f},
        {-0.0143959234f,  0.0088218332f},
        {-0.0055675427f, -0.0055675427f},
        {-0.0066198369f,  0.0108025920f},
        {-0.0104713524f, -0.0034023486f},
        {-0.0003185963f,  0.0040481493f},
    },
    {
        {-0.0003235976f, -0.0041116977f},   /* Filter 4 */
        { 0.0034317848f, -0.0011150545f},
        {-0.0059948338f, -0.0097826797f},
        { 0.0086437457f, -0.0086437457f},
        {-0.0074140420f, -0.0045433308f},
        { 0.0050851585f, -0.0156505086f},
        {-0.0154601149f, -0.0012167374f},
        {-0.0064469783f, -0.0407046192f},
        {-0.0156933046f,  0.0065003796f},
        {-0.0783633481f, -0.1078578956f},
        { 0.0839596378f, -0.0983041055f},
        {-0.1466635904f, -0.0747288318f},
        { 0.1581236571f, -0.6586324323f},
        { 1.0822216272f,  0.0000000000f},
        { 0.2503251791f,  1.0426794109f},
        {-0.5839878557f,  0.2975566747f},
        {-0.0950902394f, -0.1113363655f},
        {-0.0791302584f,  0.1089134570f},
        {-0.1194691862f, -0.0494857572f},
        { 0.0019760247f, -0.0124761289f},
        {-0.0413061997f,  0.0032508684f},
        {-0.0042392070f, -0.0130469375f},
        {-0.0144455615f,  0.0088522515f},
        {-0.0054839935f, -0.0054839935f},
        {-0.0066522260f,  0.0108554462f},
        {-0.0104075179f, -0.0033816076f},
        {-0.0003235976f,  0.0041116977f},
    },
    {
        {-0.0003284768f, -0.0041736941f},   /* Filter 5 */
        { 0.0033683193f, -0.0010944333f},
        {-0.0060281246f, -0.0098370053f},
        { 0.0085958524f, -0.0085958524f},
        {-0.0075123852f, -0.0046035956f},
        { 0.0050640016f, -0.0155853942f},
        {-0.0156828718f, -0.0012342688f},
        {-0.0064402678f, -0.0406622506f},
        {-0.0162074218f,  0.0067133339f},
        {-0.0786464462f, -0.1082475467f},
        { 0.0834926583f, -0.0977573427f},
        {-0.1487248762f, -0.0757791094f},
        { 0.1587593377f, -0.6612802328f},
        { 1.0833886862f,  0.0000000000f},
        { 0.2500192287f,  1.0414050355f},
        {-0.5815324545f,  0.2963055853f},
        {-0.0936404389f, -0.1096388672f},
        {-0.0794934547f,  0.1094133538f},
        {-0.1189896170f, -0.0492871131f},
        { 0.0018928506f, -0.0119509884f},
        {-0.0413190346f,  0.0032518786f},
        {-0.0041701300f, -0.0128343404f},
        {-0.0144908338f,  0.0088799944f},
        {-0.0053995750f, -0.0053995750f},
        {-0.0066830881f,  0.0109058085f},
        {-0.0103421636f, -0.0033603726f},
        {-0.0003284768f,  0.0041736941f},
    },
    {
        {-0.0003333561f, -0.0042356910f},   /* Filter 6 */
        { 0.0033048536f, -0.0010738120f},
        {-0.0060614159f, -0.0098913317f},
        { 0.0085479591f, -0.0085479591f},
        {-0.0076107284f, -0.0046638604f},
        { 0.0050428441f, -0.0155202782f},
        {-0.0159056278f, -0.0012518001f},
        {-0.0064335573f, -0.0406198820f},
        {-0.0167215389f,  0.0069262882f},
        {-0.0789295444f, -0.1086371979f},
        { 0.0830256788f, -0.0972105799f},
        {-0.1507861619f, -0.0768293869f},
        { 0.1593950044f, -0.6639279752f},
        { 1.0845557451f,  0.0000000000f},
        { 0.2497133061f,  1.0401307762f},
        {-0.5790770002f,  0.2950544689f},
        {-0.0921906384f, -0.1079413690f},
        {-0.0798566597f,  0.1099132627f},
        {-0.1185100615f, -0.0490884747f},
        { 0.0018096765f, -0.0114258479f},
        {-0.0413318695f,  0.0032528887f},
        {-0.0041010527f, -0.0126217423f},
        {-0.0145361044f,  0.0089077363f},
        {-0.0053151562f, -0.0053151562f},
        {-0.0067139506f,  0.0109561717f},
        {-0.0102768083f, -0.0033391374f},
        {-0.0003333561f,  0.0042356910f},
    },
    {
        {-0.0003382353f, -0.0042976874f},   /* Filter 7 */
        { 0.0032413878f, -0.0010531907f},
        {-0.0060947066f, -0.0099456573f},
        { 0.0085000658f, -0.0085000658f},
        {-0.0077090716f, -0.0047241252f},
        { 0.0050216871f, -0.0154551638f},
        {-0.0161283837f, -0.0012693313f},
        {-0.0064268467f, -0.0405775134f},
        {-0.0172356561f,  0.0071392425f},
        {-0.0792126425f, -0.1090268491f},
        { 0.0825586992f, -0.0966638172f},
        {-0.1528474477f, -0.0778796645f},
        { 0.1600306851f, -0.6665757757f},
        { 1.0857228041f,  0.0000000000f},
        { 0.2494073556f,  1.0388564008f},
        {-0.5766215991f,  0.2938033795f},
        {-0.0907408283f, -0.1062438594f},
        {-0.0802198648f,  0.1104131716f},
        {-0.1180305061f, -0.0488898364f},
        { 0.0017265024f, -0.0109007073f},
        {-0.0413447044f,  0.0032538988f},
        {-0.0040319757f, -0.0124091451f},
        {-0.0145813767f,  0.0089354791f},
        {-0.0052307377f, -0.0052307377f},
        {-0.0067448127f,  0.0110065340f},
        {-0.0102114540f, -0.0033179025f},
        {-0.0003382353f,  0.0042976874f},
    },
    {
        {-0.0003431146f, -0.0043596843f},   /* Filter 8 */
        { 0.0031779221f, -0.0010325695f},
        {-0.0061279979f, -0.0099999837f},
        { 0.0084521725f, -0.0084521725f},
        {-0.0078074149f, -0.0047843900f},
        { 0.0050005296f, -0.0153900477f},
        {-0.0163511397f, -0.0012868626f},
        {-0.0064201362f, -0.0405351449f},
        {-0.0177497715f,  0.0073521961f},
        {-0.0794957407f, -0.1094165002f},
        { 0.0820917197f, -0.0961170544f},
        {-0.1549087334f, -0.0789299420f},
        { 0.1606663657f, -0.6692235761f},
        { 1.0868898630f,  0.0000000000f},
        { 0.2491014052f,  1.0375820255f},
        {-0.5741661979f,  0.2925522901f},
        {-0.0892910279f, -0.1045463612f},
        {-0.0805830611f,  0.1109130684f},
        {-0.1175509369f, -0.0486911923f},
        { 0.0016433282f, -0.0103755659f},
        {-0.0413575394f,  0.0032549089f},
        {-0.0039628986f, -0.0121965479f},
        {-0.0146266490f,  0.0089632220f},
        {-0.0051463192f, -0.0051463192f},
        {-0.0067756753f,  0.0110568971f},
        {-0.0101460987f, -0.0032966673f},
        {-0.0003431146f,  0.0043596843f},
    },
    {
        {-0.0003478686f, -0.0044200894f},   /* Filter 9 */
        { 0.0031130992f, -0.0010115072f},
        {-0.0061603461f, -0.0100527712f},
        { 0.0084022884f, -0.0084022884f},
        {-0.0079044049f, -0.0048438256f},
        { 0.0049777904f, -0.0153200636f},
        {-0.0165734574f, -0.0013043594f},
        {-0.0064118161f, -0.0404826137f},
        {-0.0182710440f,  0.0075681142f},
        {-0.0797708684f, -0.1097951811f},
        { 0.0816025689f, -0.0955443324f},
        {-0.1569931345f, -0.0799919974f},
        { 0.1612990687f, -0.6718589736f},
        { 1.0880081654f,  0.0000000000f},
        { 0.2487845180f,  1.0362620954f},
        {-0.5717027243f,  0.2912970876f},
        {-0.0878594308f, -0.1028701764f},
        {-0.0809267343f,  0.1113860940f},
        {-0.1170608498f, -0.0484881916f},
        { 0.0015615230f, -0.0098590683f},
        {-0.0413606998f,  0.0032551577f},
        {-0.0038939359f, -0.0119843024f},
        {-0.0146675617f,  0.0089882934f},
        {-0.0050611154f, -0.0050611154f},
        {-0.0068049953f,  0.0111047430f},
        {-0.0100792909f, -0.0032749601f},
        {-0.0003478686f,  0.0044200894f},
    },
    {
        {-0.0003526226f, -0.0044804944f},   /* Filter 10 */
        { 0.0030482765f, -0.0009904451f},
        {-0.0061926948f, -0.0101055594f},
        { 0.0083524050f, -0.0083524049f},
        {-0.0080013950f, -0.0049032612f},
        { 0.0049550512f, -0.0152500795f},
        {-0.0167957752f, -0.0013218562f},
        {-0.0064034960f, -0.0404300825f},
        {-0.0187923166f,  0.0077840324f},
        {-0.0800459962f, -0.1101738620f},
        { 0.0811134182f, -0.0949716105f},
        {-0.1590775355f, -0.0810540528f},
        { 0.1619317577f, -0.6744943131f},
        { 1.0891264677f,  0.0000000000f},
        { 0.2484676308f,  1.0349421653f},
        {-0.5692392507f,  0.2900418852f},
        {-0.0864278435f, -0.1011940030f},
        {-0.0812704075f,  0.1118591195f},
        {-0.1165707628f, -0.0482851909f},
        { 0.0014797178f, -0.0093425708f},
        {-0.0413638603f,  0.0032554064f},
        {-0.0038249731f, -0.0117720568f},
        {-0.0147084760f,  0.0090133657f},
        {-0.0049759119f, -0.0049759119f},
        {-0.0068343153f,  0.0111525889f},
        {-0.0100124830f, -0.0032532529f},
        {-0.0003526226f,  0.0044804944f},
    },
    {
        {-0.0003573765f, -0.0045408995f},   /* Filter 11 */
        { 0.0029834536f, -0.0009693828f},
        {-0.0062250430f, -0.0101583469f},
        { 0.0083025209f, -0.0083025209f},
        {-0.0080983851f, -0.0049626968f},
        { 0.0049323120f, -0.0151800954f},
        {-0.0170180911f, -0.0013393528f},
        {-0.0063951759f, -0.0403775514f},
        {-0.0193135873f,  0.0079999498f},
        {-0.0803211239f, -0.1105525428f},
        { 0.0806242674f, -0.0943988885f},
        {-0.1611619499f, -0.0821161150f},
        { 0.1625644607f, -0.6771297106f},
        { 1.0902447701f,  0.0000000000f},
        { 0.2481507436f,  1.0336222352f},
        {-0.5667757240f,  0.2887866556f},
        {-0.0849962561f, -0.0995178296f},
        {-0.0816140807f,  0.1123321451f},
        {-0.1160806757f, -0.0480821902f},
        { 0.0013979127f, -0.0088260732f},
        {-0.0413670207f,  0.0032556551f},
        {-0.0037560104f, -0.0115598113f},
        {-0.0147493888f,  0.0090384371f},
        {-0.0048907081f, -0.0048907081f},
        {-0.0068636353f,  0.0112004348f},
        {-0.0099456752f, -0.0032315458f},
        {-0.0003573765f,  0.0045408995f},
    },
    {
        {-0.0003621305f, -0.0046013046f},   /* Filter 12 */
        { 0.0029186307f, -0.0009483206f},
        {-0.0062573917f, -0.0102111352f},
        { 0.0082526368f, -0.0082526368f},
        {-0.0081953752f, -0.0050221324f},
        { 0.0049095728f, -0.0151101113f},
        {-0.0172404088f, -0.0013568496f},
        {-0.0063868557f, -0.0403250202f},
        {-0.0198348598f,  0.0082158679f},
        {-0.0805962516f, -0.1109312237f},
        { 0.0801351118f, -0.0938261609f},
        {-0.1632463509f, -0.0831781703f},
        { 0.1631971497f, -0.6797650501f},
        { 1.0913630724f,  0.0000000000f},
        { 0.2478338564f,  1.0323023051f},
        {-0.5643122504f,  0.2875314531f},
        {-0.0835646688f, -0.0978416562f},
        {-0.0819577539f,  0.1128051707f},
        {-0.1155905886f, -0.0478791895f},
        { 0.0013161075f, -0.0083095757f},
        {-0.0413701812f,  0.0032559039f},
        {-0.0036870476f, -0.0113475657f},
        {-0.0147903015f,  0.0090635084f},
        {-0.0048055043f, -0.0048055043f},
        {-0.0068929552f,  0.0112482807f},
        {-0.0098788673f, -0.0032098386f},
        {-0.0003621305f,  0.0046013046f},
    },
    {
        {-0.0003667562f, -0.0046600797f},   /* Filter 13 */
        { 0.0028524949f, -0.0009268318f},
        {-0.0062887623f, -0.0102623273f},
        { 0.0082007909f, -0.0082007909f},
        {-0.0082909114f, -0.0050806770f},
        { 0.0048852541f, -0.0150352662f},
        {-0.0174620766f, -0.0013742952f},
        {-0.0063769051f, -0.0402621940f},
        {-0.0203630313f,  0.0084346437f},
        {-0.0808630937f, -0.1112985002f},
        { 0.0796236592f, -0.0932273268f},
        {-0.1653533760f, -0.0842517533f},
        { 0.1638266524f, -0.6823871173f},
        { 1.0924322605f,  0.0000000000f},
        { 0.2475061438f,  1.0309372838f},
        {-0.5618415541f,  0.2862725705f},
        {-0.0821516043f, -0.0961871702f},
        {-0.0822820441f,  0.1132515179f},
        {-0.1150904723f, -0.0476720345f},
        { 0.0012357069f, -0.0078019464f},
        {-0.0413638231f,  0.0032554035f},
        {-0.0036182596f, -0.0111358578f},
        {-0.0148268675f,  0.0090859161f},
        {-0.0047195995f, -0.0047195995f},
        {-0.0069207191f,  0.0112935871f},
        {-0.0098106733f, -0.0031876810f},
        {-0.0003667562f,  0.0046600797f},
    },
    {
        {-0.0003713820f, -0.0047188553f},   /* Filter 14 */
        { 0.0027863591f, -0.0009053429f},
        {-0.0063201333f, -0.0103135203f},
        { 0.0081489450f, -0.0081489450f},
        {-0.0083864467f, -0.0051392212f},
        { 0.0048609355f, -0.0149604211f},
        {-0.0176837445f, -0.0013917409f},
        {-0.0063669544f, -0.0401993678f},
        {-0.0208912044f,  0.0086534202f},
        {-0.0811299269f, -0.1116657647f},
        { 0.0791122066f, -0.0926284927f},
        {-0.1674604144f, -0.0853253430f},
        { 0.1644561550f, -0.6850091845f},
        { 1.0935014486f,  0.0000000000f},
        { 0.2471784312f,  1.0295722626f},
        {-0.5593708578f,  0.2850136878f},
        {-0.0807385445f, -0.0945326898f},
        {-0.0826063431f,  0.1136978772f},
        {-0.1145903561f, -0.0474648796f},
        { 0.0011553063f, -0.0072943168f},
        {-0.0413574651f,  0.0032549031f},
        {-0.0035494718f, -0.0109241508f},
        {-0.0148634318f,  0.0091083227f},
        {-0.0046336947f, -0.0046336947f},
        {-0.0069484829f,  0.0113388935f},
        {-0.0097424801f, -0.0031655237f},
        {-0.0003713820f,  0.0047188553f},
    },
    {
        {-0.0003760077f, -0.0047776305f},   /* Filter 15 */
        { 0.0027202235f, -0.0008838542f},
        {-0.0063515039f, -0.0103647124f},
        { 0.0080970991f, -0.0080970991f},
        {-0.0084819828f, -0.0051977658f},
        { 0.0048366169f, -0.0148855761f},
        {-0.0179054141f, -0.0014091867f},
        {-0.0063570037f, -0.0401365416f},
        {-0.0214193776f,  0.0088721967f},
        {-0.0813967690f, -0.1120330412f},
        { 0.0786007540f, -0.0920296586f},
        {-0.1695674396f, -0.0863989259f},
        { 0.1650856437f, -0.6876311937f},
        { 1.0945705175f,  0.0000000000f},
        { 0.2468507186f,  1.0282072413f},
        {-0.5569001084f,  0.2837547781f},
        {-0.0793254848f, -0.0928782095f},
        {-0.0829306333f,  0.1141442244f},
        {-0.1140902398f, -0.0472577246f},
        { 0.0010749057f, -0.0067866875f},
        {-0.0413511108f,  0.0032544030f},
        {-0.0034806840f, -0.0107124438f},
        {-0.0148999977f,  0.0091307304f},
        {-0.0045477902f, -0.0045477902f},
        {-0.0069762467f,  0.0113841999f},
        {-0.0096742861f, -0.0031433661f},
        {-0.0003760077f,  0.0047776305f},
    },
    {
        {-0.0003806334f, -0.0048364061f},   /* Filter 16 */
        { 0.0026540877f, -0.0008623654f},
        {-0.0063828750f, -0.0104159054f},
        { 0.0080452532f, -0.0080452532f},
        {-0.0085775182f, -0.0052563099f},
        { 0.0048122982f, -0.0148107310f},
        {-0.0181270820f, -0.0014266323f},
        {-0.0063470530f, -0.0400737154f},
        {-0.0219475490f,  0.0090909725f},
        {-0.0816636022f, -0.1124003057f},
        { 0.0780893013f, -0.0914308246f},
        {-0.1716744647f, -0.0874725088f},
        { 0.1657151464f, -0.6902532609f},
        { 1.0956397057f,  0.0000000000f},
        { 0.2465230060f,  1.0268422201f},
        {-0.5544294121f,  0.2824958955f},
        {-0.0779124251f, -0.0912237291f},
        {-0.0832549323f,  0.1145905836f},
        {-0.1135901236f, -0.0470505697f},
        { 0.0009945051f, -0.0062790583f},
        {-0.0413447527f,  0.0032539026f},
        {-0.0034118962f, -0.0105007368f},
        {-0.0149365621f,  0.0091531370f},
        {-0.0044618853f, -0.0044618853f},
        {-0.0070040105f,  0.0114295063f},
        {-0.0096060929f, -0.0031212088f},
        {-0.0003806334f,  0.0048364061f},
    },
    {
        {-0.0003851280f, -0.0048935157f},   /* Filter 17 */
        { 0.0025866848f, -0.0008404648f},
        {-0.0064132339f, -0.0104654466f},
        { 0.0079914771f, -0.0079914771f},
        {-0.0086714987f, -0.0053139012f},
        { 0.0047864048f, -0.0147310392f},
        {-0.0183478919f, -0.0014440104f},
        {-0.0063354525f, -0.0400004728f},
        {-0.0224823612f,  0.0093124989f},
        {-0.0819218257f, -0.1127557199f},
        { 0.0775554307f, -0.0908057424f},
        {-0.1738036093f, -0.0885573622f},
        { 0.1663412260f, -0.6928610705f},
        { 1.0966593027f,  0.0000000000f},
        { 0.2461845793f,  1.0254325714f},
        {-0.5519522897f,  0.2812337386f},
        {-0.0765181979f, -0.0895912988f},
        {-0.0835600060f,  0.1150104815f},
        {-0.1130804738f, -0.0468394658f},
        { 0.0009155433f, -0.0057805131f},
        {-0.0413290433f,  0.0032526663f},
        {-0.0033433427f, -0.0102897508f},
        {-0.0149687939f,  0.0091728887f},
        {-0.0043753638f, -0.0043753638f},
        {-0.0070302049f,  0.0114722518f},
        {-0.0095365818f, -0.0030986233f},
        {-0.0003851280f,  0.0048935157f},
    },
    {
        {-0.0003896226f, -0.0049506252f},   /* Filter 18 */
        { 0.0025192818f, -0.0008185643f},
        {-0.0064435933f, -0.0105149887f},
        { 0.0079377004f, -0.0079377004f},
        {-0.0087654792f, -0.0053714926f},
        { 0.0047605113f, -0.0146513473f},
        {-0.0185687000f, -0.0014613884f},
        {-0.0063238520f, -0.0399272301f},
        {-0.0230171717f,  0.0095340247f},
        {-0.0821800492f, -0.1131111340f},
        { 0.0770215552f, -0.0901806545f},
        {-0.1759327407f, -0.0896422088f},
        { 0.1669673057f, -0.6954688800f},
        { 1.0976788998f,  0.0000000000f},
        { 0.2458461804f,  1.0240230385f},
        {-0.5494751673f,  0.2799715817f},
        {-0.0751239755f, -0.0879588741f},
        {-0.0838650884f,  0.1154303915f},
        {-0.1125708239f, -0.0466283620f},
        { 0.0008365815f, -0.0052819680f},
        {-0.0413133302f,  0.0032514296f},
        {-0.0032747895f, -0.0100787656f},
        {-0.0150010258f,  0.0091926404f},
        {-0.0042888419f, -0.0042888419f},
        {-0.0070563994f,  0.0115149973f},
        {-0.0094670707f, -0.0030760377f},
        {-0.0003896226f,  0.0049506252f},
    },
    {
        {-0.0003941173f, -0.0050077347f},   /* Filter 19 */
        { 0.0024518789f, -0.0007966637f},
        {-0.0064739522f, -0.0105645299f},
        { 0.0078839243f, -0.0078839243f},
        {-0.0088594597f, -0.0054290839f},
        { 0.0047346179f, -0.0145716555f},
        {-0.0187895099f, -0.0014787665f},
        {-0.0063122509f, -0.0398539838f},
        {-0.0235519823f,  0.0097555505f},
        {-0.0824382815f, -0.1134665602f},
        { 0.0764876846f, -0.0895555723f},
        {-0.1780618721f, -0.0907270554f},
        { 0.1675933854f, -0.6980766896f},
        { 1.0986984968f,  0.0000000000f},
        { 0.2455077537f,  1.0226133898f},
        {-0.5469980450f,  0.2787094248f},
        {-0.0737297482f, -0.0863264437f},
        {-0.0841701708f,  0.1158503014f},
        {-0.1120611741f, -0.0464172581f},
        { 0.0007576198f, -0.0047834232f},
        {-0.0412976208f,  0.0032501933f},
        {-0.0032062360f, -0.0098677796f},
        {-0.0150332576f,  0.0092123921f},
        {-0.0042023200f, -0.0042023200f},
        {-0.0070825944f,  0.0115577436f},
        {-0.0093975595f, -0.0030534522f},
        {-0.0003941173f,  0.0050077347f},
    },
    {
        {-0.0003986118f, -0.0050648438f},   /* Filter 20 */
        { 0.0023844758f, -0.0007747632f},
        {-0.0065043117f, -0.0106140720f},
        { 0.0078301475f, -0.0078301475f},
        {-0.0089534402f, -0.0054866752f},
        { 0.0047087244f, -0.0144919637f},
        {-0.0190103198f, -0.0014961446f},
        {-0.0063006504f, -0.0397807411f},
        {-0.0240867928f,  0.0099770762f},
        {-0.0826965050f, -0.1138219743f},
        { 0.0759538140f, -0.0889304901f},
        {-0.1801910168f, -0.0918119088f},
        { 0.1682194651f, -0.7006844992f},
        { 1.0997180939f,  0.0000000000f},
        { 0.2451693548f,  1.0212038570f},
        {-0.5445209226f,  0.2774472679f},
        {-0.0723355258f, -0.0846940190f},
        {-0.0844752445f,  0.1162701993f},
        {-0.1115515243f, -0.0462061542f},
        { 0.0006786580f, -0.0042848781f},
        {-0.0412819114f,  0.0032489569f},
        {-0.0031376827f, -0.0096567945f},
        {-0.0150654894f,  0.0092321438f},
        {-0.0041157985f, -0.0041157985f},
        {-0.0071087888f,  0.0116004890f},
        {-0.0093280493f, -0.0030308669f},
        {-0.0003986118f,  0.0050648438f},
    },
    {
        {-0.0004029726f, -0.0051202528f},   /* Filter 21 */
        { 0.0023158529f, -0.0007524662f},
        {-0.0065336253f, -0.0106619075f},
        { 0.0077744735f, -0.0077744735f},
        {-0.0090457651f, -0.0055432520f},
        { 0.0046812616f, -0.0144074419f},
        {-0.0192300565f, -0.0015134383f},
        {-0.0062873809f, -0.0396969606f},
        {-0.0246279704f,  0.0102012394f},
        {-0.0829458033f, -0.1141651041f},
        { 0.0753974141f, -0.0882790295f},
        {-0.1823417366f, -0.0929077553f},
        { 0.1688419131f, -0.7032771818f},
        { 1.1006877422f,  0.0000000000f},
        { 0.2448203531f,  1.0197501604f},
        {-0.5420382238f,  0.2761822697f},
        {-0.0709604311f, -0.0830839899f},
        {-0.0847612768f,  0.1166638890f},
        {-0.1110328365f, -0.0459913067f},
        { 0.0006011677f, -0.0037956237f},
        {-0.0412570140f,  0.0032469974f},
        {-0.0030694222f, -0.0094467102f},
        {-0.0150934062f,  0.0092492512f},
        {-0.0040287435f, -0.0040287435f},
        {-0.0071334033f,  0.0116406561f},
        {-0.0092572893f, -0.0030078756f},
        {-0.0004029726f,  0.0051202528f},
    },
    {
        {-0.0004073334f, -0.0051756619f},   /* Filter 22 */
        { 0.0022472299f, -0.0007301693f},
        {-0.0065629390f, -0.0107097431f},
        { 0.0077187989f, -0.0077187989f},
        {-0.0091380892f, -0.0055998282f},
        { 0.0046537991f, -0.0143229210f},
        {-0.0194497931f, -0.0015307319f},
        {-0.0062741113f, -0.0396131801f},
        {-0.0251691481f,  0.0104254025f},
        {-0.0831951017f, -0.1145082339f},
        { 0.0748410142f, -0.0876275690f},
        {-0.1844924564f, -0.0940036018f},
        { 0.1694643611f, -0.7058698644f},
        { 1.1016573906f,  0.0000000000f},
        { 0.2444713793f,  1.0182965797f},
        {-0.5395555251f,  0.2749172715f},
        {-0.0695853363f, -0.0814739608f},
        {-0.0850473091f,  0.1170575787f},
        {-0.1105141488f, -0.0457764592f},
        { 0.0005236775f, -0.0033063695f},
        {-0.0412321204f,  0.0032450383f},
        {-0.0030011619f, -0.0092366267f},
        {-0.0151213230f,  0.0092663586f},
        {-0.0039416882f, -0.0039416882f},
        {-0.0071580177f,  0.0116808232f},
        {-0.0091865301f, -0.0029848846f},
        {-0.0004073334f,  0.0051756619f},
    },
    {
        {-0.0004116942f, -0.0052310710f},   /* Filter 23 */
        { 0.0021786070f, -0.0007078723f},
        {-0.0065922531f, -0.0107575794f},
        { 0.0076631249f, -0.0076631248f},
        {-0.0092304140f, -0.0056564050f},
        { 0.0046263364f, -0.0142383992f},
        {-0.0196695316f, -0.0015480257f},
        {-0.0062608412f, -0.0395293959f},
        {-0.0257103275f,  0.0106495664f},
        {-0.0834444001f, -0.1148513637f},
        { 0.0742846143f, -0.0869761084f},
        {-0.1866431763f, -0.0950994483f},
        { 0.1700868092f, -0.7084625470f},
        { 1.1026270390f,  0.0000000000f},
        { 0.2441223776f,  1.0168428830f},
        {-0.5370727733f,  0.2736522463f},
        {-0.0682102416f, -0.0798639317f},
        {-0.0853333414f,  0.1174512684f},
        {-0.1099954610f, -0.0455616117f},
        { 0.0004461872f, -0.0028171151f},
        {-0.0412072268f,  0.0032430791f},
        {-0.0029329017f, -0.0090265432f},
        {-0.0151492398f,  0.0092834661f},
        {-0.0038546332f, -0.0038546332f},
        {-0.0071826321f,  0.0117209904f},
        {-0.0091157710f, -0.0029618935f},
        {-0.0004116942f,  0.0052310710f},
    },
    {
        {-0.0004160550f, -0.0052864800f},   /* Filter 24 */
        { 0.0021099840f, -0.0006855754f},
        {-0.0066215668f, -0.0108054150f},
        { 0.0076074508f, -0.0076074508f},
        {-0.0093227389f, -0.0057129817f},
        { 0.0045988736f, -0.0141538774f},
        {-0.0198892683f, -0.0015653194f},
        {-0.0062475717f, -0.0394456154f},
        {-0.0262515052f,  0.0108737295f},
        {-0.0836936985f, -0.1151944935f},
        { 0.0737282143f, -0.0863246478f},
        {-0.1887938961f, -0.0961952948f},
        { 0.1707092572f, -0.7110552296f},
        { 1.1035966873f,  0.0000000000f},
        { 0.2437734037f,  1.0153893023f},
        {-0.5345900745f,  0.2723872481f},
        {-0.0668351468f, -0.0782539026f},
        {-0.0856193737f,  0.1178449581f},
        {-0.1094767732f, -0.0453467642f},
        { 0.0003686970f, -0.0023278609f},
        {-0.0411823294f,  0.0032411196f},
        {-0.0028646414f, -0.0088164598f},
        {-0.0151771565f,  0.0093005735f},
        {-0.0037675782f, -0.0037675782f},
        {-0.0072072466f,  0.0117611575f},
        {-0.0090450118f, -0.0029389025f},
        {-0.0004160550f,  0.0052864800f},
    },
    {
        {-0.0004202794f, -0.0053401557f},   /* Filter 25 */
        { 0.0020401896f, -0.0006628978f},
        {-0.0066498022f, -0.0108514909f},
        { 0.0075499131f, -0.0075499131f},
        {-0.0094133072f, -0.0057684821f},
        { 0.0045698486f, -0.0140645479f},
        {-0.0201077181f, -0.0015825117f},
        {-0.0062326157f, -0.0393511866f},
        {-0.0267987713f,  0.0111004145f},
        {-0.0839337477f, -0.1155248929f},
        { 0.0731491835f, -0.0856466898f},
        {-0.1909656600f, -0.0973018638f},
        { 0.1713278509f, -0.7136318579f},
        { 1.1045160294f,  0.0000000000f},
        { 0.2434139662f,  1.0138921374f},
        {-0.5321026492f,  0.2711198415f},
        {-0.0654794652f, -0.0766666033f},
        {-0.0858865311f,  0.1182126686f},
        {-0.1089495431f, -0.0451283783f},
        { 0.0002927095f, -0.0018480947f},
        {-0.0411484223f,  0.0032384511f},
        {-0.0027967317f, -0.0086074552f},
        {-0.0152007789f,  0.0093150493f},
        {-0.0036800735f, -0.0036800735f},
        {-0.0072302707f,  0.0117987295f},
        {-0.0089730738f, -0.0029155284f},
        {-0.0004202794f,  0.0053401557f},
    },
    {
        {-0.0004245037f, -0.0053938313f},   /* Filter 26 */
        { 0.0019703953f, -0.0006402202f},
        {-0.0066780380f, -0.0108975675f},
        { 0.0074923761f, -0.0074923761f},
        {-0.0095038756f, -0.0058239824f},
        { 0.0045408240f, -0.0139752192f},
        {-0.0203261679f, -0.0015997041f},
        {-0.0062176590f, -0.0392567541f},
        {-0.0273460374f,  0.0113270996f},
        {-0.0841737969f, -0.1158552923f},
        { 0.0725701576f, -0.0849687375f},
        {-0.1931374107f, -0.0984084260f},
        { 0.1719464586f, -0.7162085442f},
        { 1.1054353714f,  0.0000000000f},
        { 0.2430545287f,  1.0123949724f},
        {-0.5296151707f,  0.2698524080f},
        {-0.0641237884f, -0.0750793098f},
        {-0.0861536884f,  0.1185803792f},
        {-0.1084223130f, -0.0449099925f},
        { 0.0002167219f, -0.0013683284f},
        {-0.0411145153f,  0.0032357825f},
        {-0.0027288220f, -0.0083984506f},
        {-0.0152244029f,  0.0093295261f},
        {-0.0035925684f, -0.0035925684f},
        {-0.0072532954f,  0.0118363023f},
        {-0.0089011357f, -0.0028921543f},
        {-0.0004245037f,  0.0053938313f},
    },
    {
        {-0.0004287281f, -0.0054475065f},   /* Filter 27 */
        { 0.0019006009f, -0.0006175427f},
        {-0.0067062733f, -0.0109436434f},
        { 0.0074348391f, -0.0074348391f},
        {-0.0095944447f, -0.0058794833f},
        { 0.0045117990f, -0.0138858896f},
        {-0.0205446177f, -0.0016168965f},
        {-0.0062027030f, -0.0391623253f},
        {-0.0278933018f,  0.0115537839f},
        {-0.0844138462f, -0.1161856917f},
        { 0.0719911267f, -0.0842907795f},
        {-0.1953091746f, -0.0995149950f},
        { 0.1725650523f, -0.7187851725f},
        { 1.1063547134f,  0.0000000000f},
        { 0.2426950912f,  1.0108978075f},
        {-0.5271277453f,  0.2685850014f},
        {-0.0627681067f, -0.0734920105f},
        {-0.0864208458f,  0.1189480897f},
        {-0.1078950829f, -0.0446916066f},
        { 0.0001407344f, -0.0008885622f},
        {-0.0410806082f,  0.0032331140f},
        {-0.0026609126f, -0.0081894468f},
        {-0.0152480253f,  0.0093440019f},
        {-0.0035050636f, -0.0035050636f},
        {-0.0072763196f,  0.0118738744f},
        {-0.0088291976f, -0.0028687802f},
        {-0.0004287281f,  0.0054475065f},
    },
    {
        {-0.0004329524f, -0.0055011821f},   /* Filter 28 */
        { 0.0018308065f, -0.0005948651f},
        {-0.0067345086f, -0.0109897193f},
        { 0.0073773020f, -0.0073773020f},
        {-0.0096850131f, -0.0059349836f},
        { 0.0044827744f, -0.0137965609f},
        {-0.0207630675f, -0.0016340889f},
        {-0.0061877469f, -0.0390678966f},
        {-0.0284405679f,  0.0117804689f},
        {-0.0846538954f, -0.1165160911f},
        { 0.0714121008f, -0.0836128272f},
        {-0.1974809385f, -0.1006215640f},
        { 0.1731836599f, -0.7213618587f},
        { 1.1072740555f,  0.0000000000f},
        { 0.2423356537f,  1.0094006425f},
        {-0.5246402669f,  0.2673175678f},
        {-0.0614124299f, -0.0719047169f},
        {-0.0866880031f,  0.1193158002f},
        {-0.1073678527f, -0.0444732207f},
        { 0.0000647469f, -0.0004087959f},
        {-0.0410467012f,  0.0032304455f},
        {-0.0025930029f, -0.0079804422f},
        {-0.0152716477f,  0.0093584777f},
        {-0.0034175589f, -0.0034175589f},
        {-0.0072993442f,  0.0119114472f},
        {-0.0087572596f, -0.0028454061f},
        {-0.0004329524f,  0.0055011821f},
    },
    {
        {-0.0004370379f, -0.0055530933f},   /* Filter 29 */
        { 0.0017598908f, -0.0005718232f},
        {-0.0067616335f, -0.0110339831f},
        { 0.0073179389f, -0.0073179389f},
        {-0.0097737264f, -0.0059893473f},
        { 0.0044521959f, -0.0137024501f},
        {-0.0209800151f, -0.0016511630f},
        {-0.0061710869f, -0.0389627091f},
        {-0.0289936333f,  0.0120095561f},
        {-0.0848843801f, -0.1168333262f},
        { 0.0708103568f, -0.0829082755f},
        {-0.1996732022f, -0.1017385781f},
        { 0.1737981906f, -0.7239215633f},
        { 1.1081427336f,  0.0000000000f},
        { 0.2419659195f,  1.0078605888f},
        {-0.5221488584f,  0.2660481318f},
        {-0.0600764372f, -0.0703404704f},
        {-0.0869364694f,  0.1196577848f},
        {-0.1068325690f, -0.0442514990f},
        {-0.0000097081f,  0.0000612947f},
        {-0.0410039590f,  0.0032270816f},
        {-0.0025255004f, -0.0077726909f},
        {-0.0152910026f,  0.0093703385f},
        {-0.0033296870f, -0.0033296870f},
        {-0.0073207704f,  0.0119464115f},
        {-0.0086842126f, -0.0028216717f},
        {-0.0004370379f,  0.0055530933f},
    },
    {
        {-0.0004411234f, -0.0056050049f},   /* Filter 30 */
        { 0.0016889751f, -0.0005487813f},
        {-0.0067887584f, -0.0110782468f},
        { 0.0072585757f, -0.0072585757f},
        {-0.0098624390f, -0.0060437104f},
        { 0.0044216175f, -0.0136083393f},
        {-0.0211969608f, -0.0016682370f},
        {-0.0061544274f, -0.0388575254f},
        {-0.0295467004f,  0.0122386440f},
        {-0.0851148649f, -0.1171505612f},
        { 0.0702086080f, -0.0822037181f},
        {-0.2018654526f, -0.1028555855f},
        { 0.1744127213f, -0.7264812680f},
        { 1.1090114117f,  0.0000000000f},
        { 0.2415961853f,  1.0063205351f},
        {-0.5196575030f,  0.2647787229f},
        {-0.0587404494f, -0.0687762296f},
        {-0.0871849357f,  0.1199997693f},
        {-0.1062972852f, -0.0440297772f},
        {-0.0000841632f,  0.0005313853f},
        {-0.0409612168f,  0.0032237177f},
        {-0.0024579979f, -0.0075649396f},
        {-0.0153103576f,  0.0093821992f},
        {-0.0032418154f, -0.0032418154f},
        {-0.0073421965f,  0.0119813757f},
        {-0.0086111655f, -0.0027979373f},
        {-0.0004411234f,  0.0056050049f},
    },
    {
        {-0.0004452089f, -0.0056569160f},   /* Filter 31 */
        { 0.0016180593f, -0.0005257393f},
        {-0.0068158833f, -0.0111225106f},
        { 0.0071992125f, -0.0071992125f},
        {-0.0099511524f, -0.0060980740f},
        { 0.0043910390f, -0.0135142285f},
        {-0.0214139065f, -0.0016853110f},
        {-0.0061377673f, -0.0387523380f},
        {-0.0300997675f,  0.0124677319f},
        {-0.0853453496f, -0.1174677962f},
        { 0.0696068640f, -0.0814991665f},
        {-0.2040577163f, -0.1039725996f},
        { 0.1750272660f, -0.7290410306f},
        { 1.1098802090f,  0.0000000000f},
        { 0.2412264233f,  1.0047803655f},
        {-0.5171660945f,  0.2635092868f},
        {-0.0574044615f, -0.0672119888f},
        {-0.0874334108f,  0.1203417659f},
        {-0.1057620015f, -0.0438080554f},
        {-0.0001586182f,  0.0010014759f},
        {-0.0409184746f,  0.0032203538f},
        {-0.0023904954f, -0.0073571883f},
        {-0.0153297110f,  0.0093940590f},
        {-0.0031539435f, -0.0031539435f},
        {-0.0073636226f,  0.0120163400f},
        {-0.0085381176f, -0.0027742026f},
        {-0.0004452089f,  0.0056569160f},
    },
    {
        {-0.0004492944f, -0.0057088271f},   /* Filter 32 */
        { 0.0015471436f, -0.0005026974f},
        {-0.0068430081f, -0.0111667744f},
        { 0.0071398493f, -0.0071398493f},
        {-0.0100398657f, -0.0061524376f},
        { 0.0043604609f, -0.0134201186f},
        {-0.0216308523f, -0.0017023850f},
        {-0.0061211079f, -0.0386471542f},
        {-0.0306528311f,  0.0126968184f},
        {-0.0855758343f, -0.1177850312f},
        { 0.0690051152f, -0.0807946091f},
        {-0.2062499666f, -0.1050896070f},
        { 0.1756417967f, -0.7316007352f},
        { 1.1107488871f,  0.0000000000f},
        { 0.2408566892f,  1.0032403118f},
        {-0.5146746861f,  0.2622398508f},
        {-0.0560684736f, -0.0656477480f},
        {-0.0876818771f,  0.1206837505f},
        {-0.1052267178f, -0.0435863336f},
        {-0.0002330732f,  0.0014715665f},
        {-0.0408757361f,  0.0032169902f},
        {-0.0023229930f, -0.0071494375f},
        {-0.0153490660f,  0.0094059197f},
        {-0.0030660719f, -0.0030660719f},
        {-0.0073850488f,  0.0120513043f},
        {-0.0084650706f, -0.0027504682f},
        {-0.0004492944f,  0.0057088271f},
    },
    {
        {-0.0004532388f, -0.0057589445f},   /* Filter 33 */
        { 0.0014751579f, -0.0004793079f},
        {-0.0068689909f, -0.0112091745f},
        { 0.0070786989f, -0.0070786989f},
        {-0.0101266241f, -0.0062056032f},
        { 0.0043283390f, -0.0133212575f},
        {-0.0218460766f, -0.0017193235f},
        {-0.0061027287f, -0.0385311125f},
        {-0.0312114016f,  0.0129281858f},
        {-0.0857964393f, -0.1180886679f},
        { 0.0683805709f, -0.0800633618f},
        {-0.2084621591f, -0.1062167754f},
        { 0.1762520557f, -0.7341426468f},
        { 1.1115665436f,  0.0000000000f},
        { 0.2404767696f,  1.0016578330f},
        {-0.5121801973f,  0.2609688453f},
        {-0.0547524360f, -0.0641068659f},
        {-0.0879118451f,  0.1210002742f},
        {-0.1046838691f, -0.0433614783f},
        {-0.0003059675f,  0.0019318029f},
        {-0.0408243407f,  0.0032129453f},
        {-0.0022559532f, -0.0069431100f},
        {-0.0153641806f,  0.0094151820f},
        {-0.0029779159f, -0.0029779159f},
        {-0.0074048695f,  0.0120836489f},
        {-0.0083909855f, -0.0027263965f},
        {-0.0004532388f,  0.0057589445f},
    },
    {
        {-0.0004571831f, -0.0058090623f},   /* Filter 34 */
        { 0.0014031721f, -0.0004559183f},
        {-0.0068949737f, -0.0112515745f},
        { 0.0070175484f, -0.0070175484f},
        {-0.0102133832f, -0.0062587693f},
        { 0.0042962171f, -0.0132223965f},
        {-0.0220612991f, -0.0017362619f},
        {-0.0060843501f, -0.0384150744f},
        {-0.0317699720f,  0.0131595533f},
        {-0.0860170442f, -0.1183923046f},
        { 0.0677560267f, -0.0793321144f},
        {-0.2106743383f, -0.1073439370f},
        { 0.1768623146f, -0.7366845584f},
        { 1.1123842001f,  0.0000000000f},
        { 0.2400968501f,  1.0000753543f},
        {-0.5096857086f,  0.2596978398f},
        {-0.0534364032f, -0.0625659895f},
        {-0.0881418043f,  0.1213167859f},
        {-0.1041410205f, -0.0431366231f},
        {-0.0003788618f,  0.0023920396f},
        {-0.0407729454f,  0.0032089004f},
        {-0.0021889135f, -0.0067367830f},
        {-0.0153792951f,  0.0094244442f},
        {-0.0028897598f, -0.0028897598f},
        {-0.0074246903f,  0.0121159935f},
        {-0.0083168996f, -0.0027023245f},
        {-0.0004571831f,  0.0058090623f},
    },
    {
        {-0.0004611274f, -0.0058591796f},   /* Filter 35 */
        { 0.0013311864f, -0.0004325287f},
        {-0.0069209560f, -0.0112939738f},
        { 0.0069563979f, -0.0069563979f},
        {-0.0103001415f, -0.0063119349f},
        { 0.0042640952f, -0.0131235355f},
        {-0.0222765216f, -0.0017532003f},
        {-0.0060659709f, -0.0382990327f},
        {-0.0323285424f,  0.0133909207f},
        {-0.0862376404f, -0.1186959292f},
        { 0.0671314824f, -0.0786008671f},
        {-0.2128865308f, -0.1084711053f},
        { 0.1774725736f, -0.7392264700f},
        { 1.1132018566f,  0.0000000000f},
        { 0.2397169305f,  0.9984928755f},
        {-0.5071912198f,  0.2584268343f},
        {-0.0521203656f, -0.0610251074f},
        {-0.0883717723f,  0.1216333097f},
        {-0.1035981787f, -0.0429117706f},
        {-0.0004517562f,  0.0028522762f},
        {-0.0407215500f,  0.0032048555f},
        {-0.0021218736f, -0.0065304555f},
        {-0.0153944097f,  0.0094337064f},
        {-0.0028016041f, -0.0028016041f},
        {-0.0074445116f,  0.0121483388f},
        {-0.0082428136f, -0.0026782525f},
        {-0.0004611274f,  0.0058591796f},
    },
    {
        {-0.0004650718f, -0.0059092970f},   /* Filter 36 */
        { 0.0012592008f, -0.0004091391f},
        {-0.0069469388f, -0.0113363739f},
        { 0.0068952475f, -0.0068952475f},
        {-0.0103869007f, -0.0063651009f},
        { 0.0042319733f, -0.0130246745f},
        {-0.0224917460f, -0.0017701388f},
        {-0.0060475916f, -0.0381829910f},
        {-0.0328871128f,  0.0136222881f},
        {-0.0864582453f, -0.1189995658f},
        { 0.0665069382f, -0.0778696197f},
        {-0.2150987101f, -0.1095982669f},
        { 0.1780828326f, -0.7417683816f},
        { 1.1140196323f,  0.0000000000f},
        { 0.2393370388f,  0.9969105126f},
        {-0.5046967311f,  0.2571558288f},
        {-0.0508043328f, -0.0594842310f},
        {-0.0886017403f,  0.1219498335f},
        {-0.1030553301f, -0.0426869154f},
        {-0.0005246505f,  0.0033125128f},
        {-0.0406701546f,  0.0032008106f},
        {-0.0020548339f, -0.0063241285f},
        {-0.0154095243f,  0.0094429686f},
        {-0.0027134480f, -0.0027134480f},
        {-0.0074643324f,  0.0121806834f},
        {-0.0081687285f, -0.0026541808f},
        {-0.0004650718f,  0.0059092970f},
    },
    {
        {-0.0004688728f, -0.0059575936f},   /* Filter 37 */
        { 0.0011861981f, -0.0003854191f},
        {-0.0069717484f, -0.0113768594f},
        { 0.0068323499f, -0.0068323499f},
        {-0.0104716071f, -0.0064170091f},
        { 0.0041983192f, -0.0129210977f},
        {-0.0227050262f, -0.0017869243f},
        {-0.0060274787f, -0.0380560029f},
        {-0.0334508837f,  0.0138558097f},
        {-0.0866686552f, -0.1192891701f},
        { 0.0658595211f, -0.0771115917f},
        {-0.2173302472f, -0.1107352919f},
        { 0.1786885972f, -0.7442915729f},
        { 1.1147860289f,  0.0000000000f},
        { 0.2389470731f,  0.9952861883f},
        {-0.5021999056f,  0.2558836327f},
        {-0.0495085018f, -0.0579670079f},
        {-0.0888133938f,  0.1222411496f},
        {-0.1025054052f, -0.0424591290f},
        {-0.0005959573f,  0.0037627266f},
        {-0.0406102918f,  0.0031960993f},
        {-0.0019883112f, -0.0061193927f},
        {-0.0154204302f,  0.0094496518f},
        {-0.0026250900f, -0.0026250900f},
        {-0.0074825430f,  0.0122104004f},
        {-0.0080936744f, -0.0026297942f},
        {-0.0004688728f,  0.0059575936f},
    },
    {
        {-0.0004726738f, -0.0060058898f},   /* Filter 38 */
        { 0.0011131952f, -0.0003616991f},
        {-0.0069965580f, -0.0114173449f},
        { 0.0067694530f, -0.0067694529f},
        {-0.0105563135f, -0.0064689173f},
        { 0.0041646653f, -0.0128175219f},
        {-0.0229183064f, -0.0018037098f},
        {-0.0060073658f, -0.0379290149f},
        {-0.0340146545f,  0.0140893312f},
        {-0.0868790563f, -0.1195787623f},
        { 0.0652121089f, -0.0763535694f},
        {-0.2195617843f, -0.1118723169f},
        { 0.1792943758f, -0.7468148221f},
        { 1.1155524254f,  0.0000000000f},
        { 0.2385571351f,  0.9936619800f},
        {-0.4997031332f,  0.2546114636f},
        {-0.0482126757f, -0.0564497904f},
        {-0.0890250562f,  0.1225324778f},
        {-0.1019554735f, -0.0422313399f},
        {-0.0006672642f,  0.0042129402f},
        {-0.0405504327f,  0.0031913883f},
        {-0.0019217884f, -0.0059146564f},
        {-0.0154313378f,  0.0094563359f},
        {-0.0025367317f, -0.0025367317f},
        {-0.0075007536f,  0.0122401174f},
        {-0.0080186212f, -0.0026054079f},
        {-0.0004726738f,  0.0060058898f},
    },
    {
        {-0.0004764748f, -0.0060541865f},   /* Filter 39 */
        { 0.0010401923f, -0.0003379790f},
        {-0.0070213680f, -0.0114578312f},
        { 0.0067065554f, -0.0067065554f},
        {-0.0106410200f, -0.0065208254f},
        { 0.0041310112f, -0.0127139452f},
        {-0.0231315866f, -0.0018204954f},
        {-0.0059872534f, -0.0378020306f},
        {-0.0345784254f,  0.0143228528f},
        {-0.0870894661f, -0.1198683666f},
        { 0.0645646918f, -0.0755955413f},
        {-0.2217933347f, -0.1130093486f},
        { 0.1799001404f, -0.7493380133f},
        { 1.1163188219f,  0.0000000000f},
        { 0.2381671972f,  0.9920377716f},
        {-0.4972063608f,  0.2533392945f},
        {-0.0469168496f, -0.0549325730f},
        {-0.0892367185f,  0.1228238060f},
        {-0.1014055487f, -0.0420035536f},
        {-0.0007385710f,  0.0046631539f},
        {-0.0404905698f,  0.0031866770f},
        {-0.0018552657f, -0.0057099206f},
        {-0.0154422437f,  0.0094630191f},
        {-0.0024483737f, -0.0024483736f},
        {-0.0075189641f,  0.0122698343f},
        {-0.0079435671f, -0.0025810214f},
        {-0.0004764748f,  0.0060541865f},
    },
    {
        {-0.0004802758f, -0.0061024827f},   /* Filter 40 */
        { 0.0009671894f, -0.0003142589f},
        {-0.0070461776f, -0.0114983168f},
        { 0.0066436584f, -0.0066436584f},
        {-0.0107257264f, -0.0065727336f},
        { 0.0040973574f, -0.0126103694f},
        {-0.0233448668f, -0.0018372809f},
        {-0.0059671405f, -0.0376750426f},
        {-0.0351421962f,  0.0145563743f},
        {-0.0872998672f, -0.1201579589f},
        { 0.0639172747f, -0.0748375133f},
        {-0.2240248718f, -0.1141463735f},
        { 0.1805059050f, -0.7518612045f},
        { 1.1170852184f,  0.0000000000f},
        { 0.2377772314f,  0.9904134473f},
        {-0.4947095884f,  0.2520671255f},
        {-0.0456210186f, -0.0534153499f},
        {-0.0894483808f,  0.1231151342f},
        {-0.1008556239f, -0.0417757672f},
        {-0.0008098778f,  0.0051133675f},
        {-0.0404307070f,  0.0031819657f},
        {-0.0017887430f, -0.0055051848f},
        {-0.0154531496f,  0.0094697023f},
        {-0.0023600156f, -0.0023600156f},
        {-0.0075371742f,  0.0122995505f},
        {-0.0078685138f, -0.0025566351f},
        {-0.0004802758f,  0.0061024827f},
    },
    {
        {-0.0004839315f, -0.0061489327f},   /* Filter 41 */
        { 0.0008932235f, -0.0002902259f},
        {-0.0070697837f, -0.0115368385f},
        { 0.0065790572f, -0.0065790572f},
        {-0.0108082824f, -0.0066233240f},
        { 0.0040621843f, -0.0125021177f},
        {-0.0235559837f, -0.0018538961f},
        {-0.0059452799f, -0.0375370199f},
        {-0.0357108543f,  0.0147919202f},
        {-0.0874997666f, -0.1204330968f},
        { 0.0632469267f, -0.0740526367f},
        {-0.2262751694f, -0.1152929574f},
        { 0.1811069666f, -0.7543648061f},
        { 1.1177999973f,  0.0000000000f},
        { 0.2373774143f,  0.9887480889f},
        {-0.4922112759f,  0.2507941716f},
        {-0.0443456460f, -0.0519220803f},
        {-0.0896419302f,  0.1233815321f},
        {-0.1002991048f, -0.0415452495f},
        {-0.0008795720f,  0.0055533987f},
        {-0.0403625660f,  0.0031766029f},
        {-0.0017227906f, -0.0053022041f},
        {-0.0154598835f,  0.0094738288f},
        {-0.0022715368f, -0.0022715368f},
        {-0.0075537707f,  0.0123266335f},
        {-0.0077925634f, -0.0025319573f},
        {-0.0004839315f,  0.0061489327f},
    },
    {
        {-0.0004875871f, -0.0061953822f},   /* Filter 42 */
        { 0.0008192576f, -0.0002661929f},
        {-0.0070933904f, -0.0115753611f},
        { 0.0065144553f, -0.0065144553f},
        {-0.0108908393f, -0.0066739149f},
        { 0.0040270112f, -0.0123938661f},
        {-0.0237670987f, -0.0018705112f},
        {-0.0059234193f, -0.0373989973f},
        {-0.0362795124f,  0.0150274661f},
        {-0.0876996573f, -0.1207082227f},
        { 0.0625765836f, -0.0732677657f},
        {-0.2285254935f, -0.1164395548f},
        { 0.1817080420f, -0.7568684655f},
        { 1.1185147762f,  0.0000000000f},
        { 0.2369775693f,  0.9870826146f},
        {-0.4897130165f,  0.2495212449f},
        {-0.0430702685f, -0.0504288052f},
        {-0.0898354883f,  0.1236479420f},
        {-0.0997425856f, -0.0413147317f},
        {-0.0009492661f,  0.0059934300f},
        {-0.0402944251f,  0.0031712400f},
        {-0.0016568381f, -0.0050992234f},
        {-0.0154666173f,  0.0094779553f},
        {-0.0021830581f, -0.0021830581f},
        {-0.0075703667f,  0.0123537157f},
        {-0.0077166129f, -0.0025072795f},
        {-0.0004875871f,  0.0061953822f},
    },
    {
        {-0.0004912428f, -0.0062418321f},   /* Filter 43 */
        { 0.0007452916f, -0.0002421599f},
        {-0.0071169970f, -0.0116138836f},
        { 0.0064498541f, -0.0064498541f},
        {-0.0109733961f, -0.0067245058f},
        { 0.0039918381f, -0.0122856144f},
        {-0.0239782156f, -0.0018871265f},
        {-0.0059015592f, -0.0372609784f},
        {-0.0368481705f,  0.0152630120f},
        {-0.0878995479f, -0.1209833486f},
        { 0.0619062356f, -0.0724828890f},
        {-0.2307757911f, -0.1175861387f},
        { 0.1823091036f, -0.7593720670f},
        { 1.1192296743f,  0.0000000000f},
        { 0.2365777521f,  0.9854172562f},
        {-0.4872147571f,  0.2482483181f},
        {-0.0417948910f, -0.0489355300f},
        {-0.0900290465f,  0.1239143519f},
        {-0.0991860664f, -0.0410842139f},
        {-0.0010189602f,  0.0064334613f},
        {-0.0402262842f,  0.0031658772f},
        {-0.0015908856f, -0.0048962423f},
        {-0.0154733511f,  0.0094820818f},
        {-0.0020945793f, -0.0020945793f},
        {-0.0075869627f,  0.0123807979f},
        {-0.0076406624f, -0.0024826017f},
        {-0.0004912428f,  0.0062418321f},
    },
    {
        {-0.0004948985f, -0.0062882816f},   /* Filter 44 */
        { 0.0006713257f, -0.0002181269f},
        {-0.0071406037f, -0.0116524062f},
        { 0.0063852528f, -0.0063852528f},
        {-0.0110559522f, -0.0067750962f},
        { 0.0039566650f, -0.0121773628f},
        {-0.0241893307f, -0.0019037416f},
        {-0.0058796986f, -0.0371229558f},
        {-0.0374168286f,  0.0154985579f},
        {-0.0880994473f, -0.1212584865f},
        { 0.0612358876f, -0.0716980124f},
        {-0.2330260887f, -0.1187327226f},
        { 0.1829101651f, -0.7618756686f},
        { 1.1199444532f,  0.0000000000f},
        { 0.2361779071f,  0.9837517819f},
        {-0.4847164976f,  0.2469753914f},
        {-0.0405195159f, -0.0474422576f},
        {-0.0902225958f,  0.1241807498f},
        {-0.0986295404f, -0.0408536933f},
        {-0.0010886543f,  0.0068734926f},
        {-0.0401581470f,  0.0031605147f},
        {-0.0015249331f, -0.0046932616f},
        {-0.0154800849f,  0.0094862083f},
        {-0.0020061004f, -0.0020061004f},
        {-0.0076035587f,  0.0124078801f},
        {-0.0075647111f, -0.0024579236f},
        {-0.0004948985f,  0.0062882816f},
    },
    {
        {-0.0004984069f, -0.0063328608f},   /* Filter 45 */
        { 0.0005964521f, -0.0001937990f},
        {-0.0071629778f, -0.0116889173f},
        { 0.0063189914f, -0.0063189914f},
        {-0.0111362633f, -0.0068243110f},
        { 0.0039199873f, -0.0120644805f},
        {-0.0243980596f, -0.0019201689f},
        {-0.0058560780f, -0.0369738213f},
        {-0.0379900539f,  0.0157359955f},
        {-0.0882885123f, -0.1215187121f},
        { 0.0605425555f, -0.0708862248f},
        {-0.2352945758f, -0.1198885745f},
        { 0.1835063149f, -0.7643588110f},
        { 1.1206073761f,  0.0000000000f},
        { 0.2357683498f,  0.9820458531f},
        {-0.4822176009f,  0.2457021399f},
        {-0.0392648217f, -0.0459731995f},
        {-0.0903982600f,  0.1244225307f},
        {-0.0980669088f, -0.0406206436f},
        {-0.0011567119f,  0.0073031915f},
        {-0.0400819211f,  0.0031545156f},
        {-0.0014596031f, -0.0044921963f},
        {-0.0154826848f,  0.0094878014f},
        {-0.0019175820f, -0.0019175820f},
        {-0.0076185377f,  0.0124323236f},
        {-0.0074879351f, -0.0024329776f},
        {-0.0004984069f,  0.0063328608f},
    },
    {
        {-0.0005019154f, -0.0063774399f},   /* Filter 46 */
        { 0.0005215783f, -0.0001694711f},
        {-0.0071853518f, -0.0117254285f},
        { 0.0062527300f, -0.0062527300f},
        {-0.0112165737f, -0.0068735252f},
        { 0.0038833097f, -0.0119515982f},
        {-0.0246067885f, -0.0019365963f},
        {-0.0058324580f, -0.0368246905f},
        {-0.0385632792f,  0.0159734332f},
        {-0.0884775859f, -0.1217789497f},
        { 0.0598492233f, -0.0700744371f},
        {-0.2375630363f, -0.1210444129f},
        { 0.1841024646f, -0.7668419534f},
        { 1.1212704182f,  0.0000000000f},
        { 0.2353587647f,  0.9803398084f},
        {-0.4797186511f,  0.2444288614f},
        {-0.0380101300f, -0.0445041442f},
        {-0.0905739154f,  0.1246642996f},
        {-0.0975042702f, -0.0403875911f},
        {-0.0012247695f,  0.0077328901f},
        {-0.0400056952f,  0.0031485165f},
        {-0.0013942730f, -0.0042911310f},
        {-0.0154852846f,  0.0094893946f},
        {-0.0018290634f, -0.0018290634f},
        {-0.0076335167f,  0.0124567670f},
        {-0.0074111591f, -0.0024080316f},
        {-0.0005019154f,  0.0063774399f},
    },
    {
        {-0.0005054239f, -0.0064220191f},   /* Filter 47 */
        { 0.0004467046f, -0.0001451431f},
        {-0.0072077259f, -0.0117619396f},
        { 0.0061864692f, -0.0061864692f},
        {-0.0112968841f, -0.0069227395f},
        { 0.0038466317f, -0.0118387150f},
        {-0.0248155174f, -0.0019530236f},
        {-0.0058088374f, -0.0366755560f},
        {-0.0391365079f,  0.0162108723f},
        {-0.0886666509f, -0.1220391752f},
        { 0.0591558912f, -0.0692626495f},
        {-0.2398315234f, -0.1222002648f},
        { 0.1846986144f, -0.7693250958f},
        { 1.1219333410f,  0.0000000000f},
        { 0.2349492074f,  0.9786338796f},
        {-0.4772197544f,  0.2431556099f},
        {-0.0367554358f, -0.0430350860f},
        {-0.0907495707f,  0.1249060685f},
        {-0.0969416386f, -0.0401545414f},
        {-0.0012928271f,  0.0081625890f},
        {-0.0399294694f,  0.0031425174f},
        {-0.0013289429f, -0.0040900657f},
        {-0.0154878828f,  0.0094909868f},
        {-0.0017405448f, -0.0017405448f},
        {-0.0076484961f,  0.0124812113f},
        {-0.0073343827f, -0.0023830854f},
        {-0.0005054239f,  0.0064220191f},
    },
    {
        {-0.0005089323f, -0.0064665982f},   /* Filter 48 */
        { 0.0003718309f, -0.0001208152f},
        {-0.0072301004f, -0.0117984516f},
        { 0.0061202078f, -0.0061202077f},
        {-0.0113771945f, -0.0069719537f},
        { 0.0038099540f, -0.0117258327f},
        {-0.0250242464f, -0.0019694509f},
        {-0.0057852168f, -0.0365264215f},
        {-0.0397097331f,  0.0164483100f},
        {-0.0888557158f, -0.1222994008f},
        { 0.0584625591f, -0.0684508619f},
        {-0.2420999840f, -0.1233561032f},
        { 0.1852947641f, -0.7718082383f},
        { 1.1225962639f,  0.0000000000f},
        { 0.2345396223f,  0.9769278348f},
        {-0.4747208046f,  0.2418823314f},
        {-0.0355007440f, -0.0415660307f},
        {-0.0909252349f,  0.1251478494f},
        {-0.0963790001f, -0.0399214889f},
        {-0.0013608847f,  0.0085922880f},
        {-0.0398532435f,  0.0031365183f},
        {-0.0012636128f, -0.0038890005f},
        {-0.0154904827f,  0.0094925800f},
        {-0.0016520262f, -0.0016520262f},
        {-0.0076634751f,  0.0125056548f},
        {-0.0072576067f, -0.0023581394f},
        {-0.0005089323f,  0.0064665982f},
    },
    {
        {-0.0005122918f, -0.0065092847f},   /* Filter 49 */
        { 0.0002961061f, -0.0000962107f},
        {-0.0072512136f, -0.0118329052f},
        { 0.0060523329f, -0.0060523329f},
        {-0.0114551639f, -0.0070197335f},
        { 0.0037717876f, -0.0116083685f},
        {-0.0252303626f, -0.0019856726f},
        {-0.0057598252f, -0.0363661052f},
        {-0.0402871986f,  0.0166875040f},
        {-0.0890336484f, -0.1225443041f},
        { 0.0577462041f, -0.0676121180f},
        {-0.2443860233f, -0.1245208984f},
        { 0.1858857934f, -0.7742700522f},
        { 1.1232070923f,  0.0000000000f},
        { 0.2341204641f,  0.9751819152f},
        {-0.4722220141f,  0.2406091340f},
        {-0.0342669557f, -0.0401214502f},
        {-0.0910832065f,  0.1253652787f},
        {-0.0958107240f, -0.0396861013f},
        {-0.0014272835f,  0.0090115135f},
        {-0.0397691295f,  0.0031298984f},
        {-0.0011989560f, -0.0036900071f},
        {-0.0154889898f,  0.0094916651f},
        {-0.0015635480f, -0.0015635480f},
        {-0.0076768361f,  0.0125274579f},
        {-0.0071800761f, -0.0023329481f},
        {-0.0005122918f,  0.0065092847f},
    },
    {
        {-0.0005156513f, -0.0065519712f},   /* Filter 50 */
        { 0.0002203812f, -0.0000716062f},
        {-0.0072723269f, -0.0118673589f},
        { 0.0059844580f, -0.0059844580f},
        {-0.0115331333f, -0.0070675132f},
        { 0.0037336208f, -0.0114909033f},
        {-0.0254364807f, -0.0020018945f},
        {-0.0057344330f, -0.0362057853f},
        {-0.0408646640f,  0.0169266981f},
        {-0.0892115811f, -0.1227892073f},
        { 0.0570298443f, -0.0667733684f},
        {-0.2466720627f, -0.1256856936f},
        { 0.1864768087f, -0.7767318083f},
        { 1.1238179207f,  0.0000000000f},
        { 0.2337013059f,  0.9734359955f},
        {-0.4697232236f,  0.2393359367f},
        {-0.0330331698f, -0.0386768725f},
        {-0.0912411868f,  0.1255827200f},
        {-0.0952424548f, -0.0394507165f},
        {-0.0014936823f,  0.0094307390f},
        {-0.0396850155f,  0.0031232785f},
        {-0.0011342992f, -0.0034910138f},
        {-0.0154874953f,  0.0094907493f},
        {-0.0014750697f, -0.0014750697f},
        {-0.0076901970f,  0.0125492610f},
        {-0.0071025455f, -0.0023077569f},
        {-0.0005156513f,  0.0065519712f},
    },
    {
        {-0.0005190108f, -0.0065946577f},   /* Filter 51 */
        { 0.0001446564f, -0.0000470017f},
        {-0.0072934406f, -0.0119018134f},
        { 0.0059165832f, -0.0059165832f},
        {-0.0116111028f, -0.0071152929f},
        { 0.0036954541f, -0.0113734382f},
        {-0.0256425970f, -0.0020181162f},
        {-0.0057090414f, -0.0360454690f},
        {-0.0414421295f,  0.0171658921f},
        {-0.0893895137f, -0.1230341106f},
        { 0.0563134893f, -0.0659346245f},
        {-0.2489580755f, -0.1268504753f},
        { 0.1870678379f, -0.7791936222f},
        { 1.1244288683f,  0.0000000000f},
        { 0.2332821616f,  0.9716901338f},
        {-0.4672244862f,  0.2380627664f},
        {-0.0317993815f, -0.0372322920f},
        {-0.0913991672f,  0.1258001613f},
        {-0.0946741787f, -0.0392153288f},
        {-0.0015600811f,  0.0098499645f},
        {-0.0396009015f,  0.0031166585f},
        {-0.0010696423f, -0.0032920205f},
        {-0.0154860024f,  0.0094898345f},
        {-0.0013865916f, -0.0013865916f},
        {-0.0077035580f,  0.0125710642f},
        {-0.0070250148f, -0.0022825657f},
        {-0.0005190108f,  0.0065946577f},
    },
    {
        {-0.0005223703f, -0.0066373442f},   /* Filter 52 */
        { 0.0000689315f, -0.0000223972f},
        {-0.0073145539f, -0.0119362671f},
        { 0.0058487083f, -0.0058487083f},
        {-0.0116890714f, -0.0071630722f},
        { 0.0036572877f, -0.0112559740f},
        {-0.0258487132f, -0.0020343379f},
        {-0.0056836492f, -0.0358851491f},
        {-0.0420195949f,  0.0174050861f},
        {-0.0895674464f, -0.1232790139f},
        { 0.0555971295f, -0.0650958750f},
        {-0.2512441148f, -0.1280152706f},
        { 0.1876588672f, -0.7816554362f},
        { 1.1250396967f,  0.0000000000f},
        { 0.2328630033f,  0.9699442141f},
        {-0.4647256957f,  0.2367895690f},
        {-0.0305655932f, -0.0357877115f},
        {-0.0915571388f,  0.1260175906f},
        {-0.0941059027f, -0.0389799412f},
        {-0.0016264799f,  0.0102691900f},
        {-0.0395167875f,  0.0031100386f},
        {-0.0010049855f, -0.0030930272f},
        {-0.0154845096f,  0.0094889197f},
        {-0.0012981134f, -0.0012981134f},
        {-0.0077169190f,  0.0125928673f},
        {-0.0069474842f, -0.0022573745f},
        {-0.0005223703f,  0.0066373442f},
    },
    {
        {-0.0005255793f, -0.0066781181f},   /* Filter 53 */
        {-0.0000075868f,  0.0000024651f},
        {-0.0073343790f, -0.0119686188f},
        { 0.0057792674f, -0.0057792674f},
        {-0.0117646054f, -0.0072093594f},
        { 0.0036176494f, -0.0111339801f},
        {-0.0260519940f, -0.0020503364f},
        {-0.0056564756f, -0.0357135811f},
        {-0.0426009668f,  0.0176458982f},
        {-0.0897339314f, -0.1235081609f},
        { 0.0548577178f, -0.0642301351f},
        {-0.2535470691f, -0.1291886844f},
        { 0.1882445533f, -0.7840949944f},
        { 1.1255981922f,  0.0000000000f},
        { 0.2324344250f,  0.9681590570f},
        {-0.4622278611f,  0.2355168587f},
        {-0.0293529237f, -0.0343678579f},
        {-0.0916976544f,  0.1262109936f},
        {-0.0935324640f, -0.0387424151f},
        {-0.0016911990f,  0.0106778105f},
        {-0.0394249859f,  0.0031028137f},
        {-0.0009410515f, -0.0028962589f},
        {-0.0154789669f,  0.0094855231f},
        {-0.0012097549f, -0.0012097549f},
        {-0.0077286625f,  0.0126120309f},
        {-0.0068692707f, -0.0022319613f},
        {-0.0005255793f,  0.0066781181f},
    },
    {
        {-0.0005287883f, -0.0067188919f},   /* Filter 54 */
        {-0.0000841051f,  0.0000273274f},
        {-0.0073542042f, -0.0120009705f},
        { 0.0057098272f, -0.0057098272f},
        {-0.0118401393f, -0.0072556467f},
        { 0.0035780115f, -0.0110119870f},
        {-0.0262552748f, -0.0020663349f},
        {-0.0056293024f, -0.0355420169f},
        {-0.0431823351f,  0.0178867089f},
        {-0.0899004077f, -0.1237372958f},
        { 0.0541183013f, -0.0633643896f},
        {-0.2558500499f, -0.1303621117f},
        { 0.1888302394f, -0.7865345526f},
        { 1.1261566877f,  0.0000000000f},
        { 0.2320058328f,  0.9663738420f},
        {-0.4597300266f,  0.2342441485f},
        {-0.0281402517f, -0.0329480015f},
        {-0.0918381699f,  0.1264043967f},
        {-0.0929590254f, -0.0385048890f},
        {-0.0017559182f,  0.0110864309f},
        {-0.0393331843f,  0.0030955888f},
        {-0.0008771176f, -0.0026994905f},
        {-0.0154734257f,  0.0094821275f},
        {-0.0011213965f, -0.0011213965f},
        {-0.0077404060f,  0.0126311945f},
        {-0.0067910571f, -0.0022065482f},
        {-0.0005287883f,  0.0067188919f},
    },
    {
        {-0.0005319972f, -0.0067596658f},   /* Filter 55 */
        {-0.0001606233f,  0.0000521897f},
        {-0.0073740294f, -0.0120333223f},
        { 0.0056403870f, -0.0056403870f},
        {-0.0119156725f, -0.0073019335f},
        { 0.0035383736f, -0.0108899940f},
        {-0.0264585556f, -0.0020823335f},
        {-0.0056021287f, -0.0353704489f},
        {-0.0437637035f,  0.0181275195f},
        {-0.0900668927f, -0.1239664428f},
        { 0.0533788848f, -0.0624986441f},
        {-0.2581530042f, -0.1315355255f},
        { 0.1894159394f, -0.7889741687f},
        { 1.1267151833f,  0.0000000000f},
        { 0.2315772545f,  0.9645886849f},
        {-0.4572321920f,  0.2329714382f},
        {-0.0269275822f, -0.0315281480f},
        {-0.0919786855f,  0.1265977998f},
        {-0.0923855798f, -0.0382673601f},
        {-0.0018206374f,  0.0114950523f},
        {-0.0392413790f,  0.0030883635f},
        {-0.0008131837f, -0.0025027222f},
        {-0.0154678846f,  0.0094787319f},
        {-0.0010330379f, -0.0010330379f},
        {-0.0077521489f,  0.0126503573f},
        {-0.0067128436f, -0.0021811351f},
        {-0.0005319972f,  0.0067596658f},
    },
    {
        {-0.0005352062f, -0.0068004397f},   /* Filter 56 */
        {-0.0002371416f,  0.0000770520f},
        {-0.0073938545f, -0.0120656740f},
        { 0.0055709461f, -0.0055709461f},
        {-0.0119912065f, -0.0073482208f},
        { 0.0034987353f, -0.0107680001f},
        {-0.0266618363f, -0.0020983320f},
        {-0.0055749551f, -0.0351988810f},
        {-0.0443450753f,  0.0183683316f},
        {-0.0902333778f, -0.1241955898f},
        { 0.0526394683f, -0.0616328986f},
        {-0.2604559850f, -0.1327089529f},
        { 0.1900016255f, -0.7914137269f},
        { 1.1272736788f,  0.0000000000f},
        { 0.2311486623f,  0.9628034699f},
        {-0.4547343575f,  0.2316987279f},
        {-0.0257149127f, -0.0301082944f},
        {-0.0921192010f,  0.1267912028f},
        {-0.0918121412f, -0.0380298341f},
        {-0.0018853566f,  0.0119036728f},
        {-0.0391495774f,  0.0030811386f},
        {-0.0007492498f, -0.0023059538f},
        {-0.0154623435f,  0.0094753363f},
        {-0.0009446795f, -0.0009446795f},
        {-0.0077638924f,  0.0126695209f},
        {-0.0066346301f, -0.0021557220f},
        {-0.0005352062f,  0.0068004397f},
    },
    {
        {-0.0005382632f, -0.0068392824f},   /* Filter 57 */
        {-0.0003143943f,  0.0001021529f},
        {-0.0074123644f, -0.0120958793f},
        { 0.0054999899f, -0.0054999899f},
        {-0.0120642113f, -0.0073929582f},
        { 0.0034576446f, -0.0106415359f},
        {-0.0268620551f, -0.0021140896f},
        {-0.0055459905f, -0.0350160062f},
        {-0.0449300058f,  0.0186106178f},
        {-0.0903881087f, -0.1244085586f},
        { 0.0518769757f, -0.0607401345f},
        {-0.2627752435f, -0.1338906741f},
        { 0.1905817737f, -0.7938302179f},
        { 1.1277797222f,  0.0000000000f},
        { 0.2307108031f,  0.9609796550f},
        {-0.4522382755f,  0.2304269106f},
        {-0.0245235579f, -0.0287133972f},
        {-0.0922424882f,  0.1269608931f},
        {-0.0912340081f, -0.0377903635f},
        {-0.0019483768f,  0.0123015668f},
        {-0.0390502888f,  0.0030733244f},
        {-0.0006860873f, -0.0021115595f},
        {-0.0154528018f,  0.0094694891f},
        {-0.0008565195f, -0.0008565195f},
        {-0.0077740198f,  0.0126860474f},
        {-0.0065558054f, -0.0021301103f},
        {-0.0005382632f,  0.0068392824f},
    },
    {
        {-0.0005413202f, -0.0068781251f},   /* Filter 58 */
        {-0.0003916471f,  0.0001272538f},
        {-0.0074308747f, -0.0121260855f},
        { 0.0054290337f, -0.0054290337f},
        {-0.0121372169f, -0.0074376961f},
        { 0.0034165539f, -0.0105150716f},
        {-0.0270622738f, -0.0021298471f},
        {-0.0055170266f, -0.0348331350f},
        {-0.0455149364f,  0.0188529039f},
        {-0.0905428395f, -0.1246215274f},
        { 0.0511144782f, -0.0598473647f},
        {-0.2650945286f, -0.1350724088f},
        { 0.1911619218f, -0.7962467089f},
        { 1.1282856464f,  0.0000000000f},
        { 0.2302729439f,  0.9591558401f},
        {-0.4497421935f,  0.2291550933f},
        {-0.0233322056f, -0.0273185028f},
        {-0.0923657667f,  0.1271305714f},
        {-0.0906558680f, -0.0375508900f},
        {-0.0020113970f,  0.0126994609f},
        {-0.0389510002f,  0.0030655102f},
        {-0.0006229248f, -0.0019171654f},
        {-0.0154432601f,  0.0094636420f},
        {-0.0007683593f, -0.0007683593f},
        {-0.0077841473f,  0.0127025739f},
        {-0.0064769802f, -0.0021044984f},
        {-0.0005413202f,  0.0068781251f},
    },
    {
        {-0.0005443772f, -0.0069169683f},   /* Filter 59 */
        {-0.0004688998f,  0.0001523548f},
        {-0.0074493851f, -0.0121562916f},
        { 0.0053580775f, -0.0053580775f},
        {-0.0122102217f, -0.0074824335f},
        { 0.0033754634f, -0.0103886083f},
        {-0.0272624925f, -0.0021456047f},
        {-0.0054880621f, -0.0346502602f},
        {-0.0460998635f,  0.0190951887f},
        {-0.0906975704f, -0.1248344962f},
        { 0.0503519808f, -0.0589545949f},
        {-0.2674137870f, -0.1362541301f},
        { 0.1917420700f, -0.7986631999f},
        { 1.1287915707f,  0.0000000000f},
        { 0.2298350986f,  0.9573320831f},
        {-0.4472461115f,  0.2278832760f},
        {-0.0221408533f, -0.0259236084f},
        {-0.0924890451f,  0.1273002496f},
        {-0.0900777280f, -0.0373114166f},
        {-0.0020744172f,  0.0130973549f},
        {-0.0388517116f,  0.0030576960f},
        {-0.0005597622f, -0.0017227710f},
        {-0.0154337184f,  0.0094577948f},
        {-0.0006801991f, -0.0006801991f},
        {-0.0077942742f,  0.0127190995f},
        {-0.0063981555f, -0.0020788868f},
        {-0.0005443772f,  0.0069169683f},
    },
    {
        {-0.0005474342f, -0.0069558110f},   /* Filter 60 */
        {-0.0005461525f,  0.0001774557f},
        {-0.0074678949f, -0.0121864969f},
        { 0.0052871210f, -0.0052871210f},
        {-0.0122832265f, -0.0075271709f},
        { 0.0033343727f, -0.0102621440f},
        {-0.0274627113f, -0.0021613623f},
        {-0.0054590981f, -0.0344673891f},
        {-0.0466847940f,  0.0193374748f},
        {-0.0908522926f, -0.1250474530f},
        { 0.0495894882f, -0.0580618308f},
        {-0.2697330721f, -0.1374358648f},
        { 0.1923222182f, -0.8010796909f},
        { 1.1292974949f,  0.0000000000f},
        { 0.2293972394f,  0.9555082682f},
        {-0.4447500295f,  0.2266114587f},
        {-0.0209494985f, -0.0245287112f},
        {-0.0926123236f,  0.1274699279f},
        {-0.0894995948f, -0.0370719460f},
        {-0.0021374374f,  0.0134952489f},
        {-0.0387524230f,  0.0030498818f},
        {-0.0004965997f, -0.0015283766f},
        {-0.0154241751f,  0.0094519467f},
        {-0.0005920390f, -0.0005920390f},
        {-0.0078044016f,  0.0127356260f},
        {-0.0063193304f, -0.0020532749f},
        {-0.0005474342f,  0.0069558110f},
    },
    {
        {-0.0005503379f, -0.0069927062f},   /* Filter 61 */
        {-0.0006240797f,  0.0002027758f},
        {-0.0074850646f, -0.0122145153f},
        { 0.0052147005f, -0.0052147005f},
        {-0.0123536117f, -0.0075703030f},
        { 0.0032918496f, -0.0101312715f},
        {-0.0276596414f, -0.0021768610f},
        {-0.0054283352f, -0.0342731595f},
        {-0.0472729357f,  0.0195810911f},
        {-0.0909949628f, -0.1252438216f},
        { 0.0488039002f, -0.0571420254f},
        {-0.2720679974f, -0.1386255687f},
        { 0.1928966197f, -0.8034722454f},
        { 1.1297507286f,  0.0000000000f},
        { 0.2289502662f,  0.9536464910f},
        {-0.4422564967f,  0.2253409403f},
        {-0.0197796533f, -0.0231589985f},
        {-0.0927186015f,  0.1276162068f},
        {-0.0889172284f, -0.0368307219f},
        {-0.0021987408f,  0.0138823033f},
        {-0.0386458516f,  0.0030414945f},
        {-0.0004342557f, -0.0013365016f},
        {-0.0154106837f,  0.0094436791f},
        {-0.0005041548f, -0.0005041548f},
        {-0.0078129159f,  0.0127495200f},
        {-0.0062399654f, -0.0020274877f},
        {-0.0005503379f,  0.0069927062f},
    },
    {
        {-0.0005532416f, -0.0070296015f},   /* Filter 62 */
        {-0.0007020068f,  0.0002280958f},
        {-0.0075022343f, -0.0122425338f},
        { 0.0051422800f, -0.0051422800f},
        {-0.0124239968f, -0.0076134350f},
        { 0.0032493266f, -0.0100003989f},
        {-0.0278565697f, -0.0021923596f},
        {-0.0053975722f, -0.0340789300f},
        {-0.0478610739f,  0.0198247059f},
        {-0.0911376329f, -0.1254401903f},
        { 0.0480183122f, -0.0562222200f},
        {-0.2744029228f, -0.1398152726f},
        { 0.1934710212f, -0.8058647998f},
        { 1.1302039623f,  0.0000000000f},
        { 0.2285032930f,  0.9517847137f},
        {-0.4397629639f,  0.2240704219f},
        {-0.0186098068f, -0.0217892842f},
        {-0.0928248793f,  0.1277624857f},
        {-0.0883348550f, -0.0365894950f},
        {-0.0022600442f,  0.0142693578f},
        {-0.0385392839f,  0.0030331074f},
        {-0.0003719117f, -0.0011446265f},
        {-0.0153971922f,  0.0094354115f},
        {-0.0004162707f, -0.0004162707f},
        {-0.0078214307f,  0.0127634149f},
        {-0.0061606009f, -0.0020017006f},
        {-0.0005532416f,  0.0070296015f},
    },
    {
        {-0.0005561454f, -0.0070664968f},   /* Filter 63 */
        {-0.0007799340f,  0.0002534159f},
        {-0.0075194036f, -0.0122705514f},
        { 0.0050698592f, -0.0050698592f},
        {-0.0124943812f, -0.0076565666f},
        { 0.0032068035f, -0.0098695263f},
        {-0.0280534999f, -0.0022078583f},
        {-0.0053668093f, -0.0338847005f},
        {-0.0484492156f,  0.0200683222f},
        {-0.0912802944f, -0.1256365469f},
        { 0.0472327242f, -0.0553024146f},
        {-0.2767378482f, -0.1410049765f},
        { 0.1940454227f, -0.8082573542f},
        { 1.1306571960f,  0.0000000000f},
        { 0.2280563338f,  0.9499229944f},
        {-0.4372694311f,  0.2227999035f},
        {-0.0174399616f, -0.0204195715f},
        {-0.0929311572f,  0.1279087646f},
        {-0.0877524885f, -0.0363482709f},
        {-0.0023213476f,  0.0146564122f},
        {-0.0384327125f,  0.0030247201f},
        {-0.0003095677f, -0.0009527514f},
        {-0.0153837007f,  0.0094271439f},
        {-0.0003283865f, -0.0003283865f},
        {-0.0078299450f,  0.0127773090f},
        {-0.0060812359f, -0.0019759133f},
        {-0.0005561454f,  0.0070664968f},
    },
    {
        {-0.0005590491f, -0.0071033921f},   /* Filter 64 */
        {-0.0008578611f,  0.0002787360f},
        {-0.0075365733f, -0.0122985698f},
        { 0.0049974388f, -0.0049974388f},
        {-0.0125647663f, -0.0076996987f},
        { 0.0031642807f, -0.0097386546f},
        {-0.0282504300f, -0.0022233571f},
        {-0.0053360458f, -0.0336904673f},
        {-0.0490373538f,  0.0203119370f},
        {-0.0914229645f, -0.1258329156f},
        { 0.0464471361f, -0.0543826092f},
        {-0.2790727736f, -0.1421946804f},
        { 0.1946198242f, -0.8106499087f},
        { 1.1311104298f,  0.0000000000f},
        { 0.2276093606f,  0.9480612172f},
        {-0.4347758718f,  0.2215293715f},
        {-0.0162701151f, -0.0190498573f},
        {-0.0930374350f,  0.1280550435f},
        {-0.0871701152f, -0.0361070439f},
        {-0.0023826510f,  0.0150434667f},
        {-0.0383261448f,  0.0030163330f},
        {-0.0002472237f, -0.0007608763f},
        {-0.0153702092f,  0.0094188763f},
        {-0.0002405024f, -0.0002405024f},
        {-0.0078384593f,  0.0127912031f},
        {-0.0060018709f, -0.0019501261f},
        {-0.0005590491f,  0.0071033921f},
    },
    {
        {-0.0005617984f, -0.0071383251f},   /* Filter 65 */
        {-0.0009364015f,  0.0003042553f},
        {-0.0075523775f, -0.0123243601f},
        { 0.0049236074f, -0.0049236074f},
        {-0.0126324404f, -0.0077411695f},
        { 0.0031203471f, -0.0096034410f},
        {-0.0284438432f, -0.0022385790f},
        {-0.0053034780f, -0.0334848426f},
        {-0.0496283453f,  0.0205567337f},
        {-0.0915532675f, -0.1260122621f},
        { 0.0456384527f, -0.0534357625f},
        {-0.2814227020f, -0.1433920287f},
        { 0.1951882703f, -0.8130176572f},
        { 1.1315107346f,  0.0000000000f},
        { 0.2271534544f,  0.9461622311f},
        {-0.4322856848f,  0.2202605579f},
        {-0.0151219560f, -0.0177055357f},
        {-0.0931269400f,  0.1281782366f},
        {-0.0865839766f, -0.0358642574f},
        {-0.0024422213f,  0.0154195785f},
        {-0.0382125024f,  0.0030073892f},
        {-0.0001857442f, -0.0005716617f},
        {-0.0153528220f,  0.0094082214f},
        {-0.0001529710f, -0.0001529710f},
        {-0.0078453653f,  0.0128024727f},
        {-0.0059220378f, -0.0019241867f},
        {-0.0005617984f,  0.0071383251f},
    },
    {
        {-0.0005645477f, -0.0071732585f},   /* Filter 66 */
        {-0.0010149420f,  0.0003297747f},
        {-0.0075681818f, -0.0123501503f},
        { 0.0048497760f, -0.0048497760f},
        {-0.0127001146f, -0.0077826402f},
        { 0.0030764136f, -0.0094682274f},
        {-0.0286372583f, -0.0022538011f},
        {-0.0052709097f, -0.0332792142f},
        {-0.0502193367f,  0.0208015303f},
        {-0.0916835704f, -0.1261916087f},
        { 0.0448297741f, -0.0524889215f},
        {-0.2837726304f, -0.1445893771f},
        { 0.1957567164f, -0.8153854057f},
        { 1.1319110394f,  0.0000000000f},
        { 0.2266975342f,  0.9442631870f},
        {-0.4297954712f,  0.2189917307f},
        {-0.0139737969f, -0.0163612141f},
        {-0.0932164537f,  0.1283014417f},
        {-0.0859978380f, -0.0356214708f},
        {-0.0025017916f,  0.0157956903f},
        {-0.0380988636f,  0.0029984456f},
        {-0.0001242646f, -0.0003824470f},
        {-0.0153354348f,  0.0093975665f},
        {-0.0000654396f, -0.0000654396f},
        {-0.0078522714f,  0.0128137423f},
        {-0.0058422042f, -0.0018982472f},
        {-0.0005645477f,  0.0071732585f},
    },
    {
        {-0.0005672970f, -0.0072081915f},   /* Filter 67 */
        {-0.0010934825f,  0.0003552940f},
        {-0.0075839856f, -0.0123759397f},
        { 0.0047759442f, -0.0047759442f},
        {-0.0127677887f, -0.0078241110f},
        { 0.0030324803f, -0.0093330147f},
        {-0.0288306714f, -0.0022690231f},
        {-0.0052383414f, -0.0330735858f},
        {-0.0508103247f,  0.0210463256f},
        {-0.0918138733f, -0.1263709553f},
        { 0.0440210907f, -0.0515420749f},
        {-0.2861225854f, -0.1457867389f},
        { 0.1963251765f, -0.8177532122f},
        { 1.1323113441f,  0.0000000000f},
        { 0.2262416280f,  0.9423642008f},
        {-0.4273052577f,  0.2177229035f},
        {-0.0128256378f, -0.0150168925f},
        {-0.0933059675f,  0.1284246468f},
        {-0.0854116994f, -0.0353786843f},
        {-0.0025613617f,  0.0161718012f},
        {-0.0379852211f,  0.0029895017f},
        {-0.0000627850f, -0.0001932324f},
        {-0.0153180475f,  0.0093869116f},
        { 0.0000220918f,  0.0000220918f},
        {-0.0078591774f,  0.0128250119f},
        {-0.0057623706f, -0.0018723077f},
        {-0.0005672970f,  0.0072081915f},
    },
    {
        {-0.0005700463f, -0.0072431250f},   /* Filter 68 */
        {-0.0011720231f,  0.0003808134f},
        {-0.0075997899f, -0.0124017299f},
        { 0.0047021128f, -0.0047021128f},
        {-0.0128354629f, -0.0078655818f},
        { 0.0029885468f, -0.0091978012f},
        {-0.0290240865f, -0.0022842452f},
        {-0.0052057730f, -0.0328679574f},
        {-0.0514013161f,  0.0212911222f},
        {-0.0919441762f, -0.1265503019f},
        { 0.0432124121f, -0.0505952339f},
        {-0.2884725138f, -0.1469840873f},
        { 0.1968936226f, -0.8201209607f},
        { 1.1327116489f,  0.0000000000f},
        { 0.2257857078f,  0.9404651568f},
        {-0.4248150707f,  0.2164540899f},
        {-0.0116774775f, -0.0136725695f},
        {-0.0933954725f,  0.1285478398f},
        {-0.0848255540f, -0.0351358949f},
        {-0.0026209318f,  0.0165479121f},
        {-0.0378715823f,  0.0029805582f},
        {-0.0000013054f, -0.0000040177f},
        {-0.0153006603f,  0.0093762567f},
        { 0.0001096232f,  0.0001096232f},
        {-0.0078660834f,  0.0128362816f},
        {-0.0056825375f, -0.0018463684f},
        {-0.0005700463f,  0.0072431250f},
    },
    {
        {-0.0005726402f, -0.0072760831f},   /* Filter 69 */
        {-0.0012511149f,  0.0004065119f},
        {-0.0076142049f, -0.0124252531f},
        { 0.0046269252f, -0.0046269252f},
        {-0.0129003378f, -0.0079053372f},
        { 0.0029432260f, -0.0090583183f},
        {-0.0292137580f, -0.0022991726f},
        {-0.0051713940f, -0.0326508970f},
        {-0.0519947924f,  0.0215369482f},
        {-0.0920618141f, -0.1267122165f},
        { 0.0423806429f, -0.0496213573f},
        {-0.2908367814f, -0.1481887418f},
        { 0.1974559185f, -0.8224630919f},
        { 1.1330589056f,  0.0000000000f},
        { 0.2253210216f,  0.9385295993f},
        {-0.4223289731f,  0.2151873599f},
        {-0.0105511727f, -0.0123538360f},
        {-0.0934684586f,  0.1286482965f},
        {-0.0842360975f, -0.0348917340f},
        {-0.0026787539f,  0.0169129866f},
        {-0.0377510805f,  0.0029710745f},
        { 0.0000592651f,  0.0001823992f},
        {-0.0152794329f,  0.0093632485f},
        { 0.0001967261f,  0.0001967261f},
        {-0.0078713866f,  0.0128449355f},
        {-0.0056023067f, -0.0018202998f},
        {-0.0005726402f,  0.0072760831f},
    },
    {
        {-0.0005752340f, -0.0073090413f},   /* Filter 70 */
        {-0.0013302065f,  0.0004322103f},
        {-0.0076286203f, -0.0124487770f},
        { 0.0045517378f, -0.0045517378f},
        {-0.0129652128f, -0.0079450927f},
        { 0.0028979053f, -0.0089188354f},
        {-0.0294034277f, -0.0023141000f},
        {-0.0051370151f, -0.0324338367f},
        {-0.0525882687f,  0.0217827741f},
        {-0.0921794520f, -0.1268741312f},
        { 0.0415488785f, -0.0486474864f},
        {-0.2932010490f, -0.1493933963f},
        { 0.1980182006f, -0.8248051651f},
        { 1.1334060431f,  0.0000000000f},
        { 0.2248563354f,  0.9365940418f},
        {-0.4198429020f,  0.2139206434f},
        {-0.0094248685f, -0.0110351032f},
        {-0.0935414534f,  0.1287487654f},
        {-0.0836466480f, -0.0346475760f},
        {-0.0027365760f,  0.0172780610f},
        {-0.0376305786f,  0.0029615908f},
        { 0.0001198356f,  0.0003688162f},
        {-0.0152582054f,  0.0093502403f},
        { 0.0002838290f,  0.0002838290f},
        {-0.0078766902f,  0.0128535902f},
        {-0.0055220759f, -0.0017942312f},
        {-0.0005752340f,  0.0073090413f},
    },
    {
        {-0.0005778279f, -0.0073419995f},   /* Filter 71 */
        {-0.0014092982f,  0.0004579088f},
        {-0.0076430353f, -0.0124723001f},
        { 0.0044765501f, -0.0044765501f},
        {-0.0130300878f, -0.0079848481f},
        { 0.0028525846f, -0.0087793526f},
        {-0.0295930992f, -0.0023290274f},
        {-0.0051026361f, -0.0322167763f},
        {-0.0531817451f,  0.0220286001f},
        {-0.0922970898f, -0.1270360458f},
        { 0.0407171093f, -0.0476736098f},
        {-0.2955653432f, -0.1505980644f},
        { 0.1985804965f, -0.8271472963f},
        { 1.1337532997f,  0.0000000000f},
        { 0.2243916352f,  0.9346584264f},
        {-0.4173568043f,  0.2126539134f},
        {-0.0082985637f, -0.0097163697f},
        {-0.0936144395f,  0.1288492221f},
        {-0.0830571916f, -0.0344034152f},
        {-0.0027943978f,  0.0176431337f},
        {-0.0375100767f,  0.0029521071f},
        { 0.0001804062f,  0.0005552331f},
        {-0.0152369780f,  0.0093372321f},
        { 0.0003709319f,  0.0003709319f},
        {-0.0078819938f,  0.0128622449f},
        {-0.0054418451f, -0.0017681627f},
        {-0.0005778279f,  0.0073419995f},
    },
    {
        {-0.0005804218f, -0.0073749577f},   /* Filter 72 */
        {-0.0014883900f,  0.0004836072f},
        {-0.0076574503f, -0.0124958232f},
        { 0.0044013628f, -0.0044013628f},
        {-0.0130949620f, -0.0080246031f},
        { 0.0028072639f, -0.0086398697f},
        {-0.0297827707f, -0.0023439549f},
        {-0.0050682571f, -0.0319997159f},
        {-0.0537752214f,  0.0222744260f},
        {-0.0924147277f, -0.1271979605f},
        { 0.0398853425f, -0.0466997360f},
        {-0.2979296108f, -0.1518027189f},
        { 0.1991427925f, -0.8294894275f},
        { 1.1341005564f,  0.0000000000f},
        { 0.2239269490f,  0.9327228689f},
        {-0.4148707332f,  0.2113871969f},
        {-0.0071722595f, -0.0083976369f},
        {-0.0936874256f,  0.1289496789f},
        {-0.0824677352f, -0.0341592544f},
        {-0.0028522200f,  0.0180082081f},
        {-0.0373895748f,  0.0029426234f},
        { 0.0002409767f,  0.0007416500f},
        {-0.0152157506f,  0.0093242239f},
        { 0.0004580348f,  0.0004580348f},
        {-0.0078872969f,  0.0128708988f},
        {-0.0053616143f, -0.0017420941f},
        {-0.0005804218f,  0.0073749577f},
    },
    {
        {-0.0005828593f, -0.0074059299f},   /* Filter 73 */
        {-0.0015679698f,  0.0005094643f},
        {-0.0076704536f, -0.0125170427f},
        { 0.0043248758f, -0.0043248758f},
        {-0.0131569505f, -0.0080625897f},
        { 0.0027605807f, -0.0084961938f},
        {-0.0299684722f, -0.0023585699f},
        {-0.0050320634f, -0.0317711978f},
        {-0.0543708110f,  0.0225211273f},
        {-0.0925193940f, -0.1273420212f},
        { 0.0390305118f, -0.0456988578f},
        {-0.3003075538f, -0.1530143413f},
        { 0.1996987295f, -0.8318050720f},
        { 1.1343946457f,  0.0000000000f},
        { 0.2234536497f,  0.9307514356f},
        {-0.4123895215f,  0.2101229563f},
        {-0.0060679668f, -0.0071046763f},
        {-0.0937441381f,  0.1290277369f},
        {-0.0818754153f, -0.0339139074f},
        {-0.0029082804f,  0.0183621597f},
        {-0.0372624252f,  0.0029326165f},
        { 0.0003005950f,  0.0009251361f},
        {-0.0151907433f,  0.0093088995f},
        { 0.0005446345f,  0.0005446345f},
        {-0.0078910049f,  0.0128769497f},
        {-0.0052810571f, -0.0017159195f},
        {-0.0005828593f,  0.0074059299f},
    },
    {
        {-0.0005852969f, -0.0074369026f},   /* Filter 74 */
        {-0.0016475497f,  0.0005353213f},
        {-0.0076834565f, -0.0125382614f},
        { 0.0042483892f, -0.0042483892f},
        {-0.0132189391f, -0.0081005763f},
        { 0.0027138976f, -0.0083525178f},
        {-0.0301541737f, -0.0023731849f},
        {-0.0049958691f, -0.0315426760f},
        {-0.0549663971f,  0.0227678271f},
        {-0.0926240690f, -0.1274860940f},
        { 0.0381756786f, -0.0446979767f},
        {-0.3026854967f, -0.1542259638f},
        { 0.2002546527f, -0.8341206585f},
        { 1.1346886158f,  0.0000000000f},
        { 0.2229803504f,  0.9287800022f},
        {-0.4099083363f,  0.2088587294f},
        {-0.0049636747f, -0.0058117164f},
        {-0.0938008418f,  0.1291057828f},
        {-0.0812830954f, -0.0336685605f},
        {-0.0029643405f,  0.0187161094f},
        {-0.0371352756f,  0.0029226096f},
        { 0.0003602132f,  0.0011086223f},
        {-0.0151657345f,  0.0092935740f},
        { 0.0006312342f,  0.0006312342f},
        {-0.0078947129f,  0.0128830006f},
        {-0.0052004999f, -0.0016897448f},
        {-0.0005852969f,  0.0074369026f},
    },
    {
        {-0.0005877345f, -0.0074678748f},   /* Filter 75 */
        {-0.0017271295f,  0.0005611784f},
        {-0.0076964598f, -0.0125594809f},
        { 0.0041719022f, -0.0041719022f},
        {-0.0132809268f, -0.0081385624f},
        { 0.0026672144f, -0.0082088419f},
        {-0.0303398733f, -0.0023877998f},
        {-0.0049596754f, -0.0313141580f},
        {-0.0555619866f,  0.0230145284f},
        {-0.0927287353f, -0.1276301548f},
        { 0.0373208455f, -0.0436970957f},
        {-0.3050634397f, -0.1554375863f},
        { 0.2008105897f, -0.8364363030f},
        { 1.1349827051f,  0.0000000000f},
        { 0.2225070651f,  0.9268086269f},
        {-0.4074271512f,  0.2075945024f},
        {-0.0038593824f, -0.0045187562f},
        {-0.0938575543f,  0.1291838409f},
        {-0.0806907754f, -0.0334232135f},
        {-0.0030204009f,  0.0190700610f},
        {-0.0370081261f,  0.0029126027f},
        { 0.0004198315f,  0.0012921084f},
        {-0.0151407272f,  0.0092782496f},
        { 0.0007178340f,  0.0007178340f},
        {-0.0078984209f,  0.0128890516f},
        {-0.0051199431f, -0.0016635704f},
        {-0.0005877345f,  0.0074678748f},
    },
    {
        {-0.0005901721f, -0.0074988475f},   /* Filter 76 */
        {-0.0018067094f,  0.0005870355f},
        {-0.0077094631f, -0.0125807004f},
        { 0.0040954155f, -0.0040954155f},
        {-0.0133429153f, -0.0081765490f},
        { 0.0026205313f, -0.0080651659f},
        {-0.0305255747f, -0.0024024148f},
        {-0.0049234811f, -0.0310856362f},
        {-0.0561575762f,  0.0232612297f},
        {-0.0928334103f, -0.1277742276f},
        { 0.0364660123f, -0.0426962147f},
        {-0.3074413826f, -0.1566492087f},
        { 0.2013665268f, -0.8387519475f},
        { 1.1352766752f,  0.0000000000f},
        { 0.2220337658f,  0.9248371935f},
        {-0.4049459660f,  0.2063302754f},
        {-0.0027550900f, -0.0032257959f},
        {-0.0939142668f,  0.1292618989f},
        {-0.0800984555f, -0.0331778666f},
        {-0.0030764614f,  0.0194240126f},
        {-0.0368809765f,  0.0029025958f},
        { 0.0004794497f,  0.0014755945f},
        {-0.0151157199f,  0.0092629251f},
        { 0.0008044338f,  0.0008044338f},
        {-0.0079021289f,  0.0128951025f},
        {-0.0050393859f, -0.0016373957f},
        {-0.0005901721f,  0.0074988475f},
    },
    {
        {-0.0005924526f, -0.0075278244f},   /* Filter 77 */
        {-0.0018867132f,  0.0006130303f},
        {-0.0077210329f, -0.0125995805f},
        { 0.0040176875f, -0.0040176875f},
        {-0.0134019299f, -0.0082127132f},
        { 0.0025725119f, -0.0079173775f},
        {-0.0307070777f, -0.0024166994f},
        {-0.0048854694f, -0.0308456401f},
        {-0.0567548969f,  0.0235086480f},
        {-0.0929248246f, -0.1279000486f},
        { 0.0355881418f, -0.0416683603f},
        {-0.3098323105f, -0.1578674473f},
        { 0.2019159101f, -0.8410402939f},
        { 1.1355174780f,  0.0000000000f},
        { 0.2215520344f,  0.9228306378f},
        {-0.4024704369f,  0.2050689303f},
        {-0.0016729569f, -0.0019587808f},
        {-0.0939549596f,  0.1293179078f},
        {-0.0795037126f, -0.0329315160f},
        {-0.0031307478f,  0.0197667639f},
        {-0.0367473946f,  0.0028920827f},
        { 0.0005380737f,  0.0016560207f},
        {-0.0150869932f,  0.0092453213f},
        { 0.0008904566f,  0.0008904566f},
        {-0.0079042501f,  0.0128985639f},
        {-0.0049585732f, -0.0016111381f},
        {-0.0005924526f,  0.0075278244f},
    },
    {
        {-0.0005947332f, -0.0075568019f},   /* Filter 78 */
        {-0.0019667173f,  0.0006390252f},
        {-0.0077326026f, -0.0126184606f},
        { 0.0039399598f, -0.0039399598f},
        {-0.0134609462f, -0.0082488784f},
        { 0.0025244925f, -0.0077695890f},
        {-0.0308885807f, -0.0024309840f},
        {-0.0048474578f, -0.0306056440f},
        {-0.0573522177f,  0.0237560664f},
        {-0.0930162303f, -0.1280258577f},
        { 0.0347102737f, -0.0406405089f},
        {-0.3122232384f, -0.1590856859f},
        { 0.2024652796f, -0.8433285823f},
        { 1.1357581615f,  0.0000000000f},
        { 0.2210703030f,  0.9208240820f},
        {-0.3999949343f,  0.2038075987f},
        {-0.0005908237f, -0.0006917657f},
        {-0.0939956437f,  0.1293739046f},
        {-0.0789089766f, -0.0326851683f},
        {-0.0031850346f,  0.0201095172f},
        {-0.0366138164f,  0.0028815699f},
        { 0.0005966978f,  0.0018364470f},
        {-0.0150582664f,  0.0092277175f},
        { 0.0009764796f,  0.0009764796f},
        {-0.0079063713f,  0.0129020253f},
        {-0.0048777604f, -0.0015848804f},
        {-0.0005947332f,  0.0075568019f},
    },
    {
        {-0.0005970138f, -0.0075857793f},   /* Filter 79 */
        {-0.0020467211f,  0.0006650200f},
        {-0.0077441724f, -0.0126373407f},
        { 0.0038622318f, -0.0038622318f},
        {-0.0135199624f, -0.0082850436f},
        { 0.0024764734f, -0.0076218015f},
        {-0.0310700838f, -0.0024452686f},
        {-0.0048094459f, -0.0303656461f},
        {-0.0579495384f,  0.0240034847f},
        {-0.0931076446f, -0.1281516788f},
        { 0.0338324031f, -0.0396126545f},
        {-0.3146141398f, -0.1603039110f},
        { 0.2030146629f, -0.8456169287f},
        { 1.1359989643f,  0.0000000000f},
        { 0.2205885716f,  0.9188175263f},
        {-0.3975194052f,  0.2025462536f},
        { 0.0004913094f,  0.0005752494f},
        {-0.0940363365f,  0.1294299135f},
        {-0.0783142406f, -0.0324388206f},
        {-0.0032393211f,  0.0204522686f},
        {-0.0364802345f,  0.0028710567f},
        { 0.0006553218f,  0.0020168732f},
        {-0.0150295397f,  0.0092101138f},
        { 0.0010625026f,  0.0010625026f},
        {-0.0079084924f,  0.0129054867f},
        {-0.0047969477f, -0.0015586228f},
        {-0.0005970138f,  0.0075857793f},
    },
    {
        {-0.0005992944f, -0.0076147568f},   /* Filter 80 */
        {-0.0021267252f,  0.0006910149f},
        {-0.0077557421f, -0.0126562208f},
        { 0.0037845042f, -0.0037845041f},
        {-0.0135789771f, -0.0083212079f},
        { 0.0024284540f, -0.0074740130f},
        {-0.0312515886f, -0.0024595534f},
        {-0.0047714342f, -0.0301256501f},
        {-0.0585468626f,  0.0242509045f},
        {-0.0931990590f, -0.1282774999f},
        { 0.0329545326f, -0.0385848002f},
        {-0.3170050676f, -0.1615221496f},
        { 0.2035640463f, -0.8479052751f},
        { 1.1362396479f,  0.0000000000f},
        { 0.2201068402f,  0.9168109706f},
        {-0.3950438760f,  0.2012849085f},
        { 0.0015734425f,  0.0018422645f},
        {-0.0940770206f,  0.1294859103f},
        {-0.0777195046f, -0.0321924729f},
        {-0.0032936076f,  0.0207950200f},
        {-0.0363466526f,  0.0028605436f},
        { 0.0007139459f,  0.0021972994f},
        {-0.0150008129f,  0.0091925100f},
        { 0.0011485256f,  0.0011485256f},
        {-0.0079106136f,  0.0129089481f},
        {-0.0047161350f, -0.0015323651f},
        {-0.0005992944f,  0.0076147568f},
    },
    {
        {-0.0006014173f, -0.0076417320f},   /* Filter 81 */
        {-0.0022070882f,  0.0007171264f},
        {-0.0077658579f, -0.0126727282f},
        { 0.0037055950f, -0.0037055950f},
        {-0.0136349377f, -0.0083555006f},
        { 0.0023791261f, -0.0073221971f},
        {-0.0314286666f, -0.0024734897f},
        {-0.0047316029f, -0.0298741650f},
        {-0.0591455290f,  0.0244988803f},
        {-0.0932769149f, -0.1283846594f},
        { 0.0320536683f, -0.0375300236f},
        {-0.3194082901f, -0.1627466526f},
        { 0.2041066672f, -0.8501654540f},
        { 1.1364269257f,  0.0000000000f},
        { 0.2196168575f,  0.9147700459f},
        {-0.3925747995f,  0.2000268512f},
        { 0.0026332804f,  0.0030831752f},
        {-0.0941019478f,  0.1295202197f},
        {-0.0771227862f, -0.0319453040f},
        {-0.0033461099f,  0.0211265068f},
        {-0.0362068575f,  0.0028495415f},
        { 0.0007715352f,  0.0023745411f},
        {-0.0149684318f,  0.0091726668f},
        { 0.0012338993f,  0.0012338993f},
        {-0.0079111576f,  0.0129098359f},
        {-0.0046351367f, -0.0015060472f},
        {-0.0006014173f,  0.0076417320f},
    },
    {
        {-0.0006035403f, -0.0076687068f},   /* Filter 82 */
        {-0.0022874514f,  0.0007432380f},
        {-0.0077759731f, -0.0126892349f},
        { 0.0036266859f, -0.0036266859f},
        {-0.0136908967f, -0.0083897923f},
        { 0.0023297982f, -0.0071703817f},
        {-0.0316057446f, -0.0024874261f},
        {-0.0046917716f, -0.0296226799f},
        {-0.0597441955f,  0.0247468560f},
        {-0.0933547709f, -0.1284918188f},
        { 0.0311528015f, -0.0364752441f},
        {-0.3218115125f, -0.1639711556f},
        { 0.2046492882f, -0.8524256329f},
        { 1.1366143227f,  0.0000000000f},
        { 0.2191268748f,  0.9127291212f},
        {-0.3901057230f,  0.1987687939f},
        { 0.0036931185f,  0.0043240861f},
        {-0.0941268663f,  0.1295545170f},
        {-0.0765260746f, -0.0316981380f},
        {-0.0033986123f,  0.0214579936f},
        {-0.0360670624f,  0.0028385394f},
        { 0.0008291245f,  0.0025517827f},
        {-0.0149360507f,  0.0091528236f},
        { 0.0013192730f,  0.0013192730f},
        {-0.0079117016f,  0.0129107237f},
        {-0.0045541388f, -0.0014797294f},
        {-0.0006035403f,  0.0076687068f},
    },
    {
        {-0.0006056633f, -0.0076956820f},   /* Filter 83 */
        {-0.0023678146f,  0.0007693496f},
        {-0.0077860889f, -0.0127057422f},
        { 0.0035477772f, -0.0035477772f},
        {-0.0137468558f, -0.0084240841f},
        { 0.0022804704f, -0.0070185662f},
        {-0.0317828226f, -0.0025013624f},
        {-0.0046519403f, -0.0293711948f},
        {-0.0603428619f,  0.0249948318f},
        {-0.0934326268f, -0.1285989783f},
        { 0.0302519348f, -0.0354204647f},
        {-0.3242147084f, -0.1651956450f},
        { 0.2051919091f, -0.8546858118f},
        { 1.1368016005f,  0.0000000000f},
        { 0.2186368782f,  0.9106881385f},
        {-0.3876366199f,  0.1975107231f},
        { 0.0047529565f,  0.0055649970f},
        {-0.0941517847f,  0.1295888143f},
        {-0.0759293562f, -0.0314509691f},
        {-0.0034511144f,  0.0217894786f},
        {-0.0359272672f,  0.0028275373f},
        { 0.0008867137f,  0.0027290242f},
        {-0.0149036696f,  0.0091329805f},
        { 0.0014046468f,  0.0014046468f},
        {-0.0079122457f,  0.0129116115f},
        {-0.0044731409f, -0.0014534116f},
        {-0.0006056633f,  0.0076956820f},
    },
    {
        {-0.0006077863f, -0.0077226572f},   /* Filter 84 */
        {-0.0024481778f,  0.0007954612f},
        {-0.0077962046f, -0.0127222496f},
        { 0.0034688681f, -0.0034688680f},
        {-0.0138028164f, -0.0084583768f},
        { 0.0022311426f, -0.0068667507f},
        {-0.0319599006f, -0.0025152987f},
        {-0.0046121089f, -0.0291197098f},
        {-0.0609415284f,  0.0252428076f},
        {-0.0935104915f, -0.1287061499f},
        { 0.0293510680f, -0.0343656852f},
        {-0.3266179308f, -0.1664201480f},
        { 0.2057345440f, -0.8569460487f},
        { 1.1369889975f,  0.0000000000f},
        { 0.2181468956f,  0.9086472139f},
        {-0.3851675434f,  0.1962526657f},
        { 0.0058127945f,  0.0068059079f},
        {-0.0941767119f,  0.1296231237f},
        {-0.0753326446f, -0.0312038031f},
        {-0.0035036167f,  0.0221209654f},
        {-0.0357874721f,  0.0028165352f},
        { 0.0009443030f,  0.0029062657f},
        {-0.0148712885f,  0.0091131373f},
        { 0.0014900205f,  0.0014900205f},
        {-0.0079127897f,  0.0129124992f},
        {-0.0043921426f, -0.0014270936f},
        {-0.0006077863f,  0.0077226572f},
    },
    {
        {-0.0006097513f, -0.0077476247f},   /* Filter 85 */
        {-0.0025288345f,  0.0008216681f},
        {-0.0078048464f, -0.0127363518f},
        { 0.0033888394f, -0.0033888394f},
        {-0.0138556372f, -0.0084907454f},
        { 0.0021805355f, -0.0067109982f},
        {-0.0321323290f, -0.0025288691f},
        {-0.0045704576f, -0.0288567339f},
        {-0.0615411447f,  0.0254911768f},
        {-0.0935744999f, -0.1287942500f},
        { 0.0284272558f, -0.0332840401f},
        {-0.3290327308f, -0.1676505501f},
        { 0.2062702077f, -0.8591772487f},
        { 1.1371228695f,  0.0000000000f},
        { 0.2176488286f,  0.9065726157f},
        {-0.3827056631f,  0.1949982750f},
        { 0.0068502118f,  0.0080205675f},
        {-0.0941861275f,  0.1296360831f},
        {-0.0747343912f, -0.0309559984f},
        {-0.0035543253f,  0.0224411270f},
        {-0.0356416792f,  0.0028050610f},
        { 0.0010008183f,  0.0030802021f},
        {-0.0148353213f,  0.0090910966f},
        { 0.0015746739f,  0.0015746739f},
        {-0.0079117673f,  0.0129108309f},
        {-0.0043110296f, -0.0014007384f},
        {-0.0006097513f,  0.0077476247f},
    },
    {
        {-0.0006117162f, -0.0077725917f},   /* Filter 86 */
        {-0.0026094911f,  0.0008478751f},
        {-0.0078134887f, -0.0127504547f},
        { 0.0033088108f, -0.0033088108f},
        {-0.0139084580f, -0.0085231140f},
        { 0.0021299283f, -0.0065552451f},
        {-0.0323047536f, -0.0025424393f},
        {-0.0045288066f, -0.0285937598f},
        {-0.0621407680f,  0.0257395489f},
        {-0.0936385172f, -0.1288823621f},
        { 0.0275034412f, -0.0322023922f},
        {-0.3314475308f, -0.1688809521f},
        { 0.2068058854f, -0.8614085067f},
        { 1.1372566223f,  0.0000000000f},
        { 0.2171507756f,  0.9044980755f},
        {-0.3802437562f,  0.1937438708f},
        { 0.0078876297f,  0.0092352279f},
        {-0.0941955519f,  0.1296490546f},
        {-0.0741361378f, -0.0307081937f},
        {-0.0036050339f,  0.0227612885f},
        {-0.0354958901f,  0.0027935871f},
        { 0.0010573337f,  0.0032541385f},
        {-0.0147993525f,  0.0090690549f},
        { 0.0016593274f,  0.0016593274f},
        {-0.0079107454f,  0.0129091633f},
        {-0.0042299166f, -0.0013743832f},
        {-0.0006117162f,  0.0077725917f},
    },
    {
        {-0.0006136812f, -0.0077975591f},   /* Filter 87 */
        {-0.0026901479f,  0.0008740821f},
        {-0.0078221305f, -0.0127645568f},
        { 0.0032287821f, -0.0032287821f},
        {-0.0139612788f, -0.0085554827f},
        { 0.0020793210f, -0.0063994921f},
        {-0.0324771819f, -0.0025560097f},
        {-0.0044871553f, -0.0283307839f},
        {-0.0627403844f,  0.0259879181f},
        {-0.0937025344f, -0.1289704742f},
        { 0.0265796290f, -0.0311207471f},
        {-0.3338623308f, -0.1701113542f},
        { 0.2073415630f, -0.8636397647f},
        { 1.1373904943f,  0.0000000000f},
        { 0.2166527086f,  0.9024234774f},
        {-0.3777818758f,  0.1924894801f},
        { 0.0089250471f,  0.0104498875f},
        {-0.0942049674f,  0.1296620140f},
        {-0.0735378774f, -0.0304603862f},
        {-0.0036557426f,  0.0230814501f},
        {-0.0353500972f,  0.0027821130f},
        { 0.0011138490f,  0.0034280747f},
        {-0.0147633837f,  0.0090470132f},
        { 0.0017439806f,  0.0017439806f},
        {-0.0079097235f,  0.0129074957f},
        {-0.0041488032f, -0.0013480279f},
        {-0.0006136812f,  0.0077975591f},
    },
    {
        {-0.0006156462f, -0.0078225271f},   /* Filter 88 */
        {-0.0027708046f,  0.0009002890f},
        {-0.0078307727f, -0.0127786597f},
        { 0.0031487535f, -0.0031487535f},
        {-0.0140140997f, -0.0085878513f},
        { 0.0020287140f, -0.0062437396f},
        {-0.0326496065f, -0.0025695798f},
        {-0.0044455040f, -0.0280678079f},
        {-0.0633400076f,  0.0262362902f},
        {-0.0937665516f, -0.1290585864f},
        { 0.0256558144f, -0.0300390992f},
        {-0.3362771308f, -0.1713417562f},
        { 0.2078772268f, -0.8658709647f},
        { 1.1375243664f,  0.0000000000f},
        { 0.2161546417f,  0.9003488792f},
        {-0.3753199689f,  0.1912350759f},
        { 0.0099624644f,  0.0116645471f},
        {-0.0942143918f,  0.1296749855f},
        {-0.0729396240f, -0.0302125815f},
        {-0.0037064512f,  0.0234016117f},
        {-0.0352043080f,  0.0027706391f},
        { 0.0011703643f,  0.0036020110f},
        {-0.0147274149f,  0.0090249715f},
        { 0.0018286340f,  0.0018286340f},
        {-0.0079087017f,  0.0129058281f},
        {-0.0040676902f, -0.0013216727f},
        {-0.0006156462f,  0.0078225271f},
    },
    {
        {-0.0006174529f, -0.0078454830f},   /* Filter 89 */
        {-0.0028516882f,  0.0009265697f},
        {-0.0078379226f, -0.0127903272f},
        { 0.0030676679f, -0.0030676679f},
        {-0.0140637028f, -0.0086182482f},
        { 0.0019768581f, -0.0060841437f},
        {-0.0328171549f, -0.0025827661f},
        {-0.0044020342f, -0.0277933504f},
        {-0.0639401746f,  0.0264848875f},
        {-0.0938164323f, -0.1291272413f},
        { 0.0247091173f, -0.0289306593f},
        {-0.3387028179f, -0.1725777056f},
        { 0.2084057663f, -0.8680724904f},
        { 1.1376047134f,  0.0000000000f},
        { 0.2156486853f,  0.8982414190f},
        {-0.3728660282f,  0.1899847307f},
        { 0.0109773469f,  0.0128528219f},
        {-0.0942085673f,  0.1296669688f},
        {-0.0723402623f, -0.0299643177f},
        {-0.0037553584f,  0.0237104001f},
        {-0.0350527438f,  0.0027587108f},
        { 0.0012257680f,  0.0037725260f},
        {-0.0146879283f,  0.0090007741f},
        { 0.0019124969f,  0.0019124969f},
        {-0.0079061260f,  0.0129016251f},
        {-0.0039865316f, -0.0012953026f},
        {-0.0006174529f,  0.0078454830f},
    },
    {
        {-0.0006192596f, -0.0078684390f},   /* Filter 90 */
        {-0.0029325720f,  0.0009528504f},
        {-0.0078450724f, -0.0128019946f},
        { 0.0029865827f, -0.0029865826f},
        {-0.0141133060f, -0.0086486451f},
        { 0.0019250022f, -0.0059245475f},
        {-0.0329847033f, -0.0025959525f},
        {-0.0043585641f, -0.0275188910f},
        {-0.0645403486f,  0.0267334877f},
        {-0.0938663217f, -0.1291959082f},
        { 0.0237624178f, -0.0278222165f},
        {-0.3411284786f, -0.1738136414f},
        { 0.2089342920f, -0.8702739581f},
        { 1.1376850605f,  0.0000000000f},
        { 0.2151427288f,  0.8961339588f},
        {-0.3704120876f,  0.1887343854f},
        { 0.0119922295f,  0.0140410967f},
        {-0.0942027515f,  0.1296589641f},
        {-0.0717408937f, -0.0297160511f},
        {-0.0038042657f,  0.0240191886f},
        {-0.0349011797f,  0.0027467824f},
        { 0.0012811716f,  0.0039430408f},
        {-0.0146484418f,  0.0089765767f},
        { 0.0019963599f,  0.0019963599f},
        {-0.0079035503f,  0.0128974220f},
        {-0.0039053725f, -0.0012689324f},
        {-0.0006192596f,  0.0078684390f},
    },
    {
        {-0.0006210662f, -0.0078913950f},   /* Filter 91 */
        {-0.0030134556f,  0.0009791311f},
        {-0.0078522227f, -0.0128136629f},
        { 0.0029054974f, -0.0029054974f},
        {-0.0141629076f, -0.0086790410f},
        { 0.0018731464f, -0.0057649517f},
        {-0.0331522516f, -0.0026091388f},
        {-0.0043150940f, -0.0272444315f},
        {-0.0651405225f,  0.0269820879f},
        {-0.0939162024f, -0.1292645631f},
        { 0.0228157207f, -0.0267137766f},
        {-0.3435541657f, -0.1750495907f},
        { 0.2094628176f, -0.8724754258f},
        { 1.1377654076f,  0.0000000000f},
        { 0.2146367724f,  0.8940264986f},
        {-0.3679581469f,  0.1874840402f},
        { 0.0130071121f,  0.0152293715f},
        {-0.0941969357f,  0.1296509593f},
        {-0.0711415321f, -0.0294677874f},
        {-0.0038531730f,  0.0243279770f},
        {-0.0347496118f,  0.0027348538f},
        { 0.0013365752f,  0.0041135556f},
        {-0.0146089552f,  0.0089523793f},
        { 0.0020802229f,  0.0020802229f},
        {-0.0079009747f,  0.0128932189f},
        {-0.0038242139f, -0.0012425624f},
        {-0.0006210662f,  0.0078913950f},
    },
    {
        {-0.0006228729f, -0.0079143509f},   /* Filter 92 */
        {-0.0030943394f,  0.0010054118f},
        {-0.0078593725f, -0.0128253304f},
        { 0.0028244121f, -0.0028244121f},
        {-0.0142125108f, -0.0087094378f},
        { 0.0018212905f, -0.0056053559f},
        {-0.0333198000f, -0.0026223251f},
        {-0.0042716242f, -0.0269699740f},
        {-0.0657406895f,  0.0272306852f},
        {-0.0939660919f, -0.1293332301f},
        { 0.0218690211f, -0.0256053339f},
        {-0.3459798529f, -0.1762855401f},
        { 0.2099913432f, -0.8746768935f},
        { 1.1378457546f,  0.0000000000f},
        { 0.2141308021f,  0.8919189804f},
        {-0.3655041796f,  0.1862336815f},
        { 0.0140219947f,  0.0164176464f},
        {-0.0941911200f,  0.1296429546f},
        {-0.0705421635f, -0.0292195208f},
        {-0.0039020803f,  0.0246367655f},
        {-0.0345980476f,  0.0027229254f},
        { 0.0013919788f,  0.0042840704f},
        {-0.0145694686f,  0.0089281819f},
        { 0.0021640857f,  0.0021640857f},
        {-0.0078983990f,  0.0128890158f},
        {-0.0037430548f, -0.0012161922f},
        {-0.0006228729f,  0.0079143509f},
    },
    {
        {-0.0006245211f, -0.0079352931f},   /* Filter 93 */
        {-0.0031753829f,  0.0010317444f},
        {-0.0078650134f, -0.0128345354f},
        { 0.0027423344f, -0.0027423344f},
        {-0.0142588170f, -0.0087378143f},
        { 0.0017682182f, -0.0054420161f},
        {-0.0334822456f, -0.0026351099f},
        {-0.0042263377f, -0.0266840458f},
        {-0.0663410080f,  0.0274793452f},
        {-0.0940015646f, -0.1293820540f},
        { 0.0208995092f, -0.0244701813f},
        {-0.3484156837f, -0.1775266579f},
        { 0.2105125499f, -0.8768478754f},
        { 1.1378724575f,  0.0000000000f},
        { 0.2136171370f,  0.8897794116f},
        {-0.3630589221f,  0.1849877605f},
        { 0.0150142391f,  0.0175794153f},
        {-0.0941703356f,  0.1296143474f},
        {-0.0699421135f, -0.0289709720f},
        {-0.0039491796f,  0.0249341385f},
        {-0.0344409313f,  0.0027105601f},
        { 0.0014462343f,  0.0044510515f},
        {-0.0145265341f,  0.0089018716f},
        { 0.0022470897f,  0.0022470897f},
        {-0.0078942833f,  0.0128822995f},
        {-0.0036619194f, -0.0011898297f},
        {-0.0006245211f,  0.0079352931f},
    },
    {
        {-0.0006261694f, -0.0079562362f},   /* Filter 94 */
        {-0.0032564264f,  0.0010580771f},
        {-0.0078706542f, -0.0128437404f},
        { 0.0026602567f, -0.0026602567f},
        {-0.0143051231f, -0.0087661907f},
        { 0.0017151457f, -0.0052786758f},
        {-0.0336446912f, -0.0026478946f},
        {-0.0041810511f, -0.0263981176f},
        {-0.0669413265f,  0.0277280053f},
        {-0.0940370372f, -0.1294308779f},
        { 0.0199299961f, -0.0233350273f},
        {-0.3508515145f, -0.1787677757f},
        { 0.2110337426f, -0.8790187993f},
        { 1.1378992796f,  0.0000000000f},
        { 0.2131034720f,  0.8876398428f},
        {-0.3606136646f,  0.1837418396f},
        { 0.0160064835f,  0.0187411843f},
        {-0.0941495513f,  0.1295857402f},
        {-0.0693420635f, -0.0287224231f},
        {-0.0039962791f,  0.0252315134f},
        {-0.0342838150f,  0.0026981948f},
        { 0.0015004899f,  0.0046180330f},
        {-0.0144836012f,  0.0088755623f},
        { 0.0023300936f,  0.0023300936f},
        {-0.0078901675f,  0.0128755831f},
        {-0.0035807841f, -0.0011634673f},
        {-0.0006261694f,  0.0079562362f},
    },
    {
        {-0.0006278175f, -0.0079771783f},   /* Filter 95 */
        {-0.0033374698f,  0.0010844097f},
        {-0.0078762955f, -0.0128529462f},
        { 0.0025781792f, -0.0025781792f},
        {-0.0143514293f, -0.0087945672f},
        { 0.0016620733f, -0.0051153355f},
        {-0.0338071368f, -0.0026606794f},
        {-0.0041357645f, -0.0261121894f},
        {-0.0675416449f,  0.0279766653f},
        {-0.0940725099f, -0.1294797019f},
        { 0.0189604842f, -0.0221998747f},
        {-0.3532873453f, -0.1800088935f},
        { 0.2115549353f, -0.8811897233f},
        { 1.1379261017f,  0.0000000000f},
        { 0.2125897931f,  0.8855002161f},
        {-0.3581684071f,  0.1824959187f},
        { 0.0169987279f,  0.0199029532f},
        {-0.0941287669f,  0.1295571330f},
        {-0.0687420134f, -0.0284738743f},
        {-0.0040433784f,  0.0255288864f},
        {-0.0341266987f,  0.0026858294f},
        { 0.0015547453f,  0.0047850141f},
        {-0.0144406684f,  0.0088492530f},
        { 0.0024130976f,  0.0024130976f},
        {-0.0078860517f,  0.0128688668f},
        {-0.0034996487f, -0.0011371048f},
        {-0.0006278175f,  0.0079771783f},
    },
    {
        {-0.0006294658f, -0.0079981214f},   /* Filter 96 */
        {-0.0034185133f,  0.0011107423f},
        {-0.0078819364f, -0.0128621512f},
        { 0.0024961015f, -0.0024961015f},
        {-0.0143977355f, -0.0088229436f},
        { 0.0016090008f, -0.0049519952f},
        {-0.0339695824f, -0.0026734641f},
        {-0.0040904779f, -0.0258262613f},
        {-0.0681419634f,  0.0282253254f},
        {-0.0941079825f, -0.1295285258f},
        { 0.0179909711f, -0.0210647207f},
        {-0.3557231761f, -0.1812500113f},
        { 0.2120761280f, -0.8833606473f},
        { 1.1379528046f,  0.0000000000f},
        { 0.2120761280f,  0.8833606473f},
        {-0.3557231761f,  0.1812500113f},
        { 0.0179909711f,  0.0210647207f},
        {-0.0941079825f,  0.1295285258f},
        {-0.0681419634f, -0.0282253254f},
        {-0.0040904779f,  0.0258262613f},
        {-0.0339695824f,  0.0026734641f},
        { 0.0016090008f,  0.0049519952f},
        {-0.0143977355f,  0.0088229436f},
        { 0.0024961015f,  0.0024961015f},
        {-0.0078819364f,  0.0128621512f},
        {-0.0034185133f, -0.0011107423f},
        {-0.0006294658f,  0.0079981214f},
    },
    {
        {-0.0006309556f, -0.0080170507f},   /* Filter 97 */
        {-0.0034996487f,  0.0011371048f},
        {-0.0078860517f, -0.0128688668f},
        { 0.0024130976f, -0.0024130976f},
        {-0.0144406684f, -0.0088492530f},
        { 0.0015547453f, -0.0047850141f},
        {-0.0341266987f, -0.0026858294f},
        {-0.0040433784f, -0.0255288864f},
        {-0.0687420134f,  0.0284738743f},
        {-0.0941287669f, -0.1295571330f},
        { 0.0169987279f, -0.0199029532f},
        {-0.3581684071f, -0.1824959187f},
        { 0.2125897931f, -0.8855002161f},
        { 1.1379261017f,  0.0000000000f},
        { 0.2115549353f,  0.8811897233f},
        {-0.3532873453f,  0.1800088935f},
        { 0.0189604842f,  0.0221998747f},
        {-0.0940725099f,  0.1294797019f},
        {-0.0675416449f, -0.0279766653f},
        {-0.0041357645f,  0.0261121894f},
        {-0.0338071368f,  0.0026606794f},
        { 0.0016620733f,  0.0051153355f},
        {-0.0143514293f,  0.0087945672f},
        { 0.0025781792f,  0.0025781792f},
        {-0.0078762955f,  0.0128529462f},
        {-0.0033374698f, -0.0010844097f},
        {-0.0006309556f,  0.0080170507f},
    },
    {
        {-0.0006324453f, -0.0080359799f},   /* Filter 98 */
        {-0.0035807841f,  0.0011634673f},
        {-0.0078901675f, -0.0128755831f},
        { 0.0023300936f, -0.0023300936f},
        {-0.0144836012f, -0.0088755623f},
        { 0.0015004899f, -0.0046180330f},
        {-0.0342838150f, -0.0026981948f},
        {-0.0039962791f, -0.0252315134f},
        {-0.0693420635f,  0.0287224231f},
        {-0.0941495513f, -0.1295857402f},
        { 0.0160064835f, -0.0187411843f},
        {-0.3606136646f, -0.1837418396f},
        { 0.2131034720f, -0.8876398428f},
        { 1.1378992796f,  0.0000000000f},
        { 0.2110337426f,  0.8790187993f},
        {-0.3508515145f,  0.1787677757f},
        { 0.0199299961f,  0.0233350273f},
        {-0.0940370372f,  0.1294308779f},
        {-0.0669413265f, -0.0277280053f},
        {-0.0041810511f,  0.0263981176f},
        {-0.0336446912f,  0.0026478946f},
        { 0.0017151457f,  0.0052786758f},
        {-0.0143051231f,  0.0087661907f},
        { 0.0026602567f,  0.0026602567f},
        {-0.0078706542f,  0.0128437404f},
        {-0.0032564264f, -0.0010580771f},
        {-0.0006324453f,  0.0080359799f},
    },
    {
        {-0.0006339352f, -0.0080549101f},   /* Filter 99 */
        {-0.0036619194f,  0.0011898297f},
        {-0.0078942833f, -0.0128822995f},
        { 0.0022470897f, -0.0022470897f},
        {-0.0145265341f, -0.0089018716f},
        { 0.0014462343f, -0.0044510515f},
        {-0.0344409313f, -0.0027105601f},
        {-0.0039491796f, -0.0249341385f},
        {-0.0699421135f,  0.0289709720f},
        {-0.0941703356f, -0.1296143474f},
        { 0.0150142391f, -0.0175794153f},
        {-0.3630589221f, -0.1849877605f},
        { 0.2136171370f, -0.8897794116f},
        { 1.1378724575f,  0.0000000000f},
        { 0.2105125499f,  0.8768478754f},
        {-0.3484156837f,  0.1775266579f},
        { 0.0208995092f,  0.0244701813f},
        {-0.0940015646f,  0.1293820540f},
        {-0.0663410080f, -0.0274793452f},
        {-0.0042263377f,  0.0266840458f},
        {-0.0334822456f,  0.0026351099f},
        { 0.0017682182f,  0.0054420161f},
        {-0.0142588170f,  0.0087378143f},
        { 0.0027423344f,  0.0027423344f},
        {-0.0078650134f,  0.0128345354f},
        {-0.0031753829f, -0.0010317444f},
        {-0.0006339352f,  0.0080549101f},
    },
    {
        {-0.0006354249f, -0.0080738394f},   /* Filter 100 */
        {-0.0037430548f,  0.0012161922f},
        {-0.0078983990f, -0.0128890158f},
        { 0.0021640857f, -0.0021640857f},
        {-0.0145694686f, -0.0089281819f},
        { 0.0013919788f, -0.0042840704f},
        {-0.0345980476f, -0.0027229254f},
        {-0.0039020803f, -0.0246367655f},
        {-0.0705421635f,  0.0292195208f},
        {-0.0941911200f, -0.1296429546f},
        { 0.0140219947f, -0.0164176464f},
        {-0.3655041796f, -0.1862336815f},
        { 0.2141308021f, -0.8919189804f},
        { 1.1378457546f,  0.0000000000f},
        { 0.2099913432f,  0.8746768935f},
        {-0.3459798529f,  0.1762855401f},
        { 0.0218690211f,  0.0256053339f},
        {-0.0939660919f,  0.1293332301f},
        {-0.0657406895f, -0.0272306852f},
        {-0.0042716242f,  0.0269699740f},
        {-0.0333198000f,  0.0026223251f},
        { 0.0018212905f,  0.0056053559f},
        {-0.0142125108f,  0.0087094378f},
        { 0.0028244121f,  0.0028244121f},
        {-0.0078593725f,  0.0128253304f},
        {-0.0030943394f, -0.0010054118f},
        {-0.0006354249f,  0.0080738394f},
    },
    {
        {-0.0006367564f, -0.0080907567f},   /* Filter 101 */
        {-0.0038242139f,  0.0012425624f},
        {-0.0079009747f, -0.0128932189f},
        { 0.0020802229f, -0.0020802229f},
        {-0.0146089552f, -0.0089523793f},
        { 0.0013365752f, -0.0041135556f},
        {-0.0347496118f, -0.0027348538f},
        {-0.0038531730f, -0.0243279770f},
        {-0.0711415321f,  0.0294677874f},
        {-0.0941969357f, -0.1296509593f},
        { 0.0130071121f, -0.0152293715f},
        {-0.3679581469f, -0.1874840402f},
        { 0.2146367724f, -0.8940264986f},
        { 1.1377654076f,  0.0000000000f},
        { 0.2094628176f,  0.8724754258f},
        {-0.3435541657f,  0.1750495907f},
        { 0.0228157207f,  0.0267137766f},
        {-0.0939162024f,  0.1292645631f},
        {-0.0651405225f, -0.0269820879f},
        {-0.0043150940f,  0.0272444315f},
        {-0.0331522516f,  0.0026091388f},
        { 0.0018731464f,  0.0057649517f},
        {-0.0141629076f,  0.0086790410f},
        { 0.0029054974f,  0.0029054974f},
        {-0.0078522227f,  0.0128136629f},
        {-0.0030134556f, -0.0009791311f},
        {-0.0006367564f,  0.0080907567f},
    },
    {
        {-0.0006380879f, -0.0081076750f},   /* Filter 102 */
        {-0.0039053725f,  0.0012689324f},
        {-0.0079035503f, -0.0128974220f},
        { 0.0019963599f, -0.0019963599f},
        {-0.0146484418f, -0.0089765767f},
        { 0.0012811716f, -0.0039430408f},
        {-0.0349011797f, -0.0027467824f},
        {-0.0038042657f, -0.0240191886f},
        {-0.0717408937f,  0.0297160511f},
        {-0.0942027515f, -0.1296589641f},
        { 0.0119922295f, -0.0140410967f},
        {-0.3704120876f, -0.1887343854f},
        { 0.2151427288f, -0.8961339588f},
        { 1.1376850605f,  0.0000000000f},
        { 0.2089342920f,  0.8702739581f},
        {-0.3411284786f,  0.1738136414f},
        { 0.0237624178f,  0.0278222165f},
        {-0.0938663217f,  0.1291959082f},
        {-0.0645403486f, -0.0267334877f},
        {-0.0043585641f,  0.0275188910f},
        {-0.0329847033f,  0.0025959525f},
        { 0.0019250022f,  0.0059245475f},
        {-0.0141133060f,  0.0086486451f},
        { 0.0029865827f,  0.0029865826f},
        {-0.0078450724f,  0.0128019946f},
        {-0.0029325720f, -0.0009528504f},
        {-0.0006380879f,  0.0081076750f},
    },
    {
        {-0.0006394193f, -0.0081245932f},   /* Filter 103 */
        {-0.0039865316f,  0.0012953026f},
        {-0.0079061260f, -0.0129016251f},
        { 0.0019124969f, -0.0019124969f},
        {-0.0146879283f, -0.0090007741f},
        { 0.0012257680f, -0.0037725260f},
        {-0.0350527438f, -0.0027587108f},
        {-0.0037553584f, -0.0237104001f},
        {-0.0723402623f,  0.0299643177f},
        {-0.0942085673f, -0.1296669688f},
        { 0.0109773469f, -0.0128528219f},
        {-0.3728660282f, -0.1899847307f},
        { 0.2156486853f, -0.8982414190f},
        { 1.1376047134f,  0.0000000000f},
        { 0.2084057663f,  0.8680724904f},
        {-0.3387028179f,  0.1725777056f},
        { 0.0247091173f,  0.0289306593f},
        {-0.0938164323f,  0.1291272413f},
        {-0.0639401746f, -0.0264848875f},
        {-0.0044020342f,  0.0277933504f},
        {-0.0328171549f,  0.0025827661f},
        { 0.0019768581f,  0.0060841437f},
        {-0.0140637028f,  0.0086182482f},
        { 0.0030676679f,  0.0030676679f},
        {-0.0078379226f,  0.0127903272f},
        {-0.0028516882f, -0.0009265697f},
        {-0.0006394193f,  0.0081245932f},
    },
    {
        {-0.0006407508f, -0.0081415105f},   /* Filter 104 */
        {-0.0040676902f,  0.0013216727f},
        {-0.0079087017f, -0.0129058281f},
        { 0.0018286340f, -0.0018286340f},
        {-0.0147274149f, -0.0090249715f},
        { 0.0011703643f, -0.0036020110f},
        {-0.0352043080f, -0.0027706391f},
        {-0.0037064512f, -0.0234016117f},
        {-0.0729396240f,  0.0302125815f},
        {-0.0942143918f, -0.1296749855f},
        { 0.0099624644f, -0.0116645471f},
        {-0.3753199689f, -0.1912350759f},
        { 0.2161546417f, -0.9003488792f},
        { 1.1375243664f,  0.0000000000f},
        { 0.2078772268f,  0.8658709647f},
        {-0.3362771308f,  0.1713417562f},
        { 0.0256558144f,  0.0300390992f},
        {-0.0937665516f,  0.1290585864f},
        {-0.0633400076f, -0.0262362902f},
        {-0.0044455040f,  0.0280678079f},
        {-0.0326496065f,  0.0025695798f},
        { 0.0020287140f,  0.0062437396f},
        {-0.0140140997f,  0.0085878513f},
        { 0.0031487535f,  0.0031487535f},
        {-0.0078307727f,  0.0127786597f},
        {-0.0027708046f, -0.0009002890f},
        {-0.0006407508f,  0.0081415105f},
    },
    {
        {-0.0006419242f, -0.0081564205f},   /* Filter 105 */
        {-0.0041488032f,  0.0013480279f},
        {-0.0079097235f, -0.0129074957f},
        { 0.0017439806f, -0.0017439806f},
        {-0.0147633837f, -0.0090470132f},
        { 0.0011138490f, -0.0034280747f},
        {-0.0353500972f, -0.0027821130f},
        {-0.0036557426f, -0.0230814501f},
        {-0.0735378774f,  0.0304603862f},
        {-0.0942049674f, -0.1296620140f},
        { 0.0089250471f, -0.0104498875f},
        {-0.3777818758f, -0.1924894801f},
        { 0.2166527086f, -0.9024234774f},
        { 1.1373904943f,  0.0000000000f},
        { 0.2073415630f,  0.8636397647f},
        {-0.3338623308f,  0.1701113542f},
        { 0.0265796290f,  0.0311207471f},
        {-0.0937025344f,  0.1289704742f},
        {-0.0627403844f, -0.0259879181f},
        {-0.0044871553f,  0.0283307839f},
        {-0.0324771819f,  0.0025560097f},
        { 0.0020793210f,  0.0063994921f},
        {-0.0139612788f,  0.0085554827f},
        { 0.0032287821f,  0.0032287821f},
        {-0.0078221305f,  0.0127645568f},
        {-0.0026901479f, -0.0008740821f},
        {-0.0006419242f,  0.0081564205f},
    },
    {
        {-0.0006430977f, -0.0081713305f},   /* Filter 106 */
        {-0.0042299166f,  0.0013743832f},
        {-0.0079107454f, -0.0129091633f},
        { 0.0016593274f, -0.0016593274f},
        {-0.0147993525f, -0.0090690549f},
        { 0.0010573337f, -0.0032541385f},
        {-0.0354958901f, -0.0027935871f},
        {-0.0036050339f, -0.0227612885f},
        {-0.0741361378f,  0.0307081937f},
        {-0.0941955519f, -0.1296490546f},
        { 0.0078876297f, -0.0092352279f},
        {-0.3802437562f, -0.1937438708f},
        { 0.2171507756f, -0.9044980755f},
        { 1.1372566223f,  0.0000000000f},
        { 0.2068058854f,  0.8614085067f},
        {-0.3314475308f,  0.1688809521f},
        { 0.0275034412f,  0.0322023922f},
        {-0.0936385172f,  0.1288823621f},
        {-0.0621407680f, -0.0257395489f},
        {-0.0045288066f,  0.0285937598f},
        {-0.0323047536f,  0.0025424393f},
        { 0.0021299283f,  0.0065552451f},
        {-0.0139084580f,  0.0085231140f},
        { 0.0033088108f,  0.0033088108f},
        {-0.0078134887f,  0.0127504547f},
        {-0.0026094911f, -0.0008478751f},
        {-0.0006430977f,  0.0081713305f},
    },
    {
        {-0.0006442711f, -0.0081862405f},   /* Filter 107 */
        {-0.0043110296f,  0.0014007384f},
        {-0.0079117673f, -0.0129108309f},
        { 0.0015746739f, -0.0015746739f},
        {-0.0148353213f, -0.0090910966f},
        { 0.0010008183f, -0.0030802021f},
        {-0.0356416792f, -0.0028050610f},
        {-0.0035543253f, -0.0224411270f},
        {-0.0747343912f,  0.0309559984f},
        {-0.0941861275f, -0.1296360831f},
        { 0.0068502118f, -0.0080205675f},
        {-0.3827056631f, -0.1949982750f},
        { 0.2176488286f, -0.9065726157f},
        { 1.1371228695f,  0.0000000000f},
        { 0.2062702077f,  0.8591772487f},
        {-0.3290327308f,  0.1676505501f},
        { 0.0284272558f,  0.0332840401f},
        {-0.0935744999f,  0.1287942500f},
        {-0.0615411447f, -0.0254911768f},
        {-0.0045704576f,  0.0288567339f},
        {-0.0321323290f,  0.0025288691f},
        { 0.0021805355f,  0.0067109982f},
        {-0.0138556372f,  0.0084907454f},
        { 0.0033888394f,  0.0033888394f},
        {-0.0078048464f,  0.0127363518f},
        {-0.0025288345f, -0.0008216681f},
        {-0.0006442711f,  0.0081862405f},
    },
    {
        {-0.0006454445f, -0.0082011506f},   /* Filter 108 */
        {-0.0043921426f,  0.0014270936f},
        {-0.0079127897f, -0.0129124992f},
        { 0.0014900205f, -0.0014900205f},
        {-0.0148712885f, -0.0091131373f},
        { 0.0009443030f, -0.0029062657f},
        {-0.0357874721f, -0.0028165352f},
        {-0.0035036167f, -0.0221209654f},
        {-0.0753326446f,  0.0312038031f},
        {-0.0941767119f, -0.1296231237f},
        { 0.0058127945f, -0.0068059079f},
        {-0.3851675434f, -0.1962526657f},
        { 0.2181468956f, -0.9086472139f},
        { 1.1369889975f,  0.0000000000f},
        { 0.2057345440f,  0.8569460487f},
        {-0.3266179308f,  0.1664201480f},
        { 0.0293510680f,  0.0343656852f},
        {-0.0935104915f,  0.1287061499f},
        {-0.0609415284f, -0.0252428076f},
        {-0.0046121089f,  0.0291197098f},
        {-0.0319599006f,  0.0025152987f},
        { 0.0022311426f,  0.0068667507f},
        {-0.0138028164f,  0.0084583768f},
        { 0.0034688681f,  0.0034688680f},
        {-0.0077962046f,  0.0127222496f},
        {-0.0024481778f, -0.0007954612f},
        {-0.0006454445f,  0.0082011506f},
    },
    {
        {-0.0006464603f, -0.0082140570f},   /* Filter 109 */
        {-0.0044731409f,  0.0014534116f},
        {-0.0079122457f, -0.0129116115f},
        { 0.0014046468f, -0.0014046468f},
        {-0.0149036696f, -0.0091329805f},
        { 0.0008867137f, -0.0027290242f},
        {-0.0359272672f, -0.0028275373f},
        {-0.0034511144f, -0.0217894786f},
        {-0.0759293562f,  0.0314509691f},
        {-0.0941517847f, -0.1295888143f},
        { 0.0047529565f, -0.0055649970f},
        {-0.3876366199f, -0.1975107231f},
        { 0.2186368782f, -0.9106881385f},
        { 1.1368016005f,  0.0000000000f},
        { 0.2051919091f,  0.8546858118f},
        {-0.3242147084f,  0.1651956450f},
        { 0.0302519348f,  0.0354204647f},
        {-0.0934326268f,  0.1285989783f},
        {-0.0603428619f, -0.0249948318f},
        {-0.0046519403f,  0.0293711948f},
        {-0.0317828226f,  0.0025013624f},
        { 0.0022804704f,  0.0070185662f},
        {-0.0137468558f,  0.0084240841f},
        { 0.0035477772f,  0.0035477772f},
        {-0.0077860889f,  0.0127057422f},
        {-0.0023678146f, -0.0007693496f},
        {-0.0006464603f,  0.0082140570f},
    },
    {
        {-0.0006474761f, -0.0082269643f},   /* Filter 110 */
        {-0.0045541388f,  0.0014797294f},
        {-0.0079117016f, -0.0129107237f},
        { 0.0013192730f, -0.0013192730f},
        {-0.0149360507f, -0.0091528236f},
        { 0.0008291245f, -0.0025517827f},
        {-0.0360670624f, -0.0028385394f},
        {-0.0033986123f, -0.0214579936f},
        {-0.0765260746f,  0.0316981380f},
        {-0.0941268663f, -0.1295545170f},
        { 0.0036931185f, -0.0043240861f},
        {-0.3901057230f, -0.1987687939f},
        { 0.2191268748f, -0.9127291212f},
        { 1.1366143227f,  0.0000000000f},
        { 0.2046492882f,  0.8524256329f},
        {-0.3218115125f,  0.1639711556f},
        { 0.0311528015f,  0.0364752441f},
        {-0.0933547709f,  0.1284918188f},
        {-0.0597441955f, -0.0247468560f},
        {-0.0046917716f,  0.0296226799f},
        {-0.0316057446f,  0.0024874261f},
        { 0.0023297982f,  0.0071703817f},
        {-0.0136908967f,  0.0083897923f},
        { 0.0036266859f,  0.0036266859f},
        {-0.0077759731f,  0.0126892349f},
        {-0.0022874514f, -0.0007432380f},
        {-0.0006474761f,  0.0082269643f},
    },
    {
        {-0.0006484920f, -0.0082398716f},   /* Filter 111 */
        {-0.0046351367f,  0.0015060472f},
        {-0.0079111576f, -0.0129098359f},
        { 0.0012338993f, -0.0012338993f},
        {-0.0149684318f, -0.0091726668f},
        { 0.0007715352f, -0.0023745411f},
        {-0.0362068575f, -0.0028495415f},
        {-0.0033461099f, -0.0211265068f},
        {-0.0771227862f,  0.0319453040f},
        {-0.0941019478f, -0.1295202197f},
        { 0.0026332804f, -0.0030831752f},
        {-0.3925747995f, -0.2000268512f},
        { 0.2196168575f, -0.9147700459f},
        { 1.1364269257f,  0.0000000000f},
        { 0.2041066672f,  0.8501654540f},
        {-0.3194082901f,  0.1627466526f},
        { 0.0320536683f,  0.0375300236f},
        {-0.0932769149f,  0.1283846594f},
        {-0.0591455290f, -0.0244988803f},
        {-0.0047316029f,  0.0298741650f},
        {-0.0314286666f,  0.0024734897f},
        { 0.0023791261f,  0.0073221971f},
        {-0.0136349377f,  0.0083555006f},
        { 0.0037055950f,  0.0037055950f},
        {-0.0077658579f,  0.0126727282f},
        {-0.0022070882f, -0.0007171264f},
        {-0.0006484920f,  0.0082398716f},
    },
    {
        {-0.0006495077f, -0.0082527780f},   /* Filter 112 */
        {-0.0047161350f,  0.0015323651f},
        {-0.0079106136f, -0.0129089481f},
        { 0.0011485256f, -0.0011485256f},
        {-0.0150008129f, -0.0091925100f},
        { 0.0007139459f, -0.0021972994f},
        {-0.0363466526f, -0.0028605436f},
        {-0.0032936076f, -0.0207950200f},
        {-0.0777195046f,  0.0321924729f},
        {-0.0940770206f, -0.1294859103f},
        { 0.0015734425f, -0.0018422645f},
        {-0.3950438760f, -0.2012849085f},
        { 0.2201068402f, -0.9168109706f},
        { 1.1362396479f,  0.0000000000f},
        { 0.2035640463f,  0.8479052751f},
        {-0.3170050676f,  0.1615221496f},
        { 0.0329545326f,  0.0385848002f},
        {-0.0931990590f,  0.1282774999f},
        {-0.0585468626f, -0.0242509045f},
        {-0.0047714342f,  0.0301256501f},
        {-0.0312515886f,  0.0024595534f},
        { 0.0024284540f,  0.0074740130f},
        {-0.0135789771f,  0.0083212079f},
        { 0.0037845042f,  0.0037845041f},
        {-0.0077557421f,  0.0126562208f},
        {-0.0021267252f, -0.0006910149f},
        {-0.0006495077f,  0.0082527780f},
    },
    {
        {-0.0006503664f, -0.0082636892f},   /* Filter 113 */
        {-0.0047969477f,  0.0015586228f},
        {-0.0079084924f, -0.0129054867f},
        { 0.0010625026f, -0.0010625026f},
        {-0.0150295397f, -0.0092101138f},
        { 0.0006553218f, -0.0020168732f},
        {-0.0364802345f, -0.0028710567f},
        {-0.0032393211f, -0.0204522686f},
        {-0.0783142406f,  0.0324388206f},
        {-0.0940363365f, -0.1294299135f},
        { 0.0004913094f, -0.0005752494f},
        {-0.3975194052f, -0.2025462536f},
        { 0.2205885716f, -0.9188175263f},
        { 1.1359989643f,  0.0000000000f},
        { 0.2030146629f,  0.8456169287f},
        {-0.3146141398f,  0.1603039110f},
        { 0.0338324031f,  0.0396126545f},
        {-0.0931076446f,  0.1281516788f},
        {-0.0579495384f, -0.0240034847f},
        {-0.0048094459f,  0.0303656461f},
        {-0.0310700838f,  0.0024452686f},
        { 0.0024764734f,  0.0076218015f},
        {-0.0135199624f,  0.0082850436f},
        { 0.0038622318f,  0.0038622318f},
        {-0.0077441724f,  0.0126373407f},
        {-0.0020467211f, -0.0006650200f},
        {-0.0006503664f,  0.0082636892f},
    },
    {
        {-0.0006512252f, -0.0082746004f},   /* Filter 114 */
        {-0.0048777604f,  0.0015848804f},
        {-0.0079063713f, -0.0129020253f},
        { 0.0009764796f, -0.0009764796f},
        {-0.0150582664f, -0.0092277175f},
        { 0.0005966978f, -0.0018364470f},
        {-0.0366138164f, -0.0028815699f},
        {-0.0031850346f, -0.0201095172f},
        {-0.0789089766f,  0.0326851683f},
        {-0.0939956437f, -0.1293739046f},
        {-0.0005908237f,  0.0006917657f},
        {-0.3999949343f, -0.2038075987f},
        { 0.2210703030f, -0.9208240820f},
        { 1.1357581615f,  0.0000000000f},
        { 0.2024652796f,  0.8433285823f},
        {-0.3122232384f,  0.1590856859f},
        { 0.0347102737f,  0.0406405089f},
        {-0.0930162303f,  0.1280258577f},
        {-0.0573522177f, -0.0237560664f},
        {-0.0048474578f,  0.0306056440f},
        {-0.0308885807f,  0.0024309840f},
        { 0.0025244925f,  0.0077695890f},
        {-0.0134609462f,  0.0082488784f},
        { 0.0039399598f,  0.0039399598f},
        {-0.0077326026f,  0.0126184606f},
        {-0.0019667173f, -0.0006390252f},
        {-0.0006512252f,  0.0082746004f},
    },
    {
        {-0.0006520839f, -0.0082855115f},   /* Filter 115 */
        {-0.0049585732f,  0.0016111381f},
        {-0.0079042501f, -0.0128985639f},
        { 0.0008904566f, -0.0008904566f},
        {-0.0150869932f, -0.0092453213f},
        { 0.0005380737f, -0.0016560207f},
        {-0.0367473946f, -0.0028920827f},
        {-0.0031307478f, -0.0197667639f},
        {-0.0795037126f,  0.0329315160f},
        {-0.0939549596f, -0.1293179078f},
        {-0.0016729569f,  0.0019587808f},
        {-0.4024704369f, -0.2050689303f},
        { 0.2215520344f, -0.9228306378f},
        { 1.1355174780f,  0.0000000000f},
        { 0.2019159101f,  0.8410402939f},
        {-0.3098323105f,  0.1578674473f},
        { 0.0355881418f,  0.0416683603f},
        {-0.0929248246f,  0.1279000486f},
        {-0.0567548969f, -0.0235086480f},
        {-0.0048854694f,  0.0308456401f},
        {-0.0307070777f,  0.0024166994f},
        { 0.0025725119f,  0.0079173775f},
        {-0.0134019299f,  0.0082127132f},
        { 0.0040176875f,  0.0040176875f},
        {-0.0077210329f,  0.0125995805f},
        {-0.0018867132f, -0.0006130303f},
        {-0.0006520839f,  0.0082855115f},
    },
    {
        {-0.0006529426f, -0.0082964227f},   /* Filter 116 */
        {-0.0050393859f,  0.0016373957f},
        {-0.0079021289f, -0.0128951025f},
        { 0.0008044338f, -0.0008044338f},
        {-0.0151157199f, -0.0092629251f},
        { 0.0004794497f, -0.0014755945f},
        {-0.0368809765f, -0.0029025958f},
        {-0.0030764614f, -0.0194240126f},
        {-0.0800984555f,  0.0331778666f},
        {-0.0939142668f, -0.1292618989f},
        {-0.0027550900f,  0.0032257959f},
        {-0.4049459660f, -0.2063302754f},
        { 0.2220337658f, -0.9248371935f},
        { 1.1352766752f,  0.0000000000f},
        { 0.2013665268f,  0.8387519475f},
        {-0.3074413826f,  0.1566492087f},
        { 0.0364660123f,  0.0426962147f},
        {-0.0928334103f,  0.1277742276f},
        {-0.0561575762f, -0.0232612297f},
        {-0.0049234811f,  0.0310856362f},
        {-0.0305255747f,  0.0024024148f},
        { 0.0026205313f,  0.0080651659f},
        {-0.0133429153f,  0.0081765490f},
        { 0.0040954155f,  0.0040954155f},
        {-0.0077094631f,  0.0125807004f},
        {-0.0018067094f, -0.0005870355f},
        {-0.0006529426f,  0.0082964227f},
    },
    {
        {-0.0006536450f, -0.0083053470f},   /* Filter 117 */
        {-0.0051199431f,  0.0016635704f},
        {-0.0078984209f, -0.0128890516f},
        { 0.0007178340f, -0.0007178340f},
        {-0.0151407272f, -0.0092782496f},
        { 0.0004198315f, -0.0012921084f},
        {-0.0370081261f, -0.0029126027f},
        {-0.0030204009f, -0.0190700610f},
        {-0.0806907754f,  0.0334232135f},
        {-0.0938575543f, -0.1291838409f},
        {-0.0038593824f,  0.0045187562f},
        {-0.4074271512f, -0.2075945024f},
        { 0.2225070651f, -0.9268086269f},
        { 1.1349827051f,  0.0000000000f},
        { 0.2008105897f,  0.8364363030f},
        {-0.3050634397f,  0.1554375863f},
        { 0.0373208455f,  0.0436970957f},
        {-0.0927287353f,  0.1276301548f},
        {-0.0555619866f, -0.0230145284f},
        {-0.0049596754f,  0.0313141580f},
        {-0.0303398733f,  0.0023877998f},
        { 0.0026672144f,  0.0082088419f},
        {-0.0132809268f,  0.0081385624f},
        { 0.0041719022f,  0.0041719022f},
        {-0.0076964598f,  0.0125594809f},
        {-0.0017271295f, -0.0005611784f},
        {-0.0006536450f,  0.0083053470f},
    },
    {
        {-0.0006543473f, -0.0083142712f},   /* Filter 118 */
        {-0.0052004999f,  0.0016897448f},
        {-0.0078947129f, -0.0128830006f},
        { 0.0006312342f, -0.0006312342f},
        {-0.0151657345f, -0.0092935740f},
        { 0.0003602132f, -0.0011086223f},
        {-0.0371352756f, -0.0029226096f},
        {-0.0029643405f, -0.0187161094f},
        {-0.0812830954f,  0.0336685605f},
        {-0.0938008418f, -0.1291057828f},
        {-0.0049636747f,  0.0058117164f},
        {-0.4099083363f, -0.2088587294f},
        { 0.2229803504f, -0.9287800022f},
        { 1.1346886158f,  0.0000000000f},
        { 0.2002546527f,  0.8341206585f},
        {-0.3026854967f,  0.1542259638f},
        { 0.0381756786f,  0.0446979767f},
        {-0.0926240690f,  0.1274860940f},
        {-0.0549663971f, -0.0227678271f},
        {-0.0049958691f,  0.0315426760f},
        {-0.0301541737f,  0.0023731849f},
        { 0.0027138976f,  0.0083525178f},
        {-0.0132189391f,  0.0081005763f},
        { 0.0042483892f,  0.0042483892f},
        {-0.0076834565f,  0.0125382614f},
        {-0.0016475497f, -0.0005353213f},
        {-0.0006543473f,  0.0083142712f},
    },
    {
        {-0.0006550496f, -0.0083231946f},   /* Filter 119 */
        {-0.0052810571f,  0.0017159195f},
        {-0.0078910049f, -0.0128769497f},
        { 0.0005446345f, -0.0005446345f},
        {-0.0151907433f, -0.0093088995f},
        { 0.0003005950f, -0.0009251361f},
        {-0.0372624252f, -0.0029326165f},
        {-0.0029082804f, -0.0183621597f},
        {-0.0818754153f,  0.0339139074f},
        {-0.0937441381f, -0.1290277369f},
        {-0.0060679668f,  0.0071046763f},
        {-0.4123895215f, -0.2101229563f},
        { 0.2234536497f, -0.9307514356f},
        { 1.1343946457f,  0.0000000000f},
        { 0.1996987295f,  0.8318050720f},
        {-0.3003075538f,  0.1530143413f},
        { 0.0390305118f,  0.0456988578f},
        {-0.0925193940f,  0.1273420212f},
        {-0.0543708110f, -0.0225211273f},
        {-0.0050320634f,  0.0317711978f},
        {-0.0299684722f,  0.0023585699f},
        { 0.0027605807f,  0.0084961938f},
        {-0.0131569505f,  0.0080625897f},
        { 0.0043248758f,  0.0043248758f},
        {-0.0076704536f,  0.0125170427f},
        {-0.0015679698f, -0.0005094643f},
        {-0.0006550496f,  0.0083231946f},
    },
    {
        {-0.0006557520f, -0.0083321189f},   /* Filter 120 */
        {-0.0053616143f,  0.0017420941f},
        {-0.0078872969f, -0.0128708988f},
        { 0.0004580348f, -0.0004580348f},
        {-0.0152157506f, -0.0093242239f},
        { 0.0002409767f, -0.0007416500f},
        {-0.0373895748f, -0.0029426234f},
        {-0.0028522200f, -0.0180082081f},
        {-0.0824677352f,  0.0341592544f},
        {-0.0936874256f, -0.1289496789f},
        {-0.0071722595f,  0.0083976369f},
        {-0.4148707332f, -0.2113871969f},
        { 0.2239269490f, -0.9327228689f},
        { 1.1341005564f,  0.0000000000f},
        { 0.1991427925f,  0.8294894275f},
        {-0.2979296108f,  0.1518027189f},
        { 0.0398853425f,  0.0466997360f},
        {-0.0924147277f,  0.1271979605f},
        {-0.0537752214f, -0.0222744260f},
        {-0.0050682571f,  0.0319997159f},
        {-0.0297827707f,  0.0023439549f},
        { 0.0028072639f,  0.0086398697f},
        {-0.0130949620f,  0.0080246031f},
        { 0.0044013628f,  0.0044013628f},
        {-0.0076574503f,  0.0124958232f},
        {-0.0014883900f, -0.0004836072f},
        {-0.0006557520f,  0.0083321189f},
    },
    {
        {-0.0006562987f, -0.0083390655f},   /* Filter 121 */
        {-0.0054418451f,  0.0017681627f},
        {-0.0078819938f, -0.0128622449f},
        { 0.0003709319f, -0.0003709319f},
        {-0.0152369780f, -0.0093372321f},
        { 0.0001804062f, -0.0005552331f},
        {-0.0375100767f, -0.0029521071f},
        {-0.0027943978f, -0.0176431337f},
        {-0.0830571916f,  0.0344034152f},
        {-0.0936144395f, -0.1288492221f},
        {-0.0082985637f,  0.0097163697f},
        {-0.4173568043f, -0.2126539134f},
        { 0.2243916352f, -0.9346584264f},
        { 1.1337532997f,  0.0000000000f},
        { 0.1985804965f,  0.8271472963f},
        {-0.2955653432f,  0.1505980644f},
        { 0.0407171093f,  0.0476736098f},
        {-0.0922970898f,  0.1270360458f},
        {-0.0531817451f, -0.0220286001f},
        {-0.0051026361f,  0.0322167763f},
        {-0.0295930992f,  0.0023290274f},
        { 0.0028525846f,  0.0087793526f},
        {-0.0130300878f,  0.0079848481f},
        { 0.0044765501f,  0.0044765501f},
        {-0.0076430353f,  0.0124723001f},
        {-0.0014092982f, -0.0004579088f},
        {-0.0006562987f,  0.0083390655f},
    },
    {
        {-0.0006568455f, -0.0083460131f},   /* Filter 122 */
        {-0.0055220759f,  0.0017942312f},
        {-0.0078766902f, -0.0128535902f},
        { 0.0002838290f, -0.0002838290f},
        {-0.0152582054f, -0.0093502403f},
        { 0.0001198356f, -0.0003688162f},
        {-0.0376305786f, -0.0029615908f},
        {-0.0027365760f, -0.0172780610f},
        {-0.0836466480f,  0.0346475760f},
        {-0.0935414534f, -0.1287487654f},
        {-0.0094248685f,  0.0110351032f},
        {-0.4198429020f, -0.2139206434f},
        { 0.2248563354f, -0.9365940418f},
        { 1.1334060431f,  0.0000000000f},
        { 0.1980182006f,  0.8248051651f},
        {-0.2932010490f,  0.1493933963f},
        { 0.0415488785f,  0.0486474864f},
        {-0.0921794520f,  0.1268741312f},
        {-0.0525882687f, -0.0217827741f},
        {-0.0051370151f,  0.0324338367f},
        {-0.0294034277f,  0.0023141000f},
        { 0.0028979053f,  0.0089188354f},
        {-0.0129652128f,  0.0079450927f},
        { 0.0045517378f,  0.0045517378f},
        {-0.0076286203f,  0.0124487770f},
        {-0.0013302065f, -0.0004322103f},
        {-0.0006568455f,  0.0083460131f},
    },
    {
        {-0.0006573923f, -0.0083529607f},   /* Filter 123 */
        {-0.0056023067f,  0.0018202998f},
        {-0.0078713866f, -0.0128449355f},
        { 0.0001967261f, -0.0001967261f},
        {-0.0152794329f, -0.0093632485f},
        { 0.0000592651f, -0.0001823992f},
        {-0.0377510805f, -0.0029710745f},
        {-0.0026787539f, -0.0169129866f},
        {-0.0842360975f,  0.0348917340f},
        {-0.0934684586f, -0.1286482965f},
        {-0.0105511727f,  0.0123538360f},
        {-0.4223289731f, -0.2151873599f},
        { 0.2253210216f, -0.9385295993f},
        { 1.1330589056f,  0.0000000000f},
        { 0.1974559185f,  0.8224630919f},
        {-0.2908367814f,  0.1481887418f},
        { 0.0423806429f,  0.0496213573f},
        {-0.0920618141f,  0.1267122165f},
        {-0.0519947924f, -0.0215369482f},
        {-0.0051713940f,  0.0326508970f},
        {-0.0292137580f,  0.0022991726f},
        { 0.0029432260f,  0.0090583183f},
        {-0.0129003378f,  0.0079053372f},
        { 0.0046269252f,  0.0046269252f},
        {-0.0076142049f,  0.0124252531f},
        {-0.0012511149f, -0.0004065119f},
        {-0.0006573923f,  0.0083529607f},
    },
    {
        {-0.0006579390f, -0.0083599074f},   /* Filter 124 */
        {-0.0056825375f,  0.0018463684f},
        {-0.0078660834f, -0.0128362816f},
        { 0.0001096232f, -0.0001096232f},
        {-0.0153006603f, -0.0093762567f},
        {-0.0000013054f,  0.0000040177f},
        {-0.0378715823f, -0.0029805582f},
        {-0.0026209318f, -0.0165479121f},
        {-0.0848255540f,  0.0351358949f},
        {-0.0933954725f, -0.1285478398f},
        {-0.0116774775f,  0.0136725695f},
        {-0.4248150707f, -0.2164540899f},
        { 0.2257857078f, -0.9404651568f},
        { 1.1327116489f,  0.0000000000f},
        { 0.1968936226f,  0.8201209607f},
        {-0.2884725138f,  0.1469840873f},
        { 0.0432124121f,  0.0505952339f},
        {-0.0919441762f,  0.1265503019f},
        {-0.0514013161f, -0.0212911222f},
        {-0.0052057730f,  0.0328679574f},
        {-0.0290240865f,  0.0022842452f},
        { 0.0029885468f,  0.0091978012f},
        {-0.0128354629f,  0.0078655818f},
        { 0.0047021128f,  0.0047021128f},
        {-0.0075997899f,  0.0124017299f},
        {-0.0011720231f, -0.0003808134f},
        {-0.0006579390f,  0.0083599074f},
    },
    {
        {-0.0006583311f, -0.0083648895f},   /* Filter 125 */
        {-0.0057623706f,  0.0018723077f},
        {-0.0078591774f, -0.0128250119f},
        { 0.0000220918f, -0.0000220918f},
        {-0.0153180475f, -0.0093869116f},
        {-0.0000627850f,  0.0001932324f},
        {-0.0379852211f, -0.0029895017f},
        {-0.0025613617f, -0.0161718012f},
        {-0.0854116994f,  0.0353786843f},
        {-0.0933059675f, -0.1284246468f},
        {-0.0128256378f,  0.0150168925f},
        {-0.4273052577f, -0.2177229035f},
        { 0.2262416280f, -0.9423642008f},
        { 1.1323113441f,  0.0000000000f},
        { 0.1963251765f,  0.8177532122f},
        {-0.2861225854f,  0.1457867389f},
        { 0.0440210907f,  0.0515420749f},
        {-0.0918138733f,  0.1263709553f},
        {-0.0508103247f, -0.0210463256f},
        {-0.0052383414f,  0.0330735858f},
        {-0.0288306714f,  0.0022690231f},
        { 0.0030324803f,  0.0093330147f},
        {-0.0127677887f,  0.0078241110f},
        { 0.0047759442f,  0.0047759442f},
        {-0.0075839856f,  0.0123759397f},
        {-0.0010934825f, -0.0003552940f},
        {-0.0006583311f,  0.0083648895f},
    },
    {
        {-0.0006587232f, -0.0083698725f},   /* Filter 126 */
        {-0.0058422042f,  0.0018982472f},
        {-0.0078522714f, -0.0128137423f},
        {-0.0000654396f,  0.0000654396f},
        {-0.0153354348f, -0.0093975665f},
        {-0.0001242646f,  0.0003824470f},
        {-0.0380988636f, -0.0029984456f},
        {-0.0025017916f, -0.0157956903f},
        {-0.0859978380f,  0.0356214708f},
        {-0.0932164537f, -0.1283014417f},
        {-0.0139737969f,  0.0163612141f},
        {-0.4297954712f, -0.2189917307f},
        { 0.2266975342f, -0.9442631870f},
        { 1.1319110394f,  0.0000000000f},
        { 0.1957567164f,  0.8153854057f},
        {-0.2837726304f,  0.1445893771f},
        { 0.0448297741f,  0.0524889215f},
        {-0.0916835704f,  0.1261916087f},
        {-0.0502193367f, -0.0208015303f},
        {-0.0052709097f,  0.0332792142f},
        {-0.0286372583f,  0.0022538011f},
        { 0.0030764136f,  0.0094682274f},
        {-0.0127001146f,  0.0077826402f},
        { 0.0048497760f,  0.0048497760f},
        {-0.0075681818f,  0.0123501503f},
        {-0.0010149420f, -0.0003297747f},
        {-0.0006587232f,  0.0083698725f},
    },
    {
        {-0.0006591153f, -0.0083748546f},   /* Filter 127 */
        {-0.0059220378f,  0.0019241867f},
        {-0.0078453653f, -0.0128024727f},
        {-0.0001529710f,  0.0001529710f},
        {-0.0153528220f, -0.0094082214f},
        {-0.0001857442f,  0.0005716617f},
        {-0.0382125024f, -0.0030073892f},
        {-0.0024422213f, -0.0154195785f},
        {-0.0865839766f,  0.0358642574f},
        {-0.0931269400f, -0.1281782366f},
        {-0.0151219560f,  0.0177055357f},
        {-0.4322856848f, -0.2202605579f},
        { 0.2271534544f, -0.9461622311f},
        { 1.1315107346f,  0.0000000000f},
        { 0.1951882703f,  0.8130176572f},
        {-0.2814227020f,  0.1433920287f},
        { 0.0456384527f,  0.0534357625f},
        {-0.0915532675f,  0.1260122621f},
        {-0.0496283453f, -0.0205567337f},
        {-0.0053034780f,  0.0334848426f},
        {-0.0284438432f,  0.0022385790f},
        { 0.0031203471f,  0.0096034410f},
        {-0.0126324404f,  0.0077411695f},
        { 0.0049236074f,  0.0049236074f},
        {-0.0075523775f,  0.0123243601f},
        {-0.0009364015f, -0.0003042553f},
        {-0.0006591153f,  0.0083748546f},
    },
    {
        {-0.0006595075f, -0.0083798376f},   /* Filter 128 */
        {-0.0060018709f,  0.0019501261f},
        {-0.0078384593f, -0.0127912031f},
        {-0.0002405024f,  0.0002405024f},
        {-0.0153702092f, -0.0094188763f},
        {-0.0002472237f,  0.0007608763f},
        {-0.0383261448f, -0.0030163330f},
        {-0.0023826510f, -0.0150434667f},
        {-0.0871701152f,  0.0361070439f},
        {-0.0930374350f, -0.1280550435f},
        {-0.0162701151f,  0.0190498573f},
        {-0.4347758718f, -0.2215293715f},
        { 0.2276093606f, -0.9480612172f},
        { 1.1311104298f,  0.0000000000f},
        { 0.1946198242f,  0.8106499087f},
        {-0.2790727736f,  0.1421946804f},
        { 0.0464471361f,  0.0543826092f},
        {-0.0914229645f,  0.1258329156f},
        {-0.0490373538f, -0.0203119370f},
        {-0.0053360458f,  0.0336904673f},
        {-0.0282504300f,  0.0022233571f},
        { 0.0031642807f,  0.0097386546f},
        {-0.0125647663f,  0.0076996987f},
        { 0.0049974388f,  0.0049974388f},
        {-0.0075365733f,  0.0122985698f},
        {-0.0008578611f, -0.0002787360f},
        {-0.0006595075f,  0.0083798376f},
    },
    {
        {-0.0006597461f, -0.0083828690f},   /* Filter 129 */
        {-0.0060812359f,  0.0019759133f},
        {-0.0078299450f, -0.0127773090f},
        {-0.0003283865f,  0.0003283865f},
        {-0.0153837007f, -0.0094271439f},
        {-0.0003095677f,  0.0009527514f},
        {-0.0384327125f, -0.0030247201f},
        {-0.0023213476f, -0.0146564122f},
        {-0.0877524885f,  0.0363482709f},
        {-0.0929311572f, -0.1279087646f},
        {-0.0174399616f,  0.0204195715f},
        {-0.4372694311f, -0.2227999035f},
        { 0.2280563338f, -0.9499229944f},
        { 1.1306571960f,  0.0000000000f},
        { 0.1940454227f,  0.8082573542f},
        {-0.2767378482f,  0.1410049765f},
        { 0.0472327242f,  0.0553024146f},
        {-0.0912802944f,  0.1256365469f},
        {-0.0484492156f, -0.0200683222f},
        {-0.0053668093f,  0.0338847005f},
        {-0.0280534999f,  0.0022078583f},
        { 0.0032068035f,  0.0098695263f},
        {-0.0124943812f,  0.0076565666f},
        { 0.0050698592f,  0.0050698592f},
        {-0.0075194036f,  0.0122705514f},
        {-0.0007799340f, -0.0002534159f},
        {-0.0006597461f,  0.0083828690f},
    },
    {
        {-0.0006599847f, -0.0083859004f},   /* Filter 130 */
        {-0.0061606009f,  0.0020017006f},
        {-0.0078214307f, -0.0127634149f},
        {-0.0004162707f,  0.0004162707f},
        {-0.0153971922f, -0.0094354115f},
        {-0.0003719117f,  0.0011446265f},
        {-0.0385392839f, -0.0030331074f},
        {-0.0022600442f, -0.0142693578f},
        {-0.0883348550f,  0.0365894950f},
        {-0.0928248793f, -0.1277624857f},
        {-0.0186098068f,  0.0217892842f},
        {-0.4397629639f, -0.2240704219f},
        { 0.2285032930f, -0.9517847137f},
        { 1.1302039623f,  0.0000000000f},
        { 0.1934710212f,  0.8058647998f},
        {-0.2744029228f,  0.1398152726f},
        { 0.0480183122f,  0.0562222200f},
        {-0.0911376329f,  0.1254401903f},
        {-0.0478610739f, -0.0198247059f},
        {-0.0053975722f,  0.0340789300f},
        {-0.0278565697f,  0.0021923596f},
        { 0.0032493266f,  0.0100003989f},
        {-0.0124239968f,  0.0076134350f},
        { 0.0051422800f,  0.0051422800f},
        {-0.0075022343f,  0.0122425338f},
        {-0.0007020068f, -0.0002280958f},
        {-0.0006599847f,  0.0083859004f},
    },
    {
        {-0.0006602232f, -0.0083889308f},   /* Filter 131 */
        {-0.0062399654f,  0.0020274877f},
        {-0.0078129159f, -0.0127495200f},
        {-0.0005041548f,  0.0005041548f},
        {-0.0154106837f, -0.0094436791f},
        {-0.0004342557f,  0.0013365016f},
        {-0.0386458516f, -0.0030414945f},
        {-0.0021987408f, -0.0138823033f},
        {-0.0889172284f,  0.0368307219f},
        {-0.0927186015f, -0.1276162068f},
        {-0.0197796533f,  0.0231589985f},
        {-0.4422564967f, -0.2253409403f},
        { 0.2289502662f, -0.9536464910f},
        { 1.1297507286f,  0.0000000000f},
        { 0.1928966197f,  0.8034722454f},
        {-0.2720679974f,  0.1386255687f},
        { 0.0488039002f,  0.0571420254f},
        {-0.0909949628f,  0.1252438216f},
        {-0.0472729357f, -0.0195810911f},
        {-0.0054283352f,  0.0342731595f},
        {-0.0276596414f,  0.0021768610f},
        { 0.0032918496f,  0.0101312715f},
        {-0.0123536117f,  0.0075703030f},
        { 0.0052147005f,  0.0052147005f},
        {-0.0074850646f,  0.0122145153f},
        {-0.0006240797f, -0.0002027758f},
        {-0.0006602232f,  0.0083889308f},
    },
    {
        {-0.0006604618f, -0.0083919631f},   /* Filter 132 */
        {-0.0063193304f,  0.0020532749f},
        {-0.0078044016f, -0.0127356260f},
        {-0.0005920390f,  0.0005920390f},
        {-0.0154241751f, -0.0094519467f},
        {-0.0004965997f,  0.0015283766f},
        {-0.0387524230f, -0.0030498818f},
        {-0.0021374374f, -0.0134952489f},
        {-0.0894995948f,  0.0370719460f},
        {-0.0926123236f, -0.1274699279f},
        {-0.0209494985f,  0.0245287112f},
        {-0.4447500295f, -0.2266114587f},
        { 0.2293972394f, -0.9555082682f},
        { 1.1292974949f,  0.0000000000f},
        { 0.1923222182f,  0.8010796909f},
        {-0.2697330721f,  0.1374358648f},
        { 0.0495894882f,  0.0580618308f},
        {-0.0908522926f,  0.1250474530f},
        {-0.0466847940f, -0.0193374748f},
        {-0.0054590981f,  0.0344673891f},
        {-0.0274627113f,  0.0021613623f},
        { 0.0033343727f,  0.0102621440f},
        {-0.0122832265f,  0.0075271709f},
        { 0.0052871210f,  0.0052871210f},
        {-0.0074678949f,  0.0121864969f},
        {-0.0005461525f, -0.0001774557f},
        {-0.0006604618f,  0.0083919631f},
    },
    {
        {-0.0006605480f, -0.0083930587f},   /* Filter 133 */
        {-0.0063981555f,  0.0020788868f},
        {-0.0077942742f, -0.0127190995f},
        {-0.0006801991f,  0.0006801991f},
        {-0.0154337184f, -0.0094577948f},
        {-0.0005597622f,  0.0017227710f},
        {-0.0388517116f, -0.0030576960f},
        {-0.0020744172f, -0.0130973549f},
        {-0.0900777280f,  0.0373114166f},
        {-0.0924890451f, -0.1273002496f},
        {-0.0221408533f,  0.0259236084f},
        {-0.4472461115f, -0.2278832760f},
        { 0.2298350986f, -0.9573320831f},
        { 1.1287915707f,  0.0000000000f},
        { 0.1917420700f,  0.7986631999f},
        {-0.2674137870f,  0.1362541301f},
        { 0.0503519808f,  0.0589545949f},
        {-0.0906975704f,  0.1248344962f},
        {-0.0460998635f, -0.0190951887f},
        {-0.0054880621f,  0.0346502602f},
        {-0.0272624925f,  0.0021456047f},
        { 0.0033754634f,  0.0103886083f},
        {-0.0122102217f,  0.0074824335f},
        { 0.0053580775f,  0.0053580775f},
        {-0.0074493851f,  0.0121562916f},
        {-0.0004688998f, -0.0001523548f},
        {-0.0006605480f,  0.0083930587f},
    },
    {
        {-0.0006606343f, -0.0083941543f},   /* Filter 134 */
        {-0.0064769802f,  0.0021044984f},
        {-0.0077841473f, -0.0127025739f},
        {-0.0007683593f,  0.0007683593f},
        {-0.0154432601f, -0.0094636420f},
        {-0.0006229248f,  0.0019171654f},
        {-0.0389510002f, -0.0030655102f},
        {-0.0020113970f, -0.0126994609f},
        {-0.0906558680f,  0.0375508900f},
        {-0.0923657667f, -0.1271305714f},
        {-0.0233322056f,  0.0273185028f},
        {-0.4497421935f, -0.2291550933f},
        { 0.2302729439f, -0.9591558401f},
        { 1.1282856464f,  0.0000000000f},
        { 0.1911619218f,  0.7962467089f},
        {-0.2650945286f,  0.1350724088f},
        { 0.0511144782f,  0.0598473647f},
        {-0.0905428395f,  0.1246215274f},
        {-0.0455149364f, -0.0188529039f},
        {-0.0055170266f,  0.0348331350f},
        {-0.0270622738f,  0.0021298471f},
        { 0.0034165539f,  0.0105150716f},
        {-0.0121372169f,  0.0074376961f},
        { 0.0054290337f,  0.0054290337f},
        {-0.0074308747f,  0.0121260855f},
        {-0.0003916471f, -0.0001272538f},
        {-0.0006606343f,  0.0083941543f},
    },
    {
        {-0.0006607205f, -0.0083952499f},   /* Filter 135 */
        {-0.0065558054f,  0.0021301103f},
        {-0.0077740198f, -0.0126860474f},
        {-0.0008565195f,  0.0008565195f},
        {-0.0154528018f, -0.0094694891f},
        {-0.0006860873f,  0.0021115595f},
        {-0.0390502888f, -0.0030733244f},
        {-0.0019483768f, -0.0123015668f},
        {-0.0912340081f,  0.0377903635f},
        {-0.0922424882f, -0.1269608931f},
        {-0.0245235579f,  0.0287133972f},
        {-0.4522382755f, -0.2304269106f},
        { 0.2307108031f, -0.9609796550f},
        { 1.1277797222f,  0.0000000000f},
        { 0.1905817737f,  0.7938302179f},
        {-0.2627752435f,  0.1338906741f},
        { 0.0518769757f,  0.0607401345f},
        {-0.0903881087f,  0.1244085586f},
        {-0.0449300058f, -0.0186106178f},
        {-0.0055459905f,  0.0350160062f},
        {-0.0268620551f,  0.0021140896f},
        { 0.0034576446f,  0.0106415359f},
        {-0.0120642113f,  0.0073929582f},
        { 0.0054999899f,  0.0054999899f},
        {-0.0074123644f,  0.0120958793f},
        {-0.0003143943f, -0.0001021529f},
        {-0.0006607205f,  0.0083952499f},
    },
    {
        {-0.0006608067f, -0.0083963454f},   /* Filter 136 */
        {-0.0066346301f,  0.0021557220f},
        {-0.0077638924f, -0.0126695209f},
        {-0.0009446795f,  0.0009446795f},
        {-0.0154623435f, -0.0094753363f},
        {-0.0007492498f,  0.0023059538f},
        {-0.0391495774f, -0.0030811386f},
        {-0.0018853566f, -0.0119036728f},
        {-0.0918121412f,  0.0380298341f},
        {-0.0921192010f, -0.1267912028f},
        {-0.0257149127f,  0.0301082944f},
        {-0.4547343575f, -0.2316987279f},
        { 0.2311486623f, -0.9628034699f},
        { 1.1272736788f,  0.0000000000f},
        { 0.1900016255f,  0.7914137269f},
        {-0.2604559850f,  0.1327089529f},
        { 0.0526394683f,  0.0616328986f},
        {-0.0902333778f,  0.1241955898f},
        {-0.0443450753f, -0.0183683316f},
        {-0.0055749551f,  0.0351988810f},
        {-0.0266618363f,  0.0020983320f},
        { 0.0034987353f,  0.0107680001f},
        {-0.0119912065f,  0.0073482208f},
        { 0.0055709461f,  0.0055709461f},
        {-0.0073938545f,  0.0120656740f},
        {-0.0002371416f, -0.0000770520f},
        {-0.0006608067f,  0.0083963454f},
    },
    {
        {-0.0006607419f, -0.0083955219f},   /* Filter 137 */
        {-0.0067128436f,  0.0021811351f},
        {-0.0077521489f, -0.0126503573f},
        {-0.0010330379f,  0.0010330379f},
        {-0.0154678846f, -0.0094787319f},
        {-0.0008131837f,  0.0025027222f},
        {-0.0392413790f, -0.0030883635f},
        {-0.0018206374f, -0.0114950523f},
        {-0.0923855798f,  0.0382673601f},
        {-0.0919786855f, -0.1265977998f},
        {-0.0269275822f,  0.0315281480f},
        {-0.4572321920f, -0.2329714382f},
        { 0.2315772545f, -0.9645886849f},
        { 1.1267151833f,  0.0000000000f},
        { 0.1894159394f,  0.7889741687f},
        {-0.2581530042f,  0.1315355255f},
        { 0.0533788848f,  0.0624986441f},
        {-0.0900668927f,  0.1239664428f},
        {-0.0437637035f, -0.0181275195f},
        {-0.0056021287f,  0.0353704489f},
        {-0.0264585556f,  0.0020823335f},
        { 0.0035383736f,  0.0108899940f},
        {-0.0119156725f,  0.0073019335f},
        { 0.0056403870f,  0.0056403870f},
        {-0.0073740294f,  0.0120333223f},
        {-0.0001606233f, -0.0000521897f},
        {-0.0006607419f,  0.0083955219f},
    },
    {
        {-0.0006606771f, -0.0083946984f},   /* Filter 138 */
        {-0.0067910571f,  0.0022065482f},
        {-0.0077404060f, -0.0126311945f},
        {-0.0011213965f,  0.0011213965f},
        {-0.0154734257f, -0.0094821275f},
        {-0.0008771176f,  0.0026994905f},
        {-0.0393331843f, -0.0030955888f},
        {-0.0017559182f, -0.0110864309f},
        {-0.0929590254f,  0.0385048890f},
        {-0.0918381699f, -0.1264043967f},
        {-0.0281402517f,  0.0329480015f},
        {-0.4597300266f, -0.2342441485f},
        { 0.2320058328f, -0.9663738420f},
        { 1.1261566877f,  0.0000000000f},
        { 0.1888302394f,  0.7865345526f},
        {-0.2558500499f,  0.1303621117f},
        { 0.0541183013f,  0.0633643896f},
        {-0.0899004077f,  0.1237372958f},
        {-0.0431823351f, -0.0178867089f},
        {-0.0056293024f,  0.0355420169f},
        {-0.0262552748f,  0.0020663349f},
        { 0.0035780115f,  0.0110119870f},
        {-0.0118401393f,  0.0072556467f},
        { 0.0057098272f,  0.0057098272f},
        {-0.0073542042f,  0.0120009705f},
        {-0.0000841051f, -0.0000273274f},
        {-0.0006606771f,  0.0083946984f},
    },
    {
        {-0.0006606123f, -0.0083938758f},   /* Filter 139 */
        {-0.0068692707f,  0.0022319613f},
        {-0.0077286625f, -0.0126120309f},
        {-0.0012097549f,  0.0012097549f},
        {-0.0154789669f, -0.0094855231f},
        {-0.0009410515f,  0.0028962589f},
        {-0.0394249859f, -0.0031028137f},
        {-0.0016911990f, -0.0106778105f},
        {-0.0935324640f,  0.0387424151f},
        {-0.0916976544f, -0.1262109936f},
        {-0.0293529237f,  0.0343678579f},
        {-0.4622278611f, -0.2355168587f},
        { 0.2324344250f, -0.9681590570f},
        { 1.1255981922f,  0.0000000000f},
        { 0.1882445533f,  0.7840949944f},
        {-0.2535470691f,  0.1291886844f},
        { 0.0548577178f,  0.0642301351f},
        {-0.0897339314f,  0.1235081609f},
        {-0.0426009668f, -0.0176458982f},
        {-0.0056564756f,  0.0357135811f},
        {-0.0260519940f,  0.0020503364f},
        { 0.0036176494f,  0.0111339801f},
        {-0.0117646054f,  0.0072093594f},
        { 0.0057792674f,  0.0057792674f},
        {-0.0073343790f,  0.0119686188f},
        {-0.0000075868f, -0.0000024651f},
        {-0.0006606123f,  0.0083938758f},
    },
    {
        {-0.0006605475f, -0.0083930522f},   /* Filter 140 */
        {-0.0069474842f,  0.0022573745f},
        {-0.0077169190f, -0.0125928673f},
        {-0.0012981134f,  0.0012981134f},
        {-0.0154845096f, -0.0094889197f},
        {-0.0010049855f,  0.0030930272f},
        {-0.0395167875f, -0.0031100386f},
        {-0.0016264799f, -0.0102691900f},
        {-0.0941059027f,  0.0389799412f},
        {-0.0915571388f, -0.1260175906f},
        {-0.0305655932f,  0.0357877115f},
        {-0.4647256957f, -0.2367895690f},
        { 0.2328630033f, -0.9699442141f},
        { 1.1250396967f,  0.0000000000f},
        { 0.1876588672f,  0.7816554362f},
        {-0.2512441148f,  0.1280152706f},
        { 0.0555971295f,  0.0650958750f},
        {-0.0895674464f,  0.1232790139f},
        {-0.0420195949f, -0.0174050861f},
        {-0.0056836492f,  0.0358851491f},
        {-0.0258487132f,  0.0020343379f},
        { 0.0036572877f,  0.0112559740f},
        {-0.0116890714f,  0.0071630722f},
        { 0.0058487083f,  0.0058487083f},
        {-0.0073145539f,  0.0119362671f},
        { 0.0000689315f,  0.0000223972f},
        {-0.0006605475f,  0.0083930522f},
    },
    {
        {-0.0006603332f, -0.0083903291f},   /* Filter 141 */
        {-0.0070250148f,  0.0022825657f},
        {-0.0077035580f, -0.0125710642f},
        {-0.0013865916f,  0.0013865916f},
        {-0.0154860024f, -0.0094898345f},
        {-0.0010696423f,  0.0032920205f},
        {-0.0396009015f, -0.0031166585f},
        {-0.0015600811f, -0.0098499645f},
        {-0.0946741787f,  0.0392153288f},
        {-0.0913991672f, -0.1258001613f},
        {-0.0317993815f,  0.0372322920f},
        {-0.4672244862f, -0.2380627664f},
        { 0.2332821616f, -0.9716901338f},
        { 1.1244288683f,  0.0000000000f},
        { 0.1870678379f,  0.7791936222f},
        {-0.2489580755f,  0.1268504753f},
        { 0.0563134893f,  0.0659346245f},
        {-0.0893895137f,  0.1230341106f},
        {-0.0414421295f, -0.0171658921f},
        {-0.0057090414f,  0.0360454690f},
        {-0.0256425970f,  0.0020181162f},
        { 0.0036954541f,  0.0113734382f},
        {-0.0116111028f,  0.0071152929f},
        { 0.0059165832f,  0.0059165832f},
        {-0.0072934406f,  0.0119018134f},
        { 0.0001446564f,  0.0000470017f},
        {-0.0006603332f,  0.0083903291f},
    },
    {
        {-0.0006601188f, -0.0083876050f},   /* Filter 142 */
        {-0.0071025455f,  0.0023077569f},
        {-0.0076901970f, -0.0125492610f},
        {-0.0014750697f,  0.0014750697f},
        {-0.0154874953f, -0.0094907493f},
        {-0.0011342992f,  0.0034910138f},
        {-0.0396850155f, -0.0031232785f},
        {-0.0014936823f, -0.0094307390f},
        {-0.0952424548f,  0.0394507165f},
        {-0.0912411868f, -0.1255827200f},
        {-0.0330331698f,  0.0386768725f},
        {-0.4697232236f, -0.2393359367f},
        { 0.2337013059f, -0.9734359955f},
        { 1.1238179207f,  0.0000000000f},
        { 0.1864768087f,  0.7767318083f},
        {-0.2466720627f,  0.1256856936f},
        { 0.0570298443f,  0.0667733684f},
        {-0.0892115811f,  0.1227892073f},
        {-0.0408646640f, -0.0169266981f},
        {-0.0057344330f,  0.0362057853f},
        {-0.0254364807f,  0.0020018945f},
        { 0.0037336208f,  0.0114909033f},
        {-0.0115331333f,  0.0070675132f},
        { 0.0059844580f,  0.0059844580f},
        {-0.0072723269f,  0.0118673589f},
        { 0.0002203812f,  0.0000716062f},
        {-0.0006601188f,  0.0083876050f},
    },
    {
        {-0.0006599045f, -0.0083848818f},   /* Filter 143 */
        {-0.0071800761f,  0.0023329481f},
        {-0.0076768361f, -0.0125274579f},
        {-0.0015635480f,  0.0015635480f},
        {-0.0154889898f, -0.0094916651f},
        {-0.0011989560f,  0.0036900071f},
        {-0.0397691295f, -0.0031298984f},
        {-0.0014272835f, -0.0090115135f},
        {-0.0958107240f,  0.0396861013f},
        {-0.0910832065f, -0.1253652787f},
        {-0.0342669557f,  0.0401214502f},
        {-0.4722220141f, -0.2406091340f},
        { 0.2341204641f, -0.9751819152f},
        { 1.1232070923f,  0.0000000000f},
        { 0.1858857934f,  0.7742700522f},
        {-0.2443860233f,  0.1245208984f},
        { 0.0577462041f,  0.0676121180f},
        {-0.0890336484f,  0.1225443041f},
        {-0.0402871986f, -0.0166875040f},
        {-0.0057598252f,  0.0363661052f},
        {-0.0252303626f,  0.0019856726f},
        { 0.0037717876f,  0.0116083685f},
        {-0.0114551639f,  0.0070197335f},
        { 0.0060523329f,  0.0060523329f},
        {-0.0072512136f,  0.0118329052f},
        { 0.0002961061f,  0.0000962107f},
        {-0.0006599045f,  0.0083848818f},
    },
    {
        {-0.0006596901f, -0.0083821578f},   /* Filter 144 */
        {-0.0072576067f,  0.0023581394f},
        {-0.0076634751f, -0.0125056548f},
        {-0.0016520262f,  0.0016520262f},
        {-0.0154904827f, -0.0094925800f},
        {-0.0012636128f,  0.0038890005f},
        {-0.0398532435f, -0.0031365183f},
        {-0.0013608847f, -0.0085922880f},
        {-0.0963790001f,  0.0399214889f},
        {-0.0909252349f, -0.1251478494f},
        {-0.0355007440f,  0.0415660307f},
        {-0.4747208046f, -0.2418823314f},
        { 0.2345396223f, -0.9769278348f},
        { 1.1225962639f,  0.0000000000f},
        { 0.1852947641f,  0.7718082383f},
        {-0.2420999840f,  0.1233561032f},
        { 0.0584625591f,  0.0684508619f},
        {-0.0888557158f,  0.1222994008f},
        {-0.0397097331f, -0.0164483100f},
        {-0.0057852168f,  0.0365264215f},
        {-0.0250242464f,  0.0019694509f},
        { 0.0038099540f,  0.0117258327f},
        {-0.0113771945f,  0.0069719537f},
        { 0.0061202078f,  0.0061202077f},
        {-0.0072301004f,  0.0117984516f},
        { 0.0003718309f,  0.0001208152f},
        {-0.0006596901f,  0.0083821578f},
    },
    {
        {-0.0006593278f, -0.0083775545f},   /* Filter 145 */
        {-0.0073343827f,  0.0023830854f},
        {-0.0076484961f, -0.0124812113f},
        {-0.0017405448f,  0.0017405448f},
        {-0.0154878828f, -0.0094909868f},
        {-0.0013289429f,  0.0040900657f},
        {-0.0399294694f, -0.0031425174f},
        {-0.0012928271f, -0.0081625890f},
        {-0.0969416386f,  0.0401545414f},
        {-0.0907495707f, -0.1249060685f},
        {-0.0367554358f,  0.0430350860f},
        {-0.4772197544f, -0.2431556099f},
        { 0.2349492074f, -0.9786338796f},
        { 1.1219333410f,  0.0000000000f},
        { 0.1846986144f,  0.7693250958f},
        {-0.2398315234f,  0.1222002648f},
        { 0.0591558912f,  0.0692626495f},
        {-0.0886666509f,  0.1220391752f},
        {-0.0391365079f, -0.0162108723f},
        {-0.0058088374f,  0.0366755560f},
        {-0.0248155174f,  0.0019530236f},
        { 0.0038466317f,  0.0118387150f},
        {-0.0112968841f,  0.0069227395f},
        { 0.0061864692f,  0.0061864692f},
        {-0.0072077259f,  0.0117619396f},
        { 0.0004467046f,  0.0001451431f},
        {-0.0006593278f,  0.0083775545f},
    },
    {
        {-0.0006589655f, -0.0083729503f},   /* Filter 146 */
        {-0.0074111591f,  0.0024080316f},
        {-0.0076335167f, -0.0124567670f},
        {-0.0018290634f,  0.0018290634f},
        {-0.0154852846f, -0.0094893946f},
        {-0.0013942730f,  0.0042911310f},
        {-0.0400056952f, -0.0031485165f},
        {-0.0012247695f, -0.0077328901f},
        {-0.0975042702f,  0.0403875911f},
        {-0.0905739154f, -0.1246642996f},
        {-0.0380101300f,  0.0445041442f},
        {-0.4797186511f, -0.2444288614f},
        { 0.2353587647f, -0.9803398084f},
        { 1.1212704182f,  0.0000000000f},
        { 0.1841024646f,  0.7668419534f},
        {-0.2375630363f,  0.1210444129f},
        { 0.0598492233f,  0.0700744371f},
        {-0.0884775859f,  0.1217789497f},
        {-0.0385632792f, -0.0159734332f},
        {-0.0058324580f,  0.0368246905f},
        {-0.0246067885f,  0.0019365963f},
        { 0.0038833097f,  0.0119515982f},
        {-0.0112165737f,  0.0068735252f},
        { 0.0062527300f,  0.0062527300f},
        {-0.0071853518f,  0.0117254285f},
        { 0.0005215783f,  0.0001694711f},
        {-0.0006589655f,  0.0083729503f},
    },
    {
        {-0.0006586031f, -0.0083683461f},   /* Filter 147 */
        {-0.0074879351f,  0.0024329776f},
        {-0.0076185377f, -0.0124323236f},
        {-0.0019175820f,  0.0019175820f},
        {-0.0154826848f, -0.0094878014f},
        {-0.0014596031f,  0.0044921963f},
        {-0.0400819211f, -0.0031545156f},
        {-0.0011567119f, -0.0073031915f},
        {-0.0980669088f,  0.0406206436f},
        {-0.0903982600f, -0.1244225307f},
        {-0.0392648217f,  0.0459731995f},
        {-0.4822176009f, -0.2457021399f},
        { 0.2357683498f, -0.9820458531f},
        { 1.1206073761f,  0.0000000000f},
        { 0.1835063149f,  0.7643588110f},
        {-0.2352945758f,  0.1198885745f},
        { 0.0605425555f,  0.0708862248f},
        {-0.0882885123f,  0.1215187121f},
        {-0.0379900539f, -0.0157359955f},
        {-0.0058560780f,  0.0369738213f},
        {-0.0243980596f,  0.0019201689f},
        { 0.0039199873f,  0.0120644805f},
        {-0.0111362633f,  0.0068243110f},
        { 0.0063189914f,  0.0063189914f},
        {-0.0071629778f,  0.0116889173f},
        { 0.0005964521f,  0.0001937990f},
        {-0.0006586031f,  0.0083683461f},
    },
    {
        {-0.0006582408f, -0.0083637419f},   /* Filter 148 */
        {-0.0075647111f,  0.0024579236f},
        {-0.0076035587f, -0.0124078801f},
        {-0.0020061004f,  0.0020061004f},
        {-0.0154800849f, -0.0094862083f},
        {-0.0015249331f,  0.0046932616f},
        {-0.0401581470f, -0.0031605147f},
        {-0.0010886543f, -0.0068734926f},
        {-0.0986295404f,  0.0408536933f},
        {-0.0902225958f, -0.1241807498f},
        {-0.0405195159f,  0.0474422576f},
        {-0.4847164976f, -0.2469753914f},
        { 0.2361779071f, -0.9837517819f},
        { 1.1199444532f,  0.0000000000f},
        { 0.1829101651f,  0.7618756686f},
        {-0.2330260887f,  0.1187327226f},
        { 0.0612358876f,  0.0716980124f},
        {-0.0880994473f,  0.1212584865f},
        {-0.0374168286f, -0.0154985579f},
        {-0.0058796986f,  0.0371229558f},
        {-0.0241893307f,  0.0019037416f},
        { 0.0039566650f,  0.0121773628f},
        {-0.0110559522f,  0.0067750962f},
        { 0.0063852528f,  0.0063852528f},
        {-0.0071406037f,  0.0116524062f},
        { 0.0006713257f,  0.0002181269f},
        {-0.0006582408f,  0.0083637419f},
    },
    {
        {-0.0006577322f, -0.0083572799f},   /* Filter 149 */
        {-0.0076406624f,  0.0024826017f},
        {-0.0075869627f, -0.0123807979f},
        {-0.0020945793f,  0.0020945793f},
        {-0.0154733511f, -0.0094820818f},
        {-0.0015908856f,  0.0048962423f},
        {-0.0402262842f, -0.0031658772f},
        {-0.0010189602f, -0.0064334613f},
        {-0.0991860664f,  0.0410842139f},
        {-0.0900290465f, -0.1239143519f},
        {-0.0417948910f,  0.0489355300f},
        {-0.4872147571f, -0.2482483181f},
        { 0.2365777521f, -0.9854172562f},
        { 1.1192296743f,  0.0000000000f},
        { 0.1823091036f,  0.7593720670f},
        {-0.2307757911f,  0.1175861387f},
        { 0.0619062356f,  0.0724828890f},
        {-0.0878995479f,  0.1209833486f},
        {-0.0368481705f, -0.0152630120f},
        {-0.0059015592f,  0.0372609784f},
        {-0.0239782156f,  0.0018871265f},
        { 0.0039918381f,  0.0122856144f},
        {-0.0109733961f,  0.0067245058f},
        { 0.0064498541f,  0.0064498541f},
        {-0.0071169970f,  0.0116138836f},
        { 0.0007452916f,  0.0002421599f},
        {-0.0006577322f,  0.0083572799f},
    },
    {
        {-0.0006572235f, -0.0083508170f},   /* Filter 150 */
        {-0.0077166129f,  0.0025072795f},
        {-0.0075703667f, -0.0123537157f},
        {-0.0021830581f,  0.0021830581f},
        {-0.0154666173f, -0.0094779553f},
        {-0.0016568381f,  0.0050992234f},
        {-0.0402944251f, -0.0031712400f},
        {-0.0009492661f, -0.0059934300f},
        {-0.0997425856f,  0.0413147317f},
        {-0.0898354883f, -0.1236479420f},
        {-0.0430702685f,  0.0504288052f},
        {-0.4897130165f, -0.2495212449f},
        { 0.2369775693f, -0.9870826146f},
        { 1.1185147762f,  0.0000000000f},
        { 0.1817080420f,  0.7568684655f},
        {-0.2285254935f,  0.1164395548f},
        { 0.0625765836f,  0.0732677657f},
        {-0.0876996573f,  0.1207082227f},
        {-0.0362795124f, -0.0150274661f},
        {-0.0059234193f,  0.0373989973f},
        {-0.0237670987f,  0.0018705112f},
        { 0.0040270112f,  0.0123938661f},
        {-0.0108908393f,  0.0066739149f},
        { 0.0065144553f,  0.0065144553f},
        {-0.0070933904f,  0.0115753611f},
        { 0.0008192576f,  0.0002661929f},
        {-0.0006572235f,  0.0083508170f},
    },
    {
        {-0.0006567149f, -0.0083443540f},   /* Filter 151 */
        {-0.0077925634f,  0.0025319573f},
        {-0.0075537707f, -0.0123266335f},
        {-0.0022715368f,  0.0022715368f},
        {-0.0154598835f, -0.0094738288f},
        {-0.0017227906f,  0.0053022041f},
        {-0.0403625660f, -0.0031766029f},
        {-0.0008795720f, -0.0055533987f},
        {-0.1002991048f,  0.0415452495f},
        {-0.0896419302f, -0.1233815321f},
        {-0.0443456460f,  0.0519220803f},
        {-0.4922112759f, -0.2507941716f},
        { 0.2373774143f, -0.9887480889f},
        { 1.1177999973f,  0.0000000000f},
        { 0.1811069666f,  0.7543648061f},
        {-0.2262751694f,  0.1152929574f},
        { 0.0632469267f,  0.0740526367f},
        {-0.0874997666f,  0.1204330968f},
        {-0.0357108543f, -0.0147919202f},
        {-0.0059452799f,  0.0375370199f},
        {-0.0235559837f,  0.0018538961f},
        { 0.0040621843f,  0.0125021177f},
        {-0.0108082824f,  0.0066233240f},
        { 0.0065790572f,  0.0065790572f},
        {-0.0070697837f,  0.0115368385f},
        { 0.0008932235f,  0.0002902259f},
        {-0.0006567149f,  0.0083443540f},
    },
    {
        {-0.0006562063f, -0.0083378920f},   /* Filter 152 */
        {-0.0078685138f,  0.0025566351f},
        {-0.0075371742f, -0.0122995505f},
        {-0.0023600156f,  0.0023600156f},
        {-0.0154531496f, -0.0094697023f},
        {-0.0017887430f,  0.0055051848f},
        {-0.0404307070f, -0.0031819657f},
        {-0.0008098778f, -0.0051133675f},
        {-0.1008556239f,  0.0417757672f},
        {-0.0894483808f, -0.1231151342f},
        {-0.0456210186f,  0.0534153499f},
        {-0.4947095884f, -0.2520671255f},
        { 0.2377772314f, -0.9904134473f},
        { 1.1170852184f,  0.0000000000f},
        { 0.1805059050f,  0.7518612045f},
        {-0.2240248718f,  0.1141463735f},
        { 0.0639172747f,  0.0748375133f},
        {-0.0872998672f,  0.1201579589f},
        {-0.0351421962f, -0.0145563743f},
        {-0.0059671405f,  0.0376750426f},
        {-0.0233448668f,  0.0018372809f},
        { 0.0040973574f,  0.0126103694f},
        {-0.0107257264f,  0.0065727336f},
        { 0.0066436584f,  0.0066436584f},
        {-0.0070461776f,  0.0114983168f},
        { 0.0009671894f,  0.0003142589f},
        {-0.0006562063f,  0.0083378920f},
    },
    {
        {-0.0006555532f, -0.0083295935f},   /* Filter 153 */
        {-0.0079435671f,  0.0025810214f},
        {-0.0075189641f, -0.0122698343f},
        {-0.0024483737f,  0.0024483736f},
        {-0.0154422437f, -0.0094630191f},
        {-0.0018552657f,  0.0057099206f},
        {-0.0404905698f, -0.0031866770f},
        {-0.0007385710f, -0.0046631539f},
        {-0.1014055487f,  0.0420035536f},
        {-0.0892367185f, -0.1228238060f},
        {-0.0469168496f,  0.0549325730f},
        {-0.4972063608f, -0.2533392945f},
        { 0.2381671972f, -0.9920377716f},
        { 1.1163188219f,  0.0000000000f},
        { 0.1799001404f,  0.7493380133f},
        {-0.2217933347f,  0.1130093486f},
        { 0.0645646918f,  0.0755955413f},
        {-0.0870894661f,  0.1198683666f},
        {-0.0345784254f, -0.0143228528f},
        {-0.0059872534f,  0.0378020306f},
        {-0.0231315866f,  0.0018204954f},
        { 0.0041310112f,  0.0127139452f},
        {-0.0106410200f,  0.0065208254f},
        { 0.0067065554f,  0.0067065554f},
        {-0.0070213680f,  0.0114578312f},
        { 0.0010401923f,  0.0003379790f},
        {-0.0006555532f,  0.0083295935f},
    },
    {
        {-0.0006549001f, -0.0083212950f},   /* Filter 154 */
        {-0.0080186212f,  0.0026054079f},
        {-0.0075007536f, -0.0122401174f},
        {-0.0025367317f,  0.0025367317f},
        {-0.0154313378f, -0.0094563359f},
        {-0.0019217884f,  0.0059146564f},
        {-0.0405504327f, -0.0031913883f},
        {-0.0006672642f, -0.0042129402f},
        {-0.1019554735f,  0.0422313399f},
        {-0.0890250562f, -0.1225324778f},
        {-0.0482126757f,  0.0564497904f},
        {-0.4997031332f, -0.2546114636f},
        { 0.2385571351f, -0.9936619800f},
        { 1.1155524254f,  0.0000000000f},
        { 0.1792943758f,  0.7468148221f},
        {-0.2195617843f,  0.1118723169f},
        { 0.0652121089f,  0.0763535694f},
        {-0.0868790563f,  0.1195787623f},
        {-0.0340146545f, -0.0140893312f},
        {-0.0060073658f,  0.0379290149f},
        {-0.0229183064f,  0.0018037098f},
        { 0.0041646653f,  0.0128175219f},
        {-0.0105563135f,  0.0064689173f},
        { 0.0067694530f,  0.0067694529f},
        {-0.0069965580f,  0.0114173449f},
        { 0.0011131952f,  0.0003616991f},
        {-0.0006549001f,  0.0083212950f},
    },
    {
        {-0.0006542470f, -0.0083129965f},   /* Filter 155 */
        {-0.0080936744f,  0.0026297942f},
        {-0.0074825430f, -0.0122104004f},
        {-0.0026250900f,  0.0026250900f},
        {-0.0154204302f, -0.0094496518f},
        {-0.0019883112f,  0.0061193927f},
        {-0.0406102918f, -0.0031960993f},
        {-0.0005959573f, -0.0037627266f},
        {-0.1025054052f,  0.0424591290f},
        {-0.0888133938f, -0.1222411496f},
        {-0.0495085018f,  0.0579670079f},
        {-0.5021999056f, -0.2558836327f},
        { 0.2389470731f, -0.9952861883f},
        { 1.1147860289f,  0.0000000000f},
        { 0.1786885972f,  0.7442915729f},
        {-0.2173302472f,  0.1107352919f},
        { 0.0658595211f,  0.0771115917f},
        {-0.0866686552f,  0.1192891701f},
        {-0.0334508837f, -0.0138558097f},
        {-0.0060274787f,  0.0380560029f},
        {-0.0227050262f,  0.0017869243f},
        { 0.0041983192f,  0.0129210977f},
        {-0.0104716071f,  0.0064170091f},
        { 0.0068323499f,  0.0068323499f},
        {-0.0069717484f,  0.0113768594f},
        { 0.0011861981f,  0.0003854191f},
        {-0.0006542470f,  0.0083129965f},
    },
    {
        {-0.0006535939f, -0.0083046980f},   /* Filter 156 */
        {-0.0081687285f,  0.0026541808f},
        {-0.0074643324f, -0.0121806834f},
        {-0.0027134480f,  0.0027134480f},
        {-0.0154095243f, -0.0094429686f},
        {-0.0020548339f,  0.0063241285f},
        {-0.0406701546f, -0.0032008106f},
        {-0.0005246505f, -0.0033125128f},
        {-0.1030553301f,  0.0426869154f},
        {-0.0886017403f, -0.1219498335f},
        {-0.0508043328f,  0.0594842310f},
        {-0.5046967311f, -0.2571558288f},
        { 0.2393370388f, -0.9969105126f},
        { 1.1140196323f,  0.0000000000f},
        { 0.1780828326f,  0.7417683816f},
        {-0.2150987101f,  0.1095982669f},
        { 0.0665069382f,  0.0778696197f},
        {-0.0864582453f,  0.1189995658f},
        {-0.0328871128f, -0.0136222881f},
        {-0.0060475916f,  0.0381829910f},
        {-0.0224917460f,  0.0017701388f},
        { 0.0042319733f,  0.0130246745f},
        {-0.0103869007f,  0.0063651009f},
        { 0.0068952475f,  0.0068952475f},
        {-0.0069469388f,  0.0113363739f},
        { 0.0012592008f,  0.0004091391f},
        {-0.0006535939f,  0.0083046980f},
    },
    {
        {-0.0006527982f, -0.0082945881f},   /* Filter 157 */
        {-0.0082428136f,  0.0026782525f},
        {-0.0074445116f, -0.0121483388f},
        {-0.0028016041f,  0.0028016041f},
        {-0.0153944097f, -0.0094337064f},
        {-0.0021218736f,  0.0065304555f},
        {-0.0407215500f, -0.0032048555f},
        {-0.0004517562f, -0.0028522762f},
        {-0.1035981787f,  0.0429117706f},
        {-0.0883717723f, -0.1216333097f},
        {-0.0521203656f,  0.0610251074f},
        {-0.5071912198f, -0.2584268343f},
        { 0.2397169305f, -0.9984928755f},
        { 1.1132018566f,  0.0000000000f},
        { 0.1774725736f,  0.7392264700f},
        {-0.2128865308f,  0.1084711053f},
        { 0.0671314824f,  0.0786008671f},
        {-0.0862376404f,  0.1186959292f},
        {-0.0323285424f, -0.0133909207f},
        {-0.0060659709f,  0.0382990327f},
        {-0.0222765216f,  0.0017532003f},
        { 0.0042640952f,  0.0131235355f},
        {-0.0103001415f,  0.0063119349f},
        { 0.0069563979f,  0.0069563979f},
        {-0.0069209560f,  0.0112939738f},
        { 0.0013311864f,  0.0004325287f},
        {-0.0006527982f,  0.0082945881f},
    },
    {
        {-0.0006520026f, -0.0082844791f},   /* Filter 158 */
        {-0.0083168996f,  0.0027023245f},
        {-0.0074246903f, -0.0121159935f},
        {-0.0028897598f,  0.0028897598f},
        {-0.0153792951f, -0.0094244442f},
        {-0.0021889135f,  0.0067367830f},
        {-0.0407729454f, -0.0032089004f},
        {-0.0003788618f, -0.0023920396f},
        {-0.1041410205f,  0.0431366231f},
        {-0.0881418043f, -0.1213167859f},
        {-0.0534364032f,  0.0625659895f},
        {-0.5096857086f, -0.2596978398f},
        { 0.2400968501f, -1.0000753543f},
        { 1.1123842001f,  0.0000000000f},
        { 0.1768623146f,  0.7366845584f},
        {-0.2106743383f,  0.1073439370f},
        { 0.0677560267f,  0.0793321144f},
        {-0.0860170442f,  0.1183923046f},
        {-0.0317699720f, -0.0131595533f},
        {-0.0060843501f,  0.0384150744f},
        {-0.0220612991f,  0.0017362619f},
        { 0.0042962171f,  0.0132223965f},
        {-0.0102133832f,  0.0062587693f},
        { 0.0070175484f,  0.0070175484f},
        {-0.0068949737f,  0.0112515745f},
        { 0.0014031721f,  0.0004559183f},
        {-0.0006520026f,  0.0082844791f},
    },
    {
        {-0.0006512070f, -0.0082743692f},   /* Filter 159 */
        {-0.0083909855f,  0.0027263965f},
        {-0.0074048695f, -0.0120836489f},
        {-0.0029779159f,  0.0029779159f},
        {-0.0153641806f, -0.0094151820f},
        {-0.0022559532f,  0.0069431100f},
        {-0.0408243407f, -0.0032129453f},
        {-0.0003059675f, -0.0019318029f},
        {-0.1046838691f,  0.0433614783f},
        {-0.0879118451f, -0.1210002742f},
        {-0.0547524360f,  0.0641068659f},
        {-0.5121801973f, -0.2609688453f},
        { 0.2404767696f, -1.0016578330f},
        { 1.1115665436f,  0.0000000000f},
        { 0.1762520557f,  0.7341426468f},
        {-0.2084621591f,  0.1062167754f},
        { 0.0683805709f,  0.0800633618f},
        {-0.0857964393f,  0.1180886679f},
        {-0.0312114016f, -0.0129281858f},
        {-0.0061027287f,  0.0385311125f},
        {-0.0218460766f,  0.0017193235f},
        { 0.0043283390f,  0.0133212575f},
        {-0.0101266241f,  0.0062056032f},
        { 0.0070786989f,  0.0070786989f},
        {-0.0068689909f,  0.0112091745f},
        { 0.0014751579f,  0.0004793079f},
        {-0.0006512070f,  0.0082743692f},
    },
    {
        {-0.0006504113f, -0.0082642593f},   /* Filter 160 */
        {-0.0084650706f,  0.0027504682f},
        {-0.0073850488f, -0.0120513043f},
        {-0.0030660719f,  0.0030660719f},
        {-0.0153490660f, -0.0094059197f},
        {-0.0023229930f,  0.0071494375f},
        {-0.0408757361f, -0.0032169902f},
        {-0.0002330732f, -0.0014715665f},
        {-0.1052267178f,  0.0435863336f},
        {-0.0876818771f, -0.1206837505f},
        {-0.0560684736f,  0.0656477480f},
        {-0.5146746861f, -0.2622398508f},
        { 0.2408566892f, -1.0032403118f},
        { 1.1107488871f,  0.0000000000f},
        { 0.1756417967f,  0.7316007352f},
        {-0.2062499666f,  0.1050896070f},
        { 0.0690051152f,  0.0807946091f},
        {-0.0855758343f,  0.1177850312f},
        {-0.0306528311f, -0.0126968184f},
        {-0.0061211079f,  0.0386471542f},
        {-0.0216308523f,  0.0017023850f},
        { 0.0043604609f,  0.0134201186f},
        {-0.0100398657f,  0.0061524376f},
        { 0.0071398493f,  0.0071398493f},
        {-0.0068430081f,  0.0111667744f},
        { 0.0015471436f,  0.0005026974f},
        {-0.0006504113f,  0.0082642593f},
    },
    {
        {-0.0006494751f, -0.0082523639f},   /* Filter 161 */
        {-0.0085381176f,  0.0027742026f},
        {-0.0073636226f, -0.0120163400f},
        {-0.0031539435f,  0.0031539435f},
        {-0.0153297110f, -0.0093940590f},
        {-0.0023904954f,  0.0073571883f},
        {-0.0409184746f, -0.0032203538f},
        {-0.0001586182f, -0.0010014759f},
        {-0.1057620015f,  0.0438080554f},
        {-0.0874334108f, -0.1203417659f},
        {-0.0574044615f,  0.0672119888f},
        {-0.5171660945f, -0.2635092868f},
        { 0.2412264233f, -1.0047803655f},
        { 1.1098802090f,  0.0000000000f},
        { 0.1750272660f,  0.7290410306f},
        {-0.2040577163f,  0.1039725996f},
        { 0.0696068640f,  0.0814991665f},
        {-0.0853453496f,  0.1174677962f},
        {-0.0300997675f, -0.0124677319f},
        {-0.0061377673f,  0.0387523380f},
        {-0.0214139065f,  0.0016853110f},
        { 0.0043910390f,  0.0135142285f},
        {-0.0099511524f,  0.0060980740f},
        { 0.0071992125f,  0.0071992125f},
        {-0.0068158833f,  0.0111225106f},
        { 0.0016180593f,  0.0005257393f},
        {-0.0006494751f,  0.0082523639f},
    },
    {
        {-0.0006485390f, -0.0082404695f},   /* Filter 162 */
        {-0.0086111655f,  0.0027979373f},
        {-0.0073421965f, -0.0119813757f},
        {-0.0032418154f,  0.0032418154f},
        {-0.0153103576f, -0.0093821992f},
        {-0.0024579979f,  0.0075649396f},
        {-0.0409612168f, -0.0032237177f},
        {-0.0000841632f, -0.0005313853f},
        {-0.1062972852f,  0.0440297772f},
        {-0.0871849357f, -0.1199997693f},
        {-0.0587404494f,  0.0687762296f},
        {-0.5196575030f, -0.2647787229f},
        { 0.2415961853f, -1.0063205351f},
        { 1.1090114117f,  0.0000000000f},
        { 0.1744127213f,  0.7264812680f},
        {-0.2018654526f,  0.1028555855f},
        { 0.0702086080f,  0.0822037181f},
        {-0.0851148649f,  0.1171505612f},
        {-0.0295467004f, -0.0122386440f},
        {-0.0061544274f,  0.0388575254f},
        {-0.0211969608f,  0.0016682370f},
        { 0.0044216175f,  0.0136083393f},
        {-0.0098624390f,  0.0060437104f},
        { 0.0072585757f,  0.0072585757f},
        {-0.0067887584f,  0.0110782468f},
        { 0.0016889751f,  0.0005487813f},
        {-0.0006485390f,  0.0082404695f},
    },
    {
        {-0.0006476028f, -0.0082285742f},   /* Filter 163 */
        {-0.0086842126f,  0.0028216717f},
        {-0.0073207704f, -0.0119464115f},
        {-0.0033296870f,  0.0033296870f},
        {-0.0152910026f, -0.0093703385f},
        {-0.0025255004f,  0.0077726909f},
        {-0.0410039590f, -0.0032270816f},
        {-0.0000097081f, -0.0000612947f},
        {-0.1068325690f,  0.0442514990f},
        {-0.0869364694f, -0.1196577848f},
        {-0.0600764372f,  0.0703404704f},
        {-0.5221488584f, -0.2660481318f},
        { 0.2419659195f, -1.0078605888f},
        { 1.1081427336f,  0.0000000000f},
        { 0.1737981906f,  0.7239215633f},
        {-0.1996732022f,  0.1017385781f},
        { 0.0708103568f,  0.0829082755f},
        {-0.0848843801f,  0.1168333262f},
        {-0.0289936333f, -0.0120095561f},
        {-0.0061710869f,  0.0389627091f},
        {-0.0209800151f,  0.0016511630f},
        { 0.0044521959f,  0.0137024501f},
        {-0.0097737264f,  0.0059893473f},
        { 0.0073179389f,  0.0073179389f},
        {-0.0067616335f,  0.0110339831f},
        { 0.0017598908f,  0.0005718232f},
        {-0.0006476028f,  0.0082285742f},
    },
    {
        {-0.0006466667f, -0.0082166789f},   /* Filter 164 */
        {-0.0087572596f,  0.0028454061f},
        {-0.0072993442f, -0.0119114472f},
        {-0.0034175589f,  0.0034175589f},
        {-0.0152716477f, -0.0093584777f},
        {-0.0025930029f,  0.0079804422f},
        {-0.0410467012f, -0.0032304455f},
        { 0.0000647469f,  0.0004087959f},
        {-0.1073678527f,  0.0444732207f},
        {-0.0866880031f, -0.1193158002f},
        {-0.0614124299f,  0.0719047169f},
        {-0.5246402669f, -0.2673175678f},
        { 0.2423356537f, -1.0094006425f},
        { 1.1072740555f,  0.0000000000f},
        { 0.1731836599f,  0.7213618587f},
        {-0.1974809385f,  0.1006215640f},
        { 0.0714121008f,  0.0836128272f},
        {-0.0846538954f,  0.1165160911f},
        {-0.0284405679f, -0.0117804689f},
        {-0.0061877469f,  0.0390678966f},
        {-0.0207630675f,  0.0016340889f},
        { 0.0044827744f,  0.0137965609f},
        {-0.0096850131f,  0.0059349836f},
        { 0.0073773020f,  0.0073773020f},
        {-0.0067345086f,  0.0109897193f},
        { 0.0018308065f,  0.0005948651f},
        {-0.0006466667f,  0.0082166789f},
    },
    {
        {-0.0006455921f, -0.0082030260f},   /* Filter 165 */
        {-0.0088291976f,  0.0028687802f},
        {-0.0072763196f, -0.0118738744f},
        {-0.0035050636f,  0.0035050636f},
        {-0.0152480253f, -0.0093440019f},
        {-0.0026609126f,  0.0081894468f},
        {-0.0410806082f, -0.0032331140f},
        { 0.0001407344f,  0.0008885622f},
        {-0.1078950829f,  0.0446916066f},
        {-0.0864208458f, -0.1189480897f},
        {-0.0627681067f,  0.0734920105f},
        {-0.5271277453f, -0.2685850014f},
        { 0.2426950912f, -1.0108978075f},
        { 1.1063547134f,  0.0000000000f},
        { 0.1725650523f,  0.7187851725f},
        {-0.1953091746f,  0.0995149950f},
        { 0.0719911267f,  0.0842907795f},
        {-0.0844138462f,  0.1161856917f},
        {-0.0278933018f, -0.0115537839f},
        {-0.0062027030f,  0.0391623253f},
        {-0.0205446177f,  0.0016168965f},
        { 0.0045117990f,  0.0138858896f},
        {-0.0095944447f,  0.0058794833f},
        { 0.0074348391f,  0.0074348391f},
        {-0.0067062733f,  0.0109436434f},
        { 0.0019006009f,  0.0006175427f},
        {-0.0006455921f,  0.0082030260f},
    },
    {
        {-0.0006445176f, -0.0081893731f},   /* Filter 166 */
        {-0.0089011357f,  0.0028921543f},
        {-0.0072532954f, -0.0118363023f},
        {-0.0035925684f,  0.0035925684f},
        {-0.0152244029f, -0.0093295261f},
        {-0.0027288220f,  0.0083984506f},
        {-0.0411145153f, -0.0032357825f},
        { 0.0002167219f,  0.0013683284f},
        {-0.1084223130f,  0.0449099925f},
        {-0.0861536884f, -0.1185803792f},
        {-0.0641237884f,  0.0750793098f},
        {-0.5296151707f, -0.2698524080f},
        { 0.2430545287f, -1.0123949724f},
        { 1.1054353714f,  0.0000000000f},
        { 0.1719464586f,  0.7162085442f},
        {-0.1931374107f,  0.0984084260f},
        { 0.0725701576f,  0.0849687375f},
        {-0.0841737969f,  0.1158552923f},
        {-0.0273460374f, -0.0113270996f},
        {-0.0062176590f,  0.0392567541f},
        {-0.0203261679f,  0.0015997041f},
        { 0.0045408240f,  0.0139752192f},
        {-0.0095038756f,  0.0058239824f},
        { 0.0074923761f,  0.0074923761f},
        {-0.0066780380f,  0.0108975675f},
        { 0.0019703953f,  0.0006402202f},
        {-0.0006445176f,  0.0081893731f},
    },
    {
        {-0.0006434431f, -0.0081757193f},   /* Filter 167 */
        {-0.0089730738f,  0.0029155284f},
        {-0.0072302707f, -0.0117987295f},
        {-0.0036800735f,  0.0036800735f},
        {-0.0152007789f, -0.0093150493f},
        {-0.0027967317f,  0.0086074552f},
        {-0.0411484223f, -0.0032384511f},
        { 0.0002927095f,  0.0018480947f},
        {-0.1089495431f,  0.0451283783f},
        {-0.0858865311f, -0.1182126686f},
        {-0.0654794652f,  0.0766666033f},
        {-0.5321026492f, -0.2711198415f},
        { 0.2434139662f, -1.0138921374f},
        { 1.1045160294f,  0.0000000000f},
        { 0.1713278509f,  0.7136318579f},
        {-0.1909656600f,  0.0973018638f},
        { 0.0731491835f,  0.0856466898f},
        {-0.0839337477f,  0.1155248929f},
        {-0.0267987713f, -0.0111004145f},
        {-0.0062326157f,  0.0393511866f},
        {-0.0201077181f,  0.0015825117f},
        { 0.0045698486f,  0.0140645479f},
        {-0.0094133072f,  0.0057684821f},
        { 0.0075499131f,  0.0075499131f},
        {-0.0066498022f,  0.0108514909f},
        { 0.0020401896f,  0.0006628978f},
        {-0.0006434431f,  0.0081757193f},
    },
    {
        {-0.0006423686f, -0.0081620665f},   /* Filter 168 */
        {-0.0090450118f,  0.0029389025f},
        {-0.0072072466f, -0.0117611575f},
        {-0.0037675782f,  0.0037675782f},
        {-0.0151771565f, -0.0093005735f},
        {-0.0028646414f,  0.0088164598f},
        {-0.0411823294f, -0.0032411196f},
        { 0.0003686970f,  0.0023278609f},
        {-0.1094767732f,  0.0453467642f},
        {-0.0856193737f, -0.1178449581f},
        {-0.0668351468f,  0.0782539026f},
        {-0.5345900745f, -0.2723872481f},
        { 0.2437734037f, -1.0153893023f},
        { 1.1035966873f,  0.0000000000f},
        { 0.1707092572f,  0.7110552296f},
        {-0.1887938961f,  0.0961952948f},
        { 0.0737282143f,  0.0863246478f},
        {-0.0836936985f,  0.1151944935f},
        {-0.0262515052f, -0.0108737295f},
        {-0.0062475717f,  0.0394456154f},
        {-0.0198892683f,  0.0015653194f},
        { 0.0045988736f,  0.0141538774f},
        {-0.0093227389f,  0.0057129817f},
        { 0.0076074508f,  0.0076074508f},
        {-0.0066215668f,  0.0108054150f},
        { 0.0021099840f,  0.0006855754f},
        {-0.0006423686f,  0.0081620665f},
    },
    {
        {-0.0006411579f, -0.0081466839f},   /* Filter 169 */
        {-0.0091157710f,  0.0029618935f},
        {-0.0071826321f, -0.0117209904f},
        {-0.0038546332f,  0.0038546332f},
        {-0.0151492398f, -0.0092834661f},
        {-0.0029329017f,  0.0090265432f},
        {-0.0412072268f, -0.0032430791f},
        { 0.0004461872f,  0.0028171151f},
        {-0.1099954610f,  0.0455616117f},
        {-0.0853333414f, -0.1174512684f},
        {-0.0682102416f,  0.0798639317f},
        {-0.5370727733f, -0.2736522463f},
        { 0.2441223776f, -1.0168428830f},
        { 1.1026270390f,  0.0000000000f},
        { 0.1700868092f,  0.7084625470f},
        {-0.1866431763f,  0.0950994483f},
        { 0.0742846143f,  0.0869761084f},
        {-0.0834444001f,  0.1148513637f},
        {-0.0257103275f, -0.0106495664f},
        {-0.0062608412f,  0.0395293959f},
        {-0.0196695316f,  0.0015480257f},
        { 0.0046263364f,  0.0142383992f},
        {-0.0092304140f,  0.0056564050f},
        { 0.0076631249f,  0.0076631248f},
        {-0.0065922531f,  0.0107575794f},
        { 0.0021786070f,  0.0007078723f},
        {-0.0006411579f,  0.0081466839f},
    },
    {
        {-0.0006399473f, -0.0081313013f},   /* Filter 170 */
        {-0.0091865301f,  0.0029848846f},
        {-0.0071580177f, -0.0116808232f},
        {-0.0039416882f,  0.0039416882f},
        {-0.0151213230f, -0.0092663586f},
        {-0.0030011619f,  0.0092366267f},
        {-0.0412321204f, -0.0032450383f},
        { 0.0005236775f,  0.0033063695f},
        {-0.1105141488f,  0.0457764592f},
        {-0.0850473091f, -0.1170575787f},
        {-0.0695853363f,  0.0814739608f},
        {-0.5395555251f, -0.2749172715f},
        { 0.2444713793f, -1.0182965797f},
        { 1.1016573906f,  0.0000000000f},
        { 0.1694643611f,  0.7058698644f},
        {-0.1844924564f,  0.0940036018f},
        { 0.0748410142f,  0.0876275690f},
        {-0.0831951017f,  0.1145082339f},
        {-0.0251691481f, -0.0104254025f},
        {-0.0062741113f,  0.0396131801f},
        {-0.0194497931f,  0.0015307319f},
        { 0.0046537991f,  0.0143229210f},
        {-0.0091380892f,  0.0055998282f},
        { 0.0077187989f,  0.0077187989f},
        {-0.0065629390f,  0.0107097431f},
        { 0.0022472299f,  0.0007301693f},
        {-0.0006399473f,  0.0081313013f},
    },
    {
        {-0.0006387366f, -0.0081159187f},   /* Filter 171 */
        {-0.0092572893f,  0.0030078756f},
        {-0.0071334033f, -0.0116406561f},
        {-0.0040287435f,  0.0040287435f},
        {-0.0150934062f, -0.0092492512f},
        {-0.0030694222f,  0.0094467102f},
        {-0.0412570140f, -0.0032469974f},
        { 0.0006011677f,  0.0037956237f},
        {-0.1110328365f,  0.0459913067f},
        {-0.0847612768f, -0.1166638890f},
        {-0.0709604311f,  0.0830839899f},
        {-0.5420382238f, -0.2761822697f},
        { 0.2448203531f, -1.0197501604f},
        { 1.1006877422f,  0.0000000000f},
        { 0.1688419131f,  0.7032771818f},
        {-0.1823417366f,  0.0929077553f},
        { 0.0753974141f,  0.0882790295f},
        {-0.0829458033f,  0.1141651041f},
        {-0.0246279704f, -0.0102012394f},
        {-0.0062873809f,  0.0396969606f},
        {-0.0192300565f,  0.0015134383f},
        { 0.0046812616f,  0.0144074419f},
        {-0.0090457651f,  0.0055432520f},
        { 0.0077744735f,  0.0077744735f},
        {-0.0065336253f,  0.0106619075f},
        { 0.0023158529f,  0.0007524662f},
        {-0.0006387366f,  0.0081159187f},
    },
    {
        {-0.0006375260f, -0.0081005361f},   /* Filter 172 */
        {-0.0093280493f,  0.0030308669f},
        {-0.0071087888f, -0.0116004890f},
        {-0.0041157985f,  0.0041157985f},
        {-0.0150654894f, -0.0092321438f},
        {-0.0031376827f,  0.0096567945f},
        {-0.0412819114f, -0.0032489569f},
        { 0.0006786580f,  0.0042848781f},
        {-0.1115515243f,  0.0462061542f},
        {-0.0844752445f, -0.1162701993f},
        {-0.0723355258f,  0.0846940190f},
        {-0.5445209226f, -0.2774472679f},
        { 0.2451693548f, -1.0212038570f},
        { 1.0997180939f,  0.0000000000f},
        { 0.1682194651f,  0.7006844992f},
        {-0.1801910168f,  0.0918119088f},
        { 0.0759538140f,  0.0889304901f},
        {-0.0826965050f,  0.1138219743f},
        {-0.0240867928f, -0.0099770762f},
        {-0.0063006504f,  0.0397807411f},
        {-0.0190103198f,  0.0014961446f},
        { 0.0047087244f,  0.0144919637f},
        {-0.0089534402f,  0.0054866752f},
        { 0.0078301475f,  0.0078301475f},
        {-0.0065043117f,  0.0106140720f},
        { 0.0023844758f,  0.0007747632f},
        {-0.0006375260f,  0.0081005361f},
    },
    {
        {-0.0006361816f, -0.0080834535f},   /* Filter 173 */
        {-0.0093975595f,  0.0030534522f},
        {-0.0070825944f, -0.0115577436f},
        {-0.0042023200f,  0.0042023200f},
        {-0.0150332576f, -0.0092123921f},
        {-0.0032062360f,  0.0098677796f},
        {-0.0412976208f, -0.0032501933f},
        { 0.0007576198f,  0.0047834232f},
        {-0.1120611741f,  0.0464172581f},
        {-0.0841701708f, -0.1158503014f},
        {-0.0737297482f,  0.0863264437f},
        {-0.5469980450f, -0.2787094248f},
        { 0.2455077537f, -1.0226133898f},
        { 1.0986984968f,  0.0000000000f},
        { 0.1675933854f,  0.6980766896f},
        {-0.1780618721f,  0.0907270554f},
        { 0.0764876846f,  0.0895555723f},
        {-0.0824382815f,  0.1134665602f},
        {-0.0235519823f, -0.0097555505f},
        {-0.0063122509f,  0.0398539838f},
        {-0.0187895099f,  0.0014787665f},
        { 0.0047346179f,  0.0145716555f},
        {-0.0088594597f,  0.0054290839f},
        { 0.0078839243f,  0.0078839243f},
        {-0.0064739522f,  0.0105645299f},
        { 0.0024518789f,  0.0007966637f},
        {-0.0006361816f,  0.0080834535f},
    },
    {
        {-0.0006348372f, -0.0080663719f},   /* Filter 174 */
        {-0.0094670707f,  0.0030760377f},
        {-0.0070563994f, -0.0115149973f},
        {-0.0042888419f,  0.0042888419f},
        {-0.0150010258f, -0.0091926404f},
        {-0.0032747895f,  0.0100787656f},
        {-0.0413133302f, -0.0032514296f},
        { 0.0008365815f,  0.0052819680f},
        {-0.1125708239f,  0.0466283620f},
        {-0.0838650884f, -0.1154303915f},
        {-0.0751239755f,  0.0879588741f},
        {-0.5494751673f, -0.2799715817f},
        { 0.2458461804f, -1.0240230385f},
        { 1.0976788998f,  0.0000000000f},
        { 0.1669673057f,  0.6954688800f},
        {-0.1759327407f,  0.0896422088f},
        { 0.0770215552f,  0.0901806545f},
        {-0.0821800492f,  0.1131111340f},
        {-0.0230171717f, -0.0095340247f},
        {-0.0063238520f,  0.0399272301f},
        {-0.0185687000f,  0.0014613884f},
        { 0.0047605113f,  0.0146513473f},
        {-0.0087654792f,  0.0053714926f},
        { 0.0079377004f,  0.0079377004f},
        {-0.0064435933f,  0.0105149887f},
        { 0.0025192818f,  0.0008185643f},
        {-0.0006348372f,  0.0080663719f},
    },
    {
        {-0.0006334928f, -0.0080492893f},   /* Filter 175 */
        {-0.0095365818f,  0.0030986233f},
        {-0.0070302049f, -0.0114722518f},
        {-0.0043753638f,  0.0043753638f},
        {-0.0149687939f, -0.0091728887f},
        {-0.0033433427f,  0.0102897508f},
        {-0.0413290433f, -0.0032526663f},
        { 0.0009155433f,  0.0057805131f},
        {-0.1130804738f,  0.0468394658f},
        {-0.0835600060f, -0.1150104815f},
        {-0.0765181979f,  0.0895912988f},
        {-0.5519522897f, -0.2812337386f},
        { 0.2461845793f, -1.0254325714f},
        { 1.0966593027f,  0.0000000000f},
        { 0.1663412260f,  0.6928610705f},
        {-0.1738036093f,  0.0885573622f},
        { 0.0775554307f,  0.0908057424f},
        {-0.0819218257f,  0.1127557199f},
        {-0.0224823612f, -0.0093124989f},
        {-0.0063354525f,  0.0400004728f},
        {-0.0183478919f,  0.0014440104f},
        { 0.0047864048f,  0.0147310392f},
        {-0.0086714987f,  0.0053139012f},
        { 0.0079914771f,  0.0079914771f},
        {-0.0064132339f,  0.0104654466f},
        { 0.0025866848f,  0.0008404648f},
        {-0.0006334928f,  0.0080492893f},
    },
    {
        {-0.0006321484f, -0.0080322076f},   /* Filter 176 */
        {-0.0096060929f,  0.0031212088f},
        {-0.0070040105f, -0.0114295063f},
        {-0.0044618853f,  0.0044618853f},
        {-0.0149365621f, -0.0091531370f},
        {-0.0034118962f,  0.0105007368f},
        {-0.0413447527f, -0.0032539026f},
        { 0.0009945051f,  0.0062790583f},
        {-0.1135901236f,  0.0470505697f},
        {-0.0832549323f, -0.1145905836f},
        {-0.0779124251f,  0.0912237291f},
        {-0.5544294121f, -0.2824958955f},
        { 0.2465230060f, -1.0268422201f},
        { 1.0956397057f,  0.0000000000f},
        { 0.1657151464f,  0.6902532609f},
        {-0.1716744647f,  0.0874725088f},
        { 0.0780893013f,  0.0914308246f},
        {-0.0816636022f,  0.1124003057f},
        {-0.0219475490f, -0.0090909725f},
        {-0.0063470530f,  0.0400737154f},
        {-0.0181270820f,  0.0014266323f},
        { 0.0048122982f,  0.0148107310f},
        {-0.0085775182f,  0.0052563099f},
        { 0.0080452532f,  0.0080452532f},
        {-0.0063828750f,  0.0104159054f},
        { 0.0026540877f,  0.0008623654f},
        {-0.0006321484f,  0.0080322076f},
    },
    {
        {-0.0006306728f, -0.0080134576f},   /* Filter 177 */
        {-0.0096742861f,  0.0031433661f},
        {-0.0069762467f, -0.0113841999f},
        {-0.0045477902f,  0.0045477902f},
        {-0.0148999977f, -0.0091307304f},
        {-0.0034806840f,  0.0107124438f},
        {-0.0413511108f, -0.0032544030f},
        { 0.0010749057f,  0.0067866875f},
        {-0.1140902398f,  0.0472577246f},
        {-0.0829306333f, -0.1141442244f},
        {-0.0793254848f,  0.0928782095f},
        {-0.5569001084f, -0.2837547781f},
        { 0.2468507186f, -1.0282072413f},
        { 1.0945705175f,  0.0000000000f},
        { 0.1650856437f,  0.6876311937f},
        {-0.1695674396f,  0.0863989259f},
        { 0.0786007540f,  0.0920296586f},
        {-0.0813967690f,  0.1120330412f},
        {-0.0214193776f, -0.0088721967f},
        {-0.0063570037f,  0.0401365416f},
        {-0.0179054141f,  0.0014091867f},
        { 0.0048366169f,  0.0148855761f},
        {-0.0084819828f,  0.0051977658f},
        { 0.0080970991f,  0.0080970991f},
        {-0.0063515039f,  0.0103647124f},
        { 0.0027202235f,  0.0008838542f},
        {-0.0006306728f,  0.0080134576f},
    },
    {
        {-0.0006291970f, -0.0079947065f},   /* Filter 178 */
        {-0.0097424801f,  0.0031655237f},
        {-0.0069484829f, -0.0113388935f},
        {-0.0046336947f,  0.0046336947f},
        {-0.0148634318f, -0.0091083227f},
        {-0.0035494718f,  0.0109241508f},
        {-0.0413574651f, -0.0032549031f},
        { 0.0011553063f,  0.0072943168f},
        {-0.1145903561f,  0.0474648796f},
        {-0.0826063431f, -0.1136978772f},
        {-0.0807385445f,  0.0945326898f},
        {-0.5593708578f, -0.2850136878f},
        { 0.2471784312f, -1.0295722626f},
        { 1.0935014486f,  0.0000000000f},
        { 0.1644561550f,  0.6850091845f},
        {-0.1674604144f,  0.0853253430f},
        { 0.0791122066f,  0.0926284927f},
        {-0.0811299269f,  0.1116657647f},
        {-0.0208912044f, -0.0086534202f},
        {-0.0063669544f,  0.0401993678f},
        {-0.0176837445f,  0.0013917409f},
        { 0.0048609355f,  0.0149604211f},
        {-0.0083864467f,  0.0051392212f},
        { 0.0081489450f,  0.0081489450f},
        {-0.0063201333f,  0.0103135203f},
        { 0.0027863591f,  0.0009053429f},
        {-0.0006291970f,  0.0079947065f},
    },
    {
        {-0.0006277214f, -0.0079759565f},   /* Filter 179 */
        {-0.0098106733f,  0.0031876810f},
        {-0.0069207191f, -0.0112935871f},
        {-0.0047195995f,  0.0047195995f},
        {-0.0148268675f, -0.0090859161f},
        {-0.0036182596f,  0.0111358578f},
        {-0.0413638231f, -0.0032554035f},
        { 0.0012357069f,  0.0078019464f},
        {-0.1150904723f,  0.0476720345f},
        {-0.0822820441f, -0.1132515179f},
        {-0.0821516043f,  0.0961871702f},
        {-0.5618415541f, -0.2862725705f},
        { 0.2475061438f, -1.0309372838f},
        { 1.0924322605f,  0.0000000000f},
        { 0.1638266524f,  0.6823871173f},
        {-0.1653533760f,  0.0842517533f},
        { 0.0796236592f,  0.0932273268f},
        {-0.0808630937f,  0.1112985002f},
        {-0.0203630313f, -0.0084346437f},
        {-0.0063769051f,  0.0402621940f},
        {-0.0174620766f,  0.0013742952f},
        { 0.0048852541f,  0.0150352662f},
        {-0.0082909114f,  0.0050806770f},
        { 0.0082007909f,  0.0082007909f},
        {-0.0062887623f,  0.0102623273f},
        { 0.0028524949f,  0.0009268318f},
        {-0.0006277214f,  0.0079759565f},
    },
    {
        {-0.0006262457f, -0.0079572064f},   /* Filter 180 */
        {-0.0098788673f,  0.0032098386f},
        {-0.0068929552f, -0.0112482807f},
        {-0.0048055043f,  0.0048055043f},
        {-0.0147903015f, -0.0090635084f},
        {-0.0036870476f,  0.0113475657f},
        {-0.0413701812f, -0.0032559039f},
        { 0.0013161075f,  0.0083095757f},
        {-0.1155905886f,  0.0478791895f},
        {-0.0819577539f, -0.1128051707f},
        {-0.0835646688f,  0.0978416562f},
        {-0.5643122504f, -0.2875314531f},
        { 0.2478338564f, -1.0323023051f},
        { 1.0913630724f,  0.0000000000f},
        { 0.1631971497f,  0.6797650501f},
        {-0.1632463509f,  0.0831781703f},
        { 0.0801351118f,  0.0938261609f},
        {-0.0805962516f,  0.1109312237f},
        {-0.0198348598f, -0.0082158679f},
        {-0.0063868557f,  0.0403250202f},
        {-0.0172404088f,  0.0013568496f},
        { 0.0049095728f,  0.0151101113f},
        {-0.0081953752f,  0.0050221324f},
        { 0.0082526368f,  0.0082526368f},
        {-0.0062573917f,  0.0102111352f},
        { 0.0029186307f,  0.0009483206f},
        {-0.0006262457f,  0.0079572064f},
    },
    {
        {-0.0006246413f, -0.0079368204f},   /* Filter 181 */
        {-0.0099456752f,  0.0032315458f},
        {-0.0068636353f, -0.0112004348f},
        {-0.0048907081f,  0.0048907081f},
        {-0.0147493888f, -0.0090384371f},
        {-0.0037560104f,  0.0115598113f},
        {-0.0413670207f, -0.0032556551f},
        { 0.0013979127f,  0.0088260732f},
        {-0.1160806757f,  0.0480821902f},
        {-0.0816140807f, -0.1123321451f},
        {-0.0849962561f,  0.0995178296f},
        {-0.5667757240f, -0.2887866556f},
        { 0.2481507436f, -1.0336222352f},
        { 1.0902447701f,  0.0000000000f},
        { 0.1625644607f,  0.6771297106f},
        {-0.1611619499f,  0.0821161150f},
        { 0.0806242674f,  0.0943988885f},
        {-0.0803211239f,  0.1105525428f},
        {-0.0193135873f, -0.0079999498f},
        {-0.0063951759f,  0.0403775514f},
        {-0.0170180911f,  0.0013393528f},
        { 0.0049323120f,  0.0151800954f},
        {-0.0080983851f,  0.0049626968f},
        { 0.0083025209f,  0.0083025209f},
        {-0.0062250430f,  0.0101583469f},
        { 0.0029834536f,  0.0009693828f},
        {-0.0006246413f,  0.0079368204f},
    },
    {
        {-0.0006230369f, -0.0079164344f},   /* Filter 182 */
        {-0.0100124830f,  0.0032532529f},
        {-0.0068343153f, -0.0111525889f},
        {-0.0049759119f,  0.0049759119f},
        {-0.0147084760f, -0.0090133657f},
        {-0.0038249731f,  0.0117720568f},
        {-0.0413638603f, -0.0032554064f},
        { 0.0014797178f,  0.0093425708f},
        {-0.1165707628f,  0.0482851909f},
        {-0.0812704075f, -0.1118591195f},
        {-0.0864278435f,  0.1011940030f},
        {-0.5692392507f, -0.2900418852f},
        { 0.2484676308f, -1.0349421653f},
        { 1.0891264677f,  0.0000000000f},
        { 0.1619317577f,  0.6744943131f},
        {-0.1590775355f,  0.0810540528f},
        { 0.0811134182f,  0.0949716105f},
        {-0.0800459962f,  0.1101738620f},
        {-0.0187923166f, -0.0077840324f},
        {-0.0064034960f,  0.0404300825f},
        {-0.0167957752f,  0.0013218562f},
        { 0.0049550512f,  0.0152500795f},
        {-0.0080013950f,  0.0049032612f},
        { 0.0083524050f,  0.0083524049f},
        {-0.0061926948f,  0.0101055594f},
        { 0.0030482765f,  0.0009904451f},
        {-0.0006230369f,  0.0079164344f},
    },
    {
        {-0.0006214324f, -0.0078960474f},   /* Filter 183 */
        {-0.0100792909f,  0.0032749601f},
        {-0.0068049953f, -0.0111047430f},
        {-0.0050611154f,  0.0050611154f},
        {-0.0146675617f, -0.0089882934f},
        {-0.0038939359f,  0.0119843024f},
        {-0.0413606998f, -0.0032551577f},
        { 0.0015615230f,  0.0098590683f},
        {-0.1170608498f,  0.0484881916f},
        {-0.0809267343f, -0.1113860940f},
        {-0.0878594308f,  0.1028701764f},
        {-0.5717027243f, -0.2912970876f},
        { 0.2487845180f, -1.0362620954f},
        { 1.0880081654f,  0.0000000000f},
        { 0.1612990687f,  0.6718589736f},
        {-0.1569931345f,  0.0799919974f},
        { 0.0816025689f,  0.0955443324f},
        {-0.0797708684f,  0.1097951811f},
        {-0.0182710440f, -0.0075681142f},
        {-0.0064118161f,  0.0404826137f},
        {-0.0165734574f,  0.0013043594f},
        { 0.0049777904f,  0.0153200636f},
        {-0.0079044049f,  0.0048438256f},
        { 0.0084022884f,  0.0084022884f},
        {-0.0061603461f,  0.0100527712f},
        { 0.0031130992f,  0.0010115072f},
        {-0.0006214324f,  0.0078960474f},
    },
    {
        {-0.0006198280f, -0.0078756614f},   /* Filter 184 */
        {-0.0101460987f,  0.0032966673f},
        {-0.0067756753f, -0.0110568971f},
        {-0.0051463192f,  0.0051463192f},
        {-0.0146266490f, -0.0089632220f},
        {-0.0039628986f,  0.0121965479f},
        {-0.0413575394f, -0.0032549089f},
        { 0.0016433282f,  0.0103755659f},
        {-0.1175509369f,  0.0486911923f},
        {-0.0805830611f, -0.1109130684f},
        {-0.0892910279f,  0.1045463612f},
        {-0.5741661979f, -0.2925522901f},
        { 0.2491014052f, -1.0375820255f},
        { 1.0868898630f,  0.0000000000f},
        { 0.1606663657f,  0.6692235761f},
        {-0.1549087334f,  0.0789299420f},
        { 0.0820917197f,  0.0961170544f},
        {-0.0794957407f,  0.1094165002f},
        {-0.0177497715f, -0.0073521961f},
        {-0.0064201362f,  0.0405351449f},
        {-0.0163511397f,  0.0012868626f},
        { 0.0050005296f,  0.0153900477f},
        {-0.0078074149f,  0.0047843900f},
        { 0.0084521725f,  0.0084521725f},
        {-0.0061279979f,  0.0099999837f},
        { 0.0031779221f,  0.0010325695f},
        {-0.0006198280f,  0.0078756614f},
    },
    {
        {-0.0006180975f, -0.0078536738f},   /* Filter 185 */
        {-0.0102114540f,  0.0033179025f},
        {-0.0067448127f, -0.0110065340f},
        {-0.0052307377f,  0.0052307377f},
        {-0.0145813767f, -0.0089354791f},
        {-0.0040319757f,  0.0124091451f},
        {-0.0413447044f, -0.0032538988f},
        { 0.0017265024f,  0.0109007073f},
        {-0.1180305061f,  0.0488898364f},
        {-0.0802198648f, -0.1104131716f},
        {-0.0907408283f,  0.1062438594f},
        {-0.5766215991f, -0.2938033795f},
        { 0.2494073556f, -1.0388564008f},
        { 1.0857228041f,  0.0000000000f},
        { 0.1600306851f,  0.6665757757f},
        {-0.1528474477f,  0.0778796645f},
        { 0.0825586992f,  0.0966638172f},
        {-0.0792126425f,  0.1090268491f},
        {-0.0172356561f, -0.0071392425f},
        {-0.0064268467f,  0.0405775134f},
        {-0.0161283837f,  0.0012693313f},
        { 0.0050216871f,  0.0154551638f},
        {-0.0077090716f,  0.0047241252f},
        { 0.0085000658f,  0.0085000658f},
        {-0.0060947066f,  0.0099456573f},
        { 0.0032413878f,  0.0010531907f},
        {-0.0006180975f,  0.0078536738f},
    },
    {
        {-0.0006163670f, -0.0078316853f},   /* Filter 186 */
        {-0.0102768083f,  0.0033391374f},
        {-0.0067139506f, -0.0109561717f},
        {-0.0053151562f,  0.0053151562f},
        {-0.0145361044f, -0.0089077363f},
        {-0.0041010527f,  0.0126217423f},
        {-0.0413318695f, -0.0032528887f},
        { 0.0018096765f,  0.0114258479f},
        {-0.1185100615f,  0.0490884747f},
        {-0.0798566597f, -0.1099132627f},
        {-0.0921906384f,  0.1079413690f},
        {-0.5790770002f, -0.2950544689f},
        { 0.2497133061f, -1.0401307762f},
        { 1.0845557451f,  0.0000000000f},
        { 0.1593950044f,  0.6639279752f},
        {-0.1507861619f,  0.0768293869f},
        { 0.0830256788f,  0.0972105799f},
        {-0.0789295444f,  0.1086371979f},
        {-0.0167215389f, -0.0069262882f},
        {-0.0064335573f,  0.0406198820f},
        {-0.0159056278f,  0.0012518001f},
        { 0.0050428441f,  0.0155202782f},
        {-0.0076107284f,  0.0046638604f},
        { 0.0085479591f,  0.0085479591f},
        {-0.0060614159f,  0.0098913317f},
        { 0.0033048536f,  0.0010738120f},
        {-0.0006163670f,  0.0078316853f},
    },
    {
        {-0.0006146365f, -0.0078096977f},   /* Filter 187 */
        {-0.0103421636f,  0.0033603726f},
        {-0.0066830881f, -0.0109058085f},
        {-0.0053995750f,  0.0053995750f},
        {-0.0144908338f, -0.0088799944f},
        {-0.0041701300f,  0.0128343404f},
        {-0.0413190346f, -0.0032518786f},
        { 0.0018928506f,  0.0119509884f},
        {-0.1189896170f,  0.0492871131f},
        {-0.0794934547f, -0.1094133538f},
        {-0.0936404389f,  0.1096388672f},
        {-0.5815324545f, -0.2963055853f},
        { 0.2500192287f, -1.0414050355f},
        { 1.0833886862f,  0.0000000000f},
        { 0.1587593377f,  0.6612802328f},
        {-0.1487248762f,  0.0757791094f},
        { 0.0834926583f,  0.0977573427f},
        {-0.0786464462f,  0.1082475467f},
        {-0.0162074218f, -0.0067133339f},
        {-0.0064402678f,  0.0406622506f},
        {-0.0156828718f,  0.0012342688f},
        { 0.0050640016f,  0.0155853942f},
        {-0.0075123852f,  0.0046035956f},
        { 0.0085958524f,  0.0085958524f},
        {-0.0060281246f,  0.0098370053f},
        { 0.0033683193f,  0.0010944333f},
        {-0.0006146365f,  0.0078096977f},
    },
    {
        {-0.0006129060f, -0.0077877092f},   /* Filter 188 */
        {-0.0104075179f,  0.0033816076f},
        {-0.0066522260f, -0.0108554462f},
        {-0.0054839935f,  0.0054839935f},
        {-0.0144455615f, -0.0088522515f},
        {-0.0042392070f,  0.0130469375f},
        {-0.0413061997f, -0.0032508684f},
        { 0.0019760247f,  0.0124761289f},
        {-0.1194691862f,  0.0494857572f},
        {-0.0791302584f, -0.1089134570f},
        {-0.0950902394f,  0.1113363655f},
        {-0.5839878557f, -0.2975566747f},
        { 0.2503251791f, -1.0426794109f},
        { 1.0822216272f,  0.0000000000f},
        { 0.1581236571f,  0.6586324323f},
        {-0.1466635904f,  0.0747288318f},
        { 0.0839596378f,  0.0983041055f},
        {-0.0783633481f,  0.1078578956f},
        {-0.0156933046f, -0.0065003796f},
        {-0.0064469783f,  0.0407046192f},
        {-0.0154601149f,  0.0012167374f},
        { 0.0050851585f,  0.0156505086f},
        {-0.0074140420f,  0.0045433308f},
        { 0.0086437457f,  0.0086437457f},
        {-0.0059948338f,  0.0097826797f},
        { 0.0034317848f,  0.0011150545f},
        {-0.0006129060f,  0.0077877092f},
    },
    {
        {-0.0006111755f, -0.0077657207f},   /* Filter 189 */
        {-0.0104728723f,  0.0034028425f},
        {-0.0066213634f, -0.0108050831f},
        {-0.0055684120f,  0.0055684120f},
        {-0.0144002892f, -0.0088245086f},
        {-0.0043082843f,  0.0132595356f},
        {-0.0412933611f, -0.0032498580f},
        { 0.0020591988f,  0.0130012694f},
        {-0.1199487416f,  0.0496843955f},
        {-0.0787670533f, -0.1084135481f},
        {-0.0965400495f,  0.1130338750f},
        {-0.5864432568f, -0.2988077641f},
        { 0.2506311296f, -1.0439537862f},
        { 1.0810545683f,  0.0000000000f},
        { 0.1574879764f,  0.6559846319f},
        {-0.1446023047f,  0.0736785543f},
        { 0.0844266077f,  0.0988508570f},
        {-0.0780802499f,  0.1074682444f},
        {-0.0151791874f, -0.0062874253f},
        {-0.0064536888f,  0.0407469878f},
        {-0.0152373580f,  0.0011992061f},
        { 0.0051063160f,  0.0157156247f},
        {-0.0073156988f,  0.0044830660f},
        { 0.0086916390f,  0.0086916390f},
        {-0.0059615426f,  0.0097283533f},
        { 0.0034952505f,  0.0011356757f},
        {-0.0006111755f,  0.0077657207f},
    },
    {
        {-0.0006094450f, -0.0077437326f},   /* Filter 190 */
        {-0.0105382275f,  0.0034240777f},
        {-0.0065905013f, -0.0107547207f},
        {-0.0056528308f,  0.0056528308f},
        {-0.0143550170f, -0.0087967657f},
        {-0.0043773613f,  0.0134721328f},
        {-0.0412805262f, -0.0032488479f},
        { 0.0021423730f,  0.0135264109f},
        {-0.1204282970f,  0.0498830339f},
        {-0.0784038482f, -0.1079136392f},
        {-0.0979898499f,  0.1147313733f},
        {-0.5888986580f, -0.3000588535f},
        { 0.2509370800f, -1.0452281615f},
        { 1.0798875093f,  0.0000000000f},
        { 0.1568522958f,  0.6533368315f},
        {-0.1425410189f,  0.0726282767f},
        { 0.0848935872f,  0.0993976198f},
        {-0.0777971430f,  0.1070785812f},
        {-0.0146650702f, -0.0060744710f},
        {-0.0064603994f,  0.0407893564f},
        {-0.0150146011f,  0.0011816747f},
        { 0.0051274735f,  0.0157807408f},
        {-0.0072173556f,  0.0044228012f},
        { 0.0087395323f,  0.0087395323f},
        {-0.0059282513f,  0.0096740269f},
        { 0.0035587163f,  0.0011562970f},
        {-0.0006094450f,  0.0077437326f},
    },
    {
        {-0.0006077145f, -0.0077217446f},   /* Filter 191 */
        {-0.0106035819f,  0.0034453126f},
        {-0.0065596388f, -0.0107043576f},
        {-0.0057372490f,  0.0057372490f},
        {-0.0143097447f, -0.0087690228f},
        {-0.0044464386f,  0.0136847309f},
        {-0.0412676912f, -0.0032478377f},
        { 0.0022255471f,  0.0140515514f},
        {-0.1209078662f,  0.0500816779f},
        {-0.0780406519f, -0.1074137424f},
        {-0.0994396601f,  0.1164288828f},
        {-0.5913541123f, -0.3013099699f},
        { 0.2512430304f, -1.0465025368f},
        { 1.0787204504f,  0.0000000000f},
        { 0.1562166151f,  0.6506890310f},
        {-0.1404797332f,  0.0715779992f},
        { 0.0853605668f,  0.0999443825f},
        {-0.0775140449f,  0.1066889300f},
        {-0.0141509539f, -0.0058615170f},
        {-0.0064671099f,  0.0408317250f},
        {-0.0147918451f,  0.0011641435f},
        { 0.0051486304f,  0.0158458551f},
        {-0.0071190124f,  0.0043625364f},
        { 0.0087874256f,  0.0087874256f},
        {-0.0058949605f,  0.0096197013f},
        { 0.0036221820f,  0.0011769183f},
        {-0.0006077145f,  0.0077217446f},
    },
};

/* The following table maps the 8 soft-decisions associated with every possible point in the
   constellation space. If you look at the constellations carefully, all 4 can be accurately
   mapped at 0.5 unit resolution. */
static const uint8_t constel_maps[4][36][36][8] =
{
    {   /* 14,400bps map */
        {
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x66, 0x7f},
            {0x00, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x66, 0x7f},
            {0x08, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x76, 0x7f},
            {0x08, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x76, 0x7f},
            {0x08, 0x41, 0x7a, 0x73, 0x4c, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x7a, 0x73, 0x4c, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x73, 0x44, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x73, 0x44, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x76, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x76, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f}
        },
        {
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x66, 0x7f},
            {0x00, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x66, 0x7f},
            {0x08, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x76, 0x7f},
            {0x08, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x76, 0x7f},
            {0x08, 0x41, 0x7a, 0x73, 0x4c, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x7a, 0x73, 0x4c, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x73, 0x44, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x73, 0x44, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x76, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x76, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f}
        },
        {
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x66, 0x7f},
            {0x00, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x66, 0x7f},
            {0x08, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x76, 0x7f},
            {0x08, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x76, 0x7f},
            {0x08, 0x41, 0x7a, 0x73, 0x4c, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x7a, 0x73, 0x4c, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x73, 0x44, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x73, 0x44, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x76, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x76, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f}
        },
        {
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x63, 0x4c, 0x05, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x66, 0x7f},
            {0x00, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x66, 0x7f},
            {0x08, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x76, 0x7f},
            {0x08, 0x49, 0x7a, 0x73, 0x4c, 0x05, 0x76, 0x7f},
            {0x08, 0x41, 0x7a, 0x73, 0x4c, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x7a, 0x73, 0x4c, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x73, 0x44, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x73, 0x44, 0x0d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x76, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x76, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x0d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f}
        },
        {
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x15, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x4c, 0x15, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x63, 0x4c, 0x15, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x63, 0x4c, 0x15, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x73, 0x4c, 0x15, 0x66, 0x7f},
            {0x00, 0x49, 0x7a, 0x73, 0x4c, 0x15, 0x66, 0x7f},
            {0x08, 0x49, 0x7a, 0x73, 0x4c, 0x15, 0x76, 0x7f},
            {0x08, 0x49, 0x7a, 0x73, 0x4c, 0x15, 0x76, 0x7f},
            {0x08, 0x41, 0x7a, 0x73, 0x4c, 0x1d, 0x76, 0x7f},
            {0x08, 0x41, 0x7a, 0x73, 0x4c, 0x1d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x73, 0x44, 0x1d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x73, 0x44, 0x1d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x1d, 0x76, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x1d, 0x76, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x1d, 0x56, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x1d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f}
        },
        {
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x15, 0x66, 0x5f},
            {0x00, 0x49, 0x5a, 0x63, 0x6c, 0x15, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x63, 0x4c, 0x15, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x63, 0x4c, 0x15, 0x66, 0x5f},
            {0x00, 0x49, 0x7a, 0x73, 0x4c, 0x15, 0x66, 0x7f},
            {0x00, 0x49, 0x7a, 0x73, 0x4c, 0x15, 0x66, 0x7f},
            {0x08, 0x49, 0x7a, 0x73, 0x4c, 0x15, 0x76, 0x7f},
            {0x08, 0x49, 0x7a, 0x73, 0x4c, 0x15, 0x76, 0x7f},
            {0x08, 0x41, 0x7a, 0x73, 0x4c, 0x1d, 0x76, 0x7f},
            {0x08, 0x41, 0x7a, 0x73, 0x4c, 0x1d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x73, 0x44, 0x1d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x73, 0x44, 0x1d, 0x76, 0x7f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x1d, 0x76, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x1d, 0x76, 0x6f},
            {0x08, 0x41, 0x6a, 0x53, 0x44, 0x1d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x1d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x44, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f}
        },
        {
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x10, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x10, 0x49, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x10, 0x49, 0x5a, 0x63, 0x6c, 0x15, 0x66, 0x5f},
            {0x10, 0x49, 0x5a, 0x63, 0x6c, 0x15, 0x66, 0x5f},
            {0x10, 0x49, 0x7a, 0x63, 0x2c, 0x15, 0x66, 0x5f},
            {0x10, 0x49, 0x7a, 0x63, 0x2c, 0x15, 0x66, 0x5f},
            {0x10, 0x49, 0x7a, 0x73, 0x2c, 0x15, 0x66, 0x7f},
            {0x10, 0x49, 0x7a, 0x73, 0x2c, 0x15, 0x66, 0x7f},
            {0x18, 0x49, 0x7a, 0x73, 0x2c, 0x15, 0x76, 0x7f},
            {0x18, 0x49, 0x7a, 0x73, 0x2c, 0x15, 0x76, 0x7f},
            {0x18, 0x41, 0x7a, 0x73, 0x2c, 0x1d, 0x76, 0x7f},
            {0x18, 0x41, 0x7a, 0x73, 0x2c, 0x1d, 0x76, 0x7f},
            {0x18, 0x41, 0x6a, 0x73, 0x24, 0x1d, 0x76, 0x7f},
            {0x18, 0x41, 0x6a, 0x73, 0x24, 0x1d, 0x76, 0x7f},
            {0x18, 0x41, 0x6a, 0x53, 0x24, 0x1d, 0x76, 0x6f},
            {0x18, 0x41, 0x6a, 0x53, 0x24, 0x1d, 0x76, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x24, 0x1d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x24, 0x1d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x24, 0x5d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x24, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f}
        },
        {
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x10, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x10, 0x69, 0x5a, 0x63, 0x6c, 0x55, 0x66, 0x5f},
            {0x10, 0x49, 0x5a, 0x63, 0x6c, 0x15, 0x66, 0x5f},
            {0x10, 0x49, 0x5a, 0x63, 0x6c, 0x15, 0x66, 0x5f},
            {0x10, 0x49, 0x7a, 0x63, 0x2c, 0x15, 0x66, 0x5f},
            {0x10, 0x49, 0x7a, 0x63, 0x2c, 0x15, 0x66, 0x5f},
            {0x10, 0x49, 0x7a, 0x73, 0x2c, 0x15, 0x66, 0x7f},
            {0x10, 0x49, 0x7a, 0x73, 0x2c, 0x15, 0x66, 0x7f},
            {0x18, 0x49, 0x7a, 0x73, 0x2c, 0x15, 0x76, 0x7f},
            {0x18, 0x49, 0x7a, 0x73, 0x2c, 0x15, 0x76, 0x7f},
            {0x18, 0x41, 0x7a, 0x73, 0x2c, 0x1d, 0x76, 0x7f},
            {0x18, 0x41, 0x7a, 0x73, 0x2c, 0x1d, 0x76, 0x7f},
            {0x18, 0x41, 0x6a, 0x73, 0x24, 0x1d, 0x76, 0x7f},
            {0x18, 0x41, 0x6a, 0x73, 0x24, 0x1d, 0x76, 0x7f},
            {0x18, 0x41, 0x6a, 0x53, 0x24, 0x1d, 0x76, 0x6f},
            {0x18, 0x41, 0x6a, 0x53, 0x24, 0x1d, 0x76, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x24, 0x1d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x24, 0x1d, 0x56, 0x6f},
            {0x58, 0x41, 0x6a, 0x53, 0x24, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x24, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x53, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f}
        },
        {
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x23, 0x6c, 0x55, 0x66, 0x5f},
            {0x50, 0x69, 0x5a, 0x23, 0x6c, 0x55, 0x66, 0x5f},
            {0x10, 0x69, 0x5a, 0x23, 0x6c, 0x55, 0x66, 0x5f},
            {0x10, 0x69, 0x5a, 0x23, 0x6c, 0x55, 0x66, 0x5f},
            {0x10, 0x29, 0x5a, 0x23, 0x6c, 0x15, 0x66, 0x5f},
            {0x10, 0x29, 0x5a, 0x23, 0x6c, 0x15, 0x66, 0x5f},
            {0x10, 0x29, 0x7a, 0x23, 0x2c, 0x15, 0x66, 0x5f},
            {0x10, 0x29, 0x7a, 0x23, 0x2c, 0x15, 0x66, 0x5f},
            {0x10, 0x29, 0x7a, 0x33, 0x2c, 0x15, 0x66, 0x7f},
            {0x10, 0x29, 0x7a, 0x33, 0x2c, 0x15, 0x66, 0x7f},
            {0x18, 0x29, 0x7a, 0x33, 0x2c, 0x15, 0x76, 0x7f},
            {0x18, 0x29, 0x7a, 0x33, 0x2c, 0x15, 0x76, 0x7f},
            {0x18, 0x21, 0x7a, 0x33, 0x2c, 0x1d, 0x76, 0x7f},
            {0x18, 0x21, 0x7a, 0x33, 0x2c, 0x1d, 0x76, 0x7f},
            {0x18, 0x21, 0x6a, 0x33, 0x24, 0x1d, 0x76, 0x7f},
            {0x18, 0x21, 0x6a, 0x33, 0x24, 0x1d, 0x76, 0x7f},
            {0x18, 0x21, 0x6a, 0x13, 0x24, 0x1d, 0x76, 0x6f},
            {0x18, 0x21, 0x6a, 0x13, 0x24, 0x1d, 0x76, 0x6f},
            {0x58, 0x21, 0x6a, 0x13, 0x24, 0x1d, 0x56, 0x6f},
            {0x58, 0x21, 0x6a, 0x13, 0x24, 0x1d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x13, 0x24, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x13, 0x24, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x13, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x13, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f}
        },
        {
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x23, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x5a, 0x23, 0x6c, 0x55, 0x66, 0x5f},
            {0x10, 0x69, 0x5a, 0x23, 0x6c, 0x55, 0x66, 0x5f},
            {0x10, 0x69, 0x5a, 0x23, 0x6c, 0x55, 0x66, 0x5f},
            {0x10, 0x29, 0x5a, 0x23, 0x6c, 0x15, 0x66, 0x5f},
            {0x10, 0x29, 0x5a, 0x23, 0x6c, 0x15, 0x66, 0x5f},
            {0x10, 0x29, 0x7a, 0x23, 0x2c, 0x15, 0x66, 0x5f},
            {0x10, 0x29, 0x7a, 0x23, 0x2c, 0x15, 0x66, 0x5f},
            {0x10, 0x29, 0x7a, 0x33, 0x2c, 0x15, 0x66, 0x7f},
            {0x10, 0x29, 0x7a, 0x33, 0x2c, 0x15, 0x66, 0x7f},
            {0x18, 0x29, 0x7a, 0x33, 0x2c, 0x15, 0x76, 0x7f},
            {0x18, 0x29, 0x7a, 0x33, 0x2c, 0x15, 0x76, 0x7f},
            {0x18, 0x21, 0x7a, 0x33, 0x2c, 0x1d, 0x76, 0x7f},
            {0x18, 0x21, 0x7a, 0x33, 0x2c, 0x1d, 0x76, 0x7f},
            {0x18, 0x21, 0x6a, 0x33, 0x24, 0x1d, 0x76, 0x7f},
            {0x18, 0x21, 0x6a, 0x33, 0x24, 0x1d, 0x76, 0x7f},
            {0x18, 0x21, 0x6a, 0x13, 0x24, 0x1d, 0x76, 0x6f},
            {0x18, 0x21, 0x6a, 0x13, 0x24, 0x1d, 0x76, 0x6f},
            {0x58, 0x21, 0x6a, 0x13, 0x24, 0x1d, 0x56, 0x6f},
            {0x58, 0x21, 0x6a, 0x13, 0x24, 0x1d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x13, 0x24, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x13, 0x24, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x6a, 0x13, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x13, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x56, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f}
        },
        {
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x1a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x1a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x1a, 0x23, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x1a, 0x23, 0x6c, 0x55, 0x46, 0x5f},
            {0x10, 0x69, 0x1a, 0x23, 0x6c, 0x55, 0x26, 0x5f},
            {0x10, 0x69, 0x1a, 0x23, 0x6c, 0x55, 0x26, 0x5f},
            {0x10, 0x29, 0x1a, 0x23, 0x6c, 0x15, 0x26, 0x5f},
            {0x10, 0x29, 0x1a, 0x23, 0x6c, 0x15, 0x26, 0x5f},
            {0x10, 0x29, 0x3a, 0x23, 0x2c, 0x15, 0x26, 0x5f},
            {0x10, 0x29, 0x3a, 0x23, 0x2c, 0x15, 0x26, 0x5f},
            {0x10, 0x29, 0x3a, 0x33, 0x2c, 0x15, 0x26, 0x7f},
            {0x10, 0x29, 0x3a, 0x33, 0x2c, 0x15, 0x26, 0x7f},
            {0x18, 0x29, 0x3a, 0x33, 0x2c, 0x15, 0x36, 0x7f},
            {0x18, 0x29, 0x3a, 0x33, 0x2c, 0x15, 0x36, 0x7f},
            {0x18, 0x21, 0x3a, 0x33, 0x2c, 0x1d, 0x36, 0x7f},
            {0x18, 0x21, 0x3a, 0x33, 0x2c, 0x1d, 0x36, 0x7f},
            {0x18, 0x21, 0x2a, 0x33, 0x24, 0x1d, 0x36, 0x7f},
            {0x18, 0x21, 0x2a, 0x33, 0x24, 0x1d, 0x36, 0x7f},
            {0x18, 0x21, 0x2a, 0x13, 0x24, 0x1d, 0x36, 0x6f},
            {0x18, 0x21, 0x2a, 0x13, 0x24, 0x1d, 0x36, 0x6f},
            {0x58, 0x21, 0x2a, 0x13, 0x24, 0x1d, 0x16, 0x6f},
            {0x58, 0x21, 0x2a, 0x13, 0x24, 0x1d, 0x16, 0x6f},
            {0x58, 0x61, 0x2a, 0x13, 0x24, 0x5d, 0x16, 0x6f},
            {0x58, 0x61, 0x2a, 0x13, 0x24, 0x5d, 0x16, 0x6f},
            {0x58, 0x61, 0x4a, 0x13, 0x64, 0x5d, 0x16, 0x6f},
            {0x58, 0x61, 0x4a, 0x13, 0x64, 0x5d, 0x16, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x16, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x16, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f}
        },
        {
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x1a, 0x43, 0x6c, 0x55, 0x46, 0x0f},
            {0x50, 0x69, 0x1a, 0x43, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x1a, 0x23, 0x6c, 0x55, 0x46, 0x5f},
            {0x50, 0x69, 0x1a, 0x23, 0x6c, 0x55, 0x46, 0x5f},
            {0x10, 0x69, 0x1a, 0x23, 0x6c, 0x55, 0x26, 0x5f},
            {0x10, 0x69, 0x1a, 0x23, 0x6c, 0x55, 0x26, 0x5f},
            {0x10, 0x29, 0x1a, 0x23, 0x6c, 0x15, 0x26, 0x5f},
            {0x10, 0x29, 0x1a, 0x23, 0x6c, 0x15, 0x26, 0x5f},
            {0x10, 0x29, 0x3a, 0x23, 0x2c, 0x15, 0x26, 0x5f},
            {0x10, 0x29, 0x3a, 0x23, 0x2c, 0x15, 0x26, 0x5f},
            {0x10, 0x29, 0x3a, 0x33, 0x2c, 0x15, 0x26, 0x7f},
            {0x10, 0x29, 0x3a, 0x33, 0x2c, 0x15, 0x26, 0x7f},
            {0x18, 0x29, 0x3a, 0x33, 0x2c, 0x15, 0x36, 0x7f},
            {0x18, 0x29, 0x3a, 0x33, 0x2c, 0x15, 0x36, 0x7f},
            {0x18, 0x21, 0x3a, 0x33, 0x2c, 0x1d, 0x36, 0x7f},
            {0x18, 0x21, 0x3a, 0x33, 0x2c, 0x1d, 0x36, 0x7f},
            {0x18, 0x21, 0x2a, 0x33, 0x24, 0x1d, 0x36, 0x7f},
            {0x18, 0x21, 0x2a, 0x33, 0x24, 0x1d, 0x36, 0x7f},
            {0x18, 0x21, 0x2a, 0x13, 0x24, 0x1d, 0x36, 0x6f},
            {0x18, 0x21, 0x2a, 0x13, 0x24, 0x1d, 0x36, 0x6f},
            {0x58, 0x21, 0x2a, 0x13, 0x24, 0x1d, 0x16, 0x6f},
            {0x58, 0x21, 0x2a, 0x13, 0x24, 0x1d, 0x16, 0x6f},
            {0x58, 0x61, 0x2a, 0x13, 0x24, 0x5d, 0x16, 0x6f},
            {0x58, 0x61, 0x2a, 0x13, 0x24, 0x5d, 0x16, 0x6f},
            {0x58, 0x61, 0x4a, 0x13, 0x64, 0x5d, 0x16, 0x6f},
            {0x58, 0x61, 0x4a, 0x13, 0x64, 0x5d, 0x16, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x16, 0x6f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x16, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x5d, 0x06, 0x4f}
        },
        {
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x75, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x75, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x75, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x75, 0x46, 0x0f},
            {0x50, 0x69, 0x1a, 0x43, 0x6c, 0x75, 0x46, 0x0f},
            {0x50, 0x69, 0x1a, 0x43, 0x6c, 0x75, 0x46, 0x0f},
            {0x50, 0x69, 0x1a, 0x23, 0x6c, 0x75, 0x46, 0x1f},
            {0x50, 0x69, 0x1a, 0x23, 0x6c, 0x75, 0x46, 0x1f},
            {0x10, 0x69, 0x1a, 0x23, 0x6c, 0x75, 0x26, 0x1f},
            {0x10, 0x69, 0x1a, 0x23, 0x6c, 0x75, 0x26, 0x1f},
            {0x10, 0x29, 0x1a, 0x23, 0x6c, 0x35, 0x26, 0x1f},
            {0x10, 0x29, 0x1a, 0x23, 0x6c, 0x35, 0x26, 0x1f},
            {0x10, 0x29, 0x3a, 0x23, 0x2c, 0x35, 0x26, 0x1f},
            {0x10, 0x29, 0x3a, 0x23, 0x2c, 0x35, 0x26, 0x1f},
            {0x10, 0x29, 0x3a, 0x33, 0x2c, 0x35, 0x26, 0x3f},
            {0x10, 0x29, 0x3a, 0x33, 0x2c, 0x35, 0x26, 0x3f},
            {0x18, 0x29, 0x3a, 0x33, 0x2c, 0x35, 0x36, 0x3f},
            {0x18, 0x29, 0x3a, 0x33, 0x2c, 0x35, 0x36, 0x3f},
            {0x18, 0x21, 0x3a, 0x33, 0x2c, 0x3d, 0x36, 0x3f},
            {0x18, 0x21, 0x3a, 0x33, 0x2c, 0x3d, 0x36, 0x3f},
            {0x18, 0x21, 0x2a, 0x33, 0x24, 0x3d, 0x36, 0x3f},
            {0x18, 0x21, 0x2a, 0x33, 0x24, 0x3d, 0x36, 0x3f},
            {0x18, 0x21, 0x2a, 0x13, 0x24, 0x3d, 0x36, 0x2f},
            {0x18, 0x21, 0x2a, 0x13, 0x24, 0x3d, 0x36, 0x2f},
            {0x58, 0x21, 0x2a, 0x13, 0x24, 0x3d, 0x16, 0x2f},
            {0x58, 0x21, 0x2a, 0x13, 0x24, 0x3d, 0x16, 0x2f},
            {0x58, 0x61, 0x2a, 0x13, 0x24, 0x7d, 0x16, 0x2f},
            {0x58, 0x61, 0x2a, 0x13, 0x24, 0x7d, 0x16, 0x2f},
            {0x58, 0x61, 0x4a, 0x13, 0x64, 0x7d, 0x16, 0x2f},
            {0x58, 0x61, 0x4a, 0x13, 0x64, 0x7d, 0x16, 0x2f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x7d, 0x16, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x7d, 0x16, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x7d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x7d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x7d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x7d, 0x06, 0x4f}
        },
        {
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x75, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x75, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x75, 0x46, 0x0f},
            {0x50, 0x69, 0x0a, 0x43, 0x6c, 0x75, 0x46, 0x0f},
            {0x50, 0x69, 0x1a, 0x43, 0x6c, 0x75, 0x46, 0x0f},
            {0x50, 0x69, 0x1a, 0x43, 0x6c, 0x75, 0x46, 0x0f},
            {0x50, 0x69, 0x1a, 0x23, 0x6c, 0x75, 0x46, 0x1f},
            {0x50, 0x69, 0x1a, 0x23, 0x6c, 0x75, 0x46, 0x1f},
            {0x10, 0x69, 0x1a, 0x23, 0x6c, 0x75, 0x26, 0x1f},
            {0x10, 0x69, 0x1a, 0x23, 0x6c, 0x75, 0x26, 0x1f},
            {0x10, 0x29, 0x1a, 0x23, 0x6c, 0x35, 0x26, 0x1f},
            {0x10, 0x29, 0x1a, 0x23, 0x6c, 0x35, 0x26, 0x1f},
            {0x10, 0x29, 0x3a, 0x23, 0x2c, 0x35, 0x26, 0x1f},
            {0x10, 0x29, 0x3a, 0x23, 0x2c, 0x35, 0x26, 0x1f},
            {0x10, 0x29, 0x3a, 0x33, 0x2c, 0x35, 0x26, 0x3f},
            {0x10, 0x29, 0x3a, 0x33, 0x2c, 0x35, 0x26, 0x3f},
            {0x18, 0x29, 0x3a, 0x33, 0x2c, 0x35, 0x36, 0x3f},
            {0x18, 0x29, 0x3a, 0x33, 0x2c, 0x35, 0x36, 0x3f},
            {0x18, 0x21, 0x3a, 0x33, 0x2c, 0x3d, 0x36, 0x3f},
            {0x18, 0x21, 0x3a, 0x33, 0x2c, 0x3d, 0x36, 0x3f},
            {0x18, 0x21, 0x2a, 0x33, 0x24, 0x3d, 0x36, 0x3f},
            {0x18, 0x21, 0x2a, 0x33, 0x24, 0x3d, 0x36, 0x3f},
            {0x18, 0x21, 0x2a, 0x13, 0x24, 0x3d, 0x36, 0x2f},
            {0x18, 0x21, 0x2a, 0x13, 0x24, 0x3d, 0x36, 0x2f},
            {0x58, 0x21, 0x2a, 0x13, 0x24, 0x3d, 0x16, 0x2f},
            {0x58, 0x21, 0x2a, 0x13, 0x24, 0x3d, 0x16, 0x2f},
            {0x58, 0x61, 0x2a, 0x13, 0x24, 0x7d, 0x16, 0x2f},
            {0x58, 0x61, 0x2a, 0x13, 0x24, 0x7d, 0x16, 0x2f},
            {0x58, 0x61, 0x4a, 0x13, 0x64, 0x7d, 0x16, 0x2f},
            {0x58, 0x61, 0x4a, 0x13, 0x64, 0x7d, 0x16, 0x2f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x7d, 0x16, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x7d, 0x16, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x7d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x7d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x7d, 0x06, 0x4f},
            {0x58, 0x61, 0x4a, 0x03, 0x64, 0x7d, 0x06, 0x4f}
        },
        {
            {0x70, 0x69, 0x0a, 0x43, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x69, 0x0a, 0x43, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x69, 0x0a, 0x43, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x69, 0x0a, 0x43, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x69, 0x1a, 0x43, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x69, 0x1a, 0x43, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x69, 0x1a, 0x23, 0x7c, 0x75, 0x46, 0x1f},
            {0x70, 0x69, 0x1a, 0x23, 0x7c, 0x75, 0x46, 0x1f},
            {0x30, 0x69, 0x1a, 0x23, 0x7c, 0x75, 0x26, 0x1f},
            {0x30, 0x69, 0x1a, 0x23, 0x7c, 0x75, 0x26, 0x1f},
            {0x30, 0x29, 0x1a, 0x23, 0x7c, 0x35, 0x26, 0x1f},
            {0x30, 0x29, 0x1a, 0x23, 0x7c, 0x35, 0x26, 0x1f},
            {0x30, 0x29, 0x3a, 0x23, 0x3c, 0x35, 0x26, 0x1f},
            {0x30, 0x29, 0x3a, 0x23, 0x3c, 0x35, 0x26, 0x1f},
            {0x30, 0x29, 0x3a, 0x33, 0x3c, 0x35, 0x26, 0x3f},
            {0x30, 0x29, 0x3a, 0x33, 0x3c, 0x35, 0x26, 0x3f},
            {0x38, 0x29, 0x3a, 0x33, 0x3c, 0x35, 0x36, 0x3f},
            {0x38, 0x29, 0x3a, 0x33, 0x3c, 0x35, 0x36, 0x3f},
            {0x38, 0x21, 0x3a, 0x33, 0x3c, 0x3d, 0x36, 0x3f},
            {0x38, 0x21, 0x3a, 0x33, 0x3c, 0x3d, 0x36, 0x3f},
            {0x38, 0x21, 0x2a, 0x33, 0x34, 0x3d, 0x36, 0x3f},
            {0x38, 0x21, 0x2a, 0x33, 0x34, 0x3d, 0x36, 0x3f},
            {0x38, 0x21, 0x2a, 0x13, 0x34, 0x3d, 0x36, 0x2f},
            {0x38, 0x21, 0x2a, 0x13, 0x34, 0x3d, 0x36, 0x2f},
            {0x78, 0x21, 0x2a, 0x13, 0x34, 0x3d, 0x16, 0x2f},
            {0x78, 0x21, 0x2a, 0x13, 0x34, 0x3d, 0x16, 0x2f},
            {0x78, 0x61, 0x2a, 0x13, 0x34, 0x7d, 0x16, 0x2f},
            {0x78, 0x61, 0x2a, 0x13, 0x34, 0x7d, 0x16, 0x2f},
            {0x78, 0x61, 0x4a, 0x13, 0x74, 0x7d, 0x16, 0x2f},
            {0x78, 0x61, 0x4a, 0x13, 0x74, 0x7d, 0x16, 0x2f},
            {0x78, 0x61, 0x4a, 0x03, 0x74, 0x7d, 0x16, 0x4f},
            {0x78, 0x61, 0x4a, 0x03, 0x74, 0x7d, 0x16, 0x4f},
            {0x78, 0x61, 0x4a, 0x03, 0x74, 0x7d, 0x06, 0x4f},
            {0x78, 0x61, 0x4a, 0x03, 0x74, 0x7d, 0x06, 0x4f},
            {0x78, 0x61, 0x4a, 0x03, 0x74, 0x7d, 0x06, 0x4f},
            {0x78, 0x61, 0x4a, 0x03, 0x74, 0x7d, 0x06, 0x4f}
        },
        {
            {0x70, 0x69, 0x0a, 0x43, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x69, 0x0a, 0x43, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x69, 0x0a, 0x43, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x69, 0x0a, 0x43, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x69, 0x1a, 0x43, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x69, 0x1a, 0x43, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x69, 0x1a, 0x23, 0x7c, 0x75, 0x46, 0x1f},
            {0x70, 0x69, 0x1a, 0x23, 0x7c, 0x75, 0x46, 0x1f},
            {0x30, 0x69, 0x1a, 0x23, 0x7c, 0x75, 0x26, 0x1f},
            {0x30, 0x69, 0x1a, 0x23, 0x7c, 0x75, 0x26, 0x1f},
            {0x30, 0x29, 0x1a, 0x23, 0x7c, 0x35, 0x26, 0x1f},
            {0x30, 0x29, 0x1a, 0x23, 0x7c, 0x35, 0x26, 0x1f},
            {0x30, 0x29, 0x3a, 0x23, 0x3c, 0x35, 0x26, 0x1f},
            {0x30, 0x29, 0x3a, 0x23, 0x3c, 0x35, 0x26, 0x1f},
            {0x30, 0x29, 0x3a, 0x33, 0x3c, 0x35, 0x26, 0x3f},
            {0x30, 0x29, 0x3a, 0x33, 0x3c, 0x35, 0x26, 0x3f},
            {0x38, 0x29, 0x3a, 0x33, 0x3c, 0x35, 0x36, 0x3f},
            {0x38, 0x29, 0x3a, 0x33, 0x3c, 0x35, 0x36, 0x3f},
            {0x38, 0x21, 0x3a, 0x33, 0x3c, 0x3d, 0x36, 0x3f},
            {0x38, 0x21, 0x3a, 0x33, 0x3c, 0x3d, 0x36, 0x3f},
            {0x38, 0x21, 0x2a, 0x33, 0x34, 0x3d, 0x36, 0x3f},
            {0x38, 0x21, 0x2a, 0x33, 0x34, 0x3d, 0x36, 0x3f},
            {0x38, 0x21, 0x2a, 0x13, 0x34, 0x3d, 0x36, 0x2f},
            {0x38, 0x21, 0x2a, 0x13, 0x34, 0x3d, 0x36, 0x2f},
            {0x78, 0x21, 0x2a, 0x13, 0x34, 0x3d, 0x16, 0x2f},
            {0x78, 0x21, 0x2a, 0x13, 0x34, 0x3d, 0x16, 0x2f},
            {0x78, 0x61, 0x2a, 0x13, 0x34, 0x7d, 0x16, 0x2f},
            {0x78, 0x61, 0x2a, 0x13, 0x34, 0x7d, 0x16, 0x2f},
            {0x78, 0x61, 0x4a, 0x13, 0x74, 0x7d, 0x16, 0x2f},
            {0x78, 0x61, 0x4a, 0x13, 0x74, 0x7d, 0x16, 0x2f},
            {0x78, 0x61, 0x4a, 0x03, 0x74, 0x7d, 0x16, 0x4f},
            {0x78, 0x61, 0x4a, 0x03, 0x74, 0x7d, 0x16, 0x4f},
            {0x78, 0x61, 0x4a, 0x03, 0x74, 0x7d, 0x06, 0x4f},
            {0x78, 0x61, 0x4a, 0x03, 0x74, 0x7d, 0x06, 0x4f},
            {0x78, 0x61, 0x4a, 0x03, 0x74, 0x7d, 0x06, 0x4f},
            {0x78, 0x61, 0x4a, 0x03, 0x74, 0x7d, 0x06, 0x4f}
        },
        {
            {0x70, 0x79, 0x0a, 0x4b, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x79, 0x0a, 0x4b, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x79, 0x0a, 0x4b, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x79, 0x0a, 0x4b, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x79, 0x1a, 0x4b, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x79, 0x1a, 0x4b, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x79, 0x1a, 0x2b, 0x7c, 0x75, 0x46, 0x1f},
            {0x70, 0x79, 0x1a, 0x2b, 0x7c, 0x75, 0x46, 0x1f},
            {0x30, 0x79, 0x1a, 0x2b, 0x7c, 0x75, 0x26, 0x1f},
            {0x30, 0x79, 0x1a, 0x2b, 0x7c, 0x75, 0x26, 0x1f},
            {0x30, 0x39, 0x1a, 0x2b, 0x7c, 0x35, 0x26, 0x1f},
            {0x30, 0x39, 0x1a, 0x2b, 0x7c, 0x35, 0x26, 0x1f},
            {0x30, 0x39, 0x3a, 0x2b, 0x3c, 0x35, 0x26, 0x1f},
            {0x30, 0x39, 0x3a, 0x2b, 0x3c, 0x35, 0x26, 0x1f},
            {0x30, 0x39, 0x3a, 0x3b, 0x3c, 0x35, 0x26, 0x3f},
            {0x30, 0x39, 0x3a, 0x3b, 0x3c, 0x35, 0x26, 0x3f},
            {0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x35, 0x36, 0x3f},
            {0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x35, 0x36, 0x3f},
            {0x38, 0x31, 0x3a, 0x3b, 0x3c, 0x3d, 0x36, 0x3f},
            {0x38, 0x31, 0x3a, 0x3b, 0x3c, 0x3d, 0x36, 0x3f},
            {0x38, 0x31, 0x2a, 0x3b, 0x34, 0x3d, 0x36, 0x3f},
            {0x38, 0x31, 0x2a, 0x3b, 0x34, 0x3d, 0x36, 0x3f},
            {0x38, 0x31, 0x2a, 0x1b, 0x34, 0x3d, 0x36, 0x2f},
            {0x38, 0x31, 0x2a, 0x1b, 0x34, 0x3d, 0x36, 0x2f},
            {0x78, 0x31, 0x2a, 0x1b, 0x34, 0x3d, 0x16, 0x2f},
            {0x78, 0x31, 0x2a, 0x1b, 0x34, 0x3d, 0x16, 0x2f},
            {0x78, 0x71, 0x2a, 0x1b, 0x34, 0x7d, 0x16, 0x2f},
            {0x78, 0x71, 0x2a, 0x1b, 0x34, 0x7d, 0x16, 0x2f},
            {0x78, 0x71, 0x4a, 0x1b, 0x74, 0x7d, 0x16, 0x2f},
            {0x78, 0x71, 0x4a, 0x1b, 0x74, 0x7d, 0x16, 0x2f},
            {0x78, 0x71, 0x4a, 0x0b, 0x74, 0x7d, 0x16, 0x4f},
            {0x78, 0x71, 0x4a, 0x0b, 0x74, 0x7d, 0x16, 0x4f},
            {0x78, 0x71, 0x4a, 0x0b, 0x74, 0x7d, 0x06, 0x4f},
            {0x78, 0x71, 0x4a, 0x0b, 0x74, 0x7d, 0x06, 0x4f},
            {0x78, 0x71, 0x4a, 0x0b, 0x74, 0x7d, 0x06, 0x4f},
            {0x78, 0x71, 0x4a, 0x0b, 0x74, 0x7d, 0x06, 0x4f}
        },
        {
            {0x70, 0x79, 0x0a, 0x4b, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x79, 0x0a, 0x4b, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x79, 0x0a, 0x4b, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x79, 0x0a, 0x4b, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x79, 0x1a, 0x4b, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x79, 0x1a, 0x4b, 0x7c, 0x75, 0x46, 0x0f},
            {0x70, 0x79, 0x1a, 0x2b, 0x7c, 0x75, 0x46, 0x1f},
            {0x70, 0x79, 0x1a, 0x2b, 0x7c, 0x75, 0x46, 0x1f},
            {0x30, 0x79, 0x1a, 0x2b, 0x7c, 0x75, 0x26, 0x1f},
            {0x30, 0x79, 0x1a, 0x2b, 0x7c, 0x75, 0x26, 0x1f},
            {0x30, 0x39, 0x1a, 0x2b, 0x7c, 0x35, 0x26, 0x1f},
            {0x30, 0x39, 0x1a, 0x2b, 0x7c, 0x35, 0x26, 0x1f},
            {0x30, 0x39, 0x3a, 0x2b, 0x3c, 0x35, 0x26, 0x1f},
            {0x30, 0x39, 0x3a, 0x2b, 0x3c, 0x35, 0x26, 0x1f},
            {0x30, 0x39, 0x3a, 0x3b, 0x3c, 0x35, 0x26, 0x3f},
            {0x30, 0x39, 0x3a, 0x3b, 0x3c, 0x35, 0x26, 0x3f},
            {0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x35, 0x36, 0x3f},
            {0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x35, 0x36, 0x3f},
            {0x38, 0x31, 0x3a, 0x3b, 0x3c, 0x3d, 0x36, 0x3f},
            {0x38, 0x31, 0x3a, 0x3b, 0x3c, 0x3d, 0x36, 0x3f},
            {0x38, 0x31, 0x2a, 0x3b, 0x34, 0x3d, 0x36, 0x3f},
            {0x38, 0x31, 0x2a, 0x3b, 0x34, 0x3d, 0x36, 0x3f},
            {0x38, 0x31, 0x2a, 0x1b, 0x34, 0x3d, 0x36, 0x2f},
            {0x38, 0x31, 0x2a, 0x1b, 0x34, 0x3d, 0x36, 0x2f},
            {0x78, 0x31, 0x2a, 0x1b, 0x34, 0x3d, 0x16, 0x2f},
            {0x78, 0x31, 0x2a, 0x1b, 0x34, 0x3d, 0x16, 0x2f},
            {0x78, 0x71, 0x2a, 0x1b, 0x34, 0x7d, 0x16, 0x2f},
            {0x78, 0x71, 0x2a, 0x1b, 0x34, 0x7d, 0x16, 0x2f},
            {0x78, 0x71, 0x4a, 0x1b, 0x74, 0x7d, 0x16, 0x2f},
            {0x78, 0x71, 0x4a, 0x1b, 0x74, 0x7d, 0x16, 0x2f},
            {0x78, 0x71, 0x4a, 0x0b, 0x74, 0x7d, 0x16, 0x4f},
            {0x78, 0x71, 0x4a, 0x0b, 0x74, 0x7d, 0x16, 0x4f},
            {0x78, 0x71, 0x4a, 0x0b, 0x74, 0x7d, 0x06, 0x4f},
            {0x78, 0x71, 0x4a, 0x0b, 0x74, 0x7d, 0x06, 0x4f},
            {0x78, 0x71, 0x4a, 0x0b, 0x74, 0x7d, 0x06, 0x4f},
            {0x78, 0x71, 0x4a, 0x0b, 0x74, 0x7d, 0x06, 0x4f}
        },
        {
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x75, 0x4e, 0x0f},
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x75, 0x4e, 0x0f},
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x75, 0x4e, 0x0f},
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x75, 0x4e, 0x0f},
            {0x70, 0x79, 0x12, 0x4b, 0x7c, 0x75, 0x4e, 0x0f},
            {0x70, 0x79, 0x12, 0x4b, 0x7c, 0x75, 0x4e, 0x0f},
            {0x70, 0x79, 0x12, 0x2b, 0x7c, 0x75, 0x4e, 0x1f},
            {0x70, 0x79, 0x12, 0x2b, 0x7c, 0x75, 0x4e, 0x1f},
            {0x30, 0x79, 0x12, 0x2b, 0x7c, 0x75, 0x2e, 0x1f},
            {0x30, 0x79, 0x12, 0x2b, 0x7c, 0x75, 0x2e, 0x1f},
            {0x30, 0x39, 0x12, 0x2b, 0x7c, 0x35, 0x2e, 0x1f},
            {0x30, 0x39, 0x12, 0x2b, 0x7c, 0x35, 0x2e, 0x1f},
            {0x30, 0x39, 0x32, 0x2b, 0x3c, 0x35, 0x2e, 0x1f},
            {0x30, 0x39, 0x32, 0x2b, 0x3c, 0x35, 0x2e, 0x1f},
            {0x30, 0x39, 0x32, 0x3b, 0x3c, 0x35, 0x2e, 0x3f},
            {0x30, 0x39, 0x32, 0x3b, 0x3c, 0x35, 0x2e, 0x3f},
            {0x38, 0x39, 0x32, 0x3b, 0x3c, 0x35, 0x3e, 0x3f},
            {0x38, 0x39, 0x32, 0x3b, 0x3c, 0x35, 0x3e, 0x3f},
            {0x38, 0x31, 0x32, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f},
            {0x38, 0x31, 0x32, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f},
            {0x38, 0x31, 0x22, 0x3b, 0x34, 0x3d, 0x3e, 0x3f},
            {0x38, 0x31, 0x22, 0x3b, 0x34, 0x3d, 0x3e, 0x3f},
            {0x38, 0x31, 0x22, 0x1b, 0x34, 0x3d, 0x3e, 0x2f},
            {0x38, 0x31, 0x22, 0x1b, 0x34, 0x3d, 0x3e, 0x2f},
            {0x78, 0x31, 0x22, 0x1b, 0x34, 0x3d, 0x1e, 0x2f},
            {0x78, 0x31, 0x22, 0x1b, 0x34, 0x3d, 0x1e, 0x2f},
            {0x78, 0x71, 0x22, 0x1b, 0x34, 0x7d, 0x1e, 0x2f},
            {0x78, 0x71, 0x22, 0x1b, 0x34, 0x7d, 0x1e, 0x2f},
            {0x78, 0x71, 0x42, 0x1b, 0x74, 0x7d, 0x1e, 0x2f},
            {0x78, 0x71, 0x42, 0x1b, 0x74, 0x7d, 0x1e, 0x2f},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x7d, 0x1e, 0x4f},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x7d, 0x1e, 0x4f},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x7d, 0x0e, 0x4f},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x7d, 0x0e, 0x4f},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x7d, 0x0e, 0x4f},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x7d, 0x0e, 0x4f}
        },
        {
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x75, 0x4e, 0x0f},
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x75, 0x4e, 0x0f},
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x75, 0x4e, 0x0f},
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x75, 0x4e, 0x0f},
            {0x70, 0x79, 0x12, 0x4b, 0x7c, 0x75, 0x4e, 0x0f},
            {0x70, 0x79, 0x12, 0x4b, 0x7c, 0x75, 0x4e, 0x0f},
            {0x70, 0x79, 0x12, 0x2b, 0x7c, 0x75, 0x4e, 0x1f},
            {0x70, 0x79, 0x12, 0x2b, 0x7c, 0x75, 0x4e, 0x1f},
            {0x30, 0x79, 0x12, 0x2b, 0x7c, 0x75, 0x2e, 0x1f},
            {0x30, 0x79, 0x12, 0x2b, 0x7c, 0x75, 0x2e, 0x1f},
            {0x30, 0x39, 0x12, 0x2b, 0x7c, 0x35, 0x2e, 0x1f},
            {0x30, 0x39, 0x12, 0x2b, 0x7c, 0x35, 0x2e, 0x1f},
            {0x30, 0x39, 0x32, 0x2b, 0x3c, 0x35, 0x2e, 0x1f},
            {0x30, 0x39, 0x32, 0x2b, 0x3c, 0x35, 0x2e, 0x1f},
            {0x30, 0x39, 0x32, 0x3b, 0x3c, 0x35, 0x2e, 0x3f},
            {0x30, 0x39, 0x32, 0x3b, 0x3c, 0x35, 0x2e, 0x3f},
            {0x38, 0x39, 0x32, 0x3b, 0x3c, 0x35, 0x3e, 0x3f},
            {0x38, 0x39, 0x32, 0x3b, 0x3c, 0x35, 0x3e, 0x3f},
            {0x38, 0x31, 0x32, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f},
            {0x38, 0x31, 0x32, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f},
            {0x38, 0x31, 0x22, 0x3b, 0x34, 0x3d, 0x3e, 0x3f},
            {0x38, 0x31, 0x22, 0x3b, 0x34, 0x3d, 0x3e, 0x3f},
            {0x38, 0x31, 0x22, 0x1b, 0x34, 0x3d, 0x3e, 0x2f},
            {0x38, 0x31, 0x22, 0x1b, 0x34, 0x3d, 0x3e, 0x2f},
            {0x78, 0x31, 0x22, 0x1b, 0x34, 0x3d, 0x1e, 0x2f},
            {0x78, 0x31, 0x22, 0x1b, 0x34, 0x3d, 0x1e, 0x2f},
            {0x78, 0x71, 0x22, 0x1b, 0x34, 0x7d, 0x1e, 0x2f},
            {0x78, 0x71, 0x22, 0x1b, 0x34, 0x7d, 0x1e, 0x2f},
            {0x78, 0x71, 0x42, 0x1b, 0x74, 0x7d, 0x1e, 0x2f},
            {0x78, 0x71, 0x42, 0x1b, 0x74, 0x7d, 0x1e, 0x2f},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x7d, 0x1e, 0x4f},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x7d, 0x1e, 0x4f},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x7d, 0x0e, 0x4f},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x7d, 0x0e, 0x4f},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x7d, 0x0e, 0x4f},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x7d, 0x0e, 0x4f}
        },
        {
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x65, 0x4e, 0x07},
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x65, 0x4e, 0x07},
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x65, 0x4e, 0x07},
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x65, 0x4e, 0x07},
            {0x70, 0x79, 0x12, 0x4b, 0x7c, 0x65, 0x4e, 0x07},
            {0x70, 0x79, 0x12, 0x4b, 0x7c, 0x65, 0x4e, 0x07},
            {0x70, 0x79, 0x12, 0x2b, 0x7c, 0x65, 0x4e, 0x17},
            {0x70, 0x79, 0x12, 0x2b, 0x7c, 0x65, 0x4e, 0x17},
            {0x30, 0x79, 0x12, 0x2b, 0x7c, 0x65, 0x2e, 0x17},
            {0x30, 0x79, 0x12, 0x2b, 0x7c, 0x65, 0x2e, 0x17},
            {0x30, 0x39, 0x12, 0x2b, 0x7c, 0x25, 0x2e, 0x17},
            {0x30, 0x39, 0x12, 0x2b, 0x7c, 0x25, 0x2e, 0x17},
            {0x30, 0x39, 0x32, 0x2b, 0x3c, 0x25, 0x2e, 0x17},
            {0x30, 0x39, 0x32, 0x2b, 0x3c, 0x25, 0x2e, 0x17},
            {0x30, 0x39, 0x32, 0x3b, 0x3c, 0x25, 0x2e, 0x37},
            {0x30, 0x39, 0x32, 0x3b, 0x3c, 0x25, 0x2e, 0x37},
            {0x38, 0x39, 0x32, 0x3b, 0x3c, 0x25, 0x3e, 0x37},
            {0x38, 0x39, 0x32, 0x3b, 0x3c, 0x25, 0x3e, 0x37},
            {0x38, 0x31, 0x32, 0x3b, 0x3c, 0x2d, 0x3e, 0x37},
            {0x38, 0x31, 0x32, 0x3b, 0x3c, 0x2d, 0x3e, 0x37},
            {0x38, 0x31, 0x22, 0x3b, 0x34, 0x2d, 0x3e, 0x37},
            {0x38, 0x31, 0x22, 0x3b, 0x34, 0x2d, 0x3e, 0x37},
            {0x38, 0x31, 0x22, 0x1b, 0x34, 0x2d, 0x3e, 0x27},
            {0x38, 0x31, 0x22, 0x1b, 0x34, 0x2d, 0x3e, 0x27},
            {0x78, 0x31, 0x22, 0x1b, 0x34, 0x2d, 0x1e, 0x27},
            {0x78, 0x31, 0x22, 0x1b, 0x34, 0x2d, 0x1e, 0x27},
            {0x78, 0x71, 0x22, 0x1b, 0x34, 0x6d, 0x1e, 0x27},
            {0x78, 0x71, 0x22, 0x1b, 0x34, 0x6d, 0x1e, 0x27},
            {0x78, 0x71, 0x42, 0x1b, 0x74, 0x6d, 0x1e, 0x27},
            {0x78, 0x71, 0x42, 0x1b, 0x74, 0x6d, 0x1e, 0x27},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x6d, 0x1e, 0x47},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x6d, 0x1e, 0x47},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x6d, 0x0e, 0x47},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x6d, 0x0e, 0x47},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x6d, 0x0e, 0x47},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x6d, 0x0e, 0x47}
        },
        {
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x65, 0x4e, 0x07},
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x65, 0x4e, 0x07},
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x65, 0x4e, 0x07},
            {0x70, 0x79, 0x02, 0x4b, 0x7c, 0x65, 0x4e, 0x07},
            {0x70, 0x79, 0x12, 0x4b, 0x7c, 0x65, 0x4e, 0x07},
            {0x70, 0x79, 0x12, 0x4b, 0x7c, 0x65, 0x4e, 0x07},
            {0x70, 0x79, 0x12, 0x2b, 0x7c, 0x65, 0x4e, 0x17},
            {0x70, 0x79, 0x12, 0x2b, 0x7c, 0x65, 0x4e, 0x17},
            {0x30, 0x79, 0x12, 0x2b, 0x7c, 0x65, 0x2e, 0x17},
            {0x30, 0x79, 0x12, 0x2b, 0x7c, 0x65, 0x2e, 0x17},
            {0x30, 0x39, 0x12, 0x2b, 0x7c, 0x25, 0x2e, 0x17},
            {0x30, 0x39, 0x12, 0x2b, 0x7c, 0x25, 0x2e, 0x17},
            {0x30, 0x39, 0x32, 0x2b, 0x3c, 0x25, 0x2e, 0x17},
            {0x30, 0x39, 0x32, 0x2b, 0x3c, 0x25, 0x2e, 0x17},
            {0x30, 0x39, 0x32, 0x3b, 0x3c, 0x25, 0x2e, 0x37},
            {0x30, 0x39, 0x32, 0x3b, 0x3c, 0x25, 0x2e, 0x37},
            {0x38, 0x39, 0x32, 0x3b, 0x3c, 0x25, 0x3e, 0x37},
            {0x38, 0x39, 0x32, 0x3b, 0x3c, 0x25, 0x3e, 0x37},
            {0x38, 0x31, 0x32, 0x3b, 0x3c, 0x2d, 0x3e, 0x37},
            {0x38, 0x31, 0x32, 0x3b, 0x3c, 0x2d, 0x3e, 0x37},
            {0x38, 0x31, 0x22, 0x3b, 0x34, 0x2d, 0x3e, 0x37},
            {0x38, 0x31, 0x22, 0x3b, 0x34, 0x2d, 0x3e, 0x37},
            {0x38, 0x31, 0x22, 0x1b, 0x34, 0x2d, 0x3e, 0x27},
            {0x38, 0x31, 0x22, 0x1b, 0x34, 0x2d, 0x3e, 0x27},
            {0x78, 0x31, 0x22, 0x1b, 0x34, 0x2d, 0x1e, 0x27},
            {0x78, 0x31, 0x22, 0x1b, 0x34, 0x2d, 0x1e, 0x27},
            {0x78, 0x71, 0x22, 0x1b, 0x34, 0x6d, 0x1e, 0x27},
            {0x78, 0x71, 0x22, 0x1b, 0x34, 0x6d, 0x1e, 0x27},
            {0x78, 0x71, 0x42, 0x1b, 0x74, 0x6d, 0x1e, 0x27},
            {0x78, 0x71, 0x42, 0x1b, 0x74, 0x6d, 0x1e, 0x27},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x6d, 0x1e, 0x47},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x6d, 0x1e, 0x47},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x6d, 0x0e, 0x47},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x6d, 0x0e, 0x47},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x6d, 0x0e, 0x47},
            {0x78, 0x71, 0x42, 0x0b, 0x74, 0x6d, 0x0e, 0x47}
        },
        {
            {0x60, 0x79, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x79, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x79, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x79, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x79, 0x12, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x79, 0x12, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x79, 0x12, 0x2b, 0x5c, 0x65, 0x4e, 0x17},
            {0x60, 0x79, 0x12, 0x2b, 0x5c, 0x65, 0x4e, 0x17},
            {0x20, 0x79, 0x12, 0x2b, 0x5c, 0x65, 0x2e, 0x17},
            {0x20, 0x79, 0x12, 0x2b, 0x5c, 0x65, 0x2e, 0x17},
            {0x20, 0x39, 0x12, 0x2b, 0x5c, 0x25, 0x2e, 0x17},
            {0x20, 0x39, 0x12, 0x2b, 0x5c, 0x25, 0x2e, 0x17},
            {0x20, 0x39, 0x32, 0x2b, 0x1c, 0x25, 0x2e, 0x17},
            {0x20, 0x39, 0x32, 0x2b, 0x1c, 0x25, 0x2e, 0x17},
            {0x20, 0x39, 0x32, 0x3b, 0x1c, 0x25, 0x2e, 0x37},
            {0x20, 0x39, 0x32, 0x3b, 0x1c, 0x25, 0x2e, 0x37},
            {0x28, 0x39, 0x32, 0x3b, 0x1c, 0x25, 0x3e, 0x37},
            {0x28, 0x39, 0x32, 0x3b, 0x1c, 0x25, 0x3e, 0x37},
            {0x28, 0x31, 0x32, 0x3b, 0x1c, 0x2d, 0x3e, 0x37},
            {0x28, 0x31, 0x32, 0x3b, 0x1c, 0x2d, 0x3e, 0x37},
            {0x28, 0x31, 0x22, 0x3b, 0x14, 0x2d, 0x3e, 0x37},
            {0x28, 0x31, 0x22, 0x3b, 0x14, 0x2d, 0x3e, 0x37},
            {0x28, 0x31, 0x22, 0x1b, 0x14, 0x2d, 0x3e, 0x27},
            {0x28, 0x31, 0x22, 0x1b, 0x14, 0x2d, 0x3e, 0x27},
            {0x68, 0x31, 0x22, 0x1b, 0x14, 0x2d, 0x1e, 0x27},
            {0x68, 0x31, 0x22, 0x1b, 0x14, 0x2d, 0x1e, 0x27},
            {0x68, 0x71, 0x22, 0x1b, 0x14, 0x6d, 0x1e, 0x27},
            {0x68, 0x71, 0x22, 0x1b, 0x14, 0x6d, 0x1e, 0x27},
            {0x68, 0x71, 0x42, 0x1b, 0x54, 0x6d, 0x1e, 0x27},
            {0x68, 0x71, 0x42, 0x1b, 0x54, 0x6d, 0x1e, 0x27},
            {0x68, 0x71, 0x42, 0x0b, 0x54, 0x6d, 0x1e, 0x47},
            {0x68, 0x71, 0x42, 0x0b, 0x54, 0x6d, 0x1e, 0x47},
            {0x68, 0x71, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x71, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x71, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x71, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47}
        },
        {
            {0x60, 0x79, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x79, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x79, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x79, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x79, 0x12, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x79, 0x12, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x79, 0x12, 0x2b, 0x5c, 0x65, 0x4e, 0x17},
            {0x60, 0x79, 0x12, 0x2b, 0x5c, 0x65, 0x4e, 0x17},
            {0x20, 0x79, 0x12, 0x2b, 0x5c, 0x65, 0x2e, 0x17},
            {0x20, 0x79, 0x12, 0x2b, 0x5c, 0x65, 0x2e, 0x17},
            {0x20, 0x39, 0x12, 0x2b, 0x5c, 0x25, 0x2e, 0x17},
            {0x20, 0x39, 0x12, 0x2b, 0x5c, 0x25, 0x2e, 0x17},
            {0x20, 0x39, 0x32, 0x2b, 0x1c, 0x25, 0x2e, 0x17},
            {0x20, 0x39, 0x32, 0x2b, 0x1c, 0x25, 0x2e, 0x17},
            {0x20, 0x39, 0x32, 0x3b, 0x1c, 0x25, 0x2e, 0x37},
            {0x20, 0x39, 0x32, 0x3b, 0x1c, 0x25, 0x2e, 0x37},
            {0x28, 0x39, 0x32, 0x3b, 0x1c, 0x25, 0x3e, 0x37},
            {0x28, 0x39, 0x32, 0x3b, 0x1c, 0x25, 0x3e, 0x37},
            {0x28, 0x31, 0x32, 0x3b, 0x1c, 0x2d, 0x3e, 0x37},
            {0x28, 0x31, 0x32, 0x3b, 0x1c, 0x2d, 0x3e, 0x37},
            {0x28, 0x31, 0x22, 0x3b, 0x14, 0x2d, 0x3e, 0x37},
            {0x28, 0x31, 0x22, 0x3b, 0x14, 0x2d, 0x3e, 0x37},
            {0x28, 0x31, 0x22, 0x1b, 0x14, 0x2d, 0x3e, 0x27},
            {0x28, 0x31, 0x22, 0x1b, 0x14, 0x2d, 0x3e, 0x27},
            {0x68, 0x31, 0x22, 0x1b, 0x14, 0x2d, 0x1e, 0x27},
            {0x68, 0x31, 0x22, 0x1b, 0x14, 0x2d, 0x1e, 0x27},
            {0x68, 0x71, 0x22, 0x1b, 0x14, 0x6d, 0x1e, 0x27},
            {0x68, 0x71, 0x22, 0x1b, 0x14, 0x6d, 0x1e, 0x27},
            {0x68, 0x71, 0x42, 0x1b, 0x54, 0x6d, 0x1e, 0x27},
            {0x68, 0x71, 0x42, 0x1b, 0x54, 0x6d, 0x1e, 0x27},
            {0x68, 0x71, 0x42, 0x0b, 0x54, 0x6d, 0x1e, 0x47},
            {0x68, 0x71, 0x42, 0x0b, 0x54, 0x6d, 0x1e, 0x47},
            {0x68, 0x71, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x71, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x71, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x71, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47}
        },
        {
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x12, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x12, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x12, 0x6b, 0x5c, 0x65, 0x4e, 0x17},
            {0x60, 0x59, 0x12, 0x6b, 0x5c, 0x65, 0x4e, 0x17},
            {0x20, 0x59, 0x12, 0x6b, 0x5c, 0x65, 0x2e, 0x17},
            {0x20, 0x59, 0x12, 0x6b, 0x5c, 0x65, 0x2e, 0x17},
            {0x20, 0x19, 0x12, 0x6b, 0x5c, 0x25, 0x2e, 0x17},
            {0x20, 0x19, 0x12, 0x6b, 0x5c, 0x25, 0x2e, 0x17},
            {0x20, 0x19, 0x32, 0x6b, 0x1c, 0x25, 0x2e, 0x17},
            {0x20, 0x19, 0x32, 0x6b, 0x1c, 0x25, 0x2e, 0x17},
            {0x20, 0x19, 0x32, 0x7b, 0x1c, 0x25, 0x2e, 0x37},
            {0x20, 0x19, 0x32, 0x7b, 0x1c, 0x25, 0x2e, 0x37},
            {0x28, 0x19, 0x32, 0x7b, 0x1c, 0x25, 0x3e, 0x37},
            {0x28, 0x19, 0x32, 0x7b, 0x1c, 0x25, 0x3e, 0x37},
            {0x28, 0x11, 0x32, 0x7b, 0x1c, 0x2d, 0x3e, 0x37},
            {0x28, 0x11, 0x32, 0x7b, 0x1c, 0x2d, 0x3e, 0x37},
            {0x28, 0x11, 0x22, 0x7b, 0x14, 0x2d, 0x3e, 0x37},
            {0x28, 0x11, 0x22, 0x7b, 0x14, 0x2d, 0x3e, 0x37},
            {0x28, 0x11, 0x22, 0x5b, 0x14, 0x2d, 0x3e, 0x27},
            {0x28, 0x11, 0x22, 0x5b, 0x14, 0x2d, 0x3e, 0x27},
            {0x68, 0x11, 0x22, 0x5b, 0x14, 0x2d, 0x1e, 0x27},
            {0x68, 0x11, 0x22, 0x5b, 0x14, 0x2d, 0x1e, 0x27},
            {0x68, 0x51, 0x22, 0x5b, 0x14, 0x6d, 0x1e, 0x27},
            {0x68, 0x51, 0x22, 0x5b, 0x14, 0x6d, 0x1e, 0x27},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x1e, 0x27},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x1e, 0x27},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x1e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x1e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47}
        },
        {
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x12, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x12, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x12, 0x6b, 0x5c, 0x65, 0x4e, 0x17},
            {0x60, 0x59, 0x12, 0x6b, 0x5c, 0x65, 0x4e, 0x17},
            {0x20, 0x59, 0x12, 0x6b, 0x5c, 0x65, 0x2e, 0x17},
            {0x20, 0x59, 0x12, 0x6b, 0x5c, 0x65, 0x2e, 0x17},
            {0x20, 0x19, 0x12, 0x6b, 0x5c, 0x25, 0x2e, 0x17},
            {0x20, 0x19, 0x12, 0x6b, 0x5c, 0x25, 0x2e, 0x17},
            {0x20, 0x19, 0x32, 0x6b, 0x1c, 0x25, 0x2e, 0x17},
            {0x20, 0x19, 0x32, 0x6b, 0x1c, 0x25, 0x2e, 0x17},
            {0x20, 0x19, 0x32, 0x7b, 0x1c, 0x25, 0x2e, 0x37},
            {0x20, 0x19, 0x32, 0x7b, 0x1c, 0x25, 0x2e, 0x37},
            {0x28, 0x19, 0x32, 0x7b, 0x1c, 0x25, 0x3e, 0x37},
            {0x28, 0x19, 0x32, 0x7b, 0x1c, 0x25, 0x3e, 0x37},
            {0x28, 0x11, 0x32, 0x7b, 0x1c, 0x2d, 0x3e, 0x37},
            {0x28, 0x11, 0x32, 0x7b, 0x1c, 0x2d, 0x3e, 0x37},
            {0x28, 0x11, 0x22, 0x7b, 0x14, 0x2d, 0x3e, 0x37},
            {0x28, 0x11, 0x22, 0x7b, 0x14, 0x2d, 0x3e, 0x37},
            {0x28, 0x11, 0x22, 0x5b, 0x14, 0x2d, 0x3e, 0x27},
            {0x28, 0x11, 0x22, 0x5b, 0x14, 0x2d, 0x3e, 0x27},
            {0x68, 0x11, 0x22, 0x5b, 0x14, 0x2d, 0x1e, 0x27},
            {0x68, 0x11, 0x22, 0x5b, 0x14, 0x2d, 0x1e, 0x27},
            {0x68, 0x51, 0x22, 0x5b, 0x14, 0x6d, 0x1e, 0x27},
            {0x68, 0x51, 0x22, 0x5b, 0x14, 0x6d, 0x1e, 0x27},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x1e, 0x27},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x1e, 0x27},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x1e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x1e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47}
        },
        {
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x17},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x17},
            {0x20, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x17},
            {0x20, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x17},
            {0x20, 0x19, 0x52, 0x6b, 0x5c, 0x25, 0x6e, 0x17},
            {0x20, 0x19, 0x52, 0x6b, 0x5c, 0x25, 0x6e, 0x17},
            {0x20, 0x19, 0x72, 0x6b, 0x1c, 0x25, 0x6e, 0x17},
            {0x20, 0x19, 0x72, 0x6b, 0x1c, 0x25, 0x6e, 0x17},
            {0x20, 0x19, 0x72, 0x7b, 0x1c, 0x25, 0x6e, 0x37},
            {0x20, 0x19, 0x72, 0x7b, 0x1c, 0x25, 0x6e, 0x37},
            {0x28, 0x19, 0x72, 0x7b, 0x1c, 0x25, 0x7e, 0x37},
            {0x28, 0x19, 0x72, 0x7b, 0x1c, 0x25, 0x7e, 0x37},
            {0x28, 0x11, 0x72, 0x7b, 0x1c, 0x2d, 0x7e, 0x37},
            {0x28, 0x11, 0x72, 0x7b, 0x1c, 0x2d, 0x7e, 0x37},
            {0x28, 0x11, 0x62, 0x7b, 0x14, 0x2d, 0x7e, 0x37},
            {0x28, 0x11, 0x62, 0x7b, 0x14, 0x2d, 0x7e, 0x37},
            {0x28, 0x11, 0x62, 0x5b, 0x14, 0x2d, 0x7e, 0x27},
            {0x28, 0x11, 0x62, 0x5b, 0x14, 0x2d, 0x7e, 0x27},
            {0x68, 0x11, 0x62, 0x5b, 0x14, 0x2d, 0x5e, 0x27},
            {0x68, 0x11, 0x62, 0x5b, 0x14, 0x2d, 0x5e, 0x27},
            {0x68, 0x51, 0x62, 0x5b, 0x14, 0x6d, 0x5e, 0x27},
            {0x68, 0x51, 0x62, 0x5b, 0x14, 0x6d, 0x5e, 0x27},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x27},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x27},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47}
        },
        {
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x17},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x17},
            {0x20, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x17},
            {0x20, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x17},
            {0x20, 0x19, 0x52, 0x6b, 0x5c, 0x25, 0x6e, 0x17},
            {0x20, 0x19, 0x52, 0x6b, 0x5c, 0x25, 0x6e, 0x17},
            {0x20, 0x19, 0x72, 0x6b, 0x1c, 0x25, 0x6e, 0x17},
            {0x20, 0x19, 0x72, 0x6b, 0x1c, 0x25, 0x6e, 0x17},
            {0x20, 0x19, 0x72, 0x7b, 0x1c, 0x25, 0x6e, 0x37},
            {0x20, 0x19, 0x72, 0x7b, 0x1c, 0x25, 0x6e, 0x37},
            {0x28, 0x19, 0x72, 0x7b, 0x1c, 0x25, 0x7e, 0x37},
            {0x28, 0x19, 0x72, 0x7b, 0x1c, 0x25, 0x7e, 0x37},
            {0x28, 0x11, 0x72, 0x7b, 0x1c, 0x2d, 0x7e, 0x37},
            {0x28, 0x11, 0x72, 0x7b, 0x1c, 0x2d, 0x7e, 0x37},
            {0x28, 0x11, 0x62, 0x7b, 0x14, 0x2d, 0x7e, 0x37},
            {0x28, 0x11, 0x62, 0x7b, 0x14, 0x2d, 0x7e, 0x37},
            {0x28, 0x11, 0x62, 0x5b, 0x14, 0x2d, 0x7e, 0x27},
            {0x28, 0x11, 0x62, 0x5b, 0x14, 0x2d, 0x7e, 0x27},
            {0x68, 0x11, 0x62, 0x5b, 0x14, 0x2d, 0x5e, 0x27},
            {0x68, 0x11, 0x62, 0x5b, 0x14, 0x2d, 0x5e, 0x27},
            {0x68, 0x51, 0x62, 0x5b, 0x14, 0x6d, 0x5e, 0x27},
            {0x68, 0x51, 0x62, 0x5b, 0x14, 0x6d, 0x5e, 0x27},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x27},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x27},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47}
        },
        {
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x20, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x20, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x20, 0x19, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x20, 0x19, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x20, 0x19, 0x72, 0x6b, 0x1c, 0x45, 0x6e, 0x57},
            {0x20, 0x19, 0x72, 0x6b, 0x1c, 0x45, 0x6e, 0x57},
            {0x20, 0x19, 0x72, 0x7b, 0x1c, 0x45, 0x6e, 0x77},
            {0x20, 0x19, 0x72, 0x7b, 0x1c, 0x45, 0x6e, 0x77},
            {0x28, 0x19, 0x72, 0x7b, 0x1c, 0x45, 0x7e, 0x77},
            {0x28, 0x19, 0x72, 0x7b, 0x1c, 0x45, 0x7e, 0x77},
            {0x28, 0x11, 0x72, 0x7b, 0x1c, 0x4d, 0x7e, 0x77},
            {0x28, 0x11, 0x72, 0x7b, 0x1c, 0x4d, 0x7e, 0x77},
            {0x28, 0x11, 0x62, 0x7b, 0x14, 0x4d, 0x7e, 0x77},
            {0x28, 0x11, 0x62, 0x7b, 0x14, 0x4d, 0x7e, 0x77},
            {0x28, 0x11, 0x62, 0x5b, 0x14, 0x4d, 0x7e, 0x67},
            {0x28, 0x11, 0x62, 0x5b, 0x14, 0x4d, 0x7e, 0x67},
            {0x68, 0x11, 0x62, 0x5b, 0x14, 0x4d, 0x5e, 0x67},
            {0x68, 0x11, 0x62, 0x5b, 0x14, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x14, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x14, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47}
        },
        {
            {0x60, 0x59, 0x02, 0x4b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x20, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x20, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x20, 0x19, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x20, 0x19, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x20, 0x19, 0x72, 0x6b, 0x1c, 0x45, 0x6e, 0x57},
            {0x20, 0x19, 0x72, 0x6b, 0x1c, 0x45, 0x6e, 0x57},
            {0x20, 0x19, 0x72, 0x7b, 0x1c, 0x45, 0x6e, 0x77},
            {0x20, 0x19, 0x72, 0x7b, 0x1c, 0x45, 0x6e, 0x77},
            {0x28, 0x19, 0x72, 0x7b, 0x1c, 0x45, 0x7e, 0x77},
            {0x28, 0x19, 0x72, 0x7b, 0x1c, 0x45, 0x7e, 0x77},
            {0x28, 0x11, 0x72, 0x7b, 0x1c, 0x4d, 0x7e, 0x77},
            {0x28, 0x11, 0x72, 0x7b, 0x1c, 0x4d, 0x7e, 0x77},
            {0x28, 0x11, 0x62, 0x7b, 0x14, 0x4d, 0x7e, 0x77},
            {0x28, 0x11, 0x62, 0x7b, 0x14, 0x4d, 0x7e, 0x77},
            {0x28, 0x11, 0x62, 0x5b, 0x14, 0x4d, 0x7e, 0x67},
            {0x28, 0x11, 0x62, 0x5b, 0x14, 0x4d, 0x7e, 0x67},
            {0x68, 0x11, 0x62, 0x5b, 0x14, 0x4d, 0x5e, 0x67},
            {0x68, 0x11, 0x62, 0x5b, 0x14, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x14, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x14, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x0b, 0x54, 0x6d, 0x0e, 0x47}
        },
        {
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x19, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x19, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x19, 0x72, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x19, 0x72, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x19, 0x72, 0x7b, 0x0c, 0x45, 0x6e, 0x77},
            {0x40, 0x19, 0x72, 0x7b, 0x0c, 0x45, 0x6e, 0x77},
            {0x48, 0x19, 0x72, 0x7b, 0x0c, 0x45, 0x7e, 0x77},
            {0x48, 0x19, 0x72, 0x7b, 0x0c, 0x45, 0x7e, 0x77},
            {0x48, 0x11, 0x72, 0x7b, 0x0c, 0x4d, 0x7e, 0x77},
            {0x48, 0x11, 0x72, 0x7b, 0x0c, 0x4d, 0x7e, 0x77},
            {0x48, 0x11, 0x62, 0x7b, 0x04, 0x4d, 0x7e, 0x77},
            {0x48, 0x11, 0x62, 0x7b, 0x04, 0x4d, 0x7e, 0x77},
            {0x48, 0x11, 0x62, 0x5b, 0x04, 0x4d, 0x7e, 0x67},
            {0x48, 0x11, 0x62, 0x5b, 0x04, 0x4d, 0x7e, 0x67},
            {0x68, 0x11, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x11, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47}
        },
        {
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x19, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x19, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x19, 0x72, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x19, 0x72, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x19, 0x72, 0x7b, 0x0c, 0x45, 0x6e, 0x77},
            {0x40, 0x19, 0x72, 0x7b, 0x0c, 0x45, 0x6e, 0x77},
            {0x48, 0x19, 0x72, 0x7b, 0x0c, 0x45, 0x7e, 0x77},
            {0x48, 0x19, 0x72, 0x7b, 0x0c, 0x45, 0x7e, 0x77},
            {0x48, 0x11, 0x72, 0x7b, 0x0c, 0x4d, 0x7e, 0x77},
            {0x48, 0x11, 0x72, 0x7b, 0x0c, 0x4d, 0x7e, 0x77},
            {0x48, 0x11, 0x62, 0x7b, 0x04, 0x4d, 0x7e, 0x77},
            {0x48, 0x11, 0x62, 0x7b, 0x04, 0x4d, 0x7e, 0x77},
            {0x48, 0x11, 0x62, 0x5b, 0x04, 0x4d, 0x7e, 0x67},
            {0x48, 0x11, 0x62, 0x5b, 0x04, 0x4d, 0x7e, 0x67},
            {0x48, 0x11, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x11, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47}
        },
        {
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x72, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x72, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x6e, 0x77},
            {0x40, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x6e, 0x77},
            {0x48, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x7e, 0x77},
            {0x48, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x7e, 0x77},
            {0x48, 0x01, 0x72, 0x7b, 0x0c, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x72, 0x7b, 0x0c, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x62, 0x7b, 0x04, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x62, 0x7b, 0x04, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x7e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x7e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47}
        },
        {
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x4e, 0x07},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x72, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x72, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x6e, 0x77},
            {0x40, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x6e, 0x77},
            {0x48, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x7e, 0x77},
            {0x48, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x7e, 0x77},
            {0x48, 0x01, 0x72, 0x7b, 0x0c, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x72, 0x7b, 0x0c, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x62, 0x7b, 0x04, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x62, 0x7b, 0x04, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x7e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x7e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x42, 0x5b, 0x54, 0x6d, 0x5e, 0x47}
        },
        {
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x72, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x72, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x6e, 0x77},
            {0x40, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x6e, 0x77},
            {0x48, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x7e, 0x77},
            {0x48, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x7e, 0x77},
            {0x48, 0x01, 0x72, 0x7b, 0x0c, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x72, 0x7b, 0x0c, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x62, 0x7b, 0x04, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x62, 0x7b, 0x04, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x7e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x7e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67}
        },
        {
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x60, 0x59, 0x52, 0x6b, 0x5c, 0x65, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x59, 0x52, 0x6b, 0x5c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x52, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x72, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x72, 0x6b, 0x0c, 0x45, 0x6e, 0x57},
            {0x40, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x6e, 0x77},
            {0x40, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x6e, 0x77},
            {0x48, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x7e, 0x77},
            {0x48, 0x09, 0x72, 0x7b, 0x0c, 0x45, 0x7e, 0x77},
            {0x48, 0x01, 0x72, 0x7b, 0x0c, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x72, 0x7b, 0x0c, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x62, 0x7b, 0x04, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x62, 0x7b, 0x04, 0x4d, 0x7e, 0x77},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x7e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x7e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x48, 0x01, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x04, 0x4d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67},
            {0x68, 0x51, 0x62, 0x5b, 0x54, 0x6d, 0x5e, 0x67}
        }
    },
    {   /* 12,000bps map */
        {
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27}
        },
        {
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27}
        },
        {
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27}
        },
        {
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27}
        },
        {
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27}
        },
        {
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x0b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x0e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x0b, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x0b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x0e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x0e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x1e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x13, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x0b, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x0b, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x0b, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x3d, 0x0e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x0e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x0e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x1b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x14, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x0b, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x0b, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x0b, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x0b, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x0e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x0e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x0e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x0e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x0b, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x32, 0x0b, 0x24, 0x3d, 0x16, 0x37},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x2d, 0x0e, 0x2f},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x2d, 0x0e, 0x2f},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x0e, 0x27},
            {0x38, 0x01, 0x22, 0x1b, 0x04, 0x2d, 0x0e, 0x27},
            {0x28, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x28, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x22, 0x3b, 0x0c, 0x35, 0x1e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x2d, 0x0e, 0x2f},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x2d, 0x0e, 0x2f},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x2d, 0x0e, 0x2f},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x28, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x28, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x28, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x30, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x13, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x16, 0x37},
            {0x18, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x16, 0x37},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x0e, 0x37},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x0e, 0x37},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x3d, 0x0e, 0x37},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x2d, 0x0e, 0x2f},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x2d, 0x0e, 0x2f},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x2d, 0x0e, 0x2f},
            {0x38, 0x01, 0x22, 0x0b, 0x04, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x22, 0x0b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x22, 0x0b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x28, 0x01, 0x22, 0x1b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x28, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x28, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x30, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x1e, 0x27},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x3e, 0x27},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x35, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x14, 0x35, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x06, 0x37},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x0e, 0x37},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x0e, 0x37},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x0e, 0x37},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x0e, 0x37},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x2d, 0x0e, 0x2f},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x2d, 0x0e, 0x2f},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x2d, 0x0e, 0x2f},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x22, 0x0b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x22, 0x0b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x22, 0x0b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x22, 0x0b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x28, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x28, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x28, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x3e, 0x27},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x3e, 0x27},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x3e, 0x27},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x3e, 0x27},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x0b, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x06, 0x37},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x0e, 0x37},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x0e, 0x37},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x0e, 0x2f},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x0e, 0x2f},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x2d, 0x0e, 0x2f},
            {0x38, 0x01, 0x2a, 0x0b, 0x24, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x2a, 0x0b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x2a, 0x0b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x22, 0x0b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x22, 0x0b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x22, 0x2b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x22, 0x2b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x28, 0x09, 0x22, 0x3b, 0x0c, 0x2d, 0x0e, 0x27},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x2e, 0x27},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x2e, 0x27},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x3e, 0x27},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x3e, 0x27},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x3e, 0x07},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x0c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x06, 0x2f},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x0e, 0x2f},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x0e, 0x2f},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x0e, 0x2f},
            {0x28, 0x21, 0x2a, 0x0b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x2a, 0x0b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x2a, 0x0b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x2a, 0x0b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x2a, 0x2b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x22, 0x2b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x22, 0x2b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x22, 0x2b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x2e, 0x27},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x2e, 0x27},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x2e, 0x27},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x2e, 0x07},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x3e, 0x07},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x3e, 0x07},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x3e, 0x07},
            {0x30, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x32, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x1d, 0x06, 0x37},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x06, 0x2f},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x06, 0x2f},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x06, 0x2f},
            {0x38, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x0e, 0x2f},
            {0x28, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x21, 0x2a, 0x0b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x01, 0x2a, 0x0b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x2a, 0x2b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x2a, 0x2b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x2a, 0x2b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x22, 0x2b, 0x0c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x2d, 0x2e, 0x27},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x2e, 0x07},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x2e, 0x07},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x2e, 0x07},
            {0x30, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x3e, 0x07},
            {0x30, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x30, 0x11, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x0d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x06, 0x2f},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x06, 0x2f},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x06, 0x2f},
            {0x08, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x28, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x2a, 0x2b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x2a, 0x2b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x2a, 0x2b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x2e, 0x07},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x2e, 0x07},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x2e, 0x07},
            {0x20, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x0d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x0d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x0d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x0b, 0x24, 0x0d, 0x06, 0x2f},
            {0x08, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x08, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x08, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x28, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x2a, 0x2b, 0x2c, 0x2d, 0x0e, 0x2f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x02, 0x3b, 0x0c, 0x25, 0x2e, 0x07},
            {0x20, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x0d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x0d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x0d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x2a, 0x03, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x08, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x08, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x02, 0x2b, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x1d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x0d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x0d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x24, 0x0d, 0x06, 0x3f},
            {0x18, 0x21, 0x2a, 0x03, 0x24, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x2a, 0x03, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x2a, 0x03, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x2a, 0x03, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x2a, 0x0b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x08, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x08, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x0e, 0x2f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x2e, 0x2f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x2e, 0x2f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x02, 0x2b, 0x0c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x02, 0x2b, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x02, 0x2b, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x02, 0x2b, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x02, 0x3b, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07},
            {0x20, 0x19, 0x02, 0x3b, 0x1c, 0x25, 0x3e, 0x07}
        },
        {
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x0d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x0d, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x3a, 0x03, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x2a, 0x03, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x2a, 0x03, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x2a, 0x03, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x2a, 0x23, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x08, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x08, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x2e, 0x2f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x2e, 0x2f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x2e, 0x2f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x2e, 0x2f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x0a, 0x2b, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x02, 0x2b, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x02, 0x2b, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x02, 0x2b, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07}
        },
        {
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x3a, 0x03, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x3a, 0x03, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x3a, 0x03, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x2a, 0x03, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x2a, 0x23, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x2a, 0x23, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x2a, 0x23, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x2a, 0x2b, 0x2c, 0x0d, 0x06, 0x2f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x26, 0x2f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x26, 0x2f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x2e, 0x2f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x2e, 0x2f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x2e, 0x0f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x2e, 0x0f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x25, 0x2e, 0x0f},
            {0x28, 0x09, 0x0a, 0x2b, 0x2c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x0a, 0x2b, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x0a, 0x2b, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x0a, 0x2b, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x02, 0x2b, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x2e, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07}
        },
        {
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x21, 0x3a, 0x03, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x3a, 0x03, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x21, 0x3a, 0x03, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x3a, 0x23, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x2a, 0x23, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x2a, 0x23, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x2a, 0x23, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x26, 0x2f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x26, 0x2f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x26, 0x2f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x26, 0x2f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x2e, 0x0f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x2e, 0x0f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x2e, 0x0f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x2e, 0x0f},
            {0x20, 0x29, 0x0a, 0x2b, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x0a, 0x2b, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x0a, 0x2b, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x0a, 0x2b, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x0a, 0x33, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07}
        },
        {
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x18, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x21, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x21, 0x3a, 0x03, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x3a, 0x23, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x3a, 0x23, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x3a, 0x23, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x2a, 0x23, 0x2c, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x26, 0x2f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x0d, 0x26, 0x2f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x26, 0x0f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x26, 0x0f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x2e, 0x0f},
            {0x28, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x2e, 0x0f},
            {0x20, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x29, 0x0a, 0x2b, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x09, 0x0a, 0x2b, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x0a, 0x33, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x0a, 0x33, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x0a, 0x33, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07},
            {0x20, 0x19, 0x02, 0x33, 0x1c, 0x25, 0x36, 0x07}
        },
        {
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x29, 0x3a, 0x23, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x3a, 0x23, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x3a, 0x23, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x26, 0x0f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x26, 0x0f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x26, 0x0f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x26, 0x0f},
            {0x20, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x39, 0x0a, 0x33, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x0a, 0x33, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x0a, 0x33, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x0a, 0x33, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17}
        },
        {
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x29, 0x3a, 0x23, 0x34, 0x0d, 0x06, 0x3f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x05, 0x26, 0x1f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x05, 0x26, 0x1f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x26, 0x0f},
            {0x08, 0x29, 0x0a, 0x2b, 0x2c, 0x05, 0x26, 0x0f},
            {0x00, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x26, 0x0f},
            {0x20, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x39, 0x0a, 0x33, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x0a, 0x33, 0x3c, 0x25, 0x2e, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17}
        },
        {
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x05, 0x26, 0x1f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x05, 0x26, 0x1f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x05, 0x26, 0x1f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x26, 0x0f},
            {0x20, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17}
        },
        {
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x0d, 0x26, 0x3f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x05, 0x26, 0x1f},
            {0x08, 0x29, 0x0a, 0x23, 0x2c, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x0a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x0a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x29, 0x0a, 0x2b, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x26, 0x0f},
            {0x20, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x2e, 0x0f},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x0f},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x0f},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x0f},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17}
        },
        {
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x0a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x0a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x0a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x0a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x26, 0x0f},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x0f},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x0f},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x0f},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x0f},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17}
        },
        {
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x08, 0x29, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x0a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x0a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x0a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x0f},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x0f},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x0f},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17}
        },
        {
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x0a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x0a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x0f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x0f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x0f},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17}
        },
        {
            {0x10, 0x31, 0x3a, 0x03, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x08, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x29, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x0a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x0a, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x0f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x1c, 0x25, 0x36, 0x17}
        },
        {
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17}
        },
        {
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17}
        },
        {
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17},
            {0x20, 0x19, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17}
        },
        {
            {0x10, 0x31, 0x3a, 0x23, 0x34, 0x15, 0x06, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x3f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x10, 0x31, 0x1a, 0x23, 0x34, 0x15, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x31, 0x1a, 0x23, 0x34, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x1a, 0x23, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x26, 0x1f},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x00, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x05, 0x36, 0x17},
            {0x20, 0x39, 0x12, 0x33, 0x3c, 0x25, 0x36, 0x17}
        }
    },
    {   /* 9,600bps map */
        {
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x0e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x01, 0x12, 0x13, 0x1c, 0x1d, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x12, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x1c, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x00, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x01, 0x12, 0x13, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x12, 0x13, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x09, 0x02, 0x13, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x09, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x1b, 0x0c, 0x1d, 0x0e, 0x07},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x10, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x0e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x11, 0x12, 0x0b, 0x0c, 0x1d, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x12, 0x0b, 0x0c, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x0b, 0x14, 0x15, 0x1e, 0x0f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f},
            {0x08, 0x19, 0x02, 0x03, 0x14, 0x15, 0x1e, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x1d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x06, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x1d, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x15, 0x16, 0x0f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x15, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x06, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x11, 0x1a, 0x0b, 0x0c, 0x0d, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x1a, 0x0b, 0x0c, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x08, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x07},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x1f}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17}
        },
        {
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x10, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x1b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x06, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x11, 0x1a, 0x0b, 0x04, 0x0d, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x1a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x0b, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x04, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17},
            {0x18, 0x19, 0x0a, 0x03, 0x14, 0x05, 0x16, 0x17}
        }
    },
    {   /* 7,200bps map */
        {
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f}
        },
        {
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f}
        },
        {
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f}
        },
        {
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f}
        },
        {
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f}
        },
        {
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f}
        },
        {
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f}
        },
        {
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f}
        },
        {
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x03, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x04, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x0a, 0x0b, 0x0c, 0x0d, 0x06, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x03, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x04, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07},
            {0x08, 0x01, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07}
        },
        {
            {0x00, 0x09, 0x0a, 0x0b, 0x0c, 0x05, 0x06, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x0f},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x00, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x05, 0x0e, 0x07},
            {0x08, 0x09, 0x02, 0x0b, 0x0c, 0x0d, 0x0e, 0x07}
        }
    },
};

float v17_rx_carrier_frequency(v17_rx_state_t *s)
{
    return dds_frequency(s->carrier_phase_rate);
}
/*- End of function --------------------------------------------------------*/

float v17_rx_symbol_timing_correction(v17_rx_state_t *s)
{
    return (float) s->gardner_total_correction/((float) PULSESHAPER_COEFF_SETS*10.0f/(3.0f*2.0f));
}
/*- End of function --------------------------------------------------------*/

float v17_rx_signal_power(v17_rx_state_t *s)
{
    return power_meter_dbm0(&s->power);
}
/*- End of function --------------------------------------------------------*/

void v17_rx_signal_cutoff(v17_rx_state_t *s, float cutoff)
{
    /* The 0.4 factor allows for the gain of the DC blocker */
    s->carrier_on_power = power_meter_level_dbm0(cutoff - 2.5f)*0.4;
    s->carrier_off_power = power_meter_level_dbm0(cutoff + 2.5f)*0.4;
}
/*- End of function --------------------------------------------------------*/

int v17_rx_equalizer_state(v17_rx_state_t *s, complex_t **coeffs)
{
    *coeffs = s->eq_coeff;
    return V17_EQUALIZER_PRE_LEN + 1 + V17_EQUALIZER_POST_LEN;
}
/*- End of function --------------------------------------------------------*/

static void equalizer_save(v17_rx_state_t *s)
{
    int i;

    for (i = 0;  i < V17_EQUALIZER_PRE_LEN + 1 + V17_EQUALIZER_POST_LEN;  i++)
        s->eq_coeff_save[i] = s->eq_coeff[i];
}
/*- End of function --------------------------------------------------------*/

static void equalizer_restore(v17_rx_state_t *s)
{
    int i;

    for (i = 0;  i < V17_EQUALIZER_PRE_LEN + 1 + V17_EQUALIZER_POST_LEN;  i++)
        s->eq_coeff[i] = s->eq_coeff_save[i];
    for (i = 0;  i <= V17_EQUALIZER_MASK;  i++)
        s->eq_buf[i] = complex_set(0.0f, 0.0f);

    s->eq_put_step = PULSESHAPER_COEFF_SETS*10/(3*2) - 1;
    s->eq_step = 0;
    s->eq_delta = EQUALIZER_DELTA/(V17_EQUALIZER_PRE_LEN + 1 + V17_EQUALIZER_POST_LEN);
}
/*- End of function --------------------------------------------------------*/

static void equalizer_reset(v17_rx_state_t *s)
{
    int i;

    /* Start with an equalizer based on everything being perfect */
    for (i = 0;  i < V17_EQUALIZER_PRE_LEN + 1 + V17_EQUALIZER_POST_LEN;  i++)
        s->eq_coeff[i] = complex_set(0.0f, 0.0f);
    s->eq_coeff[V17_EQUALIZER_PRE_LEN] = complex_set(3.0f, 0.0f);
    for (i = 0;  i <= V17_EQUALIZER_MASK;  i++)
        s->eq_buf[i] = complex_set(0.0f, 0.0f);

    s->eq_put_step = PULSESHAPER_COEFF_SETS*10/(3*2) - 1;
    s->eq_step = 0;
    s->eq_delta = EQUALIZER_DELTA/(V17_EQUALIZER_PRE_LEN + 1 + V17_EQUALIZER_POST_LEN);
}
/*- End of function --------------------------------------------------------*/

static __inline__ complex_t equalizer_get(v17_rx_state_t *s)
{
    int i;
    int p;
    complex_t z;
    complex_t z1;

    /* Get the next equalized value. */
    z = complex_set(0.0f, 0.0f);
    p = s->eq_step - 1;
    for (i = 0;  i < V17_EQUALIZER_PRE_LEN + 1 + V17_EQUALIZER_POST_LEN;  i++)
    {
        p = (p - 1) & V17_EQUALIZER_MASK;
        z1 = complex_mul(&s->eq_coeff[i], &s->eq_buf[p]);
        z = complex_add(&z, &z1);
    }
    return z;
}
/*- End of function --------------------------------------------------------*/

static void tune_equalizer(v17_rx_state_t *s, const complex_t *z, const complex_t *target)
{
    int i;
    int p;
    complex_t ez;
    complex_t z1;

    /* Find the x and y mismatch from the exact constellation position. */
    ez = complex_sub(target, z);
    //span_log(&s->logging, SPAN_LOG_FLOW, "Equalizer error %f\n", sqrt(ez.re*ez.re + ez.im*ez.im));
    ez.re *= s->eq_delta;
    ez.im *= s->eq_delta;

    p = s->eq_step - 1;
    for (i = 0;  i < V17_EQUALIZER_PRE_LEN + 1 + V17_EQUALIZER_POST_LEN;  i++)
    {
        p = (p - 1) & V17_EQUALIZER_MASK;
        z1 = complex_conj(&s->eq_buf[p]);
        z1 = complex_mul(&ez, &z1);
        s->eq_coeff[i] = complex_add(&s->eq_coeff[i], &z1);
        /* Leak a little to tame uncontrolled wandering */
        s->eq_coeff[i].re *= 0.9999f;
        s->eq_coeff[i].im *= 0.9999f;
    }
}
/*- End of function --------------------------------------------------------*/

static int descramble(v17_rx_state_t *s, int in_bit)
{
    int out_bit;

    out_bit = (in_bit ^ (s->scramble_reg >> 17) ^ (s->scramble_reg >> 22)) & 1;
    s->scramble_reg <<= 1;
    if (s->in_training > TRAINING_STAGE_NORMAL_OPERATION  &&  s->in_training < TRAINING_STAGE_TCM_WINDUP)
        s->scramble_reg |= out_bit;
    else
        s->scramble_reg |= (in_bit & 1);
    return out_bit;
}
/*- End of function --------------------------------------------------------*/

static __inline__ int find_quadrant(complex_t *z)
{
    int b1;
    int b2;

    /* Split the space along the two diagonals. */
    b1 = (z->im > z->re);
    b2 = (z->im < -z->re);
    return (b2 << 1) | (b1 ^ b2);
}
/*- End of function --------------------------------------------------------*/

static void track_carrier(v17_rx_state_t *s, const complex_t *z, const complex_t *target)
{
    float error;

    /* For small errors the imaginary part of the difference between the actual and the target
       positions is proportional to the phase error, for any particular target. However, the
       different amplitudes of the various target positions scale things. */
    error = z->im*target->re - z->re*target->im;
    
    s->carrier_phase_rate += (int32_t) (s->carrier_track_i*error);
    s->carrier_phase += (int32_t) (s->carrier_track_p*error);
    span_log(&s->logging, SPAN_LOG_FLOW, "Im = %15.5f   f = %15.5f\n", error, dds_frequencyf(s->carrier_phase_rate));
}
/*- End of function --------------------------------------------------------*/

static __inline__ void put_bit(v17_rx_state_t *s, int bit)
{
    int out_bit;

    /* We need to strip the last part of the training - the test period of all 1s -
       before we let data go to the application. */
    if (s->in_training == TRAINING_STAGE_NORMAL_OPERATION)
    {
        out_bit = descramble(s, bit);
        s->put_bit(s->user_data, out_bit);
    }
    else if (s->in_training == TRAINING_STAGE_TEST_ONES)
    {
        /* The bits during the final stage of training should be all ones. However,
           buggy modems mean you cannot rely on this. Therefore we don't bother
           testing for ones, but just rely on a constellation mismatch measurement. */
        out_bit = descramble(s, bit);
        span_log(&s->logging, SPAN_LOG_FLOW, "A 1 is really %d\n", out_bit);
    }
}
/*- End of function --------------------------------------------------------*/

static int decode_baud(v17_rx_state_t *s, complex_t *z)
{
    static const int diff_code[16] =
    {
        0, 3, 2, 1, 1, 0, 3, 2, 2, 1, 0, 3, 3, 2, 1, 0                         
    };
    static const int tcm_paths[8][4] =
    {
        {0, 6, 2, 4},
        {6, 0, 4, 2},
        {2, 4, 0, 6},
        {4, 2, 6, 0},
        {1, 3, 7, 5},
        {5, 7, 3, 1},
        {7, 5, 1, 3},
        {3, 1, 5, 7}
    };
    int nearest;
    int i;
    int j;
    int k;
    int re;
    int im;
    int raw;
    int constellation_state;
    float distances[8];
    float new_distances[8];
    float min;

    re = (int) ((z->re + 9.0f)*2.0f);
    if (re > 35)
        re = 35;
    else if (re < 0)
        re = 0;
    im = (int) ((z->im + 9.0f)*2.0f);
    if (im > 35)
        im = 35;
    else if (im < 0)
        im = 0;

    /* Find a set of 8 candidate constellation positions, that are the closest
       to the target, with different patterns in the last 3 bits. */
    min = 9999999.0;
    j = 0;
    for (i = 0;  i < 8;  i++)
    {
        nearest = constel_maps[s->space_map][re][im][i];
        distances[i] = (s->constellation[nearest].re - z->re)*(s->constellation[nearest].re - z->re)
                     + (s->constellation[nearest].im - z->im)*(s->constellation[nearest].im - z->im);
        if (min > distances[i])
        {
            min = distances[i];
            j = i;
        }
    }
    /* Use the nearest of these soft-decisions as the basis for DFE */
    constellation_state = constel_maps[s->space_map][re][im][j];
    /* Control the equalizer, carrier tracking, etc. based on the non-trellis
       corrected information. The trellis correct stuff comes out a bit late. */
    track_carrier(s, z, &s->constellation[constellation_state]);
    //tune_equalizer(s, z, &s->constellation[constellation_state]);

    /* Now do the trellis decoding */
    /* Update the minimum accumulated distance to each of the 8 states */
    if (++s->trellis_ptr >= V17_TRELLIS_DEPTH)
        s->trellis_ptr = 0;
    for (i = 0;  i < 4;  i++)
    {
        min = distances[tcm_paths[i][0]] + s->distances[0];
        k = 0;
        for (j = 1;  j < 4;  j++)
        {
            if (min > distances[tcm_paths[i][j]] + s->distances[j << 1])
            {
                min = distances[tcm_paths[i][j]] + s->distances[j << 1];
                k = j;
            }
        }
        /* Use an elementary IIR filter to track the distance to date. */
        new_distances[i] = s->distances[k << 1]*0.9f + distances[tcm_paths[i][k]]*0.1f;
        s->full_path_to_past_state_locations[s->trellis_ptr][i] = constel_maps[s->space_map][re][im][tcm_paths[i][k]];
        s->past_state_locations[s->trellis_ptr][i] = k << 1;
    }
    for (i = 4;  i < 8;  i++)
    {
        min = distances[tcm_paths[i][0]] + s->distances[1];
        k = 0;
        for (j = 1;  j < 4;  j++)
        {
            if (min > distances[tcm_paths[i][j]] + s->distances[(j << 1) + 1])
            {
                min = distances[tcm_paths[i][j]] + s->distances[(j << 1) + 1];
                k = j;
            }
        }
        new_distances[i] = s->distances[(k << 1) + 1]*0.9f + distances[tcm_paths[i][k]]*0.1f;
        s->full_path_to_past_state_locations[s->trellis_ptr][i] = constel_maps[s->space_map][re][im][tcm_paths[i][k]];
        s->past_state_locations[s->trellis_ptr][i] = (k << 1) + 1;
    }
    memcpy(s->distances, new_distances, sizeof(s->distances));

    /* Find the minimum distance to date. This is the start of the path back to the result. */
    min = s->distances[0];
    k = 0;
    for (i = 1;  i < 8;  i++)
    {
        if (min > s->distances[i])
        {
            min = s->distances[i];
            k = i;
        }
    }
    /* Trace back through every time step, starting with the current one, and find the
       state from which the path came one step before. At the end of this search, the
       last state found also points to the constellation point at that state. This is the
       output of the trellis. */
    for (i = 0, j = s->trellis_ptr;  i < V17_TRELLIS_DEPTH - 1;  i++)
    {
        k = s->past_state_locations[j][k];
        if (--j < 0)
            j = V17_TRELLIS_DEPTH - 1;
    }
    nearest = s->full_path_to_past_state_locations[j][k] >> 1;

    /* Differentially decode */
    raw = (nearest & 0x3C) | diff_code[((nearest & 0x03) << 2) | s->diff];
    s->diff = nearest & 0x03;
    for (i = 0;  i < s->bits_per_symbol;  i++)
    {
        put_bit(s, raw);
        raw >>= 1;
    }
    return constellation_state;
}
/*- End of function --------------------------------------------------------*/

int fred = 0;

static void process_half_baud(v17_rx_state_t *s, const complex_t *sample)
{
    static const complex_t cdba[4] =
    {
        { 6.0f,  2.0f},
        {-2.0f,  6.0f},
        { 2.0f, -6.0f},
        {-6.0f, -2.0f}
    };
    complex_t z;
    complex_t zz;
    const complex_t *target;
    float p;
    float q;
    int bit;
    int i;
    int j;
    int32_t angle;
    int32_t ang;
    int constellation_state;

    /* Add a sample to the equalizer's circular buffer, but don't calculate anything
       at this time. */
    s->eq_buf[s->eq_step] = *sample;
    s->eq_step = (s->eq_step + 1) & V17_EQUALIZER_MASK;

    /* On alternate insertions we have a whole baud and must process it. */
    if ((s->baud_phase ^= 1))
        return;

#if 0
    /* Perform a Gardner test for baud alignment on the three most recent samples. */
    p = s->eq_buf[(s->eq_step - 3) & V17_EQUALIZER_MASK].re
      - s->eq_buf[(s->eq_step - 1) & V17_EQUALIZER_MASK].re;
    p *= s->eq_buf[(s->eq_step - 2) & V17_EQUALIZER_MASK].re;
    s->gardner_integrate += (p > 0.0f)  ?  s->gardner_step  :  -s->gardner_step;

    q = s->eq_buf[(s->eq_step - 3) & V17_EQUALIZER_MASK].im
      - s->eq_buf[(s->eq_step - 1) & V17_EQUALIZER_MASK].im;
    q *= s->eq_buf[(s->eq_step - 2) & V17_EQUALIZER_MASK].im;

    s->gardner_integrate += (q > 0.0f)  ?  s->gardner_step  :  -s->gardner_step;
#else
    if ((s->eq_buf[(s->eq_step - 3) & V17_EQUALIZER_MASK].re + s->eq_buf[(s->eq_step - 1) & V17_EQUALIZER_MASK].re) < 2.0*s->eq_buf[(s->eq_step - 2) & V17_EQUALIZER_MASK].re)
        p = -s->gardner_step;
    else
        p = s->gardner_step;
    if (s->eq_buf[(s->eq_step - 3) & V17_EQUALIZER_MASK].re > s->eq_buf[(s->eq_step - 1) & V17_EQUALIZER_MASK].re)
        p = -p;
    s->gardner_integrate += (p > 0.0f)  ?  s->gardner_step  :  -s->gardner_step;

    if ((s->eq_buf[(s->eq_step - 3) & V17_EQUALIZER_MASK].im + s->eq_buf[(s->eq_step - 1) & V17_EQUALIZER_MASK].im) < 2.0*s->eq_buf[(s->eq_step - 2) & V17_EQUALIZER_MASK].im)
        q = -s->gardner_step;
    else
        q = s->gardner_step;
    if (s->eq_buf[(s->eq_step - 3) & V17_EQUALIZER_MASK].im > s->eq_buf[(s->eq_step - 1) & V17_EQUALIZER_MASK].im)
        q = -q;

    s->gardner_integrate += (q > 0.0f)  ?  s->gardner_step  :  -s->gardner_step;
#endif

    if (abs(s->gardner_integrate) >= 16)
    {
        /* This integrate and dump approach avoids rapid changes of the equalizer put step.
           Rapid changes, without hysteresis, are bad. They degrade the equalizer performance
           when the true symbol boundary is close to a sample boundary. */
        s->eq_put_step += (s->gardner_integrate/16);
        s->gardner_total_correction += (s->gardner_integrate/16);
        if (s->qam_report)
            s->qam_report(s->qam_user_data, NULL, NULL, s->gardner_integrate);
        s->gardner_integrate = 0;
    }

    span_log(&s->logging, SPAN_LOG_FLOW, "Gardtest %d %d %d\n", fred++, s->gardner_total_correction, s->gardner_step);

    z = equalizer_get(s);

    constellation_state = 0;
    switch (s->in_training)
    {
    case TRAINING_STAGE_NORMAL_OPERATION:
        /* Normal operation. */
        constellation_state = decode_baud(s, &z);
        target = &s->constellation[constellation_state];
        break;
    case TRAINING_STAGE_SYMBOL_ACQUISITION:
        /* Allow time for the Gardner algorithm to settle the symbol timing. */
        target = &z;
        /* Don't start narrowing the bandwidth of the Gardner algorithm too early.
           Some modems are a bit wobbly when they start sending the signal. Also, we start
           this analysis before our filter buffers have completely filled. */
        if (++s->training_count == 30)
            s->gardner_step = 16;
        else if (s->training_count == 40)
            s->gardner_step = 8;
        else if (s->training_count >= 50)
        {
            /* Record the current phase angle */
            s->angles[0] =
            s->start_angles[0] = arctan2(z.im, z.re);
            /* QAM and Gardner only play nicely with heavy damping, so we need to change to
               a slow rate of symbol timing adaption. However, it must not be so slow that it
               cannot track the worst case timing error specified in V.17. This should be 0.01%,
               but since we might be off in the opposite direction from the source, the total
               error could be higher. */
            s->gardner_step = 8;
            s->in_training = TRAINING_STAGE_LOG_PHASE;
        }
        break;
    case TRAINING_STAGE_LOG_PHASE:
        /* Record the current alternate phase angle */
        target = &z;
        angle = arctan2(z.im, z.re);
        s->training_count = 1;
        if (s->short_train)
        {
            /* We should already know the accurate carrier frequency. All we need to sort
               out is the phase. */
            /* Check if we just saw A or B */
            if ((uint32_t) (angle - s->start_angles[0]) < 0x80000000U)
            {
                angle = s->start_angles[0];
                s->angles[0] = 0x80000000 + 219937506;
                s->angles[1] = 0xC0000000 + 219937506;
            }
            else
            {
                s->training_count = 0;
                s->angles[0] = 0xC0000000 + 219937506;
                s->angles[1] = 0x80000000 + 219937506;
            }
            /* Make a step shift in the phase, to pull it into line. We need to rotate the equalizer
               buffer, as well as the carrier phase, for this to play out nicely. */
            /* angle is now the difference between where A is, and where it should be */
            p = 3.14159f + angle*2.0f*3.14159f/(65536.0f*65536.0f) - 0.321751f;
            span_log(&s->logging, SPAN_LOG_FLOW, "Spin (short) by %.5f rads\n", p);
            zz = complex_set(cosf(p), -sinf(p));
            for (i = 0;  i <= V17_EQUALIZER_MASK;  i++)
                s->eq_buf[i] = complex_mul(&s->eq_buf[i], &zz);
            s->carrier_phase += (0x80000000 + angle - 219937506);

            s->carrier_track_i = 100.0f;
            s->carrier_track_p = 500000.0f;

            s->in_training = TRAINING_STAGE_SHORT_WAIT_FOR_CDBA;
        }
        else
        {
            s->angles[1] =
            s->start_angles[1] = angle;
            s->in_training = TRAINING_STAGE_WAIT_FOR_CDBA;
        }
        break;
    case TRAINING_STAGE_WAIT_FOR_CDBA:
        target = &z;
        angle = arctan2(z.im, z.re);
        /* Look for the initial ABAB sequence to display a phase reversal, which will
           signal the start of the scrambled CDBA segment */
        ang = angle - s->angles[(s->training_count - 1) & 0xF];
        s->angles[(s->training_count + 1) & 0xF] = angle;

        if (s->training_count == 100)
        {
            i = s->training_count;
            /* Avoid the possibility of a divide by zero */
            if (i)
            {
                j = i & 0xF;
                ang = (s->angles[j] - s->start_angles[0])/i
                    + (s->angles[j | 0x1] - s->start_angles[1])/i;
                s->carrier_phase_rate += 3*(ang/20);

                s->start_angles[0] = s->angles[j];
                s->start_angles[1] = s->angles[j | 0x1];
span_log(&s->logging, SPAN_LOG_FLOW, "Angles %x, %x, %x, %x, dist %d\n", s->angles[j], s->start_angles[0], s->angles[j | 0x1], s->start_angles[1], i);
            }
            //span_log(&s->logging, SPAN_LOG_FLOW, "%d %d %d %d %d\n", s->angles[s->training_count & 0xF], s->start_angles[0], s->angles[(s->training_count | 0x1) & 0xF], s->start_angles[1], s->training_count);
            span_log(&s->logging, SPAN_LOG_FLOW, "Coarse carrier frequency %7.2f (%d)\n", dds_frequencyf(s->carrier_phase_rate), s->training_count);
        }
        if ((ang > 0x40000000  ||  ang < -0x40000000)  &&  s->training_count >= 13)
        {
span_log(&s->logging, SPAN_LOG_FLOW, "We seem to have a reversal at symbol %d\n", s->training_count);
            /* We seem to have a phase reversal */
            /* Slam the carrier frequency into line, based on the total phase drift over the last
               section. Use the shift from the odd bits and the shift from the even bits to get
               better jitter suppression. */
            /* TODO: We are supposed to deal with frequancy errors up to +-8Hz. Over 200+
                     symbols that is more than half a cycle. We get confused an do crazy things.
                     We can only cope with errors up to 5Hz right now. We need to implement
                     greater tolerance to be compliant, although it doesn't really matter much
                     these days. */
            /* Step back a few symbols so we don't get ISI distorting things. */
            i = (s->training_count - 8) & ~1;
            /* Avoid the possibility of a divide by zero */
            if (i)
            {
                j = i & 0xF;
                ang = (s->angles[j] - s->start_angles[0])/(i - 100 + 8)
                    + (s->angles[j | 0x1] - s->start_angles[1])/(i - 100 + 8);
                s->carrier_phase_rate += 3*(ang/20);
span_log(&s->logging, SPAN_LOG_FLOW, "Angles %x, %x, %x, %x, dist %d\n", s->angles[j], s->start_angles[0], s->angles[j | 0x1], s->start_angles[1], i);
            }
            //span_log(&s->logging, SPAN_LOG_FLOW, "%d %d %d %d %d\n", s->angles[s->training_count & 0xF], s->start_angles[0], s->angles[(s->training_count | 0x1) & 0xF], s->start_angles[1], s->training_count);
            span_log(&s->logging, SPAN_LOG_FLOW, "Coarse carrier frequency %7.2f (%d)\n", dds_frequencyf(s->carrier_phase_rate), s->training_count);

            /* Make a step shift in the phase, to pull it into line. We need to rotate the equalizer buffer,
               as well as the carrier phase, for this to play out nicely. */
            /* angle is now the difference between where C is, and where it should be */
            p = angle*2.0f*3.14159f/(65536.0f*65536.0f) - 0.321751f;
            span_log(&s->logging, SPAN_LOG_FLOW, "Spin (long) by %.5f rads\n", p);
            zz = complex_set(cosf(p), -sinf(p));
            for (i = 0;  i <= V17_EQUALIZER_MASK;  i++)
                s->eq_buf[i] = complex_mul(&s->eq_buf[i], &zz);
            s->carrier_phase += (angle - 219937506);

            /* We have just seen the first symbol of the scrambled sequence, so skip it. */
            descramble(s, 1);
            descramble(s, 1);
            s->training_count = 1;
            s->gardner_step = 6;
            s->in_training = TRAINING_STAGE_TRAIN_ON_CDBA;
        }
        else if (++s->training_count > V17_TRAINING_SEG_1_LEN)
        {
            /* This is bogus. There are not this many bits in this section
               of a real training sequence. */
            span_log(&s->logging, SPAN_LOG_FLOW, "Training failed (sequence failed)\n");
            /* Park this modem */
            s->put_bit(s->user_data, PUTBIT_TRAINING_FAILED);
            s->in_training = TRAINING_STAGE_PARKED;
        }
        break;
    case TRAINING_STAGE_TRAIN_ON_CDBA:
        /* Train on the scrambled CDBA section. */
        bit = descramble(s, 1);
        bit = (bit << 1) | descramble(s, 1);
        target = &cdba[bit];
        track_carrier(s, &z, target);
        tune_equalizer(s, &z, target);
        if (s->training_count == V17_TRAINING_SEG_2_LEN - 2000)
            s->eq_delta /= 2.0;
        if (++s->training_count >= V17_TRAINING_SEG_2_LEN - 48)
        {
            s->gardner_step = 4;
            s->training_error = 0.0f;
            s->carrier_track_i = 100.0f;
            s->carrier_track_p = 500000.0f;
            s->in_training = TRAINING_STAGE_TRAIN_ON_CDBA_AND_TEST;
        }
        break;
    case TRAINING_STAGE_TRAIN_ON_CDBA_AND_TEST:
        /* Continue training on the scrambled CDBA section, but measure the quality of training too. */
        bit = descramble(s, 1);
        bit = (bit << 1) | descramble(s, 1);

        //span_log(&s->logging, SPAN_LOG_FLOW, "%5d [%15.5f, %15.5f]     [%15.5f, %15.5f]\n", s->training_count, z.re, z.im, cdba[bit].re, cdba[bit].im);
        target = &cdba[bit];
        track_carrier(s, &z, target);
        tune_equalizer(s, &z, target);
        /* Measure the training error */
        zz = complex_sub(&z, &cdba[bit]);
        s->training_error += power(&zz);
        if (++s->training_count >= V17_TRAINING_SEG_2_LEN)
        {
            span_log(&s->logging, SPAN_LOG_FLOW, "Constellation mismatch %f\n", s->training_error);
            if (s->training_error < 100.0f)
            {
                s->training_count = 0;
                s->training_error = 0.0f;
                s->in_training = TRAINING_STAGE_BRIDGE;
            }
            else
            {
                span_log(&s->logging, SPAN_LOG_FLOW, "Training failed (convergence failed)\n");
                /* Park this modem */
                s->put_bit(s->user_data, PUTBIT_TRAINING_FAILED);
                s->in_training = TRAINING_STAGE_PARKED;
            }
        }
        break;
    case TRAINING_STAGE_BRIDGE:
        descramble(s, V17_BRIDGE_WORD >> ((s->training_count & 0x7) << 1));
        descramble(s, V17_BRIDGE_WORD >> (((s->training_count & 0x7) << 1) + 1));
        target = &z;
        if (++s->training_count >= V17_TRAINING_SEG_3_LEN)
        {
            s->training_count = 0;
            s->training_error = 0.0;
            s->in_training = TRAINING_STAGE_TCM_WINDUP;
        }
        break;
    case TRAINING_STAGE_SHORT_WAIT_FOR_CDBA:
        target = &cdba[(s->training_count & 1) + 2];
        angle = arctan2(z.im, z.re);
        /* Look for the initial ABAB sequence to display a phase reversal, which will
           signal the start of the scrambled CDBA segment */
        ang = angle - s->angles[(s->training_count - 1) & 0xF];
        s->angles[(s->training_count + 1) & 0xF] = angle;
        if (ang > 0x40000000  ||  ang < -0x40000000)
        {
            /* We seem to have a phase reversal */
            /* We have just seen the first symbol of the scrambled sequence, so skip it. */
            descramble(s, 1);
            descramble(s, 1);
            s->training_count = 1;
            s->gardner_step = 4;
            s->in_training = TRAINING_STAGE_SHORT_TRAIN_ON_CDBA_AND_TEST;
        }
        else
        {
            track_carrier(s, &z, target);
            if (++s->training_count > V17_TRAINING_SEG_1_LEN)
            {
                /* This is bogus. There are not this many bits in this section
                   of a real training sequence. */
                span_log(&s->logging, SPAN_LOG_FLOW, "Training failed (sequence failed)\n");
                /* Park this modem */
                s->put_bit(s->user_data, PUTBIT_TRAINING_FAILED);
                s->in_training = TRAINING_STAGE_PARKED;
            }
        }
        break;
    case TRAINING_STAGE_SHORT_TRAIN_ON_CDBA_AND_TEST:
        /* Short retrain on the scrambled CDBA section, but measure the quality of training too. */
        bit = descramble(s, 1);
        bit = (bit << 1) | descramble(s, 1);
        //span_log(&s->logging, SPAN_LOG_FLOW, "%5d [%15.5f, %15.5f]     [%15.5f, %15.5f] %d\n", s->training_count, z.re, z.im, cdba[bit].re, cdba[bit].im, arctan2(z.im, z.re));
        target = &cdba[bit];
        track_carrier(s, &z, target);
        //tune_equalizer(s, &z, target);
        /* Measure the training error */
        if (s->training_count > 8)
        {
            zz = complex_sub(&z, &cdba[bit]);
            s->training_error += power(&zz);
        }
        if (++s->training_count >= V17_TRAINING_SHORT_SEG_2_LEN)
        {
            s->carrier_track_i = 100.0f;
            s->carrier_track_p = 500000.0f;
            span_log(&s->logging, SPAN_LOG_FLOW, "Short training error %f\n", s->training_error);
            if (s->training_error < 4000.0f)
            {
                s->training_count = 0;
                s->in_training = TRAINING_STAGE_TCM_WINDUP;
            }
            else
            {
                span_log(&s->logging, SPAN_LOG_FLOW, "Short training failed (convergence failed)\n");
                /* Park this modem */
                s->put_bit(s->user_data, PUTBIT_TRAINING_FAILED);
                s->in_training = TRAINING_STAGE_PARKED;
            }
        }
        break;
    case TRAINING_STAGE_TCM_WINDUP:
        /* We need to wait 15 bauds while the trellis fills up. */
        //span_log(&s->logging, SPAN_LOG_FLOW, "%5d %15.5f, %15.5f\n", s->training_count, z.re, z.im);
        constellation_state = decode_baud(s, &z);
        target = &s->constellation[constellation_state];
        /* Measure the training error */
        zz = complex_sub(&z, target);
        s->training_error += power(&zz);
        if (++s->training_count >= V17_TRAINING_SEG_4A_LEN)
        {
            s->training_count = 0;
            s->training_error = 0.0;
            /* Restart the differential decoder */
            s->diff = (s->short_train)  ?  0  :  1;
            s->in_training = TRAINING_STAGE_TEST_ONES;
        }
        break;
    case TRAINING_STAGE_TEST_ONES:
        /* We are in the test phase, where we check that we can receive reliably.
           We should get a run of 1's, 48 symbols long. */
        //span_log(&s->logging, SPAN_LOG_FLOW, "%5d %15.5f, %15.5f\n", s->training_count, z.re, z.im);
        constellation_state = decode_baud(s, &z);
        target = &s->constellation[constellation_state];
        /* Measure the training error */
        zz = complex_sub(&z, target);
        s->training_error += power(&zz);
        if (++s->training_count >= V17_TRAINING_SEG_4_LEN)
        {
            if (s->training_error < 25.0f)
            {
                /* We are up and running */
                span_log(&s->logging, SPAN_LOG_FLOW, "Training succeeded (constellation mismatch %f)\n", s->training_error);
                s->put_bit(s->user_data, PUTBIT_TRAINING_SUCCEEDED);
                /* Apply some lag to the carrier off condition, to ensure the last few bits get pushed through
                   the processing. */
                s->carrier_present = 60;
                equalizer_save(s);
                s->carrier_phase_rate_save = s->carrier_phase_rate;
                s->agc_scaling_save = s->agc_scaling;
                s->short_train = TRUE;
                s->in_training = TRAINING_STAGE_NORMAL_OPERATION;
            }
            else
            {
                /* Training has failed */
                span_log(&s->logging, SPAN_LOG_FLOW, "Training failed (constellation mismatch %f)\n", s->training_error);
                /* Park this modem */
                s->put_bit(s->user_data, PUTBIT_TRAINING_FAILED);
                s->in_training = TRAINING_STAGE_PARKED;
            }
        }
        break;
    case TRAINING_STAGE_PARKED:
    default:
        /* We failed to train! */
        /* Park here until the carrier drops. */
        target = &z;
        break;
    }
    if (s->qam_report)
        s->qam_report(s->qam_user_data, &z, target, constellation_state);
}
/*- End of function --------------------------------------------------------*/

void v17_rx(v17_rx_state_t *s, const int16_t *amp, int len)
{
    int i;
    int j;
    int step;
    complex_t z;
    complex_t zz;
    complex_t sample;
    int32_t power;
    float x;

    x = 0.0;
    for (i = 0;  i < len;  i++)
    {
        s->rrc_filter[s->rrc_filter_step] =
        s->rrc_filter[s->rrc_filter_step + V17RX_FILTER_STEPS] = amp[i];
        if (++s->rrc_filter_step >= V17RX_FILTER_STEPS)
            s->rrc_filter_step = 0;

        /* There should be no DC in the signal, but sometimes there is.
           We need to measure the power with the DC blocked, but not using
           a slow to respond DC blocker. Use the most elementary HPF. */
        power = power_meter_update(&(s->power), (amp[i] - s->last_sample) >> 1);
        s->last_sample = amp[i];
        if (s->carrier_present)
        {
            /* Look for power below turnoff threshold to turn the carrier off */
            if (power < s->carrier_off_power)
            {
                if (--s->carrier_present <= 0)
                {
                    /* Count down a short delay, to ensure we push the last
                       few bits through the filters before stopping. */
                    v17_rx_restart(s, s->bit_rate, s->short_train);
                    s->put_bit(s->user_data, PUTBIT_CARRIER_DOWN);
                    continue;
                }
            }
        }
        else
        {
            /* Look for power exceeding turnon threshold to turn the carrier on */
            if (power < s->carrier_on_power)
                continue;
            s->carrier_present = 1;
            s->put_bit(s->user_data, PUTBIT_CARRIER_UP);
        }
        if (s->in_training != TRAINING_STAGE_PARKED)
        {
            /* Only spend effort processing this data if the modem is not
               parked, after training failure. */
            z = dds_complexf(&(s->carrier_phase), s->carrier_phase_rate);

            /* Put things into the equalization buffer at T/2 rate. The Gardner algorithm
               will fiddle the step to align this with the symbols. */
            if ((s->eq_put_step -= PULSESHAPER_COEFF_SETS) <= 0)
            {
                if (s->in_training == TRAINING_STAGE_SYMBOL_ACQUISITION)
                {
                    /* Only AGC during the initial training */
                    s->agc_scaling = (1.0f/PULSESHAPER_GAIN)*6.5f/sqrtf(power);
                }
                /* Pulse shape while still at the carrier frequency, using a quadrature
                   pair of filters. This results in a properly bandpass filtered complex
                   signal, which can be brought directly to bandband by complex mixing.
                   No further filtering, to remove mixer harmonics, is needed. */
                step = -s->eq_put_step;
                if (step > PULSESHAPER_COEFF_SETS - 1)
                    step = PULSESHAPER_COEFF_SETS - 1;
                s->eq_put_step += PULSESHAPER_COEFF_SETS*10/(3*2);
                zz.re = pulseshaper[step][0].re*s->rrc_filter[s->rrc_filter_step];
                zz.im = pulseshaper[step][0].im*s->rrc_filter[s->rrc_filter_step];
                for (j = 1;  j < V17RX_FILTER_STEPS;  j++)
                {
                    zz.re += pulseshaper[step][j].re*s->rrc_filter[j + s->rrc_filter_step];
                    zz.im += pulseshaper[step][j].im*s->rrc_filter[j + s->rrc_filter_step];
                }
                sample.re = zz.re*s->agc_scaling;
                sample.im = zz.im*s->agc_scaling;
                /* Shift to baseband - since this is done in a full complex form, the
                   result is clean, and requires no further filtering apart from the
                   equalizer. */
                zz.re = sample.re*z.re - sample.im*z.im;
                zz.im = -sample.re*z.im - sample.im*z.re;
                process_half_baud(s, &zz);
            }
        }
//printf("State %d\n", s->in_training);
//fprintf(stderr, "State %d\n", s->in_training);
    }
}
/*- End of function --------------------------------------------------------*/

void v17_rx_set_put_bit(v17_rx_state_t *s, put_bit_func_t put_bit, void *user_data)
{
    s->put_bit = put_bit;
    s->user_data = user_data;
}
/*- End of function --------------------------------------------------------*/

int v17_rx_restart(v17_rx_state_t *s, int rate, int short_train)
{
    int i;
    int j;

    span_log(&s->logging, SPAN_LOG_FLOW, "Restarting V.17\n");
    switch (rate)
    {
    case 14400:
        s->constellation = v17_14400_constellation;
        s->space_map = 0;
        s->bits_per_symbol = 6;
        break;
    case 12000:
        s->constellation = v17_12000_constellation;
        s->space_map = 1;
        s->bits_per_symbol = 5;
        break;
    case 9600:
        s->constellation = v17_9600_constellation;
        s->space_map = 2;
        s->bits_per_symbol = 4;
        break;
    case 7200:
        s->constellation = v17_7200_constellation;
        s->space_map = 3;
        s->bits_per_symbol = 3;
        break;
    default:
        return -1;
    }
    s->bit_rate = rate;
    memset(s->rrc_filter, 0, sizeof(s->rrc_filter));
    s->rrc_filter_step = 0;

    s->diff = 1;
    s->scramble_reg = 0x2ECDD5;
    s->in_training = TRAINING_STAGE_SYMBOL_ACQUISITION;
    s->training_count = 0;
    s->carrier_present = 0;
    s->short_train = short_train;

    /* Initialise the TCM decoder parameters. */
    /* The accumulated distance vectors are set so state zero starts
       at a value of zero, and all others start larger. This forces the
       initial paths to merge at the zero states. */
    for (i = 0;  i < 8;  i++)
    {
        s->distances[i] = 99.0;
        for (j = 0;  j < 16;  j++)
        {
            s->full_path_to_past_state_locations[j][i] = 0;
            s->past_state_locations[j][i] = 0;
        }
    }
    s->distances[0] = 0;
    s->trellis_ptr = 14;

    span_log(&s->logging, SPAN_LOG_FLOW, "Phase rates %f %f\n", dds_frequencyf(s->carrier_phase_rate), dds_frequencyf(s->carrier_phase_rate_save));
    s->carrier_phase = 0;
    s->carrier_track_i = 500.0f;
    s->carrier_track_p = 40000.0f;
    power_meter_init(&(s->power), 4);

//printf("Restart %d\n", s->short_train);
    if (s->short_train)
    {
        s->carrier_phase_rate = s->carrier_phase_rate_save;
        s->agc_scaling = s->agc_scaling_save;
        equalizer_restore(s);
    }
    else
    {
        s->carrier_phase_rate = dds_phase_ratef(1800.0f);
        s->agc_scaling = 0.0005f;
        equalizer_reset(s);
    }
    s->last_sample = 0;

    s->gardner_integrate = 0;
    s->gardner_total_correction = 0;
    /* Start with very big Gardner steps, until we start to pull in the symbol timing. */
    s->gardner_step = 64;
    s->baud_phase = 0;
    
    return 0;
}
/*- End of function --------------------------------------------------------*/

v17_rx_state_t *v17_rx_init(v17_rx_state_t *s, int rate, put_bit_func_t put_bit, void *user_data)
{
    if (s == NULL)
    {
        if ((s = (v17_rx_state_t *) malloc(sizeof(*s))) == NULL)
            return NULL;
    }
    memset(s, 0, sizeof(*s));
    s->put_bit = put_bit;
    s->user_data = user_data;
    s->short_train = FALSE;
    v17_rx_signal_cutoff(s, -45.5);
    s->agc_scaling = 0.0005f;
    s->agc_scaling_save = 0.0005f;
    s->carrier_phase_rate_save = dds_phase_ratef(1800.0f);
    span_log_init(&s->logging, SPAN_LOG_NONE, NULL);
    span_log_set_protocol(&s->logging, "V.17");

    v17_rx_restart(s, rate, s->short_train);
    return s;
}
/*- End of function --------------------------------------------------------*/

int v17_rx_release(v17_rx_state_t *s)
{
    free(s);
    return 0;
}
/*- End of function --------------------------------------------------------*/

void v17_rx_set_qam_report_handler(v17_rx_state_t *s, qam_report_handler_t *handler, void *user_data)
{
    s->qam_report = handler;
    s->qam_user_data = user_data;
}
/*- End of function --------------------------------------------------------*/
/*- End of file ------------------------------------------------------------*/
