/*
 * SpanDSP - a series of DSP components for telephony
 *
 * complex_dds.c
 *
 * Written by Steve Underwood <steveu@coppice.org>
 *
 * Copyright (C) 2003 Steve Underwood
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: dds_float.c,v 1.1 2007/05/12 12:25:38 steveu Exp $
 */

/*! \file */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <inttypes.h>
#if defined(HAVE_TGMATH_H)
#include <tgmath.h>
#endif
#if defined(HAVE_MATH_H)
#include <math.h>
#endif

#include "spandsp/telephony.h"
#include "spandsp/complex.h"
#include "spandsp/dds.h"

#define SLENK       11
#define SINELEN     (1 << SLENK)

/* Precreating this table allows it to be in const memory, which might
   have some performance advantage. */
static const float sine_table[SINELEN] =
{
     0.00000000f,
     0.00306796f,
     0.00613588f,
     0.00920375f,
     0.01227154f,
     0.01533921f,
     0.01840673f,
     0.02147408f,
     0.02454123f,
     0.02760815f,
     0.03067480f,
     0.03374117f,
     0.03680722f,
     0.03987293f,
     0.04293826f,
     0.04600318f,
     0.04906767f,
     0.05213170f,
     0.05519524f,
     0.05825826f,
     0.06132074f,
     0.06438263f,
     0.06744392f,
     0.07050457f,
     0.07356456f,
     0.07662386f,
     0.07968244f,
     0.08274026f,
     0.08579731f,
     0.08885355f,
     0.09190896f,
     0.09496350f,
     0.09801714f,
     0.10106986f,
     0.10412163f,
     0.10717242f,
     0.11022221f,
     0.11327095f,
     0.11631863f,
     0.11936521f,
     0.12241068f,
     0.12545498f,
     0.12849811f,
     0.13154003f,
     0.13458071f,
     0.13762012f,
     0.14065824f,
     0.14369503f,
     0.14673047f,
     0.14976453f,
     0.15279719f,
     0.15582840f,
     0.15885814f,
     0.16188639f,
     0.16491312f,
     0.16793829f,
     0.17096189f,
     0.17398387f,
     0.17700422f,
     0.18002290f,
     0.18303989f,
     0.18605515f,
     0.18906866f,
     0.19208040f,
     0.19509032f,
     0.19809841f,
     0.20110463f,
     0.20410897f,
     0.20711138f,
     0.21011184f,
     0.21311032f,
     0.21610680f,
     0.21910124f,
     0.22209362f,
     0.22508391f,
     0.22807208f,
     0.23105811f,
     0.23404196f,
     0.23702361f,
     0.24000302f,
     0.24298018f,
     0.24595505f,
     0.24892761f,
     0.25189782f,
     0.25486566f,
     0.25783110f,
     0.26079412f,
     0.26375468f,
     0.26671276f,
     0.26966833f,
     0.27262136f,
     0.27557182f,
     0.27851969f,
     0.28146494f,
     0.28440754f,
     0.28734746f,
     0.29028468f,
     0.29321916f,
     0.29615089f,
     0.29907983f,
     0.30200595f,
     0.30492923f,
     0.30784964f,
     0.31076715f,
     0.31368174f,
     0.31659338f,
     0.31950203f,
     0.32240768f,
     0.32531029f,
     0.32820984f,
     0.33110631f,
     0.33399965f,
     0.33688985f,
     0.33977688f,
     0.34266072f,
     0.34554132f,
     0.34841868f,
     0.35129276f,
     0.35416353f,
     0.35703096f,
     0.35989504f,
     0.36275572f,
     0.36561300f,
     0.36846683f,
     0.37131719f,
     0.37416406f,
     0.37700741f,
     0.37984721f,
     0.38268343f,
     0.38551605f,
     0.38834505f,
     0.39117038f,
     0.39399204f,
     0.39680999f,
     0.39962420f,
     0.40243465f,
     0.40524131f,
     0.40804416f,
     0.41084317f,
     0.41363831f,
     0.41642956f,
     0.41921689f,
     0.42200027f,
     0.42477968f,
     0.42755509f,
     0.43032648f,
     0.43309382f,
     0.43585708f,
     0.43861624f,
     0.44137127f,
     0.44412214f,
     0.44686884f,
     0.44961133f,
     0.45234959f,
     0.45508359f,
     0.45781330f,
     0.46053871f,
     0.46325978f,
     0.46597650f,
     0.46868882f,
     0.47139674f,
     0.47410021f,
     0.47679923f,
     0.47949376f,
     0.48218377f,
     0.48486925f,
     0.48755016f,
     0.49022648f,
     0.49289819f,
     0.49556526f,
     0.49822767f,
     0.50088538f,
     0.50353838f,
     0.50618665f,
     0.50883014f,
     0.51146885f,
     0.51410274f,
     0.51673180f,
     0.51935599f,
     0.52197529f,
     0.52458968f,
     0.52719913f,
     0.52980362f,
     0.53240313f,
     0.53499762f,
     0.53758708f,
     0.54017147f,
     0.54275078f,
     0.54532499f,
     0.54789406f,
     0.55045797f,
     0.55301671f,
     0.55557023f,
     0.55811853f,
     0.56066158f,
     0.56319934f,
     0.56573181f,
     0.56825895f,
     0.57078075f,
     0.57329717f,
     0.57580819f,
     0.57831380f,
     0.58081396f,
     0.58330865f,
     0.58579786f,
     0.58828155f,
     0.59075970f,
     0.59323230f,
     0.59569930f,
     0.59816071f,
     0.60061648f,
     0.60306660f,
     0.60551104f,
     0.60794978f,
     0.61038281f,
     0.61281008f,
     0.61523159f,
     0.61764731f,
     0.62005721f,
     0.62246128f,
     0.62485949f,
     0.62725182f,
     0.62963824f,
     0.63201874f,
     0.63439328f,
     0.63676186f,
     0.63912444f,
     0.64148101f,
     0.64383154f,
     0.64617601f,
     0.64851440f,
     0.65084668f,
     0.65317284f,
     0.65549285f,
     0.65780669f,
     0.66011434f,
     0.66241578f,
     0.66471098f,
     0.66699992f,
     0.66928259f,
     0.67155895f,
     0.67382900f,
     0.67609270f,
     0.67835004f,
     0.68060100f,
     0.68284555f,
     0.68508367f,
     0.68731534f,
     0.68954054f,
     0.69175926f,
     0.69397146f,
     0.69617713f,
     0.69837625f,
     0.70056879f,
     0.70275474f,
     0.70493408f,
     0.70710678f,
     0.70927283f,
     0.71143220f,
     0.71358487f,
     0.71573083f,
     0.71787005f,
     0.72000251f,
     0.72212819f,
     0.72424708f,
     0.72635916f,
     0.72846439f,
     0.73056277f,
     0.73265427f,
     0.73473888f,
     0.73681657f,
     0.73888732f,
     0.74095113f,
     0.74300795f,
     0.74505779f,
     0.74710061f,
     0.74913639f,
     0.75116513f,
     0.75318680f,
     0.75520138f,
     0.75720885f,
     0.75920919f,
     0.76120239f,
     0.76318842f,
     0.76516727f,
     0.76713891f,
     0.76910334f,
     0.77106052f,
     0.77301045f,
     0.77495311f,
     0.77688847f,
     0.77881651f,
     0.78073723f,
     0.78265060f,
     0.78455660f,
     0.78645521f,
     0.78834643f,
     0.79023022f,
     0.79210658f,
     0.79397548f,
     0.79583690f,
     0.79769084f,
     0.79953727f,
     0.80137617f,
     0.80320753f,
     0.80503133f,
     0.80684755f,
     0.80865618f,
     0.81045720f,
     0.81225059f,
     0.81403633f,
     0.81581441f,
     0.81758481f,
     0.81934752f,
     0.82110251f,
     0.82284978f,
     0.82458930f,
     0.82632106f,
     0.82804505f,
     0.82976123f,
     0.83146961f,
     0.83317016f,
     0.83486287f,
     0.83654773f,
     0.83822471f,
     0.83989379f,
     0.84155498f,
     0.84320824f,
     0.84485357f,
     0.84649094f,
     0.84812034f,
     0.84974177f,
     0.85135519f,
     0.85296060f,
     0.85455799f,
     0.85614733f,
     0.85772861f,
     0.85930182f,
     0.86086694f,
     0.86242396f,
     0.86397286f,
     0.86551362f,
     0.86704625f,
     0.86857071f,
     0.87008699f,
     0.87159509f,
     0.87309498f,
     0.87458665f,
     0.87607009f,
     0.87754529f,
     0.87901223f,
     0.88047089f,
     0.88192126f,
     0.88336334f,
     0.88479710f,
     0.88622253f,
     0.88763962f,
     0.88904836f,
     0.89044872f,
     0.89184071f,
     0.89322430f,
     0.89459949f,
     0.89596625f,
     0.89732458f,
     0.89867447f,
     0.90001589f,
     0.90134885f,
     0.90267332f,
     0.90398929f,
     0.90529676f,
     0.90659570f,
     0.90788612f,
     0.90916798f,
     0.91044129f,
     0.91170603f,
     0.91296219f,
     0.91420976f,
     0.91544872f,
     0.91667906f,
     0.91790078f,
     0.91911385f,
     0.92031828f,
     0.92151404f,
     0.92270113f,
     0.92387953f,
     0.92504924f,
     0.92621024f,
     0.92736253f,
     0.92850608f,
     0.92964090f,
     0.93076696f,
     0.93188427f,
     0.93299280f,
     0.93409255f,
     0.93518351f,
     0.93626567f,
     0.93733901f,
     0.93840353f,
     0.93945922f,
     0.94050607f,
     0.94154407f,
     0.94257320f,
     0.94359346f,
     0.94460484f,
     0.94560733f,
     0.94660091f,
     0.94758559f,
     0.94856135f,
     0.94952818f,
     0.95048607f,
     0.95143502f,
     0.95237501f,
     0.95330604f,
     0.95422810f,
     0.95514117f,
     0.95604525f,
     0.95694034f,
     0.95782641f,
     0.95870347f,
     0.95957151f,
     0.96043052f,
     0.96128049f,
     0.96212140f,
     0.96295327f,
     0.96377607f,
     0.96458979f,
     0.96539444f,
     0.96619000f,
     0.96697647f,
     0.96775384f,
     0.96852209f,
     0.96928124f,
     0.97003125f,
     0.97077214f,
     0.97150389f,
     0.97222650f,
     0.97293995f,
     0.97364425f,
     0.97433938f,
     0.97502535f,
     0.97570213f,
     0.97636973f,
     0.97702814f,
     0.97767736f,
     0.97831737f,
     0.97894818f,
     0.97956977f,
     0.98018214f,
     0.98078528f,
     0.98137919f,
     0.98196387f,
     0.98253930f,
     0.98310549f,
     0.98366242f,
     0.98421009f,
     0.98474850f,
     0.98527764f,
     0.98579751f,
     0.98630810f,
     0.98680940f,
     0.98730142f,
     0.98778414f,
     0.98825757f,
     0.98872169f,
     0.98917651f,
     0.98962202f,
     0.99005821f,
     0.99048508f,
     0.99090264f,
     0.99131086f,
     0.99170975f,
     0.99209931f,
     0.99247953f,
     0.99285041f,
     0.99321195f,
     0.99356414f,
     0.99390697f,
     0.99424045f,
     0.99456457f,
     0.99487933f,
     0.99518473f,
     0.99548076f,
     0.99576741f,
     0.99604470f,
     0.99631261f,
     0.99657115f,
     0.99682030f,
     0.99706007f,
     0.99729046f,
     0.99751146f,
     0.99772307f,
     0.99792529f,
     0.99811811f,
     0.99830154f,
     0.99847558f,
     0.99864022f,
     0.99879546f,
     0.99894129f,
     0.99907773f,
     0.99920476f,
     0.99932238f,
     0.99943060f,
     0.99952942f,
     0.99961882f,
     0.99969882f,
     0.99976941f,
     0.99983058f,
     0.99988235f,
     0.99992470f,
     0.99995764f,
     0.99998118f,
     0.99999529f,
     1.00000000f,
     0.99999529f,
     0.99998118f,
     0.99995764f,
     0.99992470f,
     0.99988235f,
     0.99983058f,
     0.99976941f,
     0.99969882f,
     0.99961882f,
     0.99952942f,
     0.99943060f,
     0.99932238f,
     0.99920476f,
     0.99907773f,
     0.99894129f,
     0.99879546f,
     0.99864022f,
     0.99847558f,
     0.99830154f,
     0.99811811f,
     0.99792529f,
     0.99772307f,
     0.99751146f,
     0.99729046f,
     0.99706007f,
     0.99682030f,
     0.99657115f,
     0.99631261f,
     0.99604470f,
     0.99576741f,
     0.99548076f,
     0.99518473f,
     0.99487933f,
     0.99456457f,
     0.99424045f,
     0.99390697f,
     0.99356414f,
     0.99321195f,
     0.99285041f,
     0.99247953f,
     0.99209931f,
     0.99170975f,
     0.99131086f,
     0.99090264f,
     0.99048508f,
     0.99005821f,
     0.98962202f,
     0.98917651f,
     0.98872169f,
     0.98825757f,
     0.98778414f,
     0.98730142f,
     0.98680940f,
     0.98630810f,
     0.98579751f,
     0.98527764f,
     0.98474850f,
     0.98421009f,
     0.98366242f,
     0.98310549f,
     0.98253930f,
     0.98196387f,
     0.98137919f,
     0.98078528f,
     0.98018214f,
     0.97956977f,
     0.97894818f,
     0.97831737f,
     0.97767736f,
     0.97702814f,
     0.97636973f,
     0.97570213f,
     0.97502535f,
     0.97433938f,
     0.97364425f,
     0.97293995f,
     0.97222650f,
     0.97150389f,
     0.97077214f,
     0.97003125f,
     0.96928124f,
     0.96852209f,
     0.96775384f,
     0.96697647f,
     0.96619000f,
     0.96539444f,
     0.96458979f,
     0.96377607f,
     0.96295327f,
     0.96212140f,
     0.96128049f,
     0.96043052f,
     0.95957151f,
     0.95870347f,
     0.95782641f,
     0.95694034f,
     0.95604525f,
     0.95514117f,
     0.95422810f,
     0.95330604f,
     0.95237501f,
     0.95143502f,
     0.95048607f,
     0.94952818f,
     0.94856135f,
     0.94758559f,
     0.94660091f,
     0.94560733f,
     0.94460484f,
     0.94359346f,
     0.94257320f,
     0.94154407f,
     0.94050607f,
     0.93945922f,
     0.93840353f,
     0.93733901f,
     0.93626567f,
     0.93518351f,
     0.93409255f,
     0.93299280f,
     0.93188427f,
     0.93076696f,
     0.92964090f,
     0.92850608f,
     0.92736253f,
     0.92621024f,
     0.92504924f,
     0.92387953f,
     0.92270113f,
     0.92151404f,
     0.92031828f,
     0.91911385f,
     0.91790078f,
     0.91667906f,
     0.91544872f,
     0.91420976f,
     0.91296219f,
     0.91170603f,
     0.91044129f,
     0.90916798f,
     0.90788612f,
     0.90659570f,
     0.90529676f,
     0.90398929f,
     0.90267332f,
     0.90134885f,
     0.90001589f,
     0.89867447f,
     0.89732458f,
     0.89596625f,
     0.89459949f,
     0.89322430f,
     0.89184071f,
     0.89044872f,
     0.88904836f,
     0.88763962f,
     0.88622253f,
     0.88479710f,
     0.88336334f,
     0.88192126f,
     0.88047089f,
     0.87901223f,
     0.87754529f,
     0.87607009f,
     0.87458665f,
     0.87309498f,
     0.87159509f,
     0.87008699f,
     0.86857071f,
     0.86704625f,
     0.86551362f,
     0.86397286f,
     0.86242396f,
     0.86086694f,
     0.85930182f,
     0.85772861f,
     0.85614733f,
     0.85455799f,
     0.85296060f,
     0.85135519f,
     0.84974177f,
     0.84812034f,
     0.84649094f,
     0.84485357f,
     0.84320824f,
     0.84155498f,
     0.83989379f,
     0.83822471f,
     0.83654773f,
     0.83486287f,
     0.83317016f,
     0.83146961f,
     0.82976123f,
     0.82804505f,
     0.82632106f,
     0.82458930f,
     0.82284978f,
     0.82110251f,
     0.81934752f,
     0.81758481f,
     0.81581441f,
     0.81403633f,
     0.81225059f,
     0.81045720f,
     0.80865618f,
     0.80684755f,
     0.80503133f,
     0.80320753f,
     0.80137617f,
     0.79953727f,
     0.79769084f,
     0.79583690f,
     0.79397548f,
     0.79210658f,
     0.79023022f,
     0.78834643f,
     0.78645521f,
     0.78455660f,
     0.78265060f,
     0.78073723f,
     0.77881651f,
     0.77688847f,
     0.77495311f,
     0.77301045f,
     0.77106052f,
     0.76910334f,
     0.76713891f,
     0.76516727f,
     0.76318842f,
     0.76120239f,
     0.75920919f,
     0.75720885f,
     0.75520138f,
     0.75318680f,
     0.75116513f,
     0.74913639f,
     0.74710061f,
     0.74505779f,
     0.74300795f,
     0.74095113f,
     0.73888732f,
     0.73681657f,
     0.73473888f,
     0.73265427f,
     0.73056277f,
     0.72846439f,
     0.72635916f,
     0.72424708f,
     0.72212819f,
     0.72000251f,
     0.71787005f,
     0.71573083f,
     0.71358487f,
     0.71143220f,
     0.70927283f,
     0.70710678f,
     0.70493408f,
     0.70275474f,
     0.70056879f,
     0.69837625f,
     0.69617713f,
     0.69397146f,
     0.69175926f,
     0.68954054f,
     0.68731534f,
     0.68508367f,
     0.68284555f,
     0.68060100f,
     0.67835004f,
     0.67609270f,
     0.67382900f,
     0.67155895f,
     0.66928259f,
     0.66699992f,
     0.66471098f,
     0.66241578f,
     0.66011434f,
     0.65780669f,
     0.65549285f,
     0.65317284f,
     0.65084668f,
     0.64851440f,
     0.64617601f,
     0.64383154f,
     0.64148101f,
     0.63912444f,
     0.63676186f,
     0.63439328f,
     0.63201874f,
     0.62963824f,
     0.62725182f,
     0.62485949f,
     0.62246128f,
     0.62005721f,
     0.61764731f,
     0.61523159f,
     0.61281008f,
     0.61038281f,
     0.60794978f,
     0.60551104f,
     0.60306660f,
     0.60061648f,
     0.59816071f,
     0.59569930f,
     0.59323230f,
     0.59075970f,
     0.58828155f,
     0.58579786f,
     0.58330865f,
     0.58081396f,
     0.57831380f,
     0.57580819f,
     0.57329717f,
     0.57078075f,
     0.56825895f,
     0.56573181f,
     0.56319934f,
     0.56066158f,
     0.55811853f,
     0.55557023f,
     0.55301671f,
     0.55045797f,
     0.54789406f,
     0.54532499f,
     0.54275078f,
     0.54017147f,
     0.53758708f,
     0.53499762f,
     0.53240313f,
     0.52980362f,
     0.52719913f,
     0.52458968f,
     0.52197529f,
     0.51935599f,
     0.51673180f,
     0.51410274f,
     0.51146885f,
     0.50883014f,
     0.50618665f,
     0.50353838f,
     0.50088538f,
     0.49822767f,
     0.49556526f,
     0.49289819f,
     0.49022648f,
     0.48755016f,
     0.48486925f,
     0.48218377f,
     0.47949376f,
     0.47679923f,
     0.47410021f,
     0.47139674f,
     0.46868882f,
     0.46597650f,
     0.46325978f,
     0.46053871f,
     0.45781330f,
     0.45508359f,
     0.45234959f,
     0.44961133f,
     0.44686884f,
     0.44412214f,
     0.44137127f,
     0.43861624f,
     0.43585708f,
     0.43309382f,
     0.43032648f,
     0.42755509f,
     0.42477968f,
     0.42200027f,
     0.41921689f,
     0.41642956f,
     0.41363831f,
     0.41084317f,
     0.40804416f,
     0.40524131f,
     0.40243465f,
     0.39962420f,
     0.39680999f,
     0.39399204f,
     0.39117038f,
     0.38834505f,
     0.38551605f,
     0.38268343f,
     0.37984721f,
     0.37700741f,
     0.37416406f,
     0.37131719f,
     0.36846683f,
     0.36561300f,
     0.36275572f,
     0.35989504f,
     0.35703096f,
     0.35416353f,
     0.35129276f,
     0.34841868f,
     0.34554132f,
     0.34266072f,
     0.33977688f,
     0.33688985f,
     0.33399965f,
     0.33110631f,
     0.32820984f,
     0.32531029f,
     0.32240768f,
     0.31950203f,
     0.31659338f,
     0.31368174f,
     0.31076715f,
     0.30784964f,
     0.30492923f,
     0.30200595f,
     0.29907983f,
     0.29615089f,
     0.29321916f,
     0.29028468f,
     0.28734746f,
     0.28440754f,
     0.28146494f,
     0.27851969f,
     0.27557182f,
     0.27262136f,
     0.26966833f,
     0.26671276f,
     0.26375468f,
     0.26079412f,
     0.25783110f,
     0.25486566f,
     0.25189782f,
     0.24892761f,
     0.24595505f,
     0.24298018f,
     0.24000302f,
     0.23702361f,
     0.23404196f,
     0.23105811f,
     0.22807208f,
     0.22508391f,
     0.22209362f,
     0.21910124f,
     0.21610680f,
     0.21311032f,
     0.21011184f,
     0.20711138f,
     0.20410897f,
     0.20110463f,
     0.19809841f,
     0.19509032f,
     0.19208040f,
     0.18906866f,
     0.18605515f,
     0.18303989f,
     0.18002290f,
     0.17700422f,
     0.17398387f,
     0.17096189f,
     0.16793829f,
     0.16491312f,
     0.16188639f,
     0.15885814f,
     0.15582840f,
     0.15279719f,
     0.14976453f,
     0.14673047f,
     0.14369503f,
     0.14065824f,
     0.13762012f,
     0.13458071f,
     0.13154003f,
     0.12849811f,
     0.12545498f,
     0.12241068f,
     0.11936521f,
     0.11631863f,
     0.11327095f,
     0.11022221f,
     0.10717242f,
     0.10412163f,
     0.10106986f,
     0.09801714f,
     0.09496350f,
     0.09190896f,
     0.08885355f,
     0.08579731f,
     0.08274026f,
     0.07968244f,
     0.07662386f,
     0.07356456f,
     0.07050457f,
     0.06744392f,
     0.06438263f,
     0.06132074f,
     0.05825826f,
     0.05519524f,
     0.05213170f,
     0.04906767f,
     0.04600318f,
     0.04293826f,
     0.03987293f,
     0.03680722f,
     0.03374117f,
     0.03067480f,
     0.02760815f,
     0.02454123f,
     0.02147408f,
     0.01840673f,
     0.01533921f,
     0.01227154f,
     0.00920375f,
     0.00613588f,
     0.00306796f,
     0.00000000f,
    -0.00306796f,
    -0.00613588f,
    -0.00920375f,
    -0.01227154f,
    -0.01533921f,
    -0.01840673f,
    -0.02147408f,
    -0.02454123f,
    -0.02760815f,
    -0.03067480f,
    -0.03374117f,
    -0.03680722f,
    -0.03987293f,
    -0.04293826f,
    -0.04600318f,
    -0.04906767f,
    -0.05213170f,
    -0.05519524f,
    -0.05825826f,
    -0.06132074f,
    -0.06438263f,
    -0.06744392f,
    -0.07050457f,
    -0.07356456f,
    -0.07662386f,
    -0.07968244f,
    -0.08274026f,
    -0.08579731f,
    -0.08885355f,
    -0.09190896f,
    -0.09496350f,
    -0.09801714f,
    -0.10106986f,
    -0.10412163f,
    -0.10717242f,
    -0.11022221f,
    -0.11327095f,
    -0.11631863f,
    -0.11936521f,
    -0.12241068f,
    -0.12545498f,
    -0.12849811f,
    -0.13154003f,
    -0.13458071f,
    -0.13762012f,
    -0.14065824f,
    -0.14369503f,
    -0.14673047f,
    -0.14976453f,
    -0.15279719f,
    -0.15582840f,
    -0.15885814f,
    -0.16188639f,
    -0.16491312f,
    -0.16793829f,
    -0.17096189f,
    -0.17398387f,
    -0.17700422f,
    -0.18002290f,
    -0.18303989f,
    -0.18605515f,
    -0.18906866f,
    -0.19208040f,
    -0.19509032f,
    -0.19809841f,
    -0.20110463f,
    -0.20410897f,
    -0.20711138f,
    -0.21011184f,
    -0.21311032f,
    -0.21610680f,
    -0.21910124f,
    -0.22209362f,
    -0.22508391f,
    -0.22807208f,
    -0.23105811f,
    -0.23404196f,
    -0.23702361f,
    -0.24000302f,
    -0.24298018f,
    -0.24595505f,
    -0.24892761f,
    -0.25189782f,
    -0.25486566f,
    -0.25783110f,
    -0.26079412f,
    -0.26375468f,
    -0.26671276f,
    -0.26966833f,
    -0.27262136f,
    -0.27557182f,
    -0.27851969f,
    -0.28146494f,
    -0.28440754f,
    -0.28734746f,
    -0.29028468f,
    -0.29321916f,
    -0.29615089f,
    -0.29907983f,
    -0.30200595f,
    -0.30492923f,
    -0.30784964f,
    -0.31076715f,
    -0.31368174f,
    -0.31659338f,
    -0.31950203f,
    -0.32240768f,
    -0.32531029f,
    -0.32820984f,
    -0.33110631f,
    -0.33399965f,
    -0.33688985f,
    -0.33977688f,
    -0.34266072f,
    -0.34554132f,
    -0.34841868f,
    -0.35129276f,
    -0.35416353f,
    -0.35703096f,
    -0.35989504f,
    -0.36275572f,
    -0.36561300f,
    -0.36846683f,
    -0.37131719f,
    -0.37416406f,
    -0.37700741f,
    -0.37984721f,
    -0.38268343f,
    -0.38551605f,
    -0.38834505f,
    -0.39117038f,
    -0.39399204f,
    -0.39680999f,
    -0.39962420f,
    -0.40243465f,
    -0.40524131f,
    -0.40804416f,
    -0.41084317f,
    -0.41363831f,
    -0.41642956f,
    -0.41921689f,
    -0.42200027f,
    -0.42477968f,
    -0.42755509f,
    -0.43032648f,
    -0.43309382f,
    -0.43585708f,
    -0.43861624f,
    -0.44137127f,
    -0.44412214f,
    -0.44686884f,
    -0.44961133f,
    -0.45234959f,
    -0.45508359f,
    -0.45781330f,
    -0.46053871f,
    -0.46325978f,
    -0.46597650f,
    -0.46868882f,
    -0.47139674f,
    -0.47410021f,
    -0.47679923f,
    -0.47949376f,
    -0.48218377f,
    -0.48486925f,
    -0.48755016f,
    -0.49022648f,
    -0.49289819f,
    -0.49556526f,
    -0.49822767f,
    -0.50088538f,
    -0.50353838f,
    -0.50618665f,
    -0.50883014f,
    -0.51146885f,
    -0.51410274f,
    -0.51673180f,
    -0.51935599f,
    -0.52197529f,
    -0.52458968f,
    -0.52719913f,
    -0.52980362f,
    -0.53240313f,
    -0.53499762f,
    -0.53758708f,
    -0.54017147f,
    -0.54275078f,
    -0.54532499f,
    -0.54789406f,
    -0.55045797f,
    -0.55301671f,
    -0.55557023f,
    -0.55811853f,
    -0.56066158f,
    -0.56319934f,
    -0.56573181f,
    -0.56825895f,
    -0.57078075f,
    -0.57329717f,
    -0.57580819f,
    -0.57831380f,
    -0.58081396f,
    -0.58330865f,
    -0.58579786f,
    -0.58828155f,
    -0.59075970f,
    -0.59323230f,
    -0.59569930f,
    -0.59816071f,
    -0.60061648f,
    -0.60306660f,
    -0.60551104f,
    -0.60794978f,
    -0.61038281f,
    -0.61281008f,
    -0.61523159f,
    -0.61764731f,
    -0.62005721f,
    -0.62246128f,
    -0.62485949f,
    -0.62725182f,
    -0.62963824f,
    -0.63201874f,
    -0.63439328f,
    -0.63676186f,
    -0.63912444f,
    -0.64148101f,
    -0.64383154f,
    -0.64617601f,
    -0.64851440f,
    -0.65084668f,
    -0.65317284f,
    -0.65549285f,
    -0.65780669f,
    -0.66011434f,
    -0.66241578f,
    -0.66471098f,
    -0.66699992f,
    -0.66928259f,
    -0.67155895f,
    -0.67382900f,
    -0.67609270f,
    -0.67835004f,
    -0.68060100f,
    -0.68284555f,
    -0.68508367f,
    -0.68731534f,
    -0.68954054f,
    -0.69175926f,
    -0.69397146f,
    -0.69617713f,
    -0.69837625f,
    -0.70056879f,
    -0.70275474f,
    -0.70493408f,
    -0.70710678f,
    -0.70927283f,
    -0.71143220f,
    -0.71358487f,
    -0.71573083f,
    -0.71787005f,
    -0.72000251f,
    -0.72212819f,
    -0.72424708f,
    -0.72635916f,
    -0.72846439f,
    -0.73056277f,
    -0.73265427f,
    -0.73473888f,
    -0.73681657f,
    -0.73888732f,
    -0.74095113f,
    -0.74300795f,
    -0.74505779f,
    -0.74710061f,
    -0.74913639f,
    -0.75116513f,
    -0.75318680f,
    -0.75520138f,
    -0.75720885f,
    -0.75920919f,
    -0.76120239f,
    -0.76318842f,
    -0.76516727f,
    -0.76713891f,
    -0.76910334f,
    -0.77106052f,
    -0.77301045f,
    -0.77495311f,
    -0.77688847f,
    -0.77881651f,
    -0.78073723f,
    -0.78265060f,
    -0.78455660f,
    -0.78645521f,
    -0.78834643f,
    -0.79023022f,
    -0.79210658f,
    -0.79397548f,
    -0.79583690f,
    -0.79769084f,
    -0.79953727f,
    -0.80137617f,
    -0.80320753f,
    -0.80503133f,
    -0.80684755f,
    -0.80865618f,
    -0.81045720f,
    -0.81225059f,
    -0.81403633f,
    -0.81581441f,
    -0.81758481f,
    -0.81934752f,
    -0.82110251f,
    -0.82284978f,
    -0.82458930f,
    -0.82632106f,
    -0.82804505f,
    -0.82976123f,
    -0.83146961f,
    -0.83317016f,
    -0.83486287f,
    -0.83654773f,
    -0.83822471f,
    -0.83989379f,
    -0.84155498f,
    -0.84320824f,
    -0.84485357f,
    -0.84649094f,
    -0.84812034f,
    -0.84974177f,
    -0.85135519f,
    -0.85296060f,
    -0.85455799f,
    -0.85614733f,
    -0.85772861f,
    -0.85930182f,
    -0.86086694f,
    -0.86242396f,
    -0.86397286f,
    -0.86551362f,
    -0.86704625f,
    -0.86857071f,
    -0.87008699f,
    -0.87159509f,
    -0.87309498f,
    -0.87458665f,
    -0.87607009f,
    -0.87754529f,
    -0.87901223f,
    -0.88047089f,
    -0.88192126f,
    -0.88336334f,
    -0.88479710f,
    -0.88622253f,
    -0.88763962f,
    -0.88904836f,
    -0.89044872f,
    -0.89184071f,
    -0.89322430f,
    -0.89459949f,
    -0.89596625f,
    -0.89732458f,
    -0.89867447f,
    -0.90001589f,
    -0.90134885f,
    -0.90267332f,
    -0.90398929f,
    -0.90529676f,
    -0.90659570f,
    -0.90788612f,
    -0.90916798f,
    -0.91044129f,
    -0.91170603f,
    -0.91296219f,
    -0.91420976f,
    -0.91544872f,
    -0.91667906f,
    -0.91790078f,
    -0.91911385f,
    -0.92031828f,
    -0.92151404f,
    -0.92270113f,
    -0.92387953f,
    -0.92504924f,
    -0.92621024f,
    -0.92736253f,
    -0.92850608f,
    -0.92964090f,
    -0.93076696f,
    -0.93188427f,
    -0.93299280f,
    -0.93409255f,
    -0.93518351f,
    -0.93626567f,
    -0.93733901f,
    -0.93840353f,
    -0.93945922f,
    -0.94050607f,
    -0.94154407f,
    -0.94257320f,
    -0.94359346f,
    -0.94460484f,
    -0.94560733f,
    -0.94660091f,
    -0.94758559f,
    -0.94856135f,
    -0.94952818f,
    -0.95048607f,
    -0.95143502f,
    -0.95237501f,
    -0.95330604f,
    -0.95422810f,
    -0.95514117f,
    -0.95604525f,
    -0.95694034f,
    -0.95782641f,
    -0.95870347f,
    -0.95957151f,
    -0.96043052f,
    -0.96128049f,
    -0.96212140f,
    -0.96295327f,
    -0.96377607f,
    -0.96458979f,
    -0.96539444f,
    -0.96619000f,
    -0.96697647f,
    -0.96775384f,
    -0.96852209f,
    -0.96928124f,
    -0.97003125f,
    -0.97077214f,
    -0.97150389f,
    -0.97222650f,
    -0.97293995f,
    -0.97364425f,
    -0.97433938f,
    -0.97502535f,
    -0.97570213f,
    -0.97636973f,
    -0.97702814f,
    -0.97767736f,
    -0.97831737f,
    -0.97894818f,
    -0.97956977f,
    -0.98018214f,
    -0.98078528f,
    -0.98137919f,
    -0.98196387f,
    -0.98253930f,
    -0.98310549f,
    -0.98366242f,
    -0.98421009f,
    -0.98474850f,
    -0.98527764f,
    -0.98579751f,
    -0.98630810f,
    -0.98680940f,
    -0.98730142f,
    -0.98778414f,
    -0.98825757f,
    -0.98872169f,
    -0.98917651f,
    -0.98962202f,
    -0.99005821f,
    -0.99048508f,
    -0.99090264f,
    -0.99131086f,
    -0.99170975f,
    -0.99209931f,
    -0.99247953f,
    -0.99285041f,
    -0.99321195f,
    -0.99356414f,
    -0.99390697f,
    -0.99424045f,
    -0.99456457f,
    -0.99487933f,
    -0.99518473f,
    -0.99548076f,
    -0.99576741f,
    -0.99604470f,
    -0.99631261f,
    -0.99657115f,
    -0.99682030f,
    -0.99706007f,
    -0.99729046f,
    -0.99751146f,
    -0.99772307f,
    -0.99792529f,
    -0.99811811f,
    -0.99830154f,
    -0.99847558f,
    -0.99864022f,
    -0.99879546f,
    -0.99894129f,
    -0.99907773f,
    -0.99920476f,
    -0.99932238f,
    -0.99943060f,
    -0.99952942f,
    -0.99961882f,
    -0.99969882f,
    -0.99976941f,
    -0.99983058f,
    -0.99988235f,
    -0.99992470f,
    -0.99995764f,
    -0.99998118f,
    -0.99999529f,
    -1.00000000f,
    -0.99999529f,
    -0.99998118f,
    -0.99995764f,
    -0.99992470f,
    -0.99988235f,
    -0.99983058f,
    -0.99976941f,
    -0.99969882f,
    -0.99961882f,
    -0.99952942f,
    -0.99943060f,
    -0.99932238f,
    -0.99920476f,
    -0.99907773f,
    -0.99894129f,
    -0.99879546f,
    -0.99864022f,
    -0.99847558f,
    -0.99830154f,
    -0.99811811f,
    -0.99792529f,
    -0.99772307f,
    -0.99751146f,
    -0.99729046f,
    -0.99706007f,
    -0.99682030f,
    -0.99657115f,
    -0.99631261f,
    -0.99604470f,
    -0.99576741f,
    -0.99548076f,
    -0.99518473f,
    -0.99487933f,
    -0.99456457f,
    -0.99424045f,
    -0.99390697f,
    -0.99356414f,
    -0.99321195f,
    -0.99285041f,
    -0.99247953f,
    -0.99209931f,
    -0.99170975f,
    -0.99131086f,
    -0.99090264f,
    -0.99048508f,
    -0.99005821f,
    -0.98962202f,
    -0.98917651f,
    -0.98872169f,
    -0.98825757f,
    -0.98778414f,
    -0.98730142f,
    -0.98680940f,
    -0.98630810f,
    -0.98579751f,
    -0.98527764f,
    -0.98474850f,
    -0.98421009f,
    -0.98366242f,
    -0.98310549f,
    -0.98253930f,
    -0.98196387f,
    -0.98137919f,
    -0.98078528f,
    -0.98018214f,
    -0.97956977f,
    -0.97894818f,
    -0.97831737f,
    -0.97767736f,
    -0.97702814f,
    -0.97636973f,
    -0.97570213f,
    -0.97502535f,
    -0.97433938f,
    -0.97364425f,
    -0.97293995f,
    -0.97222650f,
    -0.97150389f,
    -0.97077214f,
    -0.97003125f,
    -0.96928124f,
    -0.96852209f,
    -0.96775384f,
    -0.96697647f,
    -0.96619000f,
    -0.96539444f,
    -0.96458979f,
    -0.96377607f,
    -0.96295327f,
    -0.96212140f,
    -0.96128049f,
    -0.96043052f,
    -0.95957151f,
    -0.95870347f,
    -0.95782641f,
    -0.95694034f,
    -0.95604525f,
    -0.95514117f,
    -0.95422810f,
    -0.95330604f,
    -0.95237501f,
    -0.95143502f,
    -0.95048607f,
    -0.94952818f,
    -0.94856135f,
    -0.94758559f,
    -0.94660091f,
    -0.94560733f,
    -0.94460484f,
    -0.94359346f,
    -0.94257320f,
    -0.94154407f,
    -0.94050607f,
    -0.93945922f,
    -0.93840353f,
    -0.93733901f,
    -0.93626567f,
    -0.93518351f,
    -0.93409255f,
    -0.93299280f,
    -0.93188427f,
    -0.93076696f,
    -0.92964090f,
    -0.92850608f,
    -0.92736253f,
    -0.92621024f,
    -0.92504924f,
    -0.92387953f,
    -0.92270113f,
    -0.92151404f,
    -0.92031828f,
    -0.91911385f,
    -0.91790078f,
    -0.91667906f,
    -0.91544872f,
    -0.91420976f,
    -0.91296219f,
    -0.91170603f,
    -0.91044129f,
    -0.90916798f,
    -0.90788612f,
    -0.90659570f,
    -0.90529676f,
    -0.90398929f,
    -0.90267332f,
    -0.90134885f,
    -0.90001589f,
    -0.89867447f,
    -0.89732458f,
    -0.89596625f,
    -0.89459949f,
    -0.89322430f,
    -0.89184071f,
    -0.89044872f,
    -0.88904836f,
    -0.88763962f,
    -0.88622253f,
    -0.88479710f,
    -0.88336334f,
    -0.88192126f,
    -0.88047089f,
    -0.87901223f,
    -0.87754529f,
    -0.87607009f,
    -0.87458665f,
    -0.87309498f,
    -0.87159509f,
    -0.87008699f,
    -0.86857071f,
    -0.86704625f,
    -0.86551362f,
    -0.86397286f,
    -0.86242396f,
    -0.86086694f,
    -0.85930182f,
    -0.85772861f,
    -0.85614733f,
    -0.85455799f,
    -0.85296060f,
    -0.85135519f,
    -0.84974177f,
    -0.84812034f,
    -0.84649094f,
    -0.84485357f,
    -0.84320824f,
    -0.84155498f,
    -0.83989379f,
    -0.83822471f,
    -0.83654773f,
    -0.83486287f,
    -0.83317016f,
    -0.83146961f,
    -0.82976123f,
    -0.82804505f,
    -0.82632106f,
    -0.82458930f,
    -0.82284978f,
    -0.82110251f,
    -0.81934752f,
    -0.81758481f,
    -0.81581441f,
    -0.81403633f,
    -0.81225059f,
    -0.81045720f,
    -0.80865618f,
    -0.80684755f,
    -0.80503133f,
    -0.80320753f,
    -0.80137617f,
    -0.79953727f,
    -0.79769084f,
    -0.79583690f,
    -0.79397548f,
    -0.79210658f,
    -0.79023022f,
    -0.78834643f,
    -0.78645521f,
    -0.78455660f,
    -0.78265060f,
    -0.78073723f,
    -0.77881651f,
    -0.77688847f,
    -0.77495311f,
    -0.77301045f,
    -0.77106052f,
    -0.76910334f,
    -0.76713891f,
    -0.76516727f,
    -0.76318842f,
    -0.76120239f,
    -0.75920919f,
    -0.75720885f,
    -0.75520138f,
    -0.75318680f,
    -0.75116513f,
    -0.74913639f,
    -0.74710061f,
    -0.74505779f,
    -0.74300795f,
    -0.74095113f,
    -0.73888732f,
    -0.73681657f,
    -0.73473888f,
    -0.73265427f,
    -0.73056277f,
    -0.72846439f,
    -0.72635916f,
    -0.72424708f,
    -0.72212819f,
    -0.72000251f,
    -0.71787005f,
    -0.71573083f,
    -0.71358487f,
    -0.71143220f,
    -0.70927283f,
    -0.70710678f,
    -0.70493408f,
    -0.70275474f,
    -0.70056879f,
    -0.69837625f,
    -0.69617713f,
    -0.69397146f,
    -0.69175926f,
    -0.68954054f,
    -0.68731534f,
    -0.68508367f,
    -0.68284555f,
    -0.68060100f,
    -0.67835004f,
    -0.67609270f,
    -0.67382900f,
    -0.67155895f,
    -0.66928259f,
    -0.66699992f,
    -0.66471098f,
    -0.66241578f,
    -0.66011434f,
    -0.65780669f,
    -0.65549285f,
    -0.65317284f,
    -0.65084668f,
    -0.64851440f,
    -0.64617601f,
    -0.64383154f,
    -0.64148101f,
    -0.63912444f,
    -0.63676186f,
    -0.63439328f,
    -0.63201874f,
    -0.62963824f,
    -0.62725182f,
    -0.62485949f,
    -0.62246128f,
    -0.62005721f,
    -0.61764731f,
    -0.61523159f,
    -0.61281008f,
    -0.61038281f,
    -0.60794978f,
    -0.60551104f,
    -0.60306660f,
    -0.60061648f,
    -0.59816071f,
    -0.59569930f,
    -0.59323230f,
    -0.59075970f,
    -0.58828155f,
    -0.58579786f,
    -0.58330865f,
    -0.58081396f,
    -0.57831380f,
    -0.57580819f,
    -0.57329717f,
    -0.57078075f,
    -0.56825895f,
    -0.56573181f,
    -0.56319934f,
    -0.56066158f,
    -0.55811853f,
    -0.55557023f,
    -0.55301671f,
    -0.55045797f,
    -0.54789406f,
    -0.54532499f,
    -0.54275078f,
    -0.54017147f,
    -0.53758708f,
    -0.53499762f,
    -0.53240313f,
    -0.52980362f,
    -0.52719913f,
    -0.52458968f,
    -0.52197529f,
    -0.51935599f,
    -0.51673180f,
    -0.51410274f,
    -0.51146885f,
    -0.50883014f,
    -0.50618665f,
    -0.50353838f,
    -0.50088538f,
    -0.49822767f,
    -0.49556526f,
    -0.49289819f,
    -0.49022648f,
    -0.48755016f,
    -0.48486925f,
    -0.48218377f,
    -0.47949376f,
    -0.47679923f,
    -0.47410021f,
    -0.47139674f,
    -0.46868882f,
    -0.46597650f,
    -0.46325978f,
    -0.46053871f,
    -0.45781330f,
    -0.45508359f,
    -0.45234959f,
    -0.44961133f,
    -0.44686884f,
    -0.44412214f,
    -0.44137127f,
    -0.43861624f,
    -0.43585708f,
    -0.43309382f,
    -0.43032648f,
    -0.42755509f,
    -0.42477968f,
    -0.42200027f,
    -0.41921689f,
    -0.41642956f,
    -0.41363831f,
    -0.41084317f,
    -0.40804416f,
    -0.40524131f,
    -0.40243465f,
    -0.39962420f,
    -0.39680999f,
    -0.39399204f,
    -0.39117038f,
    -0.38834505f,
    -0.38551605f,
    -0.38268343f,
    -0.37984721f,
    -0.37700741f,
    -0.37416406f,
    -0.37131719f,
    -0.36846683f,
    -0.36561300f,
    -0.36275572f,
    -0.35989504f,
    -0.35703096f,
    -0.35416353f,
    -0.35129276f,
    -0.34841868f,
    -0.34554132f,
    -0.34266072f,
    -0.33977688f,
    -0.33688985f,
    -0.33399965f,
    -0.33110631f,
    -0.32820984f,
    -0.32531029f,
    -0.32240768f,
    -0.31950203f,
    -0.31659338f,
    -0.31368174f,
    -0.31076715f,
    -0.30784964f,
    -0.30492923f,
    -0.30200595f,
    -0.29907983f,
    -0.29615089f,
    -0.29321916f,
    -0.29028468f,
    -0.28734746f,
    -0.28440754f,
    -0.28146494f,
    -0.27851969f,
    -0.27557182f,
    -0.27262136f,
    -0.26966833f,
    -0.26671276f,
    -0.26375468f,
    -0.26079412f,
    -0.25783110f,
    -0.25486566f,
    -0.25189782f,
    -0.24892761f,
    -0.24595505f,
    -0.24298018f,
    -0.24000302f,
    -0.23702361f,
    -0.23404196f,
    -0.23105811f,
    -0.22807208f,
    -0.22508391f,
    -0.22209362f,
    -0.21910124f,
    -0.21610680f,
    -0.21311032f,
    -0.21011184f,
    -0.20711138f,
    -0.20410897f,
    -0.20110463f,
    -0.19809841f,
    -0.19509032f,
    -0.19208040f,
    -0.18906866f,
    -0.18605515f,
    -0.18303989f,
    -0.18002290f,
    -0.17700422f,
    -0.17398387f,
    -0.17096189f,
    -0.16793829f,
    -0.16491312f,
    -0.16188639f,
    -0.15885814f,
    -0.15582840f,
    -0.15279719f,
    -0.14976453f,
    -0.14673047f,
    -0.14369503f,
    -0.14065824f,
    -0.13762012f,
    -0.13458071f,
    -0.13154003f,
    -0.12849811f,
    -0.12545498f,
    -0.12241068f,
    -0.11936521f,
    -0.11631863f,
    -0.11327095f,
    -0.11022221f,
    -0.10717242f,
    -0.10412163f,
    -0.10106986f,
    -0.09801714f,
    -0.09496350f,
    -0.09190896f,
    -0.08885355f,
    -0.08579731f,
    -0.08274026f,
    -0.07968244f,
    -0.07662386f,
    -0.07356456f,
    -0.07050457f,
    -0.06744392f,
    -0.06438263f,
    -0.06132074f,
    -0.05825826f,
    -0.05519524f,
    -0.05213170f,
    -0.04906767f,
    -0.04600318f,
    -0.04293826f,
    -0.03987293f,
    -0.03680722f,
    -0.03374117f,
    -0.03067480f,
    -0.02760815f,
    -0.02454123f,
    -0.02147408f,
    -0.01840673f,
    -0.01533921f,
    -0.01227154f,
    -0.00920375f,
    -0.00613588f,
    -0.00306796f
};

int32_t dds_phase_ratef(float frequency)
{
    return (int32_t) (frequency*65536.0f*65536.0f/SAMPLE_RATE);
}
/*- End of function --------------------------------------------------------*/

float dds_frequencyf(int32_t phase_rate)
{
    return (float) phase_rate*(float) SAMPLE_RATE/(65536.0f*65536.0f);
}
/*- End of function --------------------------------------------------------*/

float dds_scaling_dbm0f(float level)
{
    return powf(10.0f, (level - DBM0_MAX_POWER)/20.0f)*(32767.0f*1.414214f);
}
/*- End of function --------------------------------------------------------*/

float dds_scaling_dbovf(float level)
{
    return powf(10.0f, (level + 3.02f)/20.0f)*(32767.0f*1.414214f);
}
/*- End of function --------------------------------------------------------*/

float ddsf(uint32_t *phase_acc, int32_t phase_rate)
{
    float amp;

    amp = sine_table[*phase_acc >> (32 - SLENK)];
    *phase_acc += phase_rate;
    return amp;
}
/*- End of function --------------------------------------------------------*/

float dds_modf(uint32_t *phase_acc, int32_t phase_rate, float scale, int32_t phase)
{
    float amp;

    amp = sine_table[*(phase_acc + phase) >> (32 - SLENK)]*scale;
    *phase_acc += phase_rate;
    return amp;
}
/*- End of function --------------------------------------------------------*/

complexf_t dds_complexf(uint32_t *phase_acc, int32_t phase_rate)
{
    complexf_t amp;

    amp = complex_setf(sine_table[(*phase_acc + (1 << 30)) >> (32 - SLENK)],
                       sine_table[*phase_acc >> (32 - SLENK)]);
    *phase_acc += phase_rate;
    return amp;
}
/*- End of function --------------------------------------------------------*/

complexf_t dds_complex_modf(uint32_t *phase_acc, int32_t phase_rate, float scale, int32_t phase)
{
    complexf_t amp;

    amp = complex_setf(sine_table[(*phase_acc + phase + (1 << 30)) >> (32 - SLENK)]*scale,
                       sine_table[(*phase_acc + phase) >> (32 - SLENK)]*scale);
    *phase_acc += phase_rate;
    return amp;
}
/*- End of function --------------------------------------------------------*/
/*- End of file ------------------------------------------------------------*/
