#ifndef MPEG_H
#define MPEG_H

typedef struct mp3_headerSt
{
  int lay;
  int version;
  int error_protection;
  int bitrate_index;
  int sampling_frequency;
  int padding;
  int extension;
  int mode;
  int mode_ext;
  int copyright;
  int original;
  int emphasis;
  int stereo;
  int framesize;

  /* length of the frame in usecs */
  int frametime;
} mp3_header_t;

extern char *mode_names[], *layer_names[], *version_names[], *version_nums[];
extern unsigned int bitrates[3][3][15];
extern unsigned int s_freq[3][4];

#define BITRATE(mh) (bitrates[(mh).version][(mh).lay - 1][(mh).bitrate_index])

int read_mp3_header (int fd, mp3_header_t *mh);
int read_frame(int fd, unsigned char *buf, mp3_header_t *rmh);
	
#endif
