/* time.c
 * - Utility Time Functions
 *
 * Copyright (c) 1999 Jack Moffitt, Barath Raghavan, and Alexander Havng
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifdef HAVE_CONFIG_H
#ifdef _WIN32
#include <win32config.h>
#else
#include <config.h>
#endif
#endif

#include "definitions.h"
#include <stdio.h>
#include "definitions.h"

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <string.h>

#ifdef _WIN32
# include <time.h>
# include <windows.h>
#else
# include <sys/types.h>
# include <time.h>
# ifdef TIME_WITH_SYS_TIME
#  include <sys/time.h>
# endif
# include <sys/socket.h>
#endif


#include <stdlib.h>

#include "avl.h"
#include "threads.h"
#include "icetypes.h"
#include "icecast.h"
#include "logtime.h"
#include "memory.h"

extern server_info_t info;

long get_time()
{
	return time(NULL);
}

char *get_log_time()
{
	return get_string_time(get_time(), REGULAR_TIME);
}

char *get_clf_log_time()
{
	return get_string_time(get_time(), CLF_TIME);
}

char *get_string_time(time_t tt, char *format)
{
	char *buff;
	
	/* Don't set this to nmalloc */
	buff = (char *)malloc(40);
	memset(buff, 0, 40);
	
#ifdef HAVE_LOCALTIME_R
	{
		struct tm mt, *pmt;

		if (!(pmt = localtime_r(&tt, &mt))) {
			strcpy (buff, "error");
		} else {
			if (strftime(buff, 40, format, pmt) == 0)
				strcpy (buff, "error");
		}
	}
#else
	{
		struct tm *t;
		/* localtime is NOT threadsafe on all platforms */
		thread_library_lock(); 
		t = localtime(&tt);
		strftime(buff, 40, format, t);
		thread_library_unlock();
	}
#endif

	return buff;
}


