var dispMUA =
{
  bundle: null ,
  Info: {} ,
  arDispMUAOverlay: new Array() ,
  strOverlayFilename: "dispMuaOverlay.csv" ,
  arDispMUAAllocation: {} ,
}

dispMUA.search = function()
{
  var srcMsgURI = GetLoadedMessage() ;

  if ( srcMsgURI == null )
  {
    return ;
  }

  var strUserAgent = "" ;
  var strOrganization = "" ;
  var strMimeOLE = "" ;
  var strMessageId = "" ;
  var strExtra = "" ;

  var nHeader = 0 ;

  for ( var headerName in currentHeaderData )
  {
    nHeader ++ ;

    if ( headerName == "user-agent" || headerName == "x-mailer" || headerName == "x-newsreader" )
    {
      strUserAgent = currentHeaderData[headerName].headerValue ;
    }
    else if ( headerName == "organization" )
    {
      strOrganization = currentHeaderData[headerName].headerValue ;
    }
    else if ( headerName == "x-mimeole" )
    {
      strMimeOLE = currentHeaderData[headerName].headerValue ;
    }
    else if ( headerName == "message-id" )
    {
      strMessageId = currentHeaderData[headerName].headerValue ;
    }
    else if ( headerName == "x-bugzilla-reason" )
    {
      strExtra = "bugzilla" ;
    }
    else if ( headerName == "x-php-bug" )
    {
      strExtra = "phpbug" ;
    }
  }

  //if nHeader is below 6, the mail is a) very unusual or b) Enigmail resp. Mnenhy isn't installed

  strUserAgent = dispMUA.stripSurroundingQuotes ( strUserAgent ) ;
  dispMUA.Info["STRING"] = "" ;
  dispMUA.setInfo ( false , [] ) ;
  var strUserAgentLower = strUserAgent.toLowerCase() ;

  if ( strUserAgentLower != "" )
  {
    dispMUA.Info["STRING"] = strUserAgent ;
    //user overlay array
    for ( var strDispMUAKey in dispMUA.arDispMUAOverlay )
    {
      if ( strUserAgentLower.indexOf ( strDispMUAKey ) > -1 )
      {
        //an overlay icon already has the full path in it, including the protocol
        dispMUA.Info["PATH"] = "" ;
        dispMUA.Info["ICON"] = dispMUA.arDispMUAOverlay[strDispMUAKey] ;
        //that the user knows he made the crap
        dispMUA.Info["STRING"] = strUserAgent + "\n" +
                                 "User override icon" + "\n" +
                                 "Key: " + strDispMUAKey + "\n" +
                                 "Icon: " + dispMUA.Info["ICON"] ;
        dispMUA.Info["FOUND"] = true ;
        break ;
      }
    }

    if ( !dispMUA.Info["FOUND"] )
    {
      for ( var strDispMUAKey in dispMUA.arDispMUAAllocation["presearch"] )
      {
        if ( strUserAgentLower.indexOf ( strDispMUAKey ) > -1 )
        {
          dispMUA.setInfo ( true , dispMUA.arDispMUAAllocation["presearch"][strDispMUAKey] ) ;
          break ;
        }
      }
    }

    if ( !dispMUA.Info["FOUND"] )
    {
      var chLetter = strUserAgentLower.substr ( 0 , 1 ) ;

      if ( dispMUA.arDispMUAAllocation[chLetter] )
      {
        for ( var strDispMUAKey in dispMUA.arDispMUAAllocation[chLetter] )
        {
          if ( strUserAgentLower.substr ( 0 , strDispMUAKey.length ) == strDispMUAKey )
          {
            dispMUA.setInfo ( true , dispMUA.arDispMUAAllocation[chLetter][strDispMUAKey] ) ;
            break ;
          }
        }
      }
    }

    if ( !dispMUA.Info["FOUND"] )
    {
      for ( var strDispMUAKey in dispMUA.arDispMUAAllocation["postsearch"] )
      {
        if ( strUserAgentLower.indexOf ( strDispMUAKey ) > -1 )
        {
          dispMUA.setInfo ( true , dispMUA.arDispMUAAllocation["postsearch"][strDispMUAKey] ) ;
          break ;
        }
      }
    }

    if ( !dispMUA.Info["FOUND"] )
    {
      dispMUA.Info["ICON"] = "unknown.png" ;
    }
  }
  else if ( strExtra != "" )
  {
    // strExtra works only with Mnenhy installed
    if ( strExtra == "bugzilla" )
    {
      dispMUA.Info["ICON"] = "bugzilla.png" ;
      dispMUA.Info["STRING"] = "X-Bugzilla-Reason" ;
      dispMUA.Info["FOUND"] = true ;
    }
    else if ( strExtra == "phpbug" )
    {
      dispMUA.Info["ICON"] = "bug.png" ;
      dispMUA.Info["STRING"] = "X-PHP-Bug" ;
      dispMUA.Info["FOUND"] = true ;
    }
  }
  else if ( strOrganization != "" )
  {
    dispMUA.Info["STRING"] = "Organization: " + strOrganization ;
    var strOrganizationLower = strOrganization.toLowerCase() ;

    for ( var strDispMUAKey in dispMUA.arDispMUAAllocation["organization"] )
    {
      if ( strOrganizationLower.indexOf ( strDispMUAKey ) > -1 )
      {
        dispMUA.setInfo ( true , dispMUA.arDispMUAAllocation["organization"][strDispMUAKey] ) ;
        break ;
      }
    }
  }
  else if ( strMimeOLE != "" )
  {
    dispMUA.Info["STRING"] = "X-MimeOLE: " + strMimeOLE ;
    var strMimeOLELower = strMimeOLE.toLowerCase() ;

    if ( strMimeOLELower.indexOf ( "exchange" ) > -1 )
    {
      dispMUA.Info["ICON"] = "ms_exchange.png" ;
      dispMUA.Info["URL"] = "http://www.microsoft.com/" ;
      dispMUA.Info["FOUND"] = true ;
    }
    else if ( strMimeOLELower.indexOf ( "mimeole" ) > -1 )
    {
      dispMUA.Info["ICON"] = "outlook_2003.png" ;
      dispMUA.Info["URL"] = "http://www.microsoft.com/" ;
      dispMUA.Info["FOUND"] = true ;
    }
  }
  else if ( strMessageId != "" )
  {
    var strDispMUAName = "???" ;
    var strMessageIdLower = strMessageId.toLowerCase() ;

    for ( var strDispMUAKey in dispMUA.arDispMUAAllocation["messageid"] )
    {
      if ( strMessageIdLower.indexOf ( strDispMUAKey ) > -1 )
      {
        dispMUA.setInfo ( true , dispMUA.arDispMUAAllocation["messageid"][strDispMUAKey] ) ;
        strDispMUAName = dispMUA.Info["NAME"] ;
        break ;
      }
    }

    dispMUA.Info["STRING"] = strDispMUAName + "\n" + "Message-ID: " + strMessageId ;
  }

  document.getElementById ( "dispMUAicon" ).src = dispMUA.Info["PATH"] + dispMUA.Info["ICON"] ;
  var strTooltip = dispMUA.Info["STRING"] ;
  var pos = strTooltip.indexOf ( "\n" ) ;

  if ( pos != -1 )
  {
    strTooltip = dispMUA.Info["STRING"].substr ( 0 , pos ) ;
  }

  document.getElementById ( "dispMUAicon" ).setAttribute ( "tooltiptext" , strTooltip ) ;
}

dispMUA.setInfo = function ( found , info )
{
  dispMUA.Info["FOUND"] = found ;
  dispMUA.Info["PATH"] = "chrome://dispmua/content/48x48/" ;
  dispMUA.Info["ICON"] = "empty.png" ;
  dispMUA.Info["URL"] = "" ;
  dispMUA.Info["NAME"] = "" ;

  if ( info[0] )
  {
    dispMUA.Info["ICON"] = info[0] ;
  }

  if ( info[1] )
  {
    dispMUA.Info["URL"] = info[1] ;
  }

  if ( info[2] )
  {
    dispMUA.Info["NAME"] = info[2] ;
  }
}

/**
*  loads the user agent overlay file in which users can define their own icons
*
*  The overlay file has a semi-csv format.
*  - On every line, there have to be two strings, split by a comma ","
*  - The first string is the *lowercase* search string which shall match the user agent
*  - The second is the absolute path to the icon
*  If the search string shall include a comma itself, you can quote it.
*    So >"money,inc",/data/icons/money.png< would match the user agent
*    >Mail by Money,Inc. at Cayman Islands< but not >Moneymaker mailer<
*  There is no check for a third (or higher) column, so everything
*    behind the comma is used as the filename.
*  The filename may be quoted as well.
*/
dispMUA.loadMUAOverlayFile = function()
{
  var istream ;

  try
  {
    var service = Components.classes["@mozilla.org/file/directory_service;1"].getService ( Components.interfaces.nsIProperties ) ;
    var file = service.get ( "ProfD" , Components.interfaces.nsIFile ) ;
    file.append ( dispMUA.strOverlayFilename ) ;
    istream = Components.classes["@mozilla.org/network/file-input-stream;1"].createInstance ( Components.interfaces.nsIFileInputStream ) ;
    istream.init ( file , 0x01 , 0444 , 0 ) ;
    istream.QueryInterface ( Components.interfaces.nsILineInputStream ) ;
  }
  catch (e)
  {
    return ;
  }

  var line = {} , hasmore ;
  var strLine , nEndQuote , nCommaPos ;
  var strKey , strValue ;

  do
  {
    hasmore = istream.readLine ( line ) ;
    strLine = line.value ;

    if ( strLine.substr ( 0 , 1 ) == "#" )
    {
      //comment
      continue ;
    }

    if ( strLine.substr ( 0 , 1 ) == "\"" )
    {
      //with quotes
      //find end quote
      nEndQuote = strLine.indexOf ( "\"" , 2 ) ;

      if ( nEndQuote == -1 )
      {
        //no endquote? Bad line!
        continue ;
      }

      nCommaPos = strLine.indexOf ( "," , nEndQuote ) ;
    }
    else
    {
      //no quote
      nCommaPos = strLine.indexOf ( "," ) ;
    }

    if ( nCommaPos == -1 )
    {
      //no comma? Bad line!
      continue ;
    }

    strKey = dispMUA.stripSurroundingQuotes ( strLine.substr ( 0 , nCommaPos ) ) ;
    strValue = dispMUA.stripSurroundingQuotes ( strLine.substr ( nCommaPos + 1 ) ) ;
    dispMUA.arDispMUAOverlay[strKey] = strValue ;
  }
  while ( hasmore ) ;

  istream.close() ;
}

/**
*   Removes quotes (one leading and one trailing) from the given string
*   Used by loadMUAOverlayFile for quoted csv field values
*/
dispMUA.stripSurroundingQuotes = function ( string )
{
  if ( string.substr ( 0 , 1 ) == "\"" && string.substr ( string.length - 1 ) == "\"" )
  {
    string = string.substr ( 1 ) ;
    string = string.substr ( 0 , string.length - 1 ) ;
  }

  return ( string ) ;
}

dispMUA.infopopup = function()
{
  if ( dispMUA.Info["STRING"] == "" )
  {
    alert ( dispMUA.bundle.getString ( "dispMUA.NoUserAgent" ) ) ;
  }
  else
  {
    var param = new Array (
      dispMUA.Info["PATH"] + dispMUA.Info["ICON"] ,
      dispMUA.Info["STRING"] ,
      "#990000" ,
      dispMUA.bundle.getString ( "dispMUA.NOTsupported" ) ,
      dispMUA.Info["URL"]
    ) ;

    if ( dispMUA.Info["FOUND"] )
    {
      param[2] = "#008800" ;
      param[3] = dispMUA.bundle.getString ( "dispMUA.supported" ) ;
    }

    window.openDialog ( "chrome://dispmua/content/feedback.xul" ,
    "feedback" , "chrome=yes,centerscreen" ,
    param[0] , param[1] , param[2] , param[3] , param[4] ) ;
  }
}

dispMUA.init_overlay = function()
{
  if ( dispMUA.bundle != null )
  {
    return ;
  }

  dispMUA.bundle = document.getElementById ( "dispmua-strings" ) ;

  var listener = {} ;
  listener.onStartHeaders = function(){} ;
  listener.onEndHeaders = dispMUA.search ;
  gMessageListeners.push ( listener ) ;

  dispMUA.loadMUAOverlayFile() ;
}

dispMUA.destroy_overlay = function()
{
}

window.addEventListener ( "messagepane-loaded" , dispMUA.init_overlay , true ) ;
window.addEventListener ( "messagepane-unloaded" , dispMUA.destroy_overlay , true ) ;
