var pcolortext, pcolorbg, pgraphicalq;
var pbordercolor, pbordermode, pborderwidth, pcollapseborders;
var pborderleftstyle, pborderrightstyle, pbordertopstyle, pborderbottomstyle;
var pcolorhtmlmsg;
var pusermsgcolors, pmsgtextcolor, pmsgbgcolor, pmsglinkcolor, pmsglinkhovercolor, psignaturecolor, psiglinkcolor;
var phidesignatures, phidestructdelimiters;

var colors_fg = new Array(MAX_LEVELS);
var colors_bg = new Array(MAX_LEVELS);

var mymessenger = Components.classes["@mozilla.org/messenger;1"].createInstance();
mymessenger = mymessenger.QueryInterface(Components.interfaces.nsIMessenger);

var gprintMsgCnt=-1;

function getColorsAndPrefs(ishtmlmessage)
{
  var pref = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefBranch);

  var prefstringfg = "quotecolors.fg.l";
  var prefstringbg = "quotecolors.bg.l";

  for( var i=0; i<MAX_LEVELS; i++)
  {
    colors_fg[i] = pref.getCharPref(prefstringfg + (i+1));
    colors_bg[i] = pref.getCharPref(prefstringbg + (i+1));
  }

  pcolortext = pref.getBoolPref("quotecolors.colorText");
  pcolorbg = pref.getBoolPref("quotecolors.colorBackground");
  
  // is graphical quoting enabled?
  pgraphicalq = ( pref.getBoolPref("mail.quoted_graphical") ||
                  !pref.getBoolPref("mailnews.display.disable_format_flowed_support") ||
                  ishtmlmessage );

  if(pgraphicalq)
  {
    pbordermode = pref.getIntPref("quotecolors.borderMode");
    var index_borderstyle = pref.getIntPref("quotecolors.borderstyle");
    var borderstyle = arr_borderstyle[index_borderstyle];

    pbordercolor = pref.getCharPref("quotecolors.bordercolor");
    var index_borderwidth = pref.getIntPref("quotecolors.borderwidth");
    pborderwidth=arr_borderwidth[index_borderwidth];

    pborderleftstyle = pref.getBoolPref("quotecolors.borderposition.left") ? borderstyle : "none";
    pborderrightstyle = pref.getBoolPref("quotecolors.borderposition.right") ? borderstyle : "none";
    pbordertopstyle = pref.getBoolPref("quotecolors.borderposition.top") ? borderstyle : "none";
    pborderbottomstyle = pref.getBoolPref("quotecolors.borderposition.bottom") ? borderstyle : "none";
  }

  pcollapseborders = pref.getBoolPref("quotecolors.collapseBorders");

  pcolorhtmlmsg = pref.getBoolPref("quotecolors.colorHTMLmessages");

  pusermsgcolors = pref.getBoolPref("quotecolors.usermsgcolors");

  pmsgtextcolor = pref.getCharPref("quotecolors.messagetextcolor");
  pmsgbgcolor = pref.getCharPref("quotecolors.messagebgcolor");
  pmsglinkcolor = pref.getCharPref("quotecolors.messagelinkcolor");
  pmsglinkhovercolor = pref.getCharPref("quotecolors.messagelinkhovercolor");
  psignaturecolor = pref.getCharPref("quotecolors.signaturecolor");
  psiglinkcolor = pref.getCharPref("quotecolors.signaturelinkcolor");

  phidesignatures = pref.getBoolPref("quotecolors.hidesignatures");

  phidestructdelimiters=false;
  if( pref.getBoolPref("quotecolors.hidestructdelimiters") && pref.getBoolPref("mail.display_struct") )
  {
    phidestructdelimiters=true;
  }
}

function isJunk(msguri)
{
  if( !(/type=application\/x-message-display/.test(msguri)) &&
    !(/type=x-message-display/.test(msguri)) ) // for tb 1.0.x
  {
    var msgHdr = mymessenger.messageServiceFromURI(msguri).messageURIToMsgHdr(msguri);
    var junkScore = msgHdr.getStringProperty("junkscore"); 

    return ((junkScore != "") && (junkScore != "0"));
  }
  return false;
}

function onloadPrintengine()
{
  applyColorsToMessage(true);
}

function onloadMessage()
{
  applyColorsToMessage(false);
}

function applyColorsToMessage(printingMode)
{
  var loadedMessage=null;
  var content=null;

  if(printingMode)
  {
    if(gprintMsgCnt==-1) // discard the first call of this function
    {
      gprintMsgCnt=0;
      return;
    }
    content = document.getElementById("content");
    if(!content) return;

    if(window.arguments && window.arguments[0] != null)
    {
      var totalnum = window.arguments[0]; //number of selected messages
      var curmsg = (gprintMsgCnt > totalnum-1) ? totalnum-1 : gprintMsgCnt;

      if(window.arguments[1][curmsg] != null)
        loadedMessage = window.arguments[1][curmsg];
    }
    gprintMsgCnt++;
  }
  else
  {
    content = getMessageBrowser();
    if(!content) return;
    loadedMessage = GetLoadedMessage();
  }

  if(!loadedMessage) return;

  var messagePrefix = /^mailbox-message:|^imap-message:|^news-message:|^file:/i;
  if ( ! messagePrefix.test(loadedMessage) ) return;

  var mailmsg = content.contentDocument;

  var elmBody = mailmsg.getElementsByTagName("body").item(0);

  // does not seem to be a valid message
  if( !elmBody )
    return;

  // work-around bugs #142062, #233681 in print preview
  if( printingMode )
    content.contentDocument.getElementsByTagName("body")[0].style.backgroundColor="#ffffff"; 

  var elmDiv = null;

  var nextElm = elmBody.firstChild;
  while( nextElm )
  {
    if( nextElm.nodeName == "DIV" && nextElm.hasAttribute("class") )
    {
      elmDiv = nextElm;
      break;
    }
    nextElm = nextElm.nextSibling;
  }

  if( !elmDiv )
  {
    // empty message, only set background color
    if( pref.getBoolPref("quotecolors.usermsgcolors") )
      elmBody.bgColor = pref.getCharPref("quotecolors.messagebgcolor");
    return;
  }

  switch( elmDiv.getAttribute("class") )
  {
    case "moz-text-html":
      var htmlmsg = true;
      break;
    case "moz-text-plain":
    case "moz-text-flowed":
      var htmlmsg = false;
      break;
    default:
      return;
  }

  var msgisJunk = isJunk(loadedMessage);

  getColorsAndPrefs(htmlmsg);

  var msgcontainsquotes=false;
  if( mailmsg.getElementsByTagName("blockquote").item(0) )
    msgcontainsquotes=true;

  var StyleElement = mailmsg.createElement("style");
  StyleElement.type = "text/css";

  var stylecontent="";

  const bqselector = "blockquote[type=cite] ";
  if(msgcontainsquotes && !msgisJunk)
  {
    if( (htmlmsg && pcolorhtmlmsg) || !htmlmsg)
    {
    
      for(var i=0;i<MAX_LEVELS; i++)
      {
    
        for(var j=0;j<=i;j++) {
          stylecontent += bqselector;
        }
        
        stylecontent += "{";
        
        // text color
        stylecontent += "color:" + ( pcolortext ? colors_fg[i] : "inherit" ) + " !important;";
        
        // background color
        if(pcolorbg)
          stylecontent += "background-color:"+ colors_bg[i] + " !important;";
          
        // only add/style borders if graphical quoting is enabled  
        if(pgraphicalq)
        {
          stylecontent += "border-color:"+ ( (pbordermode==0) ? colors_fg[i] : pbordercolor ) + " !important;";
          stylecontent += "border-width: " + pborderwidth + "em !important;"
          stylecontent += "border-style: "+pbordertopstyle+" "+pborderrightstyle+" "+pborderbottomstyle+" "+pborderleftstyle+" !important;";
          
          if(pcollapseborders)
          {
            if(i>0)
            {
              var leftmargin = (pborderleftstyle=="none") ? 0.5 : 0.5 + pborderwidth;
              var rightmargin = (pborderrightstyle=="none") ? 0.5 : 0.5 + pborderwidth;
              stylecontent += "margin-left:-"+leftmargin+"em;margin-right:-"+rightmargin+"em;";
            }
            else
                stylecontent += "padding: 0em 0.5em 0em 0.5em !important;";  
          }

        }
        else
        {
          stylecontent += "border:none !important;";
          stylecontent += "padding:0em !important;";
        }
      
        stylecontent += "}\n";
      }

      if(pcollapseborders)
        stylecontent += "blockquote[type=cite] pre{margin-left:0em !important;margin-right:0em !important;}";
    }
  }

  // replace the default quote colors in junk messages and remove borders
  if(msgisJunk)
  {
    for(i=0;i<MAX_LEVELS; i++)
    {
      for(j=0;j<=i;j++) {
        stylecontent += bqselector;
      }
      stylecontent += "{border:none !important;padding:0em !important;color:inherit !important;}\n";
    }
    stylecontent += ".moz-txt-citetags {display:inline !important;}\n";
  }

  // set other messages styles (if enabled)

  if(pusermsgcolors)
  {
    var bgset = elmBody.hasAttribute("bgcolor");
    var textset = elmBody.hasAttribute("text");

    if(!printingMode)
    {
      if(!bgset && !textset)
      {  
        elmBody.bgColor=pmsgbgcolor;
        elmBody.text=pmsgtextcolor;
      }
    }
    else 
    {
      var htmltextcolor=pmsgtextcolor;
      if(textset)
      {
        htmltextcolor = elmBody.getAttribute("text");
        elmBody.removeAttribute("text");
      }
      elmDiv.style.color=htmltextcolor;
    }

    stylecontent += "a:link {color: "+ pmsglinkcolor +";}\n";
    stylecontent += "a:link:hover {color: "+ pmsglinkhovercolor +";}\n";
  
    if(!phidesignatures)
    {
      stylecontent += ".moz-txt-sig, .moz-signature {color: "+ psignaturecolor +";}\n";
      stylecontent += ".moz-txt-sig > a, .moz-signature > a {color: "+ psiglinkcolor +";}\n";
    }
  }

  if(phidesignatures)
    stylecontent += ".moz-txt-sig, .moz-signature {display:none;}\n";

  if(phidestructdelimiters)
    stylecontent += ".moz-txt-tag {display:none !important;}\n";

  // create text node and add it to style element

  var styletext = mailmsg.createTextNode(stylecontent);
  StyleElement.appendChild(styletext);
  
  mailmsg.getElementsByTagName("head")[0].appendChild(StyleElement);
}