/*
 * Copyright 2003-2004 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

package com.sun.corba.se.impl.legacy.connection;

import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.util.Collections;

import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;

import com.sun.corba.se.pept.transport.Acceptor;
import com.sun.corba.se.pept.transport.ContactInfo;

import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.legacy.connection.GetEndPointInfoAgainException;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.transport.CorbaConnection;
import com.sun.corba.se.spi.transport.CorbaContactInfo;
import com.sun.corba.se.spi.transport.SocketInfo;

import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.transport.SocketOrChannelContactInfoImpl;
import com.sun.corba.se.impl.transport.SocketOrChannelConnectionImpl;

/**
 * @author Harold Carr
 */
public class SocketFactoryConnectionImpl
    extends
	SocketOrChannelConnectionImpl
{
    // Socket-factory client constructor.
    public SocketFactoryConnectionImpl(ORB orb,
				       CorbaContactInfo contactInfo,
				       boolean useSelectThreadToWait,
				       boolean useWorkerThread)
    {
	super(orb, useSelectThreadToWait, useWorkerThread);

	// REVISIT - probably need a contact info for both
	// client and server for removing connections from cache?
	this.contactInfo = contactInfo;

	boolean isBlocking = !useSelectThreadToWait;
	SocketInfo socketInfo = 
	    // REVISIT - case - needs interface method
	    ((SocketFactoryContactInfoImpl)contactInfo).socketInfo;
	try {
	    socket = 
		orb.getORBData().getLegacySocketFactory().createSocket(socketInfo);
	    socketChannel = socket.getChannel();
	    if (socketChannel != null) {
		socketChannel.configureBlocking(isBlocking);
	    } else {
		// IMPORTANT: non-channel-backed sockets must use
		// dedicated reader threads.
		setUseSelectThreadToWait(false);
	    }
	    if (orb.transportDebugFlag) {
		dprint(".initialize: connection created: " + socket);
	    }
	} catch (GetEndPointInfoAgainException ex) {
	    throw wrapper.connectFailure(
                ex, socketInfo.getType(), socketInfo.getHost(),
		Integer.toString(socketInfo.getPort())) ;
	} catch (Exception ex) {
	    throw wrapper.connectFailure(
                ex, socketInfo.getType(), socketInfo.getHost(),
		Integer.toString(socketInfo.getPort())) ;
	}
	state = OPENING;
    }

    public String toString()
    {
        synchronized ( stateEvent ){
            return 
		"SocketFactoryConnectionImpl[" + " "
		+ (socketChannel == null ?
		   socket.toString() : socketChannel.toString()) + " "
		+ getStateString( state ) + " "
		+ shouldUseSelectThreadToWait() + " "
		+ shouldUseWorkerThreadForEvent()
		+ "]" ;
        }
    }

    // Note: public to override parent.
    public void dprint(String msg)
    {
	ORBUtility.dprint("SocketFactoryConnectionImpl", msg);
    }

}

// End of file.
