/*
 * Copyright 1994-2003 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

package sun.tools.tree;

import sun.tools.java.*;
import sun.tools.asm.Assembler;
import sun.tools.asm.Label;
import java.io.PrintStream;
import java.util.Hashtable;

/**
 * WARNING: The contents of this source file are not part of any
 * supported API.  Code that depends on them does so at its own risk:
 * they are subject to change or removal without notice.
 */
public
class BreakStatement extends Statement {
    Identifier lbl;

    /**
     * Constructor
     */
    public BreakStatement(long where, Identifier lbl) {
	super(BREAK, where);
	this.lbl = lbl;
    }

    /**
     * Check statement
     */
    Vset check(Environment env, Context ctx, Vset vset, Hashtable exp) {
	reach(env, vset);
	checkLabel(env, ctx);
	CheckContext destctx = (CheckContext)new CheckContext(ctx, this).getBreakContext(lbl);
	if (destctx != null) {
	    if (destctx.frameNumber != ctx.frameNumber) {
		env.error(where, "branch.to.uplevel", lbl);
	    }
	    destctx.vsBreak = destctx.vsBreak.join(vset);
	} else {
	    if (lbl != null) {
		env.error(where, "label.not.found", lbl);
	    } else {
		env.error(where, "invalid.break");
	    }
	}
	CheckContext exitctx = ctx.getTryExitContext();
	if (exitctx != null) {
	    exitctx.vsTryExit = exitctx.vsTryExit.join(vset);
	}
	return DEAD_END;
    }

    /**
     * The cost of inlining this statement
     */
    public int costInline(int thresh, Environment env, Context ctx) {
	return 1;
    }

    /**
     * Code
     */
    public void code(Environment env, Context ctx, Assembler asm) {
	CodeContext newctx = new CodeContext(ctx, this);
	CodeContext destctx = (CodeContext)newctx.getBreakContext(lbl);
	codeFinally(env, ctx, asm, destctx, null);
	asm.add(where, opc_goto, destctx.breakLabel);
	asm.add(newctx.breakLabel);
    }

    /**
     * Print
     */
    public void print(PrintStream out, int indent) {
	super.print(out, indent);
	out.print("break");
	if (lbl != null) {
	    out.print(" " + lbl);
	}
	out.print(";");
    }
}
