/* 
 * Copyright (c) 2007 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 * 
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 * 
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 * 
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */
/*
 * @test
 * @bug 4396021
 * @summary Verify that a resource bundle can override its parent.
 * @build Bug4396021GeneralMessages Bug4396021SpecialMessages
 * @run main Bug4396021
 */

import java.util.ResourceBundle;

public class Bug4396021 {

    private static ResourceBundle bundle;

    public static void main(String[] args) throws Exception {
        bundle = ResourceBundle.getBundle("Bug4396021SpecialMessages");
	
	checkValue("special_key", "special_value");
	checkValue("general_key", "general_value");
    }
    
    private static void checkValue(String key, String expected) throws Exception {
        String result = bundle.getString(key);
	if (!result.equals(expected)) {
	    throw new RuntimeException("Got wrong value from resource bundle"
                    + " - key: " + key + ", expected: " + expected
                    + ", got: " + result);
        }
    }
}
