#include <jni.h>
#include <string.h>
#include <stdlib.h>

int main(int argc, char** argv)
{
  JNIEnv *env;
  JavaVM *vm;
  JavaVMInitArgs vm_args;
  JavaVMOption options[argc-1];
  char** read_pos;
  char** write_pos;
  int a;
  jint vm_count;
  jint main_count;
  jint res;
  jclass cls;
  jmethodID main_method;
  jclass string_class;
  jobjectArray args;

  vm_args.version = JNI_VERSION_1_2;
  vm_args.ignoreUnrecognized = JNI_TRUE;
  read_pos = argv + 1;
  write_pos = argv;
  for (a = 0; a < argc - 1; ++a)
    {
      if (strncmp(*read_pos, "-J", (size_t)2) == 0)
	{
	  options[vm_count].optionString = *read_pos + 2;
	  ++vm_count;
	}
      else
	{
	  *write_pos = *read_pos;
	  ++write_pos;
	  ++main_count;
	}
      ++read_pos;
    }
  for (a = 0; a < main_count; ++a)
    printf("main option %d: %s\n", a, argv[a]);
  for (a = 0; a < vm_count; ++a)
    printf("vm option %d: %s\n", a, options[a].optionString);
  vm_args.options = options;
  vm_args.nOptions = vm_count;

  res = JNI_CreateJavaVM(&vm, (void**)&env, &vm_args);
  if (res < 0)
    {
      fprintf(stderr, "Couldn't create Java VM\n");
      exit(-1);
    }
  cls = (*env)->FindClass(env, "CLASS_NAME");
  if (cls == NULL) {
    goto destroy;
  }
 
  main_method = (*env)->GetStaticMethodID(env, cls, "main",
					  "([Ljava/lang/String;)V");
  if (main_method == NULL) {
    goto destroy;
  }

  string_class = (*env)->FindClass(env, "java/lang/String");
  args = (*env)->NewObjectArray(env, main_count, string_class, NULL);
  if (args == NULL) {
    goto destroy;
  }

  for (a = 0; a < main_count; ++a)
    {
      jstring jstr;

      jstr = (*env)->NewStringUTF(env, *argv);
      if (jstr == NULL) 
	goto destroy;
      ++argv;
      (*env)->SetObjectArrayElement(env, args, a, jstr);
    }

  (*env)->CallStaticVoidMethod(env, cls, main_method, args);
 
 destroy:
  if ((*env)->ExceptionOccurred(env)) 
    (*env)->ExceptionDescribe(env);
  (*vm)->DestroyJavaVM(vm);
  
  return 0;
}
  
