# -*- coding: iso-8859-1 -*-
#
#-------------------------------------------------------------------------------
#
#     This file is part of the Code_Saturne User Interface, element of the
#     Code_Saturne CFD tool.
#
#     Copyright (C) 1998-2008 EDF S.A., France
#
#     contact: saturne-support@edf.fr
#
#     The Code_Saturne User Interface is free software; you can redistribute it
#     and/or modify it under the terms of the GNU General Public License
#     as published by the Free Software Foundation; either version 2 of
#     the License, or (at your option) any later version.
#
#     The Code_Saturne User Interface is distributed in the hope that it will be
#     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
#     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
#
#     You should have received a copy of the GNU General Public License
#     along with the Code_Saturne Kernel; if not, write to the
#     Free Software Foundation, Inc.,
#     51 Franklin St, Fifth Floor,
#     Boston, MA  02110-1301  USA
#
#-------------------------------------------------------------------------------

"""
This module contains the following class:
- SolutionVerifView
"""

#-------------------------------------------------------------------------------
# Standard modules
#-------------------------------------------------------------------------------

import os, logging
import string

#-------------------------------------------------------------------------------
# Third-party modules
#-------------------------------------------------------------------------------

from PyQt4.QtCore import *
from PyQt4.QtGui  import *

#-------------------------------------------------------------------------------
# Application modules import
#-------------------------------------------------------------------------------

from Base.Toolbox import GuiParam
from SolutionVerifForm import Ui_SolutionVerifForm
from Pages.SolutionDomainModel import SolutionDomainModel
from FacesSelectionView import StandardItemModelFaces
import Base.QtPage as QtPage

#-------------------------------------------------------------------------------
# log config
#-------------------------------------------------------------------------------

logging.basicConfig()
log = logging.getLogger("SolutionVerifView")
log.setLevel(GuiParam.DEBUG)

#-------------------------------------------------------------------------------
# Main class
#-------------------------------------------------------------------------------

class SolutionVerifView(QWidget, Ui_SolutionVerifForm):
    """
    """
    def __init__(self, parent, case):
        """
        Constructor
        """
        QWidget.__init__(self, parent)

        Ui_SolutionVerifForm.__init__(self)
        self.setupUi(self)
        
        self.case = case
        self.mdl = SolutionDomainModel(self.case)

        # combo models
        self.modelFMTCHR         = QtPage.ComboModel(self.comboBoxFMTCHR,3,1)
        self.modelFormat         = QtPage.ComboModel(self.comboBoxFormat,2,1)
        self.modelPolygon        = QtPage.ComboModel(self.comboBoxPolygon,3,1)
        self.modelPolyhedra      = QtPage.ComboModel(self.comboBoxPolyhedra,3,1)

        self.modelFMTCHR.addItem(self.tr("EnSight Gold"), 'EnSight') 
        self.modelFMTCHR.addItem(self.tr("MED"), 'MED_fichier')
        self.modelFMTCHR.addItem(self.tr("CGNS"), 'CGNS')

        self.modelFormat.addItem(self.tr("binary"), 'binary')
        self.modelFormat.addItem(self.tr("text"), 'text')

        self.modelPolygon.addItem(self.tr("display"), 'display')
        self.modelPolygon.addItem(self.tr("discard"), 'discard_polygons')
        self.modelPolygon.addItem(self.tr("subdivide"), 'divide_polygons')

        self.modelPolyhedra.addItem(self.tr("display"), 'display')
        self.modelPolyhedra.addItem(self.tr("discard"), 'discard_polyhedra')
        self.modelPolyhedra.addItem(self.tr("subdivide"), 'divide_polyhedra')
        
        # connections
        
        self.connect(self.groupBoxFaces, SIGNAL("clicked(bool)"), self.slotVisualizeForFaces)
        self.connect(self.comboBoxFMTCHR, SIGNAL("activated(const QString&)"), self.slotOutputFormat)
        self.connect(self.comboBoxFormat, SIGNAL("activated(const QString&)"), self.slotOutputOptions)
        self.connect(self.comboBoxPolygon, SIGNAL("activated(const QString&)"), self.slotOutputOptions)
        self.connect(self.comboBoxPolyhedra, SIGNAL("activated(const QString&)"), self.slotOutputOptions)
        self.connect(self.checkBoxBigEndian, SIGNAL("clicked()"), self.slotOutputOptions)
        self.connect(self.toolButtonBatch, SIGNAL("clicked()"), self.ecsMeshChecking)

        # Faces for selection (Custom Widgets)
       
        model = StandardItemModelFaces(self, self.mdl, 'faces_select')
        self.widgetFacesSelect.modelFaces = model
        self.widgetFacesSelect.tableView.setModel(model)

        # INITIALISATIONS
        # 1 - Visualization faces parameters

        if self.mdl.getSelectStatus() == 'on':
            self.groupBoxFaces.setChecked(True)
            self.slotVisualizeForFaces(True)
        else:
            self.groupBoxFaces.setChecked(False)
            self.slotVisualizeForFaces(False)

        list = self.mdl.getListNodes('faces_select')
        result = {}
        if list:
            i = 0
            for node in list:
                i = i + 1
                result = self.mdl.getSelectFaces()
                log.debug("__init__ result = %s "%str(result))

        # 2 - Values of post processing's format

        fmt = self.mdl.getPostProFormat()
        self.modelFMTCHR.setItem(str_model=fmt)
        line = self.mdl.getPostProOptionsFormat()
        self.__updateOptionsFormat(line)


    @pyqtSignature("bool")
    def slotVisualizeForFaces(self, checked):
        """
        Private slot.

        Do we join any meshes ?

        @type checked: C{True} or C{False}
        @param checked: if C{True}, shows the QGroupBox join parameters
        """
        self.groupBoxFaces.setFlat(not checked)
        if checked:
            self.mdl.setSelectStatus("on")
            self.frameFaces.show()
        else:
            self.mdl.setSelectStatus("off")
            self.frameFaces.hide()


    def __updateOptionsFormat(self, line):
        """
        Update ligne for command of format's options at each modification of
        post processing format
        """
        list = string.split(line, ',')
        format = self.modelFMTCHR.dicoV2M[str(self.comboBoxFMTCHR.currentText())]
        log.debug("__updateOptionsFormat-> FMTCHR = %s" % format)
        log.debug("__updateOptionsFormat-> OPTCHR = %s" % line)
        print "line ==", line
        print "format ==", format


    @pyqtSignature("const QString &")
    def slotOutputFormat(self, text):
        """
        Input format of post-processing
        """
        format = self.modelFMTCHR.dicoV2M[str(text)]
        if self.mdl.getPostProFormat() != format:
            self.mdl.setPostProFormat(format)
            line = self.mdl.defaultValues()['postprocessing_options']
            self.mdl.setPostProOptionsFormat(line)
            self.__updateOptionsFormat(line)


    @pyqtSignature("")
    def slotOutputOptions(self):
        """
        Create characters ligne for command of format's options
        """
        line = []
        opt_format = self.modelFormat.dicoV2M[str(self.comboBoxFormat.currentText())]
        line.append(opt_format)

        if self.checkBoxBigEndian.isChecked():
            line.append('big_endian')

        opt_polygon = self.modelPolygon.dicoV2M[str(self.comboBoxPolygon.currentText())]
        opt_polyhed = self.modelPolyhedra.dicoV2M[str(self.comboBoxPolyhedra.currentText())]
        if opt_polygon != 'display': line.append(opt_polygon)
        if opt_polyhed != 'display': line.append(opt_polyhed)

        l = string.join(line, ',')
        log.debug("slotOutputOptions-> OPTCHR = %s" % l)
        self.mdl.setPostProOptionsFormat(l)

####
####    @pyqtSignature("")
####    def slotPostProcessing(self):
####        """
####        Activate/Desactivate the Ensight command
####        """
####        if self.checkBoxEnsight.isChecked():
####            self.post_on_off = "on"
####        else:
####            self.post_on_off = "off"
####        SolutionDomainModel(self.case).setEnsightStatus(self.post_on_off)
####
####        if self.checkBoxMed.isChecked():
####            self.med_on_off = "on"
####        else:
####            self.med_on_off = "off"
####        SolutionDomainModel(self.case).setMedStatus(self.med_on_off)
####
####        if self.checkBoxCGNS.isChecked():
####            self.cgns_on_off = "on"
####        else:
####            self.cgns_on_off = "off"
####        SolutionDomainModel(self.case).setCgnsStatus(self.cgns_on_off)


##    @pyqtSignature("const QString &")
##    def slotPostDirectory(self, text):
##        """
##        Name of the Ensight Case directory
##        """
##        directory = str(text)
##        SolutionDomainModel(self.case).setPostDir(directory)


##    def ecsBatchRunning(self):
    def ecsMeshChecking(self):
        """
        """
        # a  info to say that batch running and the results are in RESU directory
        #
        title = self.tr("Check mesh of the preprocessor")
        msg   = self.tr("The check mesh of preprocessor  will be in  " \
                        "RESU directory.\n\nResults of this running " \
                        "will be stored in this RESU directory.\n\n" \
                        "Do you really want to execute the preprocessor ?")
##        QMessageBox.setIcon
        ans = QMessageBox.information(self, title, msg)

        if ans == QMessageBox.No: 
            return

        lines = []

        # Meshes and formats list
        #
        nameList = SolutionDomainModel(self.case).getMeshList()

        line_mesh = SolutionDomainModel(self.case).getMeshCommand()
        lines.append(line_mesh)

        # join
        #
        line_join = SolutionDomainModel(self.case).getJoinCommand()
##        line_join = BatchScriptFileCommandsModel(self.case).getJoinCommand()
        lines.append(line_join)

        # perio
        #
        self.perio = SolutionDomainModel(self.case).getPeriodicityNumber()
        log.debug("ecsBatchRunning self.perio = %s (%s) "%(self.perio, type(self.perio)))
        if self.perio != 0: # ???
            for i in range(int(self.perio)):
                name = str(i+1)
                line_perio = SolutionDomainModel(self.case).getPerioCommand(name)
##                line_perio = BatchScriptFileCommandsModel(self.case).getPerioCommand(name)
                lines.append(line_perio)


        # select
        #
        line_sel = SolutionDomainModel(self.case).getSelectCommand()
        lines.append(line_sel)

        # ensight/med/cgns/cas
        #
        line_post = SolutionDomainModel(self.case).getPostCommand()
        lines.append(line_post)

        # Write the list "lines" in the new file
        #
        lines.append(" ")

        file = self.case['resu_path']+ '/' +'ecs_gui_cmd'
        f = open(file, 'w')
        f.writelines(lines)
        f.close()
        os.system('chmod +x ' + file)
        # on recupere la variable d'environnement de le preprocesseur dans "lance"
        # et on execute le preprocessor
        #toto = os.popen('grep "ECS=/" ' + self.case['scripts_path'] + '/lance' + ' &').read()
        toto = os.popen('echo $ECS_HOME').read()
        cmd = toto[:-1] + "/bin/ecs -cwd "
        os.system(cmd +self.case['resu_path'] + ' -in ' + file + ' | tee '+ self.case['resu_path'] +'/listenv.pre &')


    def tr(self, text):
        """
        Translation
        """
        return text 

#-------------------------------------------------------------------------------
# Testing part
#-------------------------------------------------------------------------------

if __name__ == "__main__":
    pass

#-------------------------------------------------------------------------------
# End
#-------------------------------------------------------------------------------
