# -*- coding: iso-8859-1 -*-
#
#-------------------------------------------------------------------------------
#
#     This file is part of the Code_Saturne User Interface, element of the
#     Code_Saturne CFD tool.
#
#     Copyright (C) 1998-2008 EDF S.A., France
#
#     contact: saturne-support@edf.fr
#
#     The Code_Saturne User Interface is free software; you can redistribute it
#     and/or modify it under the terms of the GNU General Public License
#     as published by the Free Software Foundation; either version 2 of
#     the License, or (at your option) any later version.
#
#     The Code_Saturne User Interface is distributed in the hope that it will be
#     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
#     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.
#
#     You should have received a copy of the GNU General Public License
#     along with the Code_Saturne Kernel; if not, write to the
#     Free Software Foundation, Inc.,
#     51 Franklin St, Fifth Floor,
#     Boston, MA  02110-1301  USA
#
#-------------------------------------------------------------------------------


#This module made a xml file with the hand


#-------------------------------------------------------------------------------
# Library modules import
#-------------------------------------------------------------------------------

##
##import Tix
##from Tkconstants import *
import sys
sys.path.append('/home/picard/SATURNE/INTERFACE/ICS/ics-qt4_080812/Base/')
sys.path.append('/home/picard/SATURNE/INTERFACE/ICS/ics-qt4_080812/Pages/')


#-------------------------------------------------------------------------------
# Creation class
#-------------------------------------------------------------------------------



class XMLcreation:

    def setUp(self):
        """This method is executed before all "check" methods."""
        import Toolbox as Tool
        from XMLengine import Case, XMLDocument
        from XMLinitialize import XMLinit
####        from Base.XMLmodel import XMLmodel
##        from Pages.AnalysisFeaturesModel import AnalysisFeaturesModel
        Tool.GuiParam.lang = 'fr'
        self.case = Case(None)
        XMLinit(self.case)
##        XMLmodel(self.case)
##        AnalysisFeaturesModel(self.case).setSteadyFlowManagement('off')
####        self.doc = XMLDocument()
        self.forCalculationEnvironment()
        self.forThermoPhysicalModels()
        self.forPhysicalProperties()
        self.forBoundariesConditions()
        
        self.createFile()


    def forCalculationEnvironment(self):
        """ Creates balises for calculation environment"""
        self.createSolutionDomain()


    def forThermoPhysicalModels(self):
        """ Creates balises for thermo physical models"""
        self.createTurbulence()


    def forPhysicalProperties(self):
        """ Creates balises for physical properties"""
        self.createFluidCharacteristics()
        
        
    def forBoundariesConditions(self):
        """ Creates balises for boundaries conditions"""
        self.createBoundariesDefinition()


    def createSolutionDomain(self):
        """ Creates balises for solution domain"""
        from SolutionDomainModel import MeshModel, SolutionDomainModel
        self.md = MeshModel()
        self.sd = SolutionDomainModel(self.case)
        self.setMeshes()
        self.setJoinMeshes()
        self.setFacesCutting()
        self.setSyrthesCoupling()
        self.setPeriodicities()
        self.setStandalone()
        
        
    def createTurbulence(self):
        """ Creates balises for turbulence"""
        from TurbulenceModel import TurbulenceModel
        self.turb = TurbulenceModel(self.case)
        self.turb.setTurbulenceModel('off')

        
    def createFluidCharacteristics(self):
        """ Creates balises for characteristics of the fluid"""
        from FluidCharacteristicsModel import FluidCharacteristicsModel
        self.fc = FluidCharacteristicsModel(self.case)
        self.setFluidCharacteristics()


    def createBoundariesDefinition(self):
        """ Creates balises for definition of boundaries"""
        from LocalizationModel import LocalizationModel
##        from Pages.Boundary import Boundary
        self.loc = LocalizationModel('BoundaryZone', self.case)
##        self.bc = WallBoundary(self.case)
        self.setDefinition()
        self.setBoundaryValues()


    def setMeshes(self):
        """ Creates balises about meshes for solution domain"""
        nameList = ("cavite_75sup.des", "cavite_51demi.des")
        for name in nameList:
            format = self.md.getMeshFormat(name)
            self.sd.addMesh(name, format)


    def setJoinMeshes(self):
        """ Creates balises about paste meshes for solution domain"""
        self.sd.setJoinMeshesStatus('on')
##        node = self.sd.getNodeAdd(self.sd.node_paste, 'faces_paste', 0)
        select = {}
        select['color'] = '98 99'
        select['group'] = ''
        select['fraction'] = '0.1'
        select['plan'] = '0.8'
        select['reverse'] = 'off'
        select['semiconf'] = 'off'
        self.sd.addSelectFaces(select)


    def setFacesCutting(self):
        """ Creates balises about cutting for solution domain"""
        self.sd.setCutStatus("off")


    def setSyrthesCoupling(self):
        """ Creates balises about syrthes coupling for solution domain"""
        self.sd.setSyrthesCouplingStatus("off")


    def setPeriodicities(self):
        """ Creates balises about periodicity for solution domain"""
        self.sd.setPeriodicNumber(0)


    def setStandalone(self):
        """ Creates balises about standalone for solution domain"""
        self.sd.setEnsightStatus("on")
        self.sd.setMedStatus("off")
        self.sd.setCgnsStatus("off")
        self.sd.setSimCommStatus("on")
##        self.sd.createPostDir("preprocess")
        self.sd.getPostCommand()
        
    
    def setFluidCharacteristics(self):
        """ Creates balises about standalone for solution domain"""
        self.fc.setInitialValueDensity(10)
        self.fc.setInitialValueViscosity(0.025)
        self.fc.setInitialValueHeat(1400)


    def setDefinition(self):
        """ Define nature, zone label and localisation for boundaries faces"""
        for (label, zone, nature, local) in [('paroi', '2', 'wall', '3 or 2 or 4'),
                                             ('pardef', '3', 'wall', '5'),
                                             ('sym', '1', 'symmetry', '8')]:
            self.loc.setBoundaries(nature, zone, label, local)


    def setBoundaryValues(self):
        """ Set values for boundaries faces"""
##        self.bc.setChoiceDefil('pardef', 'on')
        from Boundary import Boundary
        model = Boundary('wall', 'paroi', self.case)
        model.setVelocityChoice('on')
##        self.bc.setInletWallVelocity('wall', 'pardef', component     , valvit)
        model.setVelocityComponent(1.1, 'Velocity_U')
        model.setVelocityComponent(2.3, 'Velocity_V')
        model.setVelocityComponent(3.3, 'Velocity_W')


    def createFile(self):
        print "imprime fichier"
        print self.case
        
if __name__ == '__main__':
    print "OKAY !!!"
    XMLcreation().setUp()
    

##    def tearDown(self):
##        """This method is executed after all "check" methods."""
##        del self.case
##        del self.doc

####    def xmlNodeFromString(self, string):
####        """Private method to return a xml node from string"""
####        n = self.doc.parseString(string)
####        self.doc.xmlCleanAllBlank(n)
####        return self.doc.root()



#-------------------------------------------------------------------------------
# End
#-------------------------------------------------------------------------------
