/* vim:tabstop=4:expandtab:shiftwidth=4
 * 
 * Idesk -- SimpleSvgImage.h
 *
 * Copyright (c) 2002, Chris (nikon) (nikon@sc.rr.com)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *      Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *      
 *      Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *      
 *      Neither the name of the <ORGANIZATION> nor the names of its
 *      contributors may be used to endorse or promote products derived from
 *      this software without specific prior written permission.
 *
 * (See the included file COPYING / BSD )
 */

#ifndef SIMPLE_SVG_H
#define SIMPLE_SVG_H

#include "librsvg/rsvg.h"
#include "gdk-pixbuf/gdk-pixbuf.h"
#include "XIdeskImage.h"
#include "AbstractClasses.h"
#include "XShadowImage.h"
#include <gdk/gdk.h>
#include <gdk/gdkx.h>

extern "C" {
#include "gdk-pixbuf-xlib/gdk-pixbuf-xlib.h"
}

class SimpleSvgImage : public virtual XIdeskImage
{
    protected:
        GdkPixbuf * vectorPixbuf;


    public:
        SimpleSvgImage(AbstractContainer * c, AbstractIcon * iParent,
                       AbstractConfig * con, AbstractIconConfig * iConfig);
        virtual ~SimpleSvgImage();

        virtual void configure();
        virtual void createPicture();
        bool loadSvg(const string & filename);
};


class SimpleSvgImageShadow : public XShadowImage, public SimpleSvgImage
{
    protected:

    public:
        SimpleSvgImageShadow(AbstractContainer * c, AbstractIcon * iParent,
                       AbstractConfig * con, AbstractIconConfig * iConfig);

        void configure();

        void refreshIcon();
};

#endif
