#   IDJCmixprefs.py: Preferences window code for IDJC
#   Copyright (C) 2005 Stephen Fairchild
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

import pygtk
pygtk.require('2.0')
import gtk, os
from idjc_config import *
from langheader import *

mIRC_colours = (		# Actually these are the X-Chat2 colours.
   (0xCCCCCCFF, "00"),		# X-Chat2 calls them mIRC colours, but I doubt they match.
   (0x000000FF, "01"),
   (0x3636B2FF, "02"),
   (0x2A8C2AFF, "03"),
   (0xC33B3BFF, "04"),
   (0xC73232FF, "05"),
   (0x80267FFF, "06"),
   (0x66361FFF, "07"),
   (0xD9A641FF, "08"),
   (0x3DCC3DFF, "09"),
   (0x1A5555FF, "10"),
   (0x2F8C74FF, "11"),
   (0x4545E6FF, "12"),
   (0xB037B0FF, "13"),
   (0x4C4C4CFF, "14"),
   (0x959595FF, "15"),
   (0x00000000, "99"))		# used to restore default colours

def cb_colour_box_expose(widget, event, data=None):
   widget.set_state(gtk.STATE_NORMAL)	# Prevent pre-light from messing up the colour

def make_colour_box(rgba, label_text, width, height):
   pixbuf = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, True, 8, width, height)
   pixbuf.fill(rgba)
   image = gtk.Image()
   image.connect_after("expose-event", cb_colour_box_expose)
   image.set_from_pixbuf(pixbuf)
   image.show()
   label = gtk.Label(label_text)
   label.show()
   hbox = gtk.HBox()
   hbox.set_spacing(15)
   hbox.pack_start(label, False, False, 0)
   hbox.pack_end(image, False, False, 0)
   hbox.show()
   return hbox

def make_colour_box_menu(entry, callback):
   menu = gtk.Menu()
   for each in mIRC_colours:
      menuitem = gtk.MenuItem()
      menuitem.connect("activate", callback, entry, each[1])
      colourbox = make_colour_box(each[0], each[1], 45, 28)
      menuitem.add(colourbox)
      menu.add(menuitem)
      menuitem.show()
   menu.show()
   return menu

def make_entry_line(parent, item, code):
   box = gtk.HBox(False, 0)
   box.set_border_width(4)
   box.set_spacing(5)

   entry = gtk.Entry(30)
   entry.set_size_request(185, -1)
         
   button = gtk.Button(save_text)
   button.connect("clicked", parent.save_click, (code, entry))
   box.pack_end(button, False, False, 0)
   button.show()
      
   button = gtk.Button(set_text)
   button.connect("clicked", parent.update_click, (code, entry))
   box.pack_end(button, False, False, 0)
   button.show()
            
   if item[:3] != "Aux":
      entry.set_sensitive(False)
   box.pack_end(entry, False, False, 0)
   entry.show()
      
   checkbox = gtk.CheckButton(auto_text)
   box.pack_end(checkbox, False, False, 0)
   if item[:3] != "Aux":
      checkbox.set_active(True)
      checkbox.connect("toggled", parent.auto_click, entry)
      checkbox.show()
      
   label = gtk.Label(item)
   box.pack_start(label, False, False, 0)
   label.show()
      
   box.show()
   return box, checkbox, entry, button

class mixprefs:
   class event_command_container(gtk.Frame):
      def add(self, widget):
         self.vbox.add(widget)
      def __init__(self):
         gtk.Frame.__init__(self)
         gtk.Frame.set_border_width(self, 4)
         gtk.Frame.set_shadow_type(self, gtk.SHADOW_ETCHED_OUT)
         self.vbox = gtk.VBox()
         self.vbox.set_spacing(2)
         gtk.Frame.add(self, self.vbox)
         self.vbox.set_border_width(4)
         self.vbox.show()
   
   class event_command(gtk.HBox):
      def activate(self):
         if self.checkbutton.get_active():
            os.system(self.entry.get_text())
      def get_text(self):
         return self.entry.get_text()
      def get_active(self):
         return self.checkbutton.get_active()
      def set_text(self, text):
         return self.entry.set_text(text)
      def set_active(self, bool):
         return self.checkbutton.set_active(bool)
      def cb_checkbutton(self, widget, data = None):
         self.entry.set_sensitive(widget.get_active())
      def __init__(self, imagefile, width, height, text, default_state, crossout, tips = None, checkbutton_tip = None, entry_tip = None):
         gtk.HBox.__init__(self)
         gtk.HBox.set_spacing(self, 6)
         self.checkbutton = gtk.CheckButton()
         self.checkbutton.set_active(default_state)
         image = gtk.Image()
         if crossout:
            pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(pkgdatadir + "crossout" + gfext, width , height)
         else:
            pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(pkgdatadir + imagefile + gfext, width, height)
         image.set_from_pixbuf(pixbuf)
         self.checkbutton.add(image)
         image.show()
   	 gtk.HBox.pack_start(self, self.checkbutton, False, False, 0)
         self.checkbutton.connect("toggled", self.cb_checkbutton)
         self.checkbutton.show()
         self.entry = gtk.Entry()
         self.entry.set_text(text)
         gtk.HBox.pack_start(self, self.entry, True, True, 0)
         self.entry.set_sensitive(default_state)
         self.entry.show()
         if tips is not None:
            if checkbutton_tip is not None:
               tips.set_tip(self.checkbutton, checkbutton_tip)
            if entry_tip is not None:
               tips.set_tip(self.entry, entry_tip)
   
   def send_new_compressor_stats(self):
      string_to_send = ":%.1f:%d:%d:%d:%d:%d:%d:%.1f:%d:%.1f:%d:" % (
      					self.ratio_adj.get_value(),
					self.knee_adj.get_value(),
					self.depth_adj.get_value(),
					self.attack_adj.get_value(),
					self.release_adj.get_value(),
					self.gain_adj.get_value(),
					self.gain_relative.get_active(),
					self.ducking_adj.get_value(),
					self.ducking_hold_adj.get_value(),
					self.de_ess_adj.get_value(),
                                        self.filter_slow.get_active())
      self.parent.mixer_write("COMP=%s\nACTN=compstats\nend\n" % string_to_send, True)
      
   def cb_compressor(self, widget, data):
      self.send_new_compressor_stats()
      
   def send_new_noisegate_stats(self):
      string_to_send = ":%d:%d:%d:%d:%d:%d:" % (
      					self.gate_threshold_adj.get_value(),
					self.gate_hyster_adj.get_value(),
					self.gate_delay_adj.get_value(),
					self.gate_attenuation_adj.get_value(),
					self.gate_ontime_adj.get_value(),
					self.gate_offtime_adj.get_value())
      self.parent.mixer_write("GATE=%s\nACTN=gatestats\nend\n" % string_to_send, True)
      
   def send_new_microphone_stats(self):
      string_to_send = ":%d:%d:%d:%d:%d:%d:%d:%.1f:" % (
      					self.mic_filter,
					self.left_invert.get_active(),
					self.right_invert.get_active(),
					self.left_mic_level.get_value(),
					self.right_mic_level.get_value(),
					self.left_mic_mix_slider.get_value(),
					self.right_mic_mix_slider.get_value(),
					self.headroom.get_value())
      self.parent.mixer_write("MICS=%s\nACTN=micmixstats\nend\n" % string_to_send, True)
      
   def send_new_normalizer_stats(self):
      string_to_send = ":%0.1f:%0.1f:%d:%d:%d:" % (
      					self.normboost_adj.get_value(),
                                        self.normceiling_adj.get_value(),
                                        self.normrise_adj.get_value(),
                                        self.normfall_adj.get_value(), 
                                        self.normalize.get_active())
      self.parent.mixer_write("NORM=%s\nACTN=normalizerstats\nend\n" % string_to_send, True)
      
   def send_new_resampler_stats(self):
      self.parent.mixer_write("RSQT=%d\nACTN=resamplequality\nend\n" % self.resample_quality, True)
      
   def normalizer_defaults(self, value = None):
      self.normboost_adj.set_value(12.0)
      self.normboost_adj.value_changed()
      self.normceiling_adj.set_value(-12.0)
      self.normceiling_adj.value_changed()
      self.normrise_adj.set_value(120000.0)
      self.normrise_adj.value_changed()
      self.normfall_adj.set_value(90000.0)
      self.normfall_adj.value_changed()

   def cb_normalizer(self, widget, data = None):
      self.send_new_normalizer_stats()
      
   def cb_resample_quality(self, widget, data):
      if widget.get_active():
         self.resample_quality = data
         self.send_new_resampler_stats()
      
   def cb_dither(self, widget, data = None):
      if widget.get_active():
         string_to_send = "ACTN=dither\nend\n"
      else:
         string_to_send = "ACTN=dontdither\nend\n"
      self.parent.mixer_write(string_to_send, True)

   def cb_noisegate(self, widget, data):
      self.send_new_noisegate_stats()
      
   def cb_restore_session(self, widget, data=None):
      state = not widget.get_active()
      self.left_player_frame.set_sensitive(state)
      self.right_player_frame.set_sensitive(state)
      self.misc_session_frame.set_sensitive(state)
   
   def load_jack_port_settings(self):
      if os.path.isfile(self.parent.idjc + "micl"):
         file = open(self.parent.idjc + "micl", "r")
	 self.miclentry.set_text(file.readline()[:-1])
	 self.miclcheck.set_active(file.readline() == "1\n")
	 file.close()

      if os.path.isfile(self.parent.idjc + "micr"):
         file = open(self.parent.idjc + "micr", "r")
	 self.micrentry.set_text(file.readline()[:-1])
	 self.micrcheck.set_active(file.readline() == "1\n")
	 file.close()

      if os.path.isfile(self.parent.idjc + "audl"):
         file = open(self.parent.idjc + "audl", "r")
	 self.audlentry.set_text(file.readline()[:-1])
	 self.audlcheck.set_active(file.readline() == "1\n")
	 file.close()
      
      if os.path.isfile(self.parent.idjc + "audr"):
         file = open(self.parent.idjc + "audr", "r")
	 self.audrentry.set_text(file.readline()[:-1])
	 self.audrcheck.set_active(file.readline() == "1\n")
	 file.close()
	 
      if os.path.isfile(self.parent.idjc + "strl"):
         file = open(self.parent.idjc + "strl", "r")
	 self.strlentry.set_text(file.readline()[:-1])
	 self.strlcheck.set_active(file.readline() == "1\n")
	 file.close()
      
      if os.path.isfile(self.parent.idjc + "strr"):
         file = open(self.parent.idjc + "strr", "r")
	 self.strrentry.set_text(file.readline()[:-1])
	 self.strrcheck.set_active(file.readline() == "1\n")
	 file.close()
      
      if os.path.isfile(self.parent.idjc + "auxl"):
         file = open(self.parent.idjc + "auxl", "r")
	 self.auxlentry.set_text(file.readline()[:-1])
	 self.auxlcheck.set_active(file.readline() == "1\n")
	 file.close()
	       
      if os.path.isfile(self.parent.idjc + "auxr"):
         file = open(self.parent.idjc + "auxr", "r")
	 self.auxrentry.set_text(file.readline()[:-1])
	 self.auxrcheck.set_active(file.readline() == "1\n")
	 file.close()
   
   def auto_click(self, widget, data):
      data.set_sensitive(not widget.get_active())
   
   def save_click(self, widget, data):
      filename = self.parent.idjc + data[0].lower()
      file = open(filename, "w")
      if data[1].flags() & gtk.SENSITIVE:
         file.write(data[1].get_text() + "\n" + "0\n")
      else:
         file.write(data[1].get_text() + "\n" + "1\n")
      file.close()
   
   def update_click(self, widget, (code, entry)):
      if entry.flags() & gtk.SENSITIVE:
         entrytext = entry.get_text()
      else:
         entrytext = "default"
      buffer = "ACTN=remake%s\n%s=%s\nend\n" % (code.lower(), code, entrytext)
      self.parent.mixer_write(buffer, True)
      
   def delete_event(self, widget, event, data=None):
      self.window.hide()
      return True

   def save_player_prefs(self):
      try:
         file = open(self.parent.idjc + "playerdefaults", "w")
	 for name, widget in self.playersettingsdict.iteritems():
	    file.write(name + ("=False\n","=True\n")[widget.get_active()])
         for name, widget in self.valuesdict.iteritems():
	    file.write(name + "=" + str(widget.get_value()) + "\n")
	 for name, widget in self.textdict.iteritems():
	    file.write(name + "=" + widget.get_text() + "\n")
	 file.close()
      except IOError:
         print "Error while writing out player defaults"
      if self.ask_profile.get_active():
         if os.path.isfile(self.parent.idjcroot + "do-not-ask-profile"):
            try:
               os.unlink(self.parent.idjcroot + "do-not-ask-profile")
            except:
               print "error removing file 'do-not-ask-profile'"
      else:
         try:
            os.close(os.open(self.parent.idjcroot + "do-not-ask-profile", os.O_CREAT | os.O_WRONLY))
         except:
            print "error creating file 'do-not-ask-profile'"
	 
   def load_player_prefs(self):
      try:
         file = open(self.parent.idjc + "playerdefaults", "r")
	 
	 while 1:
	    line = file.readline()
	    if line == "":
	       break
	    if line.count("=") != 1:
	       continue
	    line = line.split("=")
	    key = line[0].strip()
	    value = line[1][:-1].strip()
	    if value == "True":
	       value = True
	    elif value == "False":
	       value = False
	    if self.playersettingsdict.has_key(key):
	       self.playersettingsdict[key].set_active(value)
	    elif self.valuesdict.has_key(key):
	       self.valuesdict[key].set_value(float(value))
	    elif self.textdict.has_key(key):
	       self.textdict[key].set_text(value)
	 file.close()
      except IOError:
         print "Failed to read playerdefaults file"
      self.send_new_compressor_stats()
      self.send_new_noisegate_stats()
      self.send_new_microphone_stats()
      self.parent.send_new_mixer_stats()

	 
   def apply_player_prefs(self):
      left = self.parent.player_left
      right = self.parent.player_right
      
      if self.lplayall.get_active():
         left.pl_mode.set_active(0)
      if self.lloopall.get_active():
         left.pl_mode.set_active(1)
      if self.lrandom.get_active():
         left.pl_mode.set_active(2)
      if self.lmanual.get_active():
         left.pl_mode.set_active(3)
      if self.lcueup.get_active():
         left.pl_mode.set_active(4)
         	 
      if self.rplayall.get_active():
         right.pl_mode.set_active(0)
      if self.rloopall.get_active():
         right.pl_mode.set_active(1)
      if self.rrandom.get_active():
         right.pl_mode.set_active(2)
      if self.rmanual.get_active():
         right.pl_mode.set_active(3)
      if self.rcueup.get_active():
         right.pl_mode.set_active(4)

      left.stream.set_active(self.lstream.get_active())
      right.stream.set_active(self.rstream.get_active())
      
      left.listen.set_active(self.llisten.get_active())
      right.listen.set_active(self.rlisten.get_active())
      
      if self.lcountdown.get_active():
         left.digiprogress_click()
      if self.rcountdown.get_active():
         right.digiprogress_click()
	 
      if self.startmini.get_active():
         self.mini.clicked()
	 
      self.mic_peak_toggle.toggled()
      self.stream_peak_toggle.toggled()
      self.vu_toggle.toggled()
      self.limiter_toggle.toggled()
      #self.enhanced_crossfade.toggled()
      
      if self.tracks_played.get_active():
         self.parent.history_expander.set_expanded(True)
         self.parent.history_vbox.show()
      if self.stream_mon.get_active():
         self.parent.listen.set_active(True)
      if self.ap_startup_pref.get_active() == True:
         self.parent.server_window.autopausebutton.set_active(True)
      
   def callback(self, widget, data):
      parent = self.parent
      if data == "basic streamer":
         if parent.menu_feature_set.get_active():
            parent.menu_feature_set.set_active(False)
      if data == "fully featured":
         if parent.menu_feature_set.get_active() == False:
            parent.menu_feature_set.set_active(True)
      if data == "enhanced-crossfader":
         if widget.get_active():
	    parent.listen.show()
	    parent.passleft.show()
	    parent.passright.show()
	    parent.passspeed.show()
	    parent.passbutton.show()
	 else:
	    parent.listen.hide()
	    parent.passleft.hide()
	    parent.passright.hide()
	    parent.passspeed.hide()
	    parent.passbutton.hide()
	    parent.listen.set_active(False)
      if data == "bigger box":
         if widget.get_active():
            self.parent.player_left.digiprogress.set_width_chars(7)
            self.parent.player_right.digiprogress.set_width_chars(7)
         else:
            self.parent.player_left.digiprogress.set_width_chars(6)
            self.parent.player_right.digiprogress.set_width_chars(6)
	    
   def cb_mic(self, widget, data):
      if data == "filter_off":
         self.mic_filter = 0
      if data == "filter_mild":
         self.mic_filter = 1
      if data == "filter_sharp" and widget.get_active():
         self.mic_filter = 2
      self.send_new_microphone_stats() 
      
   def cb_autopause(self, widget, data):
      if data == "on_delay changed":
         self.parent.server_window.serv_cmd.write("APOD=%f\nACTN=Pause\nend\n" % widget.get_value())
      if data == "off_thresh changed":
         self.parent.server_window.serv_cmd.write("APTH=%d\nACTN=Pause\nend\n" % int(widget.get_value()))
      self.parent.server_window.serv_cmd.flush()
	 
   def meter_callback(self, widget, data):
      if data[0] == "meter":
         if widget.get_active():
            data[1].show()
	 else:
	    data[1].hide()
      if self.mic_peak_toggle.get_active() or self.stream_peak_toggle.get_active() or self.vu_toggle.get_active() or self.limiter_toggle.get_active():
         if self.parent.simplemixer == False:
            self.parent.meterbox.show()
      else:
         self.parent.meterbox.hide()
    
   def cb_mic_boost(self, widget):
      self.parent.send_new_mixer_stats()
	 	    
   def cb_colourbox(self, menuitem, entry, colour):
      cursor = entry.get_position()
      if cursor < 3 or entry.get_text()[cursor - 3] !="\x03":
         entry.insert_text("\x03" + colour, cursor)	# Foreground colour
      else:
         entry.insert_text("," + colour, cursor)	# Background
      entry.set_position(cursor + 3)

   def cb_pbspeed(self, widget):
      if widget.get_active():
         self.parent.player_left.pbspeedbar.set_value(0)
         self.parent.player_right.pbspeedbar.set_value(0)
         self.parent.player_left.pbspeedbox.show()
         self.parent.player_right.pbspeedbox.show()
      else:
         self.parent.player_left.pbspeedbox.hide()
         self.parent.player_right.pbspeedbox.hide()
      self.parent.send_new_mixer_stats()

   def colourmenupopulate(self, entry, menu):
      menusep = gtk.SeparatorMenuItem()
      menu.append(menusep)
      menusep.show()
      menuitem = gtk.MenuItem(mirc_colour_menu_text)
      menu.append(menuitem)
      submenu = make_colour_box_menu(entry, self.cb_colourbox)
      menuitem.set_submenu(submenu)
      menuitem.show()
      
   def cb_handle_colour_char(self, entry, event, data=None):
      if event.state & gtk.gdk.LOCK_MASK:
         target = 75
      else:
         target = 107
      if event.state & (~gtk.gdk.LOCK_MASK) == gtk.gdk.CONTROL_MASK and event.keyval == target:
         cursor = entry.get_position()
         entry.insert_text("\x03", cursor)
         entry.set_position(cursor + 1)
   
   def bind_jack_ports(self):
      self.miclupdate.clicked()
      self.micrupdate.clicked()
      self.audlupdate.clicked()
      self.audrupdate.clicked()
      self.strlupdate.clicked()
      self.strrupdate.clicked()
      self.auxlupdate.clicked()
      self.auxrupdate.clicked()
   
   def __init__(self, parent):
      self.parent = parent
      self.parent.prefs_window = self		# yuck!
      self.window = gtk.Window(gtk.WINDOW_TOPLEVEL)
      self.parent.window_group.add_window(self.window)
      self.window.set_title(prefs_window_text)
      self.window.set_border_width(10)
      self.window.set_resizable(False)
      self.window.connect("delete_event",self.delete_event)
      self.window.set_destroy_with_parent(True)
      self.window.set_icon_from_file(pkgdatadir + "icon" + gfext)
      self.notebook = gtk.Notebook()
      self.window.add(self.notebook)

      # General tab
      
      generalwindow = gtk.ScrolledWindow()
      generalwindow.set_border_width(8)
      generalwindow.set_policy(gtk.POLICY_NEVER, gtk.POLICY_ALWAYS)
      outervbox = gtk.VBox()
      generalwindow.add_with_viewport(outervbox)
      generalwindow.show()
      outervbox.set_border_width(3)
      featuresframe = gtk.Frame(" " + feature_set_text + " ")
      featuresframe.set_border_width(3)
      hbox = gtk.HBox()
      hbox.set_border_width(2)
      featuresframe.add(hbox)
      outervbox.pack_start(featuresframe, False, False, 0)
      featuresframe.show()
      vbox = gtk.VBox()
      self.startfull = gtk.RadioButton(None, start_full_text)
      self.startfull.set_border_width(2)
      vbox.pack_start(self.startfull, False, False, 0)
      self.startfull.show()
      self.startmini = gtk.RadioButton(self.startfull, start_mini_text)
      self.startmini.set_border_width(2)
      vbox.pack_start(self.startmini, False, False, 0)
      self.startmini.show()
      vbox.show()
      hbox2 = gtk.HBox()
      hbox2.set_border_width(10)
      hbox2.set_spacing(20)
      hbox.pack_start(hbox2, True, False, 0)
      self.maxi = gtk.Button(" " + fully_featured_text + " ")
      self.maxi.connect("clicked", self.callback, "fully featured")
      hbox2.pack_start(self.maxi, False, False, 0)
      self.maxi.show()
      self.mini = gtk.Button(" " + basic_streamer_text + " ")
      self.mini.connect("clicked", self.callback, "basic streamer")
      hbox2.pack_start(self.mini, False, False, 0)
      self.mini.show()   
      hbox2.show()   
      hbox.pack_start(vbox, False, False, 9)     
      hbox.show()
      
      # Bits and Bobs
      
      frame = gtk.Frame(" " + bits_and_bobs_text + " ")
      frame.set_border_width(3)
      hbox = gtk.HBox()
      hbox.set_border_width(5)
      frame.add(hbox)
      frame.show()
      leftvbox = gtk.VBox()
      midvbox = gtk.VBox()
      rightvbox = gtk.VBox()
      hbox.add(leftvbox)
      hbox.add(midvbox)
      hbox.add(rightvbox)
      hbox.show()
      # left column
      stream_peak_hbox = gtk.HBox()
      leftvbox.add(stream_peak_hbox)
      stream_peak_hbox.show()
      mic_peak_hbox = gtk.HBox()
      leftvbox.add(mic_peak_hbox)
      mic_peak_hbox.show()
      big_box_hbox = gtk.HBox()
      leftvbox.add(big_box_hbox)
      big_box_hbox.show()
      mic_vu_hbox = gtk.HBox()
      rightvbox.add(mic_vu_hbox)
      mic_vu_hbox.show()
      mp3_utf8_hbox = gtk.HBox()
      leftvbox.add(mp3_utf8_hbox)
      mp3_utf8_hbox.show()
      speed_variance_box = gtk.HBox()
      leftvbox.add(speed_variance_box)
      speed_variance_box.show()
      leftvbox.show()
      
      # mid column
      stream_vu_hbox = gtk.HBox()
      midvbox.add(stream_vu_hbox)
      stream_vu_hbox.show()
      normalize_hbox = gtk.HBox()
      midvbox.add(normalize_hbox)
      normalize_hbox.show()
      keeppass_box = gtk.HBox()
      midvbox.add(keeppass_box)
      keeppass_box.show()
      ask_profile_hbox = gtk.HBox()
      midvbox.add(ask_profile_hbox)
      ask_profile_hbox.show()
      midvbox.show()
      # right column
      enhanced_cross_box = gtk.HBox()
      rightvbox.add(enhanced_cross_box)
      enhanced_cross_box.show()
      djalarmbox = gtk.HBox()
      rightvbox.add(djalarmbox)
      djalarmbox.show()
      extm3ubox = gtk.HBox()
      rightvbox.add(extm3ubox)
      extm3ubox.show()
      dither_hbox = gtk.HBox()
      rightvbox.add(dither_hbox)
      dither_hbox.show()
      rightvbox.show()

      self.speed_variance = gtk.CheckButton(speed_variance_text)
      speed_variance_box.pack_start(self.speed_variance, False, False, 5)
      self.speed_variance.connect("toggled", self.cb_pbspeed)
      self.speed_variance.show()
      self.ask_profile = gtk.CheckButton(ask_profile_text)
      ask_profile_hbox.pack_start(self.ask_profile, False, False, 0)
      self.ask_profile.show()
      self.stream_peak_toggle = gtk.CheckButton()
      stream_peak_hbox.pack_start(self.stream_peak_toggle, False, False, 5)
      self.stream_peak_toggle.connect("toggled", self.meter_callback, ("meter", self.parent.stream_peak_box))
      self.stream_peak_toggle.show()
      self.parent.str_pk_action.connect_proxy(self.stream_peak_toggle)
      self.mic_peak_toggle = gtk.CheckButton()
      mic_peak_hbox.pack_start(self.mic_peak_toggle, False, False, 5)
      self.mic_peak_toggle.connect("toggled", self.meter_callback, ("meter", self.parent.mic_peak_box))
      self.mic_peak_toggle.show()
      self.parent.mic_pk_action.connect_proxy(self.mic_peak_toggle) 
      self.bigger_box_toggle = gtk.CheckButton(big_box_toggle_text)
      big_box_hbox.pack_start(self.bigger_box_toggle, False, False, 5)
      self.bigger_box_toggle.connect("toggled", self.callback, "bigger box")
      self.bigger_box_toggle.show()
      self.vu_toggle = gtk.CheckButton()
      mic_vu_hbox.pack_start(self.vu_toggle, False, False, 0)
      self.vu_toggle.connect("toggled", self.meter_callback, ("meter", self.parent.vubox))
      self.vu_toggle.show()
      self.parent.show_vu_action.connect_proxy(self.vu_toggle)
      self.limiter_toggle = gtk.CheckButton()
      stream_vu_hbox.pack_start(self.limiter_toggle, False, False, 0)
      self.limiter_toggle.connect("toggled", self.meter_callback, ("meter", self.parent.limiter_box))
      self.limiter_toggle.show()
      self.parent.show_comp_action.connect_proxy(self.limiter_toggle)
      self.enhanced_crossfade = gtk.CheckButton("Enh. Crossfader")
      self.enhanced_crossfade.connect("toggled", self.callback, "enhanced-crossfader")
      #enhanced_cross_box.pack_start(self.enhanced_crossfade, False, False, 0)
      #self.enhanced_crossfade.show()
      self.fadeout = gtk.CheckButton(fadeout_toggle_text)
      enhanced_cross_box.pack_start(self.fadeout, False, False, 0)
      self.fadeout.set_active(True)
      #self.fadeout.show()
      self.djalarm = gtk.CheckButton(dj_alarm_toggle_text)
      djalarmbox.pack_start(self.djalarm, False, False, 0)
      self.djalarm.show()
      self.extm3u = gtk.CheckButton("EXTM3U")
      extm3ubox.pack_start(self.extm3u, False, False, 0)
      self.extm3u.show()
      self.normalize = gtk.CheckButton(normalizer_toggle_text)
      normalize_hbox.pack_start(self.normalize, False, False, 0)
      self.normalize.connect("toggled", self.cb_normalizer)
      self.normalize.show()
      self.dither = gtk.CheckButton(dither_toggle_text)
      dither_hbox.pack_start(self.dither, False, False, 0)
      self.dither.connect("toggled", self.cb_dither)
      self.dither.show()
      self.keeppass = gtk.CheckButton(keeppass_text)
      keeppass_box.pack_start(self.keeppass, False, False, 0)
      self.keeppass.show()
      self.mp3_utf8 = gtk.CheckButton(mp3_utf8_text)
      mp3_utf8_hbox.pack_start(self.mp3_utf8, False, False, 5)
      self.mp3_utf8.show()

      outervbox.pack_start(frame, False, False, 0)
      
      # Stream normalizer config
      
      frame = gtk.Frame(" " + stream_normalizer_text + " ")
      frame.set_border_width(3)
      hbox = gtk.HBox()
      hbox.set_border_width(5)
      frame.add(hbox)
      hbox.show()
      lvbox = gtk.VBox()
      lvbox.set_spacing(2)
      hbox.pack_start(lvbox, True, False, 0)
      mvbox = gtk.VBox()
      hbox.pack_start(mvbox, True, False, 0)
      mvbox.show()
      lvbox.show()
      rvbox = gtk.VBox()
      rvbox.set_spacing(2)
      hbox.pack_start(rvbox, True, False, 0)
      rvbox.show()
      outervbox.pack_start(frame, False, False, 0)
      frame.show()	# maybe this is just too geeky so I hide it
      
      # User can use this to set the resampled sound quality
      
      frame = gtk.Frame(" " + player_resample_mode_text + " ")
      frame.set_border_width(3)
      hbox = gtk.HBox()
      hbox.set_border_width(5)
      frame.add(hbox)
      hbox.show()
      self.best_quality_resample = gtk.RadioButton(None, best_quality_resample_text)
      self.best_quality_resample.connect("toggled", self.cb_resample_quality, 0)
      rsbox = gtk.HBox()
      rsbox.pack_start(self.best_quality_resample, True, False, 0)
      rsbox.show()
      hbox.add(rsbox)
      self.best_quality_resample.show()
      self.good_quality_resample = gtk.RadioButton(self.best_quality_resample, good_quality_resample_text)
      self.good_quality_resample.connect("toggled", self.cb_resample_quality, 1) 
      rsbox = gtk.HBox()
      rsbox.pack_start(self.good_quality_resample, True, False, 0)
      rsbox.show()
      hbox.add(rsbox)
      self.good_quality_resample.show()
      self.fast_resample = gtk.RadioButton(self.good_quality_resample, fast_resample_text)
      self.fast_resample.connect("toggled", self.cb_resample_quality, 2) 
      rsbox = gtk.HBox()
      rsbox.pack_start(self.fast_resample, True, False, 0)
      rsbox.show()
      hbox.add(rsbox)
      self.fast_resample.show()
      self.fastest_resample = gtk.RadioButton(self.fast_resample, fastest_resample_text)
      self.fastest_resample.connect("toggled", self.cb_resample_quality, 4) 
      rsbox = gtk.HBox()
      rsbox.pack_start(self.fastest_resample, True, False, 0)
      rsbox.show()
      hbox.add(rsbox)
      self.fastest_resample.show()
      
      outervbox.pack_start(frame, False, False, 0)
      frame.show()
      
      sizegroup = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
      
      boostbox = gtk.HBox()
      boostbox.set_spacing(3)
      self.normboost_adj = gtk.Adjustment(12.0, 0.0, 25.0, 0.1, 0.2, 0.2)
      normboost = gtk.SpinButton(self.normboost_adj, 1, 1)
      normboost.connect("value-changed", self.cb_normalizer)
      sizegroup.add_widget(normboost)
      boostbox.pack_start(normboost, False, False, 0)
      normboost.show()
      label = gtk.Label(normboost_text)
      boostbox.pack_start(label, False, False, 0)
      label.show()
      lvbox.add(boostbox)
      boostbox.show()
      
      ceilingbox = gtk.HBox()
      ceilingbox.set_spacing(3)
      self.normceiling_adj = gtk.Adjustment(-12.0, -25.0, 0.0, 0.1, 0.2, 0.2)
      normceiling = gtk.SpinButton(self.normceiling_adj, 1, 1)
      normceiling.connect("value-changed", self.cb_normalizer)
      sizegroup.add_widget(normceiling)
      ceilingbox.pack_start(normceiling, False, False, 0)
      normceiling.show()
      label = gtk.Label(normceiling_text)
      ceilingbox.pack_start(label, False, False, 0)
      label.show()
      lvbox.add(ceilingbox)
      ceilingbox.show()
      
      defaultsbox = gtk.HBox()
      self.normdefaults = gtk.Button(normdefaults_text)
      self.normdefaults.connect("clicked", self.normalizer_defaults)
      defaultsbox.pack_start(self.normdefaults, True, False, 0)
      self.normdefaults.show()
      mvbox.pack_start(defaultsbox, True, False, 0)
      defaultsbox.show()
      
      sizegroup = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
      
      risebox = gtk.HBox()
      risebox.set_spacing(3)
      self.normrise_adj = gtk.Adjustment(120000.0, 1.0, 999999.0, 1.0, 5.0, 5.0)
      normrise = gtk.SpinButton(self.normrise_adj, 1, 0)
      normrise.connect("value-changed", self.cb_normalizer)
      sizegroup.add_widget(normrise)
      risebox.pack_start(normrise, False, False, 0)
      normrise.show()
      label = gtk.Label(normrise_text)
      risebox.pack_start(label, False, False, 0)
      label.show()
      rvbox.add(risebox)
      risebox.show()
      
      fallbox = gtk.HBox()
      fallbox.set_spacing(3)
      self.normfall_adj = gtk.Adjustment(90000.0, 1.0, 999999.0, 1.0, 5.0, 5.0)
      normfall = gtk.SpinButton(self.normfall_adj, 1, 0)
      normfall.connect("value-changed", self.cb_normalizer)
      sizegroup.add_widget(normfall)
      fallbox.pack_start(normfall, False, False, 0)
      normfall.show()
      label = gtk.Label(normfall_text)
      fallbox.pack_start(label, False, False, 0)
      label.show()
      rvbox.add(fallbox)
      fallbox.show()
      
      # Autopause configuration
      
      frame = gtk.Frame(" " + autopause_text + " ")
      frame.set_border_width(3)
      hbox = gtk.HBox()
      hbox.set_spacing(10)
      hbox.set_border_width(10)
      frame.add(hbox)
      hbox.show()
      ondelaybox = gtk.HBox()
      hbox.pack_start(ondelaybox, False, False, 0)
      ondelaybox.show()
      offthreshbox = gtk.HBox()
      hbox.pack_start(offthreshbox, True, False, 0)
      offthreshbox.show()
      startupbox = gtk.HBox()
      hbox.pack_end(startupbox, False, False, 0)
      startupbox.show()
      
      self.ap_on_delay_adj = gtk.Adjustment(0.25, 0.1, 2.0, 0.05, 0.1, 0.1)
      self.ap_on_delay = gtk.SpinButton(self.ap_on_delay_adj, 4, 2)
      self.ap_on_delay.connect("value-changed", self.cb_autopause, "on_delay changed")
      self.ap_on_delay.emit("value-changed")
      ondelaybox.pack_start(self.ap_on_delay, False, False, 0)
      self.ap_on_delay.show()
      label = gtk.Label(" " + ap_on_delay_text)
      ondelaybox.pack_start(label, False, False, 0)
      label.show()
      
      self.ap_off_thresh_adj = gtk.Adjustment(-40.0, -60.0, 0.0, 1.0, 1.0, 1.0)
      self.ap_off_thresh = gtk.SpinButton(self.ap_off_thresh_adj)
      self.ap_off_thresh.connect("value-changed", self.cb_autopause, "off_thresh changed")
      self.ap_off_thresh.emit("value-changed")
      offthreshbox.pack_start(self.ap_off_thresh, False, False, 0)
      self.ap_off_thresh.show()
      label = gtk.Label(" " + ap_off_thresh_text)
      offthreshbox.pack_start(label, False, False, 0)
      label.show()
      
      self.ap_startup_pref = gtk.CheckButton(ap_startup_pref_text)
      startupbox.pack_start(self.ap_startup_pref, False, False, 0)
      self.ap_startup_pref.show()
      
      outervbox.pack_start(frame, False, False, 0)
      frame.show()
      
      # Player settings at application start selection
      
      frame = gtk.Frame(" " + initial_player_settings_text + " ")
      frame.set_border_width(3)
      vbox = gtk.VBox()
      frame.add(vbox)
      vbox.show()
      
      restoresessionhbox = gtk.HBox()
      restoresessionhbox.set_border_width(8)
      restoresessionhbox.show()
      self.restore_session_option = gtk.CheckButton(restore_session_text)
      vbox.pack_start(restoresessionhbox, False, False, 0)
      restoresessionhbox.pack_start(self.restore_session_option, False, False, 0)
      self.restore_session_option.show()
      
      hbox = gtk.HBox()
      vbox.add(hbox)
      hbox.set_border_width(3)
      
      self.left_player_frame = gtk.Frame(" " + player_1_text + " ")
      self.left_player_frame.set_border_width(2)
      hbox.pack_start(self.left_player_frame, True, True, 6)
      self.left_player_frame.show()
      
      self.right_player_frame = gtk.Frame(" " + player_2_text + " ")
      self.right_player_frame.set_border_width(2)
      hbox.pack_start(self.right_player_frame, True, True, 6)
      self.right_player_frame.show()

      hbox.show()
      
      lvbox = gtk.VBox()
      lvbox.set_border_width(4)
      self.left_player_frame.add(lvbox)
      self.lplayall = gtk.RadioButton(None, play_all_text)
      self.lplayall.set_border_width(1)
      lvbox.add(self.lplayall)
      self.lplayall.show()
      self.lloopall = gtk.RadioButton(self.lplayall, loop_all_text)
      self.lloopall.set_border_width(1)
      lvbox.add(self.lloopall)
      self.lloopall.show()
      self.lrandom = gtk.RadioButton(self.lloopall, random_text)
      self.lrandom.set_border_width(1)
      lvbox.add(self.lrandom)
      self.lrandom.show()
      self.lmanual = gtk.RadioButton(self.lrandom, manual_text)
      self.lmanual.set_border_width(1)
      lvbox.add(self.lmanual)
      self.lmanual.show()
      self.lcueup = gtk.RadioButton(self.lmanual, cue_up_text)
      self.lcueup.set_border_width(1)
      lvbox.add(self.lcueup)
      self.lcueup.show()
      separator = gtk.HSeparator()
      lvbox.pack_start(separator, False, False, 1)
      separator.show()
      self.lcountup = gtk.RadioButton(None, count_up_text)
      self.lcountup.set_border_width(1)
      lvbox.add(self.lcountup)
      self.lcountup.show()
      self.lcountdown = gtk.RadioButton(self.lcountup, count_down_text)
      self.lcountdown.set_border_width(1)
      lvbox.add(self.lcountdown)
      self.lcountdown.show()
      separator = gtk.HSeparator()
      lvbox.pack_start(separator, False, False, 1)
      separator.show()
      self.lstream = gtk.CheckButton(stream_text)
      self.lstream.set_border_width(1)
      self.lstream.set_active(True)
      lvbox.add(self.lstream)
      self.lstream.show()
      self.llisten = gtk.CheckButton(listen_text)
      self.llisten.set_border_width(1)
      self.llisten.set_active(True)
      lvbox.add(self.llisten)
      self.llisten.show()
      
      lvbox.show()
      
      rvbox = gtk.VBox()
      rvbox.set_border_width(4)
      self.right_player_frame.add(rvbox)
      self.rplayall = gtk.RadioButton(None, play_all_text)
      self.rplayall.set_border_width(1)
      rvbox.add(self.rplayall)
      self.rplayall.show()
      self.rloopall = gtk.RadioButton(self.rplayall, loop_all_text)
      self.rloopall.set_border_width(1)
      rvbox.add(self.rloopall)
      self.rloopall.show()
      self.rrandom = gtk.RadioButton(self.rloopall, random_text)
      self.rrandom.set_border_width(1)
      rvbox.add(self.rrandom)
      self.rrandom.show()
      self.rmanual = gtk.RadioButton(self.rrandom, manual_text)
      self.rmanual.set_border_width(1)
      rvbox.add(self.rmanual)
      self.rmanual.show()
      self.rcueup = gtk.RadioButton(self.rmanual, cue_up_text)
      self.rcueup.set_border_width(1)
      rvbox.add(self.rcueup)
      self.rcueup.show()
      separator = gtk.HSeparator()
      rvbox.pack_start(separator, False, False, 1)
      separator.show()
      self.rcountup = gtk.RadioButton(None, count_up_text)
      self.rcountup.set_border_width(1)
      rvbox.add(self.rcountup)
      self.rcountup.show()
      self.rcountdown = gtk.RadioButton(self.rcountup, count_down_text)
      self.rcountdown.set_border_width(1)
      rvbox.add(self.rcountdown)
      self.rcountdown.show()
      separator = gtk.HSeparator()
      rvbox.pack_start(separator, False, False, 1)
      separator.show()
      self.rstream = gtk.CheckButton(stream_text)
      self.rstream.set_border_width(1)
      self.rstream.set_active(True)
      rvbox.add(self.rstream)
      self.rstream.show()
      self.rlisten = gtk.CheckButton(listen_text)
      self.rlisten.set_border_width(1)
      self.rlisten.set_active(True)
      rvbox.add(self.rlisten)
      self.rlisten.show()
      rvbox.show()
      
      self.misc_session_frame = gtk.Frame()
      self.misc_session_frame.set_border_width(4)
      misc_startup = gtk.HBox(True, 20)
      self.misc_session_frame.add(misc_startup)
      misc_startup.show()
      hbox2 = gtk.HBox()
      hbox2.pack_start(self.misc_session_frame, True, True, 7)
      hbox2.show()
      
      vbox.pack_start(hbox2, False, False, 2)
      self.misc_session_frame.show()
      misc_startupl = gtk.VBox()
      misc_startup.pack_start(misc_startupl, True, True, 5)
      misc_startupl.show()
      misc_startupr = gtk.VBox()
      misc_startup.pack_start(misc_startupr, True, True, 5)
      misc_startupr.show()
      
      self.tracks_played = gtk.CheckButton(tracks_played_text)
      misc_startupl.add(self.tracks_played)
      self.tracks_played.show()
      self.stream_mon = gtk.CheckButton(stream_monitor_text)
      misc_startupr.add(self.stream_mon)
      self.stream_mon.show()
      
      self.restore_session_option.connect("toggled", self.cb_restore_session)
      self.restore_session_option.set_active(True)
     
      outervbox.pack_start(frame, False, False, 0)
      frame.show() 
            
      features_label = gtk.Label(general_tab_text)
      self.notebook.append_page(generalwindow, features_label)
      features_label.show()
      outervbox.show()
	 
      # Microphone tab
      
      mic_window = gtk.ScrolledWindow()
      mic_window.set_shadow_type(gtk.SHADOW_NONE)
      mic_window.set_border_width(8)
      mic_window.set_policy(gtk.POLICY_NEVER, gtk.POLICY_AUTOMATIC)
      viewport = gtk.Viewport()
      mic_window.add(viewport)
      mic_window.show()
      panevbox = gtk.VBox()
      panevbox.set_border_width(3)
      viewport.add(panevbox)
      viewport.show()
      
      compressorframe = gtk.Frame(" " + dnr_compressor_text + " ")
      panevbox.pack_start(compressorframe, False, False, 0)
      panevbox.show()
      compressorframe.set_border_width(3)
      compressorhbox = gtk.HBox()
      compressorframe.add(compressorhbox)
      compressortable = gtk.Table(4, 3, True)
      compressorhbox.pack_start(compressortable, True, True, 15)
      compressorhbox.show()
      compressortable.show()
      compressorframe.show()
      
      compressortable.set_col_spacing(0, 12)
      compressortable.set_col_spacing(1, 16)
      
      ratio_box = gtk.HBox()
      compressortable.attach(ratio_box, 0, 1, 0, 1, gtk.FILL | gtk.EXPAND, 0, 0, 0)
      ratio_box.show()
      knee_box = gtk.HBox()
      compressortable.attach(knee_box, 1, 2, 0, 1, gtk.FILL | gtk.EXPAND, 0, 0, 0)
      knee_box.show()
      depth_box = gtk.HBox()
      compressortable.attach(depth_box, 2, 3, 0, 1, gtk.FILL | gtk.EXPAND, 0, 0, 0)
      depth_box.show()
      
      attack_box = gtk.HBox()
      compressortable.attach(attack_box, 1, 2, 1, 2, gtk.FILL | gtk.EXPAND, 0, 0, 0)
      attack_box.show()
      release_box = gtk.HBox()
      compressortable.attach(release_box, 1, 2, 2, 3, gtk.FILL | gtk.EXPAND, 0, 0, 0)
      release_box.show()
      gain_box = gtk.HBox()
      compressortable.attach(gain_box, 2, 3, 1, 2, gtk.FILL | gtk.EXPAND, 0, 0, 0)
      gain_box.show()
      man_rel_box=gtk.VBox()
      compressortable.attach(man_rel_box, 2, 3, 2, 3, gtk.FILL | gtk.EXPAND, 0, 0, 0)
      man_rel_box.show()
      
      ducking_box = gtk.HBox()
      compressortable.attach(ducking_box, 0, 1, 3, 4, gtk.FILL | gtk.EXPAND, 0, 0, 0)
      ducking_box.show()
      ducking_hold_box = gtk.HBox()
      compressortable.attach(ducking_hold_box, 1, 2, 3, 4, gtk.FILL | gtk.EXPAND, 0, 0, 0)
      ducking_hold_box.show()
      de_ess_box = gtk.HBox()
      compressortable.attach(de_ess_box, 2, 3, 3, 4, gtk.FILL | gtk.EXPAND, 0, 0, 0)
      de_ess_box.show()
      rms_frame = gtk.Frame(" " + rms_text + " ")
      rms_frame.set_border_width(4)
      compressortable.attach(rms_frame, 0, 1, 1, 3, gtk.FILL | gtk.EXPAND, gtk.FILL | gtk.EXPAND, 0, 0)
      rms_frame.show()
                  
      self.ratio_adj = gtk.Adjustment(3.0, 1.0, 20.0, 0.5, 0.5, 0.5) 
      self.ratio = gtk.SpinButton(self.ratio_adj, 0.0, 1)
      self.ratio.connect("value-changed", self.cb_compressor, "ratio")
      ratio_box.pack_start(self.ratio, False, False, 0)
      self.ratio.show()
      label = gtk.Label(" " + comp_ratio_text)
      ratio_box.pack_start(label, False, False, 0)
      label.show()
      
      self.knee_adj = gtk.Adjustment(-13.0, -99.0, 0.0, 1.0, 1.0, 1.0)
      self.knee = gtk.SpinButton(self.knee_adj, 0.5, 0)
      self.knee.connect("value-changed", self.cb_compressor, "knee")
      knee_box.pack_start(self.knee, False, False, 0)
      self.knee.show()
      label = gtk.Label(" " + comp_knee_text)
      knee_box.pack_start(label, False, False, 0)
      label.show()
      
      self.depth_adj = gtk.Adjustment(27.0, 0.0, 99.0, 1.0, 1.0, 1.0)
      self.depth = gtk.SpinButton(self.depth_adj, 0.5, 0)
      self.depth.connect("value-changed", self.cb_compressor, "depth")
      depth_box.pack_start(self.depth, False, False, 0)
      self.depth.show()
      label = gtk.Label(" " + comp_depth_text)
      depth_box.pack_start(label, False, False, 0)
      label.show()

      self.attack_adj = gtk.Adjustment(100.0, 1.0, 9999.0, 1.0, 1.0, 1.0)
      self.attack = gtk.SpinButton(self.attack_adj, 0.9, 0)
      self.attack.connect("value-changed", self.cb_compressor, "attack")
      attack_box.pack_start(self.attack, False, False, 0)
      self.attack.show()
      label = gtk.Label(" " + comp_attack_text)
      attack_box.pack_start(label, False, False, 0)
      label.show()
      
      self.release_adj = gtk.Adjustment(8000.0, 1.0, 99999, 1.0, 1.0, 1.0)
      self.release = gtk.SpinButton(self.release_adj, 0.9, 0)
      self.release.connect("value-changed", self.cb_compressor, "release")
      release_box.pack_start(self.release, False, False, 0)
      self.release.show()
      label = gtk.Label(" " + comp_release_text)
      release_box.pack_start(label, False, False, 0)
      label.show()
      
      self.gain_adj = gtk.Adjustment(5.0, -60.0, 60.0, 1.0, 1.0, 1.0)
      self.gain = gtk.SpinButton(self.gain_adj, 0.5, 0)
      #sizegroup2.add_widget(self.gain)
      self.gain.connect("value-changed", self.cb_compressor, "gain")
      gain_box.pack_start(self.gain, False, False, 0)
      self.gain.show()
      label = gtk.Label(" " + comp_gain_text)
      gain_box.pack_start(label, False, False, 0)
      label.show()
      
      self.gain_relative = gtk.RadioButton(None, comp_relative_text)
      man_rel_box.pack_start(self.gain_relative, False, False, 0)
      self.gain_relative.connect("toggled", self.cb_compressor, "relative")
      self.gain_relative.show()
      self.gain_manual = gtk.RadioButton(self.gain_relative, comp_manual_text)
      self.gain_manual.connect("toggled", self.cb_compressor, "manual")
      man_rel_box.pack_start(self.gain_manual, False, False, 0)
      self.gain_manual.show()
      
      self.ducking_adj = gtk.Adjustment(1.6, 0.0, 3.0, 0.1, 0.1, 1.0)
      self.ducking = gtk.SpinButton(self.ducking_adj, 0, 1)
      self.ducking.connect("value-changed", self.cb_compressor, "ducking")
      ducking_box.pack_start(self.ducking, False, False, 0)
      self.ducking.show()
      label = gtk.Label(" " + comp_ducking_text)
      ducking_box.pack_start(label, False, False, 0)
      label.show()
      
      self.ducking_hold_adj = gtk.Adjustment(30000.0, 0.0, 99999, 1000.0, 1000.0, 1000.0)
      self.ducking_hold = gtk.SpinButton(self.ducking_hold_adj, 0, 0)
      self.ducking_hold.connect("value-changed", self.cb_compressor, "duckhold")
      ducking_hold_box.pack_start(self.ducking_hold, False, False, 0)
      self.ducking_hold.show()
      label = gtk.Label(" " + comp_duckhold_text)
      ducking_hold_box.pack_start(label, False, False, 0)
      label.show()

      self.de_ess_adj = gtk.Adjustment(30.0, 0.0, 40.0, 0.5, 0.5, 0.5)
      self.de_ess = gtk.SpinButton(self.de_ess_adj, 0, 1)
      self.de_ess.connect("value-changed", self.cb_compressor, "de-ess")
      de_ess_box.pack_start(self.de_ess, False, False, 0)
      label = gtk.Label(" " + comp_de_ess_text)
      de_ess_box.pack_start(label, False, False, 0)
      label.show()
      self.de_ess.show()
      
      rms_hbox = gtk.HBox()
      rms_vbox = gtk.VBox()
      rms_hbox.pack_start(rms_vbox, True, False, 0)
      rms_frame.add(rms_hbox)
      rms_hbox.show()
      rms_vbox.show()
      self.filter_fast = gtk.RadioButton(None, filter_fast_text)
      self.filter_fast.connect("toggled", self.cb_compressor, "filterfast")
      rms_vbox.add(self.filter_fast)
      self.filter_fast.show()
      self.filter_slow = gtk.RadioButton(self.filter_fast, filter_slow_text)
      self.filter_slow.connect("toggled", self.cb_compressor, "filterslow")
      rms_vbox.add(self.filter_slow)
      self.filter_slow.show()
      
      # Noise gate
      
      gatehbox = gtk.HBox()
      gatehbox.set_border_width(7)
      gateframe = gtk.Frame(" " + noise_gate_text + " ")
      gateframe.set_border_width(3)
      gateframe.add(gatehbox)
      gatehbox.show()
      panevbox.pack_start(gateframe, False, False, 0)
      gateframe.show()

      gateboxcol1 = gtk.VBox()
      gateboxcol1.set_spacing(11)
      gatehbox.pack_start(gateboxcol1, True, False, 0)
      gateboxcol1.show()
      gateboxcol2 = gtk.VBox()
      gateboxcol2.set_spacing(11)
      gatehbox.pack_start(gateboxcol2, True, False, 0)
      gateboxcol2.show()
      gateboxcol3 = gtk.VBox()
      gateboxcol3.set_spacing(11)
      gatehbox.pack_start(gateboxcol3, True, False, 0)
      gateboxcol3.show()
            
      gatethreshbox = gtk.HBox()
      gateboxcol1.add(gatethreshbox)
      gatethreshbox.show()
      
      gatehystbox = gtk.HBox()
      gateboxcol2.add(gatehystbox)
      gatehystbox.show()
      
      gatedelaybox = gtk.HBox()
      gateboxcol3.add(gatedelaybox)
      gatedelaybox.show()
      
      gateattenbox = gtk.HBox()
      gateboxcol1.add(gateattenbox)
      gateattenbox.show()
      
      gateontimebox = gtk.HBox()
      gateboxcol2.add(gateontimebox)
      gateontimebox.show()
      
      gateofftimebox = gtk.HBox()
      gateboxcol3.add(gateofftimebox)
      gateofftimebox.show()
      
      sizegroup = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
      
      self.gate_threshold_adj = gtk.Adjustment(-47.0, -99.0, 0.0, 1.0, 1.0, 1.0)
      self.gate_threshold = gtk.SpinButton(self.gate_threshold_adj, 0.5, 0)
      self.gate_threshold.connect("value-changed", self.cb_noisegate, "threshold")
      gatethreshbox.pack_start(self.gate_threshold, False, False, 0)
      self.gate_threshold.show()
      label = gtk.Label(" " + threshold_text)
      gatethreshbox.pack_start(label, False, False, 0)
      label.show()      
      
      self.gate_hyster_adj = gtk.Adjustment(6.0, 0.0, 10.0, 1.0, 1.0, 1.0)
      self.gate_hyster = gtk.SpinButton(self.gate_hyster_adj, 0, 0)
      sizegroup.add_widget(self.gate_hyster)
      self.gate_hyster.connect("value-changed", self.cb_noisegate, "hysteresis")
      gatehystbox.pack_start(self.gate_hyster, False, False, 0)
      self.gate_hyster.show()
      label = gtk.Label(" " + hysteresis_text)
      gatehystbox.pack_start(label, False, False, 0)
      label.show()      
      
      self.gate_delay_adj = gtk.Adjustment(800.0, 1.0, 99999.0, 1.0, 1.0, 1.0)
      self.gate_delay = gtk.SpinButton(self.gate_delay_adj, 0.5, 0)
      self.gate_delay.connect("value-changed", self.cb_noisegate, "delay")
      gatedelaybox.pack_start(self.gate_delay, False, False, 0)
      self.gate_delay.show()
      label = gtk.Label(" " + ng_delay_text)
      gatedelaybox.pack_start(label, False, False, 0)
      label.show()      
      
      self.gate_attenuation_adj = gtk.Adjustment(-3.0, -60.0, 0.0, 1.0, 1.0, 1.0)
      self.gate_attenuation = gtk.SpinButton(self.gate_attenuation_adj, 0.5, 0)
      self.gate_attenuation.connect("value-changed", self.cb_noisegate, "attenuation")
      gateattenbox.pack_start(self.gate_attenuation, False, False, 0)
      self.gate_attenuation.show()
      label = gtk.Label(" " + attenuation_text)
      gateattenbox.pack_start(label, False, False, 0)
      label.show()      
      
      self.gate_ontime_adj = gtk.Adjustment(55.0, 1.0, 9999.0, 1.0, 1.0, 1.0)
      self.gate_ontime = gtk.SpinButton(self.gate_ontime_adj, 0.5, 0)
      sizegroup.add_widget(self.gate_ontime)
      self.gate_ontime.connect("value-changed", self.cb_noisegate, "ontime")
      gateontimebox.pack_start(self.gate_ontime, False, False, 0)
      self.gate_ontime.show()
      label = gtk.Label(" " + rise_text)
      gateontimebox.pack_start(label, False, False, 0)
      label.show()      
      
      self.gate_offtime_adj = gtk.Adjustment(500.0, 1.0, 99999.0, 1.0, 1.0, 1.0)
      self.gate_offtime = gtk.SpinButton(self.gate_offtime_adj, 0.5, 0)
      self.gate_offtime.connect("value-changed", self.cb_noisegate, "offtime")
      gateofftimebox.pack_start(self.gate_offtime, False, False, 0)
      self.gate_offtime.show()
      label = gtk.Label(" " + fall_text)
      gateofftimebox.pack_start(label, False, False, 0)
      label.show()
      
      # Mic mix and filter options
      
      self.mic_filter = 0		# The type of filter to use for the mic filter
      frame = gtk.Frame(" " + af_h_sm_text + " ")
      frame.set_border_width(3)
      vbox = gtk.VBox()
      frame.add(vbox)
      vbox.show()
      frame.show()
      
      filterbox = gtk.HBox()
      filterbox.set_border_width(6)
      vbox.pack_start(filterbox, False, False, 0)
      filterbox.show()

      label = gtk.Label(bass_cut_text)
      filterbox.pack_start(label, False, False, 5)
      label.show()
      self.filter_off = gtk.RadioButton(None, off_text)
      self.filter_off.connect("toggled", self.cb_mic, "filter_off")
      filterbox.pack_start(self.filter_off, False, False, 3)
      self.filter_off.show()
      self.filter_mild = gtk.RadioButton(self.filter_off, mild_text)
      self.filter_mild.connect("toggled", self.cb_mic, "filter_mild")
      filterbox.pack_start(self.filter_mild, False, False, 3)
      self.filter_mild.show()
      self.filter_sharp = gtk.RadioButton(self.filter_mild, sharp_text)
      self.filter_sharp.connect("toggled", self.cb_mic, "filter_sharp")
      filterbox.pack_start(self.filter_sharp, False, False, 3)
      self.filter_sharp.show()
      vsep = gtk.VSeparator()
      filterbox.pack_start(vsep, True, False, 0)
      vsep.show()
      headroom_box = gtk.HBox()
      filterbox.pack_end(headroom_box, False, False, 6)
      self.headroom_adj = gtk.Adjustment(3.0, 0.0, 10.0, 0.5, 0.5, 0.5)
      self.headroom = gtk.SpinButton(self.headroom_adj, 0, 1)
      self.headroom.connect("value-changed", self.cb_mic, "headroom")
      headroom_box.pack_start(self.headroom, False, False, 0)
      self.headroom.show()
      label = gtk.Label(" " + headroom_text)
      headroom_box.pack_start(label, False, False, 0)
      label.show()
      headroom_box.show()
      
      # Left mic mix settings
      
      left_mic_mix_box = gtk.HBox()
      left_mic_mix_box.set_border_width(2)
      vbox.pack_start(left_mic_mix_box, False, False, 0)
      left_mic_mix_box.show()
      
      label = gtk.Label(left_text)
      left_mic_mix_box.pack_start(label, False, False, 8)
      label.show()
      
      balance_box = gtk.HBox()
      label = gtk.Label(l_text)
      balance_box.pack_start(label, False, False, 2)
      label.show()
      self.left_mic_mix_adj = gtk.Adjustment(0.0, 0.0, 100.0, 1.0, 3.0, 0.0)
      self.left_mic_mix_slider = gtk.HScale(self.left_mic_mix_adj)
      self.left_mic_mix_slider.connect("value-changed", self.cb_mic, "lmms_changed")
      self.left_mic_mix_slider.set_size_request(100, -1)
      self.left_mic_mix_slider.set_draw_value(False)
      balance_box.pack_start(self.left_mic_mix_slider, False, False, 0)
      self.left_mic_mix_slider.show()
      label = gtk.Label(r_text)
      balance_box.pack_start(label, False, False, 2)
      label.show()
      left_mic_mix_box.pack_end(balance_box, False, False, 8)
      balance_box.show()
      
      level_box = gtk.HBox()
      self.left_mic_level_adj = gtk.Adjustment(0.0, -20.0, 0.0, 1.0, 1.0, 1.0)
      self.left_mic_level = gtk.SpinButton(self.left_mic_level_adj)
      self.left_mic_level.connect("value-changed", self.cb_mic, "lmgs_changed")
      level_box.pack_start(self.left_mic_level, False, False, 0)
      self.left_mic_level.show()
      label = gtk.Label(" " + level_text)
      level_box.pack_start(label, False, False, 0)
      label.show()
      left_mic_mix_box.pack_end(level_box, False, False, 8)
      level_box.show()
      
      self.left_invert = gtk.CheckButton(" " + invert_text)
      self.left_invert.connect("toggled", self.cb_mic, "left_invert")
      left_mic_mix_box.pack_end(self.left_invert, False, False, 8)
      self.left_invert.show()             

      # Right mic mix settings
      
      right_mic_mix_box = gtk.HBox()
      right_mic_mix_box.set_border_width(2)
      vbox.pack_start(right_mic_mix_box, False, False, 0)
      right_mic_mix_box.show()
      
      label = gtk.Label(right_text)
      right_mic_mix_box.pack_start(label, False, False, 8)
      label.show()
      
      balance_box = gtk.HBox()
      label = gtk.Label(l_text)
      balance_box.pack_start(label, False, False, 2)
      label.show()
      self.right_mic_mix_adj = gtk.Adjustment(100.0, 0.0, 100.0, 1.0, 3.0, 0.0)
      self.right_mic_mix_slider = gtk.HScale(self.right_mic_mix_adj)
      self.right_mic_mix_slider.connect("value-changed", self.cb_mic, "rmms_changed")
      self.right_mic_mix_slider.set_size_request(100, -1)
      self.right_mic_mix_slider.set_draw_value(False)
      balance_box.pack_start(self.right_mic_mix_slider, False, False, 0)
      self.right_mic_mix_slider.show()
      label = gtk.Label(r_text)
      balance_box.pack_start(label, False, False, 2)
      label.show()
      right_mic_mix_box.pack_end(balance_box, False, False, 8)
      balance_box.show()
      
      level_box = gtk.HBox()
      self.right_mic_level_adj = gtk.Adjustment(0.0, -20.0, 0.0, 1.0, 1.0, 1.0)
      self.right_mic_level = gtk.SpinButton(self.right_mic_level_adj)
      self.right_mic_level.connect("value-changed", self.cb_mic, "rmgs_changed")
      level_box.pack_start(self.right_mic_level, False, False, 0)
      self.right_mic_level.show()
      label = gtk.Label(" " + level_text)
      level_box.pack_start(label, False, False, 0)
      label.show()
      right_mic_mix_box.pack_end(level_box, False, False, 8)
      level_box.show()
      
      self.right_invert = gtk.CheckButton(" " + invert_text)
      self.right_invert.connect("toggled", self.cb_mic, "right_invert")
      right_mic_mix_box.pack_end(self.right_invert, False, False, 8)
      self.right_invert.show()             
            
      panevbox.pack_start(frame, False, False, 0)
      
      compressor_label = gtk.Label(microphone_tab_text)
      self.notebook.append_page(mic_window, compressor_label)
      compressor_label.show()
       
      # X-Chat IRC announcements tag.
      
      vbox = gtk.VBox()
      vbox.set_border_width(6)
      sizegroup = gtk.SizeGroup(gtk.SIZE_GROUP_VERTICAL)
      
      trackannouncerframe = gtk.Frame(" " + track_announcer_text + " ")
      trackannouncerframe.set_border_width(3)
      vbox.pack_start(trackannouncerframe, False, False, 0)
      announcervbox = gtk.VBox()
      announcervbox.set_border_width(5)
      trackannouncerframe.add(announcervbox)
      announcervbox.show()
      
      hbox = gtk.HBox()
      announcervbox.add(hbox)
      hbox.show()
      leftpaddingbox = gtk.VBox()
      leftpaddingbox.set_size_request(6, -1)
      hbox.pack_start(leftpaddingbox, False, False, 0)
      leftpaddingbox.show()
      leftvbox = gtk.VBox()
      hbox.pack_start(leftvbox, False, False, 0)
      leftvbox.show()
      rightvbox = gtk.VBox()
      hbox.pack_start(rightvbox, True, True, 0)
      rightvbox.show()
      paddingbox = gtk.VBox()
      paddingbox.set_size_request(6, -1)
      hbox.pack_start(paddingbox, False, False, 0)
      paddingbox.show()
      
      enablebox = gtk.HBox()
      self.announce_enable = gtk.CheckButton(" " + enable_text)
      sizegroup.add_widget(self.announce_enable)
      enablebox.pack_end(self.announce_enable, False, False, 0)
      self.announce_enable.show()
      enablebox.show()
      leftvbox.add(enablebox)
      enablebox.show()

      nickbox = gtk.HBox()
      self.nickentry = gtk.Entry()
      sizegroup.add_widget(self.nickentry)
      self.nickentry.set_width_chars(14)
      self.nickentry.set_max_length(30)
      nickbox.pack_end(self.nickentry, False, False, 0)
      self.nickentry.show()
      nicklabel = gtk.Label(nick_text + " ")
      nickbox.pack_end(nicklabel, False, False, 0)
      nicklabel.show()
      
      delaybox = gtk.HBox()
      nickbox.pack_end(delaybox, False, False, 14)
      delaybox.show()
      delaylabel = gtk.Label(latency_text + " ")
      delaybox.pack_start(delaylabel, False, False, 0)
      delaylabel.show()
      self.announcedelayadj = gtk.Adjustment(10.0, 1.0, 60.0, 1.0, 1.0, 1.0)
      delay = gtk.SpinButton(self.announcedelayadj, 4, 0)
      delaybox.pack_start(delay, False, False, 0)
      delay.show()
      
      rightvbox.pack_start(nickbox, False, False, 1)
      nickbox.show()
      
      channelslabel = gtk.Label(channels_text + " ")
      sizegroup.add_widget(channelslabel)
      channelslabelbox = gtk.HBox()
      channelslabelbox.pack_end(channelslabel, False, False, 0)
      channelslabel.show()
      leftvbox.add(channelslabelbox)
      channelslabelbox.show()
      
      self.channelsentry = gtk.Entry()
      sizegroup.add_widget(self.channelsentry)
      channelsbox = gtk.HBox()
      channelsbox.pack_start(self.channelsentry, True, True, 0)
      self.channelsentry.show()
      rightvbox.pack_start(channelsbox, False, False, 1)
      channelsbox.show()
      
      announcemessagelabel = gtk.Label(message_text + " ")
      sizegroup.add_widget(announcemessagelabel)
      announcemessagelabelbox = gtk.HBox()
      announcemessagelabelbox.pack_end(announcemessagelabel, False, False, 0)
      announcemessagelabel.show()
      leftvbox.add(announcemessagelabelbox)
      announcemessagelabelbox.show()
      
      self.announcemessageentry = gtk.Entry()
      sizegroup.add_widget(self.announcemessageentry)
      announcemessagebox = gtk.HBox()
      announcemessagebox.pack_start(self.announcemessageentry, True, True, 0)
      self.announcemessageentry.show()
      rightvbox.pack_start(announcemessagebox, False, False, 1)
      self.announcemessageentry.connect("populate-popup", self.colourmenupopulate)
      self.announcemessageentry.connect("key-press-event", self.cb_handle_colour_char)
      announcemessagebox.show()
      
      trackannouncerframe.show()
      
      timerframe = gtk.Frame(" " + irc_message_timer_text + " ")
      timerframe.set_border_width(3)
      vbox.pack_start(timerframe, False, False, 2)
      timerframe.show()
      timervbox = gtk.VBox()
      timervbox.set_border_width(5)
      timerframe.add(timervbox)
      timervbox.show()
      
      hbox = gtk.HBox()
      timervbox.add(hbox)
      hbox.show()
      leftpaddingbox = gtk.VBox()
      leftpaddingbox.set_size_request(6,-1)
      hbox.pack_start(leftpaddingbox, False, False, 0)
      leftpaddingbox.show()
      leftvbox = gtk.VBox()
      hbox.pack_start(leftvbox, False, False, 0)
      leftvbox.show()
      rightvbox = gtk.VBox()
      hbox.pack_start(rightvbox, True, True, 0)
      rightvbox.show()
      paddingbox = gtk.VBox()
      paddingbox.set_size_request(6, -1)
      hbox.pack_start(paddingbox, False, False, 0)
      paddingbox.show()
      
      enablebox = gtk.HBox()
      self.timer_enable = gtk.CheckButton(" " + enable_text)
      sizegroup.add_widget(self.timer_enable)
      enablebox.pack_end(self.timer_enable, False, False, 0)
      self.timer_enable.show()
      enablebox.show()
      leftvbox.add(enablebox)
      enablebox.show()

      nickbox = gtk.HBox()
      self.timernickentry = gtk.Entry()
      sizegroup.add_widget(self.timernickentry)
      self.timernickentry.set_width_chars(14)
      self.timernickentry.set_max_length(30)
      nickbox.pack_end(self.timernickentry, False, False, 0)
      self.timernickentry.show()
      nicklabel = gtk.Label(nick_text + " ")
      nickbox.pack_end(nicklabel, False, False, 0)
      nicklabel.show()
      intervalbox = gtk.HBox()
      nickbox.pack_end(intervalbox, False, False, 14)
      intervalbox.show()
      intervallabel = gtk.Label(interval_text + " ")
      intervalbox.pack_start(intervallabel, False, False, 0)
      intervallabel.show()
      self.intervaladj = gtk.Adjustment(20.0, 1.0, 60.0, 1.0, 1.0, 1.0)
      interval = gtk.SpinButton(self.intervaladj, 4, 0)
      intervalbox.pack_start(interval, False, False, 0)
      interval.show()
      rightvbox.pack_start(nickbox, True, True, 1)
      nickbox.show()
      
      channelslabel = gtk.Label(channels_text + " ")
      sizegroup.add_widget(channelslabel)
      channelslabelbox = gtk.HBox()
      channelslabelbox.pack_end(channelslabel, False, False, 0)
      channelslabel.show()
      leftvbox.add(channelslabelbox)
      channelslabelbox.show()
      
      self.timerchannelsentry = gtk.Entry()
      sizegroup.add_widget(self.timerchannelsentry)
      channelsbox = gtk.HBox()
      channelsbox.pack_start(self.timerchannelsentry, True, True, 0)
      self.timerchannelsentry.show()
      rightvbox.pack_start(channelsbox, True, True, 1)
      channelsbox.show()
      
      timemessagelabel = gtk.Label(message_text + " ")
      sizegroup.add_widget(timemessagelabel)
      timemessagelabelbox = gtk.HBox()
      timemessagelabelbox.pack_end(timemessagelabel, False, False, 0)
      timemessagelabel.show()
      leftvbox.add(timemessagelabelbox)
      timemessagelabelbox.show()
      
      self.timermessageentry = gtk.Entry()
      sizegroup.add_widget(self.timermessageentry)
      timemessagebox = gtk.HBox()
      timemessagebox.pack_start(self.timermessageentry, True, True, 0)
      self.timermessageentry.show()
      rightvbox.pack_start(timemessagebox, True, True, 1)
      self.timermessageentry.connect("populate-popup", self.colourmenupopulate)
      self.timermessageentry.connect("key-press-event", self.cb_handle_colour_char)
      timemessagebox.show()
      
      timerframe.show()
      
      label1 = gtk.Label(song_placemarker_text)
      label2 = gtk.Label(name_placemarker_text)
      label3 = gtk.Label(desc_placemarker_text)
      label4 = gtk.Label(url_placemarker_text)
      hbox = gtk.HBox()
      hbox.add(label1)
      hbox.add(label2)
      hbox.add(label3)
      hbox.add(label4)
      vbox.pack_start(hbox, False, False, 2)
      hbox.show()
      label1.show()
      label2.show()
      label3.show()
      label4.show()
      
      irc_label = gtk.Label("X-Chat")
      self.notebook.append_page(vbox, irc_label)
      irc_label.show()
      vbox.show()
       
       
      # Jack settings Tab      
                 
      jack_window = gtk.ScrolledWindow()
      jack_window.set_border_width(8)
      jack_window.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
      jack_vbox = gtk.VBox()
      jack_vbox.set_spacing(3)
      jack_vbox.set_border_width(4)
      jack_window.add_with_viewport(jack_vbox)
      jack_window.show()
                  
      frame = gtk.Frame()
      frame.set_border_width(5)
      vbox = gtk.VBox(False, 0)
      frame.add(vbox)
      frame.show()
      
      
      box, self.miclcheck, self.miclentry, self.miclupdate = make_entry_line(self, "Mic L: ", "MICL")
      vbox.add(box)
      box, self.micrcheck, self.micrentry, self.micrupdate = make_entry_line(self, "Mic R: ", "MICR")
      vbox.add(box)
      jack_vbox.add(frame)
      vbox.show()
      self.miclentry.set_text("alsa_pcm:capture_1")
      self.micrentry.set_text("alsa_pcm:capture_2")
     
      frame = gtk.Frame()
      frame.set_border_width(5)
      vbox = gtk.VBox(False, 0)
      frame.add(vbox)
      frame.show()
      box, self.audlcheck, self.audlentry, self.audlupdate = make_entry_line(self, "Aud L: ", "AUDL")
      vbox.add(box)
      box, self.audrcheck, self.audrentry, self.audrupdate = make_entry_line(self, "Aud R: ", "AUDR")
      vbox.add(box)
      jack_vbox.add(frame)
      vbox.show()
      self.audlentry.set_text("alsa_pcm:playback_1")
      self.audrentry.set_text("alsa_pcm:playback_2")
      
      frame = gtk.Frame()
      frame.set_border_width(5)
      vbox = gtk.VBox(False, 0)
      frame.add(vbox)
      frame.show()
      box, self.strlcheck, self.strlentry, self.strlupdate = make_entry_line(self, "Str L: ", "STRL")
      vbox.add(box)
      box, self.strrcheck, self.strrentry, self.strrupdate = make_entry_line(self, "Str R: ", "STRR")
      vbox.add(box)
      jack_vbox.add(frame)
      vbox.show()
      self.strlentry.set_text("alsa_pcm:playback_5")
      self.strrentry.set_text("alsa_pcm:playback_6")
      
      frame = gtk.Frame()
      frame.set_border_width(5)
      vbox = gtk.VBox(False, 0)
      frame.add(vbox)
      frame.show()
      box, self.auxlcheck, self.auxlentry, self.auxlupdate = make_entry_line(self, "Aux L: ", "AUXL")
      vbox.add(box)
      box, self.auxrcheck, self.auxrentry, self.auxrupdate = make_entry_line(self, "Aux R: ", "AUXR")
      vbox.add(box)
      jack_vbox.add(frame)
      vbox.show()
      
      help_label = gtk.Label()
      help_label.set_line_wrap(True)
      help_label.set_markup(jack_help_text)
      jack_vbox.pack_start(help_label, False, False, 1)
      help_label.show()
      
      jacklabel = gtk.Label(jack_ports_tab_text)
      self.notebook.append_page(jack_window, jacklabel)
      jack_vbox.show()
      jacklabel.show()
      
      # event tab
      
      eventtabtips = gtk.Tooltips()
      eventtabtips.enable()
      
      vbox = gtk.VBox()
      vbox.set_border_width(4)
      vbox.set_spacing(2)
      
      app_event_container = self.event_command_container()
      self.appstart_event = self.event_command("icon", 20, 20, "amixer set Mic 0% mute cap ; " +
		'amixer set Capture 50% cap ; amixer set "Mic Boost (+20dB)" on', False, False, eventtabtips, app_start_tip_text, shell_commands_tip_text)
      app_event_container.add(self.appstart_event)
      self.appstart_event.show()
      self.appexit_event = self.event_command("icon", 20, 20, "", False, True, eventtabtips, app_exit_tip_text, shell_commands_tip_text)
      app_event_container.add(self.appexit_event)
      self.appexit_event.show()
      vbox.pack_start(app_event_container, False, False, 0)
      app_event_container.show()
      
      mic_event_container = self.event_command_container()
      self.mic_on_event = self.event_command("mic4", 20, 20, "", False, False, eventtabtips, mic_on_tip_text, shell_commands_tip_text)
      mic_event_container.add(self.mic_on_event)
      self.mic_on_event.show()
      self.mic_off_event = self.event_command("mic4", 20, 20, "", False, True, eventtabtips, mic_off_tip_text, shell_commands_tip_text)
      mic_event_container.add(self.mic_off_event)
      self.mic_off_event.show()
      vbox.pack_start(mic_event_container, False, False, 0)
      mic_event_container.show()
      
      aux_event_container = self.event_command_container()
      self.aux_on_event = self.event_command("jack2", 20, 20, "", False, False, eventtabtips, aux_on_tip_text, shell_commands_tip_text)
      aux_event_container.add(self.aux_on_event)
      self.aux_on_event.show()
      self.aux_off_event = self.event_command("jack2", 20, 20, "", False, True, eventtabtips, aux_off_tip_text, shell_commands_tip_text)
      aux_event_container.add(self.aux_off_event)
      self.aux_off_event.show()
      vbox.pack_start(aux_event_container, False, False, 0)
      aux_event_container.show()
      
      mutex_container = self.event_command_container()
      self.mic_aux_mutex = gtk.CheckButton(mic_aux_mutex_text)
      mutex_container.add(self.mic_aux_mutex)
      self.mic_aux_mutex.show()
      vbox.pack_start(mutex_container, False, False, 0)
      mutex_container.show()
      
      eventlabel = gtk.Label(event_tab_text)
      self.notebook.append_page(vbox, eventlabel)
      eventlabel.show()
      vbox.show()
      
      # about tab
      
      frame = gtk.Frame()
      frame.set_border_width(9)
      vbox = gtk.VBox()
      frame.add(vbox)
      label = gtk.Label()
      label.set_markup('<span font_desc="sans italic 20">' + self.parent.appname + '</span>')
      vbox.pack_start(label, False, False, 13)
      label.show()
      label = gtk.Label()
      label.set_markup('<span font_desc="sans 13">Version ' + self.parent.version + '</span>')
      vbox.pack_start(label, False, False, 0)
      label.show()
      
      pixbuf = gtk.gdk.pixbuf_new_from_file(pkgdatadir + "logo" + gfext)
      #pixbuf = pixbuf.scale_simple(265, 70, gtk.gdk.INTERP_BILINEAR)
      image = gtk.Image()
      image.set_from_pixbuf(pixbuf)
      vbox.pack_start(image, False, False, 8)
      image.show()
      
      label = gtk.Label()
      label.set_markup(u'<span font_desc="sans 13">' + self.parent.copyright + u'</span>')
      vbox.pack_start(label, False, False, 12)
      label.show()
      
      label = gtk.Label()
      label.set_markup('<span font_desc="sans 10">' + licence_text + '</span>')
      vbox.pack_start(label, False, False, 8)
      label.show()
      
      vbox.show()

      aboutlabel = gtk.Label(about_tab_text)
      self.notebook.append_page(frame, aboutlabel)
      aboutlabel.show()
      frame.show()
      
      self.notebook.show()

      # These shown by default
      self.mic_peak_toggle.set_active(True)
      self.stream_peak_toggle.set_active(True)
      self.limiter_toggle.set_active(True)
      self.enhanced_crossfade.set_active(True)
      self.djalarm.set_active(True)
      self.extm3u.set_active(True)
      self.dither.set_active(True)
      self.fastest_resample.set_active(True)
      
      self.load_jack_port_settings()
      self.bind_jack_ports()
      
      self.playersettingsdict = {	# Settings of these will be saved in the config file 
         "lplayall"      : self.lplayall,	# These are all True/False values
	 "lloopall"      : self.lloopall,
	 "lrandom"       : self.lrandom,
	 "lmanual"       : self.lmanual,
         "lcueup"	 : self.lcueup,
	 "lcountup"      : self.lcountup,
	 "lcountdown"    : self.lcountdown,
	 "lstream"       : self.lstream,
	 "llisten"       : self.llisten,
	 "rplayall"      : self.rplayall,
	 "rloopall"      : self.rloopall,
	 "rrandom"       : self.rrandom,
	 "rmanual"       : self.rmanual,
         "rcueup"	 : self.rcueup,
	 "rcountdown"    : self.rcountdown,
	 "rstream"       : self.rstream,
	 "rlisten"       : self.rlisten,
	 "startmini"     : self.startmini,
	 "micfiltmild"   : self.filter_mild,
	 "micfiltsharp"  : self.filter_sharp,
	 "micpeak"	 : self.mic_peak_toggle,
	 "vumeters"	 : self.vu_toggle,
	 "streampeak"	 : self.stream_peak_toggle,
	 "limitergain"   : self.limiter_toggle,
	 "comprelative"  : self.gain_relative,
         "filterslow"    : self.filter_slow,
	 "leftinvert"	 : self.left_invert,
	 "rightinvert"	 : self.right_invert,
         "fadeout2"	 : self.fadeout,
	 "announce_en"	 : self.announce_enable,
	 "timer_en"	 : self.timer_enable,
         "djalarm"	 : self.djalarm,
         "extm3u"	 : self.extm3u,
         "trxpld"	 : self.tracks_played,
         "strmon"	 : self.stream_mon,
         "autopause"     : self.ap_startup_pref,
         "bigdigibox"	 : self.bigger_box_toggle, 
         "normalize"	 : self.normalize,
         "dither"	 : self.dither,
         "recallsession" : self.restore_session_option,
         "MP3usesUTF8"   : self.mp3_utf8,
         "keeppass"      : self.keeppass,
         "ee_appstart"	 : self.appstart_event,
         "ee_appexit"    : self.appexit_event,
         "ee_micon"	 : self.mic_on_event,
         "ee_micoff"	 : self.mic_off_event,
         "ee_auxon"	 : self.aux_on_event,
         "ee_auxoff"	 : self.aux_off_event,
         "best_rs"	 : self.best_quality_resample,
         "good_rs"	 : self.good_quality_resample,
         "fast_rs"	 : self.fast_resample,
         "fastest_rs"	 : self.fastest_resample,
         "micauxmutex"	 : self.mic_aux_mutex,
         "speed_var"	 : self.speed_variance
	 }
	 
      self.valuesdict = {
         "compratio"	 : self.ratio_adj,	# These are all numeric values
	 "compknee"	 : self.knee_adj,
	 "compkneedepth" : self.depth_adj,
	 "compattack"	 : self.attack_adj,
	 "comprelease"	 : self.release_adj,
	 "compgain"	 : self.gain_adj,
	 "ngthreshold"   : self.gate_threshold_adj,
	 "nghysteresis"  : self.gate_hyster_adj,
	 "ngdelay"	 : self.gate_delay_adj,
	 "nggateatten"	 : self.gate_attenuation_adj,
	 "ngontime"	 : self.gate_ontime_adj,
	 "ngofftime"	 : self.gate_offtime_adj,
	 "ducking"	 : self.ducking_adj,
	 "duckinghold"	 : self.ducking_hold_adj,
	 "leftmiclevel"	 : self.left_mic_level_adj,
	 "rightmiclevel" : self.right_mic_level_adj,
	 "leftmicmix"	 : self.left_mic_mix_adj,
	 "rightmicmix"	 : self.right_mic_mix_adj,
	 "headroom"	 : self.headroom_adj,
	 "de-ess"	 : self.de_ess_adj,
	 "interval"	 : self.intervaladj,
         "latency"	 : self.announcedelayadj,
         "interval_vol"	 : self.parent.jingles.interadj,
	 "fullwinx"	 : self.parent.fullwinx,
         "fullwiny"	 : self.parent.fullwiny,
         "minwinx"	 : self.parent.minwinx,
         "minwiny"	 : self.parent.minwiny,
         "jingleswinx"   : self.parent.jingles.jingleswinx,
         "jingleswiny"   : self.parent.jingles.jingleswiny,
         "apondelay"     : self.ap_on_delay_adj,
         "apoffthresh"   : self.ap_off_thresh_adj,
         "passspeed"	 : self.parent.passspeed_adj, 
         "normboost"	 : self.normboost_adj,
         "normceiling"	 : self.normceiling_adj,
         "normrise"	 : self.normrise_adj,
         "normfall"	 : self.normfall_adj
         }
	 
      self.textdict = {
         "announcenick"	 : self.nickentry,	# These are all text
	 "announcechan"	 : self.channelsentry, 
	 "announcemess"	 : self.announcemessageentry,
	 "timernick"	 : self.timernickentry,
	 "timerchan"	 : self.timerchannelsentry,
	 "timermess"	 : self.timermessageentry,
         "ltfilerqdir"   : self.parent.player_left.file_requester_start_dir,
         "rtfilerqdir"   : self.parent.player_right.file_requester_start_dir,
         "et_appstart"	 : self.appstart_event,
         "et_appexit"    : self.appexit_event,
         "et_micon"	 : self.mic_on_event,
         "et_micoff"	 : self.mic_off_event,
         "et_auxon"	 : self.aux_on_event,
         "et_auxoff"	 : self.aux_off_event
         }

      self.rangewidgets = (self.parent.deckadj,)