# -*- encoding: utf-8 -*-

#   langheader.py: GUI internationalisation code of IDJC
#   Copyright (C) 2005 Stephen Fairchild
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

import os

# determine which langauge index to use by examining the LANG environment variable
# defaults to english (li=0)
try:
   li = ["en", "de", "fr"].index(os.environ["LANG"][:2])
except:
   li = 0

#print "language index is", li, "LANG is set to", os.environ["LANG"]

# Main window stuff
playlist_text = ("Playlist", "Abspielliste", "Playlist")[li]
str_peak_text = ("Str Peak", "Str. Spitze", "Str Peak")[li]
str_vu_text = ("Str VU", "Str. VU", "Str VU")[li]
comp_bar_text = ("Comp", "Komp", "Comp")[li]
mic_peak_text = ("Mic Peak", "Mik Spitze", "Mic Peak")[li]
mic_vu_text = ("Mic VU", "Mik VU", "Mic VU")[li]
play_all_text = ("Play All", "Folgend", "Play All")[li]
loop_all_text = ("Loop All", "Endlos", "Loop All")[li]
random_text = ("Random", "Zufällig", "Random")[li]
manual_text = ("Manual", "Manuell", "Manual")[li]
cue_up_text = ("Cue Up", "Aufreihen", "Cue Up")[li]
stream_text = (" Stream ", "Stream", " Stream ")[li]
listen_text = (" Listen ", "Hören", " Listen ")[li]
tracks_played_text = ("Tracks Played", "Gespielte Lieder", "Tracks Played")[li]
track_history_clear_text = ("Remove Contents", "Inhalt entfernen", "Remove Contents ")[li]
stream_monitor_text = ("Stream Mon.", "Stream Mon.", "Stream Mon.")[li]
prefs_button_text = ("Prefs", "Einstellungen", "Prefs")[li]
prefs_window_text = ("IDJC Preferences", "IDJC Einstellungen", "IDJC Preferences")[li]
server_button_text = ("Server", "Server", "Serveur")[li]
server_window_text = ("Radio Server", "Radioserver", "Radio Server")[li]
jingles_button_text = ("Jingles", "Jingles", "Jingles")[li]
jingles_window_text = ("IDJC Jingles", "IDJC Jingles", "IDJC Jingles")[li]

# Jingles window stuff

sequence_text = ("Sequence:", "Sequenz:", "Sequence:")[li]

# Server window stuff
connection_text = ("Connection", "Verbindung", "Connection")[li]
encoding_text = ("Encoding", "Format", "Encoding")[li]
stream_info_text = ("Stream Info", "Stream Info", "Stream Info")[li]
record_text = ("Record", "Aufnahme", "Record")[li]
server_type_text = ("Type:", "Typ:", "Type:")[li]
server_hostname_text = ("Host:", "Host:", "Host:")[li]
server_port_text = ("Port:", "Port:", "Port:")[li]
server_mount_text = ("Mount:", "Mount:", "Mount:")[li]
server_login_text = ("Login:", "Login:", "Login:")[li]
server_password_text = ("Pass:", "Pass:", "Pass:")[li]
dj_name_text = ("DJ Name:", "DJ-Name:", "DJ Name:")[li]
listen_url_text = ("Listen URL:", "Radio-URL:", "Listen URL:")[li]
description_text = ("Description:", "Beschreibung:", "Description:")[li]
genre_text = ("Genre:", "Musikrichtung:", "Genre:")[li]
metadata_text = ("Metadata:", "Metadaten:", "Metadata:")[li]
update_text = ("Update", "Update", "Update")[li]
send_metadata_text = ("Send Metadata", "Sende Metadaten", "Send Metadata")[li]
make_public_text = ("Make Public", "Öffentlich", "Make Public")[li]
server_connect_text = ("Server Connect", "Verbindung herstellen", "Server Connect")[li]
until_text = ("Until (24hr Time):", "Bis (24hr-Angabe):", "Until (24hr Time)")[li]
record_filename_text = ("Filename:", "Dateiname:", "Filename:")[li]
record_artist_text = ("Artist:", "Artist:", "Artist:")[li]
record_title_text = ("Title:", "Titel:", "Title:")[li]

# Prefs window stuff
general_tab_text = ("General", "Grundeinstellungen", "General")[li]
microphone_tab_text = ("Microphone", "Mikrophon", "Microphone")[li]
jack_ports_tab_text = ("Jack Ports", "Jack-Anschlüsse", "Jack Ports")[li]
about_tab_text = ("About", "Über", "About")[li]

# Stuff in the general tab of prefs window
feature_set_text = ("Feature Set", "Erscheinung", "Feature Set")[li]
fully_featured_text = ("Fully Featured", "Ausführlich", "Fully Featured")[li]
basic_streamer_text = ("Basic Streamer", "Kompakt", "Basic Streamer")[li]
start_full_text = ("Start Full", "Starte ausführlich", "Start Full")[li]
start_mini_text = ("Start Mini", "Starte kompakt", "Start Mini")[li]
bits_and_bobs_text = ("Bits and Bobs", "Bits und Bobs", "Bits and Bobs")[li]
stream_normalizer_text = ("Stream Normalizer", "Stream Normalizer", "Stream Normalizer")[li]
normboost_text = ("Boost", "Boost", "Boost")[li]
normceiling_text = ("Threshold", "Threshold", "Threshold")[li]
normrise_text = ("Rise", "Rise", "Rise")[li]
normfall_text = ("Fall", "Fall", "Fall")[li]
normalizer_toggle_text = ("Str. Normalize", "Str. Normalize", "Str. Normalize")[li]
normdefaults_text = ("Defaults", "Standardeinstellungen", "Defaults")[li]
# these correspond to str_peak_text and friends
stream_peak_toggle_text = ("Stream Peak", "Stream Spitze", "Stream Peak")[li]
mic_peak_toggle_text = ("Mic Peak", "Mik Spitze", "Mic Peak")[li]
show_vu_toggle_text = ("Show VU", "Zeige VU", "Show VU")[li]
comp_bar_toggle_text = ("Comp. Bar", "Komp. Anzeige", "Comp. Bar")[li]
fadeout_toggle_text = ("Fadeout", "Fadeout", "Fadeout")[li]
dj_alarm_toggle_text = ("DJ Alarm", "DJ Alarm", "DJ Alarm")[li]
dither_toggle_text = ("Dither", "Dither", "Dither")[li]
keeppass_text = ("Keep Password", "Keep Password", "Keep Password")[li]
initial_player_settings_text = ("Player Settings At Startup", "Einstellungen nach Programmstart", "Player Settings At Startup")[li]
player_1_text = ("Player 1", "Player 1", "Player 1")[li]
player_2_text = ("Player 2", "Player 2", "Player 2")[li]
count_up_text = ("Count Up", "Aufsteigend", "Count Up")[li]
count_down_text = ("Count Down", "Absteigend", "Count Down")[li]
restore_session_text = ("Restore previous session", "Einstellungen merken", "Restore previous session")[li]

# Stuff in the Microphone tab of prefs window
dnr_compressor_text = ("Dynamic Range Compressor", "Dynamic Range Kompressor", "Dynamic Range Compressor")[li]
comp_ratio_text = ("Ratio", "Ratio", "Ratio")[li]
comp_knee_text = ("Knee", "Knee", "Knee")[li]
comp_depth_text = ("Depth", "Depth", "Depth")[li]
comp_attack_text = ("Attack", "Attack", "Attack")[li]
comp_release_text = ("Release", "Release", "Release")[li]
comp_gain_text = ("Gain", "Gain", "Gain")[li]
comp_relative_text = ("Relative", "Relativ", "Relative")[li]
comp_manual_text = ("Manual", "Manuell", "Manual")[li]
comp_ducking_text = ("Ducking", "Ducking", "Ducking")[li]
comp_duckhold_text = ("Hold", "Hold", "Hold")[li]
comp_de_ess_text = ("De-ess", "De-ess", "De-ess")[li]
noise_gate_text = ("Noise Gate", "Noise Gate", "Noise Gate")[li]
threshold_text = ("Thresh.", "Threshold", "Thresh.")[li]
hysteresis_text = ("Hyster.", "Hysteresis", "Hyster.")[li]
ng_delay_text = ("Delay", "Delay", "Delay")[li]
attenuation_text = ("Atten.", "Attenuation", "Atten.")[li]
rise_text = ("Rise", "Rise", "Rise")[li]
fall_text = ("Fall", "Fall", "Fall")[li]
af_h_sm_text = ("Audio Filter, Headroom, and Stereo Mix","Audio Filter, Headroom, und Stereo Mix", "Audio Filter, Headroom, and Stereo Mix")[li]
bass_cut_text = ("Bass cut:", "Bass cut:", "Bass cut:")[li]
off_text = ("Off", "Aus", "Off")[li]
mild_text = ("Mild", "Schwach", "Mild")[li]
sharp_text = ("Sharp", "Stark", "Sharp")[li]
headroom_text = ("Headrooom", "Headroom", "Headroom")[li]
left_text = ("Left:", "Links:", "Left:")[li]
right_text = ("Right:", "Rechts:", "Right:")[li]
invert_text = ("Invert", "Umkehren", "Invert")[li]
level_text = ("Level", "Level", "Level")[li]
l_text = ("L", "L", "L")[li]		# L for Left
r_text = ("R", "R", "R")[li]		# R for Right

# Stuff for the X-Chat tab
track_announcer_text = ("Track Announcer", "Titel-Ansage", "Track Announcer")[li]
irc_message_timer_text = ("IRC Message Timer", "IRC Nachrichten Timer", "IRC Message Timer")[li]
enable_text = ("Enable", "Aktiviert", "Enable")[li]
latency_text = ("Latency:", "Verzögerung:", "Latency:")[li]
nick_text = ("Nick:", "Nick:", "Nick:")[li]
channels_text = ("Channels:", "Channels:", "Channels:")[li]
message_text = ("Message:", "Nachricht:", "Message:")[li]
interval_text = ("Interval:", "Interval:", "Interval:")[li]
song_placemarker_text = ("%s = Song", "%s = Song", "%s = Song")[li]
name_placemarker_text = ("%n = Name", "%n = Name", "%n = Name")[li]
desc_placemarker_text = ("%d = Description", "%d = Beschreibung", "%d = Description")[li]
url_placemarker_text = ("%u = URL", "%u = URL", "%u = URL")[li]
mirc_colour_menu_text = ("mIRC Colour Chart", "mIRC Farbenskala", "mIRC Colour Chart")[li]

# Stuff from the Jack Ports tab
auto_text = ("Auto", "Automatisch", "Auto")[li]
set_text = ("Set", "Einstellen", "Set")[li]
save_text = ("Save", "Speichern", "Save")[li]
jack_help_text = (
"Type <span foreground='red'>jack_lsp</span> in a console for a list of available ports.",
"Führe <span foreground='red'>jack_lsp</span> in einer Konsole aus, um eine Liste der verfügbaren Anschlüsse zu erhalten.",
"Type <span foreground='red'>jack_lsp</span> in a console for a list of available ports.")[li]
licence_text = ("Released under the GNU General Public License V2.0",
		"Veröffentlicht unter der GNU General Public License V2.0",
		"Released under the GNU General Public License V2.0")[li]

tagger_window_title_text = ("IDJC Tagger", "IDJC Tagger", "IDJC Tagger")[li]
tagger_filename_text = ("Filename:", "Dateiname:", "Filename:")[li]
id3_tag_text = ("ID3 Tag", "ID3 Tag", "ID3 Tag")[li]
vorbis_tag_text = ("Vorbis Tag", "Vorbis Tag", "Vorbis Tag")[li]
standard_tags_text = ("Standard Tags", "Standard Tags", "Standard Tags")[li]
tag_title_text = ("Title:", "Titel:", "Title:")[li]
tag_artist_text = ("Artist:", "Artist:", "Artist:")[li]
tag_album_text = ("Album:", "Album:", "Album:")[li]
tag_track_text = ("Track:", "Nummer:", "Track:")[li]
tag_year_text = ("Year:", "Jahr:", "Year:")[li]
tag_genre_text = ("Genre:", "Musikrichtung:", "Genre:")[li]
tag_comment_text = ("Comment:", "Kommentar:", "Comment:")[li]


# Popup menu stuff

item_menu_text = ("Item", "Objekt", "Item")[li]
playlist_menu_text = ("Playlist", "Abspielliste", "Playlist")[li]

meta_tag_text = ("Meta Tag", "Meta Tag", "Meta Tag")[li]
duplicate_text = ("Duplicate", "Klonen", "Duplicate")[li]
remove_text = ("Remove", "Löschen", "Remove")[li]
add_to_jingles_text = ("Add To Jingles", "Zu den Jingles hinzufügen", "Add To Jingles")[li]
this_text = ("This", "Nur dieses", "This")[li]
all_text = ("All", "Alle", "All")[li]
from_here_text = ("From Here", "Von hier alle", "From Here")[li]
to_here_text = ("To Here", "Bis hier alle", "To Here")[li]
add_file_text = ("Add File", "Datei hinzufügen", "Add File")[li]
save_text = ("Save", "Speichern", "Save")[li]
copy_text = ("Copy", "Kopieren", "Copy")[li]
transfer_text = ("Transfer", "Übertragen", "Transfer")[li]
exchange_text = ("Exchange", "Austauschen", "Exchange")[li]
empty_text = ("Empty", "Leeren", "Empty")[li]
append_text = ("Append", "Unten anhängen", "Append")[li]
prepend_text = ("Prepend", "Oben anhängen", "Prepend")[li]
append_cursor_text = ("Append Cursor", "Unter markiertem einfügen", "Append Cursor")[li]
prepend_cursor_text = ("Prepend Cursor", "Über markiertem einfügen", "Prepend Cursor")[li]

# Text for the quit while still streaming dialog

idjc_shutdown_text = ("IDJC Shutdown", "IDJC Beenden", "IDJC Shutdown")[li]

is_streaming_text = ("IDJC is currently streaming.", "IDJC streamt gerade.", "IDJC is currently streaming.")[li]
is_recording_text = ("IDJC is currently recording.", "IDJC nimmt gerade auf.", "IDJC is currently recording.")[li]
question_quit_text = ("Do you really want to quit?", "Wirklich beenden?", "Do you really want to quit?")[li]

# Text for various dialogs relating to the server connection

disconnected_text = ("IDJC Disconnected", "IDJC nicht verbunden", "IDJC Disconnected")[li]

unexpected_text = (("The connection to the radio server failed."), ("Die Verbindung zum Server ist fehlgeschlagen."), ("The connection to the radio server failed."))[li]

timed_out_text = (("Automatically disconnected from the server,", "after the connection timed out."), ("Automatisch vom Server getrennt,", "weil dieser nicht antwortete (timeout)."), ("Automatically disconnected from the server,", "after the connection timed out."))[li]

autoshutdown_text = (("Automatically disconnected from the server.", "Disconnection caused by the shutdown timer."), ("Automatisch vom Server getrennt.", "Grund: shutdown timer."), ("Automatically disconnected from the server.", "Disconnection caused by the shutdown timer."))[li]

disconnection_text = ("IDJC Disconnection", "IDJC trennt die Verbindung", "IDJC Disonnection")[li]

discon_warn_text = (("You will be automatically disconnected from", "the server one minute from now."), ("Sie werden in einer Minute", "automatisch vom Server getrennt."), ("You will be automatically disconnected from", "the server one minute from now."))[li]

autopause_text = ("Record Autosuspend", "Automatische Aufnahmepause", "Record Autosuspend")[li]
ap_on_delay_text = ("Delay", "Verzögerung", "Delay")[li]
ap_off_thresh_text = ("Thresh.", "Threshold", "Threshold")[li]
ap_startup_pref_text = ("On at startup", "Starte aktiv" , "On at startup")[li]	# "AN beim Programmstart" -- a little too long.

# Window titles for file requester dialogs

left_playlist_addition_text = ("Add music to left playlist", "Musik zur linken Abspielliste hinzufügen", "Add music to left playlist")[li]
right_playlist_addition_text = ("Add music to right playlist", "Musik zur linken Abspielliste hinzufügen", "Add music to right playlist")[li]
left_playlist_save_text = ("Save left playlist", "Linke Abspielliste speichern", "Save left playlist")[li]
right_playlist_save_text = ("Save right playlist", "Rechte Abspielliste speichern", "Save right playlist")[li]

# Playlist control elements

stop_control_element_text = ("Player stop", "Player anhalten", "Player stop")[li]

transfer_control_ltr_element_text = (">>> Transfer across >>>", ">>> Zum rechten Player springen >>>", ">>> Transfer across >>>")[li]

crossfade_control_ltr_element_text = (">>> Fade across >>>", ">>> Zum rechten Player faden >>>", ">>> Fade across >>>")[li]

transfer_control_rtl_element_text = ("<<< Transfer across <<<", "<<< Zum linken Player springen <<<", "<<< Transfer across <<<")[li]

crossfade_control_rtl_element_text = ("<<< Fade across <<<", "<<< Zum linken Player überblenden <<<", "<<< Fade across <<<")[li]

stream_disconnect_element_text = ("Stop streaming", "Streaming anhalten", "Stop streaming")[li]

stop_recording_element_text = ("Stop recording", "Aufnahme anhalten", "Stop recording")[li]

# The menu items for the playlist control elements

stop_control_menu_text = ("Player stop", "Player anhalten", "Player stop")[li]

transfer_control_menu_text = ("Transfer", "Sprung zum anderem Player", "Transfer")[li]

crossfade_control_menu_text = ("Crossfade", "Fade zum anderem Player", "Crossfade")[li]

stream_disconnect_menu_text = ("Stop streaming", "Streaming anhalten", "Stop Streaming")[li]

stop_recording_menu_text = ("Stop recording", "Aufnahme anhalten", "Stop recording")[li]

control_menu_text = ("Insert control", "Steuerelement einfügen", "Insert control")[li]

# Stream encoding method

format_text = ("Format", "Format", "Format")[li]

bitrate_text = ("Bitrate", "Bitrate", "Bitrate")[li]

stereo_text = ("Stereo", "Stereo", "Stereo")[li]

# Fixes for folks that like SuSE for some strange reason.

big_box_toggle_text = ("Counter fix", "Counter fix", "Counter fix")[li]

# A new dialog for when the server module crashes and is relauched whilst streaming

reconnected_text = ("IDJC Reconnected", "IDJC hat sich neu verbunden", "IDJC Reconnected")[li]
reconnected_additional_text = (("Automatically reconnected to the server", "after the server module crashed"), ("Automatisch Wiederverbunden zum Server", "nachdem das Servermodul abgestürzt ist"), ("Automatically reconnected to the server", "after the server module crashed"))[li]

# Used in the history.log file

connected_to_history_text = ("connected to", "verbunden mit", "connected to")[li]
disconnected_history_text = ("disconnected from server", "vom Server getrennt", "disconnected from server")[li]
start_recording_history_text = ("started recording to file", "Aufnahme in Datei begonnen", "started recording to file")[li]
stop_recording_history_text = ("stopped recording", "Aufnahme beendet", "stopped recording")[li]

# For the playlist stats

remaining_text = ("Remaining", "Verbleibend", "Remaining")[li]
finish_text = ("Finish", "Ende", "Finish")[li]
block_size_text = ("Block size", "Blockgröße", "Block size")[li]


del li
