#   IDJCmixprefs.py: Preferences window code for IDJC
#   Copyright (C) 2005-2007 Stephen Fairchild (s-fairchild@users.sourceforge.net)
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program in the file entitled COPYING.
#   If not, see <http://www.gnu.org/licenses/>.

__all__ = ['mixprefs']

import pygtk
pygtk.require('2.0')
import gtk, os, licence_window
from idjc_config import *
#from langheader import *
from ln_text import ln

mIRC_colours = (		# Actually these are the X-Chat2 colours.
   (0xCCCCCCFF, "00"),		# X-Chat2 calls them mIRC colours, but I doubt they match.
   (0x000000FF, "01"),
   (0x3636B2FF, "02"),
   (0x2A8C2AFF, "03"),
   (0xC33B3BFF, "04"),
   (0xC73232FF, "05"),
   (0x80267FFF, "06"),
   (0x66361FFF, "07"),
   (0xD9A641FF, "08"),
   (0x3DCC3DFF, "09"),
   (0x1A5555FF, "10"),
   (0x2F8C74FF, "11"),
   (0x4545E6FF, "12"),
   (0xB037B0FF, "13"),
   (0x4C4C4CFF, "14"),
   (0x959595FF, "15"),
   (0x00000000, "99"))		# used to restore default colours

def cb_colour_box_expose(widget, event, data=None):
   widget.set_state(gtk.STATE_NORMAL)	# Prevent pre-light from messing up the colour

def make_colour_box(rgba, label_text, width, height):
   pixbuf = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, True, 8, width, height)
   pixbuf.fill(rgba)
   image = gtk.Image()
   image.connect_after("expose-event", cb_colour_box_expose)
   image.set_from_pixbuf(pixbuf)
   image.show()
   label = gtk.Label(label_text)
   label.show()
   hbox = gtk.HBox()
   hbox.set_spacing(15)
   hbox.pack_start(label, False, False, 0)
   hbox.pack_end(image, False, False, 0)
   hbox.show()
   return hbox

def make_colour_box_menu(entry, callback):
   menu = gtk.Menu()
   for each in mIRC_colours:
      menuitem = gtk.MenuItem()
      menuitem.connect("activate", callback, entry, each[1])
      colourbox = make_colour_box(each[0], each[1], 45, 28)
      menuitem.add(colourbox)
      menu.add(menuitem)
      menuitem.show()
   menu.show()
   return menu

def make_entry_line(parent, item, code):
   box = gtk.HBox(False, 0)
   box.set_border_width(4)
   box.set_spacing(5)

   entry = gtk.Entry(30)
   entry.set_size_request(185, -1)
         
   savebutton = gtk.Button(ln.save)
   savebutton.connect("clicked", parent.save_click, (code, entry))
   box.pack_end(savebutton, False, False, 0)
   savebutton.show()
      
   setbutton = gtk.Button(ln.set)
   setbutton.connect("clicked", parent.update_click, (code, entry))
   box.pack_end(setbutton, False, False, 0)
   setbutton.show()
            
   if item[:3] != "Aux":
      entry.set_sensitive(False)
   box.pack_end(entry, False, False, 0)
   entry.show()
      
   checkbox = gtk.CheckButton(ln.auto)
   box.pack_end(checkbox, False, False, 0)
   if item[:3] != "Aux":
      checkbox.set_active(True)
      checkbox.connect("toggled", parent.auto_click, entry)
      checkbox.show()
      
   label = gtk.Label(item)
   box.pack_start(label, False, False, 0)
   label.show()
      
   box.show()
   
   parent.parent.tooltips.set_tip(checkbox, ln.auto_tip)
   parent.parent.tooltips.set_tip(setbutton, ln.set_tip)
   parent.parent.tooltips.set_tip(savebutton, ln.save_tip)
   parent.parent.tooltips.set_tip(entry, ln.jack_entry)
   
   return box, checkbox, entry, setbutton

class mixprefs:
   class event_command_container(gtk.Frame):
      def add(self, widget):
         self.vbox.add(widget)
      def __init__(self):
         gtk.Frame.__init__(self)
         gtk.Frame.set_border_width(self, 4)
         gtk.Frame.set_shadow_type(self, gtk.SHADOW_ETCHED_OUT)
         self.vbox = gtk.VBox()
         self.vbox.set_spacing(2)
         gtk.Frame.add(self, self.vbox)
         self.vbox.set_border_width(4)
         self.vbox.show()
   
   class event_command(gtk.HBox):
      def activate(self):
         if self.checkbutton.get_active():
            os.system(self.entry.get_text())
      def get_text(self):
         return self.entry.get_text()
      def get_active(self):
         return self.checkbutton.get_active()
      def set_text(self, text):
         return self.entry.set_text(text)
      def set_active(self, bool):
         return self.checkbutton.set_active(bool)
      def cb_checkbutton(self, widget, data = None):
         self.entry.set_sensitive(widget.get_active())
      def __init__(self, imagefile, width, height, text, default_state, crossout, tips = None, checkbutton_tip = None, entry_tip = None):
         gtk.HBox.__init__(self)
         gtk.HBox.set_spacing(self, 6)
         self.checkbutton = gtk.CheckButton()
         self.checkbutton.set_active(default_state)
         image = gtk.Image()
         if crossout:
            pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(pkgdatadir + "crossout" + gfext, width , height)
         else:
            pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(pkgdatadir + imagefile + gfext, width, height)
         image.set_from_pixbuf(pixbuf)
         self.checkbutton.add(image)
         image.show()
   	 gtk.HBox.pack_start(self, self.checkbutton, False, False, 0)
         self.checkbutton.connect("toggled", self.cb_checkbutton)
         self.checkbutton.show()
         self.entry = gtk.Entry()
         self.entry.set_text(text)
         gtk.HBox.pack_start(self, self.entry, True, True, 0)
         self.entry.set_sensitive(default_state)
         self.entry.show()
         if tips is not None:
            if checkbutton_tip is not None:
               tips.set_tip(self.checkbutton, checkbutton_tip)
            if entry_tip is not None:
               tips.set_tip(self.entry, entry_tip)
   
   def send_new_compressor_stats(self):
      f = float(self.parent.samplerate) / 1000.0
      string_to_send = ":%.1f:%d:%d:%d:%d:%d:%d:%.1f:%d:%.1f:%d:" % (
      					self.ratio_adj.get_value(),
					self.knee_adj.get_value(),
					self.depth_adj.get_value(),
					self.attack_adj.get_value() * f,
					self.release_adj.get_value() * f,
					self.gain_adj.get_value(),
					self.gain_relative.get_active(),
					self.ducking_adj.get_value(),
					self.ducking_hold_adj.get_value() * f,
					self.de_ess_adj.get_value(),
                                        self.filter_slow.get_active())
      self.parent.mixer_write("COMP=%s\nACTN=compstats\nend\n" % string_to_send, True)
      
   def cb_compressor(self, widget, data):
      self.send_new_compressor_stats()
      
   def send_new_noisegate_stats(self):
      f = float(self.parent.samplerate) / 1000.0
      string_to_send = ":%d:%d:%d:%d:%d:%d:" % (
      					self.gate_threshold_adj.get_value(),
					self.gate_hyster_adj.get_value(),
					self.gate_delay_adj.get_value() * f,
					self.gate_attenuation_adj.get_value(),
					self.gate_ontime_adj.get_value() * f,
					self.gate_offtime_adj.get_value() * f)
      self.parent.mixer_write("GATE=%s\nACTN=gatestats\nend\n" % string_to_send, True)
      
   def send_new_microphone_stats(self):
      string_to_send = ":%d:%d:%d:%d:%d:%d:%d:%.1f:%d:" % (
      					self.mic_filter,
					self.left_invert.get_active(),
					self.right_invert.get_active(),
					self.left_mic_level.get_value(),
					self.right_mic_level.get_value(),
					self.left_mic_mix_slider.get_value(),
					self.right_mic_mix_slider.get_value(),
					self.headroom.get_value(),
					self.mic_to_dj.get_active())
      self.parent.mixer_write("MICS=%s\nACTN=micmixstats\nend\n" % string_to_send, True)
      
   def send_new_normalizer_stats(self):
      r = float(self.parent.samplerate)
      string_to_send = ":%0.1f:%0.1f:%d:%d:%d:" % (
      					self.normboost_adj.get_value(),
                                        self.normceiling_adj.get_value(),
                                        self.normrise_adj.get_value() * r,
                                        self.normfall_adj.get_value() * r, 
                                        self.normalize.get_active())
      self.parent.mixer_write("NORM=%s\nACTN=normalizerstats\nend\n" % string_to_send, True)
      
   def send_new_resampler_stats(self):
      self.parent.mixer_write("RSQT=%d\nACTN=resamplequality\nend\n" % self.resample_quality, True)
      
   def normalizer_defaults(self, value = None):
      self.normboost_adj.set_value(12.0)
      self.normboost_adj.value_changed()
      self.normceiling_adj.set_value(-12.0)
      self.normceiling_adj.value_changed()
      self.normrise_adj.set_value(2.7)
      self.normrise_adj.value_changed()
      self.normfall_adj.set_value(2.0)
      self.normfall_adj.value_changed()

   def cb_normalizer(self, widget, data = None):
      self.normalizer_hbox.set_sensitive(self.normalize.get_active())
      self.send_new_normalizer_stats()
      
   def cb_resample_quality(self, widget, data):
      if widget.get_active():
         self.resample_quality = data
         self.send_new_resampler_stats()
      
   def cb_dither(self, widget, data = None):
      if widget.get_active():
         string_to_send = "ACTN=dither\nend\n"
      else:
         string_to_send = "ACTN=dontdither\nend\n"
      self.parent.mixer_write(string_to_send, True)

   def cb_noisegate(self, widget, data):
      self.send_new_noisegate_stats()
      
   def cb_dj_aud(self, widget):
      self.parent.send_new_mixer_stats()
      
   def cb_restore_session(self, widget, data=None):
      state = not widget.get_active()
      self.left_player_frame.set_sensitive(state)
      self.right_player_frame.set_sensitive(state)
      self.misc_session_frame.set_sensitive(state)
   
   def load_jack_port_settings(self):
      if os.path.isfile(self.parent.idjc + "micl"):
         file = open(self.parent.idjc + "micl", "r")
	 self.miclentry.set_text(file.readline()[:-1])
	 self.miclcheck.set_active(file.readline() == "1\n")
	 file.close()

      if os.path.isfile(self.parent.idjc + "micr"):
         file = open(self.parent.idjc + "micr", "r")
	 self.micrentry.set_text(file.readline()[:-1])
	 self.micrcheck.set_active(file.readline() == "1\n")
	 file.close()

      if os.path.isfile(self.parent.idjc + "audl"):
         file = open(self.parent.idjc + "audl", "r")
	 self.audlentry.set_text(file.readline()[:-1])
	 self.audlcheck.set_active(file.readline() == "1\n")
	 file.close()
      
      if os.path.isfile(self.parent.idjc + "audr"):
         file = open(self.parent.idjc + "audr", "r")
	 self.audrentry.set_text(file.readline()[:-1])
	 self.audrcheck.set_active(file.readline() == "1\n")
	 file.close()
	 
      if os.path.isfile(self.parent.idjc + "strl"):
         file = open(self.parent.idjc + "strl", "r")
	 self.strlentry.set_text(file.readline()[:-1])
	 self.strlcheck.set_active(file.readline() == "1\n")
	 file.close()
      
      if os.path.isfile(self.parent.idjc + "strr"):
         file = open(self.parent.idjc + "strr", "r")
	 self.strrentry.set_text(file.readline()[:-1])
	 self.strrcheck.set_active(file.readline() == "1\n")
	 file.close()
      
      if os.path.isfile(self.parent.idjc + "auxl"):
         file = open(self.parent.idjc + "auxl", "r")
	 self.auxlentry.set_text(file.readline()[:-1])
	 self.auxlcheck.set_active(file.readline() == "1\n")
	 file.close()
	       
      if os.path.isfile(self.parent.idjc + "auxr"):
         file = open(self.parent.idjc + "auxr", "r")
	 self.auxrentry.set_text(file.readline()[:-1])
	 self.auxrcheck.set_active(file.readline() == "1\n")
	 file.close()
   
   def auto_click(self, widget, data):
      data.set_sensitive(not widget.get_active())
   
   def save_click(self, widget, data):
      filename = self.parent.idjc + data[0].lower()
      file = open(filename, "w")
      if data[1].flags() & gtk.SENSITIVE:
         file.write(data[1].get_text() + "\n" + "0\n")
      else:
         file.write(data[1].get_text() + "\n" + "1\n")
      file.close()
   
   def update_click(self, widget, (code, entry)):
      if entry.flags() & gtk.SENSITIVE:
         entrytext = entry.get_text()
      else:
         entrytext = "default"
      buffer = "ACTN=remake%s\n%s=%s\nend\n" % (code.lower(), code, entrytext)
      self.parent.mixer_write(buffer, True)
      
   def delete_event(self, widget, event, data=None):
      self.window.hide()
      return True

   def save_player_prefs(self):
      try:
         file = open(self.parent.idjc + "playerdefaults", "w")
	 for name, widget in self.playersettingsdict.iteritems():
	    file.write(name + ("=False\n","=True\n")[widget.get_active()])
         for name, widget in self.valuesdict.iteritems():
	    file.write(name + "=" + str(widget.get_value()) + "\n")
	 for name, widget in self.textdict.iteritems():
	    file.write(name + "=" + widget.get_text() + "\n")
	 file.close()
      except IOError:
         print "Error while writing out player defaults"
      if self.ask_profile.get_active():
         if os.path.isfile(self.parent.idjcroot + "do-not-ask-profile"):
            try:
               os.unlink(self.parent.idjcroot + "do-not-ask-profile")
            except:
               print "error removing file 'do-not-ask-profile'"
      else:
         try:
            if not os.path.isfile(self.parent.idjcroot + "do-not-ask-profile"):
               os.mknod(self.parent.idjcroot + "do-not-ask-profile")
         except:
            print "error creating file 'do-not-ask-profile'"
	 
   def load_player_prefs(self):
      try:
         file = open(self.parent.idjc + "playerdefaults", "r")
	 
	 while 1:
	    line = file.readline()
	    if line == "":
	       break
	    if line.count("=") != 1:
	       continue
	    line = line.split("=")
	    key = line[0].strip()
	    value = line[1][:-1].strip()
	    if value == "True":
	       value = True
	    elif value == "False":
	       value = False
	    if self.playersettingsdict.has_key(key):
	       self.playersettingsdict[key].set_active(value)
	    elif self.valuesdict.has_key(key):
	       self.valuesdict[key].set_value(float(value))
	    elif self.textdict.has_key(key):
	       self.textdict[key].set_text(value)
	 file.close()
      except IOError:
         print "Failed to read playerdefaults file"
      self.send_new_compressor_stats()
      self.send_new_noisegate_stats()
      self.send_new_microphone_stats()
      self.parent.send_new_mixer_stats()
	 
   def apply_player_prefs(self):
      left = self.parent.player_left
      right = self.parent.player_right
      
      if self.lplayall.get_active():
         left.pl_mode.set_active(0)
      if self.lloopall.get_active():
         left.pl_mode.set_active(1)
      if self.lrandom.get_active():
         left.pl_mode.set_active(2)
      if self.lmanual.get_active():
         left.pl_mode.set_active(3)
      if self.lcueup.get_active():
         left.pl_mode.set_active(4)
         	 
      if self.rplayall.get_active():
         right.pl_mode.set_active(0)
      if self.rloopall.get_active():
         right.pl_mode.set_active(1)
      if self.rrandom.get_active():
         right.pl_mode.set_active(2)
      if self.rmanual.get_active():
         right.pl_mode.set_active(3)
      if self.rcueup.get_active():
         right.pl_mode.set_active(4)

      left.stream.set_active(self.lstream.get_active())
      right.stream.set_active(self.rstream.get_active())
      
      left.listen.set_active(self.llisten.get_active())
      right.listen.set_active(self.rlisten.get_active())
      
      if self.lcountdown.get_active():
         left.digiprogress_click()
      if self.rcountdown.get_active():
         right.digiprogress_click()
	 
      if self.startmini.get_active():
         self.mini.clicked()
	 
      self.mic_peak_toggle.toggled()
      self.stream_peak_toggle.toggled()
      self.vu_toggle.toggled()
      self.limiter_toggle.toggled()
      
      if self.tracks_played.get_active():
         self.parent.history_expander.set_expanded(True)
         self.parent.history_vbox.show()
      if self.stream_mon.get_active():
         self.parent.listen.set_active(True)
      
   def callback(self, widget, data):
      parent = self.parent
      if data == "basic streamer":
         if parent.menu_feature_set.get_active():
            parent.menu_feature_set.set_active(False)
      if data == "fully featured":
         if parent.menu_feature_set.get_active() == False:
            parent.menu_feature_set.set_active(True)
      if data == "enhanced-crossfader":
         if widget.get_active():
	    parent.listen.show()
	    parent.passleft.show()
	    parent.passright.show()
	    parent.passspeed.show()
	    parent.passbutton.show()
	 else:
	    parent.listen.hide()
	    parent.passleft.hide()
	    parent.passright.hide()
	    parent.passspeed.hide()
	    parent.passbutton.hide()
	    parent.listen.set_active(False)
      if data == "bigger box":
         if widget.get_active():
            self.parent.player_left.digiprogress.set_width_chars(7)
            self.parent.player_right.digiprogress.set_width_chars(7)
         else:
            self.parent.player_left.digiprogress.set_width_chars(6)
            self.parent.player_right.digiprogress.set_width_chars(6)
      if data == "tooltips":
         if widget.get_active():
            parent.tooltips.enable()
         else:
            parent.tooltips.disable()
	    
   def cb_mic(self, widget, data):
      if data == "filter_off":
         self.mic_filter = 0
      if data == "filter_mild":
         self.mic_filter = 1
      if data == "filter_sharp" and widget.get_active():
         self.mic_filter = 2
      self.send_new_microphone_stats() 
      
   def cb_autopause(self, widget, data):
      pass
	 
   def meter_callback(self, widget, data):
      if data[0] == "meter":
         if widget.get_active():
            data[1].show()
	 else:
	    data[1].hide()
      if self.mic_peak_toggle.get_active() or self.stream_peak_toggle.get_active() or self.vu_toggle.get_active() or self.limiter_toggle.get_active():
         if self.parent.simplemixer == False:
            self.parent.meterbox.show()
      else:
         self.parent.meterbox.hide()
    
   def cb_mic_boost(self, widget):
      self.parent.send_new_mixer_stats()
	 	    
   def cb_colourbox(self, menuitem, entry, colour):
      cursor = entry.get_position()
      if cursor < 3 or entry.get_text()[cursor - 3] !="\x03":
         entry.insert_text("\x03" + colour, cursor)	# Foreground colour
      else:
         entry.insert_text("," + colour, cursor)	# Background
      entry.set_position(cursor + 3)

   def cb_pbspeed(self, widget):
      if widget.get_active():
         self.parent.player_left.pbspeedbar.set_value(0)
         self.parent.player_right.pbspeedbar.set_value(0)
         self.parent.player_left.pbspeedbox.show()
         self.parent.player_right.pbspeedbox.show()
      else:
         self.parent.player_left.pbspeedbox.hide()
         self.parent.player_right.pbspeedbox.hide()
      self.parent.send_new_mixer_stats()

   def colourmenupopulate(self, entry, menu):
      menusep = gtk.SeparatorMenuItem()
      menu.append(menusep)
      menusep.show()
      menuitem = gtk.MenuItem(ln.mirc_colour_menu)
      menu.append(menuitem)
      submenu = make_colour_box_menu(entry, self.cb_colourbox)
      menuitem.set_submenu(submenu)
      menuitem.show()
      
   def cb_handle_colour_char(self, entry, event, data=None):
      if event.state & gtk.gdk.LOCK_MASK:
         target = 75
      else:
         target = 107
      if event.state & (~gtk.gdk.LOCK_MASK) == gtk.gdk.CONTROL_MASK and event.keyval == target:
         cursor = entry.get_position()
         entry.insert_text("\x03", cursor)
         entry.set_position(cursor + 1)
   
   def bind_jack_ports(self):
      self.miclupdate.clicked()
      self.micrupdate.clicked()
      self.audlupdate.clicked()
      self.audrupdate.clicked()
      self.strlupdate.clicked()
      self.strrupdate.clicked()
      self.auxlupdate.clicked()
      self.auxrupdate.clicked()
   
   def __init__(self, parent):
      self.parent = parent
      self.parent.prefs_window = self
      self.window = gtk.Window(gtk.WINDOW_TOPLEVEL)
      self.parent.window_group.add_window(self.window)
      self.window.set_title(ln.prefs_window)
      self.window.set_border_width(10)
      self.window.set_resizable(False)
      self.window.connect("delete_event",self.delete_event)
      self.window.set_destroy_with_parent(True)
      self.window.set_icon_from_file(pkgdatadir + "icon" + gfext)
      self.notebook = gtk.Notebook()
      self.window.add(self.notebook)

      # General tab
      
      generalwindow = gtk.ScrolledWindow()
      generalwindow.set_border_width(8)
      generalwindow.set_policy(gtk.POLICY_NEVER, gtk.POLICY_ALWAYS)
      outervbox = gtk.VBox()
      generalwindow.add_with_viewport(outervbox)
      generalwindow.show()
      outervbox.set_border_width(3)
      
      featuresframe = gtk.Frame(" " + ln.feature_set + " ")
      featuresframe.set_border_width(3)
      hbox = gtk.HBox()
      hbox.set_border_width(2)
      featuresframe.add(hbox)
      outervbox.pack_start(featuresframe, False, False, 0)
      featuresframe.show()
      vbox = gtk.VBox()
      self.startfull = gtk.RadioButton(None, ln.start_full)
      self.startfull.set_border_width(2)
      vbox.pack_start(self.startfull, False, False, 0)
      self.startfull.show()
      parent.tooltips.set_tip(self.startfull, ln.start_mini_full)
      
      self.startmini = gtk.RadioButton(self.startfull, ln.start_mini)
      self.startmini.set_border_width(2)
      vbox.pack_start(self.startmini, False, False, 0)
      self.startmini.show()
      parent.tooltips.set_tip(self.startmini, ln.start_mini_full)
      
      vbox.show()
      hbox2 = gtk.HBox()
      hbox2.set_border_width(10)
      hbox2.set_spacing(20)
      hbox.pack_start(hbox2, True, False, 0)
      
      self.maxi = gtk.Button(" " + ln.fully_featured + " ")
      self.maxi.connect("clicked", self.callback, "fully featured")
      hbox2.pack_start(self.maxi, False, False, 0)
      self.maxi.show()
      parent.tooltips.set_tip(self.maxi, ln.fully_featured_tip)
      
      self.mini = gtk.Button(" " + ln.basic_streamer + " ")
      self.mini.connect("clicked", self.callback, "basic streamer")
      hbox2.pack_start(self.mini, False, False, 0)
      self.mini.show()
      parent.tooltips.set_tip(self.mini, ln.basic_streamer_tip)
      
      hbox2.show()   
      hbox.pack_start(vbox, False, False, 9)     
      hbox.show()
      
      # Meters on/off
      
      frame = gtk.Frame(" " + ln.audio_meters + " ")
      frame.set_border_width(3)
      vbox = gtk.VBox()
      vbox.set_border_width(10)
      vbox.set_spacing(1)
      frame.add(vbox)
      frame.show()
      line1hbox = gtk.HBox()
      vbox.add(line1hbox)
      line2hbox = gtk.HBox()
      vbox.add(line2hbox)
      vbox.show()
      
      stream_peak_hbox = gtk.HBox()
      line1hbox.add(stream_peak_hbox)
      stream_peak_hbox.show()
      self.stream_peak_toggle = gtk.CheckButton()
      stream_peak_hbox.pack_start(self.stream_peak_toggle, False, False, 0)
      self.stream_peak_toggle.connect("toggled", self.meter_callback, ("meter", self.parent.stream_peak_box))
      self.stream_peak_toggle.show()
      self.parent.str_pk_action.connect_proxy(self.stream_peak_toggle)
      parent.tooltips.set_tip(self.stream_peak_toggle, ln.stream_peak_toggle_tip)
      
      mic_peak_hbox = gtk.HBox()
      line1hbox.add(mic_peak_hbox)
      mic_peak_hbox.show()
      self.mic_peak_toggle = gtk.CheckButton()
      mic_peak_hbox.pack_start(self.mic_peak_toggle, False, False, 0)
      self.mic_peak_toggle.connect("toggled", self.meter_callback, ("meter", self.parent.mic_peak_box))
      self.mic_peak_toggle.show()
      self.parent.mic_pk_action.connect_proxy(self.mic_peak_toggle)
      parent.tooltips.set_tip(self.mic_peak_toggle, ln.mic_peak_toggle_tip)
      
      vu_hbox = gtk.HBox()
      line1hbox.add(vu_hbox)
      vu_hbox.show()
      self.vu_toggle = gtk.CheckButton()
      vu_hbox.pack_start(self.vu_toggle, False, False, 0)
      self.vu_toggle.connect("toggled", self.meter_callback, ("meter", self.parent.vubox))
      self.vu_toggle.show()
      self.parent.show_vu_action.connect_proxy(self.vu_toggle)
      line1hbox.show()
      parent.tooltips.set_tip(self.vu_toggle, ln.str_mic_vu_toggle_tip)
      
      comp_hbox = gtk.HBox()
      line2hbox.add(comp_hbox)
      comp_hbox.show()
      self.limiter_toggle = gtk.CheckButton()
      comp_hbox.pack_start(self.limiter_toggle, False, False, 0)
      self.limiter_toggle.connect("toggled", self.meter_callback, ("meter", self.parent.limiter_box))
      self.limiter_toggle.show()
      self.parent.show_comp_action.connect_proxy(self.limiter_toggle)
      line2hbox.show()
      parent.tooltips.set_tip(self.limiter_toggle, ln.mic_compression_level_tip)
      
      outervbox.pack_start(frame, False, False, 0)
      frame.show()
      
      # Miscellaneous Features
      
      frame = gtk.Frame(" " + ln.misc_features + " ")
      frame.set_border_width(3)
      vbox = gtk.VBox()
      frame.add(vbox)
      frame.show()
      vbox.set_border_width(10)
      vbox.set_spacing(1)
      
      self.speed_variance = gtk.CheckButton(ln.speed_variance)
      vbox.pack_start(self.speed_variance, False, False, 0)
      self.speed_variance.connect("toggled", self.cb_pbspeed)
      self.speed_variance.show()
      parent.tooltips.set_tip(self.speed_variance, ln.player_speed_tip)
      
      self.ask_profile = gtk.CheckButton(ln.ask_profile)
      vbox.pack_start(self.ask_profile, False, False, 0)
      self.ask_profile.show()
      parent.tooltips.set_tip(self.ask_profile, ln.ask_profile_tip)
      
      self.bigger_box_toggle = gtk.CheckButton(ln.big_box_toggle)
      vbox.pack_start(self.bigger_box_toggle, False, False, 0)
      self.bigger_box_toggle.connect("toggled", self.callback, "bigger box")
      self.bigger_box_toggle.show()
      parent.tooltips.set_tip(self.bigger_box_toggle, ln.enlarge_time_elapsed_tip)
      
      self.djalarm = gtk.CheckButton(ln.dj_alarm_toggle)
      vbox.pack_start(self.djalarm, False, False, 0)
      self.djalarm.show()
      parent.tooltips.set_tip(self.djalarm, ln.dj_alarm_tip)
      
      """
      self.extm3u = gtk.CheckButton(ln.extm3u)
      vbox.pack_start(self.extm3u, False, False, 0)
      self.extm3u.show()
      parent.tooltips.set_tip(self.extm3u, ln.extm3u_tip)
      """
      
      self.dither = gtk.CheckButton(ln.dither_toggle)
      vbox.pack_start(self.dither, False, False, 0)
      self.dither.connect("toggled", self.cb_dither)
      self.dither.show()
      parent.tooltips.set_tip(self.dither, ln.dither_tip)

      self.keeppass = gtk.CheckButton(ln.keeppass)
      vbox.pack_start(self.keeppass, False, False, 0)
      self.keeppass.show()
      parent.tooltips.set_tip(self.keeppass, ln.keep_password_tip)

      self.mp3_utf8 = gtk.CheckButton(ln.mp3_utf8)
      self.mp3_utf8.set_active(True)
      vbox.pack_start(self.mp3_utf8, False, False, 0)
      self.mp3_utf8.show()
      parent.tooltips.set_tip(self.mp3_utf8, ln.mp3_utf8_tip)
      
      self.mic_aux_mutex = gtk.CheckButton(ln.mic_aux_mutex)
      vbox.pack_start(self.mic_aux_mutex, False, False, 0)
      self.mic_aux_mutex.show()
      parent.tooltips.set_tip(self.mic_aux_mutex, ln.mic_aux_mutex_tip)
      
      self.enable_tooltips = gtk.CheckButton(ln.enable_tooltips)
      self.enable_tooltips.connect("toggled", self.callback, "tooltips")
      if parent.tooltips.dummy:
         self.enable_tooltips.set_sensitive(False)
      vbox.pack_start(self.enable_tooltips, False, False, 0)
      self.enable_tooltips.show()
      parent.tooltips.set_tip(self.enable_tooltips, ln.enable_tooltips_tip)
      
      vbox.show()

      outervbox.pack_start(frame, False, False, 0)
      
      # Stream normalizer config
      
      frametitlebox = gtk.HBox()
      self.normalize = gtk.CheckButton(ln.stream_normalizer)
      self.normalize.connect("toggled", self.cb_normalizer)
      frametitlebox.pack_start(self.normalize, True, False, 2)
      parent.tooltips.set_tip(self.normalize, ln.enable_stream_normalizer_tip)
      self.normalize.show()
      frametitlebox.show()

      frame = gtk.Frame()
      frame.set_label_widget(frametitlebox)
      frame.set_border_width(3)
      self.normalizer_hbox = gtk.HBox()
      self.normalizer_hbox.set_sensitive(False)
      self.normalizer_hbox.set_border_width(5)
      frame.add(self.normalizer_hbox)
      self.normalizer_hbox.show()
      mvbox = gtk.VBox()
      self.normalizer_hbox.pack_start(mvbox, True, False, 0)
      mvbox.show()
      lvbox = gtk.VBox()
      lvbox.set_spacing(2)
      self.normalizer_hbox.pack_start(lvbox, True, False, 0)
      lvbox.show()
      rvbox = gtk.VBox()
      rvbox.set_spacing(2)
      self.normalizer_hbox.pack_start(rvbox, True, False, 0)
      rvbox.show()
      outervbox.pack_start(frame, False, False, 0)
      frame.show()
      
      sizegroup = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
      
      boostbox = gtk.HBox()
      boostbox.set_spacing(3)
      self.normboost_adj = gtk.Adjustment(12.0, 0.0, 25.0, 0.1, 0.2, 0.2)
      normboost = gtk.SpinButton(self.normboost_adj, 1, 1)
      normboost.connect("value-changed", self.cb_normalizer)
      sizegroup.add_widget(normboost)
      boostbox.pack_start(normboost, False, False, 0)
      normboost.show()
      label = gtk.Label(ln.normboost)
      boostbox.pack_start(label, False, False, 0)
      label.show()
      lvbox.add(boostbox)
      boostbox.show()
      parent.tooltips.set_tip(normboost, ln.settings_warning_tip)
      
      ceilingbox = gtk.HBox()
      ceilingbox.set_spacing(3)
      self.normceiling_adj = gtk.Adjustment(-12.0, -25.0, 0.0, 0.1, 0.2, 0.2)
      normceiling = gtk.SpinButton(self.normceiling_adj, 1, 1)
      normceiling.connect("value-changed", self.cb_normalizer)
      sizegroup.add_widget(normceiling)
      ceilingbox.pack_start(normceiling, False, False, 0)
      normceiling.show()
      label = gtk.Label(ln.normceiling)
      ceilingbox.pack_start(label, False, False, 0)
      label.show()
      lvbox.add(ceilingbox)
      ceilingbox.show()
      parent.tooltips.set_tip(normceiling, ln.settings_warning_tip)
      
      defaultsbox = gtk.HBox()
      self.normdefaults = gtk.Button(ln.normdefaults)
      self.normdefaults.connect("clicked", self.normalizer_defaults)
      defaultsbox.pack_start(self.normdefaults, True, True, 0)
      self.normdefaults.show()
      mvbox.pack_start(defaultsbox, True, False, 0)
      defaultsbox.show()
      parent.tooltips.set_tip(self.normdefaults, ln.default_normalizer_tip)
      
      sizegroup = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
      
      risebox = gtk.HBox()
      risebox.set_spacing(3)
      self.normrise_adj = gtk.Adjustment(2.7, 0.1, 5.0, 0.1, 1.0, 1.0)
      normrise = gtk.SpinButton(self.normrise_adj, 1, 1)
      normrise.connect("value-changed", self.cb_normalizer)
      sizegroup.add_widget(normrise)
      risebox.pack_start(normrise, False, False, 0)
      normrise.show()
      label = gtk.Label(ln.normrise)
      risebox.pack_start(label, False, False, 0)
      label.show()
      rvbox.add(risebox)
      risebox.show()
      parent.tooltips.set_tip(normrise, ln.settings_warning_tip)
      
      fallbox = gtk.HBox()
      fallbox.set_spacing(3)
      self.normfall_adj = gtk.Adjustment(2.0, 0.1, 5.0, 0.1, 1.0, 1.0)
      normfall = gtk.SpinButton(self.normfall_adj, 1, 1)
      normfall.connect("value-changed", self.cb_normalizer)
      sizegroup.add_widget(normfall)
      fallbox.pack_start(normfall, False, False, 0)
      normfall.show()
      label = gtk.Label(ln.normfall)
      fallbox.pack_start(label, False, False, 0)
      label.show()
      rvbox.add(fallbox)
      fallbox.show()
      parent.tooltips.set_tip(normfall, ln.settings_warning_tip)
      
      aud_rs_hbox = gtk.HBox()
      
      # User can use this to set the audio level in the headphones
      
      frame = gtk.Frame(" " + ln.dj_audio_level + " ")
      frame.set_label_align(0.5, 0.5)
      frame.set_border_width(3)
      hbox = gtk.HBox()
      hbox.set_border_width(5)
      frame.add(hbox)
      hbox.show()
      
      self.dj_aud_adj = gtk.Adjustment(0.0, -60.0, 0.0, 0.5, 1.0, 1.0)
      dj_aud = gtk.SpinButton(self.dj_aud_adj, 1, 1)
      dj_aud.connect("value-changed", self.cb_dj_aud)
      hbox.pack_start(dj_aud, True, False, 0)
      dj_aud.show()
      parent.tooltips.set_tip(dj_aud, ln.dj_audio_tip)
      
      aud_rs_hbox.pack_start(frame, False, False, 0)
      frame.show()
      
      # User can use this to set the resampled sound quality
      
      frame = gtk.Frame(" " + ln.player_resample_mode + " ")
      frame.set_label_align(0.5, 0.5)
      frame.set_border_width(3)
      hbox = gtk.HBox()
      hbox.set_border_width(5)
      frame.add(hbox)
      hbox.show()
      self.best_quality_resample = gtk.RadioButton(None, ln.best_quality_resample)
      self.best_quality_resample.connect("toggled", self.cb_resample_quality, 0)
      rsbox = gtk.HBox()
      rsbox.pack_start(self.best_quality_resample, True, False, 0)
      rsbox.show()
      hbox.add(rsbox)
      self.best_quality_resample.show()
      self.good_quality_resample = gtk.RadioButton(self.best_quality_resample, ln.good_quality_resample)
      self.good_quality_resample.connect("toggled", self.cb_resample_quality, 1) 
      rsbox = gtk.HBox()
      rsbox.pack_start(self.good_quality_resample, True, False, 0)
      rsbox.show()
      hbox.add(rsbox)
      self.good_quality_resample.show()
      self.fast_resample = gtk.RadioButton(self.good_quality_resample, ln.fast_resample)
      self.fast_resample.connect("toggled", self.cb_resample_quality, 2) 
      rsbox = gtk.HBox()
      rsbox.pack_start(self.fast_resample, True, False, 0)
      rsbox.show()
      hbox.add(rsbox)
      self.fast_resample.show()
      self.fastest_resample = gtk.RadioButton(self.fast_resample, ln.fastest_resample)
      self.fastest_resample.connect("toggled", self.cb_resample_quality, 4) 
      rsbox = gtk.HBox()
      rsbox.pack_start(self.fastest_resample, True, False, 0)
      rsbox.show()
      hbox.add(rsbox)
      self.fastest_resample.show()
      aud_rs_hbox.pack_start(frame, True, True, 0)
      frame.show()
      parent.tooltips.set_tip(self.best_quality_resample, ln.player_resample_quality)
      parent.tooltips.set_tip(self.good_quality_resample, ln.player_resample_quality)
      parent.tooltips.set_tip(self.fast_resample, ln.player_resample_quality)
      parent.tooltips.set_tip(self.fastest_resample, ln.player_resample_quality)
      
      outervbox.pack_start(aud_rs_hbox, False, False, 0)
      aud_rs_hbox.show()
      
      frame = gtk.Frame(" " + ln.initial_player_settings + " ")
      frame.set_label_align(0.5, 0.5)
      frame.set_border_width(3)
      vbox = gtk.VBox()
      frame.add(vbox)
      vbox.show()
      
      restoresessionhbox = gtk.HBox()
      restoresessionhbox.set_border_width(8)
      restoresessionhbox.show()
      self.restore_session_option = gtk.CheckButton(ln.restore_session)
      vbox.pack_start(restoresessionhbox, False, False, 0)
      restoresessionhbox.pack_start(self.restore_session_option, False, False, 0)
      self.restore_session_option.show()
      parent.tooltips.set_tip(self.restore_session_option, ln.restore_session_tip)
      
      hbox = gtk.HBox()
      vbox.add(hbox)
      hbox.set_border_width(3)
      
      self.left_player_frame = gtk.Frame(" " + ln.player_1 + " ")
      self.left_player_frame.set_border_width(2)
      hbox.pack_start(self.left_player_frame, True, True, 6)
      self.left_player_frame.show()
      
      self.right_player_frame = gtk.Frame(" " + ln.player_2 + " ")
      self.right_player_frame.set_border_width(2)
      hbox.pack_start(self.right_player_frame, True, True, 6)
      self.right_player_frame.show()

      hbox.show()
      
      lvbox = gtk.VBox()
      lvbox.set_border_width(4)
      self.left_player_frame.add(lvbox)
      self.lplayall = gtk.RadioButton(None, ln.play_all)
      self.lplayall.set_border_width(1)
      lvbox.add(self.lplayall)
      self.lplayall.show()
      self.lloopall = gtk.RadioButton(self.lplayall, ln.loop_all)
      self.lloopall.set_border_width(1)
      lvbox.add(self.lloopall)
      self.lloopall.show()
      self.lrandom = gtk.RadioButton(self.lloopall, ln.random)
      self.lrandom.set_border_width(1)
      lvbox.add(self.lrandom)
      self.lrandom.show()
      self.lmanual = gtk.RadioButton(self.lrandom, ln.manual)
      self.lmanual.set_border_width(1)
      lvbox.add(self.lmanual)
      self.lmanual.show()
      self.lcueup = gtk.RadioButton(self.lmanual, ln.cue_up)
      self.lcueup.set_border_width(1)
      lvbox.add(self.lcueup)
      self.lcueup.show()
      separator = gtk.HSeparator()
      lvbox.pack_start(separator, False, False, 1)
      separator.show()
      self.lcountup = gtk.RadioButton(None, ln.count_up)
      self.lcountup.set_border_width(1)
      lvbox.add(self.lcountup)
      self.lcountup.show()
      self.lcountdown = gtk.RadioButton(self.lcountup, ln.count_down)
      self.lcountdown.set_border_width(1)
      lvbox.add(self.lcountdown)
      self.lcountdown.show()
      separator = gtk.HSeparator()
      lvbox.pack_start(separator, False, False, 1)
      separator.show()
      self.lstream = gtk.CheckButton(ln.stream)
      self.lstream.set_border_width(1)
      self.lstream.set_active(True)
      lvbox.add(self.lstream)
      self.lstream.show()
      self.llisten = gtk.CheckButton(ln.listen)
      self.llisten.set_border_width(1)
      self.llisten.set_active(True)
      lvbox.add(self.llisten)
      self.llisten.show()
      
      lvbox.show()
      
      rvbox = gtk.VBox()
      rvbox.set_border_width(4)
      self.right_player_frame.add(rvbox)
      self.rplayall = gtk.RadioButton(None, ln.play_all)
      self.rplayall.set_border_width(1)
      rvbox.add(self.rplayall)
      self.rplayall.show()
      self.rloopall = gtk.RadioButton(self.rplayall, ln.loop_all)
      self.rloopall.set_border_width(1)
      rvbox.add(self.rloopall)
      self.rloopall.show()
      self.rrandom = gtk.RadioButton(self.rloopall, ln.random)
      self.rrandom.set_border_width(1)
      rvbox.add(self.rrandom)
      self.rrandom.show()
      self.rmanual = gtk.RadioButton(self.rrandom, ln.manual)
      self.rmanual.set_border_width(1)
      rvbox.add(self.rmanual)
      self.rmanual.show()
      self.rcueup = gtk.RadioButton(self.rmanual, ln.cue_up)
      self.rcueup.set_border_width(1)
      rvbox.add(self.rcueup)
      self.rcueup.show()
      separator = gtk.HSeparator()
      rvbox.pack_start(separator, False, False, 1)
      separator.show()
      self.rcountup = gtk.RadioButton(None, ln.count_up)
      self.rcountup.set_border_width(1)
      rvbox.add(self.rcountup)
      self.rcountup.show()
      self.rcountdown = gtk.RadioButton(self.rcountup, ln.count_down)
      self.rcountdown.set_border_width(1)
      rvbox.add(self.rcountdown)
      self.rcountdown.show()
      separator = gtk.HSeparator()
      rvbox.pack_start(separator, False, False, 1)
      separator.show()
      self.rstream = gtk.CheckButton(ln.stream)
      self.rstream.set_border_width(1)
      self.rstream.set_active(True)
      rvbox.add(self.rstream)
      self.rstream.show()
      self.rlisten = gtk.CheckButton(ln.listen)
      self.rlisten.set_border_width(1)
      self.rlisten.set_active(True)
      rvbox.add(self.rlisten)
      self.rlisten.show()
      rvbox.show()
      
      self.misc_session_frame = gtk.Frame()
      self.misc_session_frame.set_border_width(4)
      misc_startup = gtk.HBox(True, 20)
      self.misc_session_frame.add(misc_startup)
      misc_startup.show()
      hbox2 = gtk.HBox()
      hbox2.pack_start(self.misc_session_frame, True, True, 7)
      hbox2.show()
      
      vbox.pack_start(hbox2, False, False, 2)
      self.misc_session_frame.show()
      misc_startupl = gtk.VBox()
      misc_startup.pack_start(misc_startupl, True, True, 5)
      misc_startupl.show()
      misc_startupr = gtk.VBox()
      misc_startup.pack_start(misc_startupr, True, True, 5)
      misc_startupr.show()
      
      self.tracks_played = gtk.CheckButton(ln.tracks_played)
      misc_startupl.add(self.tracks_played)
      self.tracks_played.show()
      self.stream_mon = gtk.CheckButton(ln.stream_monitor)
      misc_startupr.add(self.stream_mon)
      self.stream_mon.show()
      
      self.restore_session_option.connect("toggled", self.cb_restore_session)
      self.restore_session_option.set_active(True)
     
      outervbox.pack_start(frame, False, False, 0)
      frame.show() 
            
      features_label = gtk.Label(ln.general_tab)
      self.notebook.append_page(generalwindow, features_label)
      features_label.show()
      outervbox.show()
	 
      # Microphone tab
      
      mic_window = gtk.ScrolledWindow()
      mic_window.set_shadow_type(gtk.SHADOW_NONE)
      mic_window.set_border_width(8)
      mic_window.set_policy(gtk.POLICY_NEVER, gtk.POLICY_AUTOMATIC)
      viewport = gtk.Viewport()
      mic_window.add(viewport)
      mic_window.show()
      panevbox = gtk.VBox()
      panevbox.set_border_width(3)
      viewport.add(panevbox)
      viewport.show()
      
      compressorframe = gtk.Frame(" " + ln.dnr_compressor + " ")
      panevbox.pack_start(compressorframe, False, False, 0)
      panevbox.show()
      compressorframe.set_border_width(3)
      compressorhbox = gtk.HBox()
      compressorframe.add(compressorhbox)
      compressortable = gtk.Table(4, 3, True)
      compressorhbox.pack_start(compressortable, True, True, 15)
      compressorhbox.show()
      compressortable.show()
      compressorframe.show()
      
      compressortable.set_col_spacing(0, 12)
      compressortable.set_col_spacing(1, 16)
      
      ratio_box = gtk.HBox()
      compressortable.attach(ratio_box, 0, 1, 0, 1, gtk.FILL | gtk.EXPAND, 0, 0, 0)
      ratio_box.show()
      knee_box = gtk.HBox()
      compressortable.attach(knee_box, 1, 2, 0, 1, gtk.FILL | gtk.EXPAND, 0, 0, 0)
      knee_box.show()
      depth_box = gtk.HBox()
      compressortable.attach(depth_box, 2, 3, 0, 1, gtk.FILL | gtk.EXPAND, 0, 0, 0)
      depth_box.show()
      
      attack_box = gtk.HBox()
      compressortable.attach(attack_box, 1, 2, 1, 2, gtk.FILL | gtk.EXPAND, 0, 0, 0)
      attack_box.show()
      release_box = gtk.HBox()
      compressortable.attach(release_box, 1, 2, 2, 3, gtk.FILL | gtk.EXPAND, 0, 0, 0)
      release_box.show()
      gain_box = gtk.HBox()
      compressortable.attach(gain_box, 2, 3, 1, 2, gtk.FILL | gtk.EXPAND, 0, 0, 0)
      gain_box.show()
      man_rel_box=gtk.VBox()
      compressortable.attach(man_rel_box, 2, 3, 2, 3, gtk.FILL | gtk.EXPAND, 0, 0, 0)
      man_rel_box.show()
      
      ducking_box = gtk.HBox()
      compressortable.attach(ducking_box, 0, 1, 3, 4, gtk.FILL | gtk.EXPAND, 0, 0, 0)
      ducking_box.show()
      ducking_hold_box = gtk.HBox()
      compressortable.attach(ducking_hold_box, 1, 2, 3, 4, gtk.FILL | gtk.EXPAND, 0, 0, 0)
      ducking_hold_box.show()
      de_ess_box = gtk.HBox()
      compressortable.attach(de_ess_box, 2, 3, 3, 4, gtk.FILL | gtk.EXPAND, 0, 0, 0)
      de_ess_box.show()
      rms_frame = gtk.Frame(" " + ln.rms + " ")
      rms_frame.set_border_width(4)
      compressortable.attach(rms_frame, 0, 1, 1, 3, gtk.FILL | gtk.EXPAND, gtk.FILL | gtk.EXPAND, 0, 0)
      rms_frame.show()
                  
      self.ratio_adj = gtk.Adjustment(3.0, 1.0, 20.0, 0.5, 0.5, 0.5) 
      self.ratio = gtk.SpinButton(self.ratio_adj, 0.0, 1)
      self.ratio.connect("value-changed", self.cb_compressor, "ratio")
      ratio_box.pack_start(self.ratio, False, False, 0)
      self.ratio.show()
      label = gtk.Label(" " + ln.comp_ratio)
      ratio_box.pack_start(label, False, False, 0)
      label.show()
      parent.tooltips.set_tip(self.ratio, ln.drc_ratio_tip)
      
      self.knee_adj = gtk.Adjustment(-13.0, -99.0, 0.0, 1.0, 1.0, 1.0)
      self.knee = gtk.SpinButton(self.knee_adj, 0.5, 0)
      self.knee.connect("value-changed", self.cb_compressor, "knee")
      knee_box.pack_start(self.knee, False, False, 0)
      self.knee.show()
      label = gtk.Label(" " + ln.comp_knee)
      knee_box.pack_start(label, False, False, 0)
      label.show()
      parent.tooltips.set_tip(self.knee, ln.drc_knee_tip)
      
      self.depth_adj = gtk.Adjustment(27.0, 0.0, 99.0, 1.0, 1.0, 1.0)
      self.depth = gtk.SpinButton(self.depth_adj, 0.5, 0)
      self.depth.connect("value-changed", self.cb_compressor, "depth")
      depth_box.pack_start(self.depth, False, False, 0)
      self.depth.show()
      label = gtk.Label(" " + ln.comp_depth)
      depth_box.pack_start(label, False, False, 0)
      label.show()
      parent.tooltips.set_tip(self.depth, ln.drc_depth_tip)

      self.attack_adj = gtk.Adjustment(2.25, 1.0, 99.75, 0.05, 1.0, 1.0)
      self.attack = gtk.SpinButton(self.attack_adj, 0.9, 2)
      self.attack.connect("value-changed", self.cb_compressor, "attack")
      attack_box.pack_start(self.attack, False, False, 0)
      self.attack.show()
      label = gtk.Label(" " + ln.comp_attack)
      attack_box.pack_start(label, False, False, 0)
      label.show()
      parent.tooltips.set_tip(self.attack, ln.drc_attack_tip)
      
      self.release_adj = gtk.Adjustment(180.0, 10.0, 995.0, 5.0, 10.0, 10.0)
      self.release = gtk.SpinButton(self.release_adj, 0.9, 0)
      self.release.connect("value-changed", self.cb_compressor, "release")
      release_box.pack_start(self.release, False, False, 0)
      self.release.show()
      label = gtk.Label(" " + ln.comp_release)
      release_box.pack_start(label, False, False, 0)
      label.show()
      parent.tooltips.set_tip(self.release, ln.drc_release_tip)
      
      self.gain_adj = gtk.Adjustment(5.0, -60.0, 60.0, 1.0, 1.0, 1.0)
      self.gain = gtk.SpinButton(self.gain_adj, 0.5, 0)
      #sizegroup2.add_widget(self.gain)
      self.gain.connect("value-changed", self.cb_compressor, "gain")
      gain_box.pack_start(self.gain, False, False, 0)
      self.gain.show()
      label = gtk.Label(" " + ln.comp_gain)
      gain_box.pack_start(label, False, False, 0)
      label.show()
      parent.tooltips.set_tip(self.gain, ln.drc_gain)
      
      self.gain_relative = gtk.RadioButton(None, ln.comp_relative)
      man_rel_box.pack_start(self.gain_relative, False, False, 0)
      self.gain_relative.connect("toggled", self.cb_compressor, "relative")
      self.gain_relative.show()
      parent.tooltips.set_tip(self.gain_relative, ln.drc_gain_relative_tip)
      
      self.gain_manual = gtk.RadioButton(self.gain_relative, ln.comp_manual)
      self.gain_manual.connect("toggled", self.cb_compressor, "manual")
      man_rel_box.pack_start(self.gain_manual, False, False, 0)
      self.gain_manual.show()
      parent.tooltips.set_tip(self.gain_manual, ln.drc_gain_manual_tip)
      
      self.ducking_adj = gtk.Adjustment(1.6, 0.0, 3.0, 0.1, 0.1, 1.0)
      self.ducking = gtk.SpinButton(self.ducking_adj, 0, 1)
      self.ducking.connect("value-changed", self.cb_compressor, "ducking")
      ducking_box.pack_start(self.ducking, False, False, 0)
      self.ducking.show()
      label = gtk.Label(" " + ln.comp_ducking)
      ducking_box.pack_start(label, False, False, 0)
      label.show()
      parent.tooltips.set_tip(self.ducking, ln.drc_ducking_ratio_tip)
      
      self.ducking_hold_adj = gtk.Adjustment(680.0, 10.0, 1000.0, 10.0, 10.0, 10.0)
      self.ducking_hold = gtk.SpinButton(self.ducking_hold_adj, 0, 0)
      self.ducking_hold.connect("value-changed", self.cb_compressor, "duckhold")
      ducking_hold_box.pack_start(self.ducking_hold, False, False, 0)
      self.ducking_hold.show()
      label = gtk.Label(" " + ln.comp_duckhold)
      ducking_hold_box.pack_start(label, False, False, 0)
      label.show()
      parent.tooltips.set_tip(self.ducking_hold, ln.drc_ducking_hold_tip)

      self.de_ess_adj = gtk.Adjustment(30.0, 0.0, 40.0, 0.5, 0.5, 0.5)
      self.de_ess = gtk.SpinButton(self.de_ess_adj, 0, 1)
      self.de_ess.connect("value-changed", self.cb_compressor, "de-ess")
      de_ess_box.pack_start(self.de_ess, False, False, 0)
      label = gtk.Label(" " + ln.comp_de_ess)
      de_ess_box.pack_start(label, False, False, 0)
      label.show()
      self.de_ess.show()
      parent.tooltips.set_tip(self.de_ess, ln.drc_deess_tip)
      
      rms_hbox = gtk.HBox()
      rms_vbox = gtk.VBox()
      rms_hbox.pack_start(rms_vbox, True, False, 0)
      rms_frame.add(rms_hbox)
      rms_hbox.show()
      rms_vbox.show()
      
      self.filter_fast = gtk.RadioButton(None, ln.filter_fast)
      self.filter_fast.connect("toggled", self.cb_compressor, "filterfast")
      rms_vbox.add(self.filter_fast)
      self.filter_fast.show()
      parent.tooltips.set_tip(self.filter_fast, ln.drc_filter_3)
      
      self.filter_slow = gtk.RadioButton(self.filter_fast, ln.filter_slow)
      self.filter_slow.connect("toggled", self.cb_compressor, "filterslow")
      rms_vbox.add(self.filter_slow)
      self.filter_slow.show()
      parent.tooltips.set_tip(self.filter_slow, ln.drc_filter_30)
      
      # Noise gate
      
      gatehbox = gtk.HBox()
      gatehbox.set_border_width(7)
      gateframe = gtk.Frame(" " + ln.noise_gate + " ")
      gateframe.set_border_width(3)
      gateframe.add(gatehbox)
      gatehbox.show()
      panevbox.pack_start(gateframe, False, False, 0)
      gateframe.show()

      gateboxcol1 = gtk.VBox()
      gateboxcol1.set_spacing(11)
      gatehbox.pack_start(gateboxcol1, True, False, 0)
      gateboxcol1.show()
      gateboxcol2 = gtk.VBox()
      gateboxcol2.set_spacing(11)
      gatehbox.pack_start(gateboxcol2, True, False, 0)
      gateboxcol2.show()
      gateboxcol3 = gtk.VBox()
      gateboxcol3.set_spacing(11)
      gatehbox.pack_start(gateboxcol3, True, False, 0)
      gateboxcol3.show()
            
      gatethreshbox = gtk.HBox()
      gateboxcol1.add(gatethreshbox)
      gatethreshbox.show()
      
      gatehystbox = gtk.HBox()
      gateboxcol2.add(gatehystbox)
      gatehystbox.show()
      
      gatedelaybox = gtk.HBox()
      gateboxcol3.add(gatedelaybox)
      gatedelaybox.show()
      
      gateattenbox = gtk.HBox()
      gateboxcol1.add(gateattenbox)
      gateattenbox.show()
      
      gateontimebox = gtk.HBox()
      gateboxcol2.add(gateontimebox)
      gateontimebox.show()
      
      gateofftimebox = gtk.HBox()
      gateboxcol3.add(gateofftimebox)
      gateofftimebox.show()
      
      sizegroup = gtk.SizeGroup(gtk.SIZE_GROUP_HORIZONTAL)
      
      self.gate_threshold_adj = gtk.Adjustment(-47.0, -99.0, 0.0, 1.0, 1.0, 1.0)
      self.gate_threshold = gtk.SpinButton(self.gate_threshold_adj, 0.5, 0)
      self.gate_threshold.connect("value-changed", self.cb_noisegate, "threshold")
      gatethreshbox.pack_start(self.gate_threshold, False, False, 0)
      self.gate_threshold.show()
      label = gtk.Label(" " + ln.threshold)
      gatethreshbox.pack_start(label, False, False, 0)
      label.show()
      parent.tooltips.set_tip(self.gate_threshold, ln.ng_thresh_tip)
      
      self.gate_hyster_adj = gtk.Adjustment(6.0, 0.0, 10.0, 1.0, 1.0, 1.0)
      self.gate_hyster = gtk.SpinButton(self.gate_hyster_adj, 0, 0)
      sizegroup.add_widget(self.gate_hyster)
      self.gate_hyster.connect("value-changed", self.cb_noisegate, "hysteresis")
      gatehystbox.pack_start(self.gate_hyster, False, False, 0)
      self.gate_hyster.show()
      label = gtk.Label(" " + ln.hysteresis)
      gatehystbox.pack_start(label, False, False, 0)
      label.show()
      parent.tooltips.set_tip(self.gate_hyster, ln.ng_hyster_tip)
      
      self.gate_delay_adj = gtk.Adjustment(18.15, 1.0, 99.95, 0.05, 1.0, 1.0)
      self.gate_delay = gtk.SpinButton(self.gate_delay_adj, 0.5, 2)
      self.gate_delay.connect("value-changed", self.cb_noisegate, "delay")
      gatedelaybox.pack_start(self.gate_delay, False, False, 0)
      self.gate_delay.show()
      label = gtk.Label(" " + ln.ng_delay)
      gatedelaybox.pack_start(label, False, False, 0)
      label.show()
      parent.tooltips.set_tip(self.gate_delay, ln.ng_delay_tip)
      
      self.gate_attenuation_adj = gtk.Adjustment(-3.0, -60.0, 0.0, 1.0, 1.0, 1.0)
      self.gate_attenuation = gtk.SpinButton(self.gate_attenuation_adj, 0.5, 0)
      self.gate_attenuation.connect("value-changed", self.cb_noisegate, "attenuation")
      gateattenbox.pack_start(self.gate_attenuation, False, False, 0)
      self.gate_attenuation.show()
      label = gtk.Label(" " + ln.attenuation)
      gateattenbox.pack_start(label, False, False, 0)
      label.show()
      parent.tooltips.set_tip(self.gate_attenuation, ln.ng_atten_tip)
      
      self.gate_ontime_adj = gtk.Adjustment(1.2, 0.1, 9.9, 0.1, 1.0, 1.0)
      self.gate_ontime = gtk.SpinButton(self.gate_ontime_adj, 0.5, 1)
      sizegroup.add_widget(self.gate_ontime)
      self.gate_ontime.connect("value-changed", self.cb_noisegate, "ontime")
      gateontimebox.pack_start(self.gate_ontime, False, False, 0)
      self.gate_ontime.show()
      label = gtk.Label(" " + ln.rise)
      gateontimebox.pack_start(label, False, False, 0)
      label.show()
      parent.tooltips.set_tip(self.gate_ontime, ln.ng_rise_tip)
      
      self.gate_offtime_adj = gtk.Adjustment(11.0, 1.0, 999.0, 1.0, 1.0, 1.0)
      self.gate_offtime = gtk.SpinButton(self.gate_offtime_adj, 0.5, 0)
      self.gate_offtime.connect("value-changed", self.cb_noisegate, "offtime")
      gateofftimebox.pack_start(self.gate_offtime, False, False, 0)
      self.gate_offtime.show()
      label = gtk.Label(" " + ln.fall)
      gateofftimebox.pack_start(label, False, False, 0)
      label.show()
      parent.tooltips.set_tip(self.gate_offtime, ln.ng_fall_tip)
      
      # Mic mix and filter options
      
      self.mic_filter = 0		# The type of filter to use for the mic filter
      frame = gtk.Frame(" " + ln.af_h_sm + " ")
      frame.set_border_width(3)
      vbox = gtk.VBox()
      frame.add(vbox)
      vbox.show()
      frame.show()
      
      filterbox = gtk.HBox()
      filterbox.set_border_width(6)
      vbox.pack_start(filterbox, False, False, 0)
      filterbox.show()

      label = gtk.Label(ln.bass_cut)
      filterbox.pack_start(label, False, False, 5)
      label.show()
      self.filter_off = gtk.RadioButton(None, ln.off)
      self.filter_off.connect("toggled", self.cb_mic, "filter_off")
      filterbox.pack_start(self.filter_off, False, False, 3)
      self.filter_off.show()
      parent.tooltips.set_tip(self.filter_off, ln.af_off_tip)
      
      self.filter_mild = gtk.RadioButton(self.filter_off, ln.mild)
      self.filter_mild.connect("toggled", self.cb_mic, "filter_mild")
      filterbox.pack_start(self.filter_mild, False, False, 3)
      self.filter_mild.show()
      parent.tooltips.set_tip(self.filter_mild, ln.af_mild_tip)
      
      self.filter_sharp = gtk.RadioButton(self.filter_mild, ln.sharp)
      self.filter_sharp.connect("toggled", self.cb_mic, "filter_sharp")
      filterbox.pack_start(self.filter_sharp, False, False, 3)
      self.filter_sharp.show()
      parent.tooltips.set_tip(self.filter_sharp, ln.af_sharp_tip)
      
      vsep = gtk.VSeparator()
      filterbox.pack_start(vsep, True, False, 0)
      vsep.show()
      headroom_box = gtk.HBox()
      filterbox.pack_end(headroom_box, False, False, 6)
      self.headroom_adj = gtk.Adjustment(3.0, 0.0, 10.0, 0.5, 0.5, 0.5)
      self.headroom = gtk.SpinButton(self.headroom_adj, 0, 1)
      self.headroom.connect("value-changed", self.cb_mic, "headroom")
      headroom_box.pack_start(self.headroom, False, False, 0)
      self.headroom.show()
      label = gtk.Label(" " + ln.headroom)
      headroom_box.pack_start(label, False, False, 0)
      label.show()
      headroom_box.show()
      parent.tooltips.set_tip(self.headroom, ln.headroom_tip)
      
      # Left mic mix settings
      
      left_mic_mix_box = gtk.HBox()
      left_mic_mix_box.set_border_width(2)
      vbox.pack_start(left_mic_mix_box, False, False, 0)
      left_mic_mix_box.show()
      
      label = gtk.Label(ln.left)
      left_mic_mix_box.pack_start(label, False, False, 8)
      label.show()
      
      balance_box = gtk.HBox()
      label = gtk.Label(ln.l)
      balance_box.pack_start(label, False, False, 2)
      label.show()
      self.left_mic_mix_adj = gtk.Adjustment(0.0, 0.0, 100.0, 1.0, 3.0, 0.0)
      self.left_mic_mix_slider = gtk.HScale(self.left_mic_mix_adj)
      self.left_mic_mix_slider.connect("value-changed", self.cb_mic, "lmms_changed")
      self.left_mic_mix_slider.set_size_request(100, -1)
      self.left_mic_mix_slider.set_draw_value(False)
      balance_box.pack_start(self.left_mic_mix_slider, False, False, 0)
      self.left_mic_mix_slider.show()
      label = gtk.Label(ln.r)
      balance_box.pack_start(label, False, False, 2)
      label.show()
      left_mic_mix_box.pack_end(balance_box, False, False, 8)
      balance_box.show()
      parent.tooltips.set_tip(self.left_mic_mix_slider, ln.left_mic_stereo_tip)
      
      level_box = gtk.HBox()
      self.left_mic_level_adj = gtk.Adjustment(0.0, -20.0, 0.0, 1.0, 1.0, 1.0)
      self.left_mic_level = gtk.SpinButton(self.left_mic_level_adj)
      self.left_mic_level.connect("value-changed", self.cb_mic, "lmgs_changed")
      level_box.pack_start(self.left_mic_level, False, False, 0)
      self.left_mic_level.show()
      label = gtk.Label(" " + ln.level)
      level_box.pack_start(label, False, False, 0)
      label.show()
      left_mic_mix_box.pack_end(level_box, False, False, 8)
      level_box.show()
      parent.tooltips.set_tip(self.left_mic_level, ln.attenuate_left_tip)
      
      self.left_invert = gtk.CheckButton(" " + ln.invert)
      self.left_invert.connect("toggled", self.cb_mic, "left_invert")
      left_mic_mix_box.pack_end(self.left_invert, False, False, 8)
      self.left_invert.show()
      parent.tooltips.set_tip(self.left_invert, ln.invert_left_tip)

      # Right mic mix settings
      
      right_mic_mix_box = gtk.HBox()
      right_mic_mix_box.set_border_width(2)
      vbox.pack_start(right_mic_mix_box, False, False, 0)
      right_mic_mix_box.show()
      
      label = gtk.Label(ln.right)
      right_mic_mix_box.pack_start(label, False, False, 8)
      label.show()
      
      balance_box = gtk.HBox()
      label = gtk.Label(ln.l)
      balance_box.pack_start(label, False, False, 2)
      label.show()
      self.right_mic_mix_adj = gtk.Adjustment(100.0, 0.0, 100.0, 1.0, 3.0, 0.0)
      self.right_mic_mix_slider = gtk.HScale(self.right_mic_mix_adj)
      self.right_mic_mix_slider.connect("value-changed", self.cb_mic, "rmms_changed")
      self.right_mic_mix_slider.set_size_request(100, -1)
      self.right_mic_mix_slider.set_draw_value(False)
      balance_box.pack_start(self.right_mic_mix_slider, False, False, 0)
      self.right_mic_mix_slider.show()
      label = gtk.Label(ln.r)
      balance_box.pack_start(label, False, False, 2)
      label.show()
      right_mic_mix_box.pack_end(balance_box, False, False, 8)
      balance_box.show()
      parent.tooltips.set_tip(self.right_mic_mix_slider, ln.right_mic_stereo_tip)
      
      level_box = gtk.HBox()
      self.right_mic_level_adj = gtk.Adjustment(0.0, -20.0, 0.0, 1.0, 1.0, 1.0)
      self.right_mic_level = gtk.SpinButton(self.right_mic_level_adj)
      self.right_mic_level.connect("value-changed", self.cb_mic, "rmgs_changed")
      level_box.pack_start(self.right_mic_level, False, False, 0)
      self.right_mic_level.show()
      label = gtk.Label(" " + ln.level)
      level_box.pack_start(label, False, False, 0)
      label.show()
      right_mic_mix_box.pack_end(level_box, False, False, 8)
      level_box.show()
      parent.tooltips.set_tip(self.right_mic_level, ln.attenuate_right_tip)
      
      self.right_invert = gtk.CheckButton(" " + ln.invert)
      self.right_invert.connect("toggled", self.cb_mic, "right_invert")
      right_mic_mix_box.pack_end(self.right_invert, False, False, 8)
      self.right_invert.show()
      parent.tooltips.set_tip(self.right_invert, ln.invert_right_tip)
      
      mic_to_dj_box = gtk.HBox()
      self.mic_to_dj = gtk.CheckButton(" " + ln.mic_to_dj)
      self.mic_to_dj.set_active(True)
      self.mic_to_dj.connect("toggled", self.cb_mic, "mic_to_dj")
      mic_to_dj_box.pack_start(self.mic_to_dj, False, False, 8)
      self.mic_to_dj.show()
      vbox.pack_start(mic_to_dj_box, False, False, 0)
      mic_to_dj_box.show()
      parent.tooltips.set_tip(self.mic_to_dj, ln.mic_in_phones)
	    
      panevbox.pack_start(frame, False, False, 0)
      
      compressor_label = gtk.Label(ln.microphone_tab)
      self.notebook.append_page(mic_window, compressor_label)
      compressor_label.show()
       
      # X-Chat IRC announcements tag.
      
      vbox = gtk.VBox()
      vbox.set_border_width(6)
      sizegroup = gtk.SizeGroup(gtk.SIZE_GROUP_VERTICAL)
      
      trackannouncerframe = gtk.Frame(" " + ln.track_announcer + " ")
      trackannouncerframe.set_border_width(3)
      vbox.pack_start(trackannouncerframe, False, False, 0)
      announcervbox = gtk.VBox()
      announcervbox.set_border_width(5)
      trackannouncerframe.add(announcervbox)
      announcervbox.show()
      
      hbox = gtk.HBox()
      announcervbox.add(hbox)
      hbox.show()
      leftpaddingbox = gtk.VBox()
      leftpaddingbox.set_size_request(6, -1)
      hbox.pack_start(leftpaddingbox, False, False, 0)
      leftpaddingbox.show()
      leftvbox = gtk.VBox()
      hbox.pack_start(leftvbox, False, False, 0)
      leftvbox.show()
      rightvbox = gtk.VBox()
      hbox.pack_start(rightvbox, True, True, 0)
      rightvbox.show()
      paddingbox = gtk.VBox()
      paddingbox.set_size_request(6, -1)
      hbox.pack_start(paddingbox, False, False, 0)
      paddingbox.show()
      
      enablebox = gtk.HBox()
      self.announce_enable = gtk.CheckButton(" " + ln.enable)
      sizegroup.add_widget(self.announce_enable)
      enablebox.pack_end(self.announce_enable, False, False, 0)
      self.announce_enable.show()
      enablebox.show()
      leftvbox.add(enablebox)
      enablebox.show()
      parent.tooltips.set_tip(self.announce_enable, ln.enable_track_announcer_tip)

      nickbox = gtk.HBox()
      self.nickentry = gtk.Entry()
      sizegroup.add_widget(self.nickentry)
      self.nickentry.set_width_chars(14)
      self.nickentry.set_max_length(30)
      nickbox.pack_end(self.nickentry, False, False, 0)
      self.nickentry.show()
      nicklabel = gtk.Label(ln.nick + " ")
      nickbox.pack_end(nicklabel, False, False, 0)
      nicklabel.show()
      parent.tooltips.set_tip(self.nickentry, ln.nick_entry_tip)
      
      delaybox = gtk.HBox()
      nickbox.pack_end(delaybox, False, False, 14)
      delaybox.show()
      delaylabel = gtk.Label(ln.latency + " ")
      delaybox.pack_start(delaylabel, False, False, 0)
      delaylabel.show()
      self.announcedelayadj = gtk.Adjustment(10.0, 1.0, 60.0, 1.0, 1.0, 1.0)
      delay = gtk.SpinButton(self.announcedelayadj, 4, 0)
      delaybox.pack_start(delay, False, False, 0)
      delay.show()
      parent.tooltips.set_tip(delay, ln.track_announcer_latency_tip)
      
      rightvbox.pack_start(nickbox, False, False, 1)
      nickbox.show()
      
      channelslabel = gtk.Label(ln.channels + " ")
      sizegroup.add_widget(channelslabel)
      channelslabelbox = gtk.HBox()
      channelslabelbox.pack_end(channelslabel, False, False, 0)
      channelslabel.show()
      leftvbox.add(channelslabelbox)
      channelslabelbox.show()
      
      self.channelsentry = gtk.Entry()
      sizegroup.add_widget(self.channelsentry)
      channelsbox = gtk.HBox()
      channelsbox.pack_start(self.channelsentry, True, True, 0)
      self.channelsentry.show()
      rightvbox.pack_start(channelsbox, False, False, 1)
      channelsbox.show()
      parent.tooltips.set_tip(self.channelsentry, ln.irc_channels_tip)
      
      announcemessagelabel = gtk.Label(ln.message + " ")
      sizegroup.add_widget(announcemessagelabel)
      announcemessagelabelbox = gtk.HBox()
      announcemessagelabelbox.pack_end(announcemessagelabel, False, False, 0)
      announcemessagelabel.show()
      leftvbox.add(announcemessagelabelbox)
      announcemessagelabelbox.show()
      
      self.announcemessageentry = gtk.Entry()
      sizegroup.add_widget(self.announcemessageentry)
      announcemessagebox = gtk.HBox()
      announcemessagebox.pack_start(self.announcemessageentry, True, True, 0)
      self.announcemessageentry.show()
      rightvbox.pack_start(announcemessagebox, False, False, 1)
      self.announcemessageentry.connect("populate-popup", self.colourmenupopulate)
      self.announcemessageentry.connect("key-press-event", self.cb_handle_colour_char)
      announcemessagebox.show()
      parent.tooltips.set_tip(self.announcemessageentry, ln.announce_tip)
      
      trackannouncerframe.show()
      
      timerframe = gtk.Frame(" " + ln.irc_message_timer + " ")
      timerframe.set_border_width(3)
      vbox.pack_start(timerframe, False, False, 2)
      timerframe.show()
      timervbox = gtk.VBox()
      timervbox.set_border_width(5)
      timerframe.add(timervbox)
      timervbox.show()
      
      hbox = gtk.HBox()
      timervbox.add(hbox)
      hbox.show()
      leftpaddingbox = gtk.VBox()
      leftpaddingbox.set_size_request(6,-1)
      hbox.pack_start(leftpaddingbox, False, False, 0)
      leftpaddingbox.show()
      leftvbox = gtk.VBox()
      hbox.pack_start(leftvbox, False, False, 0)
      leftvbox.show()
      rightvbox = gtk.VBox()
      hbox.pack_start(rightvbox, True, True, 0)
      rightvbox.show()
      paddingbox = gtk.VBox()
      paddingbox.set_size_request(6, -1)
      hbox.pack_start(paddingbox, False, False, 0)
      paddingbox.show()
      
      enablebox = gtk.HBox()
      self.timer_enable = gtk.CheckButton(" " + ln.enable)
      sizegroup.add_widget(self.timer_enable)
      enablebox.pack_end(self.timer_enable, False, False, 0)
      self.timer_enable.show()
      enablebox.show()
      leftvbox.add(enablebox)
      enablebox.show()
      parent.tooltips.set_tip(self.timer_enable, ln.enable_message_timer_tip)

      nickbox = gtk.HBox()
      self.timernickentry = gtk.Entry()
      sizegroup.add_widget(self.timernickentry)
      self.timernickentry.set_width_chars(14)
      self.timernickentry.set_max_length(30)
      nickbox.pack_end(self.timernickentry, False, False, 0)
      self.timernickentry.show()
      nicklabel = gtk.Label(ln.nick + " ")
      nickbox.pack_end(nicklabel, False, False, 0)
      nicklabel.show()
      intervalbox = gtk.HBox()
      nickbox.pack_end(intervalbox, False, False, 14)
      parent.tooltips.set_tip(self.timernickentry, ln.nick_entry_tip)
      
      intervalbox.show()
      intervallabel = gtk.Label(ln.interval + " ")
      intervalbox.pack_start(intervallabel, False, False, 0)
      intervallabel.show()
      self.intervaladj = gtk.Adjustment(20.0, 1.0, 60.0, 1.0, 1.0, 1.0)
      interval = gtk.SpinButton(self.intervaladj, 4, 0)
      intervalbox.pack_start(interval, False, False, 0)
      interval.show()
      rightvbox.pack_start(nickbox, True, True, 1)
      nickbox.show()
      parent.tooltips.set_tip(interval, ln.message_timer_interval)
      
      channelslabel = gtk.Label(ln.channels + " ")
      sizegroup.add_widget(channelslabel)
      channelslabelbox = gtk.HBox()
      channelslabelbox.pack_end(channelslabel, False, False, 0)
      channelslabel.show()
      leftvbox.add(channelslabelbox)
      channelslabelbox.show()
      
      self.timerchannelsentry = gtk.Entry()
      sizegroup.add_widget(self.timerchannelsentry)
      channelsbox = gtk.HBox()
      channelsbox.pack_start(self.timerchannelsentry, True, True, 0)
      self.timerchannelsentry.show()
      rightvbox.pack_start(channelsbox, True, True, 1)
      channelsbox.show()
      parent.tooltips.set_tip(self.timerchannelsentry, ln.irc_channels_tip)
      
      timemessagelabel = gtk.Label(ln.message + " ")
      sizegroup.add_widget(timemessagelabel)
      timemessagelabelbox = gtk.HBox()
      timemessagelabelbox.pack_end(timemessagelabel, False, False, 0)
      timemessagelabel.show()
      leftvbox.add(timemessagelabelbox)
      timemessagelabelbox.show()
      
      self.timermessageentry = gtk.Entry()
      sizegroup.add_widget(self.timermessageentry)
      timemessagebox = gtk.HBox()
      timemessagebox.pack_start(self.timermessageentry, True, True, 0)
      self.timermessageentry.show()
      rightvbox.pack_start(timemessagebox, True, True, 1)
      self.timermessageentry.connect("populate-popup", self.colourmenupopulate)
      self.timermessageentry.connect("key-press-event", self.cb_handle_colour_char)
      timemessagebox.show()
      parent.tooltips.set_tip(self.timermessageentry, ln.announce_tip)
      
      timerframe.show()
      
      label = gtk.Label(ln.song_placemarker)
      hbox = gtk.HBox()
      hbox.add(label)
      vbox.pack_start(hbox, False, False, 2)
      hbox.show()
      label.show()
      
      irc_label = gtk.Label("X-Chat")
      self.notebook.append_page(vbox, irc_label)
      irc_label.show()
      vbox.show()
       
      # Jack settings Tab      
                 
      jack_window = gtk.ScrolledWindow()
      jack_window.set_border_width(8)
      jack_window.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
      jack_vbox = gtk.VBox()
      jack_vbox.set_spacing(3)
      jack_vbox.set_border_width(4)
      jack_window.add_with_viewport(jack_vbox)
      jack_window.show()
      
      jackname = os.environ["IDJC_JACK_SERVER"]
      if jackname != "default":
         label = gtk.Label(ln.using_jack_server + jackname)
         jack_vbox.add(label)
         label.show()
      
      frame = gtk.Frame()
      frame.set_border_width(5)
      vbox = gtk.VBox(False, 0)
      frame.add(vbox)
      frame.show()
      
      box, self.miclcheck, self.miclentry, self.miclupdate = make_entry_line(self, "Mic L: ", "MICL")
      vbox.add(box)
      box, self.micrcheck, self.micrentry, self.micrupdate = make_entry_line(self, "Mic R: ", "MICR")
      vbox.add(box)
      jack_vbox.add(frame)
      vbox.show()
      self.miclentry.set_text("system:capture_1")
      self.micrentry.set_text("system:capture_2")
     
      frame = gtk.Frame()
      frame.set_border_width(5)
      vbox = gtk.VBox(False, 0)
      frame.add(vbox)
      frame.show()
      box, self.audlcheck, self.audlentry, self.audlupdate = make_entry_line(self, "Aud L: ", "AUDL")
      vbox.add(box)
      box, self.audrcheck, self.audrentry, self.audrupdate = make_entry_line(self, "Aud R: ", "AUDR")
      vbox.add(box)
      jack_vbox.add(frame)
      vbox.show()
      self.audlentry.set_text("system:playback_1")
      self.audrentry.set_text("system:playback_2")
      
      frame = gtk.Frame()
      frame.set_border_width(5)
      vbox = gtk.VBox(False, 0)
      frame.add(vbox)
      frame.show()
      box, self.strlcheck, self.strlentry, self.strlupdate = make_entry_line(self, "Str L: ", "STRL")
      vbox.add(box)
      box, self.strrcheck, self.strrentry, self.strrupdate = make_entry_line(self, "Str R: ", "STRR")
      vbox.add(box)
      jack_vbox.add(frame)
      vbox.show()
      self.strlentry.set_text("system:playback_5")
      self.strrentry.set_text("system:playback_6")
      
      frame = gtk.Frame()
      frame.set_border_width(5)
      vbox = gtk.VBox(False, 0)
      frame.add(vbox)
      frame.show()
      box, self.auxlcheck, self.auxlentry, self.auxlupdate = make_entry_line(self, "Aux L: ", "AUXL")
      vbox.add(box)
      box, self.auxrcheck, self.auxrentry, self.auxrupdate = make_entry_line(self, "Aux R: ", "AUXR")
      vbox.add(box)
      jack_vbox.add(frame)
      vbox.show()
      
      jacklabel = gtk.Label(ln.jack_ports_tab)
      self.notebook.append_page(jack_window, jacklabel)
      jack_vbox.show()
      jacklabel.show()
      
      # Event tab
      
      vbox = gtk.VBox()
      vbox.set_border_width(4)
      vbox.set_spacing(2)
      
      app_event_container = self.event_command_container()
      self.appstart_event = self.event_command("icon", 20, 20, "", False, False, parent.tooltips, ln.app_start_tip, ln.shell_commands_tip)
      app_event_container.add(self.appstart_event)
      self.appstart_event.show()
      self.appexit_event = self.event_command("icon", 20, 20, "", False, True, parent.tooltips, ln.app_exit_tip, ln.shell_commands_tip)
      app_event_container.add(self.appexit_event)
      self.appexit_event.show()
      vbox.pack_start(app_event_container, False, False, 0)
      app_event_container.show()
      
      mic_event_container = self.event_command_container()
      self.mic_on_event = self.event_command("mic4", 20, 20, "", False, False, parent.tooltips, ln.mic_on_tip, ln.shell_commands_tip)
      mic_event_container.add(self.mic_on_event)
      self.mic_on_event.show()
      self.mic_off_event = self.event_command("mic4", 20, 20, "", False, True, parent.tooltips, ln.mic_off_tip, ln.shell_commands_tip)
      mic_event_container.add(self.mic_off_event)
      self.mic_off_event.show()
      vbox.pack_start(mic_event_container, False, False, 0)
      mic_event_container.show()
      
      aux_event_container = self.event_command_container()
      self.aux_on_event = self.event_command("jack2", 20, 20, "", False, False, parent.tooltips, ln.aux_on_tip, ln.shell_commands_tip)
      aux_event_container.add(self.aux_on_event)
      self.aux_on_event.show()
      self.aux_off_event = self.event_command("jack2", 20, 20, "", False, True, parent.tooltips, ln.aux_off_tip, ln.shell_commands_tip)
      aux_event_container.add(self.aux_off_event)
      self.aux_off_event.show()
      vbox.pack_start(aux_event_container, False, False, 0)
      aux_event_container.show()
      
      eventlabel = gtk.Label(ln.event_tab)
      self.notebook.append_page(vbox, eventlabel)
      eventlabel.show()
      vbox.show()
      
      # about tab
      
      frame = gtk.Frame()
      frame.set_border_width(9)
      vbox = gtk.VBox()
      frame.add(vbox)
      label = gtk.Label()
      label.set_markup('<span font_desc="sans italic 20">' + self.parent.appname + '</span>')
      vbox.pack_start(label, False, False, 13)
      label.show()
      label = gtk.Label()
      label.set_markup('<span font_desc="sans 13">Version ' + self.parent.version + '</span>')
      vbox.pack_start(label, False, False, 0)
      label.show()
      
      pixbuf = gtk.gdk.pixbuf_new_from_file(pkgdatadir + "logo" + gfext)
      #pixbuf = pixbuf.scale_simple(265, 70, gtk.gdk.INTERP_BILINEAR)
      image = gtk.Image()
      image.set_from_pixbuf(pixbuf)
      vbox.pack_start(image, False, False, 8)
      image.show()
      
      label = gtk.Label()
      label.set_markup(u'<span font_desc="sans 13">' + self.parent.copyright + u'</span>')
      vbox.pack_start(label, False, False, 12)
      label.show()
      
      lw = licence_window.LicenceWindow()
      try:
         gtk.LinkButton
      except AttributeError:
         licence_button = gtk.Button(ln.licence)
      else:
         licence_button = gtk.LinkButton("", ln.licence)
      licence_button.connect_object("clicked", gtk.Window.present, lw)
      lwhbox = gtk.HBox()
      lwhbox.pack_start(licence_button, True, False, 0)
      licence_button.show()
      vbox.pack_start(lwhbox, False, False, 8)
      lwhbox.show()
      
      vbox.show()

      aboutlabel = gtk.Label(ln.about_tab)
      self.notebook.append_page(frame, aboutlabel)
      aboutlabel.show()
      frame.show()
      
      self.notebook.show()

      # These shown by default
      self.mic_peak_toggle.set_active(True)
      self.stream_peak_toggle.set_active(True)
      self.limiter_toggle.set_active(True)
      #self.enhanced_crossfade.set_active(True)
      self.djalarm.set_active(True)
      self.dither.set_active(True)
      self.fastest_resample.set_active(True)
      self.enable_tooltips.set_active(True)
      
      self.load_jack_port_settings()
      self.bind_jack_ports()
      
      self.playersettingsdict = {	# Settings of these will be saved in the config file 
         "lplayall"      : self.lplayall,	# These are all True/False values
	 "lloopall"      : self.lloopall,
	 "lrandom"       : self.lrandom,
	 "lmanual"       : self.lmanual,
         "lcueup"	 : self.lcueup,
	 "lcountup"      : self.lcountup,
	 "lcountdown"    : self.lcountdown,
	 "lstream"       : self.lstream,
	 "llisten"       : self.llisten,
	 "rplayall"      : self.rplayall,
	 "rloopall"      : self.rloopall,
	 "rrandom"       : self.rrandom,
	 "rmanual"       : self.rmanual,
         "rcueup"	 : self.rcueup,
	 "rcountdown"    : self.rcountdown,
	 "rstream"       : self.rstream,
	 "rlisten"       : self.rlisten,
	 "startmini"     : self.startmini,
	 "micfiltmild"   : self.filter_mild,
	 "micfiltsharp"  : self.filter_sharp,
	 "micpeak"	 : self.mic_peak_toggle,
	 "vumeters"	 : self.vu_toggle,
	 "streampeak"	 : self.stream_peak_toggle,
	 "limitergain"   : self.limiter_toggle,
	 "comprelative"  : self.gain_relative,
         "filterslow"    : self.filter_slow,
	 "leftinvert"	 : self.left_invert,
	 "rightinvert"	 : self.right_invert,
	 "announce_en"	 : self.announce_enable,
	 "timer_en"	 : self.timer_enable,
         "djalarm"	 : self.djalarm,
         "trxpld"	 : self.tracks_played,
         "strmon"	 : self.stream_mon,
         "bigdigibox"	 : self.bigger_box_toggle, 
         "normalize"	 : self.normalize,
         "dither"	 : self.dither,
         "recallsession" : self.restore_session_option,
         "keeppass"      : self.keeppass,
         "ee_appstart"	 : self.appstart_event,
         "ee_appexit"    : self.appexit_event,
         "ee_micon"	 : self.mic_on_event,
         "ee_micoff"	 : self.mic_off_event,
         "ee_auxon"	 : self.aux_on_event,
         "ee_auxoff"	 : self.aux_off_event,
         "best_rs"	 : self.best_quality_resample,
         "good_rs"	 : self.good_quality_resample,
         "fast_rs"	 : self.fast_resample,
         "fastest_rs"	 : self.fastest_resample,
         "micauxmutex"	 : self.mic_aux_mutex,
         "speed_var"	 : self.speed_variance,
	 "mic_to_dj"	 : self.mic_to_dj,
         "showtips"      : self.enable_tooltips,
         "mp3utf8"	 : self.mp3_utf8
	 }
	 
      self.valuesdict = {
         "compratio"	 : self.ratio_adj,	# These are all numeric values
	 "compknee"	 : self.knee_adj,
	 "compkneedepth" : self.depth_adj,
	 "compattacktc"	 : self.attack_adj,
	 "compreleasetc" : self.release_adj,
	 "compgain"	 : self.gain_adj,
	 "ngthreshold"   : self.gate_threshold_adj,
	 "nghysteresis"  : self.gate_hyster_adj,
	 "ngdelayt"	 : self.gate_delay_adj,
	 "nggateatten"	 : self.gate_attenuation_adj,
	 "ngontimetc"	 : self.gate_ontime_adj,
	 "ngofftimetc"	 : self.gate_offtime_adj,
	 "ducking"	 : self.ducking_adj,
	 "duckingholdt"	 : self.ducking_hold_adj,
	 "leftmiclevel"	 : self.left_mic_level_adj,
	 "rightmiclevel" : self.right_mic_level_adj,
	 "leftmicmix"	 : self.left_mic_mix_adj,
	 "rightmicmix"	 : self.right_mic_mix_adj,
	 "headroom"	 : self.headroom_adj,
	 "de-ess"	 : self.de_ess_adj,
	 "interval"	 : self.intervaladj,
         "latency"	 : self.announcedelayadj,
         "interval_vol"	 : self.parent.jingles.interadj,
	 "fullwinx"	 : self.parent.fullwinx,
         "fullwiny"	 : self.parent.fullwiny,
         "minwinx"	 : self.parent.minwinx,
         "minwiny"	 : self.parent.minwiny,
         "jingleswinx"   : self.parent.jingles.jingleswinx,
         "jingleswiny"   : self.parent.jingles.jingleswiny,
         "passspeed"	 : self.parent.passspeed_adj, 
         "normboost"	 : self.normboost_adj,
         "normceiling"	 : self.normceiling_adj,
         "normrisetc"	 : self.normrise_adj,
         "normfalltc"	 : self.normfall_adj, 
         "djvolume"	 : self.dj_aud_adj
         }
	 
      self.textdict = {
         "announcenick"	 : self.nickentry,	# These are all text
	 "announcechan"	 : self.channelsentry, 
	 "announcemess"	 : self.announcemessageentry,
	 "timernick"	 : self.timernickentry,
	 "timerchan"	 : self.timerchannelsentry,
	 "timermess"	 : self.timermessageentry,
         "ltfilerqdir"   : self.parent.player_left.file_requester_start_dir,
         "rtfilerqdir"   : self.parent.player_right.file_requester_start_dir,
         "et_appstart"	 : self.appstart_event,
         "et_appexit"    : self.appexit_event,
         "et_micon"	 : self.mic_on_event,
         "et_micoff"	 : self.mic_off_event,
         "et_auxon"	 : self.aux_on_event,
         "et_auxoff"	 : self.aux_off_event
         }

      self.rangewidgets = (self.parent.deckadj,)
