
/****************************************************************************/
/*                                                                          */
/* simple example / test                                                    */
/*                                                                          */
/****************************************************************************/

#include <stdlib.h>
#include <stdio.h>

#include <idsa.h>

int main(int argc, char **argv)
{
  IDSA_CONNECTION *c;
  int result;

  /* connect to idsad as test-service, no credential and no flags */
  c = idsa_open("test-service", NULL, 0);
  if (c == NULL) {
    fprintf(stderr, "%s: unable to initialize\n", argv[0]);
    exit(1);
  }

  /* report test-event in test-scheme namepace with unknown risks */
  result = idsa_set(c, "test-event", "test-scheme", 1, IDSA_R_UNKNOWN, IDSA_R_UNKNOWN, IDSA_R_UNKNOWN, NULL);

  /* check if event is allowed or denied */
  if (result == IDSA_L_ALLOW) {
    printf("%s: allow\n", argv[0]);
  } else {
    printf("%s: deny\n", argv[0]);
  }

  /* close connection */
  idsa_close(c);

  return 0;
}
