Name: ifpgui
Version: 0.12.0
Release: SuSE10.x
Group: Applications/Multimedia
Packager: Jim Campbell
Summary: iRiver Manager for GNU/Linux
Source: %{name}-%{version}.tar.gz
License: GPL
Requires: libusb qt3
BuildRoot: /var/tmp/%{name}-buildroot
Prefix: /usr/local/bin


%description
ifpgui is an iRiver Manager like software interface for GNU/Linux.
It uses a pure QT programming interface.
There is support for
iFP-100 series
iFP-300 series
iFP-500 series
iFP-700 series
iFP-800 series
iFP-900 series
and possibly for the N10 series.

Please send feedback to ifpgui@gmail.com


Implemented are:
   Upload using m3u playlist.
   Upload File/Directory
   Download File/Directory
   Delete File/Directory (and multiple files/directories)
   File Rename
   Make Directory
   Format Device
   Update Firmware
   Battery Status
   Used/Free Space
   iFP info (model, firmware, etc)
   Download MP3 files
   Tuner Support
   Convert *.REC to *.mp3 on download(INCOMPLETE)

   Expands and hi-lights newly up/down(loaded) files and directories
   Detect iFP disconnect

   Local File Delete
   Local File/Dir Rename
   Local Make Directory
   Local Directory Refresh

%prep
%setup
%build
# For updating the translation file
# lupdate src/src.pro

# For building the translation binaries
lrelease src/src.pro

# For compiling source code
qmake src/src.pro
qmake ifpgui.pro
make
strip bin/ifpgui

%install
rm -rf $RPM_BUILD_ROOT

mkdir -p -m 755 $RPM_BUILD_ROOT
mkdir -p -m 755 $RPM_BUILD_ROOT/usr
mkdir -p -m 755 $RPM_BUILD_ROOT/usr/local
mkdir -p -m 755 $RPM_BUILD_ROOT/usr/local/ifpgui
mkdir -p -m 755 $RPM_BUILD_ROOT/usr/local/ifpgui/translations

cp bin/ifpgui $RPM_BUILD_ROOT/usr/local/ifpgui/
cp nonroot.sh  $RPM_BUILD_ROOT/usr/local/ifpgui/
cp src/translations/*.qm  $RPM_BUILD_ROOT/usr/local/ifpgui/translations/
%post
echo "We may need to allow non-root user access to USB iFP Device."
echo "Run nonroot.sh (/usr/local/ifpgui/nonroot.sh) if needed."

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
/usr/local/ifpgui/ifpgui
/usr/local/ifpgui/nonroot.sh
/usr/local/ifpgui/translations/*

%changelog
* Thu Aug 30 2007 (ifpgui-0.12.0)
        - Added the processingFile flags to ioInterface.
        - Do not update status when isProcessing() is TRUE.
          This fixes a very serious bug the caused upload and download
          corruption.
        - isProcessing() runs from the top leve of the GUI down to the
          ioInterface to determine if the application is transfering files.
        - minor changes to the directory structure.
* Wed May 24 2006 (ifpgui-0.10.8)
        - Added patch from d-frog to fix renaming directories
           and then doing a refresh.
* Sun Jan 22 2006 (ifpgui-0.10.7)
        - Added Translation for Danish and German
           Danish translation added by Jørgen Elgaard Larsen
           German translation added by Peter Bittner
        - Fixed some translations problems.
* Fri Dec 17 2005 (ifpgui-0.10.6)
        - Added patch by John Steele Scott to support directories that are
           symbolic links.
        - Changed name back to ifpgui.
        - Added Ubuntu Debian package support files under the debian directory.
        - Moved the SuSE spec file to the suse directory.
* Sat Nov 19 2005 (ifpgui-0.10.5)
        - Finished translation stuff.
        - Applied patch from Sergey V Turchin for adding translations.
        - Added the Russian translation from Sergey V Turchin.
* Wed Oct 19 2005 (ifpgui-0.10.4)
        - Fixed support for utf-8.  All buffers to and from the ifp library are converted
           to utf-8 compatable buffers. (I hope).
* Sat Oct 15 2005 (ifpgui-0.10.3)
        - Added #include <errno.h> to iointerface.cpp.
* Mon Oct 10 2005 (ifpgui-0.10.2)
        - Fixed Format, was not showing a message stating what it was doing.
           Also the file list was not refreshed.
        - Another fix with create directory.  The cancel was showing a
           message even though the uses chose cancel.
       - Added Icons to menu commands.
* Thu Oct 06 2005 (ifpgui-0.10.1)
       - Fixed several bugs:
          Making directories would not put selected node at new directory.
          Menu items, delete, rename, mkdir, etc were not working.
          Different file picker for Upload Playlist and Update Firmware.
          About QT broken
          Buttons would do nothing when clicked when iRiver not plugged in.
          Filelist would not clear on disconnect.
        - Added a toolbar to the file viewer.  Now the standard file
           system functions will be accessable via an attached toolbar.
           These functions include: up one directory, refresh, new
           directory, properties, rename and delete.
        - Changes to dialogs.  All Yes/No and OK dialogs use a standard
           function for their display.  The dialogs come to the front
           when they popup.  Also the progress dialog now is a stay-on-
           top dialog that will minimize with the application.
* Wed Sep 21 2005 (ifpgui-0.10.0)
        - Made an I/O interface so that all function dealing with the
           file systems can be centralized.  All local functions are
           handled from one class and all ifp functions are handled from
           another class.  Both classes are decendants of a base i/o
           class.
        - Made a major overhall to the internals of the GUI to use the
           new I/O interface classes.  This includes the removal of
           ifpviewer.cpp and ifpviewer.h.  There is now only one widget
           that supports the viewing of files.  This widget is a now the
           fileviewer.cpp class and functions; but all the backend is
           handled by the I/O interface class.  In theory, any protocol
           can be added to the I/O interface and the file viewer can use
           this new protocol seemlessly.
* Fri Sep 02 2005 (ifpgui-0.9.3)
        - Just a little code cleanup in ifpviewer.cpp and fileviewer.cpp
        - Fixed Delete tool button to check the window with focus before
           calling the appropriate delete function.
        - Patched libifp files into ifp_gui.
        - Fixed support for deleting local files and directories with
           multi-national characters.
        - Fixed some anomalies with the handling of the selected item
           within the file trees.  Mainly dealing with what happens
           after an item is deleted.
        - Added check for sane values when reading from settings file.
        - Changed the update firmware and format icons
        - CVS Repository created on sourceforge.
        - CVS Repository created on sourceforge.
        - Implemented dialogs to show while deleting files and directories.
           There is still a problem with deleting just one file or directory.
           The dialog shows but there is nothing in it.  It seems to be
           random because sometimes it works.
* Sun Jul 31 2005 (ifpgui-0.9.2)
        - Added support for drag drop from Konqueror and Nautilus.
* Wed Jul 27 2005 (ifpgui-0.9.1)
        - Rearanged menus to look similar to windows version of
           iRiver Manager.
        - Added horizontal and vertical view alignments.
        - Progress dialog appears after a yes/yes all to confirm action.
        - Dialogs to confirm action are better worded.

* Sat Jul 16 2005 (ifpgui-0.8.5)
        - Added preliminary support for multi-national filename support.
* Fri Jul 15 2005 (ifpgui-0.8.1)
        - Fixed bug with deleting a directory and some files from iFP device.
        - Fixed bug with uploading a directory and some files to iFP device.
           It used to upload the files under the directory and also upload
           the directory (including the files).  So you got the files twice.
        - Fixed same bug as above, but for download.
        - Fixed refreshing and current file/directory selection after upload
           or download.  Now it places the current item in a better place
           and also selects/opens the item to show the contents.
        - Fixed the progress dialog.  It never shows multiple dialogs for
           one user initiated transfer.  All transfers are shown with two
           progress bars (one for total progress and one for current file
           progress).  The only exception is when the user is actually
           transfering only one file.
* Thu Jul 7 2005 (ifpgui-0.8.0)
        - Added support for uploading files using a playlist.
           Currently only m3u files are supported.  If the need arrises
           other formats can be supported as well.
* Sun Jun 19 2005 (ifpgui-0.7.0)
        - Added check box menu item to convert the *.REC files to mp3 files.
           This is still incomplete because I do not have access to any
           *.REC files in the iRiver format.
* Thu May 26 2005 (ifpgui-0.6.4.1)
        - Fixed the filename truncation routines in progressdlg.cpp
           Now the file path truncator is seperate from the file name truncator.
           This also make it more CPU friendly.
* Sun May 22 2005 (ifpgui-0.6.4)
        - Fixed infinite loop on truncating long file names in progress window.
* Thu Mar 24 2005 (ifpgui-0.6.3)
        - Added #include errno.h to filevewer.cpp.
* Thu Feb 24 2005 (ifpgui-0.6.2)
        - Fixed a bug with using tuner support and libifp.
        - Fixed a rounding problem with tuner support.
        - Added an application icon.  (there are two multimedia.png and music.png).
           I chose music.png
        - Updated to libifp-1.0.0.1

* Wed Feb 16 2005 (ifpgui-0.6.1)
        - Icons are now embedded into the application.
        - application parameters (window size, etc) are stored in
           ~/.ifp_gui_rc    ( ~ is your home directory: ie /home/user)
        - Built a .spec file for rpm distribution.

* Sun Feb 13 2005 (ifpgui-0.6.0)
        - Added button with pixmap to open tuner dialog
        - Added support for changing tuner presets

* Sun Feb 6 2005 (ifpgui-0.5.5)
        - Fixed the drag drop upload.  Now it uploads to the root directory on
	   the iFP device when a file is dropped on a file in the root directory.
        - Added the nonroot script to add the iFP device to the usb list of
	   supported hardware.