/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iglobals.h"
#include "icaptioninteractorstyle.h"

#include "ivisualobject.h"
#include "ivisualobjectfamily.h"
#include "imarker.h"
#include "icaption.h"
#include "ivtk.h"

#include <vtkMath.h>
#include <vtkRenderWindowInteractor.h>
#include <vtkRenderer.h>
#include <vtkCamera.h>
#include <vtkActor2D.h>


iCaptionInteractorStyle* iCaptionInteractorStyle::New(iVTK *m)
{
	return new iCaptionInteractorStyle(m);
}


iCaptionInteractorStyle::iCaptionInteractorStyle(iVTK *m) : iVTKSource(m)
{
	this->InteractionCaption = NULL;
}


void iCaptionInteractorStyle::FindPickedActor(int x, int y)
{
#ifndef I_VTK_VERSION_40	
	int i;
	int *x1, *x2;

	if(this->CurrentRenderer == NULL) return;
	
	for(i=0; i<=myVTK->getMarkerFamily()->getMaxMemberIndex(); i++) if(myVTK->getMarkerFamily()->getMember(i)->getMarkerCaption()->GetVisibility() == 1)
	{
		x1 = myVTK->getMarkerFamily()->getMember(i)->getMarkerCaption()->GetPositionCoordinate()->GetComputedDisplayValue(this->CurrentRenderer);
		x2 = myVTK->getMarkerFamily()->getMember(i)->getMarkerCaption()->GetPosition2Coordinate()->GetComputedDisplayValue(this->CurrentRenderer);
		if(x>x1[0] && y>x1[1] && x<x2[0] && y<x2[1])
		{
			this->InteractionCaption = myVTK->getMarkerFamily()->getMember(i)->getMarkerCaption();
			return;
		}
	}
	this->InteractionCaption = NULL;
#endif
}

//
//  Rotating - a copy of vtkInteractorStyleTrackballActor::Rotate() with 
//  no changes
//
void iCaptionInteractorStyle::Rotate()
{
#ifndef I_VTK_VERSION_40	
	if(this->CurrentRenderer==NULL || this->InteractionCaption==NULL)
    {
		return;
    }
	
	vtkRenderWindowInteractor *rwi = this->Interactor;
	
	int *size = this->CurrentRenderer->GetSize();
	float dx = rwi->GetEventPosition()[0] - rwi->GetLastEventPosition()[0];
	float dy = rwi->GetEventPosition()[1] - rwi->GetLastEventPosition()[1];
	
	vtkFloat *x = this->InteractionCaption->GetPosition();
	this->InteractionCaption->SetPosition(x[0]+dx/size[0],x[1]+dy/size[1]);
	
    rwi->Render();
#endif
}

//
// Need to overload this function too because it is not declared virtual in the parent class 
//
void iCaptionInteractorStyle::OnLeftButtonDown() 
{
#ifndef I_VTK_VERSION_40	
	int x = this->Interactor->GetEventPosition()[0];
	int y = this->Interactor->GetEventPosition()[1];
	
	this->FindPokedRenderer(x, y);
	this->FindPickedActor(x, y);
	if (this->CurrentRenderer == NULL || this->InteractionCaption == NULL)
    {
		return;
    }
	
    this->StartRotate();
#endif	
}


void iCaptionInteractorStyle::OnLeftButtonUp()
{
#ifndef I_VTK_VERSION_40	
	vtkInteractorStyleTrackballActor::OnLeftButtonUp();
	//
	//  Quantize the position
	//
	vtkFloat *x0, x[2];
	if(this->InteractionCaption != NULL)
	{
		int *size = this->CurrentRenderer->GetSize();
		x0 = this->InteractionCaption->GetPosition();
		x[0] = 10.0*floor(0.1*x0[0]*size[0])/size[0];
		x[1] = 10.0*floor(0.1*x0[1]*size[1])/size[1];
		this->InteractionCaption->SetPosition(x[0],x[1]);

		((vtkRenderWindowInteractor *)this->Interactor)->Render();

	}
#endif
}

