/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iqt.h"
#include "ivtk.h"
#include "ivtkwindow.h"
#include "iqtwindow.h"

#include "iqtdefs.h"
#include "iqt_surf.h"
#include "iqt_view.h"

#include "idatareader.h"
#include "imath.h"
#include "isurface.h"
#include "ilimits.h"
#include "ipalette.h"
#include "idatareader.h"
#include "ierror.h"
#include "iqtextension.h"

#include <qaction.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qcolordialog.h> 
#include <qcombobox.h>
#include <qcursor.h>
#include <qiconset.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlcdnumber.h>
#include <qobjectlist.h>
#include <qpixmap.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qslider.h>
#include <qspinbox.h>
#include <qtabwidget.h>


#define LIST_MENU_ICONSET QIconSet(QPixmap(14,14))


#define CURRENT_LIMITS	iVTKWindow::getCurrentWindow()->getReader()->getLimits(CURRENT_SURFACE->getDataChannel())


//
// *********************************************************************************
//
//  
//   Isosurface panel widgets
//
//
// *********************************************************************************
//
void iQT_Surf::init()
{
	
	myQT = (iQT *)parentWidget()->parentWidget()->parentWidget()->parentWidget()->parentWidget()->parentWidget();
	if(strcmp(myQT->name(),"iQT") != 0)
	{
		iQTWindow::getCurrentWindow()->popupError("Incorrect parenting in Tab Pages",IFRITERROR_INCORRECT_PARENTING_IN_TABS);
		exit(1);
	}

	side = false;
	//
	//  Define the popup menu
	//
	instancesListMenu = new QPopupMenu((QWidget *)TabWidget);
	instancesListMenu->setCheckable(true);
	instancesListMenu->insertTearOffHandle();

	instancesListMenu->insertItem(LIST_MENU_ICONSET,"Instance 1",0,-1);
	QPixmap p = instancesListMenu->iconSet(0)->pixmap();
	p.fill(iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getMember(0)->getColor());
	instancesListMenu->iconSet(0)->setPixmap(p,QIconSet::Automatic);
	
	instancesListMenu->setItemChecked(0,true);
	connect(instancesListMenu, SIGNAL( activated(int) ) ,this, SLOT( setCurrentInstance(int) ) );
	//
	//  Make sliders look better
	//
	LayoutSurfLevel->setStretchFactor(LayoutSurfLevelLeft,3); 
	LayoutSurfLevel->addStretch(1); 
	
	LayoutSurfMaterial->setStretchFactor(Surf_Paint_MaterialGroupBox,3);
	LayoutSurfMaterial->addStretch(1); 
	
	LayoutSurfEnhancements->setStretchFactor(Surf_Level_EnhancementsGroupBox,3);
	LayoutSurfEnhancements->addStretch(1); 
	
}


void iQT_Surf::destroy()
{
	
	delete instancesListMenu;
	
}


void iQT_Surf::mousePressEvent( QMouseEvent * e )
{
	
	if(e->button() == Qt::RightButton)
	{
		instancesListMenu->exec(QCursor::pos());
	}
	
}


void iQT_Surf::setCurrentInstance(int n)
{

	iVTKWindow::getCurrentWindow()->getSurfaceFamily()->setCurrentMemberIndex(n);
	this->updateSurf_Widgets();	
	
}


void iQT_Surf::doRender()
{
	myQT->doRender();
}


void iQT_Surf::updateSurf_Widgets()
{
	static int nInstance = -1;
	static int cInstance = -1;
	static iVTK *myVTK = 0;
	int cInstanceBatchTo, cInstanceBatchFrom;
    int i;
	float f;
	QString s1;
    
	//
	//  update instance lists if VTK or the # of instances changed
	//
	cInstanceBatchFrom = Surf_Mult_BatchFromInstanceList->currentItem();
	cInstanceBatchTo = Surf_Mult_BatchToInstanceList->currentItem();
	if(iVTKWindow::getCurrentWindow()!=myVTK || nInstance!=iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getMaxMemberIndex())
	{
		//
		//  Reset some things if window changed
		//
		if(iVTKWindow::getCurrentWindow() != myVTK)
		{
			CALL_FUNCTION1(Surf_Main_OpacityLockAll,setChecked,false);
			CALL_FUNCTION1(Surf_Paint_MaterialLockAll,setChecked,false);
			side = false;
			cInstanceBatchTo = cInstanceBatchFrom = 0;
		}

		myVTK = iVTKWindow::getCurrentWindow();
		nInstance = iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getMaxMemberIndex();

		Surf_Mult_SetCurrentInstanceList->blockSignals(true);
		Surf_Mult_BatchFromInstanceList->blockSignals(true);
		Surf_Mult_BatchToInstanceList->blockSignals(true);
		instancesListMenu->blockSignals(true);

		Surf_Mult_SetCurrentInstanceList->clear();
		Surf_Mult_BatchFromInstanceList->clear();
		Surf_Mult_BatchToInstanceList->clear();
		instancesListMenu->clear();
		
		for(i=0; i<=nInstance; i++)
		{
			s1 = s1.setNum(i+1);
			Surf_Mult_SetCurrentInstanceList->insertItem("Instance "+s1,-1);
			Surf_Mult_BatchFromInstanceList->insertItem("Instance "+s1,-1);
			Surf_Mult_BatchToInstanceList->insertItem("Instance "+s1,-1);
			instancesListMenu->insertItem(LIST_MENU_ICONSET,"Instance "+s1,i,-1);
			QPixmap p = instancesListMenu->iconSet(i)->pixmap();
			p.fill(iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getMember(i)->getColor());
			instancesListMenu->iconSet(i)->setPixmap(p,QIconSet::Automatic);
		}
		
		Surf_Mult_DeleteInstance->setEnabled((nInstance > 0));

		Surf_Mult_SetCurrentInstanceList->blockSignals(false);
		Surf_Mult_BatchFromInstanceList->blockSignals(false);
		Surf_Mult_BatchToInstanceList->blockSignals(false);
		instancesListMenu->blockSignals(false);

		cInstance = -1;

	}
	//
	//  update instance lists if current instance changed
	//
	if(cInstance != iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getCurrentMemberIndex())
	{
		cInstance = iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getCurrentMemberIndex();

		CALL_FUNCTION1(Surf_Mult_SetCurrentInstanceList,setCurrentItem,cInstance);
		CALL_FUNCTION1(Surf_Mult_BatchFromInstanceList,setCurrentItem,cInstanceBatchFrom);
		CALL_FUNCTION1(Surf_Mult_BatchToInstanceList,setCurrentItem,cInstanceBatchTo);
		//
		//  A work around of a bug with tearing off the popup menu.
		//
		cInstance = Surf_Mult_SetCurrentInstanceList->currentItem();
		
		CALL_FUNCTION1(Surf_Mult_LCDCurrent,display,cInstance+1);
		CALL_FUNCTION1(Surf_Level_CurrentInstanceLCD,display,cInstance+1);
		unsigned int i;
		instancesListMenu->blockSignals(true);
		for(i=0; i<instancesListMenu->count(); i++)
		{
			instancesListMenu->setItemChecked(i,false);
		}
		instancesListMenu->setItemChecked(cInstance,true);
		instancesListMenu->setActiveItem(cInstance);
		instancesListMenu->blockSignals(false);

	}
	
    iSurface* s = CURRENT_SURFACE;
    int v = s->getVar();
	//
	//  Variable names
	//
	Surf_Level_SurfVar1->setText(CURRENT_LIMITS->getVarName(1));
    Surf_Level_SurfVar2->setText(CURRENT_LIMITS->getVarName(2));
    Surf_Level_SurfVar3->setText(CURRENT_LIMITS->getVarName(3));
	Surf_Paint_PaintVar1->setText(CURRENT_LIMITS->getVarName(1));
    Surf_Paint_PaintVar2->setText(CURRENT_LIMITS->getVarName(2));
    Surf_Paint_PaintVar3->setText(CURRENT_LIMITS->getVarName(3));
	//
	//  Level panel widgets
	//    
	myQT->TabWidgetView->updateSwitchesSurf();

    CALL_FUNCTION1(Surf_Level_SurfBox,setButton,v-1);
	
	float lmin, lmax;
//	iVTKWindow::getCurrentWindow()->getReader()->getLevelLimits(v,lmin,lmax);
//	if(lmin < CURRENT_LIMITS->getVarMin(v)) lmin = CURRENT_LIMITS->getVarMin(v);
//	if(lmax > CURRENT_LIMITS->getVarMax(v)) lmax = CURRENT_LIMITS->getVarMax(v);
	lmin = CURRENT_LIMITS->getVarMin(v);
	lmax = CURRENT_LIMITS->getVarMax(v);
	
    CALL_FUNCTION1(Surf_Level_Level,setMinValue,round(myQT->scaleSlider2*lmin));
    CALL_FUNCTION1(Surf_Level_Level,setMaxValue,round(myQT->scaleSlider2*lmax));
    CALL_FUNCTION1(Surf_Level_Level,setValue,round(myQT->scaleSlider2*s->getLevel()));
    CALL_FUNCTION1(Surf_Level_LevelLCD,display,s->getLevel());
	
    CALL_FUNCTION1(Surf_Level_Opacity,setValue,round(myQT->scaleSlider2*s->getOpacity()));
    CALL_FUNCTION1(Surf_Level_OpacityLCD,display,s->getOpacity());
    
	CALL_FUNCTION1(Surf_Level_FlipNormalsBox,setChecked,s->getNormalsFlipped());
	
    CALL_FUNCTION1(Surf_Level_Decimate,setChecked,s->getDecimation());
    CALL_FUNCTION1(Surf_Level_SmoothingSlider,setValue,s->getSmoothing());
    
    CALL_FUNCTION1(Surf_Level_CurrentInstanceColorLabel,setPaletteBackgroundColor,s->getColor());
	//
	//  Paint panel widgets
	//    
    if(side) 
	{
		CALL_FUNCTION1(Surf_Paint_SideBox,setButton,1);
	}
	else
	{
		CALL_FUNCTION1(Surf_Paint_SideBox,setButton,0); 
	}
    CALL_FUNCTION1(Surf_Paint_PaintWithBox,setButton,s->getVarPaint(side));
    CALL_FUNCTION1(Surf_Paint_PaintFrame,setEnabled,(s->getVarPaint(side)>0));
    
    CALL_FUNCTION1(Surf_Paint_PaletteList,setCurrentItem,s->getPalPaint(side));
    myQT->updatePalettePixmap(iPaletteList::getInstance()->getPalette(s->getPalPaint(side)),&myQT->pixmapPaint);
    CALL_FUNCTION1(Surf_Paint_PalettePixmap,setPixmap,myQT->pixmapPaint);
	//
	//  Material panel widgets
	//    
    f = CURRENT_SURFACE->getDiffuse();
    CALL_FUNCTION1(Surf_Paint_MaterialDiffuseSlider,setValue,round(100.0*f));
    CALL_FUNCTION1(Surf_Paint_MaterialDiffuseLCD,display,(double)f);
    
    f = CURRENT_SURFACE->getAmbient();
    CALL_FUNCTION1(Surf_Paint_MaterialAmbientSlider,setValue,round(100.0*f));
    CALL_FUNCTION1(Surf_Paint_MaterialAmbientLCD,display,(double)f);
    
    f = CURRENT_SURFACE->getSpecular();
    CALL_FUNCTION1(Surf_Paint_MaterialSpecularSlider,setValue,round(100.0*f));
    CALL_FUNCTION1(Surf_Paint_MaterialSpecularLCD,display,(double)f);
    
    f = CURRENT_SURFACE->getSpecularPower();
    CALL_FUNCTION1(Surf_Paint_MaterialSpecularPowerSlider,setValue,round(f));
    CALL_FUNCTION1(Surf_Paint_MaterialSpecularPowerLCD,display,(double)f);
	//
	//  Instances panel widgets
	//  
    CALL_FUNCTION1(Surf_Mult_ColorLabel,setPaletteBackgroundColor,s->getColor());
	
	if(Surf_Mult_BatchFromInstanceList->currentItem()!=Surf_Mult_BatchToInstanceList->currentItem() &&
		iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getMember(Surf_Mult_BatchFromInstanceList->currentItem())->getVar()==iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getMember(Surf_Mult_BatchToInstanceList->currentItem())->getVar())
	{
		CALL_FUNCTION1(Surf_Mult_BatchCreateButton,setEnabled,true);
	} 
	else 
	{
		CALL_FUNCTION1(Surf_Mult_BatchCreateButton,setEnabled,false);
	}

    if(myQT->ext != NULL) myQT->ext->updateWidgets(DISPLAYPAGE_SURF);
    myQT->updateDataChannelComboBox(DISPLAYPAGE_SURF);
    
}


void iQT_Surf::updateSurf_Level_Level( int l )
{
	
    float f = l/myQT->scaleSlider2;
    CALL_FUNCTION1(Surf_Level_LevelLCD,display,f);
    CURRENT_SURFACE->setLevel(f);
    if(myQT->sliderRenderTracking) myQT->render(false);
    
}


void iQT_Surf::updateSurf_Level_Opacity( int o)
{
	
    float f = o/myQT->scaleSlider2;
    CALL_FUNCTION1(Surf_Level_OpacityLCD,display,f);
	
	if(Surf_Main_OpacityLockAll->isChecked())
	{
		int i;
		for(i=0; i<=iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getMaxMemberIndex(); i++) iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getMember(i)->setOpacity(f);
	} 
	else 
	{
		CURRENT_SURFACE->setOpacity(f);
	}
	
    if(myQT->sliderRenderTracking) myQT->render(false);
    
}


void iQT_Surf::updateSurf_Level_SurfVar( int v)
{
    
    v++;
    if(v>=1 && v<=CURRENT_LIMITS->getNvar()) 
	{
		myQT->startTask();
		CURRENT_SURFACE->setVar(v);
		CURRENT_SURFACE->setLevel(CURRENT_SURFACE->getLevel());
		updateSurf_Widgets();
		myQT->render(true);
		myQT->endTask();
	}
	
}


void iQT_Surf::updateSurf_Level_FlipNormals( bool s )
{
	
	myQT->startTask();
	CURRENT_SURFACE->flipNormals(s);
	myQT->render(true);
	myQT->endTask();
	
}


void iQT_Surf::updateSurf_Level_SmoothingSlider( int v )
{
	
    CURRENT_SURFACE->setSmoothing(v);
    if(myQT->sliderRenderTracking) myQT->render(false);    
    
}


void iQT_Surf::updateSurf_Level_Decimate( bool s )
{
	
	myQT->startTask();
    CURRENT_SURFACE->setDecimation(s);
    myQT->render(true);    
	myQT->endTask();
    
}


void iQT_Surf::updateSurf_Paint_PaintWithBox(int v)
{
	
	myQT->startTask();
    CURRENT_SURFACE->setVarPaint(side,v);
    updateSurf_Widgets();
    myQT->render(true);
	myQT->endTask();
    
}


void iQT_Surf::updateSurf_Mult_ColorLabel( ) 
{ 
	
    QColor c = QColorDialog::getColor(); 
	if(c.isValid())
	{
		myQT->startTask();
		CALL_FUNCTION1(Surf_Mult_ColorLabel,setPaletteBackgroundColor,c);
		
		CURRENT_SURFACE->setColor(c);
		QPixmap p = instancesListMenu->iconSet(iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getCurrentMemberIndex())->pixmap();
		p.fill(CURRENT_SURFACE->getColor());
		instancesListMenu->iconSet(iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getCurrentMemberIndex())->setPixmap(p,QIconSet::Automatic);
		
//		updateSurf_Widgets();
		myQT->render(true);
		myQT->endTask();
	}
    
}


void iQT_Surf::updateSurf_Mult_NewInstance()
{
    int i;
    
    i = iVTKWindow::getCurrentWindow()->getSurfaceFamily()->createMember();
    if(i != -1) 
	{
		myQT->startTask();
		iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getMember(i)->copyState(CURRENT_SURFACE);
		iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getMember(i)->setDataChannel(myQT->DataChannelComboBox->currentItem());

		iVTKWindow::getCurrentWindow()->getSurfaceFamily()->setCurrentMemberIndex(i);
        CURRENT_SURFACE->show(myQT->TabWidgetView->View_Surf->isChecked());

		this->updateSurf_Widgets();

		myQT->render(true);
		myQT->endTask();
    
    }
    else Surf_Mult_CreateNewInstance->setEnabled(false);

}


void iQT_Surf::updateSurf_Mult_DeleteInstance()
{
    
    if(iVTKWindow::getCurrentWindow()->getSurfaceFamily()->deleteMember(iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getCurrentMemberIndex())) 
	{
		myQT->startTask();
        CURRENT_SURFACE->show(myQT->TabWidgetView->View_Surf->isChecked());
		updateSurf_Widgets();
		myQT->render(true);
		myQT->endTask();
    } 
	else Surf_Mult_DeleteInstance->setEnabled(false);
    
}


void iQT_Surf::updateSurf_Paint_PalettePixmap(int n)
{
    
    myQT->updatePalettePixmap(iPaletteList::getInstance()->getPalette(n),&myQT->pixmapPaint);
    CALL_FUNCTION1(Surf_Paint_PalettePixmap,setPixmap,myQT->pixmapPaint);
    
}


void iQT_Surf::updateSurf_Paint_PalettePixmapFinal( int n )
{
	
	myQT->startTask();
    updateSurf_Paint_PalettePixmap(n);
    CURRENT_SURFACE->setPalPaint(side,n);
	updateSurf_Widgets(); // this is needed for the colorbars to change colors properly
    myQT->render(true);
	myQT->endTask();
    
}


void iQT_Surf::updateSurf_Paint_SideBox( int v )
{
    
    side = (v > 0);
    updateSurf_Widgets();
	
}


void iQT_Surf::updateSurf_Paint_MaterialAmbientSlider( int n )
{
	
    if(Surf_Paint_MaterialLockAll->isChecked())
	{
		int i;
		for(i=0; i<=iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getMaxMemberIndex(); i++) iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getMember(i)->setAmbient(0.01*n);
    } 
	else CURRENT_SURFACE->setAmbient(0.01*n);
    
    Surf_Paint_MaterialAmbientLCD->display((double)0.01*n);
    if(myQT->sliderRenderTracking) myQT->render(false);
    
}


void iQT_Surf::updateSurf_Paint_MaterialDiffuseSlider( int n )
{
	
    if(Surf_Paint_MaterialLockAll->isChecked())
	{
		int i;
		for(i=0; i<=iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getMaxMemberIndex(); i++) iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getMember(i)->setDiffuse(0.01*n);
    } 
	else CURRENT_SURFACE->setDiffuse(0.01*n);
    
    Surf_Paint_MaterialDiffuseLCD->display((double)0.01*n);
    if(myQT->sliderRenderTracking) myQT->render(false);
    
}


void iQT_Surf::updateSurf_Paint_MaterialSpecularSlider( int n )
{
	
    if(Surf_Paint_MaterialLockAll->isChecked())
	{
		int i;
		for(i=0; i<=iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getMaxMemberIndex(); i++) iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getMember(i)->setSpecular(0.01*n);
    } 
	else CURRENT_SURFACE->setSpecular(0.01*n);
    
    Surf_Paint_MaterialSpecularLCD->display((double)0.01*n);
    if(myQT->sliderRenderTracking) myQT->render(false);
    
}


void iQT_Surf::updateSurf_Paint_MaterialSpecularPower( int n )
{
    
    if(Surf_Paint_MaterialLockAll->isChecked())
	{
		int i;
		for(i=0; i<=iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getMaxMemberIndex(); i++) iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getMember(i)->setSpecularPower((float)n);
    } 
	else CURRENT_SURFACE->setSpecularPower((float)n);
    
    Surf_Paint_MaterialSpecularPowerLCD->display((double)n);
    if(myQT->sliderRenderTracking) myQT->render(false);
    
}


void iQT_Surf::updateSurf_Mult_BatchCreate()
{
    int i, l, lmax;
	QColor c, c1, c2;
	float fmin, fmax, fstp, f;
	float omin, omax, ostp, o;
    
	if(Surf_Mult_BatchFromInstanceList->currentItem()==Surf_Mult_BatchToInstanceList->currentItem() ||
		iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getMember(Surf_Mult_BatchFromInstanceList->currentItem())->getVar()!=iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getMember(Surf_Mult_BatchToInstanceList->currentItem())->getVar())
	{
		Surf_Mult_BatchCreateButton->setEnabled(false);
		return;
	}
	
	lmax = Surf_Mult_BatchNumberBox->value();

	iSurface *smin = iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getMember(Surf_Mult_BatchFromInstanceList->currentItem());
	iSurface *smax = iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getMember(Surf_Mult_BatchToInstanceList->currentItem());

	fmin = smin->getLevel();
	fmax = smax->getLevel();
	fstp = (fmax-fmin)/(lmax+1);
	
	omin = smin->getOpacity();
	omax = smax->getOpacity();
	ostp = (omax-omin)/(lmax+1);
	
	if(fabs(fstp) < 0.01)
	{
		Surf_Mult_BatchCreateButton->setEnabled(false);
		return;
	}
	
	c1 = smin->getColor();
	c2 = smax->getColor();

	myQT->startTask();

	i = 0;
	for(l=0; l<lmax; l++)
	{
		
		f = fmin + fstp*(l+1);
		o = omin + ostp*(l+1);
		c.setRgb(
			round(c1.red()+(float)(c2.red()-c1.red())*(l+1.0)/(lmax+1.0)),
			round(c1.green()+(float)(c2.green()-c1.green())*(l+1.0)/(lmax+1.0)),
			round(c1.blue()+(float)(c2.blue()-c1.blue())*(l+1.0)/(lmax+1.0)));
		
		iSurface *s = iVTKWindow::getCurrentWindow()->getSurfaceFamily()->getMember(i = iVTKWindow::getCurrentWindow()->getSurfaceFamily()->createMember());
		if(s != 0) 
		{
			//
			//  Set the parameters of the new instance
			//
			s->copyState(smin);
			s->setDataChannel(myQT->DataChannelComboBox->currentItem());
			//
			//  Set level, opacity, and color separately since they are different from
			//  the base surface
			//
			s->setLevel(f);
			s->setOpacity(o);
			s->setColor(c);

			iVTKWindow::getCurrentWindow()->getSurfaceFamily()->setCurrentMemberIndex(i);
			CURRENT_SURFACE->show(myQT->TabWidgetView->View_Surf->isChecked());
			
		}
		
	}
	
	updateSurf_Widgets();

    myQT->render(true);
	myQT->endTask();
	
}


void iQT_Surf::launchPaletteEditor()
{
	myQT->launchPaletteEditor(Surf_Paint_PaletteList->currentItem());
}


void iQT_Surf::updateTabPageChanged(QWidget *)
{
	myQT->updateDataChannelComboBox(DISPLAYPAGE_SURF);
}

