/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

#include "ivariablesview.h"

#include <qdragobject.h>


iVariablesView::iVariablesView(QWidget* parent, const char* name, WFlags f) : QListView(parent,name,f)
{
	this->setAcceptDrops(true);
	this->viewport()->setAcceptDrops(true);
}

QDragObject* iVariablesView::dragObject()
{ 
	return new QTextDrag(QString::number((unsigned long)this->currentItem()),this); 
}


void iVariablesView::contentsDragEnterEvent(QDragEnterEvent *event)
{
	event->accept(QTextDrag::canDecode(event));
}


void iVariablesView::contentsDropEvent(QDropEvent* event)
{
	QString text;
	
	if(QTextDrag::decode(event,text)) 
	{
		bool ok;
		QListViewItem *it1, *it0 = (QListViewItem *)text.toULong(&ok);
		if(ok)
		{
			it1 = this->firstChild();
			while(it1!=NULL && it1!=it0) it1 = it1->itemBelow();
		}
		else it1 = NULL;
		QListViewItem *it2 = this->itemAt(contentsToViewport(event->pos()));
		if(it1!=NULL && it2!=NULL)
		{
			//
			//  Are we above or below the center of it2?
			//
			int dy = event->pos().y() - this->itemRect(it2).center().y();

			if(dy < 0)  // put above
			{
				if(it2->itemAbove() != NULL)
				{
					it1->moveItem(it2->itemAbove());
				}
				else
				{
					this->takeItem(it1);
					this->insertItem(it1);
				}
			}
			else
			{
				it1->moveItem(it2);
			}
			this->setCurrentItem(it1);
		}
		emit dropped(event);
		event->accept();
    }
	else event->ignore();
}

