/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename slots use Qt Designer which will
** update this file, preserving your code. Create an init() slot in place of
** a constructor, and a destroy() slot in place of a destructor.
*****************************************************************************/


#include "iparallelizator.h"

#include "imath.h"
#include "iqtdefs.h"

#include <qpixmap.h>


void iDialogParallelController::init()
{

	connect( ClosePushButton, SIGNAL( clicked() ) , this, SLOT( hide() ) );
    
}


void iDialogParallelController::show()
{
    CALL_FUNCTION1(NumProcsSpinBox,setMinValue,iParallelizator::getMinNumberOfProcessors());
    CALL_FUNCTION1(NumProcsSpinBox,setMaxValue,iParallelizator::getMaxNumberOfProcessors());
    CALL_FUNCTION1(NumProcsSpinBox,setValue,iParallelizator::getNumberOfProcessors());
	QDialog::show();
}


void iDialogParallelController::updateNumProcsSpinBox( int n )
{
    iParallelizator::setNumberOfProcessors(n);
}


void iDialogParallelController::updateDisplay()
{
	static QBrush b(SolidPattern);

	int i, j, n, k1, k2, iMin, iMax;
	n = iParallelizator::getNumberOfProcessors();
	
	float *t = new float[n];

	for(i=0; i<n; i++)
	{
		t[i] = iParallelizator::getLastProcessorExecutionTime(i);
	}
	float tWall = iParallelizator::getLastTotalExecutionTime();

	WallTimeLCD->display(tWall);

	float tMax, tMin, imb = 0.0;
	tMax = tMin = t[0];
	iMin = iMax = 0;
	for(i=0; i<n; i++)
	{
		imb += t[i];
		if(t[i] < tMin) { tMin = t[i]; iMin = i; }
		if(t[i] > tMax) { tMax = t[i]; iMax = i; }
	}

	if(tWall > 0.0) imb = 1.0 - imb/(n*tWall); else imb = 0.0;
	LoadImbalanceLCD->display(100.0*imb);

	if(iMin == iMax) iMin = iMax = -1;

	FastProcTimeLCD->display(tMin);
	FastProcPercentLCD->display(100.0*tMin/tWall);

	SlowProcTimeLCD->display(tMax);
	SlowProcPercentLCD->display(100.0*tMax/tWall);

	int w = LoadImbalancePixmap->width();
	int h = LoadImbalancePixmap->height();

	QPixmap p = QPixmap(w,h);
	z.begin(&p);
	z.setBackgroundColor(white);
	z.eraseRect(0,0,w,h);
 
	for(i=0; i<n; i++)
	{
		k1 = round((w*(i+0.1))/n);
		k2 = round((w*(i+0.9))/n);
		if(i == iMin)
		{
			b.setColor(green);
		}
		else if(i == iMax)
		{
			b.setColor(red);
		}
		else
		{
			b.setColor(blue);
		}
		j = round(h*t[i]/tWall);
		z.fillRect(k1,h-j,(k2-k1),j,b);
	}

    z.end();

	LoadImbalancePixmap->setPixmap(p);
	LoadImbalancePixmap->repaint();

}
