/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

#include "iglobals.h"

#include "iqt.h"
#include "ivtk.h"
#include "ivtkwindow.h"
#include "iqtwindow.h"
#include "iqtextension.h"
#include "iqtdefs.h"
#include "iqt_view.h"
#include "iqt_surf.h"
#include "iqt_xsec.h"
#include "iqt_volv.h"
#include "iqt_part.h"
#include "iqt_vect.h"
#include "iqt_tens.h"
#include "iqt_data.h"
#include "iqt_wins.h"

#include "imath.h"
#include "ivtkcallback.h"
#include "idatareader.h"
#include "iprogressbar.h"
#include "ierror.h"

#include <vtkCamera.h>
#include <vtkRenderer.h>

#include <qaction.h>
#include <qapplication.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qwidgetstack.h>
#include <qworkspace.h>


#define I_MAKE_INSTANCE_NEW		0
#define I_MAKE_INSTANCE_CLONE	1
#define I_MAKE_INSTANCE_COPY	2

QPixmap image(char *s);


//
//  Two iQT functions for setting current window from anywhere
//
void iQT::setCurrentWindow(iVTK *w)
{
	int i;

	if(w == 0) return;

	for(i=0; i<=iVTKWindow::getMaxWindowIndex(); i++) if(w == iVTKWindow::getWindow(i))
	{
		TabWidgetView->TabWidgetWins->windows_SetCurrentInstance(i);
		break;
	}
}


void iQT::setCurrentWindow(int w)
{
	TabWidgetView->TabWidgetWins->windows_SetCurrentInstance(w);
}
//
//  iQT_Wins functions
//
void iQT_Wins::init()
{

	myQT = (iQT *)parentWidget()->parentWidget()->parentWidget()->parentWidget()->parentWidget()->parentWidget()->parentWidget()->parentWidget()->parentWidget()->parentWidget();
	if(strcmp(myQT->name(),"iQT") != 0)
	{
		iQTWindow::getCurrentWindow()->popupError("Incorrect parenting in Tab Pages",IFRITERROR_INCORRECT_PARENTING_IN_TABS);
		exit(1);
	}

	iVTKWindow::getCurrentWindow()->setWindowTileButtonGroup(Wins_TileBox); // this sets it for all windows
	Wins_TileBox->setEnabled(iVTKWindow::getMaxWindowIndex()>0);

	CALL_FUNCTION1(Wins_KeepCurrentWindowOnTopCheckBox,setChecked,iVTKWindow::getCurrentWindow()->isAutoRaiseOn());
	CALL_FUNCTION1(Wins_MakeWindowUnderFocusCurrentCheckBox,setChecked,iVTKWindow::getCurrentWindow()->isCurrentWindowUnderFocusOn());
	CALL_FUNCTION1(Wins_SynchronizeInteractorsCheckBox,setChecked,iVTKWindow::getCurrentWindow()->isBroadcastMouseEventsOn());

	pixmapIndiv = image("winindiv.png");
	pixmapClone = image("winclone.png");
	CALL_FUNCTION1(Wins_StatusPixmapLabel,setPixmap,pixmapIndiv);
	CALL_FUNCTION1(Wins_StatusTextLabel,setText,QString("window #0000"));
	int wid = Wins_StatusTextLabel->width();
	CALL_FUNCTION1(Wins_StatusTextLabel,setText,QString("Individual"));
	if(wid < Wins_StatusTextLabel->width()) wid = Wins_StatusTextLabel->width();
	Wins_StatusTextLabel->setMinimumWidth(wid);

}


void iQT_Wins::windows_CreateInstance()
{
	this->windows_MakeInstance(I_MAKE_INSTANCE_NEW);
}


void iQT_Wins::windows_CopyInstance()
{
	this->windows_MakeInstance(I_MAKE_INSTANCE_COPY);
}


void iQT_Wins::windows_CloneInstance()
{
	this->windows_MakeInstance(I_MAKE_INSTANCE_CLONE);
}


void iQT_Wins::windows_MakeInstance(int type)
{
	QString s;
 	int i;

	i = iVTKWindow::createWindow();
	if(i == -1) 
	{
		myQT->popupError("Unable to create a new window.",IFRITERROR_CANNOT_CREATE_WINDOW);
		return;
	}
	//
	//  Place the window in workspace if we are docked
	//
	if(myQT->dockState)
	{
		iVTKWindow::getWindow(i)->reparent(myQT->workspace,0,QPoint(0,0),false);
	}
	//
	//  Copy the state of the window
	//
	iVTKWindow::getWindow(i)->copyState(iVTKWindow::getCurrentWindow());
	//
	//  Set the type of the instance created
	//
	if(type==I_MAKE_INSTANCE_CLONE || type==I_MAKE_INSTANCE_COPY) iVTKWindow::getWindow(i)->becomeClone(iVTKWindow::getCurrentWindow());
	//
	//  To make a copy: make a clone first, and then unclone
	//
	if(type == I_MAKE_INSTANCE_COPY) iVTKWindow::getWindow(i)->becomeClone(0);
	//
	//  update widgets
	//
	s = s.setNum(i+1);
	CALL_FUNCTION2(Wins_SetCurrentInstanceList,insertItem,"Window "+s,-1);
	
	//instancesListMenu->insertItem(LIST_MENU_ICONSET,"Instance "+s,i,-1);
	//QPixmap p = instancesListMenu->iconSet(i)->pixmap();
	//p.fill(myQT->iSurfaceList[i]->getColor());
	//instancesListMenu->iconSet(i)->setPixmap(p,QIconSet::Automatic);
	
	iVTKWindow::getWindow(i)->getStartEventObserver()->setProgressBar(myQT->ProgressBar);
	iVTKWindow::getWindow(i)->getProgressEventObserver()->setProgressBar(myQT->ProgressBar);
	iVTKWindow::getWindow(i)->getEndEventObserver()->setProgressBar(myQT->ProgressBar);
    iVTKWindow::getWindow(i)->getPickEventObserver()->setDialogPick(myQT->Pick);
#ifndef I_VTK_VERSION_40
    iVTKWindow::getWindow(i)->getRecordEventObserver()->setDialogEventRecorder(myQT->EventRecorder);
#endif
	if(myQT->remoteControlled) iVTKWindow::getWindow(i)->getAbortRenderEventObserver()->setProgressDialog(0); else iVTKWindow::getWindow(i)->getAbortRenderEventObserver()->setProgressDialog(myQT->ProgressDialog);
	
    myQT->createVisitedFilesList(i);
	iVTKWindow::getWindow(i)->setImageComposer(myQT->ImageComposer);
	myQT->updateImageComposer(true);

	this->windows_SetCurrentInstance(i);
	if(iVTKWindow::getMaxWindowIndex() == 1)
	{
		Wins_TileBox->setEnabled(true);
		Wins_DeleteInstanceButton->setEnabled(true);
	}

	iVTKWindow::getCurrentWindow()->show();
	myQT->render(false);

}


void iQT_Wins::windows_DeleteInstance()
{
	
    int i, i0 = 0;
    QString s;
    
	//
	//  Delete all clones first
	//
	if(!iVTKWindow::getCurrentWindow()->isClone())
	{
		
		iVTK *w = iVTKWindow::getCurrentWindow();
		iDataReader *r = w->getReader();
		i = 0;
		while(i <= iVTKWindow::getMaxWindowIndex())
		{
			if(r==iVTKWindow::getWindow(i)->getReader() && iVTKWindow::getWindow(i)->isClone()) 
			{
			    myQT->deleteVisitedFilesList(iVTKWindow::getWindow(i)->getId());
				iVTKWindow::deleteWindow(i); 
				CALL_FUNCTION1(Wins_SetCurrentInstanceList,removeItem,iVTKWindow::getMaxWindowIndex()+1);
			}
			else i++;
		}
		
		if(iVTKWindow::getMaxWindowIndex() == 0)
		{
			myQT->popupInfo("It is not allowed to destroy this window: \n it is the only non-cloned one.\n");
			Wins_TileBox->setEnabled(false);
			Wins_DeleteInstanceButton->setEnabled(false);
			myQT->styleDockAction->setEnabled(true);
			return;
		}
		
		for(i=0; i<=iVTKWindow::getMaxWindowIndex(); i++) if(iVTKWindow::getWindow(i) == w) i0 = i;
	}
	else i0 = iVTKWindow::getCurrentWindowIndex();

	int id = iVTKWindow::getWindow(i0)->getId();

	if(iVTKWindow::deleteWindow(i0))
	{
		
		CALL_FUNCTION1(Wins_SetCurrentInstanceList,removeItem,iVTKWindow::getMaxWindowIndex()+1);
		
		if(iVTKWindow::getMaxWindowIndex() == 0) 
		{
			Wins_TileBox->setEnabled(false);
			Wins_DeleteInstanceButton->setEnabled(false);
		}
		CALL_FUNCTION1(Wins_TileBox,setButton,0);
		
		//instancesListMenu->removeItem(i-1);
		
		this->windows_SetCurrentInstance(iVTKWindow::getCurrentWindowIndex());

		int bt = iVTKWindow::getCurrentWindow()->getBoxType();
		iVTKWindow::getCurrentWindow()->setBoxType((bt==3)?0:3);
		iVTKWindow::getCurrentWindow()->render(false);
		iVTKWindow::getCurrentWindow()->setBoxType(bt);
		iVTKWindow::getCurrentWindow()->render(false);
		
	    myQT->deleteVisitedFilesList(id);
		myQT->updateImageComposer(true);

	}
	
}


void iQT_Wins::windows_SetCurrentInstance(int i)
{
	static bool clonePixmap = false;
    int j;

	j = iVTKWindow::getCurrentWindowIndex();
	iVTKWindow::setCurrentWindowIndex(i);
	//
	//  If docked and the old current window was maximized, maximize this one
	//
	if(myQT->dockState && iVTKWindow::getWindow(j)->isMaximized())
	{
		iVTKWindow::getCurrentWindow()->raise();
		iVTKWindow::getCurrentWindow()->showMaximized();
	}
	//
	//  Set markers for all windows
	//
	int cloneOf = -1;
	iDataReader *r = iVTKWindow::getCurrentWindow()->getReader();
	bool c = iVTKWindow::getCurrentWindow()->isClone();
	iVTKWindow::getCurrentWindow()->showIcon(I_ICON_FULL);
	iVTKWindow::getCurrentWindow()->render(false);
	for(j=0; j<=iVTKWindow::getMaxWindowIndex(); j++) if(j != i)
	{
		if(c && !iVTKWindow::getWindow(j)->isClone() && iVTKWindow::getWindow(j)->getReader()==r) cloneOf = j; 
		if(!c && iVTKWindow::getWindow(j)->isClone() && iVTKWindow::getWindow(j)->getReader()==r) iVTKWindow::getWindow(j)->showIcon(I_ICON_CLONE); else iVTKWindow::getWindow(j)->showIcon(I_ICON_NONE); 
		iVTKWindow::getWindow(j)->render(false);
	}

	QString s;
	if(cloneOf==-1 && clonePixmap)
	{
		clonePixmap = false;
		s = "Individual";
		CALL_FUNCTION1(Wins_StatusTextLabel,setText,s);
		CALL_FUNCTION1(Wins_StatusPixmapLabel,setPixmap,pixmapIndiv);
	}

	if(cloneOf != -1)
	{
		s = s.setNum(cloneOf+1);
		s = "Clone of \nwindow #" + s;
		CALL_FUNCTION1(Wins_StatusTextLabel,setText,s);
		if(!clonePixmap)
		{
			CALL_FUNCTION1(Wins_StatusPixmapLabel,setPixmap,pixmapClone);
			clonePixmap = true;
		}
	}

	CALL_FUNCTION1(Wins_SetCurrentInstanceList,setCurrentItem,i);
	//
	//  Update Open File actions
	//
	if(iVTKWindow::getCurrentWindow()->isClone())
	{
		myQT->fileOpenMeshAction->setEnabled(false);
		myQT->fileOpenPartAction->setEnabled(false);
		myQT->fileOpenVectAction->setEnabled(false);
		myQT->fileOpenTensAction->setEnabled(false);
		myQT->fileOpenSetAction->setEnabled(false);
		myQT->Button_LoadNextSet->setEnabled(false);
		myQT->Button_Animate->setEnabled(false);
		if(myQT->ext != NULL) myQT->ext->fileOpenAction->setEnabled(false);
		myQT->TabWidgetPart->TabWidget_Advan->setTabEnabled(myQT->TabWidgetPart->TabWidget_Advan->page(0),false);
	}
	else
	{
		myQT->fileOpenMeshAction->setEnabled(true);
		myQT->fileOpenPartAction->setEnabled(true);
		myQT->fileOpenVectAction->setEnabled(true);
		myQT->fileOpenTensAction->setEnabled(true);
		myQT->fileOpenSetAction->setEnabled(iVTKWindow::getCurrentWindow()->getReader()->isSet());
		myQT->Button_LoadNextSet->setEnabled(iVTKWindow::getCurrentWindow()->getReader()->isFileAnimatable());
		myQT->Button_Animate->setEnabled(iVTKWindow::getCurrentWindow()->getReader()->isFileAnimatable());
		if(myQT->ext != NULL) myQT->ext->fileOpenAction->setEnabled(true);
		myQT->TabWidgetPart->TabWidget_Advan->setTabEnabled(myQT->TabWidgetPart->TabWidget_Advan->page(0),true);
	}

    myQT->updateWidgets(-1);
	myQT->updateVariablesExplorer();
//	myQT->updateImageComposer(false);

	//
	//  Replace the visited file list
	//
	myQT->updateVisitedFilesList(true);

}


void iQT_Wins::windows_KeepCurrentWindowOnTop(bool s)
{
	iVTKWindow::getCurrentWindow()->setAutoRaiseOn(s);
}


void iQT_Wins::windows_MakeWindowUnderFocusCurrent(bool s)
{
	iVTKWindow::getCurrentWindow()->setCurrentWindowUnderFocusOn(s);
}


void iQT_Wins::windows_SynchronizeInteractors(bool s)
{
	iVTKWindow::getCurrentWindow()->setBroadcastMouseEventsOn(s);
}


void iQT_Wins::windows_SynchronizeCameras()
{
	int i;
	vtkCamera *c = iVTKWindow::getCurrentWindow()->getRenderer()->GetActiveCamera();
	double *fp = c->GetFocalPoint();
	double *cp = c->GetPosition();
	double *vu = c->GetViewUp();
	double ps = c->GetParallelScale();
	for(i=0; i<=iVTKWindow::getMaxWindowIndex(); i++)
	{
		c = iVTKWindow::getWindow(i)->getRenderer()->GetActiveCamera();
		c->SetFocalPoint(fp);
		c->SetPosition(cp);
		c->SetViewUp(vu);
		c->SetParallelScale(ps);
	}
	myQT->render(true,true);
}


void iQT_Wins::windows_RaiseCurrentWindow()
{
	iVTKWindow::getCurrentWindow()->raise();
}


void iQT_Wins::windows_SetTiling(int m)
{
	int i, j, k;
	int w, h, wd, hd;

	if(m == 0) return;

	int desktopWidth;
	int desktopHeight;

	if(myQT->dockState)
	{
		desktopWidth = myQT->workspace->width();
		desktopHeight = myQT->workspace->height();
	}
	else
	{
		desktopWidth = qApp->desktop()->width();
		desktopHeight = qApp->desktop()->height();
	}

	QRect fg = iVTKWindow::getCurrentWindow()->frameGeometry();
	QRect wg = iVTKWindow::getCurrentWindow()->geometry();
	QPoint pos = iVTKWindow::getCurrentWindow()->pos();

	switch (m)
	{
	case 1:
		{
			wd = round(floor((float)desktopWidth/(iVTKWindow::getMaxWindowIndex()+1)));
			w = wd + wg.width() - fg.width();
			h = round((float)wg.height()*w/wg.width());
			if(w < iVTKWindow::getCurrentWindow()->minimumWidth())
			{
				//
				//  Cannot tile - window would be too small
				//
				CALL_FUNCTION1(Wins_TileBox,setButton,0);
				return;
			}

			iVTKWindow::getWindow(0)->setWindowTileButtonGroup(0);
			for(k=0; k<=iVTKWindow::getMaxWindowIndex(); k++)
			{
				if(myQT->dockState)
				{
					iVTKWindow::getWindow(k)->parentWidget()->resize(w,h);
					iVTKWindow::getWindow(k)->parentWidget()->move(k*wd,pos.y());
				}
				else
				{
					iVTKWindow::getWindow(k)->resize(w,h);
					iVTKWindow::getWindow(k)->move(k*wd,pos.y());
				}
			}
			iVTKWindow::getWindow(0)->setWindowTileButtonGroup(Wins_TileBox);
			break;
		}
	case 2:
		{
			hd = round(floor((float)desktopHeight/(iVTKWindow::getMaxWindowIndex()+1)));
			h = hd + wg.height() - fg.height();
			w = round((float)wg.width()*h/wg.height());
			if(h < iVTKWindow::getCurrentWindow()->minimumHeight())
			{
				//
				//  Cannot tile - window would be too small
				//
				CALL_FUNCTION1(Wins_TileBox,setButton,0);
				return;
			}

			iVTKWindow::getWindow(0)->setWindowTileButtonGroup(0);
			for(k=0; k<=iVTKWindow::getMaxWindowIndex(); k++)
			{
				if(myQT->dockState)
				{
					iVTKWindow::getWindow(k)->parentWidget()->resize(w,h);
					iVTKWindow::getWindow(k)->parentWidget()->move(pos.x(),k*hd);
				}
				else
				{
					iVTKWindow::getWindow(k)->resize(w,h);
					iVTKWindow::getWindow(k)->move(pos.x(),k*hd);
				}
			}
			iVTKWindow::getWindow(0)->setWindowTileButtonGroup(Wins_TileBox);
			break;
		}
	case 3:
		{
			int n1 = (int)sqrt(1.0+iVTKWindow::getMaxWindowIndex());
			int n2 = n1;
			if(n1 <= 0) return;
			while(n1*n2 <= iVTKWindow::getMaxWindowIndex()) n2++;
			hd = round(floor((float)desktopHeight/n2));
			wd = round(floor((float)desktopWidth/n2));
			w = wd + wg.width() - fg.width();
			h = hd + wg.height() - fg.height();
			if(w<iVTKWindow::getCurrentWindow()->minimumWidth() || h<iVTKWindow::getCurrentWindow()->minimumHeight())
			{
				//
				//  Cannot tile - window would be too small
				//
				CALL_FUNCTION1(Wins_TileBox,setButton,0);
				return;
			}

			k = 0;
			iVTKWindow::getWindow(0)->setWindowTileButtonGroup(0);
			for(i=0; i<n2; i++)
				for(j=0; j<n2; j++)
				{
					if(k <= iVTKWindow::getMaxWindowIndex())
					{
						if(myQT->dockState)
						{
							iVTKWindow::getWindow(k)->parentWidget()->resize(w,h);
							iVTKWindow::getWindow(k)->parentWidget()->move(i*wd,j*hd);
						}
						else
						{
							iVTKWindow::getWindow(k)->resize(w,h);
							iVTKWindow::getWindow(k)->move(i*wd,j*hd);
						}
						k++;
					}
				}
			iVTKWindow::getWindow(0)->setWindowTileButtonGroup(Wins_TileBox);
			break;
		}
	default: return;
	}

}


