/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

/*
Header file for classes that support GUI data structures. They are 
created to minimize interaction berween GUI and VTK. 
*/

#ifndef ISURFACE_H
#define ISURFACE_H

class vtkPolyData;
class vtkPolyDataNormals;
class vtkPolyDataMapper;
class vtkLODActor;
class vtkActor;
class vtkProperty;
class vtkQuadricDecimation;
class vtkQuadricClustering;
class vtkWindowedSincPolyDataFilter;
class vtkCleanPolyData;
class vtkReverseSense;

class iProbeFilter;
class iUniformMeshDataConverter;
class iSurfaceShifter;
class iPolygonalDataExtender;
class iContourFilter;
class iDecimator;


#include "icolor.h"
#include "ivisualobject.h"


class iSurface : public iVisualObject
{
	
	friend class iObjectFactory;

public:
	
	static iSurface* New(iVTK *m = 0);
	virtual ~iSurface();
	
	inline int getVar(){ return var; }
	inline float getLevel(){ return lev; }
	inline float getOpacity(){ return opa; }
	inline int getVarPaint(bool s){ return varpaint[(int)s]; }
	inline iColor getColor(){ return color; }
	inline int getPalPaint(bool s){ return palpaint[(int)s]; }
	inline int getSmoothing(){ return smooth; }
	inline bool getDecimation(){ return decimate; }
	inline bool getNormalsFlipped(){ return normalsFlipped; }
	inline bool getGeometricNormals(){ return postNormals; }
	
	inline vtkLODActor* getSurface(int i=0){ if(i==0) return surfaceActor[0]; else return surfaceActor[1]; }
	inline vtkPolyDataMapper* getMapper(int i=0){ if(i==0) return surfaceMapper[0]; else return surfaceMapper[1]; }
	inline iPolygonalDataExtender* getExtender(int i=0){ if(i==0) return surfaceExtender[0]; else return surfaceExtender[1]; }
	
	virtual void setVar(int v);
	virtual void setLevel(float l);
	virtual void setOpacity(float o);
	virtual void setVarPaint(bool s, int v);
	virtual void setColor(iColor c);
	virtual void setPalPaint(bool s, int p);
	virtual void setSmoothing(int v);
	virtual void setDecimation(bool s);
	virtual void setGeometricNormals(bool s);
	
	virtual void setAmbient(float v);
	virtual void setDiffuse(float v);
	virtual void setSpecular(float v);
	virtual void setSpecularPower(float v);
	
	virtual void flipNormals(bool s);
	virtual void showClipPlane(bool s);
	virtual void showColorBars(bool s);

	virtual void show(bool s);
	virtual void reset();
	
	virtual void packState(iString &s);
	virtual void unpackState(iString s);

	virtual float getMemorySize();

protected:
	
	iSurface(iVTK *m = 0);
	virtual void updatePipeline();

	int var;
	float lev;
	float opa;
	int varpaint[2];
	iColor color;
	int palpaint[2];
	
	bool postNormals;
	bool decimate;
	bool normalsFlipped;
	int smooth;
	//
	//  VTK stuff
	//
	iContourFilter *surfaceSource;
	iUniformMeshDataConverter *surfaceDataConverter;
	iSurfaceShifter *surfaceShifter;
	iPolygonalDataExtender *surfaceExtender[2];
	iUniformMeshDataConverter *surfaceDataConverterPaint[2];
	iDecimator *surfaceReducer[2];
	iProbeFilter *surfaceProbe[2];

	vtkProperty *surfaceProperty;
	vtkPolyDataNormals *surfaceNormals[2];
	vtkLODActor *surfaceActor[2];	
	vtkPolyDataMapper *surfaceMapper[2];
	vtkWindowedSincPolyDataFilter *surfaceSmoother[2];
	vtkCleanPolyData *surfaceCleaner[2];
	vtkReverseSense *surfaceNormalsFlipper[2];

};

#endif // ISURFACE_H

