/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

#include <qglobal.h>

#ifdef _WIN32

#include <vtkProp.h>
#include <vtkPropCollection.h>
#include <vtkViewport.h>
#include <vtkCubeAxesActor2D.h>
#include <vtkAbstractPropPicker.h>

void vtkViewport::RemovePropW(vtkProp *p)
{
  if (p)
    {
    p->ReleaseGraphicsResources(this->VTKWindow);
    this->Props->RemoveItem(p);
    }
}

void vtkCubeAxesActor2D::SetPropW(vtkProp *p)
{                                             
//vtkCxxSetObjectMacro(vtkCubeAxesActor2D,Prop, vtkProp);
	vtkSetObjectBodyMacro(Prop,vtkProp,p);        
}


vtkProp* vtkAbstractPropPicker::GetPropW()
{                                             
	return this->GetProp();        
}


#else

#if defined(VTKDLL) && VTK_MAJOR_VERSION==4 && VTK_MINOR_VERSION==2 && VTK_MAJOR_VERSION == 4 && VTK_BUILD_VERSION<2

#include <vtkVolumeMapper.h>
#include <vtkImageData.h>

void vtkVolumeMapper::SetInput( vtkImageData *input )
{
	this->vtkProcessObject::SetNthInput(0, input );
}

#endif

#endif


#if (QT_VERSION == 0x030200)

#include <qspinbox.h>
#include <qapplication.h>
#include <qlineedit.h>

bool QSpinBox::eventFilter( QObject* o, QEvent* ev )
{
    if (o != vi)
	return QWidget::eventFilter(o,ev);

    if ( ev->type() == QEvent::KeyPress ) {
	QKeyEvent* k = (QKeyEvent*)ev;

	bool retval = FALSE; // workaround for MSVC++ optimization bug
	if( (k->key() == Key_Tab) || (k->key() == Key_BackTab) ){
	    if ( k->state() & Qt::ControlButton )
		return FALSE;
	    if ( edited )
		interpretText();
	    qApp->sendEvent( this, ev );
	    retval = TRUE;
	} if ( k->key() == Key_Up ) {
	    stepUp();
	    retval = TRUE;
	} else if ( k->key() == Key_Down ) {
	    stepDown();
	    retval = TRUE;
	} else if ( k->key() == Key_Enter || k->key() == Key_Return ) {
	    interpretText();
	    return FALSE;
	}
	if ( retval )
	    return retval;
    } else if ( ev->type() == QEvent::FocusOut || ev->type() == QEvent::Leave || ev->type() == QEvent::Hide ) {
	if ( edited ) {
	    interpretText();
	}
	return FALSE;
    }
    return FALSE;
}

#endif
