/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

//
//  Some useful global functions
//
#include "iglobals.h"

#ifdef _WIN32
  #include <windows.h>
  #include <winbase.h>
#else
  #include <sys/time.h>
  #include <sys/resource.h>
  #include <unistd.h>
#endif

#include <qapplication.h>
#include <qdatetime.h>
#include <qpixmap.h>
#include <qmime.h>
#include <qdragobject.h>
#include <qbitmap.h>
#include <qmessagebox.h>

#include "iqt.h"
#include "ivtk.h"
#include "iqtwindow.h"
#include "ienvironment.h"

int errorCode = 0;

//
//  Sleeps for a given # of milliseconds
//
void iSleep(int msec)
{
	if(msec == 0) return;

	QTime t;
	t.start();
	while(t.elapsed() < msec);
}

//
//  Gives the physical memory for the machine
//
#define __MB	(float)1048576.0
float iMemLimit()
{
#ifdef _WIN32
	MEMORYSTATUS r;
	::GlobalMemoryStatus(&r);
	return (float)r.dwTotalPhys/__MB;
#else
	static struct rlimit r;
	int d = getrlimit(RLIMIT_DATA,&r);
	float v1 = (float)r.rlim_cur/__MB;
#if defined(_SC_PHYS_PAGES) && defined(_SC_PAGESIZE)
	unsigned long np = sysconf(_SC_PHYS_PAGES);
	unsigned long ps = sysconf(_SC_PAGESIZE);
	float v2 = (float)np*(float)ps/__MB;
	if(v1 > v2) v1 = v2;
#endif
	if(d == 0) return v1; else return -1.0;
#endif
}


void reportNullPointer(int ec)
{
	
	errorCode = ec;

	QString s = "A fatal error #" + QString::number(errorCode) + " has occured:\n IFRIT will try to save the current state.";
	if(iQTWindow::getCurrentWindow()->isVisible()) QMessageBox::critical(qApp->desktop(), "IFRIT",s);
	cerr << s << "\n";

	iQTWindow::getCurrentWindow()->optionsSave();
	
}


QPixmap image(char *s)
{
    const QMimeSource *m = QMimeSourceFactory::defaultFactory()->data(QString(s));
    if ( !m ) return QPixmap();
    QPixmap p;
    QImageDrag::decode(m,p);
    p.setMask(p.createHeuristicMask());
    return p;
}

