/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2003 Nick Gnedin 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Nick Gnedin nor the names of any contributors may be used 
   to endorse or promote products derived from this software without specific
   prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/

#include "iqt.h"
#include "ivtk.h"
#include "ivtkwindow.h"
#include "iqtwindow.h"
#include "iqtextension.h"

#include "iqtdefs.h"
#include "iqt_xsec.h"
#include "iqt_view.h"
#include "ilimits.h"
#include "ipalette.h"
#include "ierror.h"
#include "imath.h"
#include "ixsection.h"
#include "iorthoslicer.h"
#include "idatareader.h"

#include <qaction.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qcursor.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlcdnumber.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qslider.h>
#include <qspinbox.h>
#include <qtabwidget.h>

#include <vtkRenderer.h>


#define CURRENT_LIMITS	iVTKWindow::getCurrentWindow()->getReader()->getLimits(CURRENT_XSECTION->getDataChannel())


//
// *********************************************************************************
//
//  
//   Cross-section panel widgets
//
//
// *********************************************************************************
//
void iQT_Xsec::init()
{

	myQT = (iQT *)parentWidget()->parentWidget()->parentWidget()->parentWidget()->parentWidget()->parentWidget();
	if(strcmp(myQT->name(),"iQT") != 0)
	{
		iQTWindow::getCurrentWindow()->popupError("Incorrect parenting in Tab Pages",IFRITERROR_INCORRECT_PARENTING_IN_TABS);
		exit(1);
	}

	//
	//  Define the popup menu
	//
	instancesListMenu = new QPopupMenu((QWidget *)TabWidget);
	instancesListMenu->setCheckable(true);
	instancesListMenu->insertTearOffHandle();
	instancesListMenu->insertItem("Instance 1",0,-1);
	instancesListMenu->setItemChecked(0,true);
	connect(instancesListMenu, SIGNAL( activated(int) ) ,this, SLOT( setCurrentInstance(int) ) );
	//
	//  Make sliders look better
	//
	LayoutXsecField->setStretchFactor(LayoutXsecFieldLeft,3);
	LayoutXsecField->addStretch(1);
	
	LayoutXsecMaterial->setStretchFactor(Xsec_Paint_MaterialGroupBox,3);
	LayoutXsecMaterial->addStretch(1);
	
}


void iQT_Xsec::destroy()
{
	
	delete instancesListMenu;
	
}


void iQT_Xsec::mousePressEvent( QMouseEvent * e )
{

	if(e->button() == Qt::RightButton)
	{
		instancesListMenu->exec(QCursor::pos());
	}
	
}


void iQT_Xsec::setCurrentInstance(int n)
{

    iVTKWindow::getCurrentWindow()->getXsectionFamily()->setCurrentMemberIndex(n);
	this->updateXsec_Widgets();	

}


void iQT_Xsec::doRender()
{
	myQT->doRender();
}


void iQT_Xsec::updateXsec_Widgets()
{
	static int nInstance = -1;
	static int cInstance = -1;
	static iVTK *myVTK = 0;
	int i;
	QString s1;
    float f;
    
	//
	//  update instance lists if VTK or the # of instances changed
	//
	if(iVTKWindow::getCurrentWindow()!=myVTK || nInstance!=iVTKWindow::getCurrentWindow()->getXsectionFamily()->getMaxMemberIndex())
	{
		myVTK = iVTKWindow::getCurrentWindow();
		nInstance = iVTKWindow::getCurrentWindow()->getXsectionFamily()->getMaxMemberIndex();

		Xsec_Mult_SetCurrentInstanceList->blockSignals(true);
		instancesListMenu->blockSignals(true);

		Xsec_Mult_SetCurrentInstanceList->clear();
		instancesListMenu->clear();
		
		for(i=0; i<=nInstance; i++)
		{
			s1 = s1.setNum(i+1);
			Xsec_Mult_SetCurrentInstanceList->insertItem("Instance "+s1,-1);
			instancesListMenu->insertItem("Instance "+s1,i,-1);
		}
		
		Xsec_Mult_DeleteInstance->setEnabled((nInstance > 0));

		Xsec_Mult_SetCurrentInstanceList->blockSignals(false);
		instancesListMenu->blockSignals(false);

		cInstance = -1;

	}
	//
	//  update instance lists if current instance changed
	//
	if(cInstance != iVTKWindow::getCurrentWindow()->getXsectionFamily()->getCurrentMemberIndex())
	{
		cInstance = iVTKWindow::getCurrentWindow()->getXsectionFamily()->getCurrentMemberIndex();

		CALL_FUNCTION1(Xsec_Mult_SetCurrentInstanceList,setCurrentItem,cInstance);
		//
		//  A work around of a bug with tearing off the popup menu.
		//
		cInstance = Xsec_Mult_SetCurrentInstanceList->currentItem();
		
		CALL_FUNCTION1(Xsec_Mult_LCDCurrent,display,cInstance+1);
		CALL_FUNCTION1(Xsec_Field_CurrentInstanceLCD,display,cInstance+1);
		unsigned int i;
		instancesListMenu->blockSignals(true);
		for(i=0; i<instancesListMenu->count(); i++)
		{
			instancesListMenu->setItemChecked(i,false);
		}
		instancesListMenu->setItemChecked(cInstance,true);
		instancesListMenu->setActiveItem(cInstance);
		instancesListMenu->blockSignals(false);
	}
	
    iXsection* s = CURRENT_XSECTION;
	//
	//  Variable names
	//
	Xsec_Field_FieldVar1->setText(CURRENT_LIMITS->getVarName(1));
    Xsec_Field_FieldVar2->setText(CURRENT_LIMITS->getVarName(2));
    Xsec_Field_FieldVar3->setText(CURRENT_LIMITS->getVarName(3));
	//
	//  Field panel widgets
	//    
	myQT->TabWidgetView->updateSwitchesXsec();

    CALL_FUNCTION1(Xsec_Field_DirBox,setButton,s->getDir()-1); 
    CALL_FUNCTION1(Xsec_Field_FieldBox,setButton,s->getVar()-1);
    
	CALL_FUNCTION1(Xsec_Field_MethodBox,setButton,s->getMode());
	CALL_FUNCTION1(Xsec_Field_InterpolateDataCheckBox,setChecked,s->getInterpolateData());
	this->updateCoordinateDisplays();
	//
	//  Paint panel widgets
	//    
    CALL_FUNCTION1(Xsec_Field_PaletteList,setCurrentItem,s->getPal());
    myQT->updatePalettePixmap(iPaletteList::getInstance()->getPalette(s->getPal()),&myQT->pixmapPaint);
    CALL_FUNCTION1(Xsec_Field_PalettePixmap,setPixmap,myQT->pixmapPaint);
	//
	//  Material panel widgets
	//    
    f = CURRENT_XSECTION->getDiffuse();
    CALL_FUNCTION1(Xsec_Paint_MaterialDiffuseSlider,setValue,round(100.0*f));
    CALL_FUNCTION1(Xsec_Paint_MaterialDiffuseLCD,display,(double)f);
    
    f = CURRENT_XSECTION->getAmbient();
    CALL_FUNCTION1(Xsec_Paint_MaterialAmbientSlider,setValue,round(100.0*f));
    CALL_FUNCTION1(Xsec_Paint_MaterialAmbientLCD,display,(double)f);
    
    f = CURRENT_XSECTION->getSpecular();
    CALL_FUNCTION1(Xsec_Paint_MaterialSpecularSlider,setValue,round(100.0*f));
    CALL_FUNCTION1(Xsec_Paint_MaterialSpecularLCD,display,(double)f);
    
    f = CURRENT_XSECTION->getSpecularPower();
    CALL_FUNCTION1(Xsec_Paint_MaterialSpecularPowerSlider,setValue,round(f));
    CALL_FUNCTION1(Xsec_Paint_MaterialSpecularPowerLCD,display,(double)f);
	//
	//  Instances panel widgets
	// 

    if(myQT->ext != NULL) myQT->ext->updateWidgets(DISPLAYPAGE_XSEC);
    myQT->updateDataChannelComboBox(DISPLAYPAGE_XSEC);

}


void iQT_Xsec::updateCoordinateDisplays()
{
	double x = CURRENT_XSECTION->getPos();
    CALL_FUNCTION1(Xsec_Field_PosSlider,setMinValue,round(myQT->scaleSlider2*(-1.0)));
    CALL_FUNCTION1(Xsec_Field_PosSlider,setMaxValue,round(myQT->scaleSlider2*1.0));
    CALL_FUNCTION1(Xsec_Field_PosSlider,setValue,round(myQT->scaleSlider2*x));
    Xsec_Field_PosLCD->display(iVTKWindow::getCurrentWindow()->transformToExternalCoordinate(x));
}


void iQT_Xsec::updateXsec_Field_PosSlider(int l)
{
	
    double f = l/myQT->scaleSlider2;
	CALL_FUNCTION1(Xsec_Field_PosLCD,setNumDigits,5);
	if(Xsec_Field_PosLCD->checkOverflow(f)) f = 0.0;
    bool r = CURRENT_XSECTION->setPos(f);
    Xsec_Field_PosLCD->display(iVTKWindow::getCurrentWindow()->transformToExternalCoordinate(f));
    if(r)
	{
		double fm = CURRENT_XSECTION->getPos();
		CALL_FUNCTION1(Xsec_Field_PosSlider,setValue,round(myQT->scaleSlider2*fm));
		Xsec_Field_PosLCD->display(iVTKWindow::getCurrentWindow()->transformToExternalCoordinate(fm));
    }
	bool q = myQT->reportMemory;
	myQT->reportMemory = false;
	if(Xsec_Field_PosResample->isChecked())
	{
		int estimatedResampleFactor = round(CURRENT_XSECTION->getSlicer()->GetResampleFactor()*myQT->TabWidgetView->View_DesiredFrameRateSlider->value()*iVTKWindow::getCurrentWindow()->getRenderer()->GetLastRenderTimeInSeconds());
		if(estimatedResampleFactor < 1) estimatedResampleFactor = 1;
		CURRENT_XSECTION->getSlicer()->SetResampleFactor(estimatedResampleFactor);
	}
	myQT->render(false);
	myQT->reportMemory = q;
    
}


void iQT_Xsec::updateXsec_Field_PosSliderFinal()
{
	
	CURRENT_XSECTION->getSlicer()->SetResampleFactor(1);
	myQT->render(false);
    
}


void iQT_Xsec::updateXsec_Field_FieldBox(int v)
{
	
    v++;
    if(v>=1 && v<=CURRENT_LIMITS->getNvar()) 
	{
		myQT->startTask();
		CURRENT_XSECTION->setVar(v);
		updateXsec_Widgets(); // needed for the colorbars
		myQT->render(true);
		myQT->endTask();
    }
    
}


void iQT_Xsec::updateXsec_Field_DirBox(int d)
{
	
    d++;
    if(d>=1 && d<=3 && d!=CURRENT_XSECTION->getDir()) 
	{
		myQT->startTask();
		CURRENT_XSECTION->setDir(d);
		myQT->render(true);
		myQT->endTask();
	}
    
}


void iQT_Xsec::updateXsec_Field_MethodBox(int m)
{

    if(m != CURRENT_XSECTION->getMode()) 
	{
		myQT->startTask();
		CURRENT_XSECTION->setMode(m);
		myQT->render(true);
		myQT->endTask();
	}
    
}


void iQT_Xsec::updateXsec_Field_InterpolateDataCheckBox(bool s)
{

	myQT->startTask();
	CURRENT_XSECTION->setInterpolateData(s);
	myQT->render(true);
	myQT->endTask();
    
}


void iQT_Xsec::updateXsec_Mult_NewInstance()
{
    int i;
    QString s;
    
    i = iVTKWindow::getCurrentWindow()->getXsectionFamily()->createMember();
    if(i != -1) 
	{
		myQT->startTask();
		iVTKWindow::getCurrentWindow()->getXsectionFamily()->getMember(i)->copyState(CURRENT_XSECTION);
		iVTKWindow::getCurrentWindow()->getXsectionFamily()->getMember(i)->setDataChannel(myQT->DataChannelComboBox->currentItem());
		//
		//  update widgets
		//
		iVTKWindow::getCurrentWindow()->getXsectionFamily()->setCurrentMemberIndex(i);
        CURRENT_XSECTION->show(myQT->TabWidgetView->View_Xsec->isChecked());

		updateXsec_Widgets();

		myQT->render(true);
		myQT->endTask();

    }
    else Xsec_Mult_CreateNewInstance->setEnabled(false);
    
}


void iQT_Xsec::updateXsec_Mult_DeleteInstance()
{
    
    if(iVTKWindow::getCurrentWindow()->getXsectionFamily()->deleteMember(iVTKWindow::getCurrentWindow()->getXsectionFamily()->getCurrentMemberIndex()))
	{
		myQT->startTask();
        CURRENT_XSECTION->show(myQT->TabWidgetView->View_Xsec->isChecked());
		updateXsec_Widgets();
		myQT->render(true);
		myQT->endTask();
    } 
	else Xsec_Mult_DeleteInstance->setEnabled(false);
    
}


void iQT_Xsec::updateXsec_Field_PalettePixmap(int n)
{
    
    myQT->updatePalettePixmap(iPaletteList::getInstance()->getPalette(n),&myQT->pixmapPaint);
    Xsec_Field_PalettePixmap->setPixmap(myQT->pixmapPaint);
	
}


void iQT_Xsec::updateXsec_Field_PalettePixmapFinal( int n )
{
	
	myQT->startTask();
    updateXsec_Field_PalettePixmap(n);
    CURRENT_XSECTION->setPal(n);
	updateXsec_Widgets(); // this is needed for the colorbars to change colors properly
    myQT->render(true);
	myQT->endTask();
	
}


void iQT_Xsec::updateXsec_Paint_MaterialAmbientSlider( int n )
{
	
    if(Xsec_Paint_MaterialLockAll->isChecked())
	{
		int i;
		for(i=0; i<=iVTKWindow::getCurrentWindow()->getXsectionFamily()->getMaxMemberIndex(); i++) iVTKWindow::getCurrentWindow()->getXsectionFamily()->getMember(i)->setAmbient(0.01*n);
    } 
	else CURRENT_XSECTION->setAmbient(0.01*n);
    Xsec_Paint_MaterialAmbientLCD->display((double)0.01*n);
    if(myQT->sliderRenderTracking) myQT->render(false);
    
}


void iQT_Xsec::updateXsec_Paint_MaterialDiffuseSlider( int n )
{
	
    if(Xsec_Paint_MaterialLockAll->isChecked())
	{
		int i;
		for(i=0; i<=iVTKWindow::getCurrentWindow()->getXsectionFamily()->getMaxMemberIndex(); i++) iVTKWindow::getCurrentWindow()->getXsectionFamily()->getMember(i)->setDiffuse(0.01*n);
    } 
	else CURRENT_XSECTION->setDiffuse(0.01*n);
    Xsec_Paint_MaterialDiffuseLCD->display((double)0.01*n);
    if(myQT->sliderRenderTracking) myQT->render(false);
    
}


void iQT_Xsec::updateXsec_Paint_MaterialSpecularSlider( int n )
{
	
    if(Xsec_Paint_MaterialLockAll->isChecked())
	{
		int i;
		for(i=0; i<=iVTKWindow::getCurrentWindow()->getXsectionFamily()->getMaxMemberIndex(); i++) iVTKWindow::getCurrentWindow()->getXsectionFamily()->getMember(i)->setSpecular(0.01*n);
    } 
	else CURRENT_XSECTION->setSpecular(0.01*n);
    Xsec_Paint_MaterialSpecularLCD->display((double)0.01*n);
    if(myQT->sliderRenderTracking) myQT->render(false);
    
}


void iQT_Xsec::updateXsec_Paint_MaterialSpecularPower( int n )
{
    
    if(Xsec_Paint_MaterialLockAll->isChecked())
	{
		int i;
		for(i=0; i<=iVTKWindow::getCurrentWindow()->getXsectionFamily()->getMaxMemberIndex(); i++) iVTKWindow::getCurrentWindow()->getXsectionFamily()->getMember(i)->setSpecularPower((float)n);
    } 
	else CURRENT_XSECTION->setSpecularPower((float)n);
    Xsec_Paint_MaterialSpecularPowerLCD->display((double)n);
    if(myQT->sliderRenderTracking) myQT->render(false);
    
}


void iQT_Xsec::updateXsec_Paint_MaterialShadingOff()
{
	
	myQT->startTask();
    if(Xsec_Paint_MaterialLockAll->isChecked())
	{
		int i;
		for(i=0; i<=iVTKWindow::getCurrentWindow()->getXsectionFamily()->getMaxMemberIndex(); i++) 
		{
			iXsection *s = iVTKWindow::getCurrentWindow()->getXsectionFamily()->getMember(i);
			s->setSpecularPower(0.0);
			s->setSpecular(0.0);
			s->setDiffuse(0.0);
			s->setAmbient(1.0);
		}
    } 
	else 
	{
		CURRENT_XSECTION->setSpecularPower(0.0);
		CURRENT_XSECTION->setSpecular(0.0);
		CURRENT_XSECTION->setDiffuse(0.0);
		CURRENT_XSECTION->setAmbient(1.0);
    }
    Xsec_Paint_MaterialSpecularPowerLCD->display(0.0);
    Xsec_Paint_MaterialSpecularLCD->display(0.0);
    Xsec_Paint_MaterialDiffuseLCD->display(0.0);
    Xsec_Paint_MaterialAmbientLCD->display(1.0);
    myQT->render(true);
	myQT->endTask();
    
}


void iQT_Xsec::launchPaletteEditor()
{
	
	myQT->launchPaletteEditor(Xsec_Field_PaletteList->currentItem());
	
}


void iQT_Xsec::updateTabPageChanged(QWidget *)
{
	myQT->updateDataChannelComboBox(DISPLAYPAGE_XSEC);
}


void iQT_Xsec::updateXsec_Field_ScanBoxPushButton()
{
	double cp = CURRENT_XSECTION->getPos();

    double f = -1.0;
    bool r, q = myQT->reportMemory;
	float t1, t = 0.0, tf = Xsec_Field_ScanBoxTimeSpinBox->value();

	myQT->startTask();
	myQT->reportMemory = false;

	while(!(r=CURRENT_XSECTION->setPos(f)) && t<tf)
	{
	    Xsec_Field_PosLCD->display(iVTKWindow::getCurrentWindow()->transformToExternalCoordinate(f));
		myQT->render(false);
		t1 = iVTKWindow::getCurrentWindow()->getRenderer()->GetLastRenderTimeInSeconds();
		t += t1;
		f += 2.0/tf*t1;
		if(Xsec_Field_PosResample->isChecked())
		{
			int estimatedResampleFactor = round(CURRENT_XSECTION->getSlicer()->GetResampleFactor()*myQT->TabWidgetView->View_DesiredFrameRateSlider->value()*t1);
			if(estimatedResampleFactor < 1) estimatedResampleFactor = 1;
			CURRENT_XSECTION->getSlicer()->SetResampleFactor(estimatedResampleFactor);
		}
	}

	CURRENT_XSECTION->setPos(cp);
	CURRENT_XSECTION->getSlicer()->SetResampleFactor(1);
    Xsec_Field_PosLCD->display(iVTKWindow::getCurrentWindow()->transformToExternalCoordinate(cp));
	myQT->render(false);
	myQT->reportMemory = q;
	myQT->endTask();
    
}


void iQT_Xsec::updateXsec_Field_ScanBoxTimeSpinBox(int d)
{
}

